/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.datacollect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.AppUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.imsc.dmw.common.pagemodel.DmwProjectdetail;
import kd.imsc.dmw.engine.multiimport.helper.MultiImpTaskHelper;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DateUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.FileUtils;
import kd.imsc.dmw.utils.StringUtil;

public class ProjectAllBaseUtil {
    private static final Log logger = LogFactory.getLog(ProjectAllBaseUtil.class);

    private ProjectAllBaseUtil() {
    }

    public static DynamicObjectCollection queryJoinImportResultList(List<DynamicObject> dynObjList) {
        Set pkIdSet = dynObjList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("projectid", "in", pkIdSet);
        qFilter.and(new QFilter(DmwProjectdetail.EF_reportorgid2_Q, ">", (Object)0L));
        String selectors = String.join((CharSequence)",", "id", "entryseq", "dataobjid", "datatemplateid", "impscheme");
        return QueryServiceHelper.query((String)"dmw_projectdetail", (String)selectors, (QFilter[])qFilter.toArray(), (String)"entryseq");
    }

    public static Map<Long, Boolean> getJoinImportResult(DynamicObject dynObj, List<Long> detailPkIdList) {
        ArrayList<DynamicObject> dynObjList = new ArrayList<DynamicObject>(1);
        dynObjList.add(dynObj);
        DynamicObjectCollection dynObjColl = ProjectAllBaseUtil.queryJoinImportResultList(dynObjList);
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(detailPkIdList.size());
        for (Long detailPkId : detailPkIdList) {
            long size;
            boolean flag = false;
            if (!CommonUtils.isNull(dynObjColl) && (size = dynObjColl.stream().filter(o -> detailPkId.longValue() == o.getLong("id")).count()) > 0L) {
                flag = true;
            }
            map.put(detailPkId, flag);
        }
        return map;
    }

    public static Map<Long, Map<String, String>> getEntryResultMsg(long projectId) {
        QFilter qFilter = new QFilter("projectid", "=", (Object)projectId);
        String selectors = String.join((CharSequence)",", "reportstatus", "datastatus");
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"dmw_projectdetail", (String)selectors, (QFilter[])qFilter.toArray());
        if (CommonUtils.isNull(dynObjs)) {
            return new HashMap<Long, Map<String, String>>(0);
        }
        String msg = ResManager.loadKDString((String)"\u63d0\u62a5\u5b8c\u6210\uff08%1$s/%2$s\uff09", (String)"ProjectAllBaseUtil_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        String msg2 = ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff08%1$s/%2$s\uff09", (String)"ProjectAllBaseUtil_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        long finishCount = 0L;
        long allCount = 0L;
        long importSucessCount = 0L;
        long importCount = 0L;
        HashMap<Long, Map<String, String>> resultMsgMap = new HashMap<Long, Map<String, String>>(2);
        for (DynamicObject dynObj : dynObjs) {
            DynamicObjectCollection collectEntryColl = dynObj.getDynamicObjectCollection("collectresultentry");
            finishCount = collectEntryColl.stream().filter(o -> "2".equals(o.getString("reportstatus"))).count();
            allCount = collectEntryColl.stream().filter(o -> !"3".equals(o.getString("reportstatus"))).count();
            DynamicObjectCollection importEntryColl = dynObj.getDynamicObjectCollection("importresultentry");
            importSucessCount = importEntryColl.stream().filter(o -> "5".equals(o.getString("datastatus"))).count();
            importCount = importEntryColl.stream().filter(o -> !"1".equals(o.getString("datastatus")) && !"6".equals(o.getString("datastatus"))).count();
            HashMap<String, String> msgMap = new HashMap<String, String>(2);
            msgMap.put("collectresult", String.format(msg, finishCount, allCount));
            msgMap.put("importresult", String.format(msg2, importSucessCount, importCount));
            resultMsgMap.put(dynObj.getLong("id"), msgMap);
        }
        return resultMsgMap;
    }

    public static String getCollectResultMsg(long detailId) {
        QFilter qFilter = new QFilter("id", "=", (Object)detailId);
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"dmw_projectdetail", (String)"reportstatus", (QFilter[])qFilter.toArray());
        if (CommonUtils.isNull(dynObjs)) {
            return "";
        }
        String msg = ResManager.loadKDString((String)"\u63d0\u62a5\u5b8c\u6210\uff08%1$s/%2$s\uff09", (String)"ProjectAllBaseUtil_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        long finishCount = 0L;
        long allCount = 0L;
        DynamicObject dynObj = dynObjs[0];
        DynamicObjectCollection collectEntryColl = dynObj.getDynamicObjectCollection("collectresultentry");
        finishCount = collectEntryColl.stream().filter(o -> "2".equals(o.getString("reportstatus"))).count();
        allCount = collectEntryColl.stream().filter(o -> !"3".equals(o.getString("reportstatus"))).count();
        return String.format(msg, finishCount, allCount);
    }

    public static void downloadImportTemplate(IFormView formView, String formId, long templateId, int rowIndex) throws IOException {
        if (StringUtil.isEmpty(formId)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6536\u96c6\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u6536\u96c6\u5bf9\u8c61\u540e\u518d\u4e0b\u8f7d\u3002", (String)"ProjectAllBaseUtil_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        DynamicObject templateData = null;
        String ctxPath = RequestContext.get().getClientFullContextPath();
        Map templateDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{templateId}, (String)"bos_importtemplate");
        templateData = (DynamicObject)templateDynamicObjectMap.get(templateId);
        String fileName = ProjectAllBaseUtil.getFileName(formId, DynamicObjectUtils.getString((DynamicObject)templateData, (String)"name"), rowIndex);
        formView.download(ctxPath + (ctxPath.endsWith("/") ? "" : "/") + "form/export.do?templateid=" + templateId + "&formid=" + formId + "&plugin=&filename=" + URLEncoder.encode(fileName + ".xlsx", "UTF-8") + "&extenddata=null&routeappid=" + "id" + "&a=templateId");
        formView.sendFormAction(formView);
    }

    public static void downloadImportTemplateByScheme(IFormView formView, long impSchemeId, int rowIndex) {
        Map taskTplMap;
        if (impSchemeId == 0L) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6536\u96c6\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u6536\u96c6\u5bf9\u8c61\u540e\u518d\u4e0b\u8f7d\u3002", (String)"ProjectAllBaseUtil_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        List attachments = AttachmentServiceHelper.getAttachments((String)"dmw_impscheme", (Object)impSchemeId, (String)"attachmentpanelap", (boolean)true);
        Map map = taskTplMap = CommonUtils.isNull(attachments) ? new HashMap(0) : (Map)attachments.get(0);
        if (taskTplMap != null && !taskTplMap.isEmpty()) {
            Object tplUrl = taskTplMap.get("url");
            if (StringUtil.isEmpty(tplUrl)) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6536\u96c6\u5bf9\u8c61\u672a\u914d\u7f6e\u6a21\u677f\uff0c\u8bf7\u5230\u6536\u96c6\u5bf9\u8c61\u4e2d\u7ef4\u62a4\u3002", (String)"ProjectAllBaseUtil_12", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            String templatePath = FileUtils.generateLocalPath();
            File tempFile = FileUtils.checkAndCreateDir((String)templatePath);
            OutputStream outputStream = null;
            FileInputStream inputStream = null;
            try {
                String fileName = rowIndex + "-" + taskTplMap.get("name");
                String path = (String)taskTplMap.get("url");
                String fileUrlPath = templatePath + File.separator + fileName;
                outputStream = new FileOutputStream(fileUrlPath);
                String attachmentRelativePath = MultiImpAttachmentHelper.getAttachmentRelativePath((String)path);
                FileServiceFactory.getAttachmentFileService().download(attachmentRelativePath, outputStream, "imsc-dmw");
                inputStream = new FileInputStream(fileUrlPath);
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inputStream, 2);
                formView.download(urls);
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
            finally {
                if (tempFile.exists()) {
                    AppUtils.deleteKd((File)tempFile);
                }
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    public static void doDownloadFileConfirm(IFormView view, String className, String callBackId) {
        String msg = ResManager.loadKDString((String)"\u662f\u5426\u4e0b\u8f7d\u6587\u4ef6\uff1f", (String)"ProjectAllBaseUtil_10", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        ConfirmTypes confirmTypes = ConfirmTypes.Default;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(callBackId, className);
        view.showConfirm(msg, options, confirmTypes, callBack);
    }

    public static String getFileName(String formId, String templateName, int rowIndex) {
        String fileName = ResManager.loadKDString((String)"%s-\u6570\u636e\u6a21\u677f", (String)"ProjectAllBaseUtil_2", (String)"imsc-dmw-platform", (Object[])new Object[]{rowIndex});
        if (StringUtils.isNotEmpty((CharSequence)templateName)) {
            fileName = fileName + templateName;
        } else {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)formId);
            fileName = fileName + mainEntityType.getDisplayName();
        }
        return fileName;
    }

    public static boolean sendTaskUrgingMessage(long projectDetailId, List<Long> receiveUserIdList, String datadescription, Date endDatetime) {
        StringBuilder msgContent = new StringBuilder();
        msgContent.append(ResManager.loadKDString((String)"\u60a8\u6709\u4e00\u4e2a\u6570\u636e\u6536\u96c6\u63d0\u62a5\u4efb\u52a1\u5df2\u4e0b\u53d1", (String)"ProjectAllBaseUtil_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        if (StringUtil.isNotEmpty(datadescription)) {
            msgContent.append(',').append(String.format(ResManager.loadKDString((String)"\u6536\u96c6\u8bf4\u660e\uff1a%s", (String)"ProjectAllBaseUtil_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), datadescription));
        }
        if (endDatetime != null) {
            msgContent.append(',').append(String.format(ResManager.loadKDString((String)"\u6536\u96c6\u622a\u6b62\u65f6\u95f4\uff1a%s", (String)"ProjectAllBaseUtil_5", (String)"imsc-dmw-platform", (Object[])new Object[0]), DateUtils.format((Date)endDatetime, (String)"yyyy-MM-dd HH:mm:ss")));
        }
        msgContent.append(',').append(ResManager.loadKDString((String)"\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"ProjectAllBaseUtil_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        MessageInfo waitingMessage = ProjectAllBaseUtil.buildMessage(projectDetailId, msgContent.toString(), receiveUserIdList);
        long sendMsgId = MessageCenterServiceHelper.sendMessage((MessageInfo)waitingMessage);
        return sendMsgId > 0L;
    }

    private static MessageInfo buildMessage(long projectDetailId, String msgContent, List<Long> receiveUserIdList) {
        MessageInfo message = new MessageInfo();
        message.setTitle(ResManager.loadKDString((String)"\u6570\u636e\u63d0\u62a5\u63d0\u9192", (String)"ProjectAllBaseUtil_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        message.setContent(msgContent);
        LocaleString tag = new LocaleString();
        message.setMessageTag((ILocaleString)tag);
        message.setTag(ResManager.loadKDString((String)"\u7d27\u6025", (String)"ProjectAllBaseUtil_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        message.setUserIds(receiveUserIdList);
        message.setType("warning");
        message.setEntityNumber("dmw_data_reporting");
        message.setOperation("modify");
        message.setBizDataId(Long.valueOf(projectDetailId));
        message.setPubaccNumber("flowassist");
        String clientUrl = UrlService.getDomainContextUrl();
        String contentUrl = clientUrl + String.format("/index.html?formId=%1$s&type=base&pkId=%2$s&caption=%3$s", "dmw_data_reporting", projectDetailId, ResManager.loadKDString((String)"\u6570\u636e\u63d0\u62a5", (String)"ProjectAllBaseUtil_9", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        message.setContentUrl(contentUrl);
        message.setNotifyType(MessageChannels.MC.getNumber());
        return message;
    }

    public static DynamicObjectCollection queryProjectDetailColl(List<Long> collectEntryIdList) {
        QFilter qFilter = new QFilter(DmwProjectdetail.E_collectresultentry_id, "in", collectEntryIdList);
        StringBuilder useRangeSQL = new StringBuilder();
        useRangeSQL.append(" SELECT FREPORTORGID FROM ").append("T_DMW_COLLECTRESULTENTRY").append(" WHERE FENTRYID IN (").append(StringUtil.join(collectEntryIdList.toArray(), ",")).append(')');
        QFilter orgFilter = QFilter.sqlExpress((String)DmwProjectdetail.EF_reportorgid2_Q, (String)"in", (String)useRangeSQL.toString());
        qFilter.and(orgFilter);
        String selectors = String.join((CharSequence)",", DmwProjectdetail.E_collectresultentry_id, DmwProjectdetail.EF_datastatus_Q);
        return QueryServiceHelper.query((String)"dmw_projectdetail", (String)selectors, (QFilter[])qFilter.toArray());
    }

    public static void setDataStatusToImporting(long entryId, long collectId) {
        String updateSql = "UPDATE T_DMW_IMPORTRESULTENTRY SET FDATASTATUS=?,FIMPORTORID=?,FIMPORTDATE=? WHERE FMENTRYID=? AND FENTRYID=?;";
        ArrayList<Object> list = new ArrayList<Object>(5);
        list.add("3");
        list.add(UserServiceHelper.getCurrentUserId());
        list.add(KDDateUtils.now());
        list.add(collectId);
        list.add(entryId);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1);
        paramsList.add(list.toArray());
        DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)updateSql, paramsList);
    }

    private static String getErrorMsgByTaskId(long taskId) {
        if (taskId == 0L) {
            return "";
        }
        StringBuilder errorInfo = new StringBuilder();
        DynamicObject taskDynObj = MultiImpTaskHelper.getTaskById(taskId);
        if (taskDynObj != null) {
            DynamicObjectCollection entryColl = taskDynObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDynObj : entryColl) {
                String errorMsg = entryDynObj.getString("failreason");
                if (!StringUtil.isNotEmpty(errorMsg)) continue;
                if (errorInfo.length() > 0) {
                    errorInfo.append('\n');
                }
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u5bfc\u5165\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%2$s", (String)"ProjectAllBaseUtil_13", (String)"imsc-dmw-platform", (Object[])new Object[0]), DynamicObjectUtils.getString((DynamicObject)entryDynObj.getDynamicObject("billentity"), (String)"name"), errorMsg);
                errorInfo.append(msg);
            }
        }
        return errorInfo.toString();
    }

    private static String getErrorMsgByLogDynObj(DynamicObject logDynObj) {
        StringBuilder errorInfo = new StringBuilder();
        long logId = logDynObj.getLong("id");
        String data = logDynObj.getString("data");
        if (!StringUtils.isEmpty((CharSequence)data)) {
            JSONObject info = JSON.parseObject((String)data).getJSONObject("info");
            for (Object value : info.values()) {
                ImportLogger importLogger = (ImportLogger)SerializationUtils.fromJsonString((String)value.toString(), ImportLogger.class);
                if (errorInfo.length() > 0) {
                    errorInfo.append('\n');
                }
                errorInfo.append(importLogger);
            }
        } else {
            String msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u65e5\u5fd7\u4e2d\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8bf7\u5230\u5355\u636e\u5217\u8868\u754c\u9762\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u8fdb\u884c\u786e\u8ba4\uff0c\u5bfc\u5165\u65e5\u5fd7id\uff1a%s", (String)"ProjectAllBaseUtil_14", (String)"imsc-dmw-platform", (Object[])new Object[0]), logId);
            if (errorInfo.length() > 0) {
                errorInfo.append('\n');
            }
            errorInfo.append(msg);
        }
        return errorInfo.toString();
    }

    public static void updateDataCollectStatusByScheme(long entryId, long taskReportId, long taskId, String exeStatus) {
        String errorInfo = ProjectAllBaseUtil.getErrorMsgByTaskId(taskId);
        String dataStatus = "4";
        if ("C".equals(exeStatus)) {
            dataStatus = "5";
        }
        ProjectAllBaseUtil.updateCollectDataEntry(entryId, taskReportId, errorInfo, "", dataStatus);
    }

    public static void updateDataCollectStatusByStandard(long entryId, long logId, StringBuilder errorInfo) {
        DynamicObject logDynObj = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"id,importstatus,data,total,failed", (QFilter[])new QFilter("id", "=", (Object)logId).toArray());
        boolean isSuccess = true;
        String errFile = " ";
        if (logDynObj == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u65e5\u5fd7\u672a\u6210\u529f\u67e5\u8be2\u5230\uff0c\u8bf7\u5230\u5355\u636e\u5217\u8868\u754c\u9762\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u8fdb\u884c\u786e\u8ba4\uff0c\u5bfc\u5165\u65e5\u5fd7id\uff1a%s", (String)"ProjectAllBaseUtil_15", (String)"imsc-dmw-platform", (Object[])new Object[0]), logId);
            errorInfo.append(msg);
            isSuccess = false;
        } else {
            errorInfo.append(ProjectAllBaseUtil.getErrorMsgByLogDynObj(logDynObj));
            String data = logDynObj.getString("data");
            if (!StringUtils.isEmpty((CharSequence)data)) {
                JSONObject info = JSON.parseObject((String)data).getJSONObject("info");
                for (Object value : info.values()) {
                    ImportLogger importLogger = (ImportLogger)SerializationUtils.fromJsonString((String)value.toString(), ImportLogger.class);
                    String string = errFile = importLogger.getErrFile() == null ? " " : importLogger.getErrFile();
                    if (importLogger.getFailed() <= 0 && importLogger.getTotal() > 0) continue;
                    isSuccess = false;
                }
            }
        }
        String dataStatus = "4";
        if (isSuccess) {
            dataStatus = "5";
        }
        ProjectAllBaseUtil.updateCollectDataEntry(entryId, logId, errorInfo.toString(), errFile, dataStatus);
    }

    private static void updateCollectDataEntry(long entryId, long logId, String errorInfo, String errFile, String dataStatus) {
        String updateSql = "UPDATE T_DMW_IMPORTRESULTENTRY SET FDATASTATUS=?,FERRORMSG=?,FERRORFILE=?,FLOGID=? WHERE FENTRYID=?";
        ArrayList<Object> list = new ArrayList<Object>(6);
        list.add(dataStatus);
        String errorMsg = errorInfo.length() > 2000 ? errorInfo.substring(0, 2000) : errorInfo;
        list.add(errorMsg);
        list.add(errFile);
        list.add(logId);
        list.add(entryId);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(1);
        paramsList.add(list.toArray());
        DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)updateSql, paramsList);
    }
}

