/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.datacollect.upload;

import java.io.InputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imsc.dmw.engine.multiimport.model.BizOperationResult;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;
import kd.imsc.dmw.plugin.formplugin.datacollect.upload.ExcelDataChecker;
import kd.imsc.dmw.plugin.formplugin.datacollect.upload.UploadUtil;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.FileUtils;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class CollectDataUploadForm
extends ImbdDymicTplEditPlugin
implements UploadListener,
BeforeF7SelectListener {
    private static final String ATTACHMENT_PANEL_AP = "attachmentpanelap";
    private static final String SCHEMEATTACHMENT_PANEL_AP = "schemeattachmentpanelap";
    private static final String ORG_FIELD = "orgfield";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String parentFormId = e.getFormShowParameter().getParentFormId();
        if (kd.bos.util.StringUtils.isEmpty((String)parentFormId)) {
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL_AP);
        attachmentPanel.addUploadListener((UploadListener)this);
        AttachmentPanel schemeAttachmentPanel = (AttachmentPanel)this.getControl(SCHEMEATTACHMENT_PANEL_AP);
        schemeAttachmentPanel.addUploadListener((UploadListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl(ORG_FIELD);
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String f7FiledKey = evt.getProperty().getName();
        if (ORG_FIELD.equals(f7FiledKey)) {
            List filterOrgIdList = (List)this.getView().getFormShowParameter().getCustomParam("filterOrgIdList");
            if (filterOrgIdList == null || filterOrgIdList.isEmpty()) {
                return;
            }
            QFilter idQfilter = new QFilter("id", "in", (Object)filterOrgIdList);
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(idQfilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object reportOrgId = this.getView().getFormShowParameter().getCustomParam("reportorgid");
        if (Objects.nonNull(reportOrgId)) {
            this.getModel().setValue(ORG_FIELD, reportOrgId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String opKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "upload".equals(opKey = (operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            this.validParam(args);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean flag = this.isImpSchemeType();
        this.getView().setVisible(Boolean.valueOf(!flag), new String[]{ATTACHMENT_PANEL_AP});
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{SCHEMEATTACHMENT_PANEL_AP});
        boolean isEnable = !"dmw_data_reporting".equals(this.getView().getFormShowParameter().getParentFormId());
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{ORG_FIELD});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        boolean isSuccess;
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        boolean bl = isSuccess = e.getOperationResult() != null && e.getOperationResult().isSuccess();
        if (isSuccess && "upload".equals(key)) {
            this.addImportResultEntry();
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String name;
            boolean fileUpload;
            Map fileInfo = (Map)urls[0];
            String url = (String)fileInfo.get("url");
            if (this.isImpSchemeType()) {
                long schemeId = CommonUtils.getLongCustomParamValue(this.getView(), "impscheme");
                DynamicObject schemeDynObj = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"dmw_impscheme");
                String modelInfo = DynamicObjectUtils.getString((DynamicObject)schemeDynObj, (String)"modelinfo_tag");
                BizOperationResult checkResult = MultiImpAttachmentHelper.validateFileBySchemeTpl((String)url, (String)modelInfo);
                if (!checkResult.getSuccess() && StringUtils.isNotEmpty((CharSequence)checkResult.getErrorDesc())) {
                    evt.setCancel(true);
                    evt.setCancelMsg(checkResult.getErrorDesc());
                    return;
                }
            } else if (this.verifyExcelByStandard(evt, url)) {
                return;
            }
            if (fileUpload = this.fileHasUpload(name = (String)fileInfo.get("name"))) {
                this.showFileHasUploadConfirm();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String key = e.getCallBackId();
        if ("fileExistConfirm".equals(key) && e.getResult() == MessageBoxResult.Cancel) {
            AttachmentPanel attachmentPanel = this.getAttachmentPanel();
            List attachmentData = attachmentPanel.getAttachmentData();
            attachmentPanel.remove((Map)attachmentData.get(0));
        }
    }

    private boolean verifyExcelByStandard(UploadEvent evt, String url) {
        TempFileCacheDownloadable.Content content = FileUtils.getCacheContentFromTempUrl((String)url);
        try (InputStream in = content.getInputStream();){
            ExcelDataChecker excelDataChecker = new ExcelDataChecker(this.getView(), in);
            excelDataChecker.doCheck();
            if (!excelDataChecker.isRightEntity()) {
                evt.setCancel(true);
                evt.setCancelMsg(ExcelDataChecker.getExcelFormatErrorTips());
            } else if (!excelDataChecker.hasDataRow()) {
                String error = ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\uff0c\u8bf7\u5f55\u5165\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"CollectDataUploadForm_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                evt.setCancel(true);
                evt.setCancelMsg(error);
            }
            HashMap tipsInfo = new HashMap(2);
            if (!excelDataChecker.validSensitiveFields(tipsInfo)) {
                evt.setCancel(true);
                evt.setCancelMsg(tipsInfo.getOrDefault("title", "") + tipsInfo.getOrDefault("content", ""));
            }
        }
        catch (Exception e) {
            evt.setCancel(true);
            evt.setCancelMsg(e.getMessage());
            this.getView().showErrorNotification(ExcelDataChecker.getExcelFormatErrorTips());
        }
        return evt.isCancel();
    }

    private void addImportResultEntry() {
        long reportOrgId = (Long)this.getModel().getValue("orgfield_id");
        DynamicObject projectDetail = this.getProjectDetail();
        if (projectDetail == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6536\u96c6\u6570\u636e\u5904\u7406\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"CollectDataUploadForm_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        AttachmentPanel attachmentPanel = this.getAttachmentPanel();
        List list = attachmentPanel.getAttachmentData();
        Map file = (Map)list.get(0);
        String url = (String)file.get("url");
        List attchmentFileList = FileUtils.uploadFileByTempUrl((String)"dmw_projectdetail", (Object)projectDetail.getPkValue(), (String)"file", (String)url, (String)"dmw_rpt");
        DynamicObjectCollection importResultEntry = projectDetail.getDynamicObjectCollection("importresultentry");
        DynamicObject importResultDy = new DynamicObject(importResultEntry.getDynamicObjectType());
        importResultDy.set("reportorgid2", (Object)reportOrgId);
        MulBasedataDynamicObjectCollection fileList = CommonUtils.createAttachmentField(importResultDy.getDynamicObjectCollection("file").getDynamicObjectType(), ((DynamicObject)attchmentFileList.get(0)).getLong("id"));
        importResultDy.set("file", (Object)fileList);
        importResultDy.set("filename", file.get("name"));
        importResultDy.set("datastatus", (Object)"1");
        importResultDy.set("reportdate", (Object)System.currentTimeMillis());
        importResultDy.set("reportorid2", (Object)UserServiceHelper.getCurrentUserId());
        importResultDy.set("seq", (Object)(importResultEntry.size() + 1));
        importResultEntry.add((Object)importResultDy);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"dmw_projectdetail", (DynamicObject[])new DynamicObject[]{projectDetail}, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            StringBuilder errorInfo = new StringBuilder();
            operationResult.getAllErrorOrValidateInfo().forEach(p -> errorInfo.append(p.getMessage()).append('\n'));
            this.getView().showErrorNotification(errorInfo.toString());
            return;
        }
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        parentView.showSuccessNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u6210\u529f", (String)"CollectDataUploadForm_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private DynamicObject getProjectDetail() {
        long collectId = CommonUtils.getLongCustomParamValue(this.getView(), "collectId");
        return BusinessDataServiceHelper.loadSingle((Object)collectId, (String)"dmw_projectdetail");
    }

    private int getFileNameCount(long collectId, String fileName) {
        Object[] param = new Object[]{new SqlParameter(":fmentryid", -5, (Object)collectId), new SqlParameter(":ffilename", 12, (Object)fileName), new SqlParameter(":fdatastatus", 12, (Object)"6")};
        return (Integer)DB.query((DBRoute)DBRoute.of((String)"imsc"), (String)"select count(1) from t_dmw_importresultentry where fmentryid=? and ffilename=? and fdatastatus !=?", (Object[])param, rs -> {
            rs.next();
            return rs.getInt(1);
        });
    }

    private boolean fileHasUpload(String fileName) {
        long collectId = CommonUtils.getLongCustomParamValue(this.getView(), "collectId");
        int fileNameCount = this.getFileNameCount(collectId, fileName);
        return fileNameCount > 0;
    }

    private void showFileHasUploadConfirm() {
        String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u6587\u4ef6\u540d\u6587\u4ef6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u62a5\uff1f", (String)"CollectDataUploadForm_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        ConfirmTypes confirmTypes = ConfirmTypes.Default;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener("fileExistConfirm", (IFormPlugin)this);
        this.getView().showConfirm(msg, options, confirmTypes, callBack);
    }

    private void validParam(BeforeDoOperationEventArgs args) {
        AttachmentPanel attachmentPanel = this.getAttachmentPanel();
        List attachmentData = attachmentPanel.getAttachmentData();
        if (attachmentData == null || attachmentData.isEmpty()) {
            args.setCancel(true);
            String tips = ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6", (String)"CollectDataUploadForm_3", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            args.setCancelMessage(tips);
            return;
        }
        long collectId = CommonUtils.getLongCustomParamValue(this.getView(), "collectId");
        long reportOrgId = (Long)this.getModel().getValue("orgfield_id");
        boolean canUpload = UploadUtil.checkCanUpload((IFormView)this.getView(), (long)collectId, (long)reportOrgId);
        if (!canUpload) {
            args.setCancel(true);
        }
    }

    private AttachmentPanel getAttachmentPanel() {
        return (AttachmentPanel)this.getControl(this.isImpSchemeType() ? SCHEMEATTACHMENT_PANEL_AP : ATTACHMENT_PANEL_AP);
    }

    private boolean isImpSchemeType() {
        String dataType = CommonUtils.getStringCustomParamValue(this.getView(), "datatype");
        return "2".equals(dataType);
    }
}

