/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.helper.ScheduleHelper;
import kd.imsc.dmw.helper.tpl.MigrateCheckItemHelper;
import kd.imsc.dmw.plugin.formplugin.schedule.task.CheckItemRepairTask;
import kd.imsc.dmw.plugin.formplugin.schedule.task.CheckItemValidateTask;
import kd.imsc.dmw.plugin.formplugin.schedule.taskclick.CheckItemValidateTaskClick;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.FormUtil;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.imbd.formplugin.AbstractImbdDymicPlugin;

public class CheckTestDlgEditPlugin
extends AbstractImbdDymicPlugin
implements ProgresssListener,
ItemClickListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(CheckTestDlgEditPlugin.class);
    private static final String DO_REPAIR_CALLBACK = "dorepaircallback";
    private static final String TO_BACKGROUND_CONFIRM = "tobackgroundconfirm";
    private List<Map<String, Object>> pageParams;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String parentFormId = e.getFormShowParameter().getParentFormId();
        if (StringUtils.isEmpty((String)parentFormId)) {
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btnok", "dorepair", "tobackground", "handfix", "community"});
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
        FormUtil.addF7Listener(this, "datasource");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap", "fixresult", "dorepair", "checkrepair"});
        List<Map<String, Object>> maps = this.getPageParams();
        Map defaultRepair = new HashMap(8);
        if (!CommonUtils.isNull(maps)) {
            defaultRepair = maps.stream().filter(n -> (Boolean)n.get("isdefaultrepair")).findFirst().orElseGet(() -> (Map)maps.get(0));
        }
        String url = (String)defaultRepair.get("repairpage");
        String community = (String)defaultRepair.get("community");
        String repairType = (String)defaultRepair.get("checkrepairtype");
        boolean isShow = StringUtils.isNotEmpty((String)url) || "B".equalsIgnoreCase(repairType);
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"handfix"});
        this.getView().setVisible(Boolean.valueOf(StringUtils.isNotEmpty((String)community)), new String[]{"community"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"tobackground"});
        this.initProgress();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List<Map<String, Object>> maps = this.getPageParams();
        Map<String, Object> map = maps.stream().filter(n -> (Boolean)n.get("isdefaultrepair")).findFirst().orElseGet(HashMap::new);
        if (map.isEmpty() && !maps.isEmpty()) {
            map = maps.get(0);
        }
        String repairType = (String)map.get("checkrepairtype");
        this.getModel().setValue("repairtype", (Object)repairType);
        this.getModel().setValue("repairillust", map.get("entryid"));
        this.getModel().setValue("handfixurl", map.get("repairpage"));
        this.getModel().setValue("communityurl", map.get("community"));
        this.setRepairTypeCombo(maps);
        this.setRepairIllustCombo(repairType, maps);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String taskId = (String)customParams.get("taskid");
        this.getModel().setValue("datasource", customParams.get("datasource"));
        this.taskIdSetValue(maps, customParams, taskId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("repairtype".equals(name)) {
            this.repairTypeChanged();
        } else if ("repairillust".equals(name)) {
            this.repairLogicChanged();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.doCheckService();
                break;
            }
            case "dorepair": {
                String msg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c\u524d\u5efa\u8bae\u5bf9\u6570\u636e\u8fdb\u884c\u5907\u4efd,%1$s\u56e0\u6267\u884c\u64cd\u4f5c\u5f71\u54cd\u7cfb\u7edf\u73b0\u6709\u6570\u636e\uff0c\u4e14\u64cd\u4f5c\u65e0\u6cd5\u56de\u9000\uff0c%2$s\u662f\u5426\u7ee7\u7eed\u6267\u884c\u64cd\u4f5c\uff1f", (String)"CheckTestDlgEditPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), "\r\n", "\r\n");
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DO_REPAIR_CALLBACK));
                break;
            }
            case "tobackground": {
                this.checkToBackgroundConfirm((IFormPlugin)this);
                break;
            }
            case "handfix": {
                this.handFixClick();
                break;
            }
            case "community": {
                this.communityClick();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (DO_REPAIR_CALLBACK.equals(callBackId)) {
            this.doRepairService(event);
        } else if (TO_BACKGROUND_CONFIRM.equals(callBackId)) {
            this.tobackGroundService(event);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("datasource".equals(name)) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if ("C".equals(CommonUtils.getStringCustomParamValue(this.getView(), "callmethod"))) {
                DynamicObject[] flows = BusinessDataServiceHelper.load((String)"isc_service_flow", (String)"res_category,res_ref", (QFilter[])new QFilter("id", "=", (Object)CommonUtils.getLongCustomParamValue(this.getView(), "serviceflowid")).toArray());
                ArrayList<Long> dataSourceIdList = new ArrayList<Long>(2);
                for (DynamicObject flow : flows) {
                    DynamicObjectCollection resourceDynObjs = flow.getDynamicObjectCollection("resources");
                    for (DynamicObject resourceDynObj : resourceDynObjs) {
                        if (!"isc_data_source".equals(resourceDynObj.getString("res_category"))) continue;
                        long dataSourceId = DynamicObjectUtils.getPkValue((DynamicObject)resourceDynObj, (String)"res_ref");
                        dataSourceIdList.add(dataSourceId);
                    }
                }
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", dataSourceIdList));
            } else {
                String checkitemFormId = CommonUtils.getStringCustomParamValue(this.getView(), "checkitemFormId");
                ArrayList<String> linkIdList = new ArrayList<String>(2);
                if ("dmw_migratecheckitem_ecc".equals(checkitemFormId)) {
                    linkIdList.add("0Z=EDQWTK34Y");
                    linkIdList.add("381V34W0TMWR");
                } else if ("dmw_migratecheckitem_nc".equals(checkitemFormId)) {
                    linkIdList.add("0COI9MP6A9=I");
                    linkIdList.add("0COIGTUZ7LW1");
                    linkIdList.add("2NXJFJD56QJB");
                }
                if (!linkIdList.isEmpty()) {
                    formShowParameter.getListFilterParameter().setFilter(new QFilter("dblink.dum_link", "in", linkIdList));
                }
            }
        }
    }

    public void onProgress(ProgressEvent evt) {
        log.info("\u6267\u884conProgress\u65b9\u6cd5");
        String taskId = (String)this.getModel().getValue("taskid");
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        Object taskObj = ScheduleHelper.getTaskCustomData((TaskInfo)taskInfo).get("taskTypeObj");
        evt.setProgress(40);
        if ("checkbar".equals(taskObj)) {
            this.checkBarDeal(evt, taskInfo);
        } else if ("repairbar".equals(taskObj)) {
            this.repairBarDeal(evt, taskInfo);
        } else if (taskInfo.isFailure()) {
            this.barCompleteDeal(evt);
            String failureReason = taskInfo.getFailureReason();
            this.getView().showErrorNotification(failureReason);
        }
    }

    private void initProgress() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String taskId = (String)customParams.get("taskid");
        if (StringUtils.isNotEmpty((String)taskId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"tobackground"});
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.start();
        }
    }

    private void taskIdSetValue(List<Map<String, Object>> maps, Map<String, Object> customParams, String taskId) {
        if (StringUtils.isNotEmpty((String)taskId)) {
            List repairIds;
            this.getModel().setValue("taskid", (Object)taskId);
            TaskInfo checkTask = ScheduleServiceHelper.queryTask((String)taskId);
            Object taskObj = ScheduleHelper.getTaskCustomData((TaskInfo)checkTask).get("taskTypeObj");
            if ("repairbar".equals(taskObj)) {
                this.getModel().setValue("checkresult", customParams.get("checkresult"));
                String checkDetail = (String)customParams.get("checkdetail");
                this.getModel().setValue("checkdetail", (Object)StringUtil.subDataDeal(checkDetail, 50));
                this.getModel().setValue("checkdetail_tag", (Object)checkDetail);
            }
            if (CollectionUtils.isNotEmpty((Collection)(repairIds = (List)customParams.get("repairIds")))) {
                QFilter entryIdQfilter = new QFilter("entryentity.id", "in", (Object)repairIds);
                String checkitemFormId = CommonUtils.getStringCustomParamValue(this.getView(), "checkitemFormId");
                DynamicObject entry = QueryServiceHelper.queryOne((String)checkitemFormId, (String)"entryentity.checkrepairtype,entryentity.id", (QFilter[])entryIdQfilter.toArray());
                if (entry == null) {
                    return;
                }
                String repairTypeValue = (String)entry.get("entryentity.checkrepairtype");
                this.getModel().setValue("repairtype", (Object)repairTypeValue);
                this.getModel().setValue("repairillust", entry.get("entryentity.id"));
                this.setRepairIllustCombo(repairTypeValue, maps);
            }
        }
    }

    private void repairLogicChanged() {
        String value = (String)this.getModel().getValue("repairillust");
        if (StringUtils.isEmpty((String)value)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"community"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"handfix"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"dorepair"});
            return;
        }
        List<Map<String, Object>> maps = this.getPageParams();
        Map entryId = maps.stream().filter(n -> String.valueOf(n.get("entryid")).equals(value)).findFirst().orElseGet(HashMap::new);
        String repairType = (String)entryId.get("checkrepairtype");
        String page = (String)entryId.get("repairpage");
        boolean isShow = StringUtils.isNotEmpty((String)page) || "B".equalsIgnoreCase(repairType);
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"handfix"});
        this.getModel().setValue("handfixurl", (Object)page);
        String community = (String)entryId.get("community");
        this.getView().setVisible(Boolean.valueOf(StringUtils.isNotEmpty((String)community)), new String[]{"community"});
        this.getModel().setValue("communityurl", (Object)community);
        Boolean isRepair = (Boolean)entryId.get("issupportrepair");
        this.getView().setVisible(isRepair, new String[]{"dorepair"});
    }

    private void repairTypeChanged() {
        List<Map<String, Object>> maps = this.getPageParams();
        String repairType = (String)this.getModel().getValue("repairtype");
        this.getView().setVisible(Boolean.FALSE, new String[]{"community"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"handfix"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"dorepair"});
        this.setRepairIllustCombo(repairType, maps);
    }

    private void setRepairTypeCombo(List<Map<String, Object>> maps) {
        ArrayList<ComboItem> opItems = new ArrayList<ComboItem>(4);
        ComboEdit srcBillType = (ComboEdit)this.getView().getControl("repairtype");
        Set checkRepairTypes = maps.stream().map(n -> (String)n.get("checkrepairtype")).collect(Collectors.toSet());
        for (String repairType : checkRepairTypes) {
            String key = StringUtils.getEmpty();
            if ("A".equals(repairType)) {
                key = ResManager.loadKDString((String)"\u661f\u701a\u4e2d\u4fee\u590d", (String)"CheckTestDlgEditPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            } else if ("B".equals(repairType)) {
                key = ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u4e2d\u4fee\u590d", (String)"CheckTestDlgEditPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            }
            opItems.add(new ComboItem(new LocaleString(key), repairType));
        }
        srcBillType.setComboItems(opItems);
    }

    private void setRepairIllustCombo(String repairType, List<Map<String, Object>> maps) {
        ArrayList<ComboItem> opItems = new ArrayList<ComboItem>(8);
        ComboEdit srcBillType = (ComboEdit)this.getView().getControl("repairillust");
        if (StringUtils.isEmpty((String)repairType)) {
            srcBillType.setComboItems(opItems);
            return;
        }
        List checkRepairTypeList = maps.stream().filter(n -> repairType.equals(n.get("checkrepairtype"))).collect(Collectors.toList());
        for (Map repairMap : checkRepairTypeList) {
            String repairIllust = (String)repairMap.get("repairillust");
            String entryId = String.valueOf(repairMap.get("entryid"));
            opItems.add(new ComboItem(new LocaleString(repairIllust), entryId));
        }
        srcBillType.setComboItems(opItems);
        if (checkRepairTypeList.size() == 1) {
            this.getModel().setValue("repairillust", ((Map)checkRepairTypeList.get(0)).get("entryid"));
            this.getView().updateView("repairillust");
        }
    }

    private void communityClick() {
        String communityUrl = (String)this.getModel().getValue("communityurl");
        if (StringUtils.isNotEmpty((String)communityUrl)) {
            this.getView().openUrl(communityUrl);
        }
    }

    private void handFixClick() {
        String fixUrl = (String)this.getModel().getValue("handfixurl");
        String repairType = (String)this.getModel().getValue("repairtype");
        CheckItemLog checkItemLog = this.getCheckItemLog();
        if (checkItemLog == null) {
            return;
        }
        if ("B".equalsIgnoreCase(repairType)) {
            String checkitemFormId = CommonUtils.getStringCustomParamValue(this.getView(), "checkitemFormId");
            if (StringUtil.isEmpty(checkitemFormId)) {
                checkitemFormId = "dmw_migratecheckitem_eas";
            }
            MigrateCheckItemHelper.openHandFixPage(this.getView(), checkItemLog, this.getDbLinkId(), checkitemFormId);
        } else {
            if (StringUtil.isNull(fixUrl)) {
                return;
            }
            try {
                MetadataServiceHelper.getDataEntityType((String)fixUrl.toLowerCase());
            }
            catch (Exception e) {
                throw new DmwBizException(String.format(ResManager.loadKDString((String)"\u6253\u5f00\u624b\u5de5\u4fee\u590d\u9875\u9762\u5931\u8d25,\u539f\u56e0\u4e3a:%s", (String)"CheckTestDlgEditPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), e.getMessage()));
            }
            MigrateCheckItemHelper.openXhFixPage(this.getView(), fixUrl, checkItemLog);
        }
    }

    private CheckItemLog getCheckItemLog() {
        String taskId = (String)this.getModel().getValue("taskid");
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo != null && !taskInfo.isTaskEnd()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u5148\u7b49\u5f85\u6267\u884c\u5b8c\u6210\u3002", (String)"CheckTestDlgEditPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return null;
        }
        Map taskCustomData = ScheduleHelper.getTaskCustomData((TaskInfo)taskInfo);
        Object taskObj = taskCustomData.get("taskTypeObj");
        String result = "checkbar".equals(taskObj) ? (String)taskCustomData.get("checkResultResponse") : (String)this.getModel().getValue("checkdata_tag");
        if (StringUtils.isNotEmpty((String)result)) {
            return (CheckItemLog)JSONObject.parseObject((String)result, CheckItemLog.class);
        }
        return null;
    }

    private Long getDbLinkId() {
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource");
        DynamicObject dbLink = dataSource.getDynamicObject("dblink");
        return (Long)dbLink.getPkValue();
    }

    private void checkToBackgroundConfirm(IFormPlugin formPlugin) {
        String taskId = (String)this.getModel().getValue("taskid");
        TaskInfo checkTask = ScheduleServiceHelper.queryTask((String)taskId);
        if (checkTask.isTaskEnd()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ed3\u675f\uff0c\u65e0\u9700\u8f6c\u540e\u53f0", (String)"CheckTestDlgEditPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u628a\u5f53\u524d\u4efb\u52a1\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\u540e\uff0c\u53ef\u4ee5\u518d\u6b21\u901a\u8fc7\u53f3\u4e0b\u89d2\u7684\u540e\u53f0\u8fd0\u884c\u8fdb\u5ea6\u7403\u518d\u6b21\u6253\u5f00", (String)"CheckTestDlgEditPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(TO_BACKGROUND_CONFIRM, formPlugin));
    }

    private void tobackGroundService(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
            JobFormInfo jobFormInfo;
            String taskId = (String)this.getModel().getValue("taskid");
            if (StringUtils.isBlank((String)taskId)) {
                return;
            }
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId) && (jobFormInfo = this.getJobFormInfo()) != null) {
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)Objects.requireNonNull(jobFormInfo), (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
                ThreadPools.executeOnce((String)(((Object)((Object)this)).getClass().getSimpleName() + "-background-monitor"), (Runnable)subscriber);
            }
            TaskClientProxy.setProgressPageId((String)taskId, (String)"");
            this.getView().close();
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = this.getView().getPageCache().get("imsc_jobforminfo");
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private void progressFinish(Boolean aFalse, Boolean aTrue) {
        this.getView().setVisible(aFalse, new String[]{"labelap311"});
        this.getView().setVisible(aTrue, new String[]{"labelap31"});
    }

    private void repairBarDeal(ProgressEvent evt, TaskInfo taskInfo) {
        if (taskInfo.isFailure()) {
            Map taskCustomData = ScheduleHelper.getTaskCustomData((TaskInfo)taskInfo);
            String failureReason = taskInfo.getFailureReason();
            this.getModel().setValue("repairstatus", (Object)"B");
            String errorMessage = (String)taskCustomData.get("errorMessage");
            this.getModel().setValue("repairlog", (Object)StringUtil.subDataDeal(errorMessage, 50));
            this.getModel().setValue("repairlog_tag", (Object)errorMessage);
            this.getView().setVisible(Boolean.TRUE, new String[]{"fixresult", "checkrepair"});
            this.barCompleteDeal(evt);
            this.getView().showErrorNotification(failureReason);
        } else if (taskInfo.isTaskEnd()) {
            this.barCompleteDeal(evt);
            Map taskCustomData = ScheduleHelper.getTaskCustomData((TaskInfo)taskInfo);
            String repairStatus = (String)taskCustomData.get("repairstatus");
            this.getModel().setValue("repairstatus", (Object)repairStatus);
            String repairLog = (String)taskCustomData.get("repairlog");
            this.getModel().setValue("repairlog", (Object)StringUtil.subDataDeal(repairLog, 50));
            this.getModel().setValue("repairlog_tag", (Object)repairLog);
            String repairLogId = String.valueOf(taskCustomData.get("repairlogid"));
            this.getModel().setValue("repairlogid", (Object)repairLogId);
            this.getView().setVisible(Boolean.TRUE, new String[]{"fixresult", "checkrepair"});
            if ("A".equals(repairStatus)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"dorepair"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"repairtype"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"repairillust"});
            }
        }
    }

    private void checkBarDeal(ProgressEvent evt, TaskInfo taskInfo) {
        if (taskInfo.isFailure()) {
            Map taskCustomData = ScheduleHelper.getTaskCustomData((TaskInfo)taskInfo);
            String errorMessage = (String)taskCustomData.get("errorMessage");
            this.getModel().setValue("checkresult", (Object)"B");
            this.getModel().setValue("checkdetail", (Object)StringUtil.subDataDeal(errorMessage, 50));
            this.getModel().setValue("checkdetail_tag", (Object)errorMessage);
            this.checkFailDeal(taskCustomData);
            this.barCompleteDeal(evt);
            this.getView().showErrorNotification(errorMessage);
        } else if (taskInfo.isTaskEnd()) {
            Object checkResult;
            Map customParams;
            String repairId;
            Map taskCustomData = ScheduleHelper.getTaskCustomData((TaskInfo)taskInfo);
            String result = (String)taskCustomData.get("checkResultResponse");
            this.getModel().setValue("checkdata_tag", (Object)result);
            if (StringUtils.isNotEmpty((String)result)) {
                CheckItemLog checkItemLog = (CheckItemLog)JSONObject.parseObject((String)result, CheckItemLog.class);
                this.setCheckItemLogValue(checkItemLog);
            }
            if (StringUtils.isNotEmpty((String)(repairId = (String)(customParams = this.getView().getFormShowParameter().getCustomParams()).get("repairlogid"))) && !"null".equals(repairId)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fixresult", "checkrepair"});
                DynamicObject repairLogObj = BusinessDataServiceHelper.loadSingle((Object)repairId, (String)"dmw_migraterepairlog_eas");
                String repairStatus = repairLogObj.getString("repairstatus");
                this.getModel().setValue("repairstatus", (Object)repairStatus);
                String repairLog = repairLogObj.getString("repairlog");
                this.getModel().setValue("repairlog", (Object)StringUtil.subDataDeal(repairLog, 50));
                this.getModel().setValue("repairlog_tag", (Object)repairLog);
                String repairLogId = String.valueOf(taskCustomData.get("repairlogid"));
                this.getModel().setValue("repairlogid", (Object)repairLogId);
            }
            if ("A".equals(checkResult = this.getModel().getValue("checkresult"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"repairtype"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"repairillust"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"handfix"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"dorepair"});
            } else {
                this.checkFailDeal(taskCustomData);
                this.getView().setEnable(Boolean.TRUE, new String[]{"handfix"});
            }
            this.progressFinish(Boolean.FALSE, Boolean.TRUE);
            this.barCompleteDeal(evt);
        }
    }

    private void checkFailDeal(Map<String, Object> taskCustomData) {
        Object entryMark;
        Map<String, Object> paramMap;
        List<Map<String, Object>> maps = this.getPageParams();
        Object value = this.getModel().getValue("repairillust");
        CheckItemLog checkItemLog = (CheckItemLog)JSON.parseObject((String)((String)taskCustomData.get("checkResultResponse")), CheckItemLog.class);
        String entryMarkStr = "";
        if (!(CommonUtils.isNull(checkItemLog) || CommonUtils.isNull(paramMap = checkItemLog.getParamMap()) || CommonUtils.isNull(entryMark = paramMap.get("checkEntryMark")))) {
            entryMarkStr = entryMark.toString();
        }
        boolean isRepair = false;
        if (StringUtils.isNotEmpty((String)entryMarkStr)) {
            for (Map map : maps) {
                if (!entryMarkStr.equals(String.valueOf(map.get("checkEntryMark")))) continue;
                String repairType = (String)map.get("checkrepairtype");
                this.getModel().setValue("repairtype", (Object)repairType);
                this.getModel().setValue("repairillust", map.get("entryid"));
                this.getModel().setValue("handfixurl", map.get("repairpage"));
                this.getModel().setValue("communityurl", map.get("community"));
                isRepair = (Boolean)map.get("issupportrepair");
            }
        } else {
            Map entryId = maps.stream().filter(n -> String.valueOf(n.get("entryid")).equals(value)).findFirst().orElseGet(HashMap::new);
            isRepair = (Boolean)entryId.get("issupportrepair");
        }
        this.getView().setVisible(Boolean.valueOf(isRepair), new String[]{"dorepair"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"checkrepair"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"repairtype"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"repairillust"});
    }

    private void barCompleteDeal(ProgressEvent evt) {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        evt.setProgress(100);
        bar.stop();
        this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"tobackground"});
    }

    private void doCheckService() {
        this.deleteCheckItemLogValue();
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource");
        if (dataSource == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"CheckTestDlgEditPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        DynamicObject dblink = dataSource.getDynamicObject("dblink");
        if (dblink == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u4e2d\u7cfb\u7edf\u8fde\u63a5\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u7cfb\u7edf\u8fde\u63a5\u6570\u636e\u3002", (String)"CheckTestDlgEditPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        Long checkItem = Long.parseLong(this.getView().getFormShowParameter().getCustomParams().get("dmw_migratecheckitem_eas").toString());
        String taskIdOld = (String)this.getModel().getValue("taskid");
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskIdOld);
        if (StringUtils.isNotEmpty((String)taskIdOld) && taskInfo != null && !taskInfo.isTaskEnd()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u5148\u7b49\u5f85\u6267\u884c\u5b8c\u6210\u3002", (String)"CheckTestDlgEditPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        this.getView().getFormShowParameter().getCustomParams().put("datasource", dataSource.getPkValue());
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        List<Long> checkItemIds = Collections.singletonList(checkItem);
        Object value = this.getModel().getValue("repairillust");
        Long repairIllustrate = null;
        if (!CommonUtils.isNull(value)) {
            repairIllustrate = Long.parseLong((String)this.getModel().getValue("repairillust"));
        }
        Object repairLogId = this.getModel().getValue("repairlogid");
        param.put("checkitemids", checkItemIds);
        param.put("dblinkid", dblink.getPkValue());
        String batch = UUID.randomUUID().toString().replace("-", "");
        param.put("batch", batch);
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put("taskTypeObj", "checkbar");
        param.put("repairIds", Collections.singletonList(repairIllustrate));
        param.put("repairlogid", repairLogId);
        param.put("taskData", data);
        param.put("checkitemFormId", CommonUtils.getStringCustomParamValue(this.getView(), "checkitemFormId"));
        try {
            JobFormInfo jobFormInfo = ScheduleHelper.buildJobFormInfo((String)ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u68c0\u67e5\u4efb\u52a1", (String)"CheckTestDlgEditPlugin_9", (String)"imsc-dmw-platform", (Object[])new Object[0]), (String)CheckItemValidateTask.class.getName(), (String)CheckItemValidateTaskClick.class.getName(), (IFormView)this.getView(), param);
            jobFormInfo.getJobInfo().setAppId("dmw");
            String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            this.progressFinish(Boolean.TRUE, Boolean.FALSE);
            this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap"});
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            this.setProgressPercent(bar, 40);
            bar.start();
            this.getModel().setValue("taskid", (Object)taskId);
            this.getView().setEnable(Boolean.TRUE, new String[]{"tobackground"});
            this.getView().getPageCache().put("imsc_jobforminfo", JSON.toJSONString((Object)jobFormInfo));
        }
        catch (Exception e) {
            log.error("\u5f00\u59cb\u6267\u884c\u68c0\u67e5\u5931\u8d25", (Throwable)e);
            throw new DmwBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u68c0\u67e5\u5931\u8d25", (String)"CheckTestDlgEditPlugin_10", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private void setProgressPercent(ProgressBar bar, int percent) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(bar.getKey(), "percent", (Object)percent);
    }

    private void doRepairService(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
            DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource");
            if (dataSource == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"CheckTestDlgEditPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            DynamicObject dbLink = dataSource.getDynamicObject("dblink");
            if (dbLink == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u4e2d\u7cfb\u7edf\u8fde\u63a5\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u7cfb\u7edf\u8fde\u63a5\u6570\u636e\u3002", (String)"CheckTestDlgEditPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            String taskIdOld = (String)this.getModel().getValue("taskid");
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskIdOld);
            if (StringUtils.isNotEmpty((String)taskIdOld) && taskInfo != null && !taskInfo.isTaskEnd()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u5148\u7b49\u5f85\u6267\u884c\u5b8c\u6210\u3002", (String)"CheckTestDlgEditPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            String repairType = (String)this.getModel().getValue("repairtype");
            if (StringUtils.isEmpty((String)repairType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4fee\u590d\u7c7b\u578b\u3002", (String)"CheckTestDlgEditPlugin_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            String value = (String)this.getModel().getValue("repairillust");
            if (StringUtils.isEmpty((String)value)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4fee\u590d\u903b\u8f91\u8bf4\u660e\u3002", (String)"CheckTestDlgEditPlugin_12", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            CheckItemLog checkItemLog = this.getCheckItemLog();
            if (checkItemLog == null) {
                return;
            }
            this.getView().getFormShowParameter().getCustomParams().put("datasource", dataSource.getPkValue());
            Long repairIllust = Long.valueOf((String)this.getModel().getValue("repairillust"));
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            param.put("projectid", 0L);
            param.put("dblinkid", dbLink.getPkValue());
            param.put("taskId", dbLink.getPkValue());
            param.put("repairIds", Collections.singletonList(repairIllust));
            param.put("checkresult", this.getModel().getValue("checkresult"));
            param.put("checkdetail", this.getModel().getValue("checkdetail_tag"));
            param.put("checkItemLog", JSON.toJSONString((Object)checkItemLog));
            HashMap<String, String> data = new HashMap<String, String>(8);
            data.put("taskTypeObj", "repairbar");
            param.put("taskData", data);
            param.put("checkitemFormId", CommonUtils.getStringCustomParamValue(this.getView(), "checkitemFormId"));
            param.put("projectFormId", CommonUtils.getStringCustomParamValue(this.getView(), "projectFormId"));
            try {
                JobFormInfo jobFormInfo = ScheduleHelper.buildJobFormInfo((String)ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u68c0\u67e5\u4efb\u52a1", (String)"CheckTestDlgEditPlugin_9", (String)"imsc-dmw-platform", (Object[])new Object[0]), (String)CheckItemRepairTask.class.getName(), (String)CheckItemValidateTaskClick.class.getName(), (IFormView)this.getView(), param);
                jobFormInfo.getJobInfo().setAppId("dmw");
                String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
                this.progressFinish(Boolean.TRUE, Boolean.FALSE);
                this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap"});
                ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.setFieldProperty(bar.getKey(), "percent", (Object)40);
                bar.start();
                this.getModel().setValue("taskid", (Object)taskId);
                this.getView().setEnable(Boolean.TRUE, new String[]{"tobackground"});
                this.getView().getPageCache().put("imsc_jobforminfo", JSON.toJSONString((Object)jobFormInfo));
            }
            catch (Exception e) {
                log.error("\u5f00\u59cb\u4fee\u590d\u4efb\u52a1\u5931\u8d25", (Throwable)e);
                throw new DmwBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u4fee\u590d\u4efb\u52a1\u5931\u8d25", (String)"CheckTestDlgEditPlugin_13", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    private void setCheckItemLogValue(CheckItemLog checkItemLog) {
        this.getModel().setValue("checkresult", (Object)checkItemLog.getStatus());
        this.getModel().setValue("checkdetail", (Object)checkItemLog.getSubValidateInfo());
        this.getModel().setValue("checkdetail_tag", (Object)checkItemLog.getValidateInfo());
    }

    private void deleteCheckItemLogValue() {
        this.getModel().setValue("checkresult", null);
        this.getModel().setValue("checkdetail", null);
        this.getModel().setValue("checkdetail_tag", null);
        this.getModel().setValue("dealmethod", null);
        this.getModel().setValue("dealillust", null);
    }

    private List<Map<String, Object>> getPageParams() {
        if (this.pageParams == null) {
            Object checkitemParam = this.getView().getFormShowParameter().getCustomParams().get("checkitem_param");
            this.pageParams = (List)JSONObject.parseObject((String)((String)checkitemParam), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            if (this.pageParams == null) {
                this.pageParams = new ArrayList<Map<String, Object>>(2);
            }
        }
        return this.pageParams;
    }
}

