/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imsc.dmw.helper.eas.EasReportHelper;

public class EasBgReportList
extends AbstractListPlugin {
    public void initialize() {
        super.initialize();
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        ArrayList<String> operationKeysList = new ArrayList<String>(1);
        operationKeysList.add("viewreport");
        billlist.addPackageDataListener(pkEvent -> {
            int attachNum = pkEvent.getRowData().getInt("attachnum");
            if (attachNum <= 0) {
                int rowInex = pkEvent.getRowData().getInt("fseq") - 1;
                billlist.hideOperateItems("opcolumn", rowInex, operationKeysList);
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "viewreport": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
                Object pkValue = selectedRow.getPrimaryKeyValue();
                EasReportHelper.viewRptAttachment(pkValue, "dmw_bgreport_eas", "rptdataattachment", this.getView());
                break;
            }
            case "batch_exportzip": {
                this.batchExportZip();
                break;
            }
            case "rpt_print": {
                Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
                Map attachments = AttachmentServiceHelper.getAttachments((String)"dmw_bgreport_eas", (Object[])ids, (String)"rptdataattachment", (boolean)true);
                EasReportHelper.exportRptDataToPdf(attachments, ResManager.loadKDString((String)"EAS\u9884\u7b97\u62a5\u8868", (String)"EasBgReportList_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), this.getView());
                break;
            }
        }
    }

    private void batchExportZip() {
        Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String selectors = String.join((CharSequence)",", "id", "bgschemename", "bgschemenumber", "orgunitid", "name", "number");
        DynamicObject[] reportDynObjs = BusinessDataServiceHelper.load((String)"dmw_bgreport_eas", (String)selectors, (QFilter[])qFilter.toArray());
        if (reportDynObjs != null && reportDynObjs.length == 1) {
            String downFileName = EasReportHelper.getBgRptDownFileName(reportDynObjs[0]);
            EasReportHelper.singleRptDataExport(reportDynObjs[0].getPkValue(), downFileName, "dmw_bgreport_eas", "rptdataattachment", this.getView());
        } else if (reportDynObjs != null && reportDynObjs.length > 1) {
            HashMap<Object, String> downFileNameMap = new HashMap<Object, String>(reportDynObjs.length);
            for (DynamicObject reportDynObj : reportDynObjs) {
                downFileNameMap.put(reportDynObj.getPkValue(), EasReportHelper.getBgRptDownFileName(reportDynObj));
            }
            EasReportHelper.batchRptDataExport(downFileNameMap, ResManager.loadKDString((String)"EAS\u9884\u7b97\u62a5\u8868", (String)"EasBgReportList_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), "dmw_bgreport_eas", "rptdataattachment", this.getView());
        }
    }
}

