/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imsc.dmw.helper.eas.EasReportHelper;
import kd.imsc.dmw.utils.FormUtil;

public class EasFinReportListPlugin
extends AbstractListPlugin {
    public void initialize() {
        super.initialize();
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        ArrayList<String> operationKeysList = new ArrayList<String>(1);
        operationKeysList.add("viewreport");
        billlist.addPackageDataListener(pkEvent -> {
            int attachNum = pkEvent.getRowData().getInt("attachnum");
            if (attachNum <= 0) {
                int rowInex = pkEvent.getRowData().getInt("fseq") - 1;
                billlist.hideOperateItems("opcolumn", rowInex, operationKeysList);
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("pushfireport".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "viewreport": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
                Object pkValue = selectedRow.getPrimaryKeyValue();
                EasReportHelper.viewRptAttachment(pkValue, "dmw_fi_report_eas", "attachmentpanelap", this.getView());
                break;
            }
            case "download_report": {
                this.batchExportZip();
                break;
            }
            case "print_report": {
                Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
                Map attachments = AttachmentServiceHelper.getAttachments((String)"dmw_fi_report_eas", (Object[])ids, (String)"attachmentpanelap", (boolean)true);
                EasReportHelper.exportRptDataToPdf(attachments, ResManager.loadKDString((String)"EAS\u8d22\u52a1\u62a5\u8868", (String)"EasFinReportListPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), this.getView());
                break;
            }
            case "pushfireport": {
                Object[] selectIds = this.getSelectedRows().getPrimaryKeyValues();
                HashMap<String, Object> customParams = new HashMap<String, Object>(16);
                customParams.put("param_reportpks", selectIds);
                customParams.put("reporttype", "1");
                FormShowParameter formShowParameter = FormUtil.formShowParameter("dmw_reportconfirm", ShowType.Modal, customParams);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pushfireport"));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "pushreportlog": {
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
                qFilterList.add(new QFilter("reporttype", "=", (Object)"1"));
                ListShowParameter listShowParameter = FormUtil.listShowParameter("dmw_reportpushrecord", null, ShowType.MainNewTabPage, null, qFilterList);
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
        }
    }

    private void batchExportZip() {
        Object[] ids = this.getSelectedRows().getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        String selectors = String.join((CharSequence)",", "org", "reporttime", "number", "name");
        DynamicObject[] reportDynObjs = BusinessDataServiceHelper.load((String)"dmw_fi_report_eas", (String)selectors, (QFilter[])qFilter.toArray());
        if (reportDynObjs != null && reportDynObjs.length == 1) {
            String downFileName = EasReportHelper.getFiRptDownFileName(reportDynObjs[0]);
            EasReportHelper.singleRptDataExport(reportDynObjs[0].getPkValue(), downFileName, "dmw_fi_report_eas", "attachmentpanelap", this.getView());
        } else if (reportDynObjs != null && reportDynObjs.length > 1) {
            HashMap<Object, String> downFileNameMap = new HashMap<Object, String>(reportDynObjs.length);
            for (DynamicObject reportDynObj : reportDynObjs) {
                downFileNameMap.put(reportDynObj.getPkValue(), EasReportHelper.getFiRptDownFileName(reportDynObj));
            }
            EasReportHelper.batchRptDataExport(downFileNameMap, ResManager.loadKDString((String)"EAS\u8d22\u52a1\u62a5\u8868", (String)"EasFinReportListPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), "dmw_fi_report_eas", "attachmentpanelap", this.getView());
        }
    }
}

