/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.imsc.dmw.helper.ProgressHelper;
import kd.imsc.dmw.helper.ScheduleHelper;
import kd.imsc.dmw.helper.eas.EasQueryHelper;
import kd.imsc.dmw.plugin.formplugin.schedule.task.EasObtainDataTask;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtils;
import kd.imsc.imbd.formplugin.AbstractImbdBdEditPlugin;

public class EasObtainEditPlugin
extends AbstractImbdBdEditPlugin
implements BeforeF7SelectListener,
ProgresssListener {
    private static final String JOB_ID = "jobId";
    private static final Log logger = LogFactory.getLog(EasObtainEditPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String parentFormId = e.getFormShowParameter().getParentFormId();
        if (kd.bos.util.StringUtils.isEmpty((String)parentFormId)) {
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "dblinktest"});
        BasedataEdit cashMap = (BasedataEdit)this.getControl("dblink");
        cashMap.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String name = (String)this.getView().getFormShowParameter().getCustomParam("name");
        HashMap styleMap = new HashMap(8);
        HashMap<String, String> nameMap = new HashMap<String, String>(8);
        styleMap.put("text", nameMap);
        nameMap.put("zh_CN", name);
        this.getView().updateControlMetadata("btnok", styleMap);
        this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter qFilter = new QFilter("database_type", "=", (Object)"eas");
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        DynamicObject dbLink = (DynamicObject)this.getModel().getValue("dblink");
        if (EasQueryHelper.judgeDbLinkIsNull(dbLink, this.getView())) {
            return;
        }
        if (StringUtils.equals("btnok", controlKey)) {
            this.getModel().setValue("lockmark", (Object)true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap"});
            String tableName = (String)this.getView().getFormShowParameter().getCustomParam("eastablename");
            String sql = (String)this.getView().getFormShowParameter().getCustomParam("sql");
            String countSql = (String)this.getView().getFormShowParameter().getCustomParam("countsql");
            String xhFieldsStr = (String)this.getView().getFormShowParameter().getCustomParam("xhFields");
            String easFieldsStr = (String)this.getView().getFormShowParameter().getCustomParam("easFields");
            Long dbLinkId = (Long)dbLink.getPkValue();
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            param.put("sql", sql);
            param.put("countsql", countSql);
            param.put("dbLinkId", dbLinkId);
            param.put("eastablename", tableName);
            param.put("xhFields", xhFieldsStr);
            param.put("easFields", easFieldsStr);
            JobFormInfo jobFormInfo = ScheduleHelper.buildJobFormInfo((String)ResManager.loadKDString((String)"\u83b7\u53d6EAS\u6570\u636e\u4efb\u52a1", (String)"EasObtainEditPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), (String)EasObtainDataTask.class.getName(), (String)"", (IFormView)this.getView(), param);
            jobFormInfo.getJobInfo().setAppId("dmw");
            String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            this.getView().getPageCache().put(JOB_ID, taskId);
            ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
            ProgressHelper.setFinished((IFormView)this.getView(), (boolean)false);
            this.updateProgress(0, "underway");
            progressBar.setPercent(0);
            progressBar.start();
        } else {
            EasQueryHelper.dbLinkTestClick(dbLink, this.getView());
        }
    }

    public void onProgress(ProgressEvent evt) {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        String taskId = this.getView().getPageCache().get(JOB_ID);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        int progress = taskInfo.getProgress();
        Map customData = ScheduleHelper.getTaskCustomData((TaskInfo)taskInfo);
        if (!CommonUtils.isNull(customData)) {
            progress = (Integer)customData.get("percent");
        }
        if (progress == 100) {
            if (ProgressHelper.isFinished((IFormView)this.getView())) {
                evt.setProgress(progress);
                this.updateProgress(progress, "success");
                this.getView().getModel().setValue("lockmark", (Object)false);
                String errMsg = customData.get("errmsg") == null ? taskInfo.getFailureReason() : (String)customData.get("errmsg");
                this.getView().showErrorNotification(errMsg);
                progressBar.stop();
                IFormView parentView = this.getView().getParentView();
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
            } else {
                ProgressHelper.setFinished((IFormView)this.getView(), (boolean)true);
                evt.setProgress(99);
                this.updateProgress(99, "success");
            }
        } else if (taskInfo.isFailure() || taskInfo.isTaskEnd()) {
            evt.setProgress(progress);
            this.updateProgress(progress, "fail");
            this.getView().getModel().setValue("lockmark", (Object)false);
            String errMsg = customData.get("errmsg") == null ? taskInfo.getFailureReason() : (String)customData.get("errmsg");
            this.getView().showErrorNotification(errMsg);
            logger.error(errMsg);
            progressBar.stop();
        } else {
            evt.setProgress(progress);
            this.updateProgress(progress, "underway");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Boolean lockMark = (Boolean)this.getModel().getValue("lockmark");
        if (Boolean.TRUE.equals(lockMark)) {
            e.setCancel(true);
        }
    }

    public void updateProgress(int rate, String status) {
        String title;
        HashMap styleMap = new HashMap(2);
        if (!"fail".equals(status)) {
            if (rate == 100) {
                title = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u83b7\u53d6", (String)"EasObtainEditPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"EasObtainEditPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            } else {
                title = ResManager.loadKDString((String)"\u6570\u636e\u83b7\u53d6\u4e2d\u2026\u2026", (String)"EasObtainEditPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            }
        } else {
            title = ResManager.loadKDString((String)"\u83b7\u53d6\u5931\u8d25\u6216\u4e2d\u65ad\uff0c\u8bf7\u68c0\u67e5\u9519\u8bef!", (String)"EasObtainEditPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        }
        this.getModel().setValue("progresstitle", (Object)title);
        this.getView().updateControlMetadata("progressbarap", styleMap);
    }
}

