/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.helper.PermissionHelper;
import kd.imsc.dmw.helper.ProgressHelper;
import kd.imsc.dmw.helper.ScheduleHelper;
import kd.imsc.dmw.helper.tpl.MigrateUserGuideSourceVerifyHelper;
import kd.imsc.dmw.plugin.formplugin.schedule.task.IscDataDeployTask;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class ResImportOnlineEditPlugin
extends ImbdDymicTplEditPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(ResImportOnlineEditPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String parentFormId = e.getFormShowParameter().getParentFormId();
        if (StringUtils.isEmpty((String)parentFormId)) {
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel", "btnonline", "operateinstruction", "secretkeyaffect", "secretkeyaffectcmp"});
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbar");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String json = (String)formShowParameter.getCustomParam("migobjentryentity");
        Map migObjEntryEntityMap = (Map)JSONObject.parseObject((String)json, LinkedHashMap.class);
        DynamicObjectCollection migObjEntryEntity = this.getModel().getEntryEntity("migobjentryentity");
        ArrayList<Long> schemeIdList = new ArrayList<Long>(8);
        this.getView().getPageCache().put("isStart", "notstart");
        for (Map.Entry entry : migObjEntryEntityMap.entrySet()) {
            DynamicObject migObjEntry = migObjEntryEntity.addNew();
            Map map = (Map)entry.getValue();
            migObjEntry.set("migobjtype", map.get("migobjtype"));
            migObjEntry.set("migrateobject_id", map.get("migrateobject"));
            migObjEntry.set("integrattype", map.get("integrattype"));
            migObjEntry.set("schemename", map.get("schemename"));
            migObjEntry.set("schemeid", map.get("schemeid"));
            migObjEntry.set("solutionpackageid", map.get("solutionpackageid"));
            migObjEntry.set("solutionpackage", map.get("solutionpackage"));
            schemeIdList.add(Long.parseLong(String.valueOf(map.get("schemeid"))));
        }
        this.getView().getParentView().getPageCache().put("schemeIdList", JSON.toJSONString(schemeIdList));
        BusinessDataServiceHelper.loadRefence((Object[])migObjEntryEntity.toArray(), (IDataEntityType)migObjEntryEntity.getDynamicObjectType());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean keyStatus = (Boolean)formShowParameter.getCustomParam("keystatus");
        this.getView().setVisible(Boolean.valueOf(keyStatus), new String[]{"flexsteponecmp"});
        this.getView().setVisible(Boolean.valueOf(!keyStatus), new String[]{"flexstepone"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"imgerror", "imgright", "txtpercent"});
        HashMap<String, String> styleMap = new HashMap<String, String>(2);
        styleMap.put("fc", "#999999");
        this.getView().updateControlMetadata("txtdetails", styleMap);
    }

    public void beforeClick(BeforeClickEvent evt) {
        String isStart;
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnonline".equals(key) && !(isStart = this.getView().getPageCache().get("isStart")).equals("notstart") && !isStart.equals("end")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u5728\u7ebf\u90e8\u7f72\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"ResImportOnlineEditPlugin_10", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": 
            case "btncancel": {
                this.exit();
                break;
            }
            case "btnonline": {
                this.onlineDeployment();
                break;
            }
            case "operateinstruction": {
                this.openCommunityUrl();
                break;
            }
            case "secretkeyaffect": 
            case "secretkeyaffectcmp": {
                this.openKeyApplyPage();
                break;
            }
        }
    }

    public void onProgress(ProgressEvent evt) {
        ProgressBar progressBar = (ProgressBar)evt.getSource();
        String progressBarKey = progressBar.getKey();
        if (progressBarKey.equals("progressbar")) {
            String taskId = this.getView().getPageCache().get("jobId");
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            Map customData = ScheduleHelper.getTaskCustomData((TaskInfo)taskInfo);
            if (!CommonUtils.isNull(customData)) {
                Integer realProgress = (Integer)customData.get("percent");
                progress = realProgress;
            }
            if (progress == 100) {
                if (ProgressHelper.isFinished((IFormView)this.getView())) {
                    evt.setProgress(progress);
                    this.setDeployStatus(100, ResManager.loadKDString((String)"\u90e8\u7f72\u6210\u529f", (String)"ResImportOnlineEditPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#1BA854");
                    progressBar.stop();
                    this.getView().getPageCache().put("isStart", "end");
                } else {
                    ProgressHelper.setFinished((IFormView)this.getView(), (boolean)true);
                    evt.setProgress(99);
                    this.setDeployStatus(99, ResManager.loadKDString((String)"\u6b63\u5728\u90e8\u7f72...", (String)"ResImportOnlineEditPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#276FF5");
                }
            } else if (taskInfo.isTaskEnd() || taskInfo.isFailure()) {
                evt.setProgress(progress);
                String errMsg = this.buildDeployFailMsg(customData);
                this.setDeployStatus(progress, errMsg, "#FB2323");
                progressBar.stop();
                this.getView().getPageCache().put("isStart", "end");
            } else {
                evt.setProgress(progress);
                this.setDeployStatus(progress, ResManager.loadKDString((String)"\u6b63\u5728\u90e8\u7f72...", (String)"ResImportOnlineEditPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#276FF5");
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isStart = this.getView().getPageCache().get("isStart");
        HashMap map = new HashMap(2);
        if (!isStart.equals("notstart") && !isStart.equals("end")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u5728\u7ebf\u90e8\u7f72\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed", (String)"ResImportOnlineEditPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            e.setCancel(true);
        }
        this.getView().returnDataToParent(map);
    }

    public void setDeployStatus(int percent, String details, String color) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"txtdetails", "txtpercent"});
        HashMap<String, String> styleMap = new HashMap<String, String>(2);
        String percentStr = String.valueOf(percent) + '%';
        this.getModel().setValue("txtdetails", (Object)details);
        this.getModel().setValue("txtpercent", (Object)percentStr);
        styleMap.put("fc", color);
        if ("#FB2323".equals(color)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"imgerror"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"imgright"});
        } else if ("#1BA854".equals(color)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"imgright"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"imgerror"});
        }
        this.getView().updateControlMetadata("progressbar", styleMap);
    }

    private void exit() {
        this.getView().close();
    }

    private void onlineDeployment() {
        boolean keyStatus;
        DynamicObject cloudApp = MigrateUserGuideSourceVerifyHelper.getCloudApp(false);
        boolean bl = keyStatus = cloudApp != null && "S".equals(cloudApp.get("billstatus"));
        if (!keyStatus) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u5e94\u7528\u79d8\u94a5\u7533\u8bf7\uff0c\u518d\u8fdb\u884c\u90e8\u7f72", (String)"ResImportOnlineEditPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return;
        }
        PermissionHelper.checkPermission(null, "isc_solution_center", "2F0/XKR9O2+F", "1O5+X0V9AM=+");
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("migobjentryentity");
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbar");
        Map<String, List<Long>> idListFilterMap = this.filterId(entryEntities);
        List<Long> schemeFilteredIdList = idListFilterMap.get("scheme");
        List<Long> packageFilteredIdList = idListFilterMap.get("package");
        Map<String, List<String>> packSourceMap = this.getPackSourceMap(entryEntities, schemeFilteredIdList);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("packageIdList", packageFilteredIdList);
        param.put("schemeIdMap", packSourceMap);
        param.put("sum_cache", schemeFilteredIdList.size());
        JobFormInfo jobFormInfo = ScheduleHelper.buildJobFormInfo((String)ResManager.loadKDString((String)"\u5728\u7ebf\u90e8\u7f72\u4efb\u52a1", (String)"ResImportOnlineEditPlugin_8", (String)"imsc-dmw-platform", (Object[])new Object[0]), (String)IscDataDeployTask.class.getName(), (String)"", (IFormView)this.getView(), param);
        jobFormInfo.getJobInfo().setAppId("dmw");
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.getView().getPageCache().put("jobId", taskId);
        ProgressHelper.setFinished((IFormView)this.getView(), (boolean)false);
        progressBar.start();
        this.getView().getPageCache().put("isStart", "start");
        this.setDeployStatus(0, ResManager.loadKDString((String)"\u6b63\u5728\u8ba2\u9605...", (String)"ResImportOnlineEditPlugin_9", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#276FF5");
    }

    public String buildDeployFailMsg(Map<String, Object> customData) {
        StringBuilder msg = new StringBuilder();
        List packageIdList = (List)customData.get("packageIdList");
        List schemeIdList = (List)customData.get("schemeIdList");
        String errMsg = (String)customData.get("errMsg");
        Map<String, Map<Long, Integer>> map = this.getPackEntryMap();
        Map<Long, Integer> schemeEntryMap = map.get("scheme");
        Map<Long, Integer> packEntryMap = map.get("package");
        if (!CommonUtils.isNull(packageIdList)) {
            for (Object packageId : packageIdList) {
                msg.append(ResManager.loadKDString((String)"\u7b2c%s\u884c\u65b9\u6848\u5305\u8ba2\u9605\u5931\u8d25", (String)"ResImportOnlineEditPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[]{packEntryMap.get(Long.valueOf(packageId.toString()))})).append('\n');
            }
        }
        if (!CommonUtils.isNull(schemeIdList)) {
            for (Object schemeId : schemeIdList) {
                msg.append(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d44\u6e90\u90e8\u7f72\u5931\u8d25\uff0c\u8be5\u8d44\u6e90\u53ef\u80fd\u4e0d\u5728\u5f53\u524d\u65b9\u6848\u5305", (String)"ResImportOnlineEditPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[]{schemeEntryMap.get(Long.valueOf(schemeId.toString()))})).append('\n');
            }
        }
        if (!CommonUtils.isNull(errMsg)) {
            msg.append(ResManager.loadKDString((String)"\u5f02\u5e38\u8be6\u60c5:", (String)"ResImportOnlineEditPlugin_7", (String)"imsc-dmw-platform", (Object[])new Object[0])).append('\n');
            msg.append(errMsg);
        }
        return msg.toString();
    }

    private Map<String, List<String>> getPackSourceMap(DynamicObjectCollection entryEntities, List<Long> schemeIdListFilter) {
        LinkedHashMap<String, List<String>> packSourceMap = new LinkedHashMap<String, List<String>>(8);
        for (DynamicObject entry : entryEntities) {
            String packageId = entry.getString("solutionpackageid");
            String sourceId = entry.getString("schemeid");
            if (!schemeIdListFilter.contains(Long.parseLong(sourceId))) continue;
            List<String> sourceIdList = new ArrayList<String>(8);
            if (packSourceMap.get(packageId) != null) {
                sourceIdList = (List)packSourceMap.get(packageId);
            }
            sourceIdList.add(sourceId);
            packSourceMap.put(packageId, sourceIdList);
        }
        return packSourceMap;
    }

    private Map<String, Map<Long, Integer>> getPackEntryMap() {
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("migobjentryentity");
        HashMap<String, Map<Long, Integer>> map = new HashMap<String, Map<Long, Integer>>(2);
        HashMap<Long, Integer> schemeEntryMap = new HashMap<Long, Integer>(8);
        HashMap<Long, Integer> packEntryMap = new HashMap<Long, Integer>(8);
        for (int i = 0; i < entryEntities.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntities.get(i);
            Long packageId = entry.getLong("solutionpackageid");
            Long schemeId = entry.getLong("schemeid");
            packEntryMap.putIfAbsent(packageId, i + 1);
            schemeEntryMap.putIfAbsent(schemeId, i + 1);
        }
        map.put("scheme", schemeEntryMap);
        map.put("package", packEntryMap);
        return map;
    }

    private Map<String, List<Long>> filterId(DynamicObjectCollection entryEntities) {
        ArrayList<Long> planIdListOld = new ArrayList<Long>(8);
        ArrayList<Long> flowIdListOld = new ArrayList<Long>(8);
        for (DynamicObject entry : entryEntities) {
            String initType = entry.getString("integrattype");
            if ("isc_data_copy_trigger".equals(initType)) {
                planIdListOld.add(entry.getLong("schemeid"));
                continue;
            }
            flowIdListOld.add(entry.getLong("schemeid"));
        }
        QFilter planFilter = new QFilter("id", "in", planIdListOld);
        QFilter flowFilter = new QFilter("id", "in", flowIdListOld);
        List planIdListNew = QueryServiceHelper.queryPrimaryKeys((String)"isc_data_copy_trigger", (QFilter[])new QFilter[]{planFilter}, null, (int)-1);
        List flowIdListNew = QueryServiceHelper.queryPrimaryKeys((String)"isc_service_flow", (QFilter[])new QFilter[]{flowFilter}, null, (int)-1);
        ArrayList<Long> schemeFilterIdList = new ArrayList<Long>(8);
        ArrayList<Long> packageFilterIdList = new ArrayList<Long>(8);
        for (DynamicObject entry : entryEntities) {
            Long packageId = entry.getLong("solutionpackageid");
            Long sourceId = entry.getLong("schemeid");
            packageFilterIdList.add(packageId);
            if (planIdListNew.contains(sourceId) || flowIdListNew.contains(sourceId)) continue;
            schemeFilterIdList.add(sourceId);
        }
        HashMap<String, List<Long>> idListFilterMap = new HashMap<String, List<Long>>(2);
        idListFilterMap.put("scheme", schemeFilterIdList);
        idListFilterMap.put("package", packageFilterIdList);
        return idListFilterMap;
    }

    private void openCommunityUrl() {
        String url = (String)this.getModel().getValue("opwebsite");
        this.getView().openUrl(url);
    }

    private void openKeyApplyPage() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("res_pub_thirdapp_apply");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

