/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.eas;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.utils.FileUtils;
import kd.imsc.dmw.utils.QFilterUtils;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.dmw.utils.StringUtils;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class RptFileUploadEditPlugin
extends ImbdDymicTplEditPlugin
implements UploadListener {
    private static final String ATTACHMENT_PANEL_AP = "attachmentpanelap";
    private static final String[] MATCH_FIELDS = new String[]{"org.number", "number", "reporttype", "reportyear", "reportperiod", "currency.number"};

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String parentFormId = e.getFormShowParameter().getParentFormId();
        Map params = e.getFormShowParameter().getCustomParams();
        String param = (String)params.get("mainPageId");
        if (StringUtils.isEmpty(parentFormId) && StringUtils.isEmpty(param)) {
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL_AP);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            String uploadingAttJson = cache.get("UploadingAtt" + this.getView().getPageId());
            if (StringUtil.isNotEmpty(uploadingAttJson)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"RptFileUploadEditPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return;
            }
            this.importResult();
        }
    }

    private void importResult() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL_AP);
        List list = attachmentPanel.getAttachmentData();
        ArrayList<String> errorList = new ArrayList<String>(16);
        for (Map file : list) {
            String url = (String)file.get("url");
            String name = (String)file.get("name");
            String[] names = name.split("\\.");
            if (names.length != MATCH_FIELDS.length + 1) {
                errorList.add(name);
                continue;
            }
            QFilter qFilter = QFilterUtils.getAllDataQFilter();
            for (int i = 0; i < MATCH_FIELDS.length; ++i) {
                Object value = names[i];
                if ("reportyear".equals(MATCH_FIELDS[i]) || "reportperiod".equals(MATCH_FIELDS[i])) {
                    value = Integer.parseInt((String)value);
                }
                qFilter.and(MATCH_FIELDS[i], "=", value);
            }
            DynamicObject rptObj = BusinessDataServiceHelper.loadSingleFromCache((String)"dmw_fi_report_eas", (QFilter[])qFilter.toArray());
            if (rptObj == null) {
                errorList.add(name);
                continue;
            }
            List reportFiles = AttachmentServiceHelper.getAttachments((String)"dmw_fi_report_eas", (Object)rptObj.getPkValue(), (String)ATTACHMENT_PANEL_AP);
            for (Map report : reportFiles) {
                Object uid = report.get("uid");
                AttachmentServiceHelper.remove((String)"dmw_fi_report_eas", (Object)rptObj.getPkValue(), uid);
            }
            FileUtils.uploadFilePanel((String)"dmw_fi_report_eas", (Object)rptObj.getPkValue(), (String)"file", (String)url, (String)"dmw_rpt");
            this.updateReport(rptObj.getPkValue());
            IFormView parentView = this.getView().getParentView();
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
        int success = list.size() - errorList.size();
        StringBuilder builder = new StringBuilder();
        String msg1 = ResManager.loadKDString((String)"\u5339\u914d\u6210\u529f", (String)"RptFileUploadEditPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        String msg2 = ResManager.loadKDString((String)"\u5f20\u62a5\u8868\uff0c\u5339\u914d\u5931\u8d25", (String)"RptFileUploadEditPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        String msg3 = ResManager.loadKDString((String)"\u5f20\u62a5\u8868", (String)"RptFileUploadEditPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        String msg4 = ResManager.loadKDString((String)"\u62a5\u8868\u5339\u914d\u5931\u8d25", (String)"RptFileUploadEditPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        builder.append(msg1).append(success).append(msg2).append(errorList.size()).append(msg3).append('\n');
        for (String error : errorList) {
            builder.append(error).append(msg4).append('\n');
        }
        this.getView().returnDataToParent((Object)builder.toString());
        this.getView().close();
    }

    private void updateReport(Object pkValue) {
        DynamicObject easFiReport = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"dmw_fi_report_eas");
        List sourceFileList = AttachmentServiceHelper.getAttachments((String)"dmw_fi_report_eas", (Object)pkValue, (String)ATTACHMENT_PANEL_AP);
        easFiReport.set("attachnum", (Object)sourceFileList.size());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{easFiReport});
    }
}

