/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.ecc;

import java.util.EventObject;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class MigrateUserguideECCFormPlugin
extends ImbdDymicTplEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"savelink", "modifylink", "dblinktest", "configguide"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject linkDynObj = this.loadDatabaseLink();
        boolean isDataNull = CommonUtils.isNull(linkDynObj);
        this.getView().setEnable(Boolean.valueOf(!isDataNull), new String[]{"modifylink", "dblinktest"});
        this.getView().setEnable(Boolean.valueOf(isDataNull), new String[]{"savelink"});
        DynamicObject linkDataDynObj = (DynamicObject)this.getModel().getValue("dblink");
        if (linkDataDynObj != null && !"IMSC_ECC_MIGRATE".equals(DynamicObjectUtils.getString((DynamicObject)linkDataDynObj, (String)"number")) && !"IMSC_ECC_AGENT_MIGRATE".equals(DynamicObjectUtils.getString((DynamicObject)linkDataDynObj, (String)"number"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"savelink", "modifylink", "dblinktest"});
            isDataNull = false;
            linkDynObj = linkDataDynObj;
        }
        if (linkDynObj != null) {
            this.loadDataByIscDatabaseLink(linkDynObj);
        }
        this.setLinkFieldEnable(isDataNull);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "savelink": {
                DynamicObject linkDynObj;
                OperationResult optResult;
                Object databaseType = this.getModel().getValue("databasetype");
                Object linkNumber = this.getModel().getValue("linknumber");
                Object linkName = this.getModel().getValue("linkname");
                if (StringUtil.isEmpty(databaseType) || StringUtil.isEmpty(linkNumber) || StringUtil.isEmpty(linkName) || "SAP-RFC-Proxy".equals(databaseType) && (StringUtil.isEmpty(this.getModel().getValue("proxyserver_ip")) || (Integer)this.getModel().getValue("proxyserver_port") <= 0 || StringUtil.isEmpty(this.getModel().getValue("user")) || StringUtil.isEmpty(this.getModel().getValue("newpwd")) || StringUtil.isEmpty(this.getModel().getValue("sql_database")) || StringUtil.isEmpty(this.getModel().getValue("http_protocal")))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u65b9\u5f0f\u3001\u8fde\u63a5\u7f16\u7801\u3001\u8fde\u63a5\u540d\u79f0\u3001\u670d\u52a1\u5668IP\u6216\u57df\u540d\u3001\u670d\u52a1\u5668\u7aef\u53e3\u3001\u767b\u5f55\u7528\u6237\u3001\u767b\u5f55\u5bc6\u7801\u3001SAP\u540d\u79f0\u3001HTTP\u534f\u8bae\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MigrateUserguideECCFormPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    return;
                }
                DynamicObject dblinkDynObj = (DynamicObject)this.getModel().getValue("dblink");
                if (dblinkDynObj != null) {
                    QFilter filter = new QFilter("dblink", "=", (Object)dblinkDynObj.getLong("id"));
                    filter.and(new QFilter("projectstatus", "=", (Object)"E"));
                    String selectors = String.join((CharSequence)",", "number", "executetype", "migratestatus");
                    DynamicObject[] projectDynObjs = BusinessDataServiceHelper.load((String)"dmw_migrateproject_ecc", (String)selectors, (QFilter[])filter.toArray());
                    StringBuilder numberBuilder = new StringBuilder();
                    for (DynamicObject projectDynObj : projectDynObjs) {
                        long count = projectDynObj.getDynamicObjectCollection("treeentryentity").stream().filter(o -> "2".equals(o.getString("executetype")) && "B".equals(o.getString("migratestatus"))).count();
                        if (count > 0L) continue;
                        numberBuilder.append(projectDynObj.getString("number")).append("\uff0c");
                    }
                    if (numberBuilder.length() > 0) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u540c\u4e00\u8fde\u63a5\u914d\u7f6e\u7684\u8fc1\u79fb\u4e2d\u9879\u76ee\uff1a%s\u8bf7\u8fc1\u79fb\u5b8c\u6210\u540e\uff0c\u518d\u4fee\u6539\u8fde\u63a5\u914d\u7f6e\u3002", (String)"MigrateUserguideECCFormPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), numberBuilder.toString());
                        this.getView().showErrorNotification(msg);
                        return;
                    }
                }
                if (!(optResult = SaveServiceHelper.saveOperate((String)"isc_database_link", (DynamicObject[])new DynamicObject[]{linkDynObj = this.createIscDatabaseLinkByGuide()}, (OperateOption)OperateOption.create())).isSuccess()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u96c6\u6210\u4e91SAP\u8fde\u63a5\u914d\u7f6e\u5931\u8d25\uff0c%s", (String)"MigrateUserguideECCFormPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), CommonUtils.getErrDetail(optResult));
                    this.getView().showMessage(msg);
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"MigrateUserguideECCFormPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                this.setLinkFieldEnable(false);
                this.getModel().setValue("dblink", linkDynObj.getPkValue());
                this.getView().setEnable(Boolean.FALSE, new String[]{"savelink"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"modifylink", "dblinktest"});
                this.getPageCache().put("modifylink", "savelink");
                break;
            }
            case "modifylink": {
                if (this.getModel().getValue("dblink") != null) {
                    String msg = ResManager.loadKDString((String)"\u4fee\u6539\u5f53\u524d\u8fde\u63a5\u914d\u7f6e\u4f1a\u5f71\u54cd\u5176\u4ed6ECC\u6570\u636e\u8fc1\u79fb\u9879\u76ee\u5173\u8054\u7684\u8fde\u63a5\u914d\u7f6e\uff0c\u8bf7\u8c28\u614e\u786e\u8ba4\u662f\u5426\u4fee\u6539\uff1f", (String)"MigrateUserguideECCFormPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("modifylink"));
                    return;
                }
                this.modifyLink();
                break;
            }
            case "configguide": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("dmw_ecc_config");
                parameter.getOpenStyle().setPlaceholder(false);
                parameter.getOpenStyle().setShowType(ShowType.PageDrawer);
                parameter.getOpenStyle().setFloatingDirection(FloatingDirection.BottomRight);
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("modifylink".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.modifyLink();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "proxyserver_ip": {
                String serverIp = StringUtil.toString(newValue);
                if (StringUtil.isEmpty(serverIp) || !Pattern.matches("\\d+\\.\\d+\\.\\d+\\.\\d+", serverIp)) break;
                this.getModel().setValue("http_protocal", (Object)"http");
                break;
            }
            case "http_protocal": {
                if (!"http".equals(newValue)) break;
                this.getView().showMessage(ResManager.loadKDString((String)"http\u662f\u4e0d\u5b89\u5168\u534f\u8bae\uff0c\u4f7f\u7528\u8be5\u534f\u8bae\u5728\u7f51\u7edc\u4e0a\u4f20\u8f93\u6570\u636e\u65f6\u53ef\u80fd\u53d1\u751f\u4fe1\u606f\u6cc4\u9732\uff0c\u8bf7\u614e\u91cd\u8bc4\u4f30\u76f8\u5173\u98ce\u9669\u3002", (String)"MigrateUserguideECCFormPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "databasetype": {
                DynamicObject linkDynObj = this.loadDatabaseLink();
                if (linkDynObj == null) break;
                this.loadDataByIscDatabaseLink(linkDynObj);
                break;
            }
        }
    }

    private void loadDataByIscDatabaseLink(DynamicObject linkDynObj) {
        this.getModel().setValue("dblink", linkDynObj.getPkValue());
        this.getModel().setValue("databasetype", linkDynObj.get("database_type"));
        this.getModel().setValue("linknumber", (Object)linkDynObj.getString("number"));
        this.getModel().setValue("linkname", (Object)linkDynObj.getString("name"));
        String dumLinkId = DynamicObjectUtils.getStrPkValue((DynamicObject)linkDynObj, (String)"dum_link");
        if ("0Z=EDQWTK34Y".equals(dumLinkId)) {
            this.getModel().setValue("server_ip", linkDynObj.get("server_ip"));
            this.getModel().setValue("sapclient", linkDynObj.get("attr1"));
            this.getModel().setValue("sapclientsysnr", linkDynObj.get("attr2"));
            this.getModel().setValue("sapclientlang", linkDynObj.get("attr3"));
            this.getModel().setValue("sapclientuser", linkDynObj.get("user"));
            this.getModel().setValue("sapnewpwd", linkDynObj.get("newpwd"));
            this.getModel().setValue("sappool_capacity", linkDynObj.get("attr4"));
            this.getModel().setValue("sappeak_limit", linkDynObj.get("attr5"));
            this.getModel().setValue("saprouter", linkDynObj.get("attr6"));
        } else if ("381V34W0TMWR".equals(dumLinkId)) {
            this.getModel().setValue("proxyserver_ip", linkDynObj.get("server_ip"));
            this.getModel().setValue("proxyserver_port", linkDynObj.get("server_port"));
            this.getModel().setValue("sql_database", linkDynObj.get("sql_database"));
            this.getModel().setValue("http_protocal", linkDynObj.get("http_protocal"));
            this.getModel().setValue("user", linkDynObj.get("user"));
            this.getModel().setValue("newpwd", linkDynObj.get("newpwd"));
        }
        this.getModel().setValue("max_tps", linkDynObj.get("max_tps"));
    }

    private DynamicObject createIscDatabaseLinkByGuide() {
        DynamicObject linkDynObj = this.loadDatabaseLink();
        if (linkDynObj == null) {
            linkDynObj = BusinessDataServiceHelper.newDynamicObject((String)"isc_database_link");
            long pkId = DB.genLongId((String)linkDynObj.getDynamicObjectType().getAlias());
            linkDynObj.set("id", (Object)pkId);
        }
        String databaseType = (String)this.getModel().getValue("databasetype");
        linkDynObj.set("database_type", (Object)databaseType);
        linkDynObj.set("number", this.getModel().getValue("linknumber"));
        linkDynObj.set("name", this.getModel().getValue("linkname"));
        linkDynObj.set("isv", (Object)"kingdee.imsc");
        linkDynObj.set("enable", (Object)"1");
        linkDynObj.set("status", (Object)"C");
        linkDynObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        linkDynObj.set("max_tps", this.getModel().getValue("max_tps"));
        if ("SAP-RFC".equals(databaseType)) {
            linkDynObj.set("dum_link", (Object)"0Z=EDQWTK34Y");
            linkDynObj.set("server_ip", this.getModel().getValue("server_ip"));
            linkDynObj.set("attr1", this.getModel().getValue("sapclient"));
            linkDynObj.set("attr2", this.getModel().getValue("sapclientsysnr"));
            linkDynObj.set("attr3", this.getModel().getValue("sapclientlang"));
            linkDynObj.set("user", this.getModel().getValue("sapclientuser"));
            linkDynObj.set("newpwd", this.getModel().getValue("sapnewpwd"));
            linkDynObj.set("attr4", this.getModel().getValue("sappool_capacity"));
            linkDynObj.set("attr5", this.getModel().getValue("sappeak_limit"));
            linkDynObj.set("attr6", this.getModel().getValue("saprouter"));
        } else if ("SAP-RFC-Proxy".equals(databaseType)) {
            linkDynObj.set("dum_link", (Object)"381V34W0TMWR");
            linkDynObj.set("server_ip", this.getModel().getValue("proxyserver_ip"));
            linkDynObj.set("server_port", this.getModel().getValue("proxyserver_port"));
            linkDynObj.set("sql_database", this.getModel().getValue("sql_database"));
            linkDynObj.set("http_protocal", this.getModel().getValue("http_protocal"));
            linkDynObj.set("user", this.getModel().getValue("user"));
            linkDynObj.set("newpwd", this.getModel().getValue("newpwd"));
        }
        return linkDynObj;
    }

    private void setLinkFieldEnable(boolean isEnable) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"databasetype", "http_protocal", "max_tps", "newpwd", "proxyserver_ip", "proxyserver_port", "server_ip", "sapclient", "sapclientlang", "sapclientsysnr", "sapclientuser", "sapnewpwd", "sappeak_limit", "sappool_capacity", "saprouter", "sql_database", "user"});
    }

    private DynamicObject loadDatabaseLink() {
        DynamicObject dbLinkDynObj = (DynamicObject)this.getModel().getValue("dblink");
        String dumLinkId = DynamicObjectUtils.getStrPkValue((DynamicObject)dbLinkDynObj, (String)"dum_link");
        String nubmer = "IMSC_ECC_MIGRATE";
        String databaseType = (String)this.getModel().getValue("databasetype");
        if ("381V34W0TMWR".equals(dumLinkId) || "SAP-RFC-Proxy".equals(databaseType)) {
            nubmer = "IMSC_ECC_AGENT_MIGRATE";
        }
        return BusinessDataServiceHelper.loadSingle((String)"isc_database_link", (QFilter[])new QFilter("number", "=", (Object)nubmer).toArray());
    }

    private void modifyLink() {
        this.setLinkFieldEnable(true);
        this.getView().setEnable(Boolean.TRUE, new String[]{"savelink"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"modifylink", "dblinktest"});
        this.getPageCache().put("modifylink", "modifylink");
    }
}

