/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.tpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.FilterGridUtil;
import kd.imsc.dmw.utils.StringUtils;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;

public class ManualPageParamFormPlugin
extends ImbdDymicTplEditPlugin {
    private static final String BASEFORMMODEL = "BaseFormModel";
    private static final String BILLFORMMODEL = "BillFormModel";
    private static final String PARAMETERFORMMODEL = "ParameterFormModel";
    private static final String DYNAMICFORMMODEL = "DynamicFormModel";
    private static final String REPORTFORMMODEL = "ReportFormModel";
    private static final String MOBILEFORMMODEL = "MobileFormModel";
    private static final String QUERYLISTMODEL = "QueryListModel";
    private static final String LOGBILLFORMMODEL = "LogBillFormModel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        JSONObject paramJson;
        String value;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String params = (String)parameter.getCustomParam("manualpageparam");
        if (StringUtils.isNotBlank(params) && StringUtils.isNotBlank(value = (paramJson = JSON.parseObject((String)params)).getString("parametertype"))) {
            this.getModel().setValue("parametertype", (Object)value);
        }
        this.setParameterOpenType();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String paramStr = CommonUtils.getStringCustomParamValue(this.getView(), "formnumber");
        String formNumber = "";
        if (this.isEntity() && !StringUtils.isEmpty(paramStr)) {
            formNumber = paramStr;
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGridUtil.setFilterControl(formNumber, filterGrid);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String params = (String)this.getView().getFormShowParameter().getCustomParam("manualpageparam");
        if (StringUtils.isNotBlank(params)) {
            JSONObject paramJson = JSON.parseObject((String)params);
            String filterConditionStr = paramJson.getString("filtercondition");
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            if (StringUtils.isNotBlank(filterConditionStr)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
                filterGrid.SetValue(filterCondition);
            } else {
                filterGrid.SetValue(new FilterCondition());
            }
        }
        this.getView().setEnable(Boolean.valueOf(this.isEntity()), new String[]{"filtergridap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String operateKey = control.getKey();
        if ("btnok".equals(operateKey)) {
            JSONObject jsonParamList = new JSONObject();
            String paramParameterType = (String)this.getModel().getValue("parametertype");
            String param = paramParameterType == null ? "" : paramParameterType;
            jsonParamList.put("parametertype", (Object)param);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition condition = filterGridState.getFilterCondition();
            if (condition != null && !condition.getFilterRow().isEmpty()) {
                jsonParamList.put("filtercondition", (Object)SerializationUtils.toJsonString((Object)condition));
            }
            this.getView().returnDataToParent((Object)jsonParamList);
            this.getView().close();
        }
    }

    private void setParameterOpenType() {
        String modeltype = CommonUtils.getStringCustomParamValue(this.getView(), "modeltype");
        if (modeltype.startsWith("ParameterFormModel_")) {
            modeltype = PARAMETERFORMMODEL;
        }
        ComboEdit parameterTypeCombo = (ComboEdit)this.getView().getControl("parametertype");
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(2);
        switch (modeltype) {
            case "DynamicFormModel": {
                itemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u52a8\u6001\u8868\u5355", (String)"ManualPageParamFormPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0])), "FormShowParameter"));
                parameterTypeCombo.setComboItems(itemList);
                break;
            }
            case "BillFormModel": {
                itemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e", (String)"ManualPageParamFormPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0])), "BillShowParameter"));
                itemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868", (String)"ManualPageParamFormPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0])), "ListShowParameter"));
                parameterTypeCombo.setComboItems(itemList);
                break;
            }
            case "BaseFormModel": {
                itemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ManualPageParamFormPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0])), "BaseShowParameter"));
                itemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868", (String)"ManualPageParamFormPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0])), "ListShowParameter"));
                parameterTypeCombo.setComboItems(itemList);
                break;
            }
            case "ReportFormModel": {
                itemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u62a5\u8868", (String)"ManualPageParamFormPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0])), "ReportShowParameter"));
                parameterTypeCombo.setComboItems(itemList);
                break;
            }
            case "ParameterFormModel": {
                itemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u53c2\u6570", (String)"ManualPageParamFormPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0])), "ParameterShowParameter"));
                parameterTypeCombo.setComboItems(itemList);
                break;
            }
            case "MobileFormModel": {
                itemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355", (String)"ManualPageParamFormPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0])), "MobileFormShowParameter"));
                parameterTypeCombo.setComboItems(itemList);
                break;
            }
            case "QueryListModel": 
            case "LogBillFormModel": {
                itemList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5217\u8868", (String)"ManualPageParamFormPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0])), "ListShowParameter"));
                parameterTypeCombo.setComboItems(itemList);
                break;
            }
            default: {
                itemList.add(new ComboItem(null, null));
                parameterTypeCombo.setComboItems(itemList);
            }
        }
        if (!itemList.isEmpty() && StringUtils.isBlank(this.getModel().getValue("parametertype"))) {
            this.getModel().setValue("parametertype", (Object)((ComboItem)itemList.get(0)).getValue());
        }
    }

    private boolean isEntity() {
        String modelType = CommonUtils.getStringCustomParamValue(this.getView(), "modeltype");
        return StringUtils.equals(modelType, BASEFORMMODEL) || StringUtils.equals(modelType, BILLFORMMODEL);
    }
}

