/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.formplugin.tpl;

import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.IFormMutexService;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imsc.dmw.errorcode.DmwBizException;
import kd.imsc.dmw.helper.PermissionHelper;
import kd.imsc.imbd.formplugin.tpl.ImbdBdTplListPlugin;

public class MigrateProjectListPlugin
extends ImbdBdTplListPlugin {
    private static final Log log = LogFactory.getLog(MigrateProjectListPlugin.class);
    private static final String TBL_NEW = "tblnew";
    private static final String TBL_COPY = "tblcopy";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TBL_NEW, TBL_COPY});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (TBL_NEW.equals(itemKey)) {
            PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "47156aff000000ac");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(this.getUserGuideFormId());
            parameter.setCustomParam("openPageForm", (Object)this.getUserGuideFormId());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
            evt.setCancel(true);
        } else if (TBL_COPY.equals(itemKey)) {
            PermissionHelper.checkPermission(this.getView(), "dmw_migrateproject", "47156aff000000ac");
            if (this.getSelectedRows().size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"MigrateProjectListPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            } else if (this.getSelectedRows().isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"MigrateProjectListPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            } else {
                Long projectId = (Long)this.getSelectedRows().get(0).getPrimaryKeyValue();
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId(this.getUserGuideFormId());
                parameter.setCustomParam("projectid", (Object)projectId);
                parameter.setCustomParam("isCopy", (Object)Boolean.TRUE);
                parameter.setCustomParam("openPageForm", (Object)this.getUserGuideFormId());
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
            }
            evt.setCancel(true);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (!"number".equals(fieldName)) {
            return;
        }
        args.setCancel(true);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        String pkId = String.valueOf(currentRow.getPrimaryKeyValue());
        MutexLockInfo lockInfo = new MutexLockInfo(pkId, currentRow.getNumber(), null, this.getBillFormId(), "modify", true, "default");
        StringBuilder errMsg = new StringBuilder();
        boolean require = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)errMsg);
        if (!require) {
            this.showMutexConfirm(pkId, errMsg);
            return;
        }
        this.showMigrateUserGuideEditForm(currentRow.getPrimaryKeyValue(), OperationStatus.EDIT);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("markcomplete".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && "lockedConfirm".equalsIgnoreCase(callBackId)) {
            String callbackValue = messageBoxClosedEvent.getCustomVaule();
            if (StringUtils.isEmpty((CharSequence)callbackValue)) {
                this.getView().invokeOperation("view");
                return;
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)callbackValue, Map.class);
            String operationKey = (String)map.get("operateKey");
            String entityId = (String)map.get("entityId");
            String pkValue = (String)map.get("pkvalue");
            Map<String, String> info = this.getLockInfo(pkValue, entityId, operationKey);
            String lockSessionId = info.get("GLOBALSESSION");
            String lockUserId = info.get("userid");
            OperationStatus operationStatus = OperationStatus.VIEW;
            if (String.valueOf(UserServiceHelper.getCurrentUserId()).equals(lockUserId)) {
                if (RequestContext.get().getGlobalSessionId().equals(lockSessionId)) {
                    this.showMigrateUserGuideEditForm(pkValue, OperationStatus.VIEW);
                } else if ("web".equals(RequestContext.get().getClient())) {
                    IFormMutexService service = (IFormMutexService)this.getView().getService(IFormMutexService.class);
                    if (service != null) {
                        service.destoryLockingPage(entityId, (Object)pkValue, operationKey, true);
                    } else {
                        MutexHelper.clearErrLockByWebSocket((String)entityId, (Object)pkValue, (String)operationKey);
                    }
                    operationStatus = OperationStatus.EDIT;
                } else {
                    operationStatus = OperationStatus.VIEW;
                }
            } else {
                operationStatus = OperationStatus.VIEW;
            }
            this.showMigrateUserGuideEditForm(pkValue, operationStatus);
        }
    }

    private void showMigrateUserGuideEditForm(Object id, OperationStatus operationStatus) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(this.getUserGuideFormId());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("projectid", id);
        parameter.setCustomParam("openPageForm", (Object)this.getUserGuideFormId());
        parameter.setStatus(operationStatus);
        if (this.getView() != null) {
            parameter.setPageId(id + this.getView().getFormShowParameter().getParentPageId() + parameter.getFormId());
            this.getView().showForm(parameter);
        }
    }

    private void showMutexConfirm(String pkId, StringBuilder errMsg) {
        Map<String, String> info = this.getLockInfo(pkId, this.getBillFormId(), "modify");
        String userId = info.get("userid");
        String lockSessionId = info.get("GLOBALSESSION");
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        if (StringUtils.equals((CharSequence)userId, (CharSequence)String.valueOf(UserServiceHelper.getCurrentUserId())) && RequestContext.get().getGlobalSessionId().equals(lockSessionId)) {
            this.showMigrateUserGuideEditForm(pkId, OperationStatus.EDIT);
            return;
        }
        if (StringUtils.equals((CharSequence)userId, (CharSequence)String.valueOf(UserServiceHelper.getCurrentUserId())) && !RequestContext.get().getGlobalSessionId().equals(lockSessionId) && "web".equals(RequestContext.get().getClient())) {
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u7a0d\u540e\u518d\u8bd5", (String)"MigrateProjectListPlugin_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5f3a\u5236\u8e22\u51fa", (String)"MigrateProjectListPlugin_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        } else {
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MigrateProjectListPlugin_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u67e5\u770b\u5355\u636e", (String)"MigrateProjectListPlugin_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("lockedConfirm", (IFormPlugin)this);
        HashMap<String, String> callbackValue = new HashMap<String, String>(4);
        callbackValue.put("operateKey", "modify");
        callbackValue.put("entityId", this.getBillFormId());
        callbackValue.put("pkvalue", pkId);
        this.getView().showConfirm(errMsg.toString(), null, MessageBoxOptions.YesNo, null, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(callbackValue));
    }

    private Map<String, String> getLockInfo(String objectId, String entityKey, String operationKey) {
        Map lockInfo = null;
        try (DataMutex dataMutex = DataMutex.create();){
            String groupId = MutexHelper.getMutexGroupId((String)entityKey, (String)operationKey);
            lockInfo = dataMutex.getLockInfo(String.valueOf(objectId), groupId, entityKey);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new DmwBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e92\u65a5\u9501\u4fe1\u606f\u5931\u8d25", (String)"MigrateProjectListPlugin_6", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e);
        }
        return lockInfo;
    }

    private String getBillFormId() {
        return this.getListView().getBillFormId();
    }

    private String getUserGuideFormId() {
        String formId = this.getListView().getBillFormId();
        String userGuideFormId = "dmw_migrateuserguide";
        switch (formId) {
            case "dmw_migrateproject_eas": {
                userGuideFormId = "dmw_migrateuserguide_eas";
                break;
            }
            case "dmw_migrateproject_nc": {
                userGuideFormId = "dmw_migrateuserguide_nc";
                break;
            }
            case "dmw_migrateproject_ecc": {
                userGuideFormId = "dmw_migrateuserguide_ecc";
                break;
            }
        }
        return userGuideFormId;
    }
}

