/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.opplugin.reportpush;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.imbd.opplugin.AbstractImbdOp;

public class PushReportConfirmOp
extends AbstractImbdOp {
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String reportType;
        super.endOperationTransaction(e);
        DynamicObject confirmDataDynObj = e.getDataEntities()[0];
        long modelId = confirmDataDynObj.getLong("bcmmodelid");
        String modelNumber = confirmDataDynObj.getString("bcmmodelnumber");
        String result = this.validateModel(modelId, modelNumber);
        if (StringUtil.isNotEmpty(result)) {
            OperateErrorInfo errorInfo = new OperateErrorInfo("validateErrorCode", ErrorLevel.Error, (Object)0);
            errorInfo.setMessage(result);
            this.getOperationResult().addErrorInfo(errorInfo);
            return;
        }
        switch (reportType = this.getOption().getVariableValue("reporttype")) {
            case "1": {
                DynamicObjectCollection fiReportDynObjColl = this.queryEasFiReportColl();
                if (CommonUtils.isNull(fiReportDynObjColl)) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("validateErrorCode", ErrorLevel.Error, (Object)0);
                    errorInfo.setMessage(ResManager.loadKDString((String)"EAS\u8d22\u52a1\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u518d\u63a8\u9001\u3002", (String)"PushReportConfirmOp_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    this.getOperationResult().addErrorInfo(errorInfo);
                    return;
                }
                DynamicObject recordDynObj = this.createReportPushRecordByFi(confirmDataDynObj, fiReportDynObjColl);
                OperationResult optResult = OperationServiceHelper.executeOperate((String)"save", (String)"dmw_reportpushrecord", (DynamicObject[])new DynamicObject[]{recordDynObj}, (OperateOption)CommonUtils.getOperateOption(true));
                if (!optResult.isSuccess()) {
                    this.getOperationResult().mergeOperateResult(optResult);
                    break;
                }
                this.operateOption.setVariableValue("pushRecordId", recordDynObj.getPkValue().toString());
                List recordEntryIdList = recordDynObj.getDynamicObjectCollection("entryentity").stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                this.operateOption.setVariableValue("pushRecordEntryIdList", SerializationUtils.toJsonString(recordEntryIdList));
                break;
            }
            case "2": {
                DynamicObjectCollection mergeReportDynObjColl = this.queryEasMergeReportColl();
                if (CommonUtils.isNull(mergeReportDynObjColl)) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("validateErrorCode", ErrorLevel.Error, (Object)0);
                    errorInfo.setMessage(ResManager.loadKDString((String)"EAS\u5408\u5e76\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u518d\u63a8\u9001\u3002", (String)"PushReportConfirmOp_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                    this.getOperationResult().addErrorInfo(errorInfo);
                    return;
                }
                DynamicObject mergePushecordDynObj = this.createReportPushRecordByMerge(confirmDataDynObj, mergeReportDynObjColl);
                OperationResult pushOptResult = OperationServiceHelper.executeOperate((String)"save", (String)"dmw_reportpushrecord", (DynamicObject[])new DynamicObject[]{mergePushecordDynObj}, (OperateOption)CommonUtils.getOperateOption(true));
                if (!pushOptResult.isSuccess()) {
                    this.getOperationResult().mergeOperateResult(pushOptResult);
                    break;
                }
                this.operateOption.setVariableValue("pushRecordId", mergePushecordDynObj.getPkValue().toString());
                List recordEntryIdList = mergePushecordDynObj.getDynamicObjectCollection("entryentity").stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                this.operateOption.setVariableValue("pushRecordEntryIdList", SerializationUtils.toJsonString(recordEntryIdList));
                break;
            }
        }
    }

    private DynamicObjectCollection queryEasFiReportColl() {
        List reportIdList = (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("reportIds"), List.class);
        String selectFields = String.join((CharSequence)",", "id", "number", "name", "orgunitid.id", "orgunitid.number", "orgunitid.name", "reportcycle", "reportyear", "reportperiod", "reporttime", "currency.name", "template");
        QFilter filter = new QFilter("id", "in", (Object)reportIdList);
        return QueryServiceHelper.query((String)"dmw_fi_report_eas", (String)selectFields, (QFilter[])filter.toArray(), (String)"reporttime desc,orgunitid.name asc,number asc");
    }

    private DynamicObject createReportPushRecordByFi(DynamicObject confirmDataDynObj, DynamicObjectCollection reportDynObjColl) {
        DynamicObject recordDynObj = BusinessDataServiceHelper.newDynamicObject((String)"dmw_reportpushrecord");
        recordDynObj.set("reporttype", (Object)"1");
        recordDynObj.set("bcmmodelid", (Object)confirmDataDynObj.getString("bcmmodelid"));
        recordDynObj.set("bcmmodelnumber", (Object)confirmDataDynObj.getString("bcmmodelnumber"));
        recordDynObj.set("bcmmodelname", (Object)confirmDataDynObj.getString("bcmmodelname"));
        recordDynObj.set("pushstatus", (Object)"1");
        recordDynObj.set("pushgrogress", (Object)String.format("0/%s", reportDynObjColl.size()));
        recordDynObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection recordEntryColl = recordDynObj.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject reportDynObj : reportDynObjColl) {
            DynamicObject recordEntryDynObj = recordEntryColl.addNew();
            recordEntryDynObj.set("seq", (Object)seq++);
            recordEntryDynObj.set("reportnumber", (Object)reportDynObj.getString("number"));
            recordEntryDynObj.set("periodname", (Object)reportDynObj.getString("reporttime"));
            recordEntryDynObj.set("templatename", (Object)reportDynObj.getString("template"));
            recordEntryDynObj.set("pushsubstatus", (Object)"1");
            long reportId = reportDynObj.getLong("id");
            recordEntryDynObj.set("reportid", (Object)reportId);
            recordEntryDynObj.set("orgname", (Object)reportDynObj.getString("orgunitid.name"));
            recordEntryDynObj.set("orgnumber", (Object)reportDynObj.getString("orgunitid.number"));
            recordEntryDynObj.set("reportcycle", (Object)reportDynObj.getString("reportcycle"));
            recordEntryDynObj.set("reportname", (Object)reportDynObj.getString("name"));
            String yearNumber = "FY" + reportDynObj.getInt("reportyear");
            int period = reportDynObj.getInt("reportperiod");
            String periodNumber = "M_M" + period;
            if (period < 10) {
                periodNumber = "M_M0" + period;
            }
            recordEntryDynObj.set("yearnumber", (Object)yearNumber);
            recordEntryDynObj.set("periodnumber", (Object)periodNumber);
            recordEntryDynObj.set("currencyname", (Object)reportDynObj.getString("currency.name"));
        }
        return recordDynObj;
    }

    private DynamicObjectCollection queryEasMergeReportColl() {
        List reportIdList = (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("reportIds"), List.class);
        String selectFields = String.join((CharSequence)",", "id", "number", "name", "orgmergenumber", "orgmergename", "periodtype", "year", "period", "periodname", "currencyid.name", "orgtreename", "templatename");
        QFilter filter = new QFilter("id", "in", (Object)reportIdList);
        return QueryServiceHelper.query((String)"dmw_fi_mergereport_eas", (String)selectFields, (QFilter[])filter.toArray(), (String)"periodname desc,orgmergenumber asc,orgmergename asc,orgtreenumber asc,number asc");
    }

    private DynamicObject createReportPushRecordByMerge(DynamicObject confirmDataDynObj, DynamicObjectCollection reportDynObjColl) {
        DynamicObject recordDynObj = BusinessDataServiceHelper.newDynamicObject((String)"dmw_reportpushrecord");
        recordDynObj.set("reporttype", (Object)"2");
        recordDynObj.set("bcmmodelid", (Object)confirmDataDynObj.getString("bcmmodelid"));
        recordDynObj.set("bcmmodelnumber", (Object)confirmDataDynObj.getString("bcmmodelnumber"));
        recordDynObj.set("bcmmodelname", (Object)confirmDataDynObj.getString("bcmmodelname"));
        recordDynObj.set("pushstatus", (Object)"1");
        recordDynObj.set("pushgrogress", (Object)String.format("0/%s", reportDynObjColl.size()));
        recordDynObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection recordEntryColl = recordDynObj.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject reportDynObj : reportDynObjColl) {
            DynamicObject recordEntryDynObj = recordEntryColl.addNew();
            recordEntryDynObj.set("seq", (Object)seq++);
            recordEntryDynObj.set("reportnumber", (Object)reportDynObj.getString("number"));
            recordEntryDynObj.set("orgname", (Object)reportDynObj.getString("orgmergename"));
            recordEntryDynObj.set("periodname", (Object)reportDynObj.getString("periodname"));
            recordEntryDynObj.set("templatename", (Object)reportDynObj.getString("templatename"));
            recordEntryDynObj.set("orgtreename", (Object)reportDynObj.getString("orgtreename"));
            recordEntryDynObj.set("pushsubstatus", (Object)"1");
            long reportId = reportDynObj.getLong("id");
            recordEntryDynObj.set("reportid", (Object)reportId);
            recordEntryDynObj.set("orgnumber", (Object)reportDynObj.getString("orgmergenumber"));
            recordEntryDynObj.set("reportcycle", (Object)reportDynObj.getString("periodtype"));
            recordEntryDynObj.set("reportname", (Object)reportDynObj.getString("name"));
            String yearNumber = "FY" + reportDynObj.getInt("year");
            int period = reportDynObj.getInt("period");
            String periodNumber = "M_M" + period;
            if (period < 10) {
                periodNumber = "M_M0" + period;
            }
            recordEntryDynObj.set("yearnumber", (Object)yearNumber);
            recordEntryDynObj.set("periodnumber", (Object)periodNumber);
            recordEntryDynObj.set("currencyname", (Object)reportDynObj.getString("currencyid.name"));
        }
        return recordDynObj;
    }

    private String validateModel(long modelId, String modelNumber) {
        String result = "";
        if (!QueryServiceHelper.exists((String)"bcm_model", (Object)modelId)) {
            result = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7f16\u7801:%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u68c0\u67e5\u524d\u7f6e\u6761\u4ef6\u5b8c\u6210\u540e\u518d\u63a8\u9001\u3002", (String)"PushReportConfirmOp_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), modelNumber);
        }
        return result;
    }
}

