/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.opplugin.tpl.migratecheckitem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.helper.tpl.MigrateCheckItemHelper;
import kd.imsc.dmw.helper.tpl.MigrateUserGuideProjectHelper;
import kd.imsc.dmw.utils.StringUtil;
import kd.imsc.imbd.validator.AbstractImbdValidator;

public class MigrateCheckItemSaveValidator
extends AbstractImbdValidator {
    private static final String[] checkStatus = new String[]{"A", "B", "C"};

    public Set<String> preparePropertys() {
        Set strings = super.preparePropertys();
        strings.add("serviceflowid");
        return strings;
    }

    public void validate() {
        int size = this.getDataEntities().length;
        HashSet<Long> serviceFlowIdSet = new HashSet<Long>(size);
        Map<Object, DynamicObject> dbCheckItem = this.getDbCheckItem();
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            long serviceFlowId = rowDataEntity.getDataEntity().getLong("serviceflowid");
            serviceFlowIdSet.add(serviceFlowId);
            this.checkParamStatus(rowDataEntity, dbCheckItem);
            DynamicObjectCollection paramEntry = rowDataEntity.getDataEntity().getDynamicObjectCollection("paramentry");
            for (DynamicObject entry : paramEntry) {
                String values = entry.getString("defaultvalue");
                String datatype = entry.getString("varsign.datatype");
                String[] valuesSplit = values.split(";");
                int seq = entry.getInt("seq");
                block12: for (String value : valuesSplit) {
                    if (StringUtil.isEmpty(value) || datatype == null) continue;
                    switch (datatype) {
                        case "A": {
                            if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) continue block12;
                            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u8303\u56f4\u53d8\u91cf\u8bbe\u7f6e\u7b2c%s\u884c\u8f93\u5165\u53c2\u6570\u9ed8\u8ba4\u503c\u9519\u8bef\u3002", (String)"MigrateCheckItemSaveValidator_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), seq));
                            continue block12;
                        }
                        case "B": {
                            if (MigrateUserGuideProjectHelper.isNumeric(value)) continue block12;
                            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u8303\u56f4\u53d8\u91cf\u8bbe\u7f6e\u7b2c%s\u884c\u8f93\u5165\u53c2\u6570\u9ed8\u8ba4\u503c\u683c\u5f0f\u9519\u8bef\uff0c\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u7c7b\u578b\u3002", (String)"MigrateCheckItemSaveValidator_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), seq));
                            continue block12;
                        }
                        case "C": {
                            if (MigrateUserGuideProjectHelper.isDateFormatValid(value)) continue block12;
                            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u8303\u56f4\u53d8\u91cf\u8bbe\u7f6e\u7b2c%s\u884c\u8f93\u5165\u53c2\u6570\u9ed8\u8ba4\u503c\u683c\u5f0f\u9519\u8bef\uff0c\u53ea\u80fd\u6309\uff08\u5e74/\u6708/\u65e5\uff09\u683c\u5f0f\u586b\u5199\u3002", (String)"MigrateCheckItemSaveValidator_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), seq));
                            continue block12;
                        }
                    }
                }
            }
        }
        Map<Long, String> errorMsgMap = MigrateCheckItemHelper.verifyServiceFlowDefine(serviceFlowIdSet);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            long serviceFlowId = rowDataEntity.getDataEntity().getLong("serviceflowid");
            if (!errorMsgMap.containsKey(serviceFlowId)) continue;
            this.addErrorMessage(rowDataEntity, errorMsgMap.get(serviceFlowId));
        }
    }

    private Map<Object, DynamicObject> getDbCheckItem() {
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            Object pkValue = dataEntity.getDataEntity().getPkValue();
            ids.add(pkValue);
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)"dmw_migratecheckitem_eas");
    }

    private void checkParamStatus(ExtendedDataEntity rowDataEntity, Map<Object, DynamicObject> dbCheckItem) {
        DynamicObjectCollection paramEntry = rowDataEntity.getDataEntity().getDynamicObjectCollection("paramentry");
        DynamicObject dbCheck = dbCheckItem.get(rowDataEntity.getBillPkId());
        if (dbCheck == null) {
            return;
        }
        DynamicObjectCollection dbCheckEntry = dbCheck.getDynamicObjectCollection("paramentry");
        boolean isUpdate = false;
        if (paramEntry.size() != dbCheckEntry.size()) {
            isUpdate = true;
        }
        Set varsigns = paramEntry.stream().map(n -> n.getDynamicObject("varsign").getPkValue()).collect(Collectors.toSet());
        for (DynamicObject dbCheckE : dbCheckEntry) {
            Object dbVarsign = dbCheckE.getDynamicObject("varsign").getPkValue();
            if (varsigns.contains(dbVarsign)) continue;
            isUpdate = true;
        }
        if (!isUpdate) {
            return;
        }
        QFilter qFilter = new QFilter("checkparamentry.checkitemvar", "=", rowDataEntity.getBillPkId());
        List<String> strings = Arrays.asList(checkStatus);
        qFilter.and("checkparamentry.checkstatusvar", "in", strings);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"dmw_migrateproject_eas", (String)"id,number,name", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject dobj : query) {
                String number = dobj.getString("number");
                String name = dobj.getString("name");
                String param = name + "(" + number + ")";
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u8fc1\u79fb\u5bfc\u822a%s\u5b58\u5728\u672a\u68c0\u67e5\uff0c\u68c0\u67e5\u4e2d\uff0c\u68c0\u67e5\u5931\u8d25\u7684\u68c0\u67e5\u9879\uff0c\u4e0d\u5141\u8bb8\u589e\u51cf\u68c0\u67e5\u8303\u56f4\u53d8\u91cf\u53c2\u6570\u8bbe\u7f6e\u3002", (String)"MigrateCheckItemSaveValidator_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), param));
            }
        }
    }
}

