/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.plugin.opplugin.tpl.migrateobject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.helper.tpl.MigrateSchemeHelper;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.imbd.validator.AbstractImbdValidator;

public class MigrateObjectSaveValidator
extends AbstractImbdValidator {
    public Set<String> preparePropertys() {
        Set strings = super.preparePropertys();
        strings.add("issupportinit");
        strings.add("issupportall");
        strings.add("easobjectrelys");
        strings.add("initintegrattype");
        strings.add("allintegrattype");
        strings.add("initschemename");
        strings.add("allschemename");
        strings.add(String.join((CharSequence)".", "easobjectrelys", "name"));
        return strings;
    }

    public void validate() {
        Map<Object, List<DynamicObject>> map = this.buildSchemeNameMap();
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            this.checkRelyMigrateObj(rowDataEntity);
            this.checkMigrateScheme(map, rowDataEntity);
        }
    }

    private void checkRelyMigrateObj(ExtendedDataEntity rowDataEntity) {
        DynamicObject bill = rowDataEntity.getDataEntity();
        boolean curInit = bill.getBoolean("issupportinit");
        boolean curAll = bill.getBoolean("issupportall");
        DynamicObjectCollection relyObjs = bill.getDynamicObjectCollection("easobjectrelys");
        for (DynamicObject relyObj : relyObjs) {
            String msg;
            DynamicObject rely = relyObj.getDynamicObject("fbasedataid");
            if (rely == null) continue;
            String name = rely.getString("name");
            boolean init = rely.getBoolean("issupportinit");
            boolean all = rely.getBoolean("issupportall");
            if (!init && !all) {
                msg = String.format(ResManager.loadKDString((String)"\u4f9d\u8d56\u8fc1\u79fb\u5bf9\u8c61\u201c%s\u201d\u4e0d\u652f\u6301\u8fc1\u79fb\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MigrateObjectSaveValidator_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), name);
                this.addMessage(rowDataEntity, msg);
            }
            if (!curInit && !curAll) continue;
            if (curInit && !init) {
                msg = String.format(ResManager.loadKDString((String)"\u4f9d\u8d56\u8fc1\u79fb\u5bf9\u8c61\u201c%s\u201d\u652f\u6301\u521d\u59cb\u5316\u8fc1\u79fb\uff0c\u4f46\u5f53\u524d\u5bf9\u8c61\u4e0d\u652f\u6301\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MigrateObjectSaveValidator_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), name);
                this.addMessage(rowDataEntity, msg);
            }
            if (!curAll || all) continue;
            msg = String.format(ResManager.loadKDString((String)"\u4f9d\u8d56\u8fc1\u79fb\u5bf9\u8c61\u201c%s\u201d\u652f\u6301\u5168\u91cf\u8fc1\u79fb\uff0c\u4f46\u5f53\u524d\u5bf9\u8c61\u4e0d\u652f\u6301\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MigrateObjectSaveValidator_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), name);
            this.addMessage(rowDataEntity, msg);
        }
    }

    private void checkMigrateScheme(Map<Object, List<DynamicObject>> map, ExtendedDataEntity rowDataEntity) {
        List<DynamicObject> schemes = map.get(rowDataEntity.getBillPkId());
        if (schemes != null && !schemes.isEmpty()) {
            boolean init = rowDataEntity.getDataEntity().getBoolean("issupportinit");
            boolean all = rowDataEntity.getDataEntity().getBoolean("issupportall");
            for (DynamicObject scheme : schemes) {
                boolean result;
                String schemeName = scheme.getString("name");
                String migrateModel = scheme.getString("migrationmodel");
                Set mulcomboSet = DynamicObjectUtils.getMulcomboSet((String)migrateModel);
                boolean bl = result = !init && mulcomboSet.contains("A") || !all && mulcomboSet.contains("B");
                if (mulcomboSet.contains("A") && mulcomboSet.contains("B")) {
                    if (init && all) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u8fc1\u79fb\u5bf9\u8c61\u5df2\u5305\u542b\u5728\u521d\u59cb\u5316\u8fc1\u79fb\u548c\u5168\u91cf\u8fc1\u79fb\u65b9\u6848[%1$s]\u4e2d\uff0c\u8bf7\u52fe\u9009\u521d\u59cb\u5316\u8fc1\u79fb\u4fe1\u606f\u548c\u5168\u91cf\u8fc1\u79fb\u4fe1\u606f\u3002", (String)"MigrateObjectSaveValidator_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), schemeName);
                    this.addMessage(rowDataEntity, msg);
                    continue;
                }
                if (!result) continue;
                String initName = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8fc1\u79fb", (String)"MigrateObjectSaveValidator_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                String allName = ResManager.loadKDString((String)"\u5168\u91cf\u8fc1\u79fb", (String)"MigrateObjectSaveValidator_5", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                String modelName = mulcomboSet.contains("A") ? initName : allName;
                String msg = String.format(ResManager.loadKDString((String)"\u8fc1\u79fb\u5bf9\u8c61\u5df2\u5305\u542b\u5728\u201c%1$s\u201d\u65b9\u6848[%2$s]\u4e2d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u652f\u6301%3$s\u3002", (String)"MigrateObjectSaveValidator_6", (String)"imsc-dmw-platform", (Object[])new Object[0]), modelName, schemeName, modelName);
                this.addMessage(rowDataEntity, msg);
                return;
            }
        }
    }

    private Map<Object, List<DynamicObject>> buildSchemeNameMap() {
        ArrayList<Object> list = new ArrayList<Object>(16);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            if ((Long)rowDataEntity.getBillPkId() == 0L) continue;
            list.add(rowDataEntity.getBillPkId());
        }
        String formId = this.getDataEntities()[0].getDataEntity().getDynamicObjectType().getName();
        String schemeFormId = MigrateSchemeHelper.getSchemeFormIdByMigrateObject(formId);
        QFilter qFilter = new QFilter("treeentryentity.migrateobject", "in", list);
        DynamicObjectCollection dmwSchemeEas = QueryServiceHelper.query((String)schemeFormId, (String)"id,name,treeentryentity.migrateobject migrateobject,migrationmodel", (QFilter[])qFilter.toArray());
        HashMap<Object, List<DynamicObject>> map = new HashMap<Object, List<DynamicObject>>(16);
        for (DynamicObject dynamicObject : dmwSchemeEas) {
            Long migObject = dynamicObject.getLong("migrateobject");
            map.putIfAbsent(migObject, new ArrayList(4));
            List scheme = (List)map.get(migObject);
            scheme.add(dynamicObject);
        }
        return map;
    }
}

