/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.OperationUtils;

public class IscUtils {
    public static void updateDatasource(Long inputDbLink, String projectFormId) {
        String number = "";
        switch (projectFormId) {
            case "dmw_migrateproject_eas": {
                number = "KDEAS850";
                break;
            }
            case "dmw_migrateproject_nc": {
                number = "KDNC65";
                break;
            }
            case "dmw_migrateproject_ecc": {
                number = "KDECC6";
                break;
            }
            default: {
                return;
            }
        }
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject[] dataSourceDynObjs = BusinessDataServiceHelper.load((String)"isc_data_source", (String)"number,dblink,connection_type", (QFilter[])filter.toArray());
        IscUtils.doUpdate(dataSourceDynObjs, inputDbLink);
    }

    public static void updateDatasource(List<Long> triggerIds, List<Long> flowIds, Long inputDbLink) {
        Map triggers = new HashMap(16);
        Map flows = new HashMap(16);
        if (CollectionUtils.isNotEmpty(triggerIds)) {
            triggers = BusinessDataServiceHelper.loadFromCache((String)"isc_data_copy_trigger", (String)"number, name,data_copy,params_entryentity.params_name,params_entryentity.params_value,params_entryentity.params_data_type", (QFilter[])new QFilter("id", "in", triggerIds).toArray());
        }
        if (CollectionUtils.isNotEmpty(flowIds)) {
            flows = BusinessDataServiceHelper.loadFromCache((String)"isc_service_flow", (String)"number, name,variables.var_name,variables.default_value,variables.is_input_param,resources.res_category,resources.res_ref", (QFilter[])new QFilter("id", "in", flowIds).toArray());
        }
        HashSet<Object> dbLinks = new HashSet<Object>(16);
        List dataCopyIds = triggers.values().stream().map(n -> n.getDynamicObject("data_copy").getPkValue()).collect(Collectors.toList());
        Map iscDataCopy = BusinessDataServiceHelper.loadFromCache((String)"isc_data_copy", (String)"id,data_source", (QFilter[])new QFilter("id", "in", dataCopyIds).toArray());
        Set dataSourceIds = iscDataCopy.values().stream().map(n -> n.getDynamicObject("data_source").getPkValue()).collect(Collectors.toSet());
        dbLinks.addAll(dataSourceIds);
        for (DynamicObject flow : flows.values()) {
            DynamicObjectCollection resources = flow.getDynamicObjectCollection("resources");
            for (DynamicObject resource : resources) {
                if (!"isc_data_source".equals(resource.getString("res_category"))) continue;
                DynamicObject resRef = resource.getDynamicObject("res_ref");
                dbLinks.add(resRef.getPkValue());
            }
        }
        QFilter filter = new QFilter("id", "in", dbLinks);
        DynamicObject[] dataSourceDynObjs = BusinessDataServiceHelper.load((String)"isc_data_source", (String)"number,dblink,connection_type", (QFilter[])filter.toArray());
        IscUtils.doUpdate(dataSourceDynObjs, inputDbLink);
    }

    public static void updateDatasourceByApi(List<Long> apiIds, Long inputDbLink) {
        Map apiDatas = new HashMap(16);
        if (CollectionUtils.isNotEmpty(apiIds)) {
            apiDatas = BusinessDataServiceHelper.loadFromCache((String)"isc_apic_script", (String)"number, name,resources.res_category,resources.res_ref", (QFilter[])new QFilter("id", "in", apiIds).toArray());
        }
        HashSet<Object> dbLinks = new HashSet<Object>(16);
        for (DynamicObject api : apiDatas.values()) {
            DynamicObjectCollection resources = api.getDynamicObjectCollection("resources");
            for (DynamicObject resource : resources) {
                if (!"isc_data_source".equals(resource.getString("res_category"))) continue;
                DynamicObject resRef = resource.getDynamicObject("res_ref");
                dbLinks.add(resRef.getPkValue());
            }
        }
        QFilter filter = new QFilter("id", "in", dbLinks);
        DynamicObject[] dataSourceDynObjs = BusinessDataServiceHelper.load((String)"isc_data_source", (String)"number,dblink,connection_type", (QFilter[])filter.toArray());
        IscUtils.doUpdate(dataSourceDynObjs, inputDbLink);
    }

    private static void doUpdate(DynamicObject[] dataSourceDynObjs, Long inputDbLink) {
        DynamicObject linDynObj = BusinessDataServiceHelper.loadSingle((Object)inputDbLink, (String)"isc_database_link");
        for (DynamicObject source : dataSourceDynObjs) {
            String number;
            DynamicObject dblink = source.getDynamicObject("dblink");
            if (dblink != null && inputDbLink.equals(dblink.getPkValue()) || !"KDEAS850".equalsIgnoreCase(number = source.getString("number")) && !"KDNC65".equalsIgnoreCase(number) && !"KDECC6".equalsIgnoreCase(number)) continue;
            source.set("dblink", (Object)inputDbLink);
            source.set("connection_type", (Object)DynamicObjectUtils.getString((DynamicObject)linDynObj.getDynamicObject("dum_link"), (String)"number"));
        }
        OperationUtils.OperateSingleDynamic("save", "isc_data_source", Arrays.asList(dataSourceDynObjs));
    }
}

