/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.utils;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class StringUtil {
    public static final String DOT = ".";
    public static final char DOT_CHAR = '.';
    public static final String EmptyString = "";
    public static final String COMMA = ",";

    private StringUtil() {
    }

    public static String trim(String s, String defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return (s = s.trim()).length() == 0 ? defaultValue : s;
    }

    public static final boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static final boolean isEmpty(Object s) {
        if (s instanceof DynamicObjectCollection) {
            return ((DynamicObjectCollection)s).isEmpty();
        }
        return s == null || s.toString().trim().length() == 0;
    }

    public static final boolean isNotEmpty(String s) {
        return !StringUtil.isEmpty(s);
    }

    public static final boolean isNotEmpty(Object s) {
        return !StringUtil.isEmpty(s);
    }

    public static final String urlEncode(String s) {
        String encodeStr = null;
        try {
            encodeStr = URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
        return encodeStr;
    }

    public static final String urlDecode(String s) {
        String decodeStr = null;
        try {
            decodeStr = URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
        return decodeStr;
    }

    public static boolean areNotEmpty(String[] values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            for (String value : values) {
                result &= !StringUtil.isEmpty(value);
            }
        }
        return result;
    }

    public static String join(CharSequence delimiter, Object ... elements) {
        StringBuilder sbStr = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            sbStr.append(elements[i]).append(delimiter);
        }
        if (sbStr.length() > 0) {
            sbStr.deleteCharAt(sbStr.length() - delimiter.length());
        }
        return sbStr.toString();
    }

    public static final List<Long> convertToLong(String[] strs) {
        int length = strs == null ? 0 : strs.length;
        ArrayList<Long> list = new ArrayList<Long>(length);
        if (length == 0) {
            return list;
        }
        for (int i = 0; i < length; ++i) {
            list.add(Long.parseLong(strs[i]));
        }
        return list;
    }

    public static boolean isNull(String o) {
        return o == null || o.trim().equals(EmptyString);
    }

    public static boolean isNull(Object o) {
        return o == null || StringUtil.isNull(o.toString());
    }

    public static boolean isNotNull(String o) {
        return o != null && o.trim().length() > 0;
    }

    public static final String toLowerCase(String o) {
        return StringUtil.isNotNull(o) ? o.toLowerCase() : o;
    }

    public static final String toLowerCase(Object o) {
        return StringUtil.isNotNull(o) ? o.toString().toLowerCase() : EmptyString;
    }

    public static boolean isNotNull(Object o) {
        return o != null && StringUtil.isNotNull(o.toString());
    }

    public static String join(Object[] strs, String splitChar) {
        if (strs == null) {
            return EmptyString;
        }
        return StringUtil.join(strs, strs.length - 1, splitChar);
    }

    public static String join(Collection<?> c, String seperator) {
        if (CollectionUtils.isEmpty(c)) {
            return EmptyString;
        }
        Object[] objects = c.toArray();
        return StringUtil.join(objects, seperator);
    }

    public static String joinToSql(List<String> c, String seperator) {
        if (CollectionUtils.isEmpty(c)) {
            return EmptyString;
        }
        Object[] objects = new Object[c.size()];
        for (int i = 0; i < c.size(); ++i) {
            String o = c.get(i);
            objects[i] = "'" + o + "'";
        }
        return StringUtil.join(objects, seperator);
    }

    public static String join(Object[] strs, int maxIndex, String splitChar) {
        if (strs == null) {
            return EmptyString;
        }
        if (maxIndex == -1) {
            return EmptyString;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(strs[i]);
            if (i == maxIndex) {
                return b.toString();
            }
            b.append(splitChar);
            ++i;
        }
    }

    public static List<String> toList(String strs) {
        if (StringUtils.isNull((String)strs)) {
            return new ArrayList<String>(0);
        }
        return Arrays.asList(strs.split(COMMA));
    }

    public static String getEmptyString() {
        return EmptyString;
    }

    public static String getErrorMsg(Exception e) {
        StackTraceElement[] traceElements;
        StringBuilder a = new StringBuilder();
        a.append(e.getMessage()).append("\r\n");
        for (StackTraceElement traceElement : traceElements = e.getStackTrace()) {
            a.append(traceElement).append("\r\n");
        }
        return a.toString();
    }

    public static String rtrim(String s) {
        int l;
        if (s == null || s.length() < 1) {
            return s;
        }
        char[] c = s.toCharArray();
        for (l = s.length(); l > 0 && c[l - 1] <= ' '; --l) {
        }
        return l < c.length ? s.substring(0, l) : s;
    }

    public static String subDataDeal(String data, int length) {
        if (data == null) {
            return null;
        }
        if (data.length() > length) {
            return data.substring(0, length - 3) + "...";
        }
        return data;
    }

    public static String strConnect(String ... strs) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String str : strs) {
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    public static String strDeleteLast(String param) {
        if (StringUtils.isEmpty((String)param)) {
            return param;
        }
        return param.substring(0, param.length() - 1);
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }
}

