/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.mq.resolver.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.calcnode.framework.mq.resolver.query.AbstractMRPResDataQueryResolver;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPDataSourceResolver;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.Errors;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.wrapper.DynamicRowSet;
import kd.mmc.mrp.utils.DataSourceUtil;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPBOMDataQueryResolver
extends AbstractMRPResDataQueryResolver {
    private Set<String> cols;

    public MRPBOMDataQueryResolver() {
        this.prefix = "bom-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MRPEvent event, IMRPEnvProvider ctx) {
        String requireMaterialCache;
        boolean filter_bom_by_require_material;
        this.ctx = ctx;
        this.event = event;
        this.modelId = event.getParam(MultiThreadCacheKey.KEY_MODEL_ID).toString();
        Set<String> metaCols = this.getMetaKeyCols(ctx);
        metaCols.clear();
        logger.warn(String.format("ctxid: %s, evtid: %s, mrprunner evtid: %s, modelid: %s, resolver: %s", ctx.getMRPContextId(), event.getEventId(), event.getEventId(), this.modelId, ((Object)((Object)this)).getClass().getName()));
        long start = System.currentTimeMillis();
        HashSet<String> requireMaterials = new HashSet<String>(16);
        String json = MRPCacheManager.getInst().getData((CalEnv)ctx, MRPRuntimeConsts.getSelectBillMaterialKey((String)ctx.getMRPContextId()));
        if (StringUtils.isNotBlank((CharSequence)json)) {
            requireMaterials.addAll(JSON.parseArray((String)json, String.class));
        }
        if ((filter_bom_by_require_material = MRPUtil.convert((Object)ctx.getCfgValue(EnvCfgItem.FILTER_BOM_BY_REQUIRE_MATERIAL), (Boolean)Boolean.FALSE).booleanValue()) && StringUtils.isNotBlank((CharSequence)(requireMaterialCache = MRPCacheManager.getInst().getData((CalEnv)ctx, MRPRuntimeConsts.getRequireMaterialKey((String)ctx.getMRPContextId()))))) {
            requireMaterials.addAll(JSON.parseArray((String)requireMaterialCache, String.class));
            QFilter qFilterPlanMode = new QFilter("planmode", "in", (Object)new String[]{"A", "E"});
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"mpdm_materialplan", (String)"masterid", (QFilter[])new QFilter[]{qFilterPlanMode}, null);){
                for (Row row : dataSet) {
                    requireMaterials.add(row.getString("masterid"));
                }
            }
            qFilterPlanMode = new QFilter("entrymatplanscop.plantype", "in", (Object)new String[]{"A", "E"});
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"msplan_matplanscop", (String)"material", (QFilter[])new QFilter[]{qFilterPlanMode}, null);
            var12_12 = null;
            try {
                for (Row row : dataSet) {
                    requireMaterials.add(row.getString("material"));
                }
            }
            catch (Throwable throwable) {
                var12_12 = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (var12_12 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            var12_12.addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        boolean isSelectMaterial = !requireMaterials.isEmpty();
        Set parentIds = MRPUtil.setStringParseLong(requireMaterials);
        String[] metas = null;
        IMRPDataSourceResolver dataResolver = ctx.getDataSourceResolver();
        DynamicObject mrpDs = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(this.modelId), (String)"mrp_resource_dataconfig");
        String resId = String.valueOf(mrpDs.get("id"));
        String resNumber = mrpDs.getString("number");
        Integer cnt = (Integer)ctx.getCfgValue(EnvCfgItem.MEM_DATA_STORE_CNT);
        int splitKey = 0;
        int rowCount = 0;
        ArrayList<Object[]> datas = new ArrayList<Object[]>(cnt);
        int cll = 0;
        QFilter outFilter = null;
        if (isSelectMaterial) {
            String srcMaterialField = DataSourceUtil.getSrcMaterialField((DynamicObject)mrpDs, (String)DefaultField.BOMField.MATERIAL.getName().toLowerCase(Locale.ENGLISH));
            outFilter = new QFilter(srcMaterialField, "in", (Object)parentIds);
        }
        RequireDataModel requireDataModel = (RequireDataModel)ctx.getService(RequireDataModel.class);
        CacheDatas cacheDatas = (CacheDatas)ctx.getService(CacheDatas.class);
        HashMap<String, Integer> colIdx = new HashMap<String, Integer>(0);
        do {
            if (cll >= 99) {
                throw new MRPBizException(Errors.getOverflowMaxLlc());
            }
            DynamicRowSet rs = ctx.createDataFetcher().fetchDatas(this.modelId, new HashSet(0), outFilter == null ? null : outFilter.toSerializedString(), false);
            try {
                DataSet dataSet = rs.getData();
                parentIds.clear();
                RowMeta rowMeta = dataSet.getRowMeta();
                if (metas == null) {
                    metas = rs.getMetas();
                    if (dataResolver != null) {
                        for (int i = 0; i < metas.length; ++i) {
                            colIdx.put(metas[i], i);
                        }
                    }
                }
                HashSet<Long> featuretypes = new HashSet<Long>(2);
                for (Row data : dataSet) {
                    Long child;
                    if (dataResolver != null && !dataResolver.isValidRowData(resId, resNumber, data)) continue;
                    Long l = child = rowMeta.getFieldIndex(DefaultField.BOMField.CHILDMATERIAL.getName().toLowerCase(Locale.ENGLISH), false) >= 0 ? data.get(DefaultField.BOMField.CHILDMATERIAL.getName().toLowerCase(Locale.ENGLISH)) : Long.valueOf(0L);
                    if (isSelectMaterial) {
                        if (child != null && Long.parseLong(((Object)child).toString()) > 0L && requireMaterials.add(String.valueOf(child))) {
                            parentIds.add(Long.parseLong(((Object)child).toString()));
                        } else {
                            Long featuretype;
                            Long l2 = featuretype = rowMeta.getFieldIndex(DefaultField.BOMField.FEATURETYPE.getName().toLowerCase(Locale.ENGLISH), false) >= 0 ? (Long)MRPUtil.convert((Object)data.get(DefaultField.BOMField.FEATURETYPE.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
                            if (featuretype > 0L) {
                                featuretypes.add(featuretype);
                            }
                        }
                    }
                    Object[] row = new Object[metas.length];
                    for (int i = 0; i < row.length; ++i) {
                        Object val;
                        String label = metas[i];
                        row[i] = val = data.get(label);
                    }
                    if (dataResolver != null) {
                        datas.addAll(dataResolver.splitRowData(ctx, resId, colIdx, row));
                    } else {
                        datas.add(row);
                    }
                    ++rowCount;
                    if (datas.size() < cnt) continue;
                    MRPCacheManager.getInst().putSubData((CalEnv)ctx, this.prefix + splitKey, MRPRuntimeConsts.getDataKey((String)event.getEventId(), (String)this.modelId, (String)""), JSON.toJSONString(datas, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
                    datas.clear();
                    metaCols.add(String.valueOf(splitKey));
                    ++splitKey;
                }
                if (!featuretypes.isEmpty()) {
                    Set childs = cacheDatas.getChildByFeatureTypes(featuretypes);
                    for (Long cid : childs) {
                        if (!requireMaterials.add(cid.toString())) continue;
                        parentIds.add(cid);
                    }
                }
            }
            finally {
                rs.getData().close();
            }
            ++cll;
        } while (isSelectMaterial && !parentIds.isEmpty() && !requireDataModel.isIs_single_calc());
        if (!datas.isEmpty()) {
            MRPCacheManager.getInst().putSubData((CalEnv)ctx, this.prefix + splitKey, MRPRuntimeConsts.getDataKey((String)event.getEventId(), (String)this.modelId, (String)""), JSON.toJSONString(datas, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            datas.clear();
            metaCols.add(String.valueOf(splitKey));
        }
        MRPCacheManager.getInst().putData((CalEnv)ctx, MRPRuntimeConsts.getSeparateKey((String)event.getEventId(), (String)this.modelId), JSON.toJSONString(metaCols, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        MRPCacheManager.getInst().putData((CalEnv)ctx, MRPRuntimeConsts.getQueryModelRowCountKey((String)this.modelId), JSON.toJSONString((Object)rowCount));
        logger.warn(String.format("ctxid: %s, evtid: %s, mrprunner-fetchdatas evtid: %s, timecost: %s, resolver: %s", ctx.getMRPContextId(), event.getEventId(), event.getEventId(), System.currentTimeMillis() - start, ((Object)((Object)this)).getClass().getName()));
        start = System.currentTimeMillis();
        this.saveDatas(metas, null, metaCols);
        logger.warn(String.format("ctxid: %s, evtid: %s, mrprunner-savedatas evtid: %s, timecost: %s, resolver: %s", ctx.getMRPContextId(), event.getEventId(), event.getEventId(), System.currentTimeMillis() - start, ((Object)((Object)this)).getClass().getName()));
    }

    protected Set<String> getMetaKeyCols(IMRPEnvProvider ctx) {
        if (this.cols != null) {
            return this.cols;
        }
        this.cols = new HashSet<String>();
        return this.cols;
    }

    protected void saveDatas(String[] metas, HashMap<String, ArrayList<Object[]>> rows, Set<String> metaCols) {
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, this.modelId, this.event.getEventId());
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getMetaKey((String)this.event.getEventId(), (String)this.modelId), JSON.toJSONString((Object)metas, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getQueryModelTimeCostKey((String)this.modelId), JSON.toJSONString((Object)((double)(System.currentTimeMillis() - this.startTs) / 1000.0 / 60.0)));
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getMetaColsKey((String)this.event.getEventId(), (String)this.modelId), JSON.toJSONString(new ArrayList<String>(metaCols), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
    }
}

