/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.MutexFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mrp.business.helper.GlobalPlanHelper;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.runner.AbstractMRPRunner;
import kd.mmc.mrp.integrate.entity.PlanModel;

public class BaseCalcRunningTask
extends AbstractTask {
    private Log log = LogFactory.getLog(BaseCalcRunningTask.class);
    private static final String MRP_CACULATE_LOG = "mrp_caculate_log";
    private static final String ENTITY = "mrp_plandispatch";
    private static final String H_RUNSTATUS = "runstatus";
    private static final String H_FORECASTID = "forecastids";
    private static final String H_FORECASTLOG = "forecastlogid";
    private static final String H_FORECASTLOGNUMBER = "forecastlognumber";
    private static final String H_FORECASTRUNSTATUS = "forecastrunstatus";
    private static final String H_REQPLANID = "reqplanid";
    private static final String H_REQPLANLOG = "reqplanlog";
    private static final String H_REQPLANRUNSTATUS = "reqplanrunstatus";
    private static final String H_PLANORG = "planorg";
    private static final String H_PLANGRAM = "plangram";
    private static final String H_ISLLC = "isllc";
    private static final String H_ISBOMCHECK = "isbomcheck";
    private static final String H_ISALLOWDATEINPAST = "isallowdateinpast";
    private static final String H_MRPLOG = "mrplog";
    private static final String H_MRPRUNSTATUS = "mrprunstatus";
    private static final String H_MRPEXP = "mrpexp";
    private static final String H_ECOPLANORG = "ecoplanorg";
    private static final String H_ECOSCHEMENUMBER = "ecoschemenumber";
    private static final String H_ECOSCHEMEID = "ecoschemeid";
    private static final String H_ECORUNLOGID = "ecorunlogid";
    private static final String H_ECORUNSTATUS = "ecorunstatus";
    private static final String H_ENABLE = "enable";
    private static final String ISMPS = "ismps";
    private static final String ISMRP = "ismrp";
    private static final String ISREORDERPOINT = "isreorderpoint";
    private static final String ISCOMMON = "iscommon";
    private static final String ISCUSTOMIZE = "iscustomize";
    private static final String ISSELECTION = "isselection";
    private static final String ISNOTSETUP = "isnotsetup";

    public DynamicObject checkRunable(Map<String, Object> param) {
        QFilter qf3;
        QFilter qf2;
        QFilter qf1 = new QFilter("number", "=", param.get("number"));
        if (!QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{qf1, qf2 = new QFilter("status", "=", (Object)"C"), qf3 = new QFilter(H_ENABLE, "=", (Object)"1")})) {
            throw new KDException(new ErrorCode("NUMBER_NOT_EXIST", String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a:\u201c%s\u201d\u7684\u8ba1\u5212\u8c03\u5ea6\u65b9\u6848\u4e0d\u5b58\u5728\u6216\u6570\u636e\u72b6\u6001\u4e0d\u4e3a\u201c\u5ba1\u6838\u201d\u4f7f\u7528\u72b6\u6001\u4e0d\u4e3a\u201c\u53ef\u7528\u201d\u3002", (String)"BaseCalcRunningTask_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), param.get("number"))), new Object[0]);
        }
        DynamicObject obj = QueryServiceHelper.queryOne((String)ENTITY, (String)"id", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (!"C".equals((obj = BusinessDataServiceHelper.loadSingle((Object)obj.get("id"), (String)ENTITY)).getString("status"))) {
            return null;
        }
        if (!"1".equals(obj.getString(H_ENABLE))) {
            return null;
        }
        if ("A".equals(obj.getString(H_RUNSTATUS)) && this.checkIsRunData(obj)) {
            return null;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(RequestContext context, Map<String, Object> param) {
        DynamicObject obj = this.checkRunable(param);
        if (obj == null) {
            return;
        }
        Object workerLock = new Object();
        try {
            Object object = workerLock;
            synchronized (object) {
                workerLock.wait(5000L);
            }
        }
        catch (InterruptedException e) {
            obj.set(H_RUNSTATUS, (Object)"B");
            SaveServiceHelper.update((DynamicObject)obj);
            this.log.error((Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!MutexFactory.createDataMutex().require(obj.getString("id"), "mmc.mrp", ENTITY, "edit", true)) {
            ErrorCode FAILED_REQUEST_MUTEX = new ErrorCode("FAILED_REQUEST_MUTEX", ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u8c03\u5ea6\u201c%s\u201d\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"BaseCalcRunningTask_11", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            throw new MRPBizException(FAILED_REQUEST_MUTEX, new Object[]{obj.getString("number")});
        }
        this.log.warn(String.format("\u8ba1\u5212\u8c03\u5ea6[%s]\u540e\u53f0\u6267\u884c", obj.getString("number")));
        this.initRunMsg(obj);
        try {
            this.innerExecute(obj);
        }
        catch (Exception e) {
            this.log.warn(String.format("\u8ba1\u5212\u8c03\u5ea6[%s]\u540e\u53f0\u6267\u884c,\u5f02\u5e38:%s", obj.getString("number"), e));
            ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            if (e instanceof KDException && "TASK_STOPED_BY_USER".equals(((KDException)e).getErrorCode() == null ? "" : ((KDException)e).getErrorCode().getCode())) {
                this.stop();
            }
            obj.set(H_RUNSTATUS, (Object)"B");
            if (e != null) {
                if (e.getMessage() != null) {
                    if (e.getMessage().length() > 200) {
                        obj.set(H_MRPEXP, (Object)e.getMessage().substring(0, 200));
                    } else {
                        obj.set(H_MRPEXP, (Object)e.getMessage());
                    }
                } else if (e.toString().length() > 200) {
                    obj.set(H_MRPEXP, (Object)e.toString().substring(0, 200));
                } else {
                    obj.set(H_MRPEXP, (Object)e);
                }
            }
            SaveServiceHelper.update((DynamicObject)obj);
            this.log.error((Throwable)e);
        }
        finally {
            MutexFactory.createDataMutex().release(obj.getString("id"), ENTITY, "edit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void innerExecute(DynamicObject obj) throws Exception {
        Long dataVersionId;
        Long bizPlanId;
        Object workerLock;
        block95: {
            block94: {
                block93: {
                    Object o;
                    block92: {
                        block91: {
                            workerLock = new Object();
                            DynamicObject bizPlan = obj.getDynamicObject("bizplan");
                            bizPlanId = 0L;
                            if (bizPlan != null) {
                                bizPlanId = (Long)bizPlan.getPkValue();
                            }
                            dataVersionId = obj.getDynamicObject("dataversion") == null ? 0L : obj.getDynamicObject("dataversion").getLong("id");
                            try {
                                if (obj.getBoolean("isrunning") && dataVersionId > 0L) {
                                    Object desc;
                                    obj.set("dataversionstatus", (Object)"A");
                                    SaveServiceHelper.update((DynamicObject)obj);
                                    Map ret = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"queryDataSyncActionStatus", (Object[])new Object[]{dataVersionId});
                                    boolean close = true;
                                    if (ret.get("desc") != null && !"A".equals(((Map)ret.get("desc")).get("status"))) {
                                        ret = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"addDataVersion", (Object[])new Object[]{dataVersionId});
                                        this.log.warn(String.format("\u8ba1\u5212\u8c03\u5ea6[%s]\u540e\u53f0\u6267\u884c,\u6267\u884c\u6570\u636e\u540c\u6b65\u4e2d", obj.getString("number")));
                                        if (!((Boolean)ret.get("ok")).booleanValue()) {
                                            obj.set(H_MRPEXP, ret.get("em"));
                                            obj.set(H_RUNSTATUS, (Object)"B");
                                            obj.set("dataversionstatus", (Object)"B");
                                            SaveServiceHelper.update((DynamicObject)obj);
                                            return;
                                        }
                                        while (close) {
                                            Object object = workerLock;
                                            synchronized (object) {
                                                workerLock.wait(5000L);
                                            }
                                            ret = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"queryDataSyncActionStatus", (Object[])new Object[]{dataVersionId});
                                            if (ret.get("desc") != null && !"A".equals((desc = (Map)ret.get("desc")).get("status"))) {
                                                if ("S".equals(desc.get("status"))) {
                                                    close = false;
                                                    obj.set("dataversionstatus", (Object)"C");
                                                } else if ("F".equals(desc.get("status"))) {
                                                    close = false;
                                                    obj.set("dataversionstatus", (Object)"B");
                                                    obj.set(H_RUNSTATUS, (Object)"B");
                                                    SaveServiceHelper.update((DynamicObject)obj);
                                                    return;
                                                }
                                            }
                                            if (!"D".equals(BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)ENTITY, (String)"id,runstatus").getString(H_RUNSTATUS))) continue;
                                            obj.set(H_RUNSTATUS, (Object)"D");
                                            obj.set("dataversionstatus", (Object)"D");
                                            SaveServiceHelper.update((DynamicObject)obj);
                                            this.stop();
                                        }
                                    } else {
                                        while (close) {
                                            desc = workerLock;
                                            synchronized (desc) {
                                                workerLock.wait(5000L);
                                            }
                                            ret = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"queryDataSyncActionStatus", (Object[])new Object[]{dataVersionId});
                                            if (ret.get("desc") != null && !"A".equals((desc = (Map)ret.get("desc")).get("status"))) {
                                                if ("S".equals(desc.get("status"))) {
                                                    close = false;
                                                    obj.set("dataversionstatus", (Object)"C");
                                                } else if ("F".equals(desc.get("status"))) {
                                                    close = false;
                                                    obj.set("dataversionstatus", (Object)"B");
                                                    obj.set(H_RUNSTATUS, (Object)"B");
                                                    SaveServiceHelper.update((DynamicObject)obj);
                                                    return;
                                                }
                                            }
                                            if (!"D".equals(BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)ENTITY, (String)"id,runstatus").getString(H_RUNSTATUS))) continue;
                                            obj.set(H_RUNSTATUS, (Object)"D");
                                            obj.set("dataversionstatus", (Object)"D");
                                            SaveServiceHelper.update((DynamicObject)obj);
                                            this.stop();
                                        }
                                    }
                                    obj.set("dataversionstatus", (Object)"C");
                                    break block91;
                                }
                                obj.set("dataversionstatus", (Object)"");
                                obj.set("dataversionlog", (Object)"");
                            }
                            catch (Exception e) {
                                obj.set("dataversionstatus", (Object)"B");
                                throw e;
                            }
                        }
                        try {
                            String runLogNumber = "";
                            if (StringUtils.isNotBlank((CharSequence)obj.getString("forecastplanrunid"))) {
                                obj.set("forecastplanstatus", (Object)"A");
                                String forecastlogid = obj.getString("forecastplanrunid");
                                String[] arr = forecastlogid.split(",");
                                for (int i = 0; i < arr.length; ++i) {
                                    String logNumber = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsForecastCalService", (String)"runCalculating", (Object[])new Object[]{arr[i]});
                                    this.log.warn(String.format("\u8ba1\u5212\u8c03\u5ea6[%s]\u540e\u53f0\u6267\u884c,\u9884\u6d4b\u8ba1\u5212[%s]", obj.getString("number"), logNumber));
                                    runLogNumber = "".equals(runLogNumber) ? logNumber : runLogNumber + "," + logNumber;
                                    String status = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsForecastCalService", (String)"getCalculatingStatus", (Object[])new Object[]{logNumber});
                                    while ("B".equals(status)) {
                                        Object object = workerLock;
                                        synchronized (object) {
                                            workerLock.wait(5000L);
                                        }
                                        status = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsForecastCalService", (String)"getCalculatingStatus", (Object[])new Object[]{logNumber});
                                        if (!"D".equals(BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)ENTITY, (String)"id,runstatus").getString(H_RUNSTATUS))) continue;
                                        obj.set(H_RUNSTATUS, (Object)"D");
                                        obj.set("forecastplanstatus", (Object)"D");
                                        SaveServiceHelper.update((DynamicObject)obj);
                                        this.stop();
                                    }
                                    if (!"DE".contains(status)) continue;
                                    obj.set(H_RUNSTATUS, (Object)"B");
                                    obj.set("forecastplanstatus", (Object)"B");
                                    obj.set("forecastplanlogno", (Object)runLogNumber);
                                    obj.set("forecastplanlog", (Object)String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u5212\u8fd0\u7b97\u5931\u8d25,\u65e5\u5fd7:%s", (String)"BaseCalcRunningTask_12", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), logNumber));
                                    SaveServiceHelper.update((DynamicObject)obj);
                                    return;
                                }
                                obj.set("forecastplanstatus", (Object)"C");
                            } else {
                                obj.set("forecastplanstatus", (Object)"");
                            }
                            TimeUnit.MILLISECONDS.sleep(1000L);
                            obj.set("forecastplanlogno", (Object)runLogNumber);
                        }
                        catch (Exception e) {
                            obj.set("forecastplanstatus", (Object)"B");
                            throw e;
                        }
                        try {
                            String forecastids = obj.getString(H_FORECASTID);
                            if (StringUtils.isNotBlank((CharSequence)forecastids)) {
                                obj.set(H_FORECASTRUNSTATUS, (Object)"A");
                                String[] split = forecastids.split(",");
                                ArrayList<Long> lstid = new ArrayList<Long>();
                                for (String item : split) {
                                    try {
                                        lstid.add(Long.valueOf(item));
                                    }
                                    catch (Exception e) {
                                        this.log.error((Throwable)e);
                                    }
                                }
                                Long logid = (Long)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsFNSetoffService", (String)"runSetOff2", (Object[])new Object[]{lstid, dataVersionId});
                                if (logid <= 0L) {
                                    obj.set(H_RUNSTATUS, (Object)"B");
                                    obj.set(H_FORECASTRUNSTATUS, (Object)"B");
                                    obj.set(H_MRPEXP, (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6b63\u786e\u7684\u9884\u6d4b\u51b2\u51cf\u8fd0\u7b97\u3002", (String)"BaseCalcRunningTask_14", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                                    obj.set(H_FORECASTLOG, (Object)logid);
                                    SaveServiceHelper.update((DynamicObject)obj);
                                    return;
                                }
                                obj.set(H_FORECASTLOG, (Object)logid);
                                o = BusinessDataServiceHelper.loadSingle((Object)logid, (String)"mds_setofflog");
                                obj.set(H_FORECASTLOGNUMBER, (Object)o.getString("number"));
                                SaveServiceHelper.update((DynamicObject)obj);
                                this.log.warn(String.format("\u8ba1\u5212\u8c03\u5ea6[%s]\u540e\u53f0\u6267\u884c,\u9884\u6d4b\u51b2\u51cf[%s]", obj.getString("number"), o.getString("number")));
                                boolean flag = true;
                                Long lstatus = 0L;
                                while (flag) {
                                    Object e = workerLock;
                                    synchronized (e) {
                                        workerLock.wait(5000L);
                                    }
                                    lstatus = (Long)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsFNSetoffService", (String)"getStatus", (Object[])new Object[]{logid});
                                    if (lstatus.compareTo(2L) < 0) {
                                        flag = false;
                                    }
                                    if (!"D".equals(BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)ENTITY, (String)"id,runstatus").getString(H_RUNSTATUS))) continue;
                                    obj.set(H_RUNSTATUS, (Object)"D");
                                    obj.set(H_FORECASTRUNSTATUS, (Object)"D");
                                    SaveServiceHelper.update((DynamicObject)obj);
                                    this.stop();
                                }
                                if (lstatus.compareTo(0L) <= 0) {
                                    String logstring = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsFNSetoffService", (String)"loadLog", (Object[])new Object[]{logid});
                                    obj.set(H_RUNSTATUS, (Object)"B");
                                    obj.set(H_MRPEXP, (Object)logstring);
                                    obj.set(H_FORECASTRUNSTATUS, (Object)"B");
                                    obj.set(H_FORECASTLOG, (Object)logid);
                                    SaveServiceHelper.update((DynamicObject)obj);
                                    return;
                                }
                                obj.set(H_FORECASTRUNSTATUS, (Object)"C");
                                obj.set(H_FORECASTLOG, (Object)logid);
                                break block92;
                            }
                            obj.set(H_FORECASTRUNSTATUS, (Object)"");
                            obj.set(H_FORECASTLOG, (Object)0L);
                            obj.set(H_FORECASTLOGNUMBER, (Object)"");
                        }
                        catch (Exception e) {
                            obj.set(H_FORECASTRUNSTATUS, (Object)"B");
                            throw e;
                        }
                    }
                    try {
                        String dspnumber = obj.getString("dspnumber");
                        if (StringUtils.isNotBlank((CharSequence)dspnumber)) {
                            String lognumber = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsDPSSiteService", (String)"runDPSSiteByDataVersion", (Object[])new Object[]{dspnumber, dataVersionId});
                            if ("".equals(lognumber)) {
                                obj.set(H_RUNSTATUS, (Object)"B");
                                obj.set("dpsrunstatus", (Object)"B");
                                obj.set(H_MRPEXP, (Object)ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6b63\u786e\u7684DPS Site\u8fd0\u7b97\u3002", (String)"BaseCalcRunningTask_15", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                                obj.set("dsplog", (Object)lognumber);
                                SaveServiceHelper.update((DynamicObject)obj);
                                return;
                            }
                            obj.set("dpsrunstatus", (Object)"A");
                            obj.set("dsplog", (Object)lognumber);
                            SaveServiceHelper.update((DynamicObject)obj);
                            this.log.warn(String.format("\u8ba1\u5212\u8c03\u5ea6[%s]\u540e\u53f0\u6267\u884c,DPS SITE[%s]", obj.getString("number"), lognumber));
                            boolean flag = true;
                            String status = "";
                            while (flag) {
                                o = workerLock;
                                synchronized (o) {
                                    workerLock.wait(5000L);
                                }
                                status = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsDPSSiteService", (String)"getStatus", (Object[])new Object[]{lognumber});
                                if ("CDE".contains(status)) {
                                    flag = false;
                                }
                                if (!"D".equals(BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)ENTITY, (String)"id,runstatus").getString(H_RUNSTATUS))) continue;
                                obj.set(H_RUNSTATUS, (Object)"D");
                                obj.set("dpsrunstatus", (Object)"D");
                                SaveServiceHelper.update((DynamicObject)obj);
                                this.stop();
                            }
                            if ("DE".contains(status)) {
                                obj.set(H_RUNSTATUS, (Object)"B");
                                obj.set("dpsrunstatus", (Object)"B");
                                obj.set("dsplog", (Object)lognumber);
                                obj.set(H_MRPEXP, (Object)String.format(ResManager.loadKDString((String)"DPS Site\u8fd0\u7b97\u5931\u8d25,\u65e5\u5fd7:%s", (String)"BaseCalcRunningTask_16", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), lognumber));
                                SaveServiceHelper.update((DynamicObject)obj);
                                return;
                            }
                            obj.set("dpsrunstatus", (Object)"C");
                            obj.set("dsplog", (Object)lognumber);
                            break block93;
                        }
                        obj.set("dpsrunstatus", (Object)"");
                        obj.set("dsplog", (Object)"");
                    }
                    catch (Exception e) {
                        obj.set("dpsrunstatus", (Object)"B");
                        throw e;
                    }
                }
                try {
                    String reqplanid = obj.getString(H_REQPLANID);
                    if (StringUtils.isNotBlank((CharSequence)reqplanid)) {
                        obj.set(H_REQPLANRUNSTATUS, (Object)"A");
                        SaveServiceHelper.update((DynamicObject)obj);
                        String[] reqArr = reqplanid.split(",");
                        ArrayList<String> li = new ArrayList<String>(reqArr.length);
                        for (int i = 0; i < reqArr.length; ++i) {
                            String reqplanLogID = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsCalculatingPlanService", (String)"runCalculating", (Object[])new Object[]{reqArr[i]});
                            li.add(reqplanLogID);
                            this.log.warn(String.format("\u8ba1\u5212\u8c03\u5ea6[%s]\u540e\u53f0\u6267\u884c,\u9700\u6c42\u8ba1\u5212[%s]", obj.getString("number"), reqplanLogID));
                        }
                        if (li.size() == 0) {
                            obj.set(H_RUNSTATUS, (Object)"B");
                            obj.set(H_REQPLANRUNSTATUS, (Object)"B");
                            obj.set(H_MRPEXP, (Object)ResManager.loadKDString((String)"\u83b7\u53d6\u9700\u6c42\u8ba1\u5212\u8ba1\u7b97\u65e5\u5fd7\u5931\u8d25\u3002", (String)"BaseCalcRunningTask_17", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                            SaveServiceHelper.update((DynamicObject)obj);
                            return;
                        }
                        if ("D".equals(BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)ENTITY, (String)"id,runstatus").getString(H_RUNSTATUS))) {
                            obj.set(H_RUNSTATUS, (Object)"D");
                            SaveServiceHelper.update((DynamicObject)obj);
                            this.stop();
                        }
                        obj.set(H_FORECASTRUNSTATUS, (Object)"C");
                        obj.set(H_REQPLANLOG, (Object)String.join((CharSequence)",", li));
                        obj.set(H_REQPLANRUNSTATUS, (Object)"A");
                        SaveServiceHelper.update((DynamicObject)obj);
                        boolean flag = true;
                        String reqPlanLogId = "";
                        String status = "";
                        while (flag) {
                            Object lstatus = workerLock;
                            synchronized (lstatus) {
                                workerLock.wait(5000L);
                            }
                            int n = li.size();
                            for (int i = 0; i < n; ++i) {
                                status = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsCalculatingPlanService", (String)"getCalculatingStatus", (Object[])new Object[]{li.get(i)});
                                if (!"CDE".contains(status)) continue;
                                flag = false;
                                reqPlanLogId = (String)li.get(i);
                            }
                            if (!"D".equals(BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)ENTITY, (String)"id,runstatus").getString(H_RUNSTATUS))) continue;
                            obj.set(H_RUNSTATUS, (Object)"D");
                            obj.set(H_REQPLANRUNSTATUS, (Object)"D");
                            SaveServiceHelper.update((DynamicObject)obj);
                            this.stop();
                        }
                        if ("DE".contains(status)) {
                            obj.set(H_RUNSTATUS, (Object)"B");
                            obj.set(H_REQPLANRUNSTATUS, (Object)"B");
                            obj.set(H_REQPLANLOG, (Object)String.join((CharSequence)",", li));
                            obj.set(H_MRPEXP, (Object)String.format(ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u8fd0\u7b97\u5931\u8d25,\u65e5\u5fd7:%s", (String)"BaseCalcRunningTask_18", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), reqPlanLogId));
                            SaveServiceHelper.update((DynamicObject)obj);
                            return;
                        }
                        obj.set(H_REQPLANRUNSTATUS, (Object)"C");
                        obj.set(H_REQPLANLOG, (Object)String.join((CharSequence)",", li));
                        break block94;
                    }
                    obj.set(H_REQPLANRUNSTATUS, (Object)"");
                    obj.set(H_REQPLANLOG, (Object)"");
                }
                catch (Exception e) {
                    obj.set(H_REQPLANRUNSTATUS, (Object)"B");
                    throw e;
                }
            }
            try {
                String ecoSchemeNumber = obj.getString(H_ECOSCHEMENUMBER);
                String ecoSchemeId = obj.getString(H_ECOSCHEMEID);
                DynamicObject ecoPlanOrg = obj.getDynamicObject(H_ECOPLANORG);
                if (StringUtils.isNotBlank((CharSequence)ecoSchemeNumber) && StringUtils.isNotBlank((CharSequence)ecoSchemeId) && ecoPlanOrg != null) {
                    obj.set(H_ECORUNSTATUS, (Object)"A");
                    SaveServiceHelper.update((DynamicObject)obj);
                    String[] ecoSchemeIdArray = ecoSchemeId.split(",");
                    ArrayList<String> li = new ArrayList<String>(ecoSchemeIdArray.length);
                    for (int i = 0; i < ecoSchemeIdArray.length; ++i) {
                        String ecoRunLogNumber = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"IECNEstimateService", (String)"startEcnEstimate", (Object[])new Object[]{(Long)ecoPlanOrg.getPkValue(), Long.parseLong(ecoSchemeIdArray[i]), "", ""});
                        li.add(ecoRunLogNumber);
                        this.log.warn(String.format("\u8ba1\u5212\u8c03\u5ea6[%s]\u540e\u53f0\u6267\u884c,\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u8fd0\u7b97[%s]", obj.getString("number"), ecoRunLogNumber));
                    }
                    if (li.size() == 0) {
                        obj.set(H_RUNSTATUS, (Object)"B");
                        obj.set(H_ECORUNSTATUS, (Object)"B");
                        obj.set(H_MRPEXP, (Object)ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u8fd0\u7b97\u65e5\u5fd7\u5931\u8d25\u3002", (String)"BaseCalcRunningTask_22", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                        SaveServiceHelper.update((DynamicObject)obj);
                        return;
                    }
                    if ("D".equals(BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)ENTITY, (String)"id,runstatus").getString(H_RUNSTATUS))) {
                        obj.set(H_RUNSTATUS, (Object)"D");
                        SaveServiceHelper.update((DynamicObject)obj);
                        this.stop();
                    }
                    obj.set(H_ECORUNLOGID, (Object)String.join((CharSequence)",", li));
                    obj.set(H_ECORUNSTATUS, (Object)"A");
                    SaveServiceHelper.update((DynamicObject)obj);
                    boolean flag = true;
                    String ecoRunLogNumber = "";
                    String status = "";
                    while (flag) {
                        Object object = workerLock;
                        synchronized (object) {
                            workerLock.wait(5000L);
                        }
                        int n = li.size();
                        for (int i = 0; i < n; ++i) {
                            status = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"IECNEstimateService", (String)"getEcnEstimateLogStatus", (Object[])new Object[]{li.get(i)});
                            if (!"ABC".contains(status)) continue;
                            flag = false;
                            ecoRunLogNumber = (String)li.get(i);
                        }
                        if (!"D".equals(BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)ENTITY, (String)"id,runstatus").getString(H_RUNSTATUS))) continue;
                        obj.set(H_RUNSTATUS, (Object)"D");
                        obj.set(H_ECORUNSTATUS, (Object)"D");
                        SaveServiceHelper.update((DynamicObject)obj);
                        this.stop();
                    }
                    if ("BC".contains(status)) {
                        obj.set(H_RUNSTATUS, (Object)"B");
                        obj.set(H_ECORUNSTATUS, (Object)"B");
                        obj.set(H_ECORUNLOGID, (Object)String.join((CharSequence)",", li));
                        obj.set(H_MRPEXP, (Object)String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u8fd0\u7b97\u5931\u8d25,\u65e5\u5fd7:%s", (String)"BaseCalcRunningTask_23", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), ecoRunLogNumber));
                        SaveServiceHelper.update((DynamicObject)obj);
                        return;
                    }
                    obj.set(H_ECORUNSTATUS, (Object)"C");
                    obj.set(H_ECORUNLOGID, (Object)String.join((CharSequence)",", li));
                    break block95;
                }
                obj.set(H_ECORUNLOGID, (Object)"");
                obj.set(H_ECORUNSTATUS, (Object)"");
            }
            catch (Exception e) {
                obj.set(H_ECORUNSTATUS, (Object)"B");
                throw e;
            }
        }
        try {
            DynamicObject planorg = obj.getDynamicObject(H_PLANORG);
            DynamicObject plangram = obj.getDynamicObject(H_PLANGRAM);
            plangram = BusinessDataServiceHelper.loadSingle((Object)plangram.getPkValue(), (String)"mrp_planprogram");
            Object isllc = obj.get(H_ISLLC);
            Object isbomcheck = obj.get(H_ISBOMCHECK);
            Object isallowdateinpast = obj.get(H_ISALLOWDATEINPAST);
            DynamicObject caculateLog = ORM.create().newDynamicObject(MRP_CACULATE_LOG);
            Long id = ORM.create().genLongId(MRP_CACULATE_LOG);
            caculateLog.set("id", (Object)id);
            caculateLog.set("createorg", (Object)planorg);
            caculateLog.set("useorg", (Object)planorg);
            caculateLog.set("runtype", (Object)"A");
            caculateLog.set("plantype", (Object)PlanModel.getPlanType((DynamicObject)plangram));
            caculateLog.set(H_PLANGRAM, (Object)plangram.getLong("id"));
            caculateLog.set("programnumber", (Object)plangram.getString("number"));
            caculateLog.set("programname", (Object)plangram.getString("name"));
            caculateLog.set("plangramentity", (Object)"mrp_planprogram");
            caculateLog.set("clearstatus", (Object)"A");
            caculateLog.set("plandate", (Object)new Date());
            caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
            caculateLog.set("operatmode", (Object)ResManager.loadKDString((String)"\u5168\u5c40\u8ba1\u5212", (String)"BaseCalcRunningTask_19", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            caculateLog.set("operatmodekey", (Object)"mrp_globalplan");
            caculateLog.set("calculatestatus", (Object)"D");
            caculateLog.set("startdate", (Object)new Date());
            caculateLog.set("ctrlstrategy", (Object)"7");
            caculateLog.set(H_ISLLC, isllc);
            caculateLog.set(H_ISBOMCHECK, isbomcheck);
            caculateLog.set(H_ISALLOWDATEINPAST, isallowdateinpast);
            caculateLog.set("dataversion", (Object)dataVersionId);
            caculateLog.set("status", (Object)"C");
            caculateLog.set(H_ENABLE, (Object)"1");
            caculateLog.set(ISCOMMON, plangram.get(ISCOMMON));
            caculateLog.set(ISCUSTOMIZE, plangram.get(ISCUSTOMIZE));
            caculateLog.set(ISSELECTION, plangram.get(ISSELECTION));
            caculateLog.set(ISNOTSETUP, plangram.get(ISNOTSETUP));
            String number = CodeRuleServiceHelper.getNumber((String)MRP_CACULATE_LOG, (DynamicObject)caculateLog, (String)obj.getDynamicObject(H_PLANORG).getPkValue().toString());
            String errorMsg = null;
            if (GlobalPlanHelper.isExistMRPRunning((Long)plangram.getLong("id"))) {
                errorMsg = ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"BaseCalcRunningTask_13", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)number)) {
                errorMsg = ResManager.loadKDString((String)"MRP\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"BaseCalcRunningTask_20", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
            }
            if (StringUtils.isNotBlank(errorMsg)) {
                obj.set(H_RUNSTATUS, (Object)"B");
                obj.set(H_MRPLOG, (Object)"");
                obj.set(H_MRPRUNSTATUS, (Object)"B");
                obj.set(H_MRPEXP, (Object)errorMsg);
                SaveServiceHelper.update((DynamicObject)obj);
                return;
            }
            caculateLog.set("number", (Object)number);
            DynamicObjectCollection plantags = plangram.getDynamicObjectCollection("plantags");
            DynamicObjectCollection calctags = caculateLog.getDynamicObjectCollection("plantags");
            calctags.clear();
            for (DynamicObject tag : plantags) {
                DynamicObject cal = calctags.addNew();
                cal.set("fbasedataid", tag.get("fbasedataid"));
            }
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IMRPRunnerApi", (String)"mrpStarterByBizPlan", (Object[])new Object[]{caculateLog, bizPlanId});
            this.log.warn(String.format("\u8ba1\u5212\u8c03\u5ea6[%s]\u540e\u53f0\u6267\u884c,\u5168\u5c40\u8ba1\u5212[%s]", obj.getString("number"), number));
            obj.set(H_MRPLOG, (Object)number);
            obj.set(H_MRPRUNSTATUS, (Object)"A");
            SaveServiceHelper.update((DynamicObject)obj);
            boolean flag = true;
            DynamicObject logObj = null;
            while (flag) {
                Object object = workerLock;
                synchronized (object) {
                    workerLock.wait(5000L);
                }
                if (QueryServiceHelper.exists((String)MRP_CACULATE_LOG, (Object)id) && "ABC".contains((logObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)MRP_CACULATE_LOG)).getString("calculatestatus"))) {
                    flag = false;
                }
                if (!"D".equals(BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)ENTITY, (String)"id,runstatus").getString(H_RUNSTATUS))) continue;
                obj.set(H_RUNSTATUS, (Object)"D");
                obj.set(H_MRPRUNSTATUS, (Object)"D");
                SaveServiceHelper.update((DynamicObject)obj);
                AbstractMRPRunner.clearMutexByPlanId((String)obj.getDynamicObject(H_PLANORG).getPkValue().toString());
                this.stop();
            }
            if (logObj != null && "BC".contains(logObj.getString("calculatestatus"))) {
                obj.set(H_RUNSTATUS, (Object)"B");
                obj.set(H_MRPRUNSTATUS, (Object)"B");
                SaveServiceHelper.update((DynamicObject)obj);
                return;
            }
        }
        catch (Exception e) {
            obj.set(H_MRPRUNSTATUS, (Object)"B");
            throw e;
        }
        obj.set(H_RUNSTATUS, (Object)"C");
        obj.set(H_MRPRUNSTATUS, (Object)"C");
        SaveServiceHelper.update((DynamicObject)obj);
    }

    public void initRunMsg(DynamicObject obj) {
        obj.set("dataversionlog", (Object)"");
        obj.set("dataversionstatus", (Object)"");
        obj.set("forecastplanstatus", (Object)"");
        obj.set("forecastplanlog", (Object)"");
        obj.set("forecastplanlogno", (Object)"");
        obj.set(H_FORECASTLOGNUMBER, (Object)"");
        obj.set(H_RUNSTATUS, (Object)"A");
        obj.set(H_FORECASTLOG, (Object)0L);
        obj.set("dsplog", (Object)"");
        obj.set("dpsrunstatus", (Object)"");
        obj.set(H_FORECASTRUNSTATUS, (Object)"");
        obj.set(H_REQPLANLOG, (Object)"");
        obj.set(H_REQPLANRUNSTATUS, (Object)"");
        obj.set(H_MRPLOG, (Object)"");
        obj.set(H_MRPRUNSTATUS, (Object)"");
        obj.set(H_MRPEXP, (Object)"");
        obj.set(H_ECORUNSTATUS, (Object)"");
        obj.set(H_ECORUNLOGID, (Object)"");
        SaveServiceHelper.update((DynamicObject)obj);
    }

    public boolean checkIsRunData(DynamicObject obj) {
        String jobId = obj.getString("jobid");
        if (!jobId.isEmpty()) {
            QFilter qf1 = new QFilter("job.id", "=", (Object)jobId);
            QFilter qf2 = new QFilter("status", "=", (Object)"BEGIN");
            if (QueryServiceHelper.exists((String)"sch_task", (QFilter[])new QFilter[]{qf1, qf2})) {
                QFilter filter2;
                QFilter filter1;
                String[] arr;
                Object lstatus;
                Map desc;
                Map ret;
                if (obj.getBoolean("isrunning") && (ret = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"addDataVersion", (Object[])new Object[]{obj.getDynamicObject("dataversion").getLong("id")})).get("desc") != null && "A".equals((desc = (Map)ret.get("desc")).get("status"))) {
                    return true;
                }
                if (!"".equals(obj.getString("forecastplanlogno"))) {
                    String[] arr2 = obj.getString("forecastplanlogno").split(",");
                    for (int i = 0; i < arr2.length; ++i) {
                        String status = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsForecastCalService", (String)"getCalculatingStatus", (Object[])new Object[]{arr2[i]});
                        if (!"".equals(status)) continue;
                        return true;
                    }
                }
                if (!"".equals(obj.getString("dsplog")) && "B".equals(lstatus = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsDPSSiteService", (String)"getStatus", (Object[])new Object[]{obj.getString("dsplog")}))) {
                    return true;
                }
                if (!"".equals(obj.getString(H_FORECASTLOG)) && ((Long)(lstatus = (Long)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsFNSetoffService", (String)"getStatus", (Object[])new Object[]{obj.getLong(H_FORECASTLOG)}))).compareTo(2L) >= 0) {
                    return true;
                }
                if (!"".equals(obj.getString(H_REQPLANLOG))) {
                    boolean flag = false;
                    arr = obj.getString(H_REQPLANLOG).split(",");
                    for (int i = 0; i < arr.length; ++i) {
                        String status = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsCalculatingPlanService", (String)"getCalculatingStatus", (Object[])new Object[]{arr[i]});
                        if (!"".equals(status)) continue;
                        flag = true;
                    }
                    if (flag) {
                        return true;
                    }
                }
                if (!"".equals(obj.getString(H_ECORUNLOGID))) {
                    boolean flag = false;
                    arr = obj.getString(H_ECORUNLOGID).split(",");
                    for (int i = 0; i < arr.length; ++i) {
                        QFilter filter12 = new QFilter("number", "=", (Object)arr[i]);
                        QFilter filter22 = new QFilter("calculatestatus", "=", (Object)"D");
                        if (!QueryServiceHelper.exists((String)MRP_CACULATE_LOG, (QFilter[])new QFilter[]{filter12, filter22})) continue;
                        flag = true;
                    }
                    if (flag) {
                        return true;
                    }
                }
                if (!"".equals(obj.getString(H_MRPLOG)) && QueryServiceHelper.exists((String)MRP_CACULATE_LOG, (QFilter[])new QFilter[]{filter1 = new QFilter("number", "=", (Object)obj.getString(H_MRPLOG)), filter2 = new QFilter("calculatestatus", "=", (Object)"D")})) {
                    return true;
                }
            }
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.disableSchedule(jobId);
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)("update T_SCH_TASK set fstatus = 'COMPLETED' where fjobid = '" + jobId + "'"));
        }
        return false;
    }
}

