/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.formplugin.productconfig;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.platform.api.IFormulaFunctions;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;
import kd.mmc.pdm.business.proconfig.proconfigEdit.ProConfigPreConditionBusiness;
import kd.mmc.pdm.business.proconfig.proconfigEdit.ProdConfigFeatureSearchBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.PDMFormulaRunBusiness;
import kd.mmc.pdm.common.constants.Productconfig;
import kd.mmc.pdm.common.enums.BOMOpenTypeEnum;
import kd.mmc.pdm.common.enums.ConfigTypeEnum;
import kd.mmc.pdm.common.enums.ProductConfigPageTypeEnum;
import kd.mmc.pdm.common.objectbeen.FeatureValueObj;
import kd.mmc.pdm.common.objectbeen.ProdConfigureFeatureDefAndValObj;
import kd.mmc.pdm.common.util.FormViewUtil;
import kd.mmc.pdm.common.util.MaterialUtil;
import kd.mmc.pdm.common.util.PDMCustFormulaFuntions;
import kd.mmc.pdm.formplugin.productconfig.ProductConfigsBaseEdit;

public class ProductConfigsEdit
extends ProductConfigsBaseEdit
implements RowClickEventListener {
    private static final String MESSAGE = ProductConfigsEdit.getNodeRepeat();
    private static final String CACHE_LOCKROWS = "cachelockrows";
    private static final Log logger = LogFactory.getLog(ProductConfigsEdit.class);
    private int rowNum = 0;
    private String CONFIGPROCESS_USER_SETUP = ResManager.loadKDString((String)"\u503c\u72b6\u6001\uff1a\u5df2\u8bbe\u7f6e\uff1b\u503c\u6765\u6e90\u7c7b\u578b\uff1a\u7528\u6237\u6307\u5b9a\uff1b\u503c\u6765\u6e90\uff1a\uff1b", (String)"ProductConfigsEdit_0", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    private String CONFIGPROCESS_UNSETUP = ResManager.loadKDString((String)"\u503c\u72b6\u6001\uff1a\u672a\u8bbe\u7f6e\uff1b\u503c\u6765\u6e90\u7c7b\u578b\uff1a\uff1b\u503c\u6765\u6e90\uff1a\uff1b", (String)"ProductConfigsEdit_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    private String CONFIGPROCESS_FROM_FEATURE_ENTRYRULE = ResManager.loadKDString((String)"\u503c\u72b6\u6001\uff1a\u5df2\u8bbe\u7f6e\uff1b\u503c\u6765\u6e90\u7c7b\u578b\uff1a\u7279\u5f81\u503c\u5e26\u51fa\uff1b\u503c\u6765\u6e90\uff1a\uff1b", (String)"ProductConfigsEdit_2", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);

    private static String getNodeRepeat() {
        return ResManager.loadKDString((String)"\u8282\u70b9\u201c%s\u201d\u4e0e\u4e0a\u7ea7\u8282\u70b9\u51fa\u73b0\u7ec4\u4ef6\u914d\u7f6e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u8d85\u7ea7BOM\u914d\u7f6e\u3002", (String)"ProductConfigsEdit_3", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        IPageCache pcPageCache;
        Map customParams;
        Object datetimeObj;
        super.preOpenForm(e);
        if (this.validaFeatureLicense(e)) {
            return;
        }
        String errMsg = this.validCustParaVal(e);
        FormShowParameter fsp = e.getFormShowParameter();
        IFormView fvParent = null;
        String appId = fsp.getAppId();
        if ("pdm".equals(appId)) {
            fvParent = FormViewUtil.getView((String)fsp.getParentPageId());
        }
        if ((datetimeObj = (customParams = fsp.getCustomParams()).get("datetime")) == null) {
            errMsg = ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u65e5\u671f\u3002", (String)"ProductConfigsEdit_4", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        if (!this.checkConfigCodeType(customParams)) {
            errMsg = ResManager.loadKDString((String)"\u624b\u5de5\u7c7b\u578b\u7684\u914d\u7f6e\u53f7\u4e0d\u652f\u6301\u9009\u914d\u3002", (String)"ProductConfigsEdit_5", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        if (!this.checkMaterialMatchConfigCode(customParams)) {
            errMsg = ResManager.loadKDString((String)"\u914d\u7f6e\u53f7\u5bf9\u5e94\u7684\u4ea7\u54c1\u914d\u7f6e\u6e05\u5355\u4e0a\u7684\u7269\u6599\u4e0e\u9009\u914d\u7269\u6599\u4e0d\u4e00\u81f4\u3002", (String)"ProductConfigsEdit_6", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        if ("pdm".equals(appId) && errMsg.length() <= 0 && fvParent != null && (pcPageCache = this.getParentPageCache(fsp.getParentPageId())) != null) {
            String parentPageCacheKey = this.getOnlyPageCacheKey(e.getFormShowParameter());
            if (StringUtils.isBlank((CharSequence)pcPageCache.get(parentPageCacheKey))) {
                pcPageCache.put(parentPageCacheKey, "true");
            } else {
                errMsg = ResManager.loadKDString((String)"\u9009\u914d\u9875\u9762\u5df2\u6253\u5f00", (String)"ProductConfigsEdit_7", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            }
        }
        if (errMsg.length() > 0 && fvParent != null) {
            e.setCancel(true);
            fvParent.showTipNotification(errMsg);
        }
        if (!"pdm".equals(appId) && errMsg.length() > 0) {
            e.setCancel(true);
            e.setCancelMessage(errMsg);
        }
    }

    private boolean validaFeatureLicense(PreOpenFormEventArgs e) {
        boolean license;
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_MMC_PC");
        boolean bl = license = checkResult.getHasLicense() == false;
        if (license) {
            String msg = checkResult.getMsg();
            String resMsg = "";
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                resMsg = msg.replace("PRO_MMC_PC", ResManager.loadKDString((String)"\u4ea7\u54c1\u9009\u914d", (String)"ProductConfigsEdit_15", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
            }
            e.setCancel(license);
            e.setCancelMessage(resMsg);
            e.setCancelFormShowParameter(checkResult.getCancelFormShowParameter());
        }
        return license;
    }

    private boolean checkConfigCodeType(Map<String, Object> customParams) {
        String createType;
        QFilter configCodeQfilter;
        DynamicObject configCodeDO;
        if (customParams == null) {
            return true;
        }
        boolean isMatch = true;
        Object configCodeObj = customParams.get("configcode");
        Long configCodeParamPK = 0L;
        if (configCodeObj != null && (configCodeDO = BusinessDataServiceHelper.loadSingle((String)"bd_configuredcode", (String)"id,createtype", (QFilter[])new QFilter[]{configCodeQfilter = new QFilter("id", "=", (Object)(configCodeParamPK = Long.valueOf(Long.parseLong(String.valueOf(configCodeObj)))))})) != null && "1".equals(createType = configCodeDO.getString("createtype"))) {
            isMatch = false;
        }
        return isMatch;
    }

    private boolean checkMaterialMatchConfigCode(Map<String, Object> customParams) {
        if (customParams == null) {
            return true;
        }
        boolean isMatch = true;
        Object materialObj = customParams.get("material");
        Object configCodeObj = customParams.get("configcode");
        Long materialPK = 0L;
        Long configCodeParamPK = 0L;
        if (materialObj != null && configCodeObj != null) {
            materialPK = Long.parseLong(String.valueOf(materialObj));
            configCodeParamPK = Long.parseLong(String.valueOf(configCodeObj));
            if (materialPK > 0L && configCodeParamPK > 0L) {
                QFilter configCodeQfilter = new QFilter("masterconfigcode", "=", (Object)configCodeParamPK);
                QFilter materielnoQfilter = new QFilter("materielno", "=", (Object)materialPK);
                boolean exists = QueryServiceHelper.exists((String)"pdm_productconfigure", (QFilter[])new QFilter[]{configCodeQfilter});
                if (exists) {
                    isMatch = QueryServiceHelper.exists((String)"pdm_productconfigure", (QFilter[])new QFilter[]{materielnoQfilter, configCodeQfilter});
                }
            }
        }
        return isMatch;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadView(0L);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryCol = model.getEntryEntity("entryentity");
        this.hideFeature(entryCol, null, -1);
    }

    private void loadView(long proOrg) {
        this.rowNum = 0;
        FormShowParameter fsp = this.getView().getFormShowParameter();
        IFormView gv = this.getView();
        IDataModel dm = gv.getModel();
        if (StringUtils.isNotBlank((Object)fsp) && StringUtils.isNotBlank((Object)gv) && StringUtils.isNotBlank((Object)dm)) {
            String superBomMsg;
            DynamicObject createOrg;
            Object org = fsp.getCustomParam("org");
            Object deliverOrg = fsp.getCustomParam("deliverorg");
            Object materiel = fsp.getCustomParam("material");
            Object srcId = fsp.getCustomParam("srcid");
            Object srcEntryId = fsp.getCustomParam("srcentryid");
            String srcEntity = (String)fsp.getCustomParam("srcentity");
            String srcEntryEntity = (String)fsp.getCustomParam("srcentryentity");
            Object simulaObj = fsp.getCustomParam("simula");
            Object dateTimeObj = fsp.getCustomParam("datetime");
            Object deliverDataTimeObj = fsp.getCustomParam("deliverdatetime");
            Object configCodeParamObj = fsp.getCustomParam("configcode");
            Long orgL = -1L;
            Long materielL = -1L;
            Long srcIdL = -1L;
            Long srcEntryIdL = -1L;
            boolean simula = true;
            Date dateTime = null;
            Date deliverDataTime = null;
            Long configCodeParamPK = 0L;
            Long deliverOrgL = -1L;
            if (materiel instanceof Long || StringUtils.isNotBlank((Object)materiel)) {
                materielL = Long.parseLong(materiel.toString());
            }
            if (proOrg > 0L) {
                orgL = proOrg;
            } else if (org instanceof Long || StringUtils.isNotBlank((Object)org)) {
                orgL = Long.parseLong(org.toString());
            }
            DynamicObject materielObj = BusinessDataServiceHelper.loadSingle((Object)materielL, (String)"bd_material");
            if (orgL <= 0L && materielObj != null && (createOrg = materielObj.getDynamicObject("createorg")) != null) {
                orgL = createOrg.getLong("id");
            }
            if (deliverOrg instanceof Long || StringUtils.isNotBlank((Object)deliverOrg)) {
                deliverOrgL = Long.parseLong(deliverOrg.toString());
            }
            if (srcId instanceof Long || StringUtils.isNotBlank((Object)srcId)) {
                srcIdL = Long.parseLong(srcId.toString());
            }
            if (srcEntryId instanceof Long || StringUtils.isNotBlank((Object)srcEntryId)) {
                srcEntryIdL = Long.parseLong(srcEntryId.toString());
            }
            if (simulaObj instanceof Boolean) {
                simula = (Boolean)simulaObj;
            } else if (StringUtils.isNotBlank((Object)simulaObj)) {
                simula = Boolean.parseBoolean(simulaObj.toString());
            }
            SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (dateTimeObj != null) {
                try {
                    dateTime = simple.parse(String.valueOf(dateTimeObj));
                    deliverDataTime = deliverDataTime != null ? simple.parse(String.valueOf(deliverDataTimeObj)) : null;
                }
                catch (ParseException parseException) {
                    logger.error(parseException.getMessage());
                }
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap2"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"featuretreeentryentity"});
            if (configCodeParamObj instanceof Long || StringUtils.isNotBlank((Object)configCodeParamObj)) {
                configCodeParamPK = Long.parseLong(configCodeParamObj.toString());
            }
            if (StringUtils.isNotEmpty((CharSequence)(superBomMsg = this.existSuperBom(orgL, materielL, materielObj)))) {
                this.getView().showTipNotification(superBomMsg);
            }
            QFilter schemeIds = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_proconfigscheme", (Long)orgL);
            QFilter superBomIds = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)orgL);
            QFilter materialnum = new QFilter("materielnum", "=", (Object)materielL);
            QFilter material = new QFilter("materialid", "=", (Object)materielL);
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            QFilter versionFilter = new QFilter("version", "=", (Object)0L);
            QFilter replaceNoFilter = new QFilter("replaceno", "=", (Object)0L);
            QFilter auxPropFilter = new QFilter("auxproperty", "=", (Object)0L);
            QFilter[] schemesFilter = new QFilter[]{materialnum, schemeIds, status, enable};
            DynamicObject scheme = this.getPriorityMax(schemesFilter);
            DynamicObject bomExpandConfig = scheme == null ? null : scheme.getDynamicObject("bomexpandconfig");
            long bomExpandConfigId = bomExpandConfig == null ? 0L : bomExpandConfig.getLong("id");
            Map bomExpandMap = BOMExpandConfigBusiness.getBomExpandConfig((long)bomExpandConfigId);
            Set bomTypeSet = BOMExpandConfigBusiness.getBomTypeOfPurpose((Map)bomExpandMap, (String)"B");
            QFilter bomTypeFilter = new QFilter("type", "in", (Object)bomTypeSet);
            QFilter[] superBomFilter = new QFilter[]{material, superBomIds, status, enable, versionFilter, replaceNoFilter, auxPropFilter, bomTypeFilter};
            DynamicObject[] superBomArray = BusinessDataServiceHelper.load((String)"pdm_mftbom", (String)this.getSelectItems(), (QFilter[])superBomFilter);
            DynamicObject superBom = BOMExpandConfigBusiness.bomTypePriorityFilter((DynamicObject[])superBomArray, (Map)bomExpandMap, (String)"B");
            if (superBom == null) {
                return;
            }
            this.setHeadInfo(orgL, deliverOrgL, materielL, srcEntity, srcIdL, srcEntryEntity, srcEntryIdL, simula, superBom, scheme);
            dm.setValue("datetime", (Object)dateTime);
            DynamicObjectCollection bomTreeEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
            superBomIds.and(bomTypeFilter);
            this.queryTreeentryentity(bomTreeEntrys, superBom, scheme, superBomIds);
            this.loadProductConfigure(configCodeParamPK, dateTime);
            if (srcIdL == -1L) {
                return;
            }
        }
    }

    private void loadProductConfigure(Long configCodeParamPK, Date time) {
        if (configCodeParamPK <= 0L) {
            return;
        }
        IDataModel model = this.getModel();
        if (configCodeParamPK > 0L) {
            Map<Long, Boolean> fsMap = new HashMap<Long, Boolean>(16);
            String status = "";
            QFilter configCodeQfilter = new QFilter("masterconfigcode", "=", (Object)configCodeParamPK);
            DynamicObject productConfFrom = BusinessDataServiceHelper.loadSingle((String)"pdm_productconfigure", (QFilter[])new QFilter[]{configCodeQfilter});
            if (productConfFrom != null) {
                if (productConfFrom == null) {
                    model.setValue("masterconfigcode", (Object)configCodeParamPK);
                    return;
                }
                this.getModel().deleteEntryData("entryentity");
                model.setValue("id", productConfFrom.getPkValue());
                DynamicObject productConfigPlanDO = productConfFrom.getDynamicObject("productconfigplan");
                status = productConfFrom.getString("status");
                String configType = "";
                if (productConfigPlanDO != null) {
                    configType = productConfigPlanDO.getString("configtype");
                    fsMap = this.getFeatureNumIsSolid(productConfigPlanDO);
                }
                if ("1".equals(configType)) {
                    DynamicObjectCollection modelTreeEntry = model.getEntryEntity("treeentryentity");
                    DynamicObjectCollection configureEntry = productConfFrom.getDynamicObjectCollection("treeentryentity");
                    this.setComponentEntry(configureEntry, modelTreeEntry);
                } else if ("2".equals(configType)) {
                    DynamicObjectCollection modelFreature = model.getEntryEntity("entryentity");
                    DynamicObjectCollection configureFeature = productConfFrom.getDynamicObjectCollection("entryentity");
                    this.setComponentFeature(configureFeature, modelFreature, fsMap, status);
                }
                model.setValue("status", (Object)status);
                model.setValue("masterconfigcode", productConfFrom.get("masterconfigcode"));
                if (!"A".equals(status)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"savelist"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{"donothing_savefeaturelist"});
                    model.setValue("createorg", productConfFrom.get("createorg"));
                    model.setValue("prodorgid", productConfFrom.get("prodorgid"));
                    this.setEntityEnable(false);
                }
            } else {
                model.setValue("masterconfigcode", (Object)configCodeParamPK);
            }
            model.setValue("datetime", (Object)time);
            this.getView().updateView("treeentryentity");
            this.getView().updateView("entryentity");
            this.setDefaultFeatureValueEnable(fsMap, status, -1);
        }
    }

    private Map<Long, Boolean> getFeatureNumIsSolid(DynamicObject productConfigPlanDO) {
        Long featurenumid;
        HashMap<Long, Boolean> dataMapA = new HashMap<Long, Boolean>(16);
        HashMap<Long, Boolean> dataMapB = new HashMap<Long, Boolean>(16);
        String sp = "featureinfo.featuretype.issolid issolid,featureinfo.featuretype.entryentity.featurenum featurenumid";
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_proconfigscheme", (String)sp, (QFilter[])new QFilter[]{new QFilter("id", "=", productConfigPlanDO.getPkValue())});
        for (DynamicObject data : coll) {
            featurenumid = data.getLong("featurenumid");
            boolean issolid = data.getBoolean("issolid");
            dataMapA.put(featurenumid, issolid);
        }
        sp = "featureinfo.subentryentity.featureid featureid,featureinfo.subentryentity.featurevalue featurevalue";
        coll = QueryServiceHelper.query((String)"pdm_proconfigscheme", (String)sp, (QFilter[])new QFilter[]{new QFilter("id", "=", productConfigPlanDO.getPkValue())});
        for (DynamicObject data : coll) {
            Long featureid = data.getLong("featureid");
            String featurevalue = data.getString("featurevalue");
            dataMapB.put(featureid, StringUtils.isEmpty((CharSequence)featurevalue));
        }
        for (Map.Entry entrys : dataMapA.entrySet()) {
            featurenumid = (Long)entrys.getKey();
            boolean issolid = (Boolean)entrys.getValue();
            if (issolid) continue;
            dataMapA.put(featurenumid, (Boolean)dataMapB.get(featurenumid));
        }
        return dataMapA;
    }

    private void setComponentFeature(DynamicObjectCollection configureFeatures, DynamicObjectCollection modelFreatures, Map<Long, Boolean> fsMap, String status) {
        String featureNumID;
        if (configureFeatures == null || configureFeatures.isEmpty()) {
            return;
        }
        HashMap configFeatureMap = new HashMap(8);
        ArrayList<Object> seqList = new ArrayList<Object>(8);
        if (configureFeatures != null && !configureFeatures.isEmpty()) {
            for (DynamicObject configureEntryDO : configureFeatures) {
                Iterator featureNumID2 = configureEntryDO.getString("featurenumberid");
                List featueValList = configFeatureMap.getOrDefault(featureNumID2, new ArrayList(4));
                featueValList.add(configureEntryDO);
                configFeatureMap.put(featureNumID2, featueValList);
                if (seqList.contains(featureNumID2)) continue;
                seqList.add(featureNumID2);
            }
        }
        boolean existsModelEntry = true;
        HashMap<String, List<DynamicObject>> modelFeatureMap = new HashMap<String, List<DynamicObject>>(8);
        if (modelFreatures != null && !modelFreatures.isEmpty()) {
            for (DynamicObject modelFeature : modelFreatures) {
                featureNumID = modelFeature.getString("featurenumberid");
                List featueValList = modelFeatureMap.getOrDefault(featureNumID, new ArrayList(4));
                featueValList.add(modelFeature);
                modelFeatureMap.put(featureNumID, featueValList);
                if (seqList.contains(featureNumID)) continue;
                seqList.add(featureNumID);
            }
        } else {
            modelFeatureMap = configFeatureMap;
            existsModelEntry = false;
        }
        for (Map.Entry entry : modelFeatureMap.entrySet()) {
            featureNumID = (String)entry.getKey();
            List valueList = (List)entry.getValue();
            List<DynamicObject> confFeatureList = (List<DynamicObject>)configFeatureMap.get(featureNumID);
            List<DynamicObject> resultList = existsModelEntry ? this.handleEqualsEntry(valueList, confFeatureList) : confFeatureList;
            if (resultList == null) continue;
            modelFeatureMap.put(featureNumID, resultList);
        }
        this.getModel().deleteEntryData("entryentity");
        for (int i = 0; i < seqList.size(); ++i) {
            String featureNumID3 = (String)seqList.get(i);
            List features = (List)modelFeatureMap.get(featureNumID3);
            for (int j = 0; j < features.size(); ++j) {
                DynamicObject feature = (DynamicObject)features.get(j);
                String value = feature.getString("featurevalue");
                int newEntryRow = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("featureid", feature.get("featureid"), newEntryRow);
                this.getModel().setValue("featurenumberid", feature.get("featurenumberid"), newEntryRow);
                this.getModel().setValue("featurevalueid", feature.get("featurevalueid"), newEntryRow);
                this.getModel().setValue("featurevalue", (Object)value, newEntryRow);
                this.getModel().setValue("featurevaluename", feature.get("featurevaluename"), newEntryRow);
                this.getModel().setValue("configprocess", feature.get("configprocess"), newEntryRow);
                boolean isSolid = true;
                if (StringUtils.isNotEmpty((CharSequence)value) && fsMap != null) {
                    isSolid = fsMap.get(feature.getLong("featurenumberid"));
                }
                this.getView().setEnable(Boolean.valueOf(isSolid), newEntryRow, new String[]{"featurevalue"});
            }
        }
    }

    private void setFeatureData(DataEntityPropertyCollection confFeatureProps, DynamicObject feature, DataEntityPropertyCollection modelProps, DynamicObject modelFeature) {
        if (confFeatureProps == null || feature == null || modelProps == null || modelFeature == null) {
            return;
        }
        for (int i = 0; i < confFeatureProps.size(); ++i) {
            IDataEntityProperty property = (IDataEntityProperty)confFeatureProps.get(i);
            if ("id".equals(property.getName()) || !modelProps.contains((Object)property)) continue;
            modelFeature.set(property, feature.get(property));
        }
    }

    private List<DynamicObject> handleEqualsEntry(List<DynamicObject> valueList, List<DynamicObject> confFeatureList) {
        if (valueList == null || confFeatureList == null || confFeatureList.isEmpty()) {
            return valueList;
        }
        ArrayList<DynamicObject> mulFeaturVals = new ArrayList<DynamicObject>(4);
        for (int i = 0; i < confFeatureList.size(); ++i) {
            DynamicObject confFeature = confFeatureList.get(i);
            DynamicObject feature = confFeature.getDynamicObject("featureid");
            String featureNumID = confFeature.getString("featurenumberid");
            String featureValID = confFeature.getString("featurevalueid");
            String featureVal = confFeature.getString("featurevalue");
            String featureValName = confFeature.getString("featurevaluename");
            String confProcess = confFeature.getString("configprocess");
            boolean isExsit = false;
            for (int j = 0; j < valueList.size(); ++j) {
                DynamicObject value = valueList.get(j);
                DynamicObject modelFeature = value.getDynamicObject("featureid");
                String modelFeatureNumID = value.getString("featurenumberid");
                String modelFeatureValID = value.getString("featurevalueid");
                String modelFeatureVal = value.getString("featurevalue");
                String modelFeatureValName = value.getString("featurevaluename");
                String modelConfProcess = value.getString("configprocess");
                if (StringUtils.isEmpty((CharSequence)modelFeatureVal) && (StringUtils.isEmpty((CharSequence)modelFeatureValID) || "0".equals(modelFeatureValID))) {
                    value.set("featurevalue", confFeature.get("featurevalue"));
                    value.set("featurevalueid", confFeature.get("featurevalueid"));
                    value.set("featurevaluename", confFeature.get("featurevaluename"));
                    value.set("configprocess", confFeature.get("configprocess"));
                    isExsit = true;
                    continue;
                }
                if (!StringUtils.equals((CharSequence)modelFeatureValID, (CharSequence)featureValID) || !StringUtils.equals((CharSequence)featureVal, (CharSequence)modelFeatureVal)) continue;
                isExsit = true;
            }
            if (isExsit) continue;
            mulFeaturVals.add(confFeature);
        }
        if (!mulFeaturVals.isEmpty()) {
            valueList.addAll(mulFeaturVals);
        }
        return valueList;
    }

    private void setComponentEntry(DynamicObjectCollection configureEntry, DynamicObjectCollection modelTreeEntry) {
        if (configureEntry == null || configureEntry.isEmpty() || modelTreeEntry == null || modelTreeEntry.isEmpty()) {
            return;
        }
        for (DynamicObject configureEntryDO : configureEntry) {
            DynamicObject configureEntryMat = configureEntryDO.getDynamicObject("entrymaterial");
            Long configureEntryMatPk = configureEntryMat != null ? configureEntryMat.getLong("id") : 0L;
            if (configureEntryMat != null) {
                configureEntryMatPk = configureEntryMat.getLong("id");
            }
            for (DynamicObject modelEntryDO : modelTreeEntry) {
                DynamicObject modelEntryMat = modelEntryDO.getDynamicObject("entrymaterial");
                Long modelEntryMatPk = modelEntryMat != null ? modelEntryMat.getLong("id") : 0L;
                if (configureEntryMatPk <= 0L || modelEntryMatPk <= 0L || configureEntryMatPk.compareTo(modelEntryMatPk) != 0) continue;
                Object configurEntryAux = configureEntryDO.get("entryauxproperty");
                Object configurEntryQty = configureEntryDO.get("entryqty");
                Object configurEntryQtyNumerator = configureEntryDO.get("entryqtynumerator");
                Object configurEntryQtyDe = configureEntryDO.get("entryqtydenominator");
                modelEntryDO.set("checkbox", (Object)true);
                modelEntryDO.set("entryauxproperty", configurEntryAux);
                modelEntryDO.set("entryqty", configurEntryQty);
                modelEntryDO.set("entryqtynumerator", configurEntryQtyNumerator);
                modelEntryDO.set("entryqtydenominator", configurEntryQtyDe);
            }
        }
    }

    private String getBomOpenTypeToPlan(DynamicObject productConfigPlanDO) {
        if (productConfigPlanDO == null) {
            return "";
        }
        String bomopentype = "";
        Long planPk = productConfigPlanDO.getLong("id");
        DynamicObject planDO = BusinessDataServiceHelper.loadSingle((Object)planPk, (String)"pdm_proconfigscheme", (String)"id,bomopentype");
        if (planDO != null) {
            bomopentype = planDO.getString("bomopentype");
        }
        return bomopentype;
    }

    private void setEntityEnable(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"treeentryentity"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"entryentity"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"prodorgid"});
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"simula"});
    }

    private void writeDynamicConllectionData(DynamicObjectCollection entryEntity, DynamicObjectCollection newEntryEntity) {
        if (entryEntity == null || newEntryEntity == null || newEntryEntity.isEmpty()) {
            return;
        }
        entryEntity.clear();
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection newProperties = newEntryEntity.getDynamicObjectType().getProperties();
        for (int i = 0; i < newEntryEntity.size(); ++i) {
            DynamicObject entryDO = entryEntity.addNew();
            DynamicObject newEntryDO = (DynamicObject)newEntryEntity.get(i);
            for (int j = 0; j < newProperties.size(); ++j) {
                IDataEntityProperty property = (IDataEntityProperty)newProperties.get(j);
                if (!properties.containsKey((Object)property.getName())) continue;
                entryDO.set(property.getName(), newEntryDO.get(property.getName()));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        TextEdit itemselector = (TextEdit)this.getControl("itemselector");
        itemselector.addClickListener((ClickListener)this);
        TextEdit featurevalue = (TextEdit)this.getView().getControl("featurevalue");
        if (featurevalue != null) {
            featurevalue.addClickListener((ClickListener)this);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"featurevalue")) {
            this.setShowFeatureSelect();
        }
    }

    private void setShowFeatureSelect() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        int row = selectRows[0];
        Object featureid = this.getModel().getValue("featureid", row);
        DynamicObject featureDO = null;
        String featureType = "";
        int len = -1;
        long featurePKValue = 0L;
        boolean isAllowMulValue = false;
        boolean isAllowNegative = false;
        ProConfigPreConditionBusiness business = new ProConfigPreConditionBusiness();
        DynamicObjectCollection entryCol = model.getEntryEntity("entryentity");
        Map featureValMap = business.getSelectFeatureAndVal(entryCol);
        if (featureid == null) {
            Object featureNumberIDObj = this.getModel().getValue("featurenumberid", row);
            if (StringUtils.isNotBlank((Object)featureNumberIDObj) && Pattern.matches("^[0-9]*$", featureNumberIDObj.toString())) {
                featurePKValue = Long.parseLong(featureNumberIDObj.toString());
                featureDO = BusinessDataServiceHelper.loadSingle((Object)featurePKValue, (String)"pdm_featuredefinition");
            }
        } else {
            featureDO = (DynamicObject)featureid;
        }
        if (featureDO instanceof DynamicObject) {
            featureType = featureDO.getString("featuretype");
            featurePKValue = featureDO.getLong("id");
            isAllowMulValue = featureDO.getBoolean("isallowmulvalue");
            isAllowNegative = featureDO.getBoolean("isallownegative");
            if (StringUtils.equals((CharSequence)featureType, (CharSequence)"A")) {
                len = featureDO.getInt("length");
            } else if (StringUtils.equals((CharSequence)featureType, (CharSequence)"B")) {
                len = featureDO.getInt("precision");
            }
        }
        DynamicObjectCollection featureListDOC = model.getEntryEntity("entryentity");
        List<Map<String, Object>> selectParamData = this.getFeatureDOList(featureListDOC, featurePKValue);
        ArrayList<Map<String, Object>> valueData = new ArrayList(4);
        boolean isEdit = false;
        DynamicObjectCollection treeEntryEntity = null;
        if (featureDO != null) {
            treeEntryEntity = featureDO.getDynamicObjectCollection("treeentryentity");
        }
        if (treeEntryEntity != null && !treeEntryEntity.isEmpty()) {
            for (DynamicObject entryDO : treeEntryEntity) {
                if (entryDO == null) continue;
                HashMap<String, Object> entryMap = new HashMap<String, Object>(4);
                String entryValue = entryDO.getString("entryvalue");
                String entryvalueName = entryDO.getString("entryvaluename");
                DynamicObject entryConfigRule = entryDO.getDynamicObject("entryconfigrule");
                long entryPK = entryDO.getLong("id");
                long featureValueId = 0L;
                String featurevalueid = entryDO.getString("featurevalueid");
                if (StringUtils.isNotEmpty((CharSequence)featurevalueid) && Pattern.matches("^[0-9]*$", featurevalueid)) {
                    featureValueId = Long.parseLong(featurevalueid);
                }
                if (!business.isMeetPreCondition(featureValMap, entryConfigRule)) continue;
                entryMap.put("entryvalue", entryValue);
                entryMap.put("entryvaluename", entryvalueName);
                entryMap.put("entryid", entryPK);
                entryMap.put("entryauxvalueid", featureValueId);
                valueData.add(entryMap);
            }
        } else {
            isEdit = true;
            List<Map<String, Object>> cacheManualDataList = this.queryFeatureValueCacheManualData(view, model, row);
            valueData = cacheManualDataList;
        }
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("isallownegative", isAllowNegative);
        param.put("len", len);
        param.put("featuretype", featureType);
        this.showWorkScopeForm(param, valueData, selectParamData, isAllowMulValue, isEdit);
    }

    private void showWorkScopeForm(Map<String, Object> paramData, List<Map<String, Object>> valueData, List<Map<String, Object>> selectParamData, boolean isAllowMulValue, boolean isEdit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("list", valueData);
        params.put("selectData", selectParamData);
        params.put("isedit", isEdit);
        params.put("isallowmulvalue", isAllowMulValue);
        params.put("formId", "pdm_featurevalselector");
        if (paramData != null) {
            params.putAll(paramData);
        }
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(params);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "featurevalueselect"));
        this.getView().showForm(showParameter);
    }

    private List<Map<String, Object>> queryFeatureValueCacheManualData(IFormView view, IDataModel model, int row) {
        String cacheManualDataJSON;
        DynamicObject featureDO;
        List<Map<String, Object>> cacheManualDataList = new ArrayList<Map<String, Object>>(2);
        if (view == null || model == null) {
            return cacheManualDataList;
        }
        Object featureObj = model.getValue("featureid", row);
        String featurePkStr = "";
        if (featureObj instanceof DynamicObject && (featureDO = (DynamicObject)featureObj).getPkValue() != null) {
            featurePkStr = String.valueOf(featureDO.getPkValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)(cacheManualDataJSON = view.getPageCache().get(featurePkStr)))) {
            cacheManualDataList = (List)JSONObject.parseObject((String)cacheManualDataJSON, List.class);
        }
        return cacheManualDataList;
    }

    private List<Map<String, Object>> getFeatureDOList(DynamicObjectCollection featureListDOC, long featurePKValue) {
        if (featureListDOC == null) {
            return null;
        }
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(4);
        for (DynamicObject featureListDO : featureListDOC) {
            if (featureListDO == null) continue;
            HashMap<String, String> param = new HashMap<String, String>(4);
            String featurenumberid = featureListDO.getString("featurenumberid");
            if (!StringUtils.equals((CharSequence)featurenumberid, (CharSequence)String.valueOf(featurePKValue))) continue;
            String featureValueID = featureListDO.getString("featurevalueid");
            String featureValue = featureListDO.getString("featurevalue");
            String featureValueName = featureListDO.getString("featurevaluename");
            if (!StringUtils.isNotEmpty((CharSequence)featureValue) && !StringUtils.isNotEmpty((CharSequence)featureValueName) && !StringUtils.isNotEmpty((CharSequence)featureValueID)) continue;
            param.put("entryid", featureValueID);
            param.put("entryvalue", featureValue);
            param.put("entryvaluename", featureValueName);
            paramList.add(param);
        }
        return paramList;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Map map = (Map)evt.getReturnData();
        if (map == null) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (StringUtils.equals((CharSequence)"featurevalueselect", (CharSequence)actionId)) {
            this.callBackItemSelector(view, model, map);
            this.showRelationFeature(map, index);
            this.showConditionFeature(map, index);
        }
    }

    private void showConditionFeature(Map<String, Object> callBackDataMap, int index) {
        if (callBackDataMap == null) {
            return;
        }
        Object datas = callBackDataMap.get("datas");
        if (datas == null) {
            return;
        }
        ArrayList<Map<String, Object>> dataList = new ArrayList(8);
        if (datas instanceof List) {
            dataList = (List)datas;
        }
        if (dataList.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection entryCol = model.getEntryEntity("entryentity");
        this.hideFeature(entryCol, dataList, index);
        this.showFeature(entryCol, dataList, index);
    }

    /*
     * WARNING - void declaration
     */
    private void showFeature(DynamicObjectCollection entryCol, List<Map<String, Object>> dataList, int index) {
        int n;
        String featureId;
        void var16_22;
        IDataModel model = this.getModel();
        ProConfigPreConditionBusiness business = new ProConfigPreConditionBusiness();
        Map featureValMap = business.getSelectFeatureAndVal(entryCol);
        HashSet<String> existFeatureIdSet = new HashSet<String>(entryCol.size());
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            String featureId3 = entryObj.getString("featurenumberid");
            existFeatureIdSet.add(featureId3);
        }
        DynamicObject configPlan = (DynamicObject)model.getValue("productconfigplan");
        DynamicObjectCollection featureTypeCol = configPlan.getDynamicObjectCollection("featureinfo");
        HashSet<Long> featureIdSet = new HashSet<Long>(featureTypeCol.size());
        for (int i = 0; i < featureTypeCol.size(); ++i) {
            DynamicObject featureTypeEntry = (DynamicObject)featureTypeCol.get(i);
            DynamicObjectCollection featureEntryCol = featureTypeEntry.getDynamicObjectCollection("subentryentity");
            for (Object featureEntry : featureEntryCol) {
                DynamicObject dynamicObject = featureEntry.getDynamicObject("featureid");
                if (dynamicObject == null) continue;
                long featureId2 = dynamicObject.getLong("id");
                featureIdSet.add(featureId2);
            }
        }
        ProdConfigFeatureSearchBusiness featureBusiness = new ProdConfigFeatureSearchBusiness();
        Map featureFormulaMap = featureBusiness.getFeatureFormula(featureIdSet);
        Set entrySet = featureFormulaMap.entrySet();
        HashSet<String> needAddFeatureSet = new HashSet<String>(featureFormulaMap.size());
        for (Map.Entry entry : entrySet) {
            long featureId2 = (Long)entry.getKey();
            Set formulaSet = (Set)entry.getValue();
            Object runFormulaRet = PDMFormulaRunBusiness.getInstance().runFormula("1", formulaSet, featureValMap);
            if (!(runFormulaRet instanceof Boolean) || !((Boolean)runFormulaRet).booleanValue()) continue;
            needAddFeatureSet.add(String.valueOf(featureId2));
        }
        ArrayList<DynamicObject> featureList = new ArrayList<DynamicObject>(featureTypeCol.size());
        boolean bl = false;
        while (var16_22 < featureTypeCol.size()) {
            DynamicObject featureTypeEntry = (DynamicObject)featureTypeCol.get((int)var16_22);
            DynamicObjectCollection featureEntryCol = featureTypeEntry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject featureEntry : featureEntryCol) {
                featureId = featureEntry.getString("featurenumberid");
                if (!needAddFeatureSet.contains(featureId)) continue;
                featureList.add(featureEntry);
            }
            ++var16_22;
        }
        int n2 = entryCol.size();
        if (index >= 0 && dataList != null) {
            n = index + dataList.size();
        }
        for (int i = 0; i < featureList.size(); ++i) {
            DynamicObject obj = (DynamicObject)featureList.get(i);
            int rowIndex = n + i - 1;
            int seq = rowIndex + 1;
            featureId = obj.getString("featurenumberid");
            if (existFeatureIdSet.contains(featureId)) continue;
            model.appendEntryRow("entryentity", rowIndex, 1);
            model.setValue("featurenumberid", obj.get("featurenumberid"), seq);
            model.setValue("featureid", obj.get("featureid"), seq);
            model.setValue("featurevalue", obj.get("featurevalue"), seq);
            model.setValue("featurevaluename", obj.get("featurevaluename"), seq);
            model.setValue("configprocess", (Object)this.CONFIGPROCESS_FROM_FEATURE_ENTRYRULE, seq);
            model.setValue("featurevalueid", obj.get("featurevalueid"), seq);
            this.getView().setEnable(Boolean.valueOf(true), seq, new String[]{"featurevalue"});
        }
    }

    private void hideFeature(DynamicObjectCollection entryCol, List<Map<String, Object>> dataList, int index) {
        IDataModel model = this.getModel();
        if (entryCol == null || entryCol.isEmpty()) {
            return;
        }
        ProConfigPreConditionBusiness business = new ProConfigPreConditionBusiness();
        Map featureValMap = business.getSelectFeatureAndVal(entryCol);
        Map<Long, Set<String>> featureFormulaMap = this.getFeatureFormula(entryCol);
        HashSet<String> deleteFeatureSet = new HashSet<String>(featureFormulaMap.size());
        Set<Map.Entry<Long, Set<String>>> entrySet = featureFormulaMap.entrySet();
        for (Map.Entry<Long, Set<String>> entry : entrySet) {
            long featureId = entry.getKey();
            Set<String> formulaSet = entry.getValue();
            Object runFormulaRet = PDMFormulaRunBusiness.getInstance().runFormula("1", formulaSet, featureValMap);
            if (!(runFormulaRet instanceof Boolean) || ((Boolean)runFormulaRet).booleanValue()) continue;
            deleteFeatureSet.add(String.valueOf(featureId));
        }
        HashSet<Integer> deleteSet = new HashSet<Integer>(entryCol.size());
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            String featureId = entryObj.getString("featurenumberid");
            if (deleteFeatureSet == null || !deleteFeatureSet.contains(featureId)) continue;
            deleteSet.add(i);
        }
        int[] existArray = deleteSet.stream().mapToInt(Integer::intValue).toArray();
        if (existArray.length > 0) {
            this.getModel().deleteEntryRows("entryentity", existArray);
        }
    }

    private Map<Long, Set<String>> getFeatureFormula(DynamicObjectCollection entrtCol) {
        HashMap featureRuleMap = new HashMap(entrtCol.size());
        HashSet<Long> ruleIdSet = new HashSet<Long>(entrtCol.size());
        for (int i = 0; i < entrtCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entrtCol.get(i);
            DynamicObject featureObj = entryObj.getDynamicObject("featureid");
            if (featureObj == null) continue;
            long featureId = featureObj.getLong("id");
            DynamicObjectCollection ruleCol = featureObj.getDynamicObjectCollection("configentity");
            HashSet<Long> featureRuleSet = new HashSet<Long>(entrtCol.size());
            for (DynamicObject ruleEntryObj : ruleCol) {
                DynamicObject ruleObj = ruleEntryObj.getDynamicObject("featurerule");
                if (ruleObj == null) continue;
                long ruleId = ruleObj.getLong("id");
                ruleIdSet.add(ruleId);
                featureRuleSet.add(ruleId);
            }
            featureRuleMap.put(featureId, featureRuleSet);
        }
        ProdConfigFeatureSearchBusiness business = new ProdConfigFeatureSearchBusiness();
        Map ruleMap = business.getProConfigRule(ruleIdSet);
        Set entrySet = featureRuleMap.entrySet();
        HashMap<Long, Set<String>> featureFormulaMap = new HashMap<Long, Set<String>>(entrtCol.size());
        for (Map.Entry entry : entrySet) {
            long featureId = (Long)entry.getKey();
            Set ruleSet = (Set)entry.getValue();
            HashSet<String> formulaSet = new HashSet<String>(entrySet.size());
            Iterator iterator = ruleSet.iterator();
            while (iterator.hasNext()) {
                long ruleId = (Long)iterator.next();
                DynamicObject ruleObj = (DynamicObject)ruleMap.get(ruleId);
                if (ruleObj == null) continue;
                String formula = ruleObj.getString("formula");
                formulaSet.add(formula);
            }
            if (formulaSet.isEmpty()) continue;
            featureFormulaMap.put(featureId, formulaSet);
        }
        return featureFormulaMap;
    }

    private void showRelationFeature(Map<String, Object> callBackDataMap, int index) {
        Object curEntryObj = this.getModel().getValue("featureid", index);
        if (curEntryObj == null) {
            return;
        }
        DynamicObject curFeatureObj = (DynamicObject)curEntryObj;
        String curFeatureId = curFeatureObj.getString("id");
        this.deleteExistEntryRow(curFeatureId);
        if (callBackDataMap == null) {
            return;
        }
        Object datas = callBackDataMap.get("datas");
        if (datas == null) {
            return;
        }
        ArrayList<Map<String, Object>> dataList = new ArrayList(8);
        if (datas instanceof List) {
            dataList = (List)datas;
        }
        if (dataList.isEmpty()) {
            return;
        }
        JSONArray featureArray = this.getFeatureList(dataList, index);
        if (featureArray == null || featureArray.isEmpty()) {
            return;
        }
        int size = dataList.size();
        int startIndex = index + size;
        this.addFeatureList(featureArray, curFeatureId, startIndex);
    }

    private void addFeatureList(JSONArray featureArray, String curFeatureId, int startIndex) {
        IDataModel model = this.getModel();
        if (featureArray == null || featureArray.isEmpty()) {
            return;
        }
        HashSet<Long> featureIdSet = new HashSet<Long>(featureArray.size());
        for (int i = 0; i < featureArray.size(); ++i) {
            JSONObject obj = featureArray.getJSONObject(i);
            int rowIndex = startIndex + i - 1;
            int seq = rowIndex + 1;
            long featureId = obj.getLong("featureid");
            model.appendEntryRow("entryentity", rowIndex, 1);
            model.setValue("featurenumberid", obj.get((Object)"featurenumberid"), seq);
            if (!featureIdSet.contains(featureId)) {
                model.setValue("featureid", obj.get((Object)"featureid"), seq);
            }
            model.setValue("featurevalue", obj.get((Object)"featurevalue"), seq);
            model.setValue("featurevaluename", obj.get((Object)"featurevaluename"), seq);
            model.setValue("configprocess", (Object)this.CONFIGPROCESS_FROM_FEATURE_ENTRYRULE, seq);
            model.setValue("featurevalueid", obj.get((Object)"featurevalueid"), seq);
            model.setValue("fromfeatureid", (Object)curFeatureId, seq);
            featureIdSet.add(featureId);
            this.getView().setEnable(Boolean.valueOf(false), seq, new String[]{"featurevalue"});
        }
    }

    private void deleteExistEntryRow(String curFeatureId) {
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
        HashSet<Integer> existSet = new HashSet<Integer>(entryCol.size());
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            String fromFeatureId = entryObj.getString("fromfeatureid");
            if (curFeatureId == null || "".equals(curFeatureId) || !curFeatureId.equals(fromFeatureId)) continue;
            existSet.add(i);
        }
        int[] existArray = existSet.stream().mapToInt(Integer::intValue).toArray();
        if (existArray.length > 0) {
            this.getModel().deleteEntryRows("entryentity", existArray);
        }
    }

    private JSONArray getFeatureList(List<Map<String, Object>> dataList, int index) {
        JSONArray retArray = new JSONArray(64);
        DynamicObject featureObj = (DynamicObject)this.getModel().getValue("featureid", index);
        if (dataList == null || dataList.isEmpty() || featureObj == null) {
            return retArray;
        }
        ProdConfigFeatureSearchBusiness business = new ProdConfigFeatureSearchBusiness();
        String featureNum = featureObj.getString("number");
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            Object entryValue = dataMap.get("entryvalue");
            JSONObject param = new JSONObject();
            param.put("featureNum", (Object)featureNum);
            param.put("featureVal", entryValue);
            JSONArray featureArray = business.getRelationFeature(param.toJSONString());
            if (featureArray == null || featureArray.isEmpty()) continue;
            retArray.addAll((Collection)featureArray);
        }
        return retArray;
    }

    private void callBackItemSelector(IFormView view, IDataModel model, Map<String, Object> callBackDataMap) {
        if (view == null || model == null || callBackDataMap == null) {
            return;
        }
        Object datas = callBackDataMap.get("datas");
        List<Map<String, Object>> dataList = new ArrayList(8);
        EntryGrid subentryGrid = (EntryGrid)this.getControl("entryentity");
        int[] subEntrySelects = subentryGrid.getSelectRows();
        if (subEntrySelects != null && subEntrySelects.length > 0) {
            int row = subEntrySelects[0];
            Object cacheManualData = callBackDataMap.get("cachemanualdata");
            this.recordCacheManualData(view, model, cacheManualData, row);
            if (datas instanceof List) {
                dataList = (List)datas;
            }
            Object featureIDObj = model.getValue("featureid", row);
            Long featureID = 0L;
            if (featureIDObj instanceof DynamicObject) {
                DynamicObject featureIDDO = (DynamicObject)featureIDObj;
                featureID = featureIDDO.getLong("id");
            }
            model.beginInit();
            this.clearSubEntryData(featureID, model);
            if (dataList != null && !dataList.isEmpty()) {
                this.callBackWriteFeatureValue(view, model, dataList, featureID, row);
            }
            model.endInit();
            view.updateView("entryentity");
            this.setDefaultFeatureValueEnable(null, "", row);
        }
    }

    private Set<Integer> getLockIndexSet(Map<Long, Boolean> fsMap) {
        Set<Integer> lockIndexSet = new HashSet<Integer>(16);
        if (fsMap == null || fsMap.isEmpty()) {
            String cacheIds = this.getPageCache().get(CACHE_LOCKROWS);
            lockIndexSet = this.ParseStringToIntSet(cacheIds);
        }
        return lockIndexSet;
    }

    private void setDefaultFeatureValueEnable(Map<Long, Boolean> fsMap, String status, int row) {
        String featureValueNotEnable = this.getView().getPageCache().get("featurevaluenotenable");
        Set featureValueSet = (Set)JSONObject.parseObject((String)featureValueNotEnable, (TypeReference)new TypeReference<HashSet<String>>(){}, (Feature[])new Feature[0]);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null) {
            return;
        }
        Set<Integer> lockIndexSet = this.getLockIndexSet(fsMap);
        boolean isFirstLoad = fsMap != null;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryDO = (DynamicObject)entryEntity.get(i);
            if (entryDO == null) continue;
            String featureNumberID = entryDO.getString("featurenumberid");
            boolean isSolid = true;
            if (fsMap != null) {
                String value = entryDO.getString("featurevalue");
                if (StringUtils.isNotEmpty((CharSequence)value) && fsMap != null) {
                    isSolid = fsMap.get(entryDO.getLong("featurenumberid"));
                } else if (!isSolid && "A".equals(status)) {
                    isSolid = true;
                }
            }
            if (entryDO.getDynamicObject("featureid") == null) {
                isSolid = false;
            }
            if (isFirstLoad) {
                lockIndexSet.add(isSolid ? -1 : i);
            } else {
                boolean bl = isSolid = !lockIndexSet.contains(i);
                if (entryDO.getDynamicObject("featureid") == null) {
                    isSolid = false;
                }
            }
            this.getView().setEnable(Boolean.valueOf(isSolid), i, new String[]{"featurevalue"});
        }
        if (isFirstLoad) {
            this.getPageCache().put(CACHE_LOCKROWS, lockIndexSet.toString());
        }
    }

    private void callBackWriteFeatureValue(IFormView view, IDataModel model, List<Map<String, Object>> dataList, Long featureID, int row) {
        if (view == null || model == null || dataList == null) {
            return;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            if (i == 0) {
                this.writeFeatureEntryInfo(model, dataMap, featureID, row);
                continue;
            }
            model.insertEntryRow("entryentity", row + i);
            this.writeFeatureEntryInfo(model, dataMap, featureID, row + i);
            view.setEnable(Boolean.valueOf(false), row + i, new String[]{"featurevalue"});
        }
    }

    private void writeFeatureEntryInfo(IDataModel model, Map<String, Object> dataMap, Long featureID, int row) {
        Object entryValue = dataMap.get("entryvalue");
        Object entryValueName = dataMap.get("entryvaluename");
        Object entryid = dataMap.get("entryid");
        model.setValue("featurevalue", entryValue, row);
        model.setValue("featurevaluename", entryValueName, row);
        model.setValue("featurevalueid", entryid, row);
        model.setValue("configprocess", (Object)this.CONFIGPROCESS_USER_SETUP, row);
        if (featureID > 0L) {
            model.setValue("featurenumberid", (Object)featureID, row);
        }
    }

    private void recordCacheManualData(IFormView view, IDataModel model, Object cacheManualData, int row) {
        DynamicObject featureDO;
        if (view == null || model == null || cacheManualData == null) {
            return;
        }
        List cacheManualDataList = new ArrayList(8);
        Object featureObj = model.getValue("featureid", row);
        String featurePkStr = "";
        if (featureObj instanceof DynamicObject && (featureDO = (DynamicObject)featureObj).getPkValue() != null) {
            featurePkStr = String.valueOf(featureDO.getPkValue());
        }
        if (cacheManualData instanceof List) {
            cacheManualDataList = (List)cacheManualData;
            String cacheManualDataJson = JSONObject.toJSONString(cacheManualDataList);
            view.getPageCache().put(featurePkStr, cacheManualDataJson);
        }
    }

    private void clearSubEntryData(Long featureID, IDataModel model) {
        if (model == null) {
            return;
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        if (entryEntity == null) {
            return;
        }
        HashSet<Integer> rowSet = new HashSet<Integer>(4);
        int index = -1;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryDO = (DynamicObject)entryEntity.get(i);
            if (entryDO == null) continue;
            String featureNumberID = entryDO.getString("featurenumberid");
            DynamicObject featureDO = entryDO.getDynamicObject("featureid");
            int seq = entryDO.getInt("seq");
            if (StringUtils.equals((CharSequence)String.valueOf(featureID), (CharSequence)featureNumberID) && featureDO == null) {
                rowSet.add(seq - 1);
                continue;
            }
            if (!StringUtils.equals((CharSequence)String.valueOf(featureID), (CharSequence)featureNumberID) || featureDO == null) continue;
            index = seq - 1;
        }
        Integer[] rowInts = rowSet.toArray(new Integer[rowSet.size()]);
        int[] rows = Arrays.stream(rowInts).mapToInt(Integer::intValue).toArray();
        if (index > -1) {
            model.setValue("featurevalue", (Object)"", index);
            model.setValue("featurevaluename", (Object)"", index);
            model.setValue("featurevalueid", (Object)"", index);
        }
        if (rows != null && rows.length > 0) {
            model.deleteEntryRows("entryentity", rows);
        }
    }

    public void beforeBindData(EventObject e) {
        this.getModel().setDataChanged(true);
        super.beforeBindData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String string = "donothing_savelist,donothing_savefeaturelist";
        DynamicObject useorg = this.getModel().getDataEntity().getDynamicObject("createorg");
        long orgId = Long.parseLong(useorg.getPkValue().toString());
        if (StringUtils.contains((CharSequence)string, (CharSequence)operate.getOperateKey()) && !this.getPermissionByUser(orgId)) {
            args.setCancel(true);
            String number = useorg.getString("number");
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e3a\u201c%1$s\u201d\u6ca1\u6709\u201c\u4ea7\u54c1\u914d\u7f6e\u6e05\u5355\u201d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"ProductConfigsEdit_8", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), number));
            return;
        }
        String defAndValObjListStr = this.packageSaveParam();
        if (StringUtils.isNotEmpty((CharSequence)defAndValObjListStr)) {
            this.getPageCache().put("ProdConfigureFeatureDefAndValObj", defAndValObjListStr);
        }
        if (StringUtils.equals((CharSequence)"donothing_savelist", (CharSequence)operate.getOperateKey())) {
            if (!this.checkTreeEntryData(true) || !this.checkEntryNumeratorDenominator()) {
                args.setCancel(true);
                return;
            }
            String node = this.getPageCache().get("deadnode");
            if (!StringUtils.isBlank((CharSequence)node)) {
                this.getView().showTipNotification(String.format(MESSAGE, node));
                args.setCancel(true);
                return;
            }
            this.setOptionVariableVal(operate);
            this.setSelectComponentSeqList(operate);
        } else if (StringUtils.equals((CharSequence)"donothing_savefeaturelist", (CharSequence)operate.getOperateKey())) {
            if (!this.checkTreeEntryData(false)) {
                args.setCancel(true);
                return;
            }
            if (this.isFrontOperateError(args, operate)) {
                return;
            }
            this.setSelectFeatureList(operate);
        }
    }

    private boolean checkTreeEntryData(boolean isEntry) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (isEntry) {
            DynamicObjectCollection treeEntry = model.getEntryEntity("treeentryentity");
            if (treeEntry == null || treeEntry.isEmpty()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u7ec4\u4ef6\u9009\u914d\u65f6\uff0c\u7ec4\u4ef6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProductConfigsEdit_9", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            DynamicObjectCollection treeEntry = model.getEntryEntity("entryentity");
            if (treeEntry == null || treeEntry.isEmpty()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u7279\u5f81\u9009\u914d\u65f6\uff0c\u7279\u5f81\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProductConfigsEdit_10", (String)"mmc-pdm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean checkEntryNumeratorDenominator() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection entryEntity = model.getEntryEntity("treeentryentity");
        if (entryEntity == null || entryEntity.isEmpty()) {
            return true;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entryDO = (DynamicObject)entryEntity.get(i);
            BigDecimal minqtyopt = entryDO.getBigDecimal("minqtyopt");
            BigDecimal maxqtyopt = entryDO.getBigDecimal("maxqtyopt");
            BigDecimal entryNumerator = entryDO.getBigDecimal("entryqtynumerator");
            BigDecimal entryDenominator = entryDO.getBigDecimal("entryqtydenominator");
            if (entryDenominator == null || entryDenominator.compareTo(BigDecimal.ZERO) == 0) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5e8f\u53f7\u4e3a%1$s\u7684\u7ec4\u4ef6\u7528\u91cf\uff1a\u5206\u6bcd\u4e0d\u80fd\u4e3a0\u3002", (String)"ProductConfigsEdit_11", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), entryDO.getString("entryseq")));
                return false;
            }
            String minqtyoptStr = minqtyopt.stripTrailingZeros().toPlainString();
            String maxqtyoptStr = maxqtyopt.stripTrailingZeros().toPlainString();
            boolean isQtyOpt = this.isQtyOpt(entryDO);
            if (!isQtyOpt || this.checkEntryQtyRange(minqtyopt, maxqtyopt, entryNumerator, entryDenominator)) continue;
            String symbol = "[";
            if (minqtyopt.compareTo(BigDecimal.ZERO) == 0) {
                symbol = "(";
            }
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5e8f\u53f7\u4e3a%1$s\u7684\u7ec4\u4ef6\u201c\u7528\u91cf\uff1a\u5206\u5b50\u201d/\u201c\u7528\u91cf\uff1a\u5206\u6bcd\u201d\u5fc5\u987b\u5927\u4e8e0\u4e14\u5728\u8303\u56f4[%2$s\u3001%3$s\u3001%4$s]\u5185\u3002", (String)"ProductConfigsEdit_12", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), entryDO.getString("entryseq"), symbol, minqtyoptStr, maxqtyoptStr));
            return false;
        }
        return true;
    }

    private boolean isQtyOpt(DynamicObject entryDO) {
        boolean isQtyOpt = false;
        String qtyOpt = this.getView().getPageCache().get("qtyopt");
        Set qtyoptSet = new HashSet(2);
        if (StringUtils.isNotBlank((CharSequence)qtyOpt)) {
            qtyoptSet = (Set)SerializationUtils.deSerializeFromBase64((String)qtyOpt);
        }
        if (entryDO != null) {
            long matPk;
            DynamicObject matDO = entryDO.getDynamicObject("entrymaterial");
            long l = matPk = matDO == null ? 0L : matDO.getLong("id");
            if (matPk > 0L && qtyoptSet.contains(matPk)) {
                isQtyOpt = true;
            }
        }
        return isQtyOpt;
    }

    private boolean getPermissionByUser(long orgId) {
        RequestContext requestContext = RequestContext.get();
        long userId = Long.parseLong(requestContext.getUserId());
        int checkFunctionPermission = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)orgId, (String)"pdm_productconfigure", (String)"47156aff000000ac");
        return checkFunctionPermission == 1;
    }

    private void setSelectFeatureList(FormOperate operate) {
        String defAndValObjString;
        DynamicObject productconfigplan = (DynamicObject)this.getModel().getValue("productconfigplan");
        if (null != productconfigplan) {
            Object configtype = productconfigplan.get("configtype");
            operate.getOption().setVariableValue("configtype", configtype.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)(defAndValObjString = this.getPageCache().get("ProdConfigureFeatureDefAndValObj")))) {
            List defAndValObj = (List)JSONObject.parseObject((String)defAndValObjString, (TypeReference)new TypeReference<List<ProdConfigureFeatureDefAndValObj>>(){}, (Feature[])new Feature[0]);
            operate.getOption().setVariableValue("featureRows", JSON.toJSONString((Object)defAndValObj));
        }
    }

    private String packageSaveParam() {
        IDataModel model = this.getModel();
        DynamicObjectCollection featureEntryDOC = model.getEntryEntity("entryentity");
        if (featureEntryDOC == null || featureEntryDOC.isEmpty()) {
            return "";
        }
        ArrayList<ProdConfigureFeatureDefAndValObj> proConfFeatureDefs = new ArrayList<ProdConfigureFeatureDefAndValObj>(8);
        HashMap<String, List<DynamicObject>> featureDefSelMap = new HashMap<String, List<DynamicObject>>(4);
        for (int i = 0; i < featureEntryDOC.size(); ++i) {
            DynamicObject featureEntryDO = (DynamicObject)featureEntryDOC.get(i);
            DynamicObject featureDO = featureEntryDO.getDynamicObject("featureid");
            String featureDefPK = "";
            if (featureDO != null) {
                Object featurePkObj;
                ProdConfigureFeatureDefAndValObj proConfFeatureDef = this.getProConfFeatureDef(featureDO);
                if (proConfFeatureDef != null) {
                    proConfFeatureDefs.add(proConfFeatureDef);
                }
                String string = featureDefPK = (featurePkObj = featureDO.getPkValue()) == null ? "" : String.valueOf(featurePkObj);
            }
            if (StringUtils.isEmpty((CharSequence)featureDefPK)) {
                featureDefPK = featureEntryDO.getString("featurenumberid");
            }
            List featureEntryList = featureDefSelMap.getOrDefault(featureDefPK, new ArrayList(4));
            featureEntryList.add(featureEntryDO);
            featureDefSelMap.put(featureDefPK, featureEntryList);
        }
        this.setDefalutSelectValue(featureDefSelMap, proConfFeatureDefs);
        return JSON.toJSONString(proConfFeatureDefs);
    }

    private void setDefalutSelectValue(Map<String, List<DynamicObject>> featureDefSelMap, List<ProdConfigureFeatureDefAndValObj> proConfFeatureDefs) {
        if (featureDefSelMap == null || proConfFeatureDefs == null) {
            return;
        }
        for (int i = 0; i < proConfFeatureDefs.size(); ++i) {
            ProdConfigureFeatureDefAndValObj featureDefAndValObj = proConfFeatureDefs.get(i);
            String featureDefId = featureDefAndValObj.getFeatureDefId();
            List<DynamicObject> featureEntryList = featureDefSelMap.get(featureDefId);
            if (featureEntryList == null || featureEntryList.isEmpty()) continue;
            ArrayList<FeatureValueObj> featureValues = featureDefAndValObj.getFeatureValues();
            if (featureValues == null) {
                featureValues = new ArrayList<FeatureValueObj>();
            }
            if (featureValues.isEmpty()) {
                for (int j = 0; j < featureEntryList.size(); ++j) {
                    DynamicObject featureEntryDO = featureEntryList.get(j);
                    FeatureValueObj featValueObj = this.getFeatureValueObj(featureEntryDO, false);
                    if (featValueObj == null) continue;
                    featureValues.add(featValueObj);
                }
            } else {
                this.setFeaturValueChoose(featureValues, featureEntryList);
            }
            featureDefAndValObj.setFeatureValues(featureValues);
        }
    }

    private void setFeaturValueChoose(List<FeatureValueObj> featureValues, List<DynamicObject> featureEntryList) {
        int i;
        if (featureValues == null || featureEntryList == null || featureEntryList.isEmpty()) {
            return;
        }
        HashSet<String> featureVIdSet = new HashSet<String>(4);
        for (i = 0; i < featureEntryList.size(); ++i) {
            FeatureValueObj featValueObj;
            DynamicObject featureEntryDO = featureEntryList.get(i);
            String featureValueid = featureEntryDO.getString("featurevalueid");
            if (!StringUtils.isEmpty((CharSequence)featureValueid)) {
                featureVIdSet.add(featureValueid);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)featureEntryDO.getString("featurevalue")) || (featValueObj = this.getFeatureValueObj(featureEntryDO, false)) == null) continue;
            featureValues.add(featValueObj);
        }
        for (i = 0; i < featureValues.size(); ++i) {
            FeatureValueObj featureValueObj = featureValues.get(i);
            String featureValueId = featureValueObj.getFeatureValueId();
            if (!featureVIdSet.contains(featureValueId)) continue;
            featureValueObj.setFeatureValueChoose(true);
        }
    }

    private ProdConfigureFeatureDefAndValObj getProConfFeatureDef(DynamicObject featureDO) {
        if (featureDO == null) {
            return null;
        }
        ProdConfigureFeatureDefAndValObj proConfFeatureDef = new ProdConfigureFeatureDefAndValObj();
        Object pkValueObj = featureDO.getPkValue();
        String pkValue = pkValueObj == null ? "" : String.valueOf(pkValueObj);
        String featureNumber = featureDO.getString("number");
        String featureName = featureDO.getString("name");
        boolean isValueMust = featureDO.getBoolean("isvaluemust");
        proConfFeatureDef.setFeatureDefId(pkValue);
        proConfFeatureDef.setFeatureDefNumber(featureNumber);
        proConfFeatureDef.setFeatureDefName(featureName);
        proConfFeatureDef.setFeatureIsValueMust(isValueMust);
        DynamicObjectCollection featureValueDOC = featureDO.getDynamicObjectCollection("treeentryentity");
        if (featureValueDOC != null) {
            ArrayList<FeatureValueObj> featureValues = new ArrayList<FeatureValueObj>(4);
            for (int i = 0; i < featureValueDOC.size(); ++i) {
                FeatureValueObj featValueObj;
                DynamicObject featureValueDO = (DynamicObject)featureValueDOC.get(i);
                if (featureValueDO == null || (featValueObj = this.getFeatureValueObj(featureValueDO, true)) == null) continue;
                featureValues.add(featValueObj);
            }
            proConfFeatureDef.setFeatureValues(featureValues);
        }
        return proConfFeatureDef;
    }

    private FeatureValueObj getFeatureValueObj(DynamicObject featureValueDO, boolean isFeatureDef) {
        boolean isChoose;
        String pkID;
        String entryValueName;
        if (featureValueDO == null) {
            return null;
        }
        FeatureValueObj featValueObj = new FeatureValueObj();
        String entryValue = "";
        if (isFeatureDef) {
            entryValue = featureValueDO.getString("entryvalue");
            entryValueName = featureValueDO.getString("entryvaluename");
            Object fvPkValueObj = featureValueDO.getPkValue();
            pkID = fvPkValueObj == null ? "" : String.valueOf(fvPkValueObj);
            isChoose = false;
        } else {
            entryValue = featureValueDO.getString("featurevalue");
            entryValueName = featureValueDO.getString("featurevaluename");
            pkID = featureValueDO.getString("featurevalueid");
            isChoose = true;
        }
        featValueObj.setFeatureValueId(pkID);
        featValueObj.setFeatureValue(entryValue);
        featValueObj.setFeatureValueName(entryValueName);
        featValueObj.setFeatureValueChoose(isChoose);
        featValueObj.setFeatureValuePId("0");
        return featValueObj;
    }

    private void setSelectComponentSeqList(FormOperate operate) {
        Set<Long> notSelectedPids = this.checkPItemSelected();
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        DynamicObjectCollection checkedAssemblyData = this.getCheckedAssemblyData(ProductConfigPageTypeEnum.DETAILED_LIST.getValue());
        for (DynamicObject dynamicObject : checkedAssemblyData) {
            Integer seq = (Integer)dynamicObject.get("seq");
            long pid = dynamicObject.getLong("pid");
            long id = dynamicObject.getLong("id");
            if (!notSelectedPids.contains(pid)) {
                selectRows.add(seq);
                continue;
            }
            notSelectedPids.add(id);
        }
        StringBuilder selectRow = new StringBuilder();
        Iterator iterator = selectRows.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            selectRow.append(i).append(',');
        }
        operate.getOption().setVariableValue("selectTreeList", selectRow.toString());
    }

    private Set<Long> checkPItemSelected() {
        IDataModel model = this.getModel();
        HashSet<Long> notCheckedIdSet = new HashSet<Long>(64);
        DynamicObjectCollection entryCol = model.getEntryEntity("treeentryentity");
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            boolean isChecked = entryObj.getBoolean("checkbox");
            if (isChecked) {
                long l = entryObj.getLong("pid");
                continue;
            }
            long id = entryObj.getLong("id");
            notCheckedIdSet.add(id);
        }
        return notCheckedIdSet;
    }

    private boolean isFrontOperateError(BeforeDoOperationEventArgs args, FormOperate operate) {
        boolean dataChanged = this.setOptionVariableVal(operate);
        String exceptionMassage = this.getPageCache().get("exceptionMessage");
        if (!dataChanged && !StringUtils.isBlank((CharSequence)exceptionMassage)) {
            String superBomId = this.getPageCache().get("errorSuperBomId");
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)superBomId, (String)"pdm_mftbom");
            Long modifytime = Long.parseLong(this.getPageCache().get("errorSuperBomModifytime"));
            Date newModifytime = loadSingle.getDate("modifytime");
            int compareTo = Long.compare(newModifytime.getTime(), modifytime);
            if (compareTo > 0) {
                this.getModel().setDataChanged(true);
                return false;
            }
            String exceptionMessage = this.getPageCache().get("exceptionMessage");
            this.getView().showErrorNotification(exceptionMessage);
            args.setCancel(true);
            return true;
        }
        if (!this.getModel().getDataChanged() && !StringUtils.isBlank((CharSequence)exceptionMassage)) {
            this.getView().showErrorNotification(exceptionMassage);
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private boolean setOptionVariableVal(FormOperate operate) {
        Long id = (Long)this.getModel().getValue("id");
        if (id != 0L) {
            operate.getOption().setVariableValue("ids", id.toString());
        }
        boolean dataChanged = this.getModel().getDataChanged();
        operate.getOption().setVariableValue("dataChanged", String.valueOf(dataChanged));
        return dataChanged;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"donothing_savelist", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"donothing_savefeaturelist", (CharSequence)operateKey)) {
            String configCodeValue;
            boolean configCodeVariable;
            boolean containsVariable;
            FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
            boolean isBomError = operate.getOption().containsVariable("exceptionMessage");
            if (isBomError) {
                String exceptionMessage = operate.getOption().getVariableValue("exceptionMessage");
                this.getView().getPageCache().put("exceptionMessage", exceptionMessage);
                String modifytime = operate.getOption().getVariableValue("errorSuperBomModifytime");
                this.getView().getPageCache().put("errorSuperBomModifytime", modifytime);
                String superBomId = operate.getOption().getVariableValue("errorSuperBomId");
                this.getView().getPageCache().put("errorSuperBomId", superBomId);
            }
            if (containsVariable = operate.getOption().containsVariable("ids")) {
                String variableValue = operate.getOption().getVariableValue("ids");
                this.getModel().setValue("id", (Object)variableValue);
            }
            if ((configCodeVariable = operate.getOption().containsVariable("configcode")) && StringUtils.isNotEmpty((CharSequence)(configCodeValue = operate.getOption().getVariableValue("configcode")))) {
                this.getModel().setValue("masterconfigcode", (Object)configCodeValue);
                this.getView().updateView("masterconfigcode");
            }
            DynamicObjectCollection decs = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
            List hideMap = (List)Productconfig.getHiddenMap().get(this.getView().getPageId());
            if (null != hideMap && !hideMap.isEmpty()) {
                decs.removeAll((Collection)hideMap);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operateKey = evt.getOperationKey();
        if (StringUtils.equals((CharSequence)"configpreview", (CharSequence)operateKey)) {
            this.showConfigpreview();
        }
    }

    private void showConfigpreview() {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("pdm_pconfigpreview");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        DynamicObject value = (DynamicObject)this.getModel().getValue("productconfigplan");
        String type = value.getString("configtype");
        StyleCss styleCss = new StyleCss();
        showParameter.setCustomParam("previewtype", (Object)type);
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"1", (CharSequence)type)) {
            DynamicObjectCollection decs = this.getCheckedAssemblyData(ProductConfigPageTypeEnum.CONFIG_PREVIEW.getValue());
            Map<Long, String> serialMap = this.getEntryAuxProp(decs);
            showParameter.setCustomParam("decs", (Object)decs);
            showParameter.setCustomParam("serialaux", serialMap);
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)type)) {
            String defAndValString = this.packageSaveParam();
            showParameter.setCustomParam("decs", (Object)defAndValString);
            int count = this.getModel().getEntryRowCount("entryentity");
            HashMap<String, List> map = new HashMap<String, List>(8);
            for (int i = 0; i < count; ++i) {
                String featurePK = "";
                if (model.getValue("featureid", i) == null) {
                    Object featureNumberid = model.getValue("featurenumberid", i);
                    if (StringUtils.isNotBlank((Object)featureNumberid)) {
                        featurePK = featureNumberid.toString();
                    }
                } else {
                    featurePK = ((DynamicObject)model.getValue("featureid", i)).getPkValue().toString();
                }
                List valueList = map.getOrDefault(featurePK, new ArrayList(4));
                HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
                valueMap.put("featurenumberid", model.getValue("featurenumberid", i));
                valueMap.put("featureid", featurePK);
                valueMap.put("featurevalue", model.getValue("featurevalue", i));
                valueMap.put("configprocess", model.getValue("configprocess", i));
                valueMap.put("featurevaluename", model.getValue("featurevaluename", i));
                valueMap.put("featurevalueid", model.getValue("featurevalueid", i));
                valueMap.put("itemselector", model.getValue("itemselector", i));
                valueList.add(valueMap);
                map.put(featurePK, valueList);
            }
            showParameter.setCustomParam("map", map);
        }
        styleCss.setHeight("860");
        styleCss.setWidth("1500");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Map<Long, String> getEntryAuxProp(DynamicObjectCollection decs) {
        HashMap<Long, String> serialMap = new HashMap<Long, String>(4);
        if (decs == null || decs.isEmpty()) {
            return serialMap;
        }
        for (DynamicObject next : decs) {
            DynamicObject entryMaterial;
            if (!next.getBoolean("checkbox") || (entryMaterial = next.getDynamicObject("entrymaterial")) == null || next.get("entryauxproperty") == null) continue;
            long materialPk = entryMaterial.getLong("id");
            String serialAux = SerializationUtils.serializeToBase64((Object)next.get("entryauxproperty"));
            serialMap.put(materialPk, serialAux);
        }
        return serialMap;
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public DynamicObjectCollection getCheckedAssemblyData(int flag) {
        String bomopentype = this.getPageCache().get("bomopentype");
        DynamicObjectCollection decs = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        DynamicObjectCollection copy = new DynamicObjectCollection(decs.getDynamicObjectType(), (Object)decs);
        for (DynamicObject next : decs) {
            if (!next.getBoolean("checkbox")) continue;
            copy.add((Object)next);
        }
        List hidelist = (List)Productconfig.getHiddenMap().get(this.getView().getPageId());
        if (StringUtils.equals((CharSequence)BOMOpenTypeEnum.CONFIGURABLE.getValue(), (CharSequence)bomopentype) && flag == ProductConfigPageTypeEnum.DETAILED_LIST.getValue() && null != hidelist) {
            ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(Integer.sum(decs.size(), hidelist.size()));
            result.addAll((Collection<DynamicObject>)decs);
            result.addAll(hidelist);
            HashMap<String, DynamicObject> compareMap = new HashMap<String, DynamicObject>(result.size());
            for (DynamicObject dynamicObject : result) {
                String entryseq = dynamicObject.getString("entryseq");
                compareMap.put(entryseq, dynamicObject);
            }
            Set keySet = compareMap.keySet();
            ArrayList list = new ArrayList(keySet);
            Collections.sort(list);
            result.clear();
            for (int index = 0; index < list.size(); ++index) {
                String string = (String)list.get(index);
                DynamicObject dynamicObject = (DynamicObject)compareMap.get(string);
                dynamicObject.set("seq", (Object)(index + 1));
                result.add(dynamicObject);
            }
            decs.clear();
            decs.addAll(result);
            ArrayList<DynamicObject> selectedResult = new ArrayList<DynamicObject>(result.size());
            for (DynamicObject next : result) {
                if (!next.getBoolean("checkbox")) continue;
                selectedResult.add(next);
            }
            copy.clear();
            copy.addAll(selectedResult);
        }
        return copy;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        switch (e.getProperty().getName()) {
            case "checkbox": {
                this.checkedChild(grid.getEntryData().getDataEntitys(), e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "entryqty": {
                this.checkedEntryqty(e, grid.getEntryData().getDataEntitys());
                break;
            }
            case "checkboxvalue": {
                break;
            }
            case "featurevalue": {
                ChangeData changeData = e.getChangeSet()[0];
                this.setFeatureValueEmpty(changeData);
                this.setRelationFeaure(changeData);
                int index = this.getModel().getEntryCurrentRowIndex("entryentity");
                DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
                this.hideFeature(entryCol, null, index);
                break;
            }
            case "prodorgid": {
                ChangeData[] changeSet = e.getChangeSet();
                this.setProductConfigData(changeSet);
            }
        }
    }

    private void setRelationFeaure(ChangeData changeData) {
        Object newVal = changeData.getNewValue();
        changeData.getRowIndex();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (newVal == null || "".equals(newVal)) {
            DynamicObject entryObj = this.getModel().getEntryRowEntity("entryentity", index);
            DynamicObject featureObj = entryObj.getDynamicObject("featureid");
            String featureId = featureObj.getString("id");
            this.deleteExistEntryRow(featureId);
        }
    }

    private void setProductConfigData(ChangeData[] changeSet) {
        for (int i = 0; i < changeSet.length; ++i) {
            DynamicObject newProOrg;
            ChangeData changeData = changeSet[i];
            DynamicObject dynamicObject = newProOrg = changeData.getNewValue() instanceof DynamicObject ? (DynamicObject)changeData.getNewValue() : null;
            if (newProOrg == null) continue;
            long proOrgPk = newProOrg.getLong("id");
            this.getModel().deleteEntryData("treeentryentity");
            this.getModel().deleteEntryData("featuretreeentryentity");
            this.getModel().deleteEntryData("entryentity");
            this.getModel().setValue("superbom", null);
            this.getModel().setValue("productconfigplan", null);
            this.getModel().createNewEntryRow("treeentryentity");
            this.loadView(proOrgPk);
        }
    }

    private boolean checkEntryQtyRange(BigDecimal minqtyopt, BigDecimal maxqtyopt, BigDecimal entryNumerator, BigDecimal entryDenominator) {
        boolean checkResult = true;
        if (entryDenominator.compareTo(BigDecimal.ZERO) <= 0 || entryNumerator.compareTo(BigDecimal.ZERO) <= 0) {
            return false;
        }
        int scale = entryDenominator.scale();
        BigDecimal divide = entryNumerator.divide(entryDenominator, scale, 4);
        if (divide.compareTo(minqtyopt) < 0 || divide.compareTo(maxqtyopt) > 0) {
            checkResult = false;
        }
        return checkResult;
    }

    private void setFeatureValueEmpty(ChangeData changeData) {
        if (changeData == null) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        if (newValue == null || StringUtils.isEmpty((CharSequence)String.valueOf(newValue))) {
            this.getModel().setValue("configprocess", (Object)this.CONFIGPROCESS_UNSETUP, rowIndex);
            this.getModel().setValue("featurevaluename", (Object)"", rowIndex);
            this.getModel().setValue("featurevalueid", (Object)"", rowIndex);
            this.collateEntry(rowIndex);
        }
    }

    private void collateEntry(int rowIndex) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Object featureNumId = this.getModel().getValue("featurenumberid", rowIndex);
        Object feature = this.getModel().getValue("featureid", rowIndex);
        if (feature == null) {
            this.getModel().deleteEntryRow("entryentity", rowIndex);
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject entryFeature = entry.getDynamicObject("featureid");
            String entryFeatureNumId = entry.getString("featurenumberid");
            if (!StringUtils.isNotBlank((Object)featureNumId) || !featureNumId.equals(entryFeatureNumId)) continue;
            int seq = entry.getInt("seq");
            if (entryFeature != null || seq <= 0) continue;
            this.getModel().setValue("configprocess", (Object)this.CONFIGPROCESS_USER_SETUP, rowIndex);
            this.getModel().setValue("featurevaluename", entry.get("featurevaluename"), rowIndex);
            this.getModel().setValue("featurevalueid", entry.get("featurevalueid"), rowIndex);
            this.getModel().setValue("featurevalue", entry.get("featurevalue"), rowIndex);
            this.getModel().deleteEntryRow("entryentity", i);
            break;
        }
        this.setDefaultFeatureValueEnable(null, "", -1);
    }

    private void checkedChild(DynamicObject[] objs, int rowNum) {
        DynamicObject obj = objs[rowNum];
        boolean checkvalue = obj.getBoolean("checkbox");
        if (checkvalue) {
            this.selfIsChecked(objs, rowNum);
        } else {
            this.getPageCache().put("cacheSeq", "");
        }
    }

    private void uncheckedChild(int entryRowIndex, DynamicObject[] objs, boolean ischeck) {
        Long pid = (Long)this.getModel().getValue("treeentryentity.id", entryRowIndex);
        for (int i = entryRowIndex + 1; i < objs.length; ++i) {
            DynamicObject obj = objs[i];
            if (obj.getLong("pid") != pid.longValue()) continue;
            this.getModel().setValue("checkbox", (Object)ischeck, i);
        }
    }

    private boolean isInLine(String cacheSeq, String seq) {
        String[] seqdata;
        String[] cacheSeqdata = cacheSeq.split("\\.");
        int length = cacheSeqdata.length > (seqdata = seq.split("\\.")).length ? cacheSeqdata.length : seqdata.length;
        for (int i = 0; i < length; ++i) {
            if (i >= cacheSeqdata.length || i >= seqdata.length || i == length - 1 || cacheSeqdata[i].equals(seqdata[i])) continue;
            this.getPageCache().put("cacheSeq", seq);
            return false;
        }
        return true;
    }

    private void selfIsChecked(DynamicObject[] objs, int entryRowIndex) {
        boolean isOneLine;
        DynamicObject selfObj = objs[entryRowIndex];
        Long pid = selfObj.getLong("pid");
        DynamicObjectCollection dec = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        DynamicObject parent = this.getParentInfo(dec, pid);
        String optioncontrol = selfObj.getString("optioncontrol");
        String seq = selfObj.getString("entryseq");
        String cacheSeq = this.getPageCache().get("cacheSeq");
        if (StringUtils.isBlank((CharSequence)cacheSeq)) {
            cacheSeq = seq;
            this.getPageCache().put("cacheSeq", cacheSeq);
        }
        if ((isOneLine = this.isInLine(this.getPageCache().get("cacheSeq"), seq)) && seq.length() < cacheSeq.length()) {
            return;
        }
        if ("A".equals(optioncontrol)) {
            this.singleCheck(objs, parent, selfObj);
        } else if ("B".equals(optioncontrol)) {
            this.multipleCheck(objs, parent, selfObj);
        } else {
            this.maybeCheck(objs, parent, selfObj);
        }
    }

    private void singleCheck(DynamicObject[] objs, DynamicObject parent, DynamicObject selfObj) {
        if (parent == null) {
            return;
        }
        long parentId = parent.getLong("id");
        long curId = selfObj.getLong("id");
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject treeBomObj = objs[i];
            long entryPid = treeBomObj.getLong("pid");
            long entryCurId = treeBomObj.getLong("id");
            if (parentId != entryPid || curId == entryCurId) continue;
            this.getModel().setValue("checkbox", (Object)Boolean.FALSE, treeBomObj.getInt("rownum"));
        }
        this.checkChild(objs, selfObj);
    }

    private void multipleCheck(DynamicObject[] objs, DynamicObject parent, DynamicObject selfObj) {
        if (parent == null) {
            return;
        }
        this.checkChild(objs, selfObj);
    }

    private void maybeCheck(DynamicObject[] objs, DynamicObject parent, DynamicObject selfObj) {
        if (parent == null) {
            return;
        }
        this.checkChild(objs, selfObj);
    }

    private void checkChild(DynamicObject[] objs, DynamicObject selfObj) {
        long curId = selfObj.getLong("id");
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject treeBomObj = objs[i];
            long entryPid = treeBomObj.getLong("pid");
            boolean optOptctl = treeBomObj.getBoolean("opt");
            if (curId != entryPid || optOptctl) continue;
            this.getModel().setValue("checkbox", (Object)Boolean.TRUE, treeBomObj.getInt("rownum"));
        }
    }

    private void checkedEntryqty(PropertyChangedArgs e, DynamicObject[] objs) {
        int entryRowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal minqtyopt = objs[entryRowIndex].getBigDecimal("minqtyopt");
        BigDecimal maxqtyopt = objs[entryRowIndex].getBigDecimal("maxqtyopt");
        BigDecimal num = (BigDecimal)e.getChangeSet()[0].getNewValue();
        if (StringUtils.isBlank((Object)maxqtyopt)) {
            maxqtyopt = BigDecimal.ZERO;
        }
        if (StringUtils.isBlank((Object)minqtyopt)) {
            minqtyopt = BigDecimal.ZERO;
        }
        String minqtyoptStr = minqtyopt.stripTrailingZeros().toPlainString();
        String maxqtyoptStr = maxqtyopt.stripTrailingZeros().toPlainString();
        if (num == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5e8f\u53f7\u4e3a%1$s\u7684\u7ec4\u4ef6\u6570\u91cf\u5fc5\u987b\u5728\u8303\u56f4[%2$s,%3$s]\u5185\u3002", (String)"ProductConfigsEdit_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), objs[entryRowIndex].getString("entryseq"), minqtyoptStr, maxqtyoptStr));
            return;
        }
        if (num.compareTo(minqtyopt) < 0 || num.compareTo(maxqtyopt) > 0) {
            this.getModel().setValue("entryqty", (Object)minqtyopt, entryRowIndex);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5e8f\u53f7\u4e3a%1$s\u7684\u7ec4\u4ef6\u6570\u91cf\u5fc5\u987b\u5728\u8303\u56f4[%2$s,%3$s]\u5185\u3002", (String)"ProductConfigsEdit_13", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), objs[entryRowIndex].getString("entryseq"), minqtyoptStr, maxqtyoptStr));
        }
    }

    public void queryTreeentryentity(DynamicObjectCollection bomTreeEntrys, DynamicObject superBom, DynamicObject scheme, QFilter superBomIds) {
        if (scheme == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)scheme.getString("configtype"), (CharSequence)ConfigTypeEnum.GROUP.getValue())) {
            if (superBom == null) {
                this.getModel().deleteEntryData("treeentryentity");
                this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"donothing_savefeaturelist"});
                return;
            }
            String bomopentype = scheme.getString("bomopentype");
            this.getPageCache().put("bomopentype", bomopentype);
            DynamicObject anew = bomTreeEntrys.addNew();
            this.setFirstRowData(anew, superBom);
            String fnum = "1";
            HashMap<String, Long> isRepectDynamicObject = new HashMap<String, Long>();
            DynamicObject materialMftInfo = superBom.getDynamicObject("material");
            long materialPK = -1L;
            if (materialMftInfo != null) {
                materialPK = materialMftInfo.getLong("id");
            } else {
                DynamicObject material = superBom.getDynamicObject("materialid");
                if (material != null) {
                    materialPK = material.getLong("id");
                }
            }
            if (materialPK > -1L) {
                isRepectDynamicObject.put(fnum, materialPK);
            }
            String optioncontrol = superBom.getString("optioncontrol");
            this.getEntryDataSet(superBom.getDynamicObjectCollection("entry"), bomTreeEntrys, fnum, superBom.getLong("id"), superBomIds, bomTreeEntrys.remove(0), isRepectDynamicObject, optioncontrol);
            this.getView().updateView("treeentryentity");
            TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
            if (!StringUtils.equals((CharSequence)bomopentype, (CharSequence)BOMOpenTypeEnum.NOOPEN.getValue())) {
                grid.expand(0);
            }
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"pdm_mftbom");
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)entityType);
            cacheManager.removeByFilterDt();
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"donothing_savefeaturelist"});
        } else {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData("featuretreeentryentity");
            if (superBom != null) {
                DynamicObjectCollection entryct = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                DynamicObjectCollection featureEntryct = this.getModel().getDataEntity(true).getDynamicObjectCollection("featuretreeentryentity");
                DynamicObjectCollection featureDefs = scheme.getDynamicObjectCollection("featureinfo");
                FormulaEngine.registerFunctions((IFormulaFunctions)new PDMCustFormulaFuntions());
                HashMap<Long, Boolean> solidMap = new HashMap<Long, Boolean>(16);
                DynamicObjectCollection allFeatureDefs = this.getAllFeatureDefs(featureDefs, solidMap);
                Map<String, List<DynamicObject>> defaultSelectValMap = this.getDefaultSelectValMap(allFeatureDefs);
                HashSet<Integer> lockIndexSet = new HashSet<Integer>(16);
                if (!allFeatureDefs.isEmpty()) {
                    for (int i = 0; i < allFeatureDefs.size(); ++i) {
                        DynamicObject featureInfo = (DynamicObject)allFeatureDefs.get(i);
                        boolean isSolid = (Boolean)solidMap.get(featureInfo.getPkValue());
                        DynamicObject featureDef = featureInfo.getDynamicObject("featureid");
                        DynamicObject materialMunDO = scheme.getDynamicObject("materielnum");
                        String schmeNumber = "";
                        if (materialMunDO != null) {
                            schmeNumber = materialMunDO.getString("number");
                        }
                        int lockIndex = this.createFeatureRowData(entryct, featureInfo, schmeNumber, isSolid);
                        lockIndexSet.add(lockIndex);
                        if (featureDef != null) continue;
                    }
                }
                this.getPageCache().put(CACHE_LOCKROWS, ((Object)lockIndexSet).toString());
            }
            this.getModel().updateCache();
            this.getView().updateView("entryentity");
            this.getView().updateView("featuretreeentryentity");
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"savelist"});
            Tab tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab("tabpageap1");
            TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("featuretreeentryentity");
            grid.expand(0);
        }
    }

    private void addDefRowFromSchemeMamualValue(List<DynamicObject> emptyIDList, Set<String> featureValueSet, List<FeatureValueObj> featureValues) {
        for (int j = 0; j < emptyIDList.size(); ++j) {
            FeatureValueObj featureValueObj;
            DynamicObject fetureDO = emptyIDList.get(j);
            String featureValue = fetureDO.getString("featurevalue");
            String featureValueName = fetureDO.getString("featurevaluename");
            String featureValueID = fetureDO.getString("featurevalueid");
            if (featureValueSet.contains(featureValue) || (featureValueObj = this.createFeatureValueObj(featureValueID, featureValue, featureValueName, true, j)) == null) continue;
            featureValues.add(featureValueObj);
        }
    }

    private FeatureValueObj createFeatureValueObj(String featureValueID, String featureValue, String featureValueName, boolean b, int j) {
        FeatureValueObj featureValueObj = new FeatureValueObj();
        featureValueObj.setFeatureValue(featureValue);
        featureValueObj.setFeatureValueChoose(true);
        featureValueObj.setFeatureValueName(featureValueName);
        featureValueObj.setFeatureValueId(featureValueID);
        featureValueObj.setFeatureValuePId("0");
        featureValueObj.setFeatureValueSeq(j + "");
        return featureValueObj;
    }

    private Map<String, List<DynamicObject>> getDefaultSelectValMap(DynamicObjectCollection allFeatureDefs) {
        if (allFeatureDefs == null) {
            return null;
        }
        HashMap<String, List<DynamicObject>> defaultSelectValueMap = new HashMap<String, List<DynamicObject>>(8);
        for (int i = 0; i < allFeatureDefs.size(); ++i) {
            String featureValue;
            DynamicObject featuerDO = (DynamicObject)allFeatureDefs.get(i);
            if (featuerDO == null || StringUtils.isEmpty((CharSequence)(featureValue = featuerDO.getString("featurevalue")))) continue;
            DynamicObject featureDefDO = featuerDO.getDynamicObject("featureid");
            String featurePK = "";
            featurePK = featureDefDO != null ? String.valueOf(featureDefDO.getPkValue()) : featuerDO.getString("featurenumberid");
            if (StringUtils.isEmpty((CharSequence)featurePK)) continue;
            List defaultList = defaultSelectValueMap.getOrDefault(featurePK, new ArrayList(4));
            defaultList.add(featuerDO);
            defaultSelectValueMap.put(featurePK, defaultList);
        }
        return defaultSelectValueMap;
    }

    private int createFeatureRowData(DynamicObjectCollection entryDOC, DynamicObject featureInfo, String schmeNumber, boolean isSolid) {
        String valueSourceStr;
        if (entryDOC == null || featureInfo == null) {
            return -1;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject featureDef = featureInfo.getDynamicObject("featureid");
        String featureValue = featureInfo.getString("featurevalue");
        String featureValueName = featureInfo.getString("featurevaluename");
        String featureValueID = featureInfo.getString("featurevalueid");
        String featureNumberID = featureInfo.getString("featurenumberid");
        int rowIndex = this.getModel().createNewEntryRow("entryentity");
        model.setValue("featureid", (Object)featureDef, rowIndex);
        model.setValue("featurevalueid", (Object)featureValueID, rowIndex);
        model.setValue("featurenumberid", (Object)featureNumberID, rowIndex);
        model.setValue("featurevalue", (Object)featureValue, rowIndex);
        model.setValue("featurevaluename", (Object)featureValueName, rowIndex);
        if (!StringUtils.isNotEmpty((CharSequence)((String)model.getValue("featurevalue", rowIndex)))) {
            isSolid = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)featureValue)) {
            valueSourceStr = String.format(ResManager.loadKDString((String)"\u503c\u72b6\u6001\uff1a\u5df2\u8bbe\u7f6e\uff1b\u503c\u6765\u6e90\u7c7b\u578b\uff1a\u914d\u7f6e\u65b9\u6848\u6307\u5b9a\uff1b\u503c\u6765\u6e90\uff1a%1$s\uff1b", (String)"ProductConfigsEdit_14", (String)"mmc-pdm-formplugin", (Object[])new Object[0]), schmeNumber);
            this.setFeatureValueNotEnableCache(featureDef);
        } else {
            valueSourceStr = ResManager.loadKDString((String)"\u503c\u72b6\u6001\uff1a\u672a\u8bbe\u7f6e\uff1b\u503c\u6765\u6e90\u7c7b\u578b\uff1a\uff1b\u503c\u6765\u6e90\uff1a\uff1b", (String)"ProductConfigsEdit_1", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
            this.setPreferenceFeatureValue(model, featureDef, rowIndex);
            isSolid = true;
        }
        view.setEnable(Boolean.valueOf(isSolid), rowIndex, new String[]{"featurevalue"});
        model.setValue("configprocess", (Object)valueSourceStr, rowIndex);
        return isSolid ? -1 : rowIndex;
    }

    private void setPreferenceFeatureValue(IDataModel model, DynamicObject featureDef, int rowIndex) {
        if (featureDef == null || rowIndex < 0 || model == null) {
            return;
        }
        DynamicObjectCollection featureValueEntryDOC = featureDef.getDynamicObjectCollection("treeentryentity");
        if (featureValueEntryDOC == null || featureValueEntryDOC.isEmpty()) {
            return;
        }
        for (int i = 0; i < featureValueEntryDOC.size(); ++i) {
            DynamicObject featureValueEntryDO = (DynamicObject)featureValueEntryDOC.get(i);
            boolean isDefaultValue = featureValueEntryDO.getBoolean("isdefaultvalue");
            if (!isDefaultValue) continue;
            String entryId = featureValueEntryDO.getString("id");
            String entryValue = featureValueEntryDO.getString("entryvalue");
            String entryValueName = featureValueEntryDO.getString("entryvaluename");
            model.setValue("featurevalueid", (Object)entryId, rowIndex);
            model.setValue("featurevalue", (Object)entryValue, rowIndex);
            model.setValue("featurevaluename", (Object)entryValueName, rowIndex);
            return;
        }
    }

    private void setFeatureValueNotEnableCache(DynamicObject featureDef) {
        if (featureDef == null) {
            return;
        }
        Long featureID = featureDef.getLong("id");
        String featureValueNotEnable = this.getView().getPageCache().get("featurevaluenotenable");
        Set<String> featureValueSet = new HashSet<String>(4);
        if (StringUtils.isEmpty((CharSequence)featureValueNotEnable)) {
            featureValueSet.add(featureID.toString());
        } else {
            featureValueSet = (Set)JSONObject.parseObject((String)featureValueNotEnable, (TypeReference)new TypeReference<HashSet<String>>(){}, (Feature[])new Feature[0]);
            featureValueSet.add(featureID.toString());
        }
        this.getView().getPageCache().put("featurevaluenotenable", JSONObject.toJSONString(featureValueSet));
    }

    private DynamicObjectCollection getAllFeatureDefs(DynamicObjectCollection featureDefs, Map<Long, Boolean> solidMap) {
        DynamicObjectCollection allFeatureDefs = new DynamicObjectCollection();
        if (featureDefs == null) {
            return allFeatureDefs;
        }
        HashSet<String> featureDefSet = new HashSet<String>(4);
        for (int i = 0; i < featureDefs.size(); ++i) {
            DynamicObjectCollection featureDefDOC;
            DynamicObject featureTypeInfo = (DynamicObject)featureDefs.get(i);
            DynamicObject featureTypeObj = featureTypeInfo.getDynamicObject("featuretype");
            String isSolid = featureTypeObj.getString("issolid");
            if (featureTypeInfo == null || (featureDefDOC = featureTypeInfo.getDynamicObjectCollection("subentryentity")) == null) continue;
            this.repeatFeatureDefHandle(allFeatureDefs, featureDefDOC, featureDefSet, isSolid);
            for (DynamicObject entry : featureDefDOC) {
                solidMap.put((Long)entry.getPkValue(), "true".equals(isSolid));
            }
        }
        return allFeatureDefs;
    }

    private void repeatFeatureDefHandle(DynamicObjectCollection allFeatureDefs, DynamicObjectCollection featureDefDOC, Set<String> featureDefSet, String isSolid) {
        if (allFeatureDefs == null || featureDefDOC == null || featureDefSet == null) {
            return;
        }
        String repeatFeatureDef = "";
        DynamicObjectCollection newFeatureDefCol = (DynamicObjectCollection)featureDefDOC.clone();
        for (int j = 0; j < newFeatureDefCol.size(); ++j) {
            DynamicObject featureDefEntryDO = (DynamicObject)newFeatureDefCol.get(j);
            if (featureDefEntryDO == null) continue;
            DynamicObject featureDefDO = featureDefEntryDO.getDynamicObject("featureid");
            String featureNumberID = featureDefEntryDO.getString("featurenumberid");
            boolean isNotRepeat = true;
            if (featureDefDO == null) {
                if (StringUtils.isNotEmpty((CharSequence)repeatFeatureDef) && StringUtils.equals((CharSequence)featureNumberID, (CharSequence)repeatFeatureDef)) {
                    isNotRepeat = false;
                    continue;
                }
            } else {
                Long featureDefPkValue = featureDefDO.getLong("id");
                if (featureDefSet.contains(featureDefPkValue.toString())) {
                    repeatFeatureDef = featureDefPkValue.toString();
                    isNotRepeat = false;
                    continue;
                }
                featureDefSet.add(featureDefPkValue.toString());
            }
            if (!isNotRepeat) continue;
            allFeatureDefs.add((Object)featureDefEntryDO);
        }
    }

    private void setMatchFeatureValsFromDB(ProdConfigureFeatureDefAndValObj defAndValObj, List<FeatureValueObj> featureValues, DynamicObject featureValEntry, DynamicObject featureEntry, Map<Long, DynamicObject> featureValSeqMap) {
        Long pid = 0L;
        featureEntry.set("id", featureValEntry.get("id"));
        featureEntry.set("pid", (Object)pid);
        featureEntry.set("entryvalue", featureValEntry.get("entryvalue"));
        featureEntry.set("entryvaluename", featureValEntry.get("entryvaluename"));
        if (featureValSeqMap != null) {
            DynamicObject obj = featureValSeqMap.get(featureValEntry.getLong("id"));
            featureEntry.set("seq", obj.get("seq"));
        } else {
            featureEntry.set("seq", featureValEntry.get("seq"));
        }
        featureEntry.set("featuredefno_id", (Object)defAndValObj.getFeatureDefId());
        featureEntry.set("checkboxvalue", featureValEntry.get("isdefaultvalue"));
        this.setPageCacheOfFeatureValObj(featureValues, featureValEntry, pid, featureValSeqMap);
    }

    private List<FeatureValueObj> setPageCacheOfFeatureDefAndValObj(DynamicObject featureDef, ProdConfigureFeatureDefAndValObj defAndValObj) {
        defAndValObj.setFeatureDefId(featureDef.getPkValue().toString());
        defAndValObj.setFeatureDefName(featureDef.getString("name"));
        ArrayList<FeatureValueObj> featureValues = new ArrayList<FeatureValueObj>();
        defAndValObj.setFeatureValues(featureValues);
        defAndValObj.setFeatureIsValueMust(featureDef.getBoolean("isvaluemust"));
        defAndValObj.setFeatureIsValueShow(featureDef.getBoolean("isvalueshow"));
        defAndValObj.setFeatureDefNumber(featureDef.getString("number"));
        return featureValues;
    }

    private void setPageCacheOfFeatureValObj(List<FeatureValueObj> featureValues, DynamicObject dynamicObject, Long pid, Map<Long, DynamicObject> featureValSeqMap) {
        FeatureValueObj featureValue = new FeatureValueObj();
        featureValue.setFeatureValue(dynamicObject.get("entryvalue").toString());
        featureValue.setFeatureValueName(dynamicObject.get("entryvaluename").toString());
        featureValue.setFeatureValuePId(pid.toString());
        if (featureValSeqMap != null) {
            DynamicObject obj = featureValSeqMap.get(dynamicObject.getLong("id"));
            featureValue.setFeatureValueSeq(obj.getString("seq"));
        } else {
            featureValue.setFeatureValueSeq(dynamicObject.get("seq").toString());
        }
        featureValue.setFeatureValueId(dynamicObject.get("id").toString());
        featureValue.setFeatureValueChoose((StringUtils.equals((CharSequence)"true", (CharSequence)dynamicObject.get("isdefaultvalue").toString()) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
        featureValues.add(featureValue);
    }

    private void setFirstRowData(DynamicObject anew, DynamicObject obj) {
        DynamicObject materialIdDO = obj.getDynamicObject("materialid");
        DynamicObject baseUnit = null;
        if (materialIdDO != null) {
            DynamicObject baseUnitDO = materialIdDO.getDynamicObject("baseunit");
            baseUnit = BusinessDataServiceHelper.loadSingle((Object)baseUnitDO.getLong("id"), (String)"bd_measureunits");
        }
        anew.set("id", obj.get("id"));
        anew.set("entrymaterial", (Object)obj.getDynamicObject("materialid"));
        anew.set("entryseq", (Object)"1");
        anew.set("entryqtynumerator", (Object)1);
        anew.set("entryqtydenominator", (Object)1);
        anew.set("entryunit", (Object)baseUnit);
        anew.set("checkbox", (Object)Boolean.TRUE);
        anew.set("rownum", (Object)this.rowNum);
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"entryauxproperty"});
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"entryqty"});
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"entryqtynumerator"});
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"entryqtydenominator"});
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"checkbox"});
    }

    private Long createGenLongId(ORM create) {
        return create.genLongId("pdm_mftbom");
    }

    private void getEntryDataSet(DynamicObjectCollection bomEntrys, DynamicObjectCollection bomTreeEntrys, String fnum, Long pid, QFilter superBomIds, DynamicObject bomTreeEntry, Map<String, Long> isRepectDynamicObject, String optioncontrol) {
        if (bomEntrys.isEmpty()) {
            return;
        }
        IFormView fv = this.getView();
        IPageCache pc = fv.getPageCache();
        ORM create = ORM.create();
        for (int index = 0; index < bomEntrys.size(); ++index) {
            DynamicObject bomEntry = (DynamicObject)bomEntrys.get(index);
            long superBomEntryId = bomEntry.getLong("id");
            bomEntry.set("id", (Object)this.createGenLongId(create));
            if (!StringUtils.isBlank((CharSequence)pc.get("deadnode"))) {
                return;
            }
            String pnum = fnum + "." + bomEntry.getInt("seq");
            if (this.onlyConfigData(bomEntry, bomTreeEntry, pnum, pid, index, optioncontrol, superBomEntryId)) continue;
            this.addNewRow(bomTreeEntrys, pid, bomEntry, pnum, index, isRepectDynamicObject, optioncontrol, superBomEntryId);
            if (this.isRepeatBom(fnum, pnum, bomEntry, isRepectDynamicObject)) {
                this.getView().getPageCache().put("deadnode", pnum);
                return;
            }
            if (StringUtils.equals((CharSequence)pc.get("bomopentype"), (CharSequence)BOMOpenTypeEnum.SINGLESTAGE.getValue())) continue;
            this.callSelf(superBomIds, bomTreeEntrys, pnum, bomEntry, bomTreeEntry, isRepectDynamicObject);
        }
    }

    private void addNewRow(DynamicObjectCollection bomTreeEntrys, Long pid, DynamicObject bomEntry, String pnum, int index, Map<String, Long> isRepectDynamicObject, String optioncontrol, long superBomEntryId) {
        DynamicObject newBomEntry = bomTreeEntrys.addNew();
        Long materialId = bomEntry.getDynamicObject("entrymaterialid").getLong("id");
        this.setRowData(bomTreeEntrys, pid, bomEntry, newBomEntry);
        isRepectDynamicObject.put(pnum, materialId);
        this.setAuxproperty(bomEntry.getDynamicObject("entrymaterialid"), this.rowNum);
        this.copyProperies(bomEntry, newBomEntry, pnum, pid, index, optioncontrol, superBomEntryId);
    }

    private void setRowData(DynamicObjectCollection bomTreeEntrys, Long pid, DynamicObject dynamicObject, DynamicObject addNew) {
        DynamicObject parent = this.getParentInfo(bomTreeEntrys, pid);
        boolean qtyoptOptctl = dynamicObject.getBoolean("qtyopt");
        boolean optOptctl = dynamicObject.getBoolean("opt");
        boolean preferoptOptctl = dynamicObject.getBoolean("preferopt");
        boolean isckParent = false;
        if (parent != null) {
            isckParent = parent.getBoolean("checkbox");
        }
        ++this.rowNum;
        if (optOptctl) {
            this.getView().setEnable(Boolean.TRUE, this.rowNum, new String[]{"checkbox"});
        } else {
            addNew.set("checkbox", (Object)Boolean.TRUE);
            this.getView().setEnable(Boolean.FALSE, this.rowNum, new String[]{"checkbox"});
        }
        if (preferoptOptctl) {
            addNew.set("checkbox", (Object)Boolean.TRUE);
            this.getView().setEnable(Boolean.TRUE, this.rowNum, new String[]{"checkbox"});
        }
        boolean thisOptCtl = addNew.getBoolean("checkbox");
        this.setParentCheckBox(thisOptCtl, bomTreeEntrys, parent);
        if (qtyoptOptctl) {
            this.setPageCacheCtrlQty(dynamicObject);
            addNew.set("maxqtyopt", dynamicObject.get("maxqtyopt"));
            addNew.set("minqtyopt", dynamicObject.get("minqtyopt"));
            addNew.set("entryqtydenominator", (Object)1);
            addNew.set("entryqtynumerator", dynamicObject.get("minqtyopt"));
            this.getView().setEnable(Boolean.TRUE, this.rowNum, new String[]{"entryqty"});
            this.getView().setEnable(Boolean.TRUE, this.rowNum, new String[]{"entryqtydenominator"});
            this.getView().setEnable(Boolean.TRUE, this.rowNum, new String[]{"entryqtynumerator"});
        } else {
            addNew.set("maxqtyopt", (Object)BigDecimal.ONE);
            addNew.set("minqtyopt", (Object)BigDecimal.ONE);
            addNew.set("entryqtydenominator", (Object)1);
            addNew.set("entryqtynumerator", (Object)1);
            this.getView().setEnable(Boolean.FALSE, this.rowNum, new String[]{"entryqty"});
            this.getView().setEnable(Boolean.FALSE, this.rowNum, new String[]{"entryqtydenominator"});
            this.getView().setEnable(Boolean.FALSE, this.rowNum, new String[]{"entryqtynumerator"});
        }
        addNew.set("rownum", (Object)this.rowNum);
    }

    private void setParentCheckBox(boolean thisOptCtl, DynamicObjectCollection bomTreeEntrys, DynamicObject parent) {
        boolean pOptCtl;
        if (!thisOptCtl || parent == null) {
            return;
        }
        DynamicObject handleParent = parent;
        while (handleParent != null && !(pOptCtl = handleParent.getBoolean("checkbox"))) {
            handleParent.set("checkbox", (Object)Boolean.TRUE);
            long pid = handleParent.getLong("pid");
            if (pid == 0L) break;
            handleParent = this.getParentInfo(bomTreeEntrys, pid);
        }
    }

    private void setPageCacheCtrlQty(DynamicObject entryDO) {
        DynamicObject matDO;
        long matPk;
        String qtyOpt = this.getView().getPageCache().get("qtyopt");
        Set<Long> qtyoptSet = new HashSet(4);
        if (StringUtils.isNotBlank((CharSequence)qtyOpt)) {
            qtyoptSet = (Set)SerializationUtils.deSerializeFromBase64((String)qtyOpt);
        }
        if (qtyoptSet == null) {
            qtyoptSet = new HashSet(4);
        }
        long l = matPk = (matDO = entryDO.getDynamicObject("entrymaterialid")) != null ? matDO.getLong("id") : 0L;
        if (matPk > 0L) {
            qtyoptSet.add(matPk);
            this.getPageCache().put("qtyopt", SerializationUtils.serializeToBase64(qtyoptSet));
        }
    }

    private boolean onlyConfigData(DynamicObject dynamicObject, DynamicObject object, String pnum, Long pid, int index, String optioncontrol, long superBomEntryId) {
        boolean flag = !dynamicObject.getBoolean("qtyopt") && !dynamicObject.getBoolean("opt") && !dynamicObject.getBoolean("preferopt");
        boolean onlyConfigData = false;
        DynamicObject matObj = dynamicObject.getDynamicObject("entrymaterialid");
        if (matObj == null) {
            return true;
        }
        String configproperties = matObj.getString("configproperties");
        if (StringUtils.equals((CharSequence)this.getPageCache().get("bomopentype"), (CharSequence)BOMOpenTypeEnum.CONFIGURABLE.getValue())) {
            Boolean isUseAuxpty = Boolean.FALSE;
            Object tempObj = dynamicObject.get("entrymaterialid");
            if (StringUtils.isNotBlank((Object)tempObj)) {
                isUseAuxpty = this.isUseAuxpty((DynamicObject)tempObj);
            }
            ArrayList<DynamicObject> hidelist = (ArrayList<DynamicObject>)Productconfig.getHiddenMap().get(this.getView().getPageId());
            if (!isUseAuxpty.booleanValue() && !"2".equals(configproperties) && !"3".equals(configproperties) && flag) {
                if (null == hidelist) {
                    hidelist = new ArrayList<DynamicObject>();
                }
                DynamicObject target = new DynamicObject(object.getDynamicObjectType());
                this.copyProperies(dynamicObject, target, pnum, pid, index, optioncontrol, superBomEntryId);
                target.set("checkbox", (Object)Boolean.TRUE);
                hidelist.add(target);
                Productconfig.getHiddenMap().put(this.getView().getPageId(), hidelist);
                onlyConfigData = true;
            }
        }
        return onlyConfigData;
    }

    private void callSelf(QFilter superBomIds, DynamicObjectCollection bomTreeEntrys, String pnum, DynamicObject bomentry, DynamicObject bomTreeEntry, Map<String, Long> isRepectDynamicObject) {
        Long materialId = bomentry.getDynamicObject("entrymaterialid").getLong("id");
        QFilter material = new QFilter("materialid", "=", (Object)materialId);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter[] allDataFilter = new QFilter[]{material, superBomIds, status, enable};
        DynamicObject bomObj = BusinessDataServiceHelper.loadSingle((String)"pdm_mftbom", (String)this.getSelectItems(), (QFilter[])allDataFilter);
        if (bomObj != null) {
            String optioncontrol = bomObj.getString("optioncontrol");
            DynamicObjectCollection bomEntryObjs = bomObj.getDynamicObjectCollection("entry");
            this.getEntryDataSet(bomEntryObjs, bomTreeEntrys, pnum, bomentry.getLong("id"), superBomIds, bomTreeEntry, isRepectDynamicObject, optioncontrol);
        }
    }

    private DynamicObject getParentInfo(DynamicObjectCollection decs, Long pid) {
        DynamicObject parent = null;
        for (DynamicObject dynamicObject : decs) {
            if (dynamicObject.getLong("id") != pid.longValue()) continue;
            parent = dynamicObject;
            break;
        }
        return parent;
    }

    private void setAuxproperty(DynamicObject material, int rowNum) {
        Boolean isAUXPTY = this.isUseAuxpty(material);
        this.getView().setEnable(isAUXPTY == false ? Boolean.FALSE : Boolean.TRUE, rowNum, new String[]{"entryauxproperty"});
    }

    private Boolean isUseAuxpty(DynamicObject materialObj) {
        Boolean isUseAuxpty = Boolean.FALSE;
        IFormView gv = this.getView();
        IPageCache pc = gv.getPageCache();
        if (StringUtils.isBlank((Object)materialObj)) {
            return isUseAuxpty;
        }
        StringBuilder sbCacheMaterialKey = new StringBuilder();
        sbCacheMaterialKey.append("material_");
        sbCacheMaterialKey.append(String.valueOf(materialObj.getPkValue()));
        String materialVal = pc.get(sbCacheMaterialKey.toString());
        if (StringUtils.isBlank((CharSequence)materialVal)) {
            isUseAuxpty = MaterialUtil.isUseAuxpty((DynamicObject)materialObj);
            pc.put(sbCacheMaterialKey.toString(), String.valueOf(isUseAuxpty));
        } else {
            isUseAuxpty = Boolean.valueOf(pc.get(sbCacheMaterialKey.toString()));
        }
        return isUseAuxpty;
    }

    private void copyProperies(DynamicObject source, DynamicObject target, String pnum, Long pid, int index, String optioncontrol, long superBomEntryId) {
        target.set("seq", (Object)(index + 2));
        target.set("entryseq", (Object)pnum);
        target.set("pid", (Object)pid);
        target.set("id", source.get("id"));
        target.set("entrytype", source.get("entrytype"));
        target.set("entrymaterial", (Object)source.getDynamicObject("entrymaterialid"));
        target.set("entryunit", (Object)source.getDynamicObject("entryunit"));
        target.set("entryversion", (Object)source.getDynamicObject("entryversion"));
        target.set("entryauxproperty", source.get("entryauxproperty"));
        target.set("entryqtytype", source.get("entryqtytype"));
        BigDecimal sourceQtyNumer = source.getBigDecimal("entryqtynumerator");
        BigDecimal sourceQtyDenom = source.getBigDecimal("entryqtydenominator");
        BigDecimal divide = BigDecimal.ONE;
        boolean isQtyOpt = source.getBoolean("qtyopt");
        if (sourceQtyDenom.compareTo(BigDecimal.ZERO) > 0) {
            divide = sourceQtyNumer.divide(sourceQtyDenom, sourceQtyNumer.scale(), 4);
            BigDecimal maxQtyopt = target.getBigDecimal("maxqtyopt");
            BigDecimal minQtyopt = target.getBigDecimal("minqtyopt");
            if (isQtyOpt && (divide.compareTo(minQtyopt) < 0 || divide.compareTo(maxQtyopt) > 0)) {
                target.set("entryqtynumerator", (Object)minQtyopt);
                target.set("entryqtydenominator", (Object)BigDecimal.ONE);
            } else {
                target.set("entryqtynumerator", (Object)source.getBigDecimal("entryqtynumerator"));
                target.set("entryqtydenominator", (Object)source.getBigDecimal("entryqtydenominator"));
            }
        } else {
            target.set("entryqtynumerator", (Object)BigDecimal.ONE);
            target.set("entryqtydenominator", (Object)BigDecimal.ONE);
        }
        target.set("entryqty", source.get("entryqty"));
        target.set("entryfixscrap", (Object)source.getBigDecimal("entryfixscrap"));
        target.set("entryscraprate", (Object)source.getBigDecimal("entryscraprate"));
        target.set("entryvaliddate", source.get("entryvaliddate"));
        target.set("entryinvaliddate", source.get("entryinvaliddate"));
        target.set("mutuexcopt", source.get("mutuexcopt"));
        target.set("opt", (Object)source.getBoolean("opt"));
        target.set("optioncontrol", (Object)optioncontrol);
        target.set("superbomentryid", (Object)superBomEntryId);
    }

    private boolean isRepeatBom(String pnum, String selfNum, DynamicObject dynamicObject, Map<String, Long> isRepectDynamicObject) {
        int lastIndex;
        boolean retFlag = false;
        Long materialId = dynamicObject.getDynamicObject("entrymaterialid").getLong("id");
        int length = selfNum.split("\\.").length;
        String rowNum = selfNum;
        for (int i = 0; i < length && (lastIndex = rowNum.lastIndexOf(46)) > 0; ++i) {
            if (isRepectDynamicObject.get(rowNum = rowNum.substring(0, lastIndex)).longValue() != materialId.longValue()) continue;
            this.getView().showMessage(String.format(MESSAGE, selfNum));
            retFlag = true;
        }
        return retFlag;
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        FormShowParameter paras = this.getFormShowParameter();
        String appId = paras.getAppId();
        if ("pdm".equals(appId)) {
            IPageCache pcPageCache = this.getParentPageCache();
            if (pcPageCache != null && paras != null) {
                pcPageCache.remove(this.getOnlyPageCacheKey(paras));
            }
            Productconfig.getHiddenMap().remove(this.getView().getPageId());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String appId = fsp.getAppId();
        if (!"pdm".equals(appId)) {
            e.setCheckDataChange(false);
        }
        Object masterConfigcode = model.getValue("masterconfigcode");
        Long configCodePK = 0L;
        if (masterConfigcode instanceof DynamicObject) {
            configCodePK = ((DynamicObject)masterConfigcode).getLong("id");
        }
        HashMap<String, Long> resultParam = new HashMap<String, Long>(2);
        resultParam.put("configCodeBack", configCodePK);
        view.returnDataToParent(resultParam);
    }

    private Set<Integer> ParseStringToIntSet(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new HashSet<Integer>(16);
        }
        str = str.replace("[", "");
        str = str.replace("]", "");
        String[] array = str.split(",");
        int size = array.length;
        HashSet<Integer> set = new HashSet<Integer>(size);
        for (int i = 0; i < size; ++i) {
            String value = array[i];
            if (StringUtils.isEmpty((CharSequence)value)) continue;
            value = value.trim();
            set.add(Integer.parseInt(value));
        }
        return set;
    }
}

