/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.business.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pmgt.pmas.business.helper.ApproveContext;
import kd.pmgt.pmas.business.helper.ProjectBudgetGenerateHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.business.utils.AssociatedTableModel;
import kd.pmgt.pmbs.business.utils.AutoPushOperation;
import kd.pmgt.pmbs.business.utils.AutoPushUtil;
import kd.pmgt.pmbs.common.enums.BillTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetCtrlEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.ProjValidEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.SupervisionDatasourceEnum;
import kd.pmgt.pmbs.common.enums.TeamAdjustDescEnum;
import kd.pmgt.pmbs.common.enums.approval.ApprovalStatusEnum;
import kd.pmgt.pmbs.common.enums.projectProposal.BizStatusEnum;
import kd.pmgt.pmbs.common.utils.StageStatusHelper;
import kd.pmgt.pmbs.common.utils.SynFunSourceHelper;
import kd.pmgt.pmbs.common.utils.coderule.CodeRuleHelper;
import kd.pmgt.pmbs.servicehelper.BudgetCtrlHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ProjectApprovalHelper {
    private static final Log logger = LogFactory.getLog(ProjectApprovalHelper.class);
    private static final String push_source_approval = "pmas_pro_approval";
    private static final String push_target_project = "bd_project";
    private static final String appId = "pmas";
    private static final String action_audit = "audit";
    private static final String PROSTATUS_FORM_KEY = "bd_projectstatus";
    public static final String BUDGET_CONTROL_MODE = "budgetcontrolmode";
    public static final String PROJECT_COST_CONTROL = "projectcostcontrol";
    private static final String BUDGETPERIOD = "budgetperiod";
    private static final String BUDGETPRONAME = "budgetproname";
    private static final String BUDGETPRONUMBER = "budgetpronumber";
    private static final String BUDGETPRO = "budgetpro";
    public static final String REALBUDGETENTRY = "realbudgetentry";
    private static final String OPERATION_APPROVAL_CONFIRM = "approvalconfirm";
    private static final String AUDIT_BILLNO_SDF = "yyyyMMddHHmmss";
    private static final String APP_AUDIT_BILLNO_SDF = "MMddHHmmss";
    private static final String APP_AUDIT_BILLNAME_SDF = "MMdd";

    public static void syncToBudgetDataBase(DynamicObject proAppObj) {
        DynamicObject proproposalBillF7 = proAppObj.getDynamicObject("proproposal");
        DynamicObject budgetDataBaseF7 = proAppObj.getDynamicObject("bugproname");
        if (proproposalBillF7 != null) {
            DynamicObject[] budgetDataBaseArr;
            for (DynamicObject budgetDataBase : budgetDataBaseArr = BusinessDataServiceHelper.load((String)"pmim_budgetbase", (String)"projectname", (QFilter[])new QFilter[]{new QFilter("proproposal.id", "=", proproposalBillF7.getPkValue())})) {
                ProjectApprovalHelper.addProjectName(budgetDataBase, proAppObj);
            }
        } else if (proproposalBillF7 == null && budgetDataBaseF7 != null) {
            budgetDataBaseF7 = BusinessDataServiceHelper.loadSingle((Object)budgetDataBaseF7.getPkValue(), (String)"pmim_budgetbase");
            ProjectApprovalHelper.addProjectName(budgetDataBaseF7, proAppObj);
        }
    }

    private static void addProjectName(DynamicObject budgetDataBase, DynamicObject proAppObj) {
        DynamicObjectCollection projectNames = budgetDataBase.getDynamicObjectCollection("projectname");
        DynamicObject projectName = new DynamicObject(projectNames.getDynamicObjectType());
        projectName.set("fbasedataid_id", proAppObj.getPkValue());
        projectNames.add((Object)projectName);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{budgetDataBase});
    }

    public static void syncToProjectproposal(DynamicObject proApp) {
        DynamicObject proproposalf7 = proApp.getDynamicObject("proproposal");
        if (proproposalf7 != null) {
            DynamicObject proproposal = BusinessDataServiceHelper.loadSingle((Object)proproposalf7.getPkValue(), (String)"pmim_projectproposal");
            DynamicObjectCollection projectCollection = proproposal.getDynamicObjectCollection("project");
            DynamicObject project = new DynamicObject(projectCollection.getDynamicObjectType());
            project.set("fbasedataid_id", proApp.getPkValue());
            projectCollection.add((Object)project);
            DynamicObjectCollection projectNameCollection = proproposal.getDynamicObjectCollection("projectname");
            DynamicObject projectname = new DynamicObject(projectNameCollection.getDynamicObjectType());
            projectname.set("fbasedataid_id", proApp.getPkValue());
            projectNameCollection.add((Object)projectname);
            proproposal.set("bizstatus", (Object)BizStatusEnum.APPROVAL.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proproposal});
        }
    }

    public static void deleteFromProjectproposal(DynamicObject proApp) {
        DynamicObject proproposalf7 = proApp.getDynamicObject("proproposal");
        if (proproposalf7 != null) {
            DynamicObject proproposal = BusinessDataServiceHelper.loadSingle((Object)proproposalf7.getPkValue(), (String)"pmim_projectproposal");
            DynamicObjectCollection projectCollection = proproposal.getDynamicObjectCollection("project");
            DynamicObjectCollection projectNameCollection = proproposal.getDynamicObjectCollection("projectname");
            Iterator projectIt = projectCollection.iterator();
            Iterator projectNameIt = projectNameCollection.iterator();
            while (projectIt.hasNext()) {
                DynamicObject project = (DynamicObject)projectIt.next();
                projectNameIt.next();
                if (!project.getDynamicObject("fbasedataid").getPkValue().equals(proApp.getPkValue())) continue;
                projectIt.remove();
                projectNameIt.remove();
            }
            if (projectCollection.isEmpty()) {
                proproposal.set("bizstatus", (Object)BizStatusEnum.NORMAL.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proproposal});
        }
    }

    public static void deleteFromBudgetDataBase(DynamicObject proAppObj, List<DynamicObject> budgetDataBaseList) {
        DynamicObject proproposalBillF7 = proAppObj.getDynamicObject("proproposal");
        DynamicObject budgetDataBaseF7 = proAppObj.getDynamicObject("bugproname");
        if (proproposalBillF7 != null) {
            DynamicObject[] budgetDataBaseArr;
            for (DynamicObject budgetDataBase : budgetDataBaseArr = BusinessDataServiceHelper.load((String)"pmim_budgetbase", (String)"projectname", (QFilter[])new QFilter[]{new QFilter("proproposal.id", "=", proproposalBillF7.getPkValue())})) {
                ProjectApprovalHelper.deleteProjectName(budgetDataBase, proAppObj, budgetDataBaseList);
            }
        } else if (proproposalBillF7 == null && budgetDataBaseF7 != null) {
            budgetDataBaseF7 = BusinessDataServiceHelper.loadSingle((Object)budgetDataBaseF7.getPkValue(), (String)"pmim_budgetbase");
            ProjectApprovalHelper.deleteProjectName(budgetDataBaseF7, proAppObj, budgetDataBaseList);
        }
    }

    private static void deleteProjectName(DynamicObject budgetDataBase, DynamicObject proAppObj, List<DynamicObject> budgetDataBaseList) {
        DynamicObjectCollection projectNames = budgetDataBase.getDynamicObjectCollection("projectname");
        Iterator projectNamesIt = projectNames.iterator();
        while (projectNamesIt.hasNext()) {
            DynamicObject projectName = (DynamicObject)projectNamesIt.next();
            if (!projectName.getDynamicObject("fbasedataid").getPkValue().equals(proAppObj.getPkValue())) continue;
            projectNamesIt.remove();
        }
        budgetDataBaseList.add(budgetDataBase);
    }

    public static boolean existsProjLeader(DynamicObject proleaderDymObj, DynamicObject proDymObj) {
        QFilter proLeaderQF = new QFilter("member", "=", (Object)proleaderDymObj.getLong("id"));
        QFilter projQF = new QFilter("project", "=", (Object)proDymObj.getLong("id"));
        QFilter pmRoleQF = new QFilter("role", "=", ProjectApprovalHelper.getProjLeaderRoleObj().getPkValue());
        return QueryServiceHelper.exists((String)"pmas_nowteam", (QFilter[])new QFilter[]{proLeaderQF, projQF, pmRoleQF});
    }

    public static boolean existsOutMember(DynamicObject member, DynamicObject role, DynamicObject proDymObj) {
        QFilter memberQF = new QFilter("outpartner", "=", member.getPkValue());
        QFilter projQF = new QFilter("project", "=", (Object)proDymObj.getLong("id"));
        QFilter roleQF = new QFilter("roleobj", "=", role.getPkValue());
        return QueryServiceHelper.exists((String)"pmas_outnowteam", (QFilter[])new QFilter[]{memberQF, projQF, roleQF});
    }

    protected static boolean objEquals(DynamicObject source, DynamicObject target) {
        return source != null && target != null && source.getPkValue().equals(target.getPkValue());
    }

    public static DynamicObject getNowTeamObj(DynamicObject proleaderDymObj, DynamicObject projectDymObj) {
        QFilter proLeaderQF = new QFilter("member", "=", (Object)proleaderDymObj.getLong("id"));
        QFilter projQF = new QFilter("project", "=", (Object)projectDymObj.getLong("id"));
        DynamicObject projLeaderRoleObj = ProjectApprovalHelper.getProjLeaderRoleObj();
        if (projLeaderRoleObj == null) {
            return null;
        }
        QFilter pmRoleQF = new QFilter("role", "=", ProjectApprovalHelper.getProjLeaderRoleObj().getPkValue());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"pmas_nowteam", (QFilter[])new QFilter[]{proLeaderQF, projQF, pmRoleQF});
    }

    public static DynamicObject getNowTeamObj(Object projectDymObjID) {
        DynamicObject projLeaderRoleObj = ProjectApprovalHelper.getProjLeaderRoleObj();
        if (projLeaderRoleObj == null) {
            return null;
        }
        QFilter pmRoleQF = new QFilter("role", "=", projLeaderRoleObj.getPkValue());
        QFilter projQF = new QFilter("project", "=", projectDymObjID != null ? Long.valueOf(projectDymObjID.toString()) : null);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"pmas_nowteam", (QFilter[])new QFilter[]{pmRoleQF, projQF});
    }

    public static DynamicObject[] getNowTeamManager(Object projectDymObjID) {
        QFilter isChargeQF = new QFilter("ischarge", "=", (Object)Boolean.TRUE);
        QFilter projQF = new QFilter("project", "=", projectDymObjID);
        return BusinessDataServiceHelper.load((String)"pmas_nowteam", (String)"id,member", (QFilter[])new QFilter[]{isChargeQF, projQF});
    }

    public static DynamicObject[] getNowTeamMenbers(DynamicObject projectObj) {
        if (projectObj == null) {
            return null;
        }
        return BusinessDataServiceHelper.load((String)"pmas_nowteam", (String)"id,project,seqno,member,ischarge,role,telno,description", (QFilter[])new QFilter[]{new QFilter("project", "=", projectObj.getPkValue())});
    }

    public static DynamicObject[] getOutNowTeamMenbers(DynamicObject projectObj) {
        if (projectObj == null) {
            return null;
        }
        return BusinessDataServiceHelper.load((String)"pmas_outnowteam", (String)"project, seqno, member, role, telno, description,outpartner,roleobj,outbizparter", (QFilter[])new QFilter[]{new QFilter("project", "=", projectObj.getPkValue())});
    }

    public static DynamicObject getProjLeaderRoleObj() {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)"117VXH+9X6P2", (String)"perm_role");
    }

    public static Boolean createnNowTeam(DynamicObject projectObj, DynamicObject projleaderObj, String telNo, TeamAdjustDescEnum descEnum, boolean isCharge) {
        DynamicObject nowTeamObj = BusinessDataServiceHelper.newDynamicObject((String)"pmas_nowteam");
        nowTeamObj.set("project", (Object)projectObj);
        nowTeamObj.set("member", (Object)projleaderObj);
        nowTeamObj.set("role", (Object)ProjectApprovalHelper.getProjLeaderRoleObj());
        nowTeamObj.set("telno", (Object)telNo);
        if (isCharge) {
            nowTeamObj.set("ischarge", (Object)1);
            nowTeamObj.set("seqno", (Object)-1);
        } else {
            nowTeamObj.set("ischarge", (Object)0);
        }
        nowTeamObj.set("description", (Object)descEnum.getDesc());
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmas_nowteam", (DynamicObject[])new DynamicObject[]{nowTeamObj}, (OperateOption)OperateOption.create());
        return saveResult.isSuccess();
    }

    public static Map<String, BigDecimal> getBudgetOutRoot(DynamicObjectCollection budgetOutEntrys) {
        HashMap<String, BigDecimal> rootMap = new HashMap<String, BigDecimal>(16);
        for (DynamicObject entry : budgetOutEntrys) {
            String parentId = entry.getString("pid");
            String outItemName = entry.getString("outitemname");
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)parentId) || outItemName == null || outItemName.trim().isEmpty()) continue;
            BigDecimal bdOutAmount = entry.getBigDecimal("bdoutamount");
            rootMap.put(outItemName, bdOutAmount);
        }
        return rootMap;
    }

    public static Map<String, Object> getBudgetOutRootByName(DynamicObjectCollection budgetOutEntrys) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        for (DynamicObject entry : budgetOutEntrys) {
            String parentId = entry.getString("pid");
            String outItemName = entry.getString("outitemname");
            DynamicObject outItem = entry.getDynamicObject("outitem");
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)parentId) || outItemName == null || outItemName.trim().isEmpty() || outItem == null) continue;
            map.put(outItemName, outItem.getPkValue());
        }
        return map;
    }

    public static Map<String, BigDecimal> getControlinfoEntryByName(DynamicObjectCollection controlinfoEntrys) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(16);
        for (DynamicObject entry : controlinfoEntrys) {
            BigDecimal newAmount;
            String name = entry.getString("ctrloutitemname");
            if (map.containsKey(name)) {
                newAmount = (BigDecimal)map.get(name);
                newAmount = newAmount.add(entry.getBigDecimal("undertakeamt"));
            } else {
                newAmount = entry.getBigDecimal("undertakeamt");
            }
            map.put(name, newAmount);
        }
        return map;
    }

    public static void saveSysProAuto(DynamicObject appPro, ApproveContext context) {
        Throwable throwable;
        TXHandle h;
        DynamicObject parentProject;
        block31: {
            DynamicObject pro = appPro.getDynamicObject("pro");
            parentProject = null;
            if (pro != null) {
                DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pro.getPkValue(), (String)push_target_project);
                ProjectApprovalHelper.backupsProInfo(project);
                project.set("planbegindate", appPro.get("planbegindate"));
                project.set("planenddate", appPro.get("planenddate"));
                project.set("proaddress", appPro.get("proaddress"));
                project.set("department", appPro.get("createorg"));
                project.set("pmascreateorg", appPro.get("org"));
                project.set("group", appPro.get("kind"));
                project.set(BUDGETPRONAME, appPro.get(BUDGETPRONAME));
                project.set(BUDGETPRONUMBER, appPro.get(BUDGETPRONUMBER));
                context.setSysPro(project);
                h = TX.requiresNew();
                throwable = null;
                try {
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{context.getSysPro()});
                        break block31;
                    }
                    catch (Exception e1) {
                        logger.error("\u540c\u6b65\u65b0\u589e\u9879\u76ee\u5f02\u5e38\u3002", (Throwable)e1);
                        h.markRollback();
                        throw e1;
                    }
                }
                catch (Throwable e1) {
                    throwable = e1;
                    throw e1;
                }
                finally {
                    if (h != null) {
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable e1) {
                                throwable.addSuppressed(e1);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
            }
            List<AssociatedTableModel> tableModels = Arrays.asList(new AssociatedTableModel("sys", "t_bd_project_tc"), new AssociatedTableModel("sys", "t_bd_project_lk"));
            AutoPushOperation ato = new AutoPushOperation(appPro.getPkValue(), push_source_approval, push_target_project, appId, null, tableModels);
            pro = ato.pushAction();
            appPro.set("pro", (Object)pro);
            context.setSysPro(pro);
        }
        Object parentPro = appPro.get("parentpro");
        if (parentPro != null) {
            parentProject = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)parentPro).getPkValue(), (String)push_target_project);
            parentProject.set("isleaf", (Object)0);
        }
        context.setApprovePro(appPro);
        if (parentProject != null) {
            h = TX.requiresNew();
            throwable = null;
            try {
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentProject});
                }
                catch (Exception e) {
                    logger.error("\u66f4\u65b0\u4e0a\u7ea7\u9879\u76ee\u4fe1\u606f\u5f02\u5e38\u3002", (Throwable)e);
                    h.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
    }

    public static void backupsProInfo(DynamicObject project) {
        if (project != null) {
            MainEntityType proBackDt = EntityMetadataCache.getDataEntityType((String)"pmas_projectbackups");
            DynamicObject proBackups = new DynamicObject((DynamicObjectType)proBackDt);
            proBackups.set("id", (Object)Long.parseLong(project.getPkValue().toString()));
            if (project.get("masterid") != null) {
                proBackups.set("masterid", (Object)project.getLong("masterid"));
            }
            proBackups.set("sourcedata", project.get("sourcedata"));
            proBackups.set("bitindex", project.get("bitindex"));
            proBackups.set("srcindex", project.get("srcindex"));
            proBackups.set("org", (Object)project.getDynamicObject("org"));
            proBackups.set("createorg", project.get("createorg"));
            proBackups.set("department", project.get("department"));
            proBackups.set("pmascreateorg", project.get("pmascreateorg"));
            proBackups.set("useorg", project.get("useorg"));
            proBackups.set("modifier", project.get("modifier"));
            proBackups.set("creator", project.get("creator"));
            proBackups.set("createtime", project.get("createtime"));
            proBackups.set("modifytime", project.get("modifytime"));
            proBackups.set("planbegindate", project.get("planbegindate"));
            proBackups.set("planenddate", project.get("planenddate"));
            proBackups.set("refcheck", project.get("refcheck"));
            proBackups.set("number", project.get("number"));
            proBackups.set("name", project.get("name"));
            proBackups.set("status", project.get("status"));
            proBackups.set("enable", project.get("enable"));
            proBackups.set("ctrlstrategy", project.get("ctrlstrategy"));
            proBackups.set("parent", project.get("parent"));
            proBackups.set("group", project.get("group"));
            proBackups.set("level", project.get("level"));
            proBackups.set("longnumber", project.get("longnumber"));
            proBackups.set("fullname", project.get("fullname"));
            proBackups.set("isleaf", project.get("isleaf"));
            proBackups.set("proaddress", project.get("proaddress"));
            proBackups.set("issys", project.get("issys"));
            proBackups.set("systemtype", project.get("systemtype"));
            proBackups.set(BUDGETPRONAME, project.get(BUDGETPRONAME));
            proBackups.set(BUDGETPRONUMBER, project.get(BUDGETPRONUMBER));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proBackups});
        }
    }

    public static void synProjLeader(DynamicObject proApproveObj) {
        DynamicObject projectObj = proApproveObj.getDynamicObject("pro");
        DynamicObject projLeaderObj = proApproveObj.getDynamicObject("proleader");
        if (projLeaderObj == null || projectObj == null) {
            return;
        }
        DynamicObject projLeaderRoleObj = ProjectApprovalHelper.getProjLeaderRoleObj();
        DynamicObjectCollection teamEntitys = proApproveObj.getDynamicObjectCollection("proappteamentity");
        DynamicObject existsTeamMemberObj = ProjectApprovalHelper.exsitsTeamMember(projLeaderObj, teamEntitys);
        if (existsTeamMemberObj != null) {
            ProjectApprovalHelper.moveProjLeadertoTop(projLeaderObj, projLeaderRoleObj, proApproveObj, teamEntitys);
        } else {
            ProjectApprovalHelper.insertProLeader(projLeaderObj, projLeaderRoleObj, proApproveObj, teamEntitys);
        }
    }

    protected static void insertProLeader(DynamicObject projLeaderObj, DynamicObject projLeaderRoleObj, DynamicObject proApproveObj, DynamicObjectCollection teamEntitys) {
        ArrayList oriList = new ArrayList(teamEntitys);
        teamEntitys.clear();
        DynamicObject addNewObj = teamEntitys.addNew();
        addNewObj.set("teamuser", (Object)projLeaderObj);
        addNewObj.set("teamrole", (Object)projLeaderRoleObj);
        String telNo = proApproveObj.getString("leaderconttype");
        addNewObj.set("teamtelno", (Object)telNo);
        addNewObj.set("teamdescription", (Object)TeamAdjustDescEnum.PROJ_APPROVE.getDesc());
        addNewObj.set("ischarge", (Object)1);
        oriList.forEach(oriItemMember -> {
            DynamicObject needAddNewObj = teamEntitys.addNew();
            Object pkValue = oriItemMember.getPkValue();
            if (pkValue != null && Long.parseLong(oriItemMember.getPkValue().toString()) != 0L) {
                needAddNewObj.set("id", pkValue);
            }
            needAddNewObj.set("teamuser", oriItemMember.get("teamuser"));
            needAddNewObj.set("teamrole", oriItemMember.get("teamrole"));
            needAddNewObj.set("teamtelno", oriItemMember.get("teamtelno"));
            needAddNewObj.set("teamdescription", oriItemMember.get("teamdescription"));
            needAddNewObj.set("ischarge", oriItemMember.get("ischarge"));
        });
        proApproveObj.set("proappteamentity", (Object)teamEntitys);
    }

    protected static void moveProjLeadertoTop(DynamicObject projLeaderObj, DynamicObject projLeaderRoleObj, DynamicObject proApproveObj, DynamicObjectCollection teamEntitys) {
        if (CollectionUtils.isEmpty((Collection)teamEntitys)) {
            return;
        }
        ArrayList oriList = new ArrayList(teamEntitys);
        List<DynamicObject> notProjLeaderMembers = oriList.stream().filter(itemMemberObj -> {
            DynamicObject itemTeamRoleObj;
            DynamicObject itemMemberUserObj = itemMemberObj.getDynamicObject("teamuser");
            boolean isProjLeader = ProjectApprovalHelper.memberIsProjLeader(projLeaderObj, projLeaderRoleObj, itemMemberUserObj, itemTeamRoleObj = itemMemberObj.getDynamicObject("teamrole"));
            return !isProjLeader;
        }).collect(Collectors.toList());
        teamEntitys.clear();
        DynamicObject addNewObj = teamEntitys.addNew();
        addNewObj.set("teamuser", (Object)projLeaderObj);
        addNewObj.set("teamrole", (Object)projLeaderRoleObj);
        String telNo = proApproveObj.getString("leaderconttype");
        addNewObj.set("teamtelno", (Object)telNo);
        addNewObj.set("teamdescription", (Object)TeamAdjustDescEnum.PROJ_APPROVE.getDesc());
        addNewObj.set("ischarge", (Object)1);
        notProjLeaderMembers.forEach(oriItemMember -> {
            DynamicObject needAddNewObj = teamEntitys.addNew();
            Object pkValue = oriItemMember.getPkValue();
            if (pkValue != null && Long.parseLong(oriItemMember.getPkValue().toString()) != 0L) {
                needAddNewObj.set("id", pkValue);
            }
            needAddNewObj.set("teamuser", oriItemMember.get("teamuser"));
            needAddNewObj.set("teamrole", oriItemMember.get("teamrole"));
            needAddNewObj.set("teamtelno", oriItemMember.get("teamtelno"));
            needAddNewObj.set("teamdescription", oriItemMember.get("teamdescription"));
            needAddNewObj.set("ischarge", oriItemMember.get("ischarge"));
        });
        proApproveObj.set("proappteamentity", (Object)teamEntitys);
    }

    public static DynamicObject exsitsTeamMember(DynamicObject projLeaderObj, DynamicObjectCollection teamEntitys) {
        if (CollectionUtils.isEmpty((Collection)teamEntitys)) {
            return null;
        }
        DynamicObject projLeaderRoleObj = ProjectApprovalHelper.getProjLeaderRoleObj();
        Optional<DynamicObject> firstMatch = teamEntitys.stream().filter(itemMember -> {
            DynamicObject itemMemberUserObj = itemMember.getDynamicObject("teamuser");
            DynamicObject itemTeamRoleObj = itemMember.getDynamicObject("teamrole");
            return ProjectApprovalHelper.memberIsProjLeader(projLeaderObj, projLeaderRoleObj, itemMemberUserObj, itemTeamRoleObj);
        }).findFirst();
        return firstMatch.orElse(null);
    }

    public static boolean memberIsProjLeader(DynamicObject projLeaderObj, DynamicObject projLeaderRoleObj, DynamicObject memberUserObj, DynamicObject memberRoleObj) {
        return memberUserObj != null && memberUserObj.getPkValue().equals(projLeaderObj.getPkValue()) && memberRoleObj != null && memberRoleObj.getPkValue().equals(projLeaderRoleObj.getPkValue());
    }

    public static void backupsSupervision(DynamicObject dataEntity) {
        Object id = dataEntity.getPkValue();
        if (id != null) {
            DynamicObjectCollection workEntry = dataEntity.getDynamicObjectCollection("workentity");
            DynamicObject kind = dataEntity.getDynamicObject("kind");
            DynamicObject projectKind = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("projectkind.id", "=", kind.getPkValue())});
            DynamicObjectCollection supervisionEntry = (projectKind = BusinessDataServiceHelper.loadSingle((Object)projectKind.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_prokindctrlsetting"))).getDynamicObjectCollection("spventryentity");
            if (supervisionEntry != null && !supervisionEntry.isEmpty()) {
                MainEntityType SDT = EntityMetadataCache.getDataEntityType((String)"pmbs_workexecution");
                DynamicObjectType DT = workEntry.getDynamicObjectType();
                ORM orm = ORM.create();
                long[] sids = orm.genLongIds((IDataEntityType)SDT, supervisionEntry.size());
                int i = 0;
                for (DynamicObject supervision : supervisionEntry) {
                    DynamicObject workObject = new DynamicObject(DT);
                    workObject.set("projectstage", (Object)supervision.getDynamicObject("spvprojectstage"));
                    workObject.set("workitem", (Object)supervision.getString("workitem"));
                    workObject.set("keyitem", (Object)supervision.getBoolean("keyitem"));
                    workObject.set("sysbill", (Object)supervision.getDynamicObject("sysbill"));
                    workObject.set("keypropertyid", (Object)supervision.getString("keypropconfigid"));
                    workObject.set("hiddendata", (Object)Boolean.TRUE);
                    workObject.set("supervisionid", (Object)sids[i]);
                    workEntry.add((Object)workObject);
                    ++i;
                }
            }
        }
    }

    public static void updateDownFlowBill(ApproveContext context) {
        DynamicObject appPro = context.getApprovePro();
        try {
            DynamicObjectCollection appBudgetInCol;
            ProjectApprovalHelper.backupsSupervision(appPro);
            ProjectApprovalHelper.saveSupervisionAuto(appPro);
            ProjectApprovalHelper.saveProGoal(context);
            ProjectApprovalHelper.saveProTeamBill(context);
            ProjectApprovalHelper.saveProBudgetCtrl(context);
            DynamicObjectCollection appBudgetOutCol = appPro.getDynamicObjectCollection("budgetout");
            if (appBudgetOutCol.size() > 0) {
                ProjectApprovalHelper.saveOutBudget(context, BudgetSourceTypeEnum.OUT);
                ProjectApprovalHelper.saveTotalBudget(context, BudgetSourceTypeEnum.TOTAL);
            }
            if ((appBudgetInCol = appPro.getDynamicObjectCollection("budgetin")).size() > 0) {
                ProjectApprovalHelper.saveInBudget(context, BudgetSourceTypeEnum.IN);
            }
            ProjectApprovalHelper.saveFundSource(context);
            ProjectApprovalHelper.savePurchasePlan(context);
            ProjectApprovalHelper.saveProStatus(context);
            ProjectApprovalHelper.updateBudgetRecordField(context, appPro, action_audit);
        }
        catch (Exception e) {
            logger.error("Sync_create_biz_bill_error", (Throwable)e);
            ProjectApprovalHelper.deleteSysProject(context.getSysPro());
            ProjectApprovalHelper.deleteAssociation(Long.valueOf(appPro.getPkValue().toString()));
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u751f\u6210\u4e0b\u6e38\u5355\u636e\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectApprovalHelper_34", (String)"pmgt-pmas-business", (Object[])new Object[0]));
        }
        try {
            ProjectApprovalHelper.returnOccupyAmtAndClearRecord(appPro, action_audit, "unsubmitoccupy");
            String budgetControlMode = appPro.getString(BUDGET_CONTROL_MODE);
            if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                BudgetCtrlHelper.invokeAdjustInterface((DynamicObject)appPro, (BudgetCtrlEnum)BudgetCtrlEnum.AUDIT);
            }
        }
        catch (Exception e) {
            logger.error("Sync_create_biz_bill_error", (Throwable)e);
            ProjectApprovalHelper.deleteSysProject(context.getSysPro());
            ProjectApprovalHelper.deleteAssociation(Long.valueOf(appPro.getPkValue().toString()));
            throw new KDBizException(e.getMessage());
        }
    }

    public static void deleteProjectProposalAndBudgetDataBase(DynamicObject proApproval) {
        ArrayList<DynamicObject> budgetDataBaseList = new ArrayList<DynamicObject>();
        DynamicObject proApp = BusinessDataServiceHelper.loadSingle((Object)proApproval.getPkValue(), (String)push_source_approval);
        ProjectApprovalHelper.deleteFromProjectproposal(proApp);
        ProjectApprovalHelper.deleteFromBudgetDataBase(proApp, budgetDataBaseList);
        SaveServiceHelper.save((DynamicObject[])budgetDataBaseList.toArray(new DynamicObject[budgetDataBaseList.size()]));
    }

    public static void syncProjectProposalAndBudgetDataBase(DynamicObject appPro) {
        ProjectApprovalHelper.syncToProjectproposal(appPro);
        ProjectApprovalHelper.syncToBudgetDataBase(appPro);
    }

    public static void saveSupervisionAuto(DynamicObject dataEntity) {
        DynamicObjectCollection workEntry = dataEntity.getDynamicObjectCollection("workentity");
        if (workEntry != null && !workEntry.isEmpty()) {
            List<AssociatedTableModel> tableModels = Arrays.asList(new AssociatedTableModel("cr", "t_pmas_prosupervision_tc"), new AssociatedTableModel("cr", "t_pmas_prosupervision_lk"), new AssociatedTableModel("cr", "t_pmas_supervision_lk"));
            AutoPushOperation ato = new AutoPushOperation(dataEntity.getPkValue(), push_source_approval, "pmas_projectsupervision", appId, null, tableModels);
            ato.pushAction();
        }
    }

    public static void savePurchasePlan(ApproveContext context) {
        DynamicObject approvePro = context.getApprovePro();
        DynamicObject purchaseObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_purchaseplan"));
        if (approvePro.getBoolean("isneedpurchaseplan")) {
            DynamicObject sysPro = context.getSysPro();
            purchaseObj.set("project", (Object)sysPro);
            purchaseObj.set("org", approvePro.get("org"));
            purchaseObj.set("createorg", approvePro.get("createorg"));
            purchaseObj.set("billno", (Object)(approvePro.getString("billno") + "_PURCHASE"));
            purchaseObj.set("billname", (Object)String.format(ResManager.loadKDString((String)"%s\u91c7\u8d2d\u9700\u6c42\u8ba1\u5212", (String)"ProjectApprovalHelper_63", (String)"pmgt-pmas-business", (Object[])new Object[0]), approvePro.getString("billname")));
            purchaseObj.set("applydate", approvePro.get("projectapplydate"));
            purchaseObj.set("currency", approvePro.get("currencyfield"));
            purchaseObj.set("projectbugamt", approvePro.get("projcetbugamt"));
            purchaseObj.set("proyearbudgetamt", approvePro.get("proyearbudgetamt"));
            purchaseObj.set("purchasescale", approvePro.get("purchasescale"));
            purchaseObj.set("creator", approvePro.get("creator"));
            purchaseObj.set("auditor", approvePro.get("auditor"));
            purchaseObj.set("createtime", (Object)new Date());
            purchaseObj.set("auditdate", (Object)new Date());
            purchaseObj.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
            DynamicObjectCollection purchaseEntries = purchaseObj.getDynamicObjectCollection("purchaseplanentry");
            DynamicObjectCollection approPurchaseEntry = approvePro.getDynamicObjectCollection("purchaseplanentry");
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (DynamicObject entry : approPurchaseEntry) {
                DynamicObject purchaseEntry = new DynamicObject(purchaseEntries.getDynamicObjectType());
                purchaseEntry.set("entryamount", entry.get("purchaseamount"));
                purchaseEntry.set("entrybaseunit", entry.get("purchasebaseunit"));
                purchaseEntry.set("entrydescription", entry.get("purchasedescription"));
                purchaseEntry.set("entrygroup", entry.get("purchasegroup"));
                purchaseEntry.set("entrymaterial", entry.get("purchasematerial"));
                purchaseEntry.set("entryprice", entry.get("purchaseprice"));
                purchaseEntry.set("entryqty", entry.get("purchaseqty"));
                totalAmount = totalAmount.add(entry.getBigDecimal("purchaseamount"));
                purchaseEntries.add((Object)purchaseEntry);
            }
            purchaseObj.set("totalamount", (Object)totalAmount);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{purchaseObj});
        }
    }

    public static void saveProGoal(ApproveContext context) {
        DynamicObject approvePro = context.getApprovePro();
        String purpose = approvePro.getString("purpose");
        if (StringUtils.isBlank((CharSequence)purpose)) {
            return;
        }
        DynamicObject goal = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projectobjective"));
        DynamicObject sysPro = context.getSysPro();
        goal.set("project", (Object)sysPro);
        goal.set("billname", (Object)String.format(ResManager.loadKDString((String)"%s_\u9879\u76ee\u76ee\u6807", (String)"ProjectApprovalHelper_17", (String)"pmgt-pmas-business", (Object[])new Object[0]), sysPro.get("name")));
        DynamicObject org = approvePro.getDynamicObject("org");
        String billNo = CodeRuleHelper.getBillNo((String)"pmas_projectobjective", (DynamicObject)goal, (String)org.getPkValue().toString());
        if (StringUtils.isEmpty((CharSequence)billNo)) {
            billNo = sysPro.get("number") + "_GOAL";
        }
        goal.set("billno", (Object)billNo);
        goal.set("org", (Object)org);
        goal.set("issys", (Object)DefaultEnum.YES.getValue());
        goal.set("projkind", approvePro.get("kind"));
        goal.set("objstatus", (Object)ProjValidEnum.VALID.getValue());
        goal.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        goal.set("creator", approvePro.get("creator"));
        Date now = new Date();
        goal.set("createtime", (Object)now);
        goal.set("auditor", approvePro.get("auditor"));
        goal.set("auditdate", (Object)now);
        goal.set("modifier", approvePro.get("modifier"));
        goal.set("modifytime", (Object)now);
        goal.set("version", (Object)BigDecimal.ONE);
        goal.set("objective", (Object)purpose);
        goal.set("createorg", approvePro.get("createorg"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{goal});
    }

    public static void saveProTeamBill(ApproveContext context) {
        DynamicObject proTeam = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_team"));
        proTeam.set("id", (Object)ORM.create().genLongId("pmas_team"));
        DynamicObject sysPro = context.getSysPro();
        DynamicObject approvePro = context.getApprovePro();
        proTeam.set("project", (Object)sysPro);
        proTeam.set("billname", (Object)String.format(ResManager.loadKDString((String)"%s_\u9879\u76ee\u56e2\u961f", (String)"ProjectApprovalHelper_18", (String)"pmgt-pmas-business", (Object[])new Object[0]), sysPro.get("name")));
        DynamicObject org = approvePro.getDynamicObject("org");
        String billNo = CodeRuleHelper.getBillNo((String)"pmas_team", (DynamicObject)proTeam, (String)org.getPkValue().toString());
        if (StringUtils.isEmpty((CharSequence)billNo)) {
            billNo = sysPro.get("number") + "_TEAM";
        }
        proTeam.set("billno", (Object)billNo);
        proTeam.set("proleader", (Object)approvePro.getDynamicObject("proleader"));
        proTeam.set("leaderconttype", (Object)approvePro.getString("leaderconttype"));
        proTeam.set("org", (Object)org);
        proTeam.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        proTeam.set("projkind", approvePro.get("kind"));
        proTeam.set("issys", (Object)DefaultEnum.YES.getValue());
        proTeam.set("type", (Object)BillTypeEnum.NEW.getValue());
        proTeam.set("creator", approvePro.get("creator"));
        Date now = new Date();
        proTeam.set("createtime", (Object)now);
        proTeam.set("auditor", approvePro.get("auditor"));
        proTeam.set("auditdate", (Object)now);
        proTeam.set("modifier", approvePro.get("modifier"));
        proTeam.set("modifytime", (Object)now);
        proTeam.set("createorg", approvePro.get("createorg"));
        DynamicObjectCollection teamCollection = proTeam.getDynamicObjectCollection("teamentry");
        DynamicObjectCollection appTeamCollection = approvePro.getDynamicObjectCollection("proappteamentity");
        for (DynamicObject appTeam : appTeamCollection) {
            DynamicObject teamEntry = new DynamicObject(teamCollection.getDynamicObjectType());
            teamEntry.set("member", appTeam.get("teamuser"));
            teamEntry.set("role", appTeam.get("teamrole"));
            teamEntry.set("ischarge", appTeam.get("ischarge"));
            teamEntry.set("telno", appTeam.get("teamtelno"));
            teamEntry.set("note", appTeam.get("teamdescription"));
            teamCollection.add((Object)teamEntry);
        }
        DynamicObjectCollection outTeamCollection = proTeam.getDynamicObjectCollection("outerteamentry");
        DynamicObjectCollection outAppTeamCollection = approvePro.getDynamicObjectCollection("teamouterstaffentity");
        for (DynamicObject appTeam : outAppTeamCollection) {
            DynamicObject outTeamEntry = new DynamicObject(outTeamCollection.getDynamicObjectType());
            outTeamEntry.set("outerteamuser", appTeam.get("outerteamuser"));
            outTeamEntry.set("outteamrole", appTeam.get("outteamrole"));
            outTeamEntry.set("outerteamtelno", appTeam.get("outerteamtelno"));
            outTeamEntry.set("outerteamdescription", appTeam.get("outerteamdescription"));
            outTeamEntry.set("outpartner", appTeam.get("outteampartner"));
            outTeamEntry.set("outroleobj", appTeam.get("outroleobj"));
            outTeamEntry.set("outbizpartner", appTeam.get("outbizpartner"));
            outTeamCollection.add((Object)outTeamEntry);
        }
        context.setProTeam(proTeam);
        if (!appTeamCollection.isEmpty() || !outAppTeamCollection.isEmpty()) {
            context.setGenerateTeam(true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proTeam});
        }
        if (context.isGenerateTeam()) {
            ArrayList<DynamicObject> teamMembers = new ArrayList<DynamicObject>();
            DynamicObjectCollection members = context.getProTeam().getDynamicObjectCollection("teamentry");
            if (!CollectionUtils.isEmpty((Collection)members)) {
                for (DynamicObject member : members) {
                    DynamicObject nowTeam = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_nowteam"));
                    nowTeam.set("project", (Object)context.getSysPro());
                    nowTeam.set("member", member.get("member"));
                    nowTeam.set("role", member.get("role"));
                    nowTeam.set("telno", member.get("telno"));
                    nowTeam.set("ischarge", member.get("ischarge"));
                    nowTeam.set("description", member.get("note"));
                    teamMembers.add(nowTeam);
                }
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmas_nowteam"), (Object[])teamMembers.toArray(new DynamicObject[teamMembers.size()]));
            }
            ArrayList<DynamicObject> outteamMembers = new ArrayList<DynamicObject>();
            DynamicObjectCollection outMembers = context.getProTeam().getDynamicObjectCollection("outerteamentry");
            if (!CollectionUtils.isEmpty((Collection)outMembers)) {
                for (DynamicObject member : outMembers) {
                    DynamicObject outNowTeam = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_outnowteam"));
                    outNowTeam.set("project", (Object)context.getSysPro());
                    outNowTeam.set("member", member.get("outerteamuser"));
                    outNowTeam.set("role", member.get("outteamrole"));
                    outNowTeam.set("telno", member.get("outerteamtelno"));
                    outNowTeam.set("description", member.get("outerteamdescription"));
                    outNowTeam.set("outpartner", member.get("outpartner"));
                    outNowTeam.set("roleobj", member.get("outroleobj"));
                    outNowTeam.set("outbizparter", member.get("outbizpartner"));
                    outteamMembers.add(outNowTeam);
                }
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmas_outnowteam"), (Object[])outteamMembers.toArray(new DynamicObject[outteamMembers.size()]));
            }
        }
    }

    public static void saveFundSource(ApproveContext context) {
        DynamicObject approvePro = context.getApprovePro();
        DynamicObject sysPro = context.getSysPro();
        approvePro.set("pro", (Object)sysPro);
        Date applyDate = approvePro.getDate("projectapplydate");
        if (applyDate == null) {
            applyDate = approvePro.getDate("createtime");
        }
        SynFunSourceHelper.createFunSource((DynamicObject)approvePro, (Date)applyDate, (String)push_source_approval);
    }

    public static void saveTotalBudget(ApproveContext context, BudgetSourceTypeEnum budgetSourceTypeEnum) {
        DynamicObject approvePro = context.getApprovePro();
        DynamicObjectCollection appBudgetCol = approvePro.getDynamicObjectCollection("budgetout");
        if (approvePro.getBigDecimal("prooutbudgetsumamt").compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_totalbudget");
        DynamicObject totalBudget = new DynamicObject((DynamicObjectType)dt);
        totalBudget.set("id", (Object)ORM.create().genLongId("pmas_totalbudget"));
        ProjectApprovalHelper.setBudgetCommonField(budgetSourceTypeEnum, context, appBudgetCol, totalBudget);
        ProjectBudgetGenerateHelper.generateProjectBudget((DynamicObject)totalBudget, (String)budgetSourceTypeEnum.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudget});
        ProBudgetControlHelper.updateTotalBudgetCtrlData((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)totalBudget.getPkValue(), (String)"pmas_totalbudget"));
    }

    public static void saveOutBudget(ApproveContext context, BudgetSourceTypeEnum budgetSourceTypeEnum) {
        DynamicObject approvePro = context.getApprovePro();
        DynamicObjectCollection appBudgetCol = approvePro.getDynamicObjectCollection("budgetout");
        if (approvePro.getBigDecimal("outamount").compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_outbudget");
        DynamicObject outBudget = new DynamicObject((DynamicObjectType)dt);
        outBudget.set("id", (Object)ORM.create().genLongId("pmas_outbudget"));
        String budgetControlMode = approvePro.getString(BUDGET_CONTROL_MODE);
        outBudget.set(BUDGET_CONTROL_MODE, (Object)budgetControlMode);
        outBudget.set(PROJECT_COST_CONTROL, approvePro.get(PROJECT_COST_CONTROL));
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
            outBudget.set(BUDGETPERIOD, approvePro.get(BUDGETPERIOD));
            outBudget.set(BUDGETPRONAME, approvePro.get(BUDGETPRONAME));
            outBudget.set(BUDGETPRONUMBER, approvePro.get(BUDGETPRONUMBER));
            outBudget.set(BUDGETPRO, approvePro.get(BUDGETPRO));
        }
        outBudget.set("splittype", approvePro.get("splittype"));
        outBudget.set("projectapplydate", approvePro.get("projectapplydate"));
        ProjectApprovalHelper.setBudgetCommonField(budgetSourceTypeEnum, context, appBudgetCol, outBudget);
        ProjectApprovalHelper.setControlInfoEntry(approvePro, outBudget);
        ProjectApprovalHelper.setRealBudgetEntry(approvePro, outBudget);
        String proBudgetCtrl = approvePro.getString("probudgetctrl");
        ProjectBudgetGenerateHelper.generateProjectBudget((DynamicObject)outBudget, (String)budgetSourceTypeEnum.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{outBudget});
        ProBudgetControlHelper.updateYearBudgetCtrlData((DynamicObject)outBudget);
    }

    public static void setBudgetCommonField(BudgetSourceTypeEnum budgetSourceTypeEnum, ApproveContext context, DynamicObjectCollection appBudgetCol, DynamicObject budget) {
        Long pkValue;
        Object budgetEntry;
        Date applyDate;
        String billNo;
        DynamicObject sysPro = context.getSysPro();
        DynamicObject approvePro = context.getApprovePro();
        budget.set("project", (Object)sysPro);
        DynamicObject org = approvePro.getDynamicObject("org");
        Object proName = sysPro.get("name");
        ILocaleString proNameLocal = sysPro.getLocaleString("name");
        if (proNameLocal != null && proNameLocal.getLocaleValue() != null) {
            proName = proNameLocal.getLocaleValue();
        }
        if (BudgetSourceTypeEnum.OUT == budgetSourceTypeEnum) {
            billNo = CodeRuleHelper.getBillNo((String)"pmas_outbudget", (DynamicObject)budget, (String)org.getPkValue().toString());
            if (StringUtils.isEmpty((CharSequence)billNo)) {
                billNo = sysPro.getString("number");
            }
            budget.set("name", (Object)String.format(ResManager.loadKDString((String)"%s_\u9884\u7b97\u652f\u51fa", (String)"ProjectApprovalHelper_20", (String)"pmgt-pmas-business", (Object[])new Object[0]), proName));
            budget.set("totalamount", approvePro.get("outamount"));
            budget.set("totalyearamt", (Object)approvePro.getBigDecimal("proyearbudgetamt"));
        } else if (BudgetSourceTypeEnum.IN == budgetSourceTypeEnum) {
            billNo = CodeRuleHelper.getBillNo((String)"pmas_inbudget", (DynamicObject)budget, (String)org.getPkValue().toString());
            if (StringUtils.isEmpty((CharSequence)billNo)) {
                billNo = sysPro.getString("number");
            }
            budget.set("name", (Object)String.format(ResManager.loadKDString((String)"%s_\u9884\u7b97\u6536\u5165", (String)"ProjectApprovalHelper_21", (String)"pmgt-pmas-business", (Object[])new Object[0]), proName));
            budget.set("totalamount", approvePro.get("inamount"));
            budget.set("totalyearamt", (Object)approvePro.getBigDecimal("proyearbudgetamt"));
        } else {
            billNo = CodeRuleHelper.getBillNo((String)"pmas_totalbudget", (DynamicObject)budget, (String)org.getPkValue().toString());
            if (StringUtils.isEmpty((CharSequence)billNo)) {
                billNo = sysPro.getString("number");
            }
            budget.set("name", (Object)String.format(ResManager.loadKDString((String)"%s_\u603b\u4f53\u9884\u7b97", (String)"ProjectApprovalHelper_35", (String)"pmgt-pmas-business", (Object[])new Object[0]), proName));
            budget.set("totalamount", approvePro.get("prooutbudgetsumamt"));
            budget.set("proapprovalamt", (Object)approvePro.getBigDecimal("projcetbugamt"));
            budget.set("projectapplydate", (Object)approvePro.getDate("projectapplydate"));
            budget.set("planbegindate", (Object)approvePro.getDate("planbegindate"));
            budget.set("planenddate", (Object)approvePro.getDate("planenddate"));
        }
        budget.set("billno", (Object)billNo);
        budget.set("org", (Object)org);
        budget.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        budget.set("budgetstage", approvePro.get("budgetstage"));
        budget.set("issys", (Object)DefaultEnum.YES.getValue());
        budget.set("isvalid", (Object)DefaultEnum.YES.getValue());
        budget.set("type", (Object)BillTypeEnum.NEW.getValue());
        budget.set("sourcetype", (Object)budgetSourceTypeEnum.getValue());
        budget.set("creator", approvePro.get("creator"));
        budget.set("createorg", approvePro.get("createorg"));
        Date now = new Date();
        budget.set("createtime", (Object)now);
        budget.set("auditor", approvePro.get("auditor"));
        budget.set("auditdate", (Object)now);
        budget.set("modifier", approvePro.get("modifier"));
        budget.set("modifytime", (Object)now);
        budget.set("currency", approvePro.get("currencyfield"));
        budget.set("version", (Object)1.0);
        budget.set("group", approvePro.get("kind"));
        DynamicObjectCollection budgetCollection = budget.getDynamicObjectCollection("treeentryentity");
        if (BudgetSourceTypeEnum.TOTAL != budgetSourceTypeEnum && (applyDate = approvePro.getDate("projectapplydate")) != null) {
            LocalDate localDate = applyDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                budget.set("year", (Object)sdf.parse(localDate.getYear() + "-01-01"));
            }
            catch (ParseException e) {
                logger.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a{}", (Object)e);
            }
        }
        HashMap<Long, Long> idMaps = new HashMap<Long, Long>();
        long[] ids = DB.genLongIds((String)"t_pmas_budgetentry", (int)appBudgetCol.size());
        int i = 0;
        if (BudgetSourceTypeEnum.OUT == budgetSourceTypeEnum) {
            for (DynamicObject appBudget : appBudgetCol) {
                budgetEntry = new DynamicObject(budgetCollection.getDynamicObjectType());
                pkValue = (Long)appBudget.getPkValue();
                idMaps.put(pkValue, ids[i]);
                budget.getDataEntityType().getPrimaryKey().setValueFast(budgetEntry, (Object)ids[i]);
                ++i;
                budgetEntry.set("seq", appBudget.get("seq"));
                budgetEntry.set("pid", appBudget.get("pid"));
                budgetEntry.set("budgetitemnum", appBudget.get("outitemnumber"));
                budgetEntry.set("budgetitemname", appBudget.get("outitemname"));
                budgetEntry.set("budgetitem", appBudget.get("outitem"));
                budgetEntry.set("descriptionentry", appBudget.get("outdescription"));
                budgetEntry.set("budgetamount", appBudget.get("bdoutamount"));
                budgetEntry.set("itemtotalamount", appBudget.get("outbudsumamount"));
                budgetCollection.add(budgetEntry);
            }
        } else if (BudgetSourceTypeEnum.IN == budgetSourceTypeEnum) {
            for (DynamicObject appBudget : appBudgetCol) {
                budgetEntry = new DynamicObject(budgetCollection.getDynamicObjectType());
                pkValue = (Long)appBudget.getPkValue();
                idMaps.put(pkValue, ids[i]);
                budget.getDataEntityType().getPrimaryKey().setValueFast(budgetEntry, (Object)ids[i]);
                ++i;
                budgetEntry.set("seq", appBudget.get("seq"));
                budgetEntry.set("pid", appBudget.get("pid"));
                budgetEntry.set("budgetitemnum", appBudget.get("initemnumber"));
                budgetEntry.set("budgetitemname", appBudget.get("initemname"));
                budgetEntry.set("budgetitem", appBudget.get("initem"));
                budgetEntry.set("descriptionentry", appBudget.get("indescription"));
                budgetEntry.set("budgetamount", appBudget.get("bdinamount"));
                budgetCollection.add(budgetEntry);
            }
        } else {
            QFilter projectFilter = new QFilter("project", "=", sysPro.getPkValue());
            DynamicObject[] projectBudgetItemList = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)String.join((CharSequence)",", "number", "budgetitem"), (QFilter[])new QFilter[]{projectFilter});
            for (DynamicObject appBudget : appBudgetCol) {
                DynamicObject budgetEntry2 = new DynamicObject(budgetCollection.getDynamicObjectType());
                Long pkValue2 = (Long)appBudget.getPkValue();
                idMaps.put(pkValue2, ids[i]);
                budget.getDataEntityType().getPrimaryKey().setValueFast((Object)budgetEntry2, (Object)ids[i]);
                ++i;
                budgetEntry2.set("seq", appBudget.get("seq"));
                budgetEntry2.set("pid", appBudget.get("pid"));
                budgetEntry2.set("budgetitemnum", appBudget.get("outitemnumber"));
                budgetEntry2.set("budgetitemname", appBudget.get("outitemname"));
                budgetEntry2.set("budgetitem", appBudget.get("outitem"));
                budgetEntry2.set("descriptionentry", appBudget.get("outdescription"));
                budgetEntry2.set("budgetamount", appBudget.get("outbudsumamount"));
                Optional<DynamicObject> optional = Arrays.stream(projectBudgetItemList).filter(dyn -> appBudget.get("outitemnumber").equals(dyn.getString("number"))).findFirst();
                if (optional.isPresent()) {
                    budgetEntry2.set("projectbudgetitem", (Object)optional.get());
                }
                budgetCollection.add((Object)budgetEntry2);
            }
        }
        Iterator iterator = budgetCollection.iterator();
        while (iterator.hasNext()) {
            DynamicObject budgetItem;
            Long aLong = (Long)idMaps.get((budgetItem = (DynamicObject)iterator.next()).get("pid"));
            budgetItem.set("pid", (Object)(aLong == null ? Long.valueOf(0L) : aLong));
        }
    }

    public static void setControlInfoEntry(DynamicObject approve, DynamicObject outBudget) {
        DynamicObjectCollection appControlInfoEntry = approve.getDynamicObjectCollection("controlinfoentry");
        DynamicObjectCollection outBudgetControlInfoEntry = outBudget.getDynamicObjectCollection("controlinfoentry");
        DynamicObjectType type = outBudgetControlInfoEntry.getDynamicObjectType();
        for (DynamicObject appControlInfo : appControlInfoEntry) {
            DynamicObject outBudgetControlInfo = new DynamicObject(type);
            outBudgetControlInfo.set("seq", appControlInfo.get("seq"));
            outBudgetControlInfo.set("ctrlbudgetitem", appControlInfo.get("ctrloutitem"));
            outBudgetControlInfo.set("ctrlbudgetitemname", appControlInfo.get("ctrloutitemname"));
            outBudgetControlInfo.set("undertakeorg", appControlInfo.get("undertakeorg"));
            outBudgetControlInfo.set("undertakeperiod", appControlInfo.get("undertakeperiod"));
            outBudgetControlInfo.set("currentratio", appControlInfo.get("undertakeratio"));
            outBudgetControlInfo.set("currentamt", appControlInfo.get("undertakeamt"));
            outBudgetControlInfo.set("entryproname", appControlInfo.get("entryproname"));
            outBudgetControlInfo.set("entrypronumber", appControlInfo.get("entrypronumber"));
            outBudgetControlInfo.set("entryproid", appControlInfo.get("entryproid"));
            outBudgetControlInfo.set("entryproid", appControlInfo.get("entryproid"));
            outBudgetControlInfo.set("differenceamt", appControlInfo.get("undertakeamt"));
            outBudgetControlInfo.set("thisnew", (Object)"1");
            outBudgetControlInfoEntry.add((Object)outBudgetControlInfo);
        }
    }

    public static void setRealBudgetEntry(DynamicObject approve, DynamicObject outBudget) {
        DynamicObjectCollection realBudgetEntryCol = approve.getDynamicObjectCollection(REALBUDGETENTRY);
        DynamicObjectCollection outBudgetControlInfoEntry = outBudget.getDynamicObjectCollection(REALBUDGETENTRY);
        DynamicObjectType type = outBudgetControlInfoEntry.getDynamicObjectType();
        for (DynamicObject realBudgetEntry : realBudgetEntryCol) {
            DynamicObject outBudgetControlInfo = new DynamicObject(type);
            outBudgetControlInfo.set("seq", realBudgetEntry.get("seq"));
            outBudgetControlInfo.set("realprobudgetname", realBudgetEntry.get("realprobudgetname"));
            outBudgetControlInfo.set("realbudgetitem", realBudgetEntry.get("realbudgetitem"));
            outBudgetControlInfo.set("realundertakeorg", realBudgetEntry.get("realundertakeorg"));
            outBudgetControlInfo.set("realundertakeperiod", realBudgetEntry.get("realundertakeperiod"));
            outBudgetControlInfo.set("realproname", realBudgetEntry.get("realproname"));
            outBudgetControlInfo.set("realpronumber", realBudgetEntry.get("realpronumber"));
            outBudgetControlInfo.set("realproid", realBudgetEntry.get("realproid"));
            outBudgetControlInfo.set("realundertakeamt", realBudgetEntry.get("realundertakeamt"));
            outBudgetControlInfoEntry.add((Object)outBudgetControlInfo);
        }
    }

    public static void saveInBudget(ApproveContext context, BudgetSourceTypeEnum budgetSourceTypeEnum) {
        DynamicObject approvePro = context.getApprovePro();
        DynamicObjectCollection appBudgetCol = approvePro.getDynamicObjectCollection("budgetin");
        if (approvePro.getBigDecimal("inamount").compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        DynamicObject budget = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_budget"));
        budget.set("id", (Object)ORM.create().genLongId("pmas_budget"));
        ProjectApprovalHelper.setBudgetCommonField(budgetSourceTypeEnum, context, appBudgetCol, budget);
        ProjectBudgetGenerateHelper.generateProjectBudget((DynamicObject)budget, (String)budgetSourceTypeEnum.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{budget});
        ProBudgetControlHelper.updateYearBudgetCtrlData((DynamicObject)budget);
    }

    public static void saveProStatus(ApproveContext context) {
        DynamicObject sysPro = context.getSysPro();
        StageStatusHelper.relateProject((DynamicObject)context.getApprovePro());
        StageStatusHelper.changeStatus((DynamicObject)sysPro, (ProjectStageEnum)ProjectStageEnum.PROPOSALSTAGE_S, (ProjectStatusEnum)ProjectStatusEnum.APPROVAL_SUCC);
    }

    public static void deleteSysProject(DynamicObject project) {
        if (project == null) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)push_target_project), (Object[])new Object[]{project.getPkValue()});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        DynamicObject parent = project.getDynamicObject("parent");
        if (parent != null) {
            QFilter parentFilter = new QFilter("parent", "=", parent.getPkValue());
            DynamicObject[] sonPros = BusinessDataServiceHelper.load((String)push_target_project, (String)"", (QFilter[])new QFilter[]{parentFilter});
            if (sonPros.length == 0) {
                parent = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)push_target_project);
                parent.set("isleaf", (Object)1);
                try (TXHandle h = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
                    }
                    catch (Exception e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    public static void deleteAssociation(Long approvalId) {
        List<AssociatedTableModel> tableModels = new ArrayList<AssociatedTableModel>(Arrays.asList(new AssociatedTableModel("sys", "t_bd_project_tc"), new AssociatedTableModel("sys", "t_bd_project_lk")));
        AutoPushUtil.deleteAssociation((Long)approvalId, tableModels);
        tableModels = Arrays.asList(new AssociatedTableModel("cr", "t_pmas_prosupervision_tc"), new AssociatedTableModel("cr", "t_pmas_prosupervision_lk"), new AssociatedTableModel("cr", "t_pmas_supervision_lk"));
        AutoPushUtil.deleteAssociation((Long)approvalId, tableModels);
    }

    public static void checkOccurUnSysBiz(DynamicObject project) {
        if (project == null) {
            return;
        }
        ArrayList<String> refTables = new ArrayList<String>(10);
        refTables.add("t_pmas_pro_approval");
        refTables.add("t_pmas_projectbudget");
        refTables.add("t_pmas_nowteam");
        refTables.add("t_pmas_projteam");
        refTables.add("t_pmas_prostatusentry");
        refTables.add("t_pmas_fundsource");
        refTables.add("t_pmas_projectobjective");
        refTables.add("t_pmas_budget");
        refTables.add("t_pmas_outnowteam");
        refTables.add("t_pmco_budgetrecord");
        refTables.add("t_pmfs_supervisperform");
        refTables.add("t_pmbs_workexecution");
        refTables.add("t_pmas_prosupervision");
        refTables.add("t_pmas_supervision");
        refTables.add("t_pmas_purchaseplan");
        ArrayList<String> ingoreRefEntityList = new ArrayList<String>(10);
        ingoreRefEntityList.add("pmct_contracttpl");
        ingoreRefEntityList.add("pmct_revisiontpl");
        ingoreRefEntityList.add("pmct_addagreementtpl");
        ingoreRefEntityList.add("pmct_claimbilltpl");
        ingoreRefEntityList.add("pmct_clarificbilltpl");
        ingoreRefEntityList.add("pmct_contract_settle_tpl");
        ingoreRefEntityList.add("pmct_finalsettletpl");
        ingoreRefEntityList.add("pmas_addtmemberbatch");
        ingoreRefEntityList.add("pmas_totalbudgetctrl");
        ingoreRefEntityList.add("pmas_ybudgetctrl");
        ingoreRefEntityList.add("pmas_ybudgetctrldetail");
        ingoreRefEntityList.add("pmas_tbudgetctrldetail");
        ingoreRefEntityList.add("pmas_budgetexerecord");
        ArrayList<String> refEntityList = new ArrayList<String>(10);
        refEntityList.add("pmct_incontract");
        refEntityList.add("pmct_outcontract");
        refEntityList.add("pmct_incontractrevision");
        refEntityList.add("pmct_outcontractrevision");
        refEntityList.add("pmct_inclaimbill");
        refEntityList.add("pmct_outclaimbill");
        refEntityList.add("pmct_inclarificbill");
        refEntityList.add("pmct_outclarificbill");
        refEntityList.add("pmct_incontract_settle");
        refEntityList.add("pmct_outcontract_settle");
        refEntityList.add("pmct_infinalsettle");
        refEntityList.add("pmct_outfinalsettle");
        BaseDataCheckRefrence checkRef = new BaseDataCheckRefrence();
        List refList = checkRef.getAllRefs((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)push_target_project), project.getPkValue());
        String systemType = project.getString("systemtype");
        for (BaseDataRefenceKey key : refList) {
            DynamicObject[] contObjs;
            String refEntityKey = key.getRefEntityKey();
            if (refTables.contains(key.getRefTable()) || ingoreRefEntityList.contains(refEntityKey) || refEntityList.contains(refEntityKey) && (contObjs = BusinessDataServiceHelper.load((String)refEntityKey, (String)"", (QFilter[])new QFilter[]{new QFilter("project", "=", project.getPkValue()), new QFilter("paydirection", "=", (Object)(refEntityKey.contains("in") ? PayDirectionEnum.IN.getValue() : PayDirectionEnum.OUT.getValue()))})).length == 0) continue;
            boolean checkResult = true;
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)refEntityKey);
            AppInfo appInfo = EntityMetadataCache.getAppInfo((String)dt.getAppId());
            String name = dt.getDisplayName().getLocaleValue();
            if (StringUtil.equals((String)systemType, (String)"PMGT")) {
                checkResult = false;
            } else if (StringUtil.equals((String)appInfo.getCloudNum(), (String)"PMGT")) {
                checkResult = false;
            }
            if (checkResult) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u5df2\u5173\u8054\u4e1a\u52a1\u5355\u636e\u201c%2$s\u201d\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002\u8bf7\u5148\u5220\u9664\u5173\u8054\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"ProjectApprovalHelper_53", (String)"pmgt-pmas-business", (Object[])new Object[0]), project.get("number"), StringUtils.isNotEmpty((CharSequence)name) ? name : ""));
        }
        DynamicObject[] refProApps = BusinessDataServiceHelper.load((String)push_source_approval, (String)"id", (QFilter[])new QFilter[]{new QFilter("parentpro", "=", project.getPkValue())});
        if (refProApps.length > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u9879\u76ee\u201c%s\u201d\u88ab\u540e\u7eed\u9879\u76ee\u7acb\u9879\u5355\u636e\u7684\u201c\u4e0a\u7ea7\u9879\u76ee\u201d\u5b57\u6bb5\u5f15\u7528\u3002", (String)"ProjectApprovalHelper_54", (String)"pmgt-pmas-business", (Object[])new Object[0]), project.get("name")));
        }
        DynamicObject[] teams = BusinessDataServiceHelper.load((String)"pmas_team", (String)"id", (QFilter[])new QFilter[]{new QFilter("issys", "=", (Object)"0").and(new QFilter("project", "=", project.getPkValue())).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue())});
        if (teams.length > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u9879\u76ee\u201c%s\u201d\u5df2\u53d1\u751f\u201c\u9879\u76ee\u56e2\u961f\u201d\u4e1a\u52a1\u3002", (String)"ProjectApprovalHelper_55", (String)"pmgt-pmas-business", (Object[])new Object[0]), project.get("name")));
        }
        DynamicObject[] goals = BusinessDataServiceHelper.load((String)"pmas_projectobjective", (String)"id", (QFilter[])new QFilter[]{new QFilter("issys", "=", (Object)"0").and(new QFilter("project", "=", project.getPkValue())).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue())});
        if (goals.length > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u9879\u76ee\u201c%s\u201d\u5df2\u53d1\u751f\u540e\u7eed\u201c\u9879\u76ee\u76ee\u6807\u201d\u4e1a\u52a1\u3002", (String)"ProjectApprovalHelper_56", (String)"pmgt-pmas-business", (Object[])new Object[0]), project.get("name")));
        }
        DynamicObject[] sources = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"id", (QFilter[])new QFilter[]{new QFilter("issys", "=", (Object)"0").and(new QFilter("project", "=", project.getPkValue())).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue())});
        if (sources.length > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u9879\u76ee\u201c%s\u201d\u5df2\u53d1\u751f\u540e\u7eed\u201c\u8d44\u91d1\u6765\u6e90\u201d\u4e1a\u52a1\u3002", (String)"ProjectApprovalHelper_57", (String)"pmgt-pmas-business", (Object[])new Object[0]), project.get("name")));
        }
        DynamicObject[] budgets = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id", (QFilter[])new QFilter[]{new QFilter("issys", "=", (Object)"0").and(new QFilter("project", "=", project.getPkValue())).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue())});
        if (budgets.length > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u9879\u76ee\u201c%s\u201d\u5df2\u53d1\u751f\u540e\u7eed\u201c\u9879\u76ee\u9884\u7b97\u201d\u4e1a\u52a1\u3002", (String)"ProjectApprovalHelper_58", (String)"pmgt-pmas-business", (Object[])new Object[0]), project.get("name")));
        }
        DynamicObject[] superAdjust = BusinessDataServiceHelper.load((String)"pmas_projectsupervision", (String)"id", (QFilter[])new QFilter[]{new QFilter("project", "=", project.getPkValue()).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()).and("syscreation", "=", (Object)Boolean.FALSE)});
        if (superAdjust.length > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u9879\u76ee\u201c%s\u201d\u5df2\u53d1\u751f\u540e\u7eed\u201c\u7763\u5bfc\u5b8c\u6210\u201d\u4e1a\u52a1\u3002", (String)"ProjectApprovalHelper_59", (String)"pmgt-pmas-business", (Object[])new Object[0]), project.get("name")));
        }
        DynamicObject[] superVisionFinishes = BusinessDataServiceHelper.load((String)"pmfs_supervisionfinish", (String)"id", (QFilter[])new QFilter[]{new QFilter("project", "=", project.getPkValue()).and("datasource", "!=", (Object)SupervisionDatasourceEnum.SYSTEM).and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue())});
        if (superVisionFinishes.length > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u9879\u76ee\u201c%s\u201d\u5df2\u53d1\u751f\u540e\u7eed\u201c\u7763\u5bfc\u5b8c\u6210\u201d\u4e1a\u52a1\u3002", (String)"ProjectApprovalHelper_59", (String)"pmgt-pmas-business", (Object[])new Object[0]), project.get("name")));
        }
    }

    public static void deleteBDPro(DynamicObject appPro, DynamicObject pro) {
        String systemType = pro.getString("systemtype");
        if (StringUtils.equals((CharSequence)systemType, (CharSequence)"PMGT")) {
            ProjectApprovalHelper.deleteSysProject(pro);
            ProjectApprovalHelper.deleteAssociation(Long.valueOf(String.valueOf(appPro.getPkValue())));
        } else {
            if (QueryServiceHelper.exists((String)"pmas_projectbackups", (Object)pro.getPkValue())) {
                DynamicObject backupsPro = BusinessDataServiceHelper.loadSingle((Object)pro.getPkValue(), (String)"pmas_projectbackups");
                pro.set("department", backupsPro.get("department"));
                pro.set("pmascreateorg", backupsPro.get("pmascreateorg"));
                pro.set("group", backupsPro.get("group"));
                pro.set("planbegindate", backupsPro.get("planbegindate"));
                pro.set("planenddate", backupsPro.get("planenddate"));
                pro.set("proaddress", backupsPro.get("proaddress"));
                pro.set("prostatus", (Object)0L);
                pro.set(BUDGETPRONAME, backupsPro.get(BUDGETPRONAME));
                pro.set(BUDGETPRONUMBER, backupsPro.get(BUDGETPRONUMBER));
                DeleteServiceHelper.delete((String)"pmas_projectbackups", (QFilter[])new QFilter[]{new QFilter("id", "=", pro.getPkValue())});
            } else {
                pro.set("prostatus", (Object)0L);
                pro.set(BUDGETPRONAME, (Object)"");
                pro.set(BUDGETPRONUMBER, (Object)"");
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pro});
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void deleteRelateBiz(DynamicObject appPro, DynamicObject pro) {
        ProjectApprovalHelper.doDeleteRelateBiz(appPro, pro, true);
    }

    public static void deleteRelateBizExclude(DynamicObject appPro, DynamicObject pro) {
        ProjectApprovalHelper.doDeleteRelateBiz(appPro, pro, false);
    }

    private static void doDeleteRelateBiz(DynamicObject appPro, DynamicObject pro, boolean needDeleteSysPro) {
        appPro.set("prostatus", (Object)0L);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appPro});
        if (needDeleteSysPro) {
            ProjectApprovalHelper.deleteBDPro(appPro, pro);
        }
        DeleteServiceHelper.delete((String)"pmas_projectobjective", (QFilter[])new QFilter[]{new QFilter("issys", "=", (Object)DefaultEnum.YES.getValue()).and(new QFilter("project", "=", pro.getPkValue()))});
        DeleteServiceHelper.delete((String)"pmas_team", (QFilter[])new QFilter[]{new QFilter("issys", "=", (Object)DefaultEnum.YES.getValue()).and(new QFilter("project", "=", pro.getPkValue()))});
        DeleteServiceHelper.delete((String)"pmas_projfundsource", (QFilter[])new QFilter[]{new QFilter("issys", "=", (Object)DefaultEnum.YES.getValue()).and(new QFilter("project", "=", pro.getPkValue()))});
        DeleteServiceHelper.delete((String)"pmas_budget", (QFilter[])new QFilter[]{new QFilter("issys", "=", (Object)DefaultEnum.YES.getValue()).and(new QFilter("project", "=", pro.getPkValue()))});
        DeleteServiceHelper.delete((String)"pmas_budgetexerecord", (QFilter[])new QFilter[]{new QFilter("project", "=", pro.getPkValue())});
        DeleteServiceHelper.delete((String)"pmas_projectbudget", (QFilter[])new QFilter[]{new QFilter("project", "=", pro.getPkValue())});
        DeleteServiceHelper.delete((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{new QFilter("tproject", "=", pro.getPkValue())});
        DeleteServiceHelper.delete((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{new QFilter("yproject", "=", pro.getPkValue())});
        DeleteServiceHelper.delete((String)"pmas_prostatus", (QFilter[])new QFilter[]{new QFilter("project", "=", pro.getPkValue())});
        DeleteServiceHelper.delete((String)"pmas_nowteam", (QFilter[])new QFilter[]{new QFilter("project", "=", pro.getPkValue())});
        DeleteServiceHelper.delete((String)"pmas_projectsupervision", (QFilter[])new QFilter[]{new QFilter("project", "=", pro.getPkValue())});
        DeleteServiceHelper.delete((String)"pmfs_supervisperform", (QFilter[])new QFilter[]{new QFilter("billproject.id", "=", pro.getPkValue())});
        DeleteServiceHelper.delete((String)"pmas_purchaseplan", (QFilter[])new QFilter[]{new QFilter("project", "=", pro.getPkValue())});
    }

    public static DynamicObject getProStatus(Object proAppPk, String projectStage, String projectStatus) {
        QFilter proAppFilter = new QFilter("proapproval", "=", proAppPk);
        QFilter projectStageFilter = new QFilter("projectstage.number", "=", (Object)projectStage);
        QFilter projectStatusFilter = new QFilter("projectstatus.number", "=", (Object)projectStatus);
        return BusinessDataServiceHelper.loadSingle((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval", (QFilter[])new QFilter[]{proAppFilter, projectStageFilter, projectStatusFilter});
    }

    public static void setProStatus(DynamicObject proApp) {
        Object oldStatus;
        Object proId;
        DynamicObject project;
        Object pro = proApp.get("pro");
        boolean isReport = proApp.getBoolean("isreport");
        boolean needApproval = proApp.getBoolean("needapproval");
        DynamicObject proStatus = null;
        if (!isReport && !needApproval) {
            proStatus = BusinessDataServiceHelper.loadSingle((String)PROSTATUS_FORM_KEY, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)ProjectStatusEnum.APPROVAL_IN.getValue())});
        }
        if (pro != null && (project = BusinessDataServiceHelper.loadSingle((Object)(proId = ((DynamicObject)pro).get("id")), (String)push_target_project)) != null && project.getPkValue() != null && (oldStatus = project.get("prostatus")) == null && proStatus != null) {
            project.set("prostatus", proStatus.getPkValue());
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        DeleteServiceHelper.delete((String)"pmas_prostatus", (QFilter[])new QFilter[]{new QFilter("proapproval", "=", proApp.getPkValue())});
        StageStatusHelper.initProStatus((DynamicObject)proApp);
    }

    public static void deleteProStatus(DynamicObject proApp) {
        Object proId;
        DynamicObject project;
        Object pro = proApp.get("pro");
        if (pro != null && (project = BusinessDataServiceHelper.loadSingle((Object)(proId = ((DynamicObject)pro).get("id")), (String)push_target_project)) != null && project.getPkValue() != null) {
            project.set("prostatus", (Object)0);
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
            DeleteServiceHelper.delete((String)"pmas_prostatus", (QFilter[])new QFilter[]{new QFilter("project", "=", project.getPkValue())});
        }
        DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((Object)proApp.getPkValue(), (String)push_source_approval);
        projectApproval.set("prostatus", (Object)0);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectApproval});
        DeleteServiceHelper.delete((String)"pmas_prostatus", (QFilter[])new QFilter[]{new QFilter("proapproval", "=", proApp.getPkValue())});
    }

    public static void returnOccupyAmtAndClearRecord(DynamicObject proApp, String curOperate, String registerOp) {
        String budgetControlMode = proApp.getString(BUDGET_CONTROL_MODE);
        String billNo = proApp.getString("billno");
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
            if (StringUtils.equals((CharSequence)curOperate, (CharSequence)action_audit) || StringUtils.equals((CharSequence)curOperate, (CharSequence)OPERATION_APPROVAL_CONFIRM)) {
                return;
            }
            try {
                String msg = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\uff08\u7acb\u9879\u5ba1\u6279\uff09\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u8fd4\u8fd8\u64cd\u4f5c%3$s\uff1a", (String)"ProjectApprovalHelper_61", (String)"pmgt-pmas-business", (Object[])new Object[0]), billNo, curOperate, registerOp);
                QFilter qFilter = new QFilter("relatebillid", "=", (Object)proApp.getPkValue().toString());
                DynamicObject newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)String.join((CharSequence)",", "id", "billno"), (QFilter[])new QFilter[]{qFilter});
                BudgetCtrlHelper.returnBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)registerOp, (String)msg);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.toString());
            }
        }
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
            if (StringUtils.equals((CharSequence)curOperate, (CharSequence)"unaudit")) {
                return;
            }
            try {
                String msg = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\uff08\u7acb\u9879\u5ba1\u6279\uff09\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u8fd4\u8fd8\u64cd\u4f5c%3$s\uff1a", (String)"ProjectApprovalHelper_61", (String)"pmgt-pmas-business", (Object[])new Object[0]), billNo, curOperate, registerOp);
                QFilter qFilter = new QFilter("relatebillid", "=", (Object)proApp.getPkValue().toString());
                DynamicObject newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)String.join((CharSequence)",", "id", "billno"), (QFilter[])new QFilter[]{qFilter});
                if (newBudgetRecord != null) {
                    BudgetCtrlHelper.returnBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)registerOp, (String)msg);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.toString());
            }
        }
    }

    public static void updateBudgetRecordField(ApproveContext context, DynamicObject dataEntity, String operate) {
        QFilter qFilter = new QFilter("relatebillid", "=", (Object)dataEntity.getPkValue().toString());
        DynamicObject curBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"billno, billstatus, creator, auditor, org, auditdate, createtime, modifytime, modifier, project, relatebillid, billsource, budgetstage, totalamount, group, currency, projectapplydate, budgetcontrolmode, projectcostcontrol, isvalid, description,year", (QFilter[])new QFilter[]{qFilter});
        String budgetControlMode = dataEntity.getString(BUDGET_CONTROL_MODE);
        if (curBudgetRecord == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue())) {
            return;
        }
        if (StringUtils.equals((CharSequence)operate, (CharSequence)action_audit)) {
            curBudgetRecord.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
            curBudgetRecord.set("isvalid", (Object)Boolean.TRUE);
            curBudgetRecord.set("project", (Object)context.getSysPro());
            curBudgetRecord.set("modifytime", (Object)new Date());
            curBudgetRecord.set("auditdate", (Object)new Date());
            Date applyDate = dataEntity.getDate("projectapplydate");
            if (applyDate != null) {
                LocalDate localDate = applyDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    curBudgetRecord.set("year", (Object)sdf.parse(localDate.getYear() + "-01-01"));
                }
                catch (ParseException e) {
                    logger.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a{}", (Object)e);
                }
            }
        } else if (StringUtils.equals((CharSequence)operate, (CharSequence)"auditrefuse")) {
            curBudgetRecord.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
            curBudgetRecord.set("isvalid", (Object)Boolean.TRUE);
            curBudgetRecord.set("project", null);
            curBudgetRecord.set("modifytime", (Object)new Date());
            curBudgetRecord.set("auditdate", (Object)new Date());
            curBudgetRecord.set("description", (Object)ResManager.loadKDString((String)"\u5ba1\u6838\u4e0d\u901a\u8fc7\u3002", (String)"ProjectApprovalHelper_52", (String)"pmgt-pmas-business", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)operate, (CharSequence)"unaudit")) {
            curBudgetRecord.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
            curBudgetRecord.set("isvalid", (Object)Boolean.FALSE);
            curBudgetRecord.set("project", null);
            curBudgetRecord.set("modifytime", (Object)new Date());
            curBudgetRecord.set("auditdate", null);
        } else if (StringUtils.equals((CharSequence)operate, (CharSequence)"unsubmit")) {
            curBudgetRecord.set("billstatus", (Object)StatusEnum.TEMPSAVE.getValue());
            curBudgetRecord.set("isvalid", (Object)Boolean.FALSE);
            curBudgetRecord.set("project", null);
            curBudgetRecord.set("modifytime", (Object)new Date());
        } else if (StringUtils.equals((CharSequence)operate, (CharSequence)"submit")) {
            curBudgetRecord.set("billstatus", (Object)StatusEnum.UNCHECKED.getValue());
            curBudgetRecord.set("isvalid", (Object)Boolean.FALSE);
            curBudgetRecord.set("project", null);
            curBudgetRecord.set("modifytime", (Object)new Date());
            curBudgetRecord.set("auditdate", null);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curBudgetRecord});
    }

    public static void occupyAmount(DynamicObject proApp, String operate) {
        String budgetControlMode = proApp.getString(BUDGET_CONTROL_MODE);
        String billNo = proApp.getString("billno");
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue()) || StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
            DynamicObject newBudgetRecord;
            try {
                String msg = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\uff08\u7acb\u9879\u5ba1\u6279\uff09\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%3$s\uff1a", (String)"ProjectApprovalHelper_29", (String)"pmgt-pmas-business", (Object[])new Object[0]), billNo, operate, "submitoccupy");
                QFilter qFilter = new QFilter("relatebillid", "=", (Object)proApp.getPkValue().toString());
                newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)String.join((CharSequence)",", "id", "billno", "relatebillid"), (QFilter[])new QFilter[]{qFilter});
                if (newBudgetRecord == null) {
                    qFilter = new QFilter("billno", "=", (Object)billNo);
                    QFilter billSourceFilter = new QFilter("billsource", "=", (Object)push_source_approval);
                    newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)String.join((CharSequence)",", "id", "billno", "relatebillid"), (QFilter[])new QFilter[]{qFilter, billSourceFilter});
                }
                if (newBudgetRecord == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9884\u7b97\u8bb0\u5f55\u6570\u636e\uff0c\u65e0\u6cd5\u5360\u7528\u3002", (String)"ProjectApprovalHelper_60", (String)"pmgt-pmas-business", (Object[])new Object[0]));
                }
                newBudgetRecord.set("relatebillid", (Object)proApp.getPkValue().toString());
                BudgetCtrlHelper.requestBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"submitoccupy", (boolean)true, (String)msg);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.toString());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newBudgetRecord});
        }
    }

    public static DynamicObject proAppReport(DynamicObject proApp) {
        DynamicObject proAudit = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_proj_audit"));
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"pmas_proj_audit", (DynamicObject)proAudit, (String)String.valueOf(RequestContext.get().getOrgId()));
        Date now = new Date();
        if (null != codeRuleInfo) {
            proAudit.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)proAudit));
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat(AUDIT_BILLNO_SDF);
            proAudit.set("billno", (Object)String.join((CharSequence)"", proApp.getString("billno"), sdf.format(now)));
        }
        proAudit.set("prono", (Object)proApp);
        proAudit.set("proname", (Object)proApp.getString("billname"));
        proAudit.set("kind", (Object)proApp.getDynamicObject("kind"));
        proAudit.set("project", proApp.getPkValue());
        proAudit.set("proapp", (Object)proApp);
        proAudit.set("billname", (Object)String.format(ResManager.loadKDString((String)"%s\u7684\u5ba1\u6279\u5355", (String)"ProjectApprovalHelper_31", (String)"pmgt-pmas-business", (Object[])new Object[0]), proApp.getString("billname")));
        proAudit.set("org", (Object)proApp.getDynamicObject("reportorg"));
        proAudit.set("proorg", (Object)proApp.getDynamicObject("org"));
        proAudit.set("creator", (Object)RequestContext.get().getUserId());
        proAudit.set("modifier", (Object)RequestContext.get().getUserId());
        proAudit.set("createtime", (Object)now);
        proAudit.set("modifytime", (Object)now);
        proAudit.set("createorg", proApp.get("createorg"));
        proAudit.set("billstatus", (Object)"A");
        DynamicObjectCollection proApprovalAttachTypeEntry = proApp.getDynamicObjectCollection("attachtypeentry");
        DynamicObjectCollection proAuditAttachTypeEntry = proAudit.getDynamicObjectCollection("attachtypeentry");
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_proj_audit")).getDynamicObjectCollection("attachtypeentry").getDynamicObjectType();
        for (DynamicObject proApprovalAttachType : proApprovalAttachTypeEntry) {
            DynamicObject proAuditAttachtypeObject = new DynamicObject(dt);
            proAuditAttachtypeObject.set("attachtype", (Object)proApprovalAttachType.getDynamicObject("attachtype"));
            DynamicObjectCollection proApprovalfileEntry = proApprovalAttachType.getDynamicObjectCollection("upfile");
            DynamicObjectCollection proAuditfileEntry = proAuditAttachtypeObject.getDynamicObjectCollection("upfile");
            DynamicObjectType fileDt = proApprovalAttachType.getDynamicObjectCollection("upfile").getDynamicObjectType();
            for (DynamicObject proApprovalFile : proApprovalfileEntry) {
                DynamicObject proAuditFile = new DynamicObject(fileDt);
                proAuditFile.set("fbasedataid_id", proApprovalFile.getDynamicObject("fbasedataid").getPkValue());
                proAuditfileEntry.add((Object)proAuditFile);
            }
            proAuditAttachTypeEntry.add((Object)proAuditAttachtypeObject);
        }
        return proAudit;
    }

    public static void proAppApprovalReport(DynamicObject proApp) {
        DynamicObject proAppAudit = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_pro_app_audit"));
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"pmas_pro_app_audit", (DynamicObject)proAppAudit, (String)String.valueOf(RequestContext.get().getOrgId()));
        Date now = new Date();
        if (null != codeRuleInfo) {
            proAppAudit.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)proAppAudit));
        } else {
            SimpleDateFormat billNoSdf = new SimpleDateFormat(APP_AUDIT_BILLNO_SDF);
            proAppAudit.set("billno", (Object)String.join((CharSequence)"LXHZ", proApp.getString("billno"), billNoSdf.format(now)));
        }
        SimpleDateFormat billNameSdf = new SimpleDateFormat(APP_AUDIT_BILLNAME_SDF);
        proAppAudit.set("billname", (Object)String.format(ResManager.loadKDString((String)"%1$s\u7684\u6838\u51c6\u5ba1\u6279%2$s", (String)"ProjectApprovalHelper_36", (String)"pmgt-pmas-business", (Object[])new Object[0]), proApp.getLocaleString("billname").getLocaleValue(), billNameSdf.format(now)));
        proAppAudit.set("org", (Object)proApp.getDynamicObject("reportorg"));
        proAppAudit.set("lastreportorg", (Object)proApp.getDynamicObject("createorg"));
        proAppAudit.set("proapp", (Object)proApp);
        proAppAudit.set("creator", (Object)RequestContext.get().getCurrUserId());
        proAppAudit.set("modifier", (Object)RequestContext.get().getCurrUserId());
        proAppAudit.set("createtime", (Object)now);
        proAppAudit.set("modifytime", (Object)now);
        proAppAudit.set("billstatus", (Object)"A");
        proAppAudit.set("createorg", (Object)proApp.getDynamicObject("createorg"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proAppAudit});
        proAppAudit = BusinessDataServiceHelper.loadSingle((Object)proAppAudit.getPkValue(), (String)"pmas_pro_app_audit");
        List enabledProcessInfoList = WorkflowServiceHelper.getEnabledProcesses((DynamicObject)proAppAudit, (String)"submit");
        if (enabledProcessInfoList != null && enabledProcessInfoList.size() > 0) {
            OperationServiceHelper.executeOperate((String)"submit", (String)"pmas_pro_app_audit", (DynamicObject[])new DynamicObject[]{proAppAudit}, (OperateOption)OperateOption.create());
        }
        proApp.set("approvalstatus", (Object)ApprovalStatusEnum.ONGOING.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proApp});
    }

    public static void saveProBudgetCtrl(ApproveContext context) {
        MainEntityType totalBudgetCtrlDt = EntityMetadataCache.getDataEntityType((String)"pmas_totalbudgetctrl");
        DynamicObject totalBudgetCtrl = new DynamicObject((DynamicObjectType)totalBudgetCtrlDt);
        DynamicObject sysPro = context.getSysPro();
        DynamicObject budgetControl = ProBudgetControlHelper.getBudgetControlRatio((DynamicObject)context.getSysPro());
        DynamicObject approvePro = context.getApprovePro();
        totalBudgetCtrl.set("tproject", (Object)sysPro);
        totalBudgetCtrl.set("tcurrency", (Object)approvePro.getDynamicObject("currencyfield"));
        totalBudgetCtrl.set("proappamt", (Object)approvePro.getBigDecimal("projcetbugamt"));
        totalBudgetCtrl.set("tbudgetamt", (Object)approvePro.getBigDecimal("prooutbudgetsumamt"));
        totalBudgetCtrl.set("tsumbudamt", (Object)ProjectApprovalHelper.getBudgetAmountBysourceType(approvePro, BudgetSourceTypeEnum.OUT));
        totalBudgetCtrl.set("proapporiamt", (Object)approvePro.getBigDecimal("projcetbugamt"));
        totalBudgetCtrl.set("tbudgetoriamt", (Object)approvePro.getBigDecimal("prooutbudgetsumamt"));
        totalBudgetCtrl.set("tsumbudoriamt", (Object)ProjectApprovalHelper.getBudgetAmountBysourceType(approvePro, BudgetSourceTypeEnum.OUT));
        totalBudgetCtrl.set("tbudgettype", (Object)BudgetSourceTypeEnum.OUT.getValue());
        DynamicObject currency = totalBudgetCtrl.getDynamicObject("tcurrency");
        int amtPrecision = 10;
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
        }
        BigDecimal totalRemindRate = budgetControl != null ? budgetControl.getBigDecimal("totalremindrate") : new BigDecimal("100");
        BigDecimal totalControlRate = budgetControl != null ? budgetControl.getBigDecimal("totalcontrolrate") : new BigDecimal("100");
        totalBudgetCtrl.set("tremindrate", (Object)totalRemindRate);
        totalBudgetCtrl.set("tcontrolrate", (Object)totalControlRate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{totalBudgetCtrl});
        MainEntityType yearBudgetCtrlDt = EntityMetadataCache.getDataEntityType((String)"pmas_ybudgetctrl");
        DynamicObject yearOutBudgetCtrl = new DynamicObject((DynamicObjectType)yearBudgetCtrlDt);
        DynamicObject yearInBudgetCtrl = new DynamicObject((DynamicObjectType)yearBudgetCtrlDt);
        yearOutBudgetCtrl.set("ybudgettype", (Object)BudgetSourceTypeEnum.OUT.getValue());
        yearInBudgetCtrl.set("ybudgettype", (Object)BudgetSourceTypeEnum.IN.getValue());
        yearOutBudgetCtrl.set("yproject", (Object)sysPro);
        yearInBudgetCtrl.set("yproject", (Object)sysPro);
        yearOutBudgetCtrl.set("ycurrency", (Object)approvePro.getDynamicObject("currencyfield"));
        yearInBudgetCtrl.set("ycurrency", (Object)approvePro.getDynamicObject("currencyfield"));
        yearOutBudgetCtrl.set("yearproamt", (Object)approvePro.getBigDecimal("proyearbudgetamt"));
        yearInBudgetCtrl.set("yearproamt", (Object)approvePro.getBigDecimal("proyearbudgetamt"));
        yearOutBudgetCtrl.set("ybudgetamt", (Object)ProjectApprovalHelper.getBudgetAmountBysourceType(approvePro, BudgetSourceTypeEnum.OUT));
        yearInBudgetCtrl.set("ybudgetamt", (Object)ProjectApprovalHelper.getBudgetAmountBysourceType(approvePro, BudgetSourceTypeEnum.IN));
        yearOutBudgetCtrl.set("ybudgetoriamt", (Object)ProjectApprovalHelper.getBudgetAmountBysourceType(approvePro, BudgetSourceTypeEnum.OUT));
        yearInBudgetCtrl.set("ybudgetoriamt", (Object)ProjectApprovalHelper.getBudgetAmountBysourceType(approvePro, BudgetSourceTypeEnum.IN));
        Date applyDate = approvePro.getDate("projectapplydate");
        if (applyDate != null) {
            LocalDate localDate = applyDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                yearOutBudgetCtrl.set("yyear", (Object)sdf.parse(localDate.getYear() + "-01-01"));
                yearInBudgetCtrl.set("yyear", (Object)sdf.parse(localDate.getYear() + "-01-01"));
            }
            catch (ParseException e) {
                logger.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff1a{}", (Object)e);
            }
        }
        yearOutBudgetCtrl.set("yearprooriamt", (Object)approvePro.getBigDecimal("proyearbudgetamt"));
        yearInBudgetCtrl.set("yearprooriamt", (Object)approvePro.getBigDecimal("proyearbudgetamt"));
        DynamicObject yearCurrency = yearOutBudgetCtrl.getDynamicObject("ycurrency");
        if (yearCurrency != null) {
            amtPrecision = yearCurrency.getInt("amtprecision");
        }
        yearOutBudgetCtrl.set("yremindrate", (Object)totalRemindRate);
        yearOutBudgetCtrl.set("ycontrolrate", (Object)totalControlRate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yearOutBudgetCtrl, yearInBudgetCtrl});
    }

    public static BigDecimal getBudgetAmountBysourceType(DynamicObject approvePro, BudgetSourceTypeEnum sourceType) {
        BigDecimal inAmount;
        String proBudgetCtrl = approvePro.getString("probudgetctrl");
        BigDecimal budgetAmt = new BigDecimal(BigInteger.ZERO);
        if (BudgetSourceTypeEnum.TOTAL.equals((Object)sourceType)) {
            BigDecimal proOutBudgetSumAmt = approvePro.getBigDecimal("prooutbudgetsumamt");
            if (proOutBudgetSumAmt.compareTo(BigDecimal.ZERO) > 0) {
                budgetAmt = proOutBudgetSumAmt;
            }
        } else if (BudgetSourceTypeEnum.OUT.equals((Object)sourceType)) {
            BigDecimal outAmount = approvePro.getBigDecimal("outamount");
            if (outAmount.compareTo(BigDecimal.ZERO) > 0) {
                budgetAmt = outAmount;
            }
        } else if (BudgetSourceTypeEnum.IN.equals((Object)sourceType) && (inAmount = approvePro.getBigDecimal("inamount")).compareTo(BigDecimal.ZERO) > 0) {
            budgetAmt = inAmount;
        }
        return budgetAmt;
    }
}

