/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.budget;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.budget.ProjectBudgetValidateService;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.budget.BudgetParam;
import kd.pmgt.pmbs.common.budget.BudgetRegValue;
import kd.pmgt.pmbs.common.enums.BudgetControlTargetEnum;
import kd.pmgt.pmbs.common.enums.BudgetControlTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateBean;

public class ProjectBudgetValidateServiceImpl
implements ProjectBudgetValidateService {
    public List<BudgetValidateBean> checkOccupyBalance(BudgetParam budgetParam) {
        return this.checkBalance(budgetParam);
    }

    public List<BudgetValidateBean> checkAvailableBalance(BudgetParam budgetParam) {
        return this.checkBalance(budgetParam);
    }

    private List<BudgetValidateBean> checkBalance(BudgetParam budgetParam) {
        this.checkBudgetInfo(budgetParam);
        List<Object> validateBeanList = new ArrayList(10);
        String controlTarget = budgetParam.regBillInfo.getString("controltarget");
        BudgetControlTargetEnum controlTargetEnum = BudgetControlTargetEnum.getEnumByValue((Object)controlTarget);
        if (BudgetControlTargetEnum.BUDGETOCCUPY.getValue().equalsIgnoreCase(controlTargetEnum.getValue())) {
            validateBeanList = this.checkBudgetOccupyBalance(budgetParam);
        } else if (BudgetControlTargetEnum.BUDGETUSE.getValue().equalsIgnoreCase(controlTargetEnum.getValue())) {
            validateBeanList = this.checkBudgetUsageBalance(budgetParam);
        } else {
            List<BudgetValidateBean> budgetValidateBeans = this.checkBudgetOccupyBalance(budgetParam);
            validateBeanList.addAll(budgetValidateBeans);
            budgetValidateBeans = this.checkBudgetUsageBalance(budgetParam);
            validateBeanList.addAll(budgetValidateBeans);
        }
        return validateBeanList;
    }

    public void checkBudgetInfo(BudgetParam budgetParam) {
        List budgetRegValues = budgetParam.getBudgetRegValues();
        ArrayList<DynamicObject> notBudgetProject = new ArrayList<DynamicObject>(10);
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            int year;
            SimpleDateFormat sdf;
            QFilter filter;
            boolean isProCostControl;
            BudgetValidateBean budgetValidateBean = new BudgetValidateBean();
            budgetValidateBean.setOperation(budgetParam.getOp());
            BudgetSourceTypeEnum budgetType = budgetRegValue.getBudgetTypeValue();
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl((DynamicObject)project))) continue;
            DynamicObject budget = budgetRegValue.getBudgetValue();
            Date bizDate = budgetRegValue.getBizDateValue();
            boolean budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.valueOf(project.getPkValue().toString()));
            budgetValidateBean.setBudgetCtrl(budgetCtrl);
            if (!budgetCtrl) continue;
            ProBudgetCtrlEnums proBudgetCtrl = ProBudgetControlHelper.getProjectBudgetControlType((DynamicObject)project);
            if (budget == null) {
                filter = new QFilter("tproject", "=", project.getPkValue()).and("tbudgettype", "=", (Object)budgetType.getValue());
                DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{filter});
                if (totalBudgetCtrl == null) {
                    notBudgetProject.add(project);
                }
                if (!proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue())) continue;
                sdf = new SimpleDateFormat("yyyy");
                year = Integer.parseInt(sdf.format(bizDate));
                filter = new QFilter("yproject", "=", project.getPkValue()).and("ybudgettype", "=", (Object)budgetType.getValue()).and("YEAR(yyear)", "=", (Object)year);
                DynamicObject yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{filter});
                if (yearBudgetCtrl != null) continue;
                notBudgetProject.add(project);
                continue;
            }
            filter = new QFilter("project", "=", project.getPkValue()).and("budget", "=", budget.getPkValue()).and("budgettype", "=", (Object)budgetType.getValue());
            DynamicObject totalBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{filter});
            if (totalBudgetCtrlDetail == null) {
                notBudgetProject.add(project);
            }
            if (!proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue())) continue;
            sdf = new SimpleDateFormat("yyyy");
            year = Integer.parseInt(sdf.format(bizDate));
            filter = new QFilter("project", "=", project.getPkValue()).and("budget", "=", budget.getPkValue()).and("YEAR(year)", "=", (Object)year).and("budgettype", "=", (Object)budgetType.getValue());
            DynamicObject yearBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrldetail", (QFilter[])new QFilter[]{filter});
            if (yearBudgetCtrlDetail != null) continue;
            notBudgetProject.add(project);
        }
        if (!notBudgetProject.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject pro : notBudgetProject) {
                sb.append(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u9879\u76ee\u201c%1$s\u201d\u7684\u9884\u7b97\u63a7\u5236\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u5df2\u6b63\u786e\u7acb\u9879\u6216\u5df2\u7f16\u5236\u9884\u7b97\u3002", (String)"ProjectBudgetValidateServiceImpl_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]), pro.getLocaleString("name").getLocaleValue())).append("\n");
            }
            throw new KDBizException(sb.toString());
        }
    }

    public List<BudgetValidateBean> checkBudgetUsageBalance(BudgetParam budgetParam) {
        ArrayList<BudgetValidateBean> validateBeanList = new ArrayList<BudgetValidateBean>(10);
        List budgetRegValues = budgetParam.getBudgetRegValues();
        HashMap<String, BigDecimal> projectTotalAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> budgetTotalAmtMap = new HashMap<String, BigDecimal>(16);
        String billId = budgetParam.bill.getPkValue().toString();
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            boolean isProCostControl;
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl((DynamicObject)project))) continue;
            BigDecimal amount = budgetRegValue.getAmountValue();
            BigDecimal ptoTotalAmt = (BigDecimal)projectTotalAmtMap.get(project.getPkValue().toString());
            if (ptoTotalAmt == null) {
                ptoTotalAmt = BigDecimal.ZERO;
            }
            projectTotalAmtMap.put(project.getPkValue().toString(), ptoTotalAmt.add(amount));
            DynamicObject budget = budgetRegValue.getBudgetValue();
            if (budget == null) continue;
            BigDecimal budgetAmt = (BigDecimal)budgetTotalAmtMap.get(budget.getPkValue().toString());
            if (budgetAmt == null) {
                budgetAmt = BigDecimal.ZERO;
            }
            budgetTotalAmtMap.put(budget.getPkValue().toString(), budgetAmt.add(amount));
        }
        HashMap<String, BigDecimal> proPreUseAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> proUseAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> budPreUseAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> budUseAmtMap = new HashMap<String, BigDecimal>(16);
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            BigDecimal lastOpAmount;
            SimpleDateFormat sdf;
            BigDecimal usageAmt;
            BigDecimal preOccupyUsageAmt;
            BigDecimal controlAmt;
            BigDecimal remindAmt;
            BigDecimal controlRate;
            BigDecimal remindRate;
            QFilter filter;
            boolean isProCostControl;
            BudgetValidateBean budgetValidateBean = new BudgetValidateBean();
            budgetValidateBean.setOperation(budgetParam.getOp());
            BudgetSourceTypeEnum budgetType = budgetRegValue.getBudgetTypeValue();
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl((DynamicObject)project))) continue;
            DynamicObject budget = budgetRegValue.getBudgetValue();
            BigDecimal amount = budgetRegValue.getAmountValue();
            DynamicObject currency = budgetRegValue.getCurrencyValue();
            Date bizDate = budgetRegValue.getBizDateValue();
            boolean budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.valueOf(project.getPkValue().toString()));
            budgetValidateBean.setBudgetCtrl(budgetCtrl);
            if (!budgetCtrl) continue;
            budgetValidateBean.setProject(project);
            budgetValidateBean.setBudget(budget);
            budgetValidateBean.setBizDate(bizDate);
            budgetValidateBean.setCurrency(currency);
            budgetValidateBean.setAmount(amount);
            budgetValidateBean.setCheckBalanceType("USAGE");
            String controlTarget = budgetParam.regBillInfo.getString("controltarget");
            BudgetControlTargetEnum controlTargetEnum = BudgetControlTargetEnum.getEnumByValue((Object)controlTarget);
            budgetValidateBean.setBudgetControlTargetEnum(controlTargetEnum);
            ProBudgetCtrlEnums proBudgetCtrl = ProBudgetControlHelper.getProjectBudgetControlType((DynamicObject)project);
            int amtPrecision = 10;
            if (currency != null) {
                amtPrecision = currency.getInt("amtprecision");
            }
            if (budget == null) {
                BigDecimal proUseAmt;
                filter = new QFilter("tproject", "=", project.getPkValue()).and("tbudgettype", "=", (Object)budgetType.getValue());
                DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{filter});
                if (totalBudgetCtrl == null) continue;
                remindRate = totalBudgetCtrl.getBigDecimal("tremindrate");
                controlRate = totalBudgetCtrl.getBigDecimal("tcontrolrate");
                BigDecimal budgetAmt = totalBudgetCtrl.getBigDecimal("tbudgetamt");
                BigDecimal sumBudgetAmt = totalBudgetCtrl.getBigDecimal("tsumbudamt");
                if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue())) {
                    remindAmt = remindRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(remindRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    controlAmt = controlRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(controlRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    preOccupyUsageAmt = totalBudgetCtrl.getBigDecimal("tpreoccupyusageamt");
                    usageAmt = totalBudgetCtrl.getBigDecimal("tusageamt");
                } else if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue())) {
                    sdf = new SimpleDateFormat("yyyy");
                    int year = Integer.parseInt(sdf.format(bizDate));
                    filter = new QFilter("yproject", "=", project.getPkValue()).and("ybudgettype", "=", (Object)budgetType.getValue()).and("YEAR(yyear)", "=", (Object)year);
                    DynamicObject yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{filter});
                    if (yearBudgetCtrl == null) continue;
                    BigDecimal yearBudgetAmt = yearBudgetCtrl.getBigDecimal("ybudgetamt");
                    remindRate = yearBudgetCtrl.getBigDecimal("yremindrate");
                    controlRate = yearBudgetCtrl.getBigDecimal("ycontrolrate");
                    remindAmt = remindRate.compareTo(BigDecimal.ZERO) > 0 ? yearBudgetAmt.multiply(remindRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    controlAmt = controlRate.compareTo(BigDecimal.ZERO) > 0 ? yearBudgetAmt.multiply(controlRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    preOccupyUsageAmt = yearBudgetCtrl.getBigDecimal("ypreoccupyusageamt");
                    usageAmt = yearBudgetCtrl.getBigDecimal("yusageamt");
                } else {
                    remindAmt = remindRate.compareTo(BigDecimal.ZERO) > 0 ? sumBudgetAmt.multiply(remindRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    controlAmt = controlRate.compareTo(BigDecimal.ZERO) > 0 ? sumBudgetAmt.multiply(controlRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    preOccupyUsageAmt = totalBudgetCtrl.getBigDecimal("tpreoccupyusageamt");
                    usageAmt = totalBudgetCtrl.getBigDecimal("tusageamt");
                }
                if (budgetParam.budgetAction.equals("execProjectBudget")) {
                    lastOpAmount = this.getLastOpAmount(billId, null, project, controlTargetEnum.getValue());
                    preOccupyUsageAmt = preOccupyUsageAmt.subtract(lastOpAmount);
                }
                BigDecimal proTotalAmt = (BigDecimal)projectTotalAmtMap.get(project.getPkValue().toString());
                BigDecimal proPreUseAmt = (BigDecimal)proPreUseAmtMap.get(project.getPkValue().toString());
                if (proPreUseAmt == null) {
                    proTotalAmt = proTotalAmt.add(preOccupyUsageAmt);
                    proPreUseAmtMap.put(project.getPkValue().toString(), preOccupyUsageAmt);
                }
                if ((proUseAmt = (BigDecimal)proUseAmtMap.get(project.getPkValue().toString())) == null) {
                    proTotalAmt = proTotalAmt.add(usageAmt);
                    proUseAmtMap.put(project.getPkValue().toString(), usageAmt);
                }
                projectTotalAmtMap.put(project.getPkValue().toString(), proTotalAmt);
            } else {
                BigDecimal budUseAmt;
                filter = new QFilter("project", "=", project.getPkValue()).and("budget", "=", budget.getPkValue()).and("budgettype", "=", (Object)budgetType.getValue());
                DynamicObject totalBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{filter});
                if (totalBudgetCtrlDetail == null) continue;
                BigDecimal budgetItemAmt = totalBudgetCtrlDetail.getBigDecimal("budgetamt");
                BigDecimal budgetItemSumAmt = totalBudgetCtrlDetail.getBigDecimal("sumbudamt");
                remindRate = totalBudgetCtrlDetail.getBigDecimal("remindrate");
                controlRate = totalBudgetCtrlDetail.getBigDecimal("controlrate");
                if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue())) {
                    remindAmt = remindRate.compareTo(BigDecimal.ZERO) > 0 ? budgetItemAmt.multiply(remindRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    controlAmt = controlRate.compareTo(BigDecimal.ZERO) > 0 ? budgetItemAmt.multiply(controlRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    preOccupyUsageAmt = totalBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                    usageAmt = totalBudgetCtrlDetail.getBigDecimal("usageamt");
                } else if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue())) {
                    sdf = new SimpleDateFormat("yyyy");
                    int year = Integer.parseInt(sdf.format(bizDate));
                    filter = new QFilter("project", "=", project.getPkValue()).and("budget", "=", budget.getPkValue()).and("YEAR(year)", "=", (Object)year).and("budgettype", "=", (Object)budgetType.getValue());
                    DynamicObject yearBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrldetail", (QFilter[])new QFilter[]{filter});
                    if (yearBudgetCtrlDetail == null) continue;
                    BigDecimal budgetAmt = yearBudgetCtrlDetail.getBigDecimal("budgetamt");
                    remindRate = yearBudgetCtrlDetail.getBigDecimal("remindrate");
                    controlRate = yearBudgetCtrlDetail.getBigDecimal("controlrate");
                    remindAmt = remindRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(remindRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    controlAmt = controlRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(controlRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    preOccupyUsageAmt = yearBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                    usageAmt = yearBudgetCtrlDetail.getBigDecimal("usageamt");
                } else {
                    remindAmt = remindRate.compareTo(BigDecimal.ZERO) > 0 ? budgetItemSumAmt.multiply(remindRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    controlAmt = controlRate.compareTo(BigDecimal.ZERO) > 0 ? budgetItemSumAmt.multiply(controlRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                    preOccupyUsageAmt = totalBudgetCtrlDetail.getBigDecimal("preoccupyusageamt");
                    usageAmt = totalBudgetCtrlDetail.getBigDecimal("usageamt");
                }
                if (budgetParam.budgetAction.equals("execProjectBudget")) {
                    lastOpAmount = this.getLastOpAmount(billId, budget, project, controlTargetEnum.getValue());
                    preOccupyUsageAmt = preOccupyUsageAmt.subtract(lastOpAmount);
                }
                BigDecimal budTotalAmt = (BigDecimal)budgetTotalAmtMap.get(budget.getPkValue().toString());
                BigDecimal budPreUseAmt = (BigDecimal)budPreUseAmtMap.get(budget.getPkValue().toString());
                if (budPreUseAmt == null) {
                    budTotalAmt = budTotalAmt.add(preOccupyUsageAmt);
                    budPreUseAmtMap.put(budget.getPkValue().toString(), preOccupyUsageAmt);
                }
                if ((budUseAmt = (BigDecimal)budUseAmtMap.get(budget.getPkValue().toString())) == null) {
                    budTotalAmt = budTotalAmt.add(usageAmt);
                    budUseAmtMap.put(budget.getPkValue().toString(), usageAmt);
                }
                budgetTotalAmtMap.put(budget.getPkValue().toString(), budTotalAmt);
            }
            budgetValidateBean.setStrongControlRate(controlRate);
            budgetValidateBean.setWeakControlRate(remindRate);
            if (budget != null) {
                BigDecimal budgetTotalAmt = (BigDecimal)budgetTotalAmtMap.get(budget.getPkValue().toString());
                budgetValidateBean.setSumAmount(budgetTotalAmt);
                if (budgetTotalAmt.compareTo(controlAmt) > 0) {
                    budgetValidateBean.setStrongControl(true);
                    budgetValidateBean.setBalanceAmount(budgetTotalAmt.subtract(controlAmt));
                    budgetValidateBean.setWeakControl(false);
                } else if (budgetTotalAmt.compareTo(remindAmt) > 0) {
                    budgetValidateBean.setStrongControl(false);
                    budgetValidateBean.setBalanceAmount(budgetTotalAmt.subtract(remindAmt));
                    budgetValidateBean.setWeakControl(true);
                }
                validateBeanList.add(budgetValidateBean);
                continue;
            }
            BigDecimal projectTotalAmt = (BigDecimal)projectTotalAmtMap.get(project.getPkValue().toString());
            budgetValidateBean.setSumAmount(projectTotalAmt);
            if (projectTotalAmt.compareTo(controlAmt) > 0) {
                budgetValidateBean.setStrongControl(true);
                budgetValidateBean.setBalanceAmount(projectTotalAmt.subtract(controlAmt));
                budgetValidateBean.setWeakControl(false);
            } else if (projectTotalAmt.compareTo(remindAmt) > 0) {
                budgetValidateBean.setStrongControl(false);
                budgetValidateBean.setBalanceAmount(projectTotalAmt.subtract(remindAmt));
                budgetValidateBean.setWeakControl(true);
            }
            validateBeanList.add(budgetValidateBean);
        }
        return validateBeanList;
    }

    public List<BudgetValidateBean> checkBudgetOccupyBalance(BudgetParam budgetParam) {
        ArrayList<BudgetValidateBean> validateBeanList = new ArrayList<BudgetValidateBean>(10);
        List budgetRegValues = budgetParam.getBudgetRegValues();
        HashMap<String, BigDecimal> projectTotalAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> budgetTotalAmtMap = new HashMap<String, BigDecimal>(16);
        String billId = budgetParam.bill.getPkValue().toString();
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            boolean isProCostControl;
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl((DynamicObject)project))) continue;
            BigDecimal amount = budgetRegValue.getAmountValue();
            BigDecimal ptoTotalAmt = (BigDecimal)projectTotalAmtMap.get(project.getPkValue().toString());
            if (ptoTotalAmt == null) {
                ptoTotalAmt = BigDecimal.ZERO;
            }
            projectTotalAmtMap.put(project.getPkValue().toString(), ptoTotalAmt.add(amount));
            DynamicObject budget = budgetRegValue.getBudgetValue();
            if (budget == null) continue;
            BigDecimal budgetAmt = (BigDecimal)budgetTotalAmtMap.get(budget.getPkValue().toString());
            if (budgetAmt == null) {
                budgetAmt = BigDecimal.ZERO;
            }
            budgetTotalAmtMap.put(budget.getPkValue().toString(), budgetAmt.add(amount));
        }
        HashMap<String, BigDecimal> proPreOccupyAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> proOccupyAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> budPreOccupyAmtMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> budOccupyAmtMap = new HashMap<String, BigDecimal>(16);
        for (BudgetRegValue budgetRegValue : budgetRegValues) {
            BigDecimal lastOpAmount;
            BigDecimal occupyAmt;
            BigDecimal preOccupyAmt;
            BigDecimal controlAmt;
            BigDecimal remindAmt;
            BigDecimal controlRate;
            BigDecimal remindRate;
            QFilter filter;
            boolean isProCostControl;
            BudgetValidateBean budgetValidateBean = new BudgetValidateBean();
            budgetValidateBean.setOperation(budgetParam.getOp());
            BudgetSourceTypeEnum budgetType = budgetRegValue.getBudgetTypeValue();
            DynamicObject project = budgetRegValue.getProjectValue();
            if (project == null || !(isProCostControl = ProBudgetControlHelper.checkIsProCostControl((DynamicObject)project))) continue;
            DynamicObject budget = budgetRegValue.getBudgetValue();
            BigDecimal amount = budgetRegValue.getAmountValue();
            DynamicObject currency = budgetRegValue.getCurrencyValue();
            Date bizDate = budgetRegValue.getBizDateValue();
            boolean budgetCtrl = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.valueOf(project.getPkValue().toString()));
            budgetValidateBean.setBudgetCtrl(budgetCtrl);
            if (!budgetCtrl) continue;
            budgetValidateBean.setProject(project);
            budgetValidateBean.setBudget(budget);
            budgetValidateBean.setBizDate(bizDate);
            budgetValidateBean.setCurrency(currency);
            budgetValidateBean.setAmount(amount);
            budgetValidateBean.setCheckBalanceType("OCCUPY");
            String controlTarget = budgetParam.regBillInfo.getString("controltarget");
            BudgetControlTargetEnum controlTargetEnum = BudgetControlTargetEnum.getEnumByValue((Object)controlTarget);
            budgetValidateBean.setBudgetControlTargetEnum(controlTargetEnum);
            ProBudgetCtrlEnums proBudgetCtrl = ProBudgetControlHelper.getProjectBudgetControlType((DynamicObject)project);
            int amtPrecision = 10;
            if (currency != null) {
                amtPrecision = currency.getInt("amtprecision");
            }
            if (budget == null) {
                BigDecimal proOccupyAmt;
                filter = new QFilter("tproject", "=", project.getPkValue()).and("tbudgettype", "=", (Object)budgetType.getValue());
                DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{filter});
                if (totalBudgetCtrl == null) continue;
                remindRate = totalBudgetCtrl.getBigDecimal("tremindrate");
                controlRate = totalBudgetCtrl.getBigDecimal("tcontrolrate");
                BigDecimal budgetAmt = totalBudgetCtrl.getBigDecimal("tbudgetamt");
                if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue())) {
                    budgetAmt = totalBudgetCtrl.getBigDecimal("tsumbudamt");
                }
                remindAmt = remindRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(remindRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                controlAmt = controlRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(controlRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                preOccupyAmt = totalBudgetCtrl.getBigDecimal("tpreoccupyamt");
                occupyAmt = totalBudgetCtrl.getBigDecimal("toccupyamt");
                if (budgetParam.budgetAction.equals("execProjectBudget")) {
                    lastOpAmount = this.getLastOpAmount(billId, null, project, controlTargetEnum.getValue());
                    preOccupyAmt = preOccupyAmt.subtract(lastOpAmount);
                }
                BigDecimal proTotalAmt = (BigDecimal)projectTotalAmtMap.get(project.getPkValue().toString());
                BigDecimal proPreOccupyAmt = (BigDecimal)proPreOccupyAmtMap.get(project.getPkValue().toString());
                if (proPreOccupyAmt == null) {
                    proTotalAmt = proTotalAmt.add(preOccupyAmt);
                    proPreOccupyAmtMap.put(project.getPkValue().toString(), preOccupyAmt);
                }
                if ((proOccupyAmt = (BigDecimal)proOccupyAmtMap.get(project.getPkValue().toString())) == null) {
                    proTotalAmt = proTotalAmt.add(occupyAmt);
                    proOccupyAmtMap.put(project.getPkValue().toString(), occupyAmt);
                }
                projectTotalAmtMap.put(project.getPkValue().toString(), proTotalAmt);
            } else {
                BigDecimal budOccupyAmt;
                filter = new QFilter("project", "=", project.getPkValue()).and("budget", "=", budget.getPkValue()).and("budgettype", "=", (Object)budgetType.getValue());
                DynamicObject totalBudgetCtrlDetail = BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{filter});
                if (totalBudgetCtrlDetail == null) continue;
                BigDecimal budgetItemAmt = totalBudgetCtrlDetail.getBigDecimal("budgetamt");
                if (proBudgetCtrl.getValue().equalsIgnoreCase(ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue())) {
                    budgetItemAmt = totalBudgetCtrlDetail.getBigDecimal("sumbudamt");
                }
                remindRate = totalBudgetCtrlDetail.getBigDecimal("remindrate");
                controlRate = totalBudgetCtrlDetail.getBigDecimal("controlrate");
                remindAmt = remindRate.compareTo(BigDecimal.ZERO) > 0 ? budgetItemAmt.multiply(remindRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                controlAmt = controlRate.compareTo(BigDecimal.ZERO) > 0 ? budgetItemAmt.multiply(controlRate.divide(BigDecimal.valueOf(100L))).setScale(amtPrecision, RoundingMode.HALF_UP) : BigDecimal.ZERO;
                preOccupyAmt = totalBudgetCtrlDetail.getBigDecimal("preoccupyamt");
                occupyAmt = totalBudgetCtrlDetail.getBigDecimal("occupyamt");
                if (budgetParam.budgetAction.equals("execProjectBudget")) {
                    lastOpAmount = this.getLastOpAmount(billId, budget, project, controlTargetEnum.getValue());
                    preOccupyAmt = preOccupyAmt.subtract(lastOpAmount);
                }
                BigDecimal budgetTotalAmt = (BigDecimal)budgetTotalAmtMap.get(budget.getPkValue().toString());
                BigDecimal budPreOccupyAmt = (BigDecimal)budPreOccupyAmtMap.get(budget.getPkValue().toString());
                if (budPreOccupyAmt == null) {
                    budgetTotalAmt = budgetTotalAmt.add(preOccupyAmt);
                    budPreOccupyAmtMap.put(budget.getPkValue().toString(), preOccupyAmt);
                }
                if ((budOccupyAmt = (BigDecimal)budOccupyAmtMap.get(budget.getPkValue().toString())) == null) {
                    budgetTotalAmt = budgetTotalAmt.add(occupyAmt);
                    budOccupyAmtMap.put(budget.getPkValue().toString(), occupyAmt);
                }
                budgetTotalAmtMap.put(budget.getPkValue().toString(), budgetTotalAmt);
            }
            budgetValidateBean.setStrongControlRate(controlRate);
            budgetValidateBean.setWeakControlRate(remindRate);
            if (budget != null) {
                BigDecimal budgetTotalAmt = (BigDecimal)budgetTotalAmtMap.get(budget.getPkValue().toString());
                budgetValidateBean.setSumAmount(budgetTotalAmt);
                if (budgetTotalAmt.compareTo(controlAmt) > 0) {
                    budgetValidateBean.setStrongControl(true);
                    budgetValidateBean.setBalanceAmount(budgetTotalAmt.subtract(controlAmt));
                    budgetValidateBean.setWeakControl(false);
                } else if (budgetTotalAmt.compareTo(remindAmt) > 0) {
                    budgetValidateBean.setStrongControl(false);
                    budgetValidateBean.setBalanceAmount(budgetTotalAmt.subtract(remindAmt));
                    budgetValidateBean.setWeakControl(true);
                }
                validateBeanList.add(budgetValidateBean);
                continue;
            }
            BigDecimal projectTotalAmt = (BigDecimal)projectTotalAmtMap.get(project.getPkValue().toString());
            budgetValidateBean.setSumAmount(projectTotalAmt);
            if (projectTotalAmt.compareTo(controlAmt) > 0) {
                budgetValidateBean.setStrongControl(true);
                budgetValidateBean.setBalanceAmount(projectTotalAmt.subtract(controlAmt));
                budgetValidateBean.setWeakControl(false);
            } else if (projectTotalAmt.compareTo(remindAmt) > 0) {
                budgetValidateBean.setStrongControl(false);
                budgetValidateBean.setBalanceAmount(projectTotalAmt.subtract(remindAmt));
                budgetValidateBean.setWeakControl(true);
            }
            validateBeanList.add(budgetValidateBean);
        }
        return validateBeanList;
    }

    private BigDecimal getLastOpAmount(String billId, DynamicObject budget, DynamicObject project, String controlTarget) {
        DynamicObject[] records;
        BigDecimal amount = BigDecimal.ZERO;
        QFilter filter = new QFilter("billid", "=", (Object)billId).and("iseffect", "=", (Object)true).and("opaction", "=", (Object)BillFieldTypeEnum.TAKE_OPERATION.getNumber());
        if (budget != null) {
            filter.and("probudget", "=", (Object)Long.parseLong(budget.getPkValue().toString()));
        }
        if (project != null) {
            filter.and("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
        }
        if (BudgetControlTargetEnum.BUDGETOCCUPYANDUSE.getValue().equalsIgnoreCase(controlTarget)) {
            filter.and("controltype", "=", (Object)BudgetControlTypeEnum.TAKEOPERATION.getValue());
        }
        if ((records = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)"amount", (QFilter[])new QFilter[]{filter})).length > 0) {
            amount = Arrays.stream(records).map(o -> o.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        return amount;
    }
}

