/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.dataupdate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.business.dataupdate.ContractApplyPaymentDataUpdateService;
import kd.pmgt.pmbs.business.dataupdate.ContractIncomeItemDataUpdateService;
import kd.pmgt.pmbs.business.dataupdate.ContractPayItemDataUpdateService;
import kd.pmgt.pmbs.business.dataupdate.ContractSupplierDataUpdateService;
import kd.pmgt.pmbs.business.dataupdate.ContractTypeDataUpdateService;
import kd.pmgt.pmbs.business.dataupdate.FunSourceDataUpdateService;
import kd.pmgt.pmbs.business.dataupdate.ProBudgetUpdateService;
import kd.pmgt.pmbs.business.dataupdate.ProjectExecStatusDataUpdateService;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.SupervisionDatasourceEnum;
import kd.pmgt.pmbs.common.enums.SupervisionIdentTypeEnum;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.TimeUtils;
import org.apache.commons.lang3.StringUtils;

public class DataUpdateHelper {
    private static final Log logger = LogFactory.getLog(DataUpdateHelper.class);
    protected static final String[] pmfsFormIds = new String[]{"pmfs_projectinitialize", "pmfs_progressreport", "pmfs_supplierident", "pmfs_investregister", "pmfs_projectprocessdoc", "pmfs_risktrack", "pmfs_supervisionfinish", "pmfs_exprojectaccept", "pmfs_projectaccept", "pmfs_projectreport", "pmfs_selfresearch"};
    protected static final String[] pmasFormIds = new String[]{"pmas_approval_apply", "pmas_pro_app_audit", "pmas_team", "pmas_addtmemberbill", "pmas_projfundsource", "pmas_projectobjective", "pmas_projectprogramme", "pmas_proj_audit", "pmas_pro_approvaladjust", "pmas_projectsupervision"};
    protected static final String[] pmcoFormIds = new String[]{"pmco_contractcost", "pmco_outbudgetadjust", "pmco_procostsplit", "pmas_budget"};
    protected static final String[] pmscFormIds = new String[]{"pmsc_projectexecstatus", "pmsc_accounts_audit", "pmsc_pro_comp_acc", "pmsc_projectevaluation", "pmsc_projecthandover"};
    protected static final String[] pmctFormIds = new String[]{"pmct_incontract_settle", "pmct_inclarificbill", "pmct_incontractrevision", "pmct_outclaimbill", "pmct_monthlyfundplan", "pmct_paymentapply", "pmct_incomeregister", "pmct_paymentregister", "pmct_outinvoice", "pmct_ininvoice", "pmct_inperformrecords", "pmct_infinalsettle", "pmct_incontract", "pmct_inaddagreement", "pmct_strategicagreement", "pmct_incomeapply", "pmct_applymentpay", "pmct_contractrevision", "pmct_statuschange"};
    protected static final String[] pmimFormIds = new String[]{"pmim_projectproposal", "pmim_investplanclaim", "pmim_specialapproval", "pmim_tacticinvestplan", "pmim_budgetbase", "pmim_aunualinvestplan"};
    protected static final String[] pmptFormIds = new String[]{"pmpt_masterplan", "pmpt_deptplan", "pmpt_personplan", "pmpt_assigntask", "pmpt_prooperationreport"};
    protected static final String[] extTableFormIds = new String[]{"pmct_incontract_settle", "pmct_ininvoice", "pmct_incontract", "pmim_projectproposal", "pmpt_assigntask"};

    public static void updateStagestatus(IFormView view) {
        QFilter filter4;
        DynamicObject[] projectApprovalUns;
        QFilter filter3;
        DynamicObject[] projectApprovals;
        QFilter filter2;
        QFilter filter1 = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] projects = BusinessDataServiceHelper.load((String)"bd_project", (String)"id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf,parent,createorg,org,useorg,ctrlstrategy,group,planbegindate,planenddate,prostatus,proaddress", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("prostatus", "=", (Object)ProjectStatusEnum.APPROVAL_SUCC.getId())});
        if (projects.length > 0) {
            DynamicObject proStage = BusinessDataServiceHelper.loadSingle((Object)ProjectStageEnum.PROPOSALSTAGE_S.getId(), (String)"pmbs_projectstage");
            for (DynamicObject project : projects) {
                QFilter filter42;
                QFilter filter32 = new QFilter("project", "=", project.getPkValue());
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"pmas_prostatus", (String)"project, projectstage, projectstatus, remarks, stagename, proapproval", (QFilter[])new QFilter[]{filter32, filter42 = new QFilter("projectstage", "=", (Object)ProjectStageEnum.PROPOSALSTAGE_S.getId())});
                if (load.length < 1) {
                    DynamicObject prosta = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_prostatus"));
                    prosta.set("project", project.getPkValue());
                    prosta.set("projectstage", proStage.getPkValue());
                    prosta.set("stagename", (Object)proStage.getString("name"));
                    prosta.set("projectstatus", (Object)ProjectStatusEnum.APPROVAL_SUCC.getId());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{prosta});
                }
                project.set("prostatus", (Object)ProjectStatusEnum.APPROVAL_IN.getId());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
            }
        }
        if ((projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id,pro,prostatus", (QFilter[])new QFilter[]{filter3 = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue())})).length > 0) {
            for (DynamicObject approval : projectApprovals) {
                DynamicObject appProject = approval.getDynamicObject("pro");
                if (appProject == null || appProject.get("prostatus") == null) continue;
                approval.set("prostatus", appProject.get("prostatus"));
            }
            SaveServiceHelper.save((DynamicObject[])projectApprovals);
        }
        if ((projectApprovalUns = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id,pro,prostatus", (QFilter[])new QFilter[]{filter4 = new QFilter("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue())})).length > 0) {
            for (DynamicObject approval : projectApprovals) {
                approval.set("prostatus", (Object)ProjectStatusEnum.APPROVAL_IN.getId());
            }
            SaveServiceHelper.save((DynamicObject[])projectApprovalUns);
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"DataUpdateHelper_0", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
    }

    public static void updateProkindctrl(IFormView view) {
        QFilter qFilter = new QFilter("id", "!=", (Object)Long.parseLong("0"));
        DynamicObject[] projectKinds = BusinessDataServiceHelper.load((String)"bd_projectkind", (String)"id", (QFilter[])new QFilter[]{qFilter});
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmbs_prokindctrlsetting");
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>();
        for (DynamicObject projectKind : projectKinds) {
            QFilter filter = new QFilter("projectkind", "=", projectKind.getPkValue());
            DynamicObject[] projectKindCtls = BusinessDataServiceHelper.load((String)"pmbs_prokindctrlsetting", (String)"id", (QFilter[])new QFilter[]{filter});
            if (null != projectKindCtls && projectKindCtls.length >= 1) continue;
            DynamicObject[] prostages = BusinessDataServiceHelper.load((String)"pmbs_projectstage", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"PROPOSALSTAGE_S")});
            DynamicObject[] budgetstages = BusinessDataServiceHelper.load((String)"pmbs_budgetstage", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"Preinstall_4")});
            if (prostages == null || prostages.length <= 0 || null == budgetstages || budgetstages.length <= 0) continue;
            DynamicObject prostage = prostages[0];
            DynamicObject budgetstage = budgetstages[0];
            DynamicObject setting = new DynamicObject((DynamicObjectType)dt);
            setting.set("enable", (Object)Boolean.TRUE);
            setting.set("ismajortype", (Object)Boolean.TRUE);
            setting.set("projectkind", (Object)projectKind);
            DynamicObjectCollection projextStageEntity = setting.getDynamicObjectCollection("projectstageentry");
            DynamicObject proentry = new DynamicObject(projextStageEntity.getDynamicObjectType());
            proentry.set("projectstage", prostage.getPkValue());
            projextStageEntity.add((Object)proentry);
            DynamicObjectCollection budgetStageEntity = setting.getDynamicObjectCollection("budgetstageentry");
            DynamicObject budgetentry = new DynamicObject(budgetStageEntity.getDynamicObjectType());
            budgetentry.set("budgetstage", budgetstage.getPkValue());
            budgetStageEntity.add((Object)budgetentry);
            bills.add(setting);
        }
        SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[bills.size()]));
        view.showSuccessNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5206\u7c7b\u7ba1\u63a7\u8bbe\u7f6e\u5347\u7ea7\u6210\u529f\u3002", (String)"DataUpdateHelper_1", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
    }

    public static void updateProadjust(IFormView view) {
        DataUpdateHelper.showChooseTimeView("projectadjust", ResManager.loadKDString((String)"\u8c03\u5242\u6a21\u5f0f\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5230\u591a\u7ec4\u7ec7\u7ed3\u6784\u3002", (String)"DataUpdateHelper_2", (String)"pmgt-pmbs-business", (Object[])new Object[0]), view);
    }

    public static void updateExecstatusdata(IFormView view) {
        DataUpdateHelper.showChooseTimeView("updateexecstatusdata", ResManager.loadKDString((String)"\u9879\u76ee\u5173\u95ed\u5355\u6570\u636e\u5347\u7ea7\u5230\u591a\u7ec4\u7ec7\u7ed3\u6784\u3002", (String)"DataUpdateHelper_3", (String)"pmgt-pmbs-business", (Object[])new Object[0]), view);
    }

    public static void updateData(IFormView view) {
        String type = (String)view.getFormShowParameter().getCustomParam("type");
        Date date = (Date)view.getModel().getValue("datetime");
        if ("projectadjust".equals(type)) {
            DataUpdateHelper.updateProjectApproval(date);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"updateexecstatusdata")) {
            new ProjectExecStatusDataUpdateService().updateByDate(date);
        }
    }

    public static void updateFinishrecord(IFormView view) {
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter dataSourceFilter = new QFilter("datasource", "=", (Object)SupervisionDatasourceEnum.SYSTEM.getValue());
        QFilter identFilter = new QFilter("identificationtype", "=", (Object)SupervisionIdentTypeEnum.AUDIT.getValue());
        QFilter actualEndTimeFilter = new QFilter("actualendtime", "is null", null);
        DynamicObject[] finishRecords = BusinessDataServiceHelper.load((String)"pmfs_supervisionfinish", (String)"billno, actualendtime, bizbillid, sysbill", (QFilter[])new QFilter[]{statusFilter, dataSourceFilter, identFilter, actualEndTimeFilter});
        StringBuilder sb = new StringBuilder();
        ArrayList<DynamicObject> outBuidgetList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> inBuidgetList = new ArrayList<DynamicObject>(10);
        for (DynamicObject finishRecord : finishRecords) {
            DynamicObject sysBillObj = finishRecord.getDynamicObject("sysbill");
            String billId = finishRecord.getString("bizbillid");
            DynamicObject sysBill = sysBillObj.getDynamicObject("sysbill");
            String formBillId = sysBill.getString("number");
            if (StringUtils.isEmpty((CharSequence)billId)) {
                sb.append(String.format("data repair failure.spvfinishrecord billno:%s bizbillid is empty.", finishRecord.getString("billno")));
                continue;
            }
            QFilter idFilter = new QFilter("id", "=", (Object)billId);
            DynamicObject bizBill = BusinessDataServiceHelper.loadSingle((String)formBillId, (String)"billno, auditdate", (QFilter[])new QFilter[]{idFilter, statusFilter});
            if (bizBill == null) continue;
            Date auditdate = bizBill.getDate("auditdate");
            if (auditdate == null) {
                DynamicObject proApp;
                QFilter proFilter;
                DynamicObject project;
                boolean isSys;
                if (StringUtils.equals((CharSequence)formBillId, (CharSequence)"pmas_outbudget")) {
                    bizBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)formBillId);
                    isSys = bizBill.getBoolean("issys");
                    if (!isSys) continue;
                    project = bizBill.getDynamicObject("project");
                    proFilter = new QFilter("pro", "=", project.getPkValue());
                    proApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"auditor, auditdate", (QFilter[])new QFilter[]{proFilter});
                    bizBill.set("auditor", proApp.get("auditor"));
                    bizBill.set("auditdate", proApp.get("auditdate"));
                    outBuidgetList.add(bizBill);
                    finishRecord.set("actualendtime", proApp.get("auditdate"));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)formBillId, (CharSequence)"pmas_inbudget") || !(isSys = (bizBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)formBillId)).getBoolean("issys"))) continue;
                project = bizBill.getDynamicObject("project");
                proFilter = new QFilter("pro", "=", project.getPkValue());
                proApp = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"auditor, auditdate", (QFilter[])new QFilter[]{proFilter});
                bizBill.set("auditor", proApp.get("auditor"));
                bizBill.set("auditdate", proApp.get("auditdate"));
                inBuidgetList.add(bizBill);
                finishRecord.set("actualendtime", proApp.get("auditdate"));
                continue;
            }
            finishRecord.set("actualendtime", (Object)auditdate);
        }
        String tipStr = sb.toString();
        SaveServiceHelper.update((DynamicObject[])outBuidgetList.toArray(new DynamicObject[outBuidgetList.size()]));
        SaveServiceHelper.update((DynamicObject[])inBuidgetList.toArray(new DynamicObject[inBuidgetList.size()]));
        SaveServiceHelper.update((DynamicObject[])finishRecords);
        if (StringUtils.isNotEmpty((CharSequence)tipStr)) {
            logger.error(tipStr);
            view.showTipNotification(tipStr);
        } else {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u9879\u76ee\u7763\u5bfc\u6570\u636e\u4fee\u590d\u5b8c\u6210\u3002", (String)"DataUpdateHelper_4", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
    }

    public static void updateContractsupplier(IFormView view) {
        new ContractSupplierDataUpdateService().doRepairContractSupplier();
    }

    public static void updateContractincomeitem(IFormView view) {
        try (TXHandle h = TX.required();){
            try {
                new ContractIncomeItemDataUpdateService().doRepairContractIncomeItem();
            }
            catch (Exception e) {
                logger.info("\u5408\u540c\u6536\u6b3e\u6761\u76ee\u5347\u7ea7\u5931\u8d25\u3002\u539f\u56e0: {}", (Object)e.getMessage());
                h.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u6536\u6b3e\u6761\u76ee\u5347\u7ea7\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u8bbe\u7f6e\u3002", (String)"DataUpdateHelper_5", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
            }
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5408\u540c\u6536\u6b3e\u6761\u76ee\u5347\u7ea7\u5b8c\u6210\u3002", (String)"DataUpdateHelper_6", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
    }

    public static void updateContractpayitem(IFormView view) {
        new ContractPayItemDataUpdateService().doRepairContractPayItem();
    }

    public static void updateContapplypayment(IFormView view) {
        new ContractApplyPaymentDataUpdateService().doRepairContApplyPayment();
    }

    public static void updateContracttypedataupdate(IFormView view) {
        try (TXHandle h = TX.required();){
            try {
                new ContractTypeDataUpdateService().doContractTypeDataUpdate();
            }
            catch (Exception e) {
                logger.info("\u5408\u540c\u5c5e\u6027\u5347\u7ea7\u5931\u8d25\u3002\u539f\u56e0: {}", (Object)e.getMessage());
                h.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u5c5e\u6027\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataUpdateHelper_7", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
            }
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5408\u540c\u5c5e\u6027\u5347\u7ea7\u5b8c\u6210\u3002", (String)"DataUpdateHelper_8", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
    }

    public static void updateFunsourcedataupdate(IFormView view) {
        try (TXHandle h = TX.required();){
            try {
                new FunSourceDataUpdateService().doRepairFunSourceData();
            }
            catch (Exception e) {
                logger.info("\u8d44\u91d1\u6765\u6e90\u5347\u7ea7\u5931\u8d25\u3002\u539f\u56e0: {}", (Object)e.getMessage());
                h.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u91d1\u6765\u6e90\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataUpdateHelper_9", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
            }
            view.showSuccessNotification(ResManager.loadKDString((String)"\u8d44\u91d1\u6765\u6e90\u5347\u7ea7\u5b8c\u6210\u3002", (String)"DataUpdateHelper_10", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
    }

    public static void updateProbudgetupdate(IFormView view) {
        try (TXHandle h = TX.required();){
            try {
                new ProBudgetUpdateService().doProBudgetUpdateData();
            }
            catch (Exception e) {
                logger.info("\u9879\u76ee\u9884\u7b97\u9879\u5347\u7ea7\u5931\u8d25\u3002\u539f\u56e0: {}", (Object)e.getMessage());
                h.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\u9879\u76ee\u9884\u7b97\u9879\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataUpdateHelper_11", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
            }
            view.showSuccessNotification(ResManager.loadKDString((String)"\u9879\u76ee\u9884\u7b97\u9879\u5347\u7ea7\u5b8c\u6210\u3002", (String)"DataUpdateHelper_12", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
    }

    public static void updateProbudgetupdatetree(IFormView view) {
        try (TXHandle h = TX.required();){
            try {
                new ProBudgetUpdateService().doProBudgetUpdateTree();
            }
            catch (Exception e) {
                logger.info("\u9879\u76ee\u9884\u7b97\u9879\u5347\u7ea7\u5931\u8d25\u3002\u539f\u56e0: {}", (Object)e.getMessage());
                h.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\u9879\u76ee\u9884\u7b97\u9879\u5347\u7ea7\u5931\u8d25\u3002", (String)"DataUpdateHelper_11", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
            }
            view.showSuccessNotification(ResManager.loadKDString((String)"\u9879\u76ee\u9884\u7b97\u9879\u5347\u7ea7\u5b8c\u6210\u3002", (String)"DataUpdateHelper_12", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
        }
    }

    public static void updateProbudgetcostamtrepair(IFormView view) {
        String selectSql = "select fid from t_pmas_bugetperformentry where fentryid != 0;";
        DataSet dataSet = DB.queryDataSet((String)"DataUpdateFormPlugin.doProBudgetCostAmtRepair", (DBRoute)DBRoute.of((String)"cr"), (String)selectSql);
        ArrayList<Object> idList = new ArrayList<Object>();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Object billId = row.get(0);
            if (billId == null || Long.parseLong(String.valueOf(billId)) == 0L) continue;
            idList.add(billId);
        }
        QFilter idFilter = new QFilter("id", "in", idList);
        QFilter sourcetypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        QFilter parentFilter = new QFilter("parent", "!=", (Object)0);
        QFilter procostamtFilter = new QFilter("procostamt", "!=", (Object)0);
        DynamicObject[] leafBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudgetperform", (String)"id,parent,procostamt", (QFilter[])new QFilter[]{idFilter, sourcetypeFilter, parentFilter, procostamtFilter});
        Set leafBudgetIdSet = Arrays.stream(leafBudgets).map(o -> o.getLong("id")).collect(Collectors.toSet());
        Set parentIdSet = Arrays.stream(leafBudgets).filter(o -> o.getLong("parent") != 0L).map(o -> o.getLong("parent")).collect(Collectors.toSet());
        DynamicObject[] parentBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudgetperform", (String)"id,parent,procostamt", (QFilter[])new QFilter[]{new QFilter("id", "in", parentIdSet)});
        HashSet totalBudgetIdSet = new HashSet(leafBudgets.length);
        totalBudgetIdSet.addAll(leafBudgetIdSet);
        totalBudgetIdSet.addAll(parentIdSet);
        while (parentBudgets.length != 0) {
            parentIdSet = Arrays.stream(parentBudgets).filter(o -> o.getLong("parent") != 0L).map(o -> o.getLong("parent")).collect(Collectors.toSet());
            parentBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudgetperform", (String)"id,parent,procostamt", (QFilter[])new QFilter[]{new QFilter("id", "in", parentIdSet)});
            totalBudgetIdSet.addAll(parentIdSet);
        }
        DynamicObject[] totalBudgets = BusinessDataServiceHelper.load((String)"pmas_projectbudgetperform", (String)"id,parent,procostamt", (QFilter[])new QFilter[]{new QFilter("id", "in", totalBudgetIdSet)});
        Map<Object, DynamicObject> topParentBudgetMap = Arrays.stream(totalBudgets).filter(o -> o.getLong("parent") == 0L).collect(Collectors.toMap(o -> o.getPkValue(), o -> o));
        Map<Long, List<DynamicObject>> sonBudgetMap = Arrays.stream(totalBudgets).filter(o -> o.getLong("parent") != 0L).collect(Collectors.groupingBy(obj -> obj.getLong("parent")));
        ArrayList<DynamicObject> updateParentBudgetList = new ArrayList<DynamicObject>();
        for (DynamicObject topParentBudget : topParentBudgetMap.values()) {
            DataUpdateHelper.repairsSonBudgetCostAmt(topParentBudget, sonBudgetMap, updateParentBudgetList);
        }
        SaveServiceHelper.update((DynamicObject[])updateParentBudgetList.toArray(new DynamicObject[updateParentBudgetList.size()]));
        view.showSuccessNotification(ResManager.loadKDString((String)"\u9879\u76ee\u9884\u7b97\u9879\u7236\u7ea7\u6570\u636e\u6210\u672c\u91d1\u989d\u6570\u636e\u4fee\u590d\u5b8c\u6210\u3002", (String)"DataUpdateHelper_13", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
    }

    public static void updateOutbudgetproyearamtupdate(IFormView view) {
        QFilter qFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
        qFilter.and("totalyearamt", "=", (Object)BigDecimal.ZERO);
        qFilter.or("totalyearamt", "is null", null);
        DynamicObject[] outBudgetBills = BusinessDataServiceHelper.load((String)"pmas_budget", (String)String.join((CharSequence)",", "project", "year", "totalyearamt"), (QFilter[])new QFilter[]{qFilter});
        if (outBudgetBills.length > 0) {
            ArrayList<DynamicObject> updateBudgetList = new ArrayList<DynamicObject>();
            for (DynamicObject outBudgetBill : outBudgetBills) {
                DynamicObject project = outBudgetBill.getDynamicObject("project");
                Date budgetYear = outBudgetBill.getDate("year");
                if (project == null || budgetYear == null) continue;
                outBudgetBill.set("totalyearamt", (Object)DataUpdateHelper.getProYearAmt(budgetYear, Long.parseLong(project.getPkValue().toString())));
                updateBudgetList.add(outBudgetBill);
            }
            SaveServiceHelper.update((DynamicObject[])updateBudgetList.toArray(new DynamicObject[updateBudgetList.size()]));
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u5e74\u5ea6\u652f\u51fa\u9884\u7b97\u5355\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u5347\u7ea7\u5b8c\u6210\u3002", (String)"DataUpdateHelper_14", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
    }

    public static void updateAccountorgupdate(IFormView view) {
        DataUpdateHelper.doAccountOrgUpdate(view);
    }

    public static void updateCreateorgupdate(IFormView view) {
        DataUpdateHelper.doCreateOrgUpdate(view);
    }

    public static void updateRepairinvoiceimage(IFormView view) {
        DataUpdateHelper.doRepairInvoiceImage(view);
    }

    private static void showChooseTimeView(String type, String caption, IFormView view) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", "pmbs_choosetime");
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("type", (Object)type);
        parameter.setCaption(caption);
        view.showForm(parameter);
    }

    private static void updateProjectApproval(Date date) {
        DynamicObject[] objs;
        QFilter typeFilter = new QFilter("budgetcontrolmode", "=", (Object)BudgetCtlModeEnum.CONTROLANDADJUST.getValue());
        QFilter timeFilter = new QFilter("createtime", "<", (Object)date);
        QFilter budgetFilter = new QFilter("budgetproname", "!=", (Object)"");
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_pro_approval");
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"", (QFilter[])new QFilter[]{typeFilter, timeFilter, budgetFilter})) {
            int controlInfoSize;
            obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (DynamicObjectType)dt);
            obj.set("splittype", (Object)SplitTypeEnum.TOTALAMTSPLIT.getValue());
            DynamicObjectCollection controlInfoEntryCol = obj.getDynamicObjectCollection("controlinfoentry");
            controlInfoEntryCol.clear();
            DynamicObjectType controlinfoentryDt = new DynamicObject((DynamicObjectType)dt).getDynamicObjectCollection("controlinfoentry").getDynamicObjectType();
            DynamicObject controlinfoEntry = new DynamicObject(controlinfoentryDt);
            controlinfoEntry.set("undertakeorg", (Object)obj.getDynamicObject("org"));
            controlinfoEntry.set("undertakeperiod", (Object)obj.getDate("budgetperiod"));
            controlinfoEntry.set("entryproname", (Object)obj.getString("budgetproname"));
            controlinfoEntry.set("entrypronumber", (Object)obj.getString("budgetpronumber"));
            controlinfoEntry.set("entryproid", (Object)obj.getLong("budgetpro"));
            controlinfoEntry.set("undertakeamt", (Object)obj.getBigDecimal("outamount"));
            controlinfoEntry.set("undertakeratio", (Object)new BigDecimal(100));
            controlInfoEntryCol.add((Object)controlinfoEntry);
            DynamicObjectCollection budgetEntryCol = obj.getDynamicObjectCollection("budgetout");
            DynamicObjectCollection realbudgetentryCol = obj.getDynamicObjectCollection("realbudgetentry");
            realbudgetentryCol.clear();
            ArrayList<DynamicObject> parentBudgetEntryList = new ArrayList<DynamicObject>(10);
            for (DynamicObject budgetEntry : budgetEntryCol) {
                long pid = budgetEntry.getLong("pid");
                if (pid != 0L) continue;
                parentBudgetEntryList.add(budgetEntry);
            }
            int parentBudgetEntrySize = parentBudgetEntryList.size();
            int totalRowSize = parentBudgetEntrySize * (controlInfoSize = controlInfoEntryCol.size());
            if (totalRowSize <= 0) continue;
            DynamicObject currency = obj.getDynamicObject("currencyfield");
            int amtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
            for (DynamicObject parentBudgetEntry : parentBudgetEntryList) {
                BigDecimal bdOutAmount = parentBudgetEntry.getBigDecimal("bdoutamount");
                for (DynamicObject controlInfo : controlInfoEntryCol) {
                    DynamicObject budgetitem = parentBudgetEntry.getDynamicObject("outitem");
                    DynamicObject undertakeOrg = controlInfo.getDynamicObject("undertakeorg");
                    Date undertakePeriod = controlInfo.getDate("undertakeperiod");
                    long entryproid = controlInfo.getLong("entryproid");
                    BigDecimal realUndertakeAmt = bdOutAmount.multiply(controlInfo.getBigDecimal("undertakeratio")).divide(new BigDecimal(100), amtPrecision, RoundingMode.HALF_UP);
                    if (DataUpdateHelper.checkIsRepeat(realbudgetentryCol, controlInfo, budgetitem, realUndertakeAmt)) continue;
                    DynamicObjectType realbudgetentryDt = new DynamicObject((DynamicObjectType)dt).getDynamicObjectCollection("realbudgetentry").getDynamicObjectType();
                    DynamicObject realbudgetentry = new DynamicObject(realbudgetentryDt);
                    realbudgetentry.set("realbudgetitem", (Object)budgetitem);
                    realbudgetentry.set("realundertakeorg", (Object)undertakeOrg);
                    realbudgetentry.set("realundertakeperiod", (Object)undertakePeriod);
                    realbudgetentry.set("realproname", (Object)controlInfo.getString("entryproname"));
                    realbudgetentry.set("realpronumber", (Object)controlInfo.getString("entrypronumber"));
                    realbudgetentry.set("realproid", (Object)entryproid);
                    realbudgetentry.set("realundertakeAmt", (Object)realUndertakeAmt);
                    realbudgetentryCol.add((Object)realbudgetentry);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            DataUpdateHelper.updateOutBudget(obj);
        }
    }

    private static void updateOutBudget(DynamicObject obj) {
        DynamicObject pro = obj.getDynamicObject("pro");
        if (pro == null) {
            return;
        }
        DynamicObject[] outBudgets = BusinessDataServiceHelper.load((String)"pmas_outbudget", (String)"", (QFilter[])new QFilter[]{new QFilter("project", "=", pro.getPkValue())});
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmas_outbudget");
        for (DynamicObject outBudget : outBudgets) {
            int controlInfoSize;
            outBudget = BusinessDataServiceHelper.loadSingle((Object)outBudget.getPkValue(), (DynamicObjectType)dt);
            DynamicObjectCollection controlInfoEntryCol = outBudget.getDynamicObjectCollection("controlinfoentry");
            controlInfoEntryCol.clear();
            DynamicObjectType controlinfoentryDt = new DynamicObject((DynamicObjectType)dt).getDynamicObjectCollection("controlinfoentry").getDynamicObjectType();
            DynamicObject controlinfoEntry = new DynamicObject(controlinfoentryDt);
            controlinfoEntry.set("undertakeorg", (Object)outBudget.getDynamicObject("org"));
            controlinfoEntry.set("undertakeperiod", (Object)outBudget.getDate("budgetperiod"));
            controlinfoEntry.set("entryproname", (Object)outBudget.getString("budgetproname"));
            controlinfoEntry.set("entrypronumber", (Object)outBudget.getString("budgetpronumber"));
            controlinfoEntry.set("entryproid", (Object)outBudget.getString("budgetpro"));
            controlinfoEntry.set("beforeamt", (Object)outBudget.getBigDecimal("prevamount"));
            if (outBudget.getBigDecimal("prevamount").compareTo(BigDecimal.ZERO) != 0) {
                controlinfoEntry.set("beforeratio", (Object)new BigDecimal(100));
            }
            controlinfoEntry.set("currentamt", (Object)outBudget.getBigDecimal("totalamount"));
            controlinfoEntry.set("currentratio", (Object)new BigDecimal(100));
            controlinfoEntry.set("differenceamt", (Object)outBudget.getBigDecimal("vchangeamount"));
            controlInfoEntryCol.add((Object)controlinfoEntry);
            DynamicObjectCollection budgetEntryCol = outBudget.getDynamicObjectCollection("treeentryentity");
            DynamicObjectCollection realbudgetentryCol = outBudget.getDynamicObjectCollection("realbudgetentry");
            realbudgetentryCol.clear();
            ArrayList<DynamicObject> parentBudgetEntryList = new ArrayList<DynamicObject>(10);
            for (DynamicObject budgetEntry : budgetEntryCol) {
                long pid = budgetEntry.getLong("pid");
                if (pid != 0L) continue;
                parentBudgetEntryList.add(budgetEntry);
            }
            int parentBudgetEntrySize = parentBudgetEntryList.size();
            int totalRowSize = parentBudgetEntrySize * (controlInfoSize = controlInfoEntryCol.size());
            if (totalRowSize <= 0) continue;
            DynamicObject currency = outBudget.getDynamicObject("currency");
            int amtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
            for (DynamicObject parentBudgetEntry : parentBudgetEntryList) {
                BigDecimal viamount = parentBudgetEntry.getBigDecimal("viamount");
                BigDecimal bdOutAmount = parentBudgetEntry.getBigDecimal("budgetamount");
                for (DynamicObject controlInfo : controlInfoEntryCol) {
                    BigDecimal realdifferenceamt;
                    BigDecimal realUndertakeAmt;
                    DynamicObject budgetitem = parentBudgetEntry.getDynamicObject("budgetitem");
                    DynamicObject undertakeOrg = controlInfo.getDynamicObject("undertakeorg");
                    Date undertakePeriod = controlInfo.getDate("undertakeperiod");
                    long entryproid = controlInfo.getLong("entryproid");
                    BigDecimal realbeforeamt = viamount.multiply(controlInfo.getBigDecimal("beforeratio")).divide(new BigDecimal(100), amtPrecision, RoundingMode.HALF_UP);
                    if (DataUpdateHelper.checkIsRepeat(realbudgetentryCol, controlInfo, budgetitem, realbeforeamt, realUndertakeAmt = bdOutAmount.multiply(controlInfo.getBigDecimal("currentratio")).divide(new BigDecimal(100), amtPrecision, RoundingMode.HALF_UP), realdifferenceamt = realUndertakeAmt.subtract(realbeforeamt))) continue;
                    DynamicObjectType realbudgetentryDt = new DynamicObject((DynamicObjectType)dt).getDynamicObjectCollection("realbudgetentry").getDynamicObjectType();
                    DynamicObject realbudgetentry = new DynamicObject(realbudgetentryDt);
                    realbudgetentry.set("realbudgetitem", (Object)budgetitem);
                    realbudgetentry.set("realundertakeorg", (Object)undertakeOrg);
                    realbudgetentry.set("realundertakeperiod", (Object)undertakePeriod);
                    realbudgetentry.set("realproname", (Object)controlInfo.getString("entryproname"));
                    realbudgetentry.set("realpronumber", (Object)controlInfo.getString("entrypronumber"));
                    realbudgetentry.set("realproid", (Object)entryproid);
                    realbudgetentry.set("realbeforeamt", (Object)realbeforeamt);
                    realbudgetentry.set("realundertakeAmt", (Object)realUndertakeAmt);
                    realbudgetentry.set("realdifferenceamt", (Object)realdifferenceamt);
                    realbudgetentryCol.add((Object)realbudgetentry);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{outBudget});
        }
    }

    private static boolean checkIsRepeat(DynamicObjectCollection realbudgetentry, DynamicObject controlInfo, DynamicObject budgetitem, BigDecimal realUndertakeAmt) {
        boolean isContinue = false;
        for (DynamicObject obj : realbudgetentry) {
            Integer realundertakeorgPK;
            Object budgetitemPK = budgetitem == null ? Integer.valueOf(0) : budgetitem.getPkValue();
            Integer undertakeOrgPK = controlInfo.getDynamicObject("undertakeorg") == null ? Integer.valueOf(0) : controlInfo.getDynamicObject("undertakeorg").getPkValue();
            Date ndertakePeriod = controlInfo.getDate("undertakeperiod");
            long entryproid = controlInfo.getLong("entryproid");
            Integer realbudgetitemPK = obj.getDynamicObject("realbudgetitem") == null ? Integer.valueOf(0) : obj.getDynamicObject("realbudgetitem").getPkValue();
            Integer n = realundertakeorgPK = obj.getDynamicObject("realundertakeorg") == null ? Integer.valueOf(0) : obj.getDynamicObject("realundertakeorg").getPkValue();
            if (budgetitemPK != realbudgetitemPK || undertakeOrgPK != realundertakeorgPK || !TimeUtils.isSameMonth((Date)ndertakePeriod, (Date)obj.getDate("realundertakeperiod")) || entryproid != obj.getLong("realproid")) continue;
            obj.set("realundertakeamt", (Object)((BigDecimal)obj.get("realundertakeamt")).add(realUndertakeAmt));
            isContinue = true;
        }
        return isContinue;
    }

    private static boolean checkIsRepeat(DynamicObjectCollection realbudgetentry, DynamicObject controlInfo, DynamicObject budgetitem, BigDecimal realbeforeamt, BigDecimal realundertakeamt, BigDecimal realdifferenceamt) {
        boolean isContinue = false;
        for (DynamicObject obj : realbudgetentry) {
            Integer realundertakeorgPK;
            Object budgetitemPK = budgetitem == null ? Integer.valueOf(0) : budgetitem.getPkValue();
            Integer undertakeOrgPK = controlInfo.getDynamicObject("undertakeorg") == null ? Integer.valueOf(0) : controlInfo.getDynamicObject("undertakeorg").getPkValue();
            Date ndertakePeriod = controlInfo.getDate("undertakeperiod");
            long entryproid = controlInfo.getLong("entryproid");
            Integer realbudgetitemPK = obj.getDynamicObject("realbudgetitem") == null ? Integer.valueOf(0) : obj.getDynamicObject("realbudgetitem").getPkValue();
            Integer n = realundertakeorgPK = obj.getDynamicObject("realundertakeorg") == null ? Integer.valueOf(0) : obj.getDynamicObject("realundertakeorg").getPkValue();
            if (budgetitemPK != realbudgetitemPK || undertakeOrgPK != realundertakeorgPK || !TimeUtils.isSameMonth((Date)ndertakePeriod, (Date)obj.getDate("realundertakeperiod")) || entryproid != obj.getLong("realproid")) continue;
            obj.set("realbeforeamt", (Object)((BigDecimal)obj.get("realbeforeamt")).add(realbeforeamt));
            obj.set("realundertakeamt", (Object)((BigDecimal)obj.get("realundertakeamt")).add(realundertakeamt));
            obj.set("realdifferenceamt", (Object)((BigDecimal)obj.get("realdifferenceamt")).add(realdifferenceamt));
            isContinue = true;
        }
        return isContinue;
    }

    private static void doRepairInvoiceImage(IFormView view) {
        String algoKey = "DataUpdateFormPlugin.doRepairInvoiceImage";
        String selectSql = "select fid,fentryid,fimageurl from t_pmct_invoicepicture";
        DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)selectSql);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Object[] param = new Object[2];
            String imageUrl = row.getString(2);
            if (StringUtils.isBlank((CharSequence)imageUrl)) {
                Long invoiceId = row.getLong(0);
                if (QueryServiceHelper.exists((String)"pmct_ininvoice", (Object)invoiceId)) {
                    DynamicObject invoice = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)"pmct_ininvoice");
                    String serialNo = invoice.getString("serialno");
                    if (StringUtils.isBlank((CharSequence)serialNo)) continue;
                    ArrayList<String> invoices = new ArrayList<String>(1);
                    invoices.add(serialNo);
                    Map invoiceMap = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"query", (Object[])new Object[]{invoices});
                    if (invoiceMap != null) {
                        JSONArray invoiceData = (JSONArray)invoiceMap.get("data");
                        JSONObject invoiceInfo = invoiceData.getJSONObject(0);
                        param[0] = invoiceInfo.getString("snapshotUrl");
                    }
                }
            } else {
                param[0] = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(imageUrl);
            }
            param[1] = row.getLong(1);
            paramList.add(param);
        }
        if (paramList.size() > 0) {
            String sql = "update t_pmct_invoicepicture set fimageurl  = ? where fentryid = ?;";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)sql, paramList);
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u7968\u5f71\u50cf\u6587\u4ef6\u4fee\u590d\u6210\u529f\u3002", (String)"DataUpdateHelper_15", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
    }

    private static void doAccountOrgUpdate(IFormView view) {
        String algoKey = "DataUpdateFormPlugin.doAccountOrgUpdate";
        String selectSql = "select fid,fprojectid,forgid from t_pmct_in_invoice where fid not in (select fid from t_pmct_in_invoice_a)";
        DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"cr"), (String)selectSql);
        ArrayList<SqlParameter[]> paramList = new ArrayList<SqlParameter[]>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long fid = row.getLong(0);
            Long projectId = row.getLong(1);
            Long orgId = row.getLong(2);
            SqlParameter[] param = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)fid), new SqlParameter(":faccountorg", -5, (Object)DataUpdateHelper.getAccountOrg(projectId, orgId))};
            paramList.add(param);
        }
        if (paramList.size() > 0) {
            String insertSql = "insert into t_pmct_in_invoice_a (fid,faccountorg) values (?,?);";
            DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)insertSql, paramList);
        }
        ArrayList<DynamicObject> paymentApplies = new ArrayList<DynamicObject>(16);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_paymentapply");
        QFilter qFilter = new QFilter("accountorg", "=", (Object)0L);
        DynamicObjectCollection paymentApplyCol = QueryServiceHelper.query((String)"pmct_paymentapply", (String)String.join((CharSequence)",", "id", "org", "project", "accountorg"), (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject col : paymentApplyCol) {
            DynamicObject paymentApply = new DynamicObject((DynamicObjectType)dt);
            paymentApply.set("id", (Object)col.getLong("id"));
            long accountOrg = 0L;
            if (col.getLong("project") != 0L) {
                accountOrg = DataUpdateHelper.getAccountOrgByProject(col.getLong("project"));
            }
            if (accountOrg == 0L) {
                accountOrg = DataUpdateHelper.getAccountOrgByOrg(col.getLong("org"));
            }
            paymentApply.set("accountorg", (Object)accountOrg);
            paymentApplies.add(paymentApply);
        }
        if (paymentApplies.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])paymentApplies.toArray(new DynamicObject[0]));
        }
        ArrayList<DynamicObject> incomeApplies = new ArrayList<DynamicObject>(16);
        MainEntityType dtIncome = EntityMetadataCache.getDataEntityType((String)"pmct_incomeapply");
        QFilter orgNullQFilter = new QFilter("accountorg", "=", null).or("accountorg", "=", (Object)0L);
        DynamicObjectCollection incomeApplyCol = QueryServiceHelper.query((String)"pmct_incomeapply", (String)String.join((CharSequence)",", "id", "org", "project", "accountorg"), (QFilter[])new QFilter[]{orgNullQFilter});
        for (DynamicObject col : incomeApplyCol) {
            DynamicObject incomeApply = new DynamicObject((DynamicObjectType)dtIncome);
            incomeApply.set("id", (Object)col.getLong("id"));
            long accountOrg = 0L;
            if (col.getLong("project") != 0L) {
                accountOrg = DataUpdateHelper.getAccountOrgByProject(col.getLong("project"));
            }
            if (accountOrg == 0L) {
                accountOrg = DataUpdateHelper.getAccountOrgByOrg(col.getLong("org"));
            }
            incomeApply.set("accountorg", (Object)accountOrg);
            incomeApplies.add(incomeApply);
        }
        if (incomeApplies.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])incomeApplies.toArray(new DynamicObject[0]));
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u5347\u7ea7\u6210\u529f\u3002", (String)"DataUpdateHelper_16", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
    }

    private static long getAccountOrg(Long pro, Long org) {
        long accountOrg = 0L;
        if (pro != 0L) {
            accountOrg = DataUpdateHelper.getAccountOrgByProject(pro);
        }
        if (accountOrg == 0L) {
            accountOrg = DataUpdateHelper.getAccountOrgByOrg(org);
        }
        if (accountOrg == 0L) {
            accountOrg = org;
        }
        return accountOrg;
    }

    private static long getAccountOrgByOrg(long orgId) {
        long accountOrg = 0L;
        Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (mapOrg != null && !mapOrg.isEmpty() && mapOrg.get("id") != null) {
            accountOrg = Long.parseLong(mapOrg.get("id").toString());
        }
        return accountOrg;
    }

    private static long getAccountOrgByProject(long projectId) {
        QFilter approvalFilter = new QFilter("pro", "=", (Object)projectId);
        approvalFilter.and(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        DynamicObject[] projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"accountorg", (QFilter[])new QFilter[]{approvalFilter});
        if (projectApprovals != null && projectApprovals.length > 0) {
            DynamicObject accountOrg = projectApprovals[0].getDynamicObject("accountorg");
            return accountOrg == null ? 0L : accountOrg.getLong("id");
        }
        return 0L;
    }

    protected static void doCreateOrgUpdate(IFormView view) {
        ArrayList<String> allFromIds = new ArrayList<String>();
        allFromIds.addAll(Arrays.asList(pmfsFormIds));
        allFromIds.addAll(Arrays.asList(pmasFormIds));
        allFromIds.addAll(Arrays.asList(pmcoFormIds));
        allFromIds.addAll(Arrays.asList(pmscFormIds));
        allFromIds.addAll(Arrays.asList(pmctFormIds));
        allFromIds.addAll(Arrays.asList(pmimFormIds));
        allFromIds.addAll(Arrays.asList(pmptFormIds));
        StringBuilder message = new StringBuilder();
        for (String formId : allFromIds) {
            QFilter qFilter;
            DynamicObjectCollection objects = QueryServiceHelper.query((String)formId, (String)"id,creator", (QFilter[])new QFilter[]{qFilter = new QFilter("createorg", "=", (Object)0).or("createorg", "is null", (Object)0)});
            if (objects.size() == 0) continue;
            List creators = objects.stream().map(obj -> obj.getLong("creator")).collect(Collectors.toList());
            List userMainOrgId = UserServiceHelper.getUserMainOrgId(creators);
            HashMap allMap = new HashMap();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            for (Map map : userMainOrgId) {
                allMap.putAll(map);
            }
            for (Map.Entry entry : allMap.entrySet()) {
                if (entry.getValue() == null) continue;
                Object[] param = new Object[]{entry.getValue(), entry.getKey()};
                paramsList.add(param);
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)formId);
            List<String> list = Arrays.asList(extTableFormIds);
            boolean isError = false;
            try {
                if (paramsList.size() > 0) {
                    String sql = list.contains(formId) ? DataUpdateHelper.extTableSql(formId) : String.format("update %s set fcreateorgid  = ? where fcreatorid = ? and ( fcreateorgid = 0 or fcreateorgid is null )", mainType.getAlias());
                    int[] result = DB.executeBatch((DBRoute)DBRoute.of((String)"cr"), (String)sql, paramsList);
                    if (result.length > 0) {
                        message.append(String.format(ResManager.loadKDString((String)"\u2018%1$s\u2019\u7684\u521b\u5efa\u7ec4\u7ec7\u5347\u7ea7\u6210\u529f\u6761\u6570\uff1a%2$s\u3002", (String)"DataUpdateHelper_17", (String)"pmgt-pmbs-business", (Object[])new Object[0]), mainType.getDisplayName().getLocaleValue(), result.length));
                        message.append("\n");
                    }
                } else {
                    isError = true;
                }
            }
            catch (Exception e) {
                isError = true;
                view.showErrMessage(String.format("%s:error", mainType.getDisplayName().getLocaleValue()), e.getMessage());
            }
            if (!isError) continue;
            message.append(String.format(ResManager.loadKDString((String)"\u2018%s\u2019\u7684\u521b\u5efa\u7ec4\u7ec7\u5347\u7ea7\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u6709\u6570\u636e\u9700\u8981\u66f4\u65b0\u3002", (String)"DataUpdateHelper_18", (String)"pmgt-pmbs-business", (Object[])new Object[0]), mainType.getDisplayName().getLocaleValue()));
            message.append("\n");
        }
        view.showMessage(message.toString());
    }

    private static String extTableSql(String formId) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)formId);
        String extTableName = String.join((CharSequence)"_", mainType.getAlias(), ((IDataEntityProperty)mainType.getAllFields().get("createorg")).getTableGroup());
        return String.format("update %s set fcreateorgid = ? where fid in (select t.fid from %s t where t.fcreatorid = ? ) ", extTableName, mainType.getAlias());
    }

    private static BigDecimal repairsSonBudgetCostAmt(DynamicObject parentBudget, Map<Long, List<DynamicObject>> sonBudgetMap, List<DynamicObject> updateParentBudgetList) {
        Object pkValue = parentBudget.getPkValue();
        if (sonBudgetMap.containsKey(pkValue)) {
            List<DynamicObject> sonBudgetList = sonBudgetMap.get(pkValue);
            BigDecimal sonTotalCostAmt = BigDecimal.ZERO;
            for (DynamicObject sonBudget : sonBudgetList) {
                BigDecimal costAmt = DataUpdateHelper.repairsSonBudgetCostAmt(sonBudget, sonBudgetMap, updateParentBudgetList);
                sonTotalCostAmt = sonTotalCostAmt.add(costAmt);
            }
            if (sonTotalCostAmt.compareTo(parentBudget.getBigDecimal("procostamt")) != 0) {
                parentBudget.set("procostamt", (Object)sonTotalCostAmt);
                updateParentBudgetList.add(parentBudget);
            }
            return sonTotalCostAmt;
        }
        return parentBudget.getBigDecimal("procostamt");
    }

    private static BigDecimal getProYearAmt(Date budgetYear, Long projectId) {
        DynamicObject bill;
        DynamicObjectCollection invEntry;
        BigDecimal proYearAmt = BigDecimal.ZERO;
        int organizationYear = budgetYear.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
        QFilter qFilter = new QFilter("YEAR(year)", "=", (Object)organizationYear);
        qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("inventry.projectno", "=", (Object)projectId);
        qFilter.and("inventry.inventry_approvalcon", "=", (Object)"pass");
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmim_aunualinvestplan", (String)String.join((CharSequence)",", "docuimenttype", "inventry", "projectno", "inventry_approveamt"), (QFilter[])new QFilter[]{qFilter}, (String)" auditdate desc", (int)1);
        if (bills.length > 0 && (invEntry = (bill = bills[0]).getDynamicObjectCollection("inventry")).size() > 0) {
            DynamicObject rowEntry = null;
            for (DynamicObject entry : invEntry) {
                String projectNoPk;
                if (entry.getDynamicObject("projectno") == null || Long.parseLong(projectNoPk = entry.getDynamicObject("projectno").getPkValue().toString()) != projectId) continue;
                rowEntry = entry;
                break;
            }
            if (rowEntry != null) {
                proYearAmt = rowEntry.getBigDecimal("inventry_approveamt");
            }
        }
        if (proYearAmt.compareTo(BigDecimal.ZERO) == 0) {
            qFilter = new QFilter("pro", "=", (Object)projectId);
            DynamicObject approval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "proyearbudgetamt", "projectapplydate", "createtime"), (QFilter[])new QFilter[]{qFilter});
            if (approval != null) {
                int applyYear;
                Date applyDate = approval.getDate("projectapplydate");
                if (applyDate == null) {
                    applyDate = approval.getDate("createtime");
                }
                if ((applyYear = applyDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear()) == organizationYear) {
                    proYearAmt = approval.getBigDecimal("proyearbudgetamt");
                }
            }
        }
        return proYearAmt;
    }

    public static void repairInContractReceivedAmt(IFormView view) {
        DynamicObject[] contracts;
        String select = String.join((CharSequence)",", "pushed", "entryentity", "entrycontract", "receiptoftaxamount", "receiptamount");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] registers = BusinessDataServiceHelper.load((String)"pmct_incomeregister", (String)select, (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> contractIdSet = new HashSet<Long>();
        HashMap<Long, BigDecimal> registerReceiveOfTaxAmtMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> registerReceiveAmtMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject register : registers) {
            Map sourceBills;
            Object sourcePks;
            int isPush = register.getBoolean("pushed");
            if (isPush != 0 && ((HashSet)(sourcePks = (sourceBills = BFTrackerServiceHelper.findSourceBills((String)"pmct_incomeregister", (Long[])new Long[]{(Long)register.getPkValue()})).getOrDefault("pmct_incomeapply", new HashSet()))).isEmpty()) continue;
            DynamicObjectCollection entryEntity = register.getDynamicObjectCollection("entryentity");
            sourcePks = entryEntity.iterator();
            while (sourcePks.hasNext()) {
                DynamicObject entry = (DynamicObject)sourcePks.next();
                DynamicObject contract = entry.getDynamicObject("entrycontract");
                if (contract == null) continue;
                BigDecimal receiveOfTaxAmt = entry.getBigDecimal("receiptoftaxamount");
                BigDecimal receiveAmt = entry.getBigDecimal("receiptamount");
                long contractId = Long.parseLong(contract.getPkValue().toString());
                BigDecimal sumReceiveOfTaxAmt = (BigDecimal)registerReceiveOfTaxAmtMap.get(contractId);
                if (sumReceiveOfTaxAmt == null) {
                    sumReceiveOfTaxAmt = BigDecimal.ZERO;
                }
                sumReceiveOfTaxAmt = sumReceiveOfTaxAmt.add(receiveOfTaxAmt);
                registerReceiveOfTaxAmtMap.put(contractId, sumReceiveOfTaxAmt);
                BigDecimal sumReceiveAmt = (BigDecimal)registerReceiveAmtMap.get(contractId);
                if (sumReceiveAmt == null) {
                    sumReceiveAmt = BigDecimal.ZERO;
                }
                sumReceiveAmt = sumReceiveAmt.add(receiveAmt);
                registerReceiveAmtMap.put(contractId, sumReceiveAmt);
                contractIdSet.add(contractId);
            }
        }
        if (contractIdSet.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> repairContracts = new ArrayList<DynamicObject>();
        for (DynamicObject contract : contracts = BusinessDataServiceHelper.load((Object[])contractIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract"))) {
            BigDecimal totalRealOfTaxAmount;
            long contractId = Long.parseLong(contract.getPkValue().toString());
            BigDecimal sumReceiveOfTaxAmt = (BigDecimal)registerReceiveOfTaxAmtMap.get(contractId);
            if (sumReceiveOfTaxAmt == null || sumReceiveOfTaxAmt.compareTo(totalRealOfTaxAmount = NumberHelper.toBigDecimal((Object)contract.getBigDecimal("totalrealoftaxamount"))) == 0) continue;
            repairContracts.add(contract);
        }
        if (repairContracts.size() == 0) {
            return;
        }
        String ids = repairContracts.stream().map(o -> o.getPkValue().toString()).collect(Collectors.joining(","));
        DBRoute dbRoute = new DBRoute("cr");
        Calendar calendar = Calendar.getInstance();
        String time = String.valueOf(calendar.get(1)) + (calendar.get(2) + 1) + calendar.get(5) + calendar.get(11) + calendar.get(12) + calendar.get(13);
        String sql = "/*dialect*/create table t_con_inregister_back_" + time + " as select * from t_pmct_contract_s where fid in (" + ids + ")";
        DB.execute((DBRoute)dbRoute, (String)sql, null);
        for (DynamicObject contract : repairContracts) {
            BigDecimal sumReceiveAmt;
            long contractId = Long.parseLong(contract.getPkValue().toString());
            BigDecimal sumReceiveOfTaxAmt = (BigDecimal)registerReceiveOfTaxAmtMap.get(contractId);
            if (sumReceiveOfTaxAmt != null) {
                contract.set("totalrealoftaxamount", (Object)sumReceiveOfTaxAmt);
            }
            if ((sumReceiveAmt = (BigDecimal)registerReceiveAmtMap.get(contractId)) == null) continue;
            contract.set("totalrealamount", (Object)sumReceiveAmt);
        }
        SaveServiceHelper.update((DynamicObject[])repairContracts.toArray(new DynamicObject[0]));
        view.showSuccessNotification(ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c\u7d2f\u8ba1\u5b9e\u6536\u91d1\u989d\u4fee\u590d\u6210\u529f\u3002", (String)"DataUpdateHelper_19", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
    }

    public static void repairOutContractPayAmt(IFormView view) {
        DynamicObject[] contracts;
        String select = String.join((CharSequence)",", "pushed", "entryentity", "entrycontract", "thispaymentoftaxamount", "thispaymentamount");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] registers = BusinessDataServiceHelper.load((String)"pmct_paymentregister", (String)select, (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> contractIdSet = new HashSet<Long>();
        HashMap<Long, BigDecimal> paymentOfTaxAmtMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> paymentAmtMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject register : registers) {
            Map sourceBills;
            Object sourcePks;
            int isPush = register.getBoolean("pushed");
            if (isPush != 0 && ((HashSet)(sourcePks = (sourceBills = BFTrackerServiceHelper.findSourceBills((String)"pmct_paymentregister", (Long[])new Long[]{(Long)register.getPkValue()})).getOrDefault("pmct_paymentapply", new HashSet()))).isEmpty()) continue;
            DynamicObjectCollection entryEntity = register.getDynamicObjectCollection("entryentity");
            sourcePks = entryEntity.iterator();
            while (sourcePks.hasNext()) {
                DynamicObject entry = (DynamicObject)sourcePks.next();
                DynamicObject contract = entry.getDynamicObject("entrycontract");
                if (contract == null) continue;
                BigDecimal paymentOfTaxAmt = entry.getBigDecimal("thispaymentoftaxamount");
                BigDecimal paymentAmt = entry.getBigDecimal("thispaymentamount");
                long contractId = Long.parseLong(contract.getPkValue().toString());
                BigDecimal sumPaymentOfTaxAmt = (BigDecimal)paymentOfTaxAmtMap.get(contractId);
                if (sumPaymentOfTaxAmt == null) {
                    sumPaymentOfTaxAmt = BigDecimal.ZERO;
                }
                sumPaymentOfTaxAmt = sumPaymentOfTaxAmt.add(paymentOfTaxAmt);
                paymentOfTaxAmtMap.put(contractId, sumPaymentOfTaxAmt);
                BigDecimal sumPaymentAmt = (BigDecimal)paymentAmtMap.get(contractId);
                if (sumPaymentAmt == null) {
                    sumPaymentAmt = BigDecimal.ZERO;
                }
                sumPaymentAmt = sumPaymentAmt.add(paymentAmt);
                paymentAmtMap.put(contractId, sumPaymentAmt);
                contractIdSet.add(contractId);
            }
        }
        if (contractIdSet.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> repairContracts = new ArrayList<DynamicObject>();
        for (DynamicObject contract : contracts = BusinessDataServiceHelper.load((Object[])contractIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"))) {
            BigDecimal totalRealOfTaxAmount;
            long contractId = Long.parseLong(contract.getPkValue().toString());
            BigDecimal sumReceiveOfTaxAmt = (BigDecimal)paymentOfTaxAmtMap.get(contractId);
            if (sumReceiveOfTaxAmt == null || sumReceiveOfTaxAmt.compareTo(totalRealOfTaxAmount = NumberHelper.toBigDecimal((Object)contract.getBigDecimal("totalrealoftaxamount"))) == 0) continue;
            repairContracts.add(contract);
        }
        String ids = repairContracts.stream().map(o -> o.getPkValue().toString()).collect(Collectors.joining(","));
        DBRoute dbRoute = new DBRoute("cr");
        Calendar calendar = Calendar.getInstance();
        String time = String.valueOf(calendar.get(1)) + (calendar.get(2) + 1) + calendar.get(5) + calendar.get(11) + calendar.get(12) + calendar.get(13);
        String sql = "/*dialect*/create table t_con_payregister_back_" + time + " as select * from t_pmct_contract_s where fid in (" + ids + ")";
        DB.execute((DBRoute)dbRoute, (String)sql, null);
        for (DynamicObject contract : repairContracts) {
            BigDecimal sumPaymentAmt;
            long contractId = Long.parseLong(contract.getPkValue().toString());
            BigDecimal sumPaymentOfTaxAmt = (BigDecimal)paymentOfTaxAmtMap.get(contractId);
            if (sumPaymentOfTaxAmt != null) {
                contract.set("totalrealoftaxamount", (Object)sumPaymentOfTaxAmt);
            }
            if ((sumPaymentAmt = (BigDecimal)paymentAmtMap.get(contractId)) == null) continue;
            contract.set("totalrealamount", (Object)sumPaymentAmt);
        }
        SaveServiceHelper.update((DynamicObject[])repairContracts.toArray(new DynamicObject[0]));
        view.showSuccessNotification(ResManager.loadKDString((String)"\u652f\u51fa\u5408\u540c\u7d2f\u8ba1\u5b9e\u4ed8\u91d1\u989d\u4fee\u590d\u6210\u529f\u3002", (String)"DataUpdateHelper_20", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
    }

    public static void repairInContractSettleAmt(IFormView view) {
        DynamicObject[] contracts;
        String select = String.join((CharSequence)",", "contract", "settleamount", "settleoftaxamount");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("paydirection", "=", (Object)PayDirectionEnum.IN.getValue());
        DynamicObject[] settlements = BusinessDataServiceHelper.load((String)"pmct_incontract_settle", (String)select, (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> contractIdSet = new HashSet<Long>();
        HashMap<Long, BigDecimal> settleOfTaxAmtMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> settleAmtMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject settlement : settlements) {
            DynamicObject contract = settlement.getDynamicObject("contract");
            if (contract == null) continue;
            long contractId = Long.parseLong(contract.getPkValue().toString());
            BigDecimal settleAmt = settlement.getBigDecimal("settleamount");
            BigDecimal settleOfTaxAmt = settlement.getBigDecimal("settleoftaxamount");
            BigDecimal sumSettleOfTaxAmt = (BigDecimal)settleOfTaxAmtMap.get(contractId);
            if (sumSettleOfTaxAmt == null) {
                sumSettleOfTaxAmt = BigDecimal.ZERO;
            }
            sumSettleOfTaxAmt = sumSettleOfTaxAmt.add(settleOfTaxAmt);
            settleOfTaxAmtMap.put(contractId, sumSettleOfTaxAmt);
            BigDecimal sumSettleAmt = (BigDecimal)settleAmtMap.get(contractId);
            if (sumSettleAmt == null) {
                sumSettleAmt = BigDecimal.ZERO;
            }
            sumSettleAmt = sumSettleAmt.add(settleAmt);
            settleAmtMap.put(contractId, sumSettleAmt);
            contractIdSet.add(contractId);
        }
        if (contractIdSet.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> repairContracts = new ArrayList<DynamicObject>();
        for (DynamicObject contract : contracts = BusinessDataServiceHelper.load((Object[])contractIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract"))) {
            BigDecimal totalSetOfTaxAmt;
            long contractId = Long.parseLong(contract.getPkValue().toString());
            BigDecimal sumSettleOfTaxAmt = (BigDecimal)settleOfTaxAmtMap.get(contractId);
            if (sumSettleOfTaxAmt == null || sumSettleOfTaxAmt.compareTo(totalSetOfTaxAmt = contract.getBigDecimal("totalsettleoftaxamount")) == 0) continue;
            repairContracts.add(contract);
        }
        String ids = repairContracts.stream().map(o -> o.getPkValue().toString()).collect(Collectors.joining(","));
        DBRoute dbRoute = new DBRoute("cr");
        Calendar calendar = Calendar.getInstance();
        String time = String.valueOf(calendar.get(1)) + (calendar.get(2) + 1) + calendar.get(5) + calendar.get(11) + calendar.get(12) + calendar.get(13);
        String sql = "/*dialect*/create table t_con_insettle_back_" + time + " as select * from t_pmct_contract_s where fid in (" + ids + ")";
        DB.execute((DBRoute)dbRoute, (String)sql, null);
        for (DynamicObject contract : repairContracts) {
            BigDecimal sumSettleAmt;
            long contractId = Long.parseLong(contract.getPkValue().toString());
            BigDecimal sumSettleOfTaxAmt = (BigDecimal)settleOfTaxAmtMap.get(contractId);
            if (sumSettleOfTaxAmt != null) {
                contract.set("totalsettleoftaxamount", (Object)sumSettleOfTaxAmt);
            }
            if ((sumSettleAmt = (BigDecimal)settleAmtMap.get(contractId)) == null) continue;
            contract.set("totalsettleamount", (Object)sumSettleAmt);
        }
        SaveServiceHelper.update((DynamicObject[])repairContracts.toArray(new DynamicObject[0]));
        view.showSuccessNotification(ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u4fee\u590d\u6210\u529f\u3002", (String)"DataUpdateHelper_21", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
    }

    public static void repairOutContractSettleAmt(IFormView view) {
        DynamicObject[] contracts;
        String select = String.join((CharSequence)",", "contract", "settleamount", "settleoftaxamount");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("paydirection", "=", (Object)PayDirectionEnum.OUT.getValue());
        DynamicObject[] settlements = BusinessDataServiceHelper.load((String)"pmct_outcontract_settle", (String)select, (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> contractIdSet = new HashSet<Long>();
        HashMap<Long, BigDecimal> settleOfTaxAmtMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> settleAmtMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject settlement : settlements) {
            DynamicObject contract = settlement.getDynamicObject("contract");
            if (contract == null) continue;
            long contractId = Long.parseLong(contract.getPkValue().toString());
            BigDecimal settleAmt = settlement.getBigDecimal("settleamount");
            BigDecimal settleOfTaxAmt = settlement.getBigDecimal("settleoftaxamount");
            BigDecimal sumSettleOfTaxAmt = (BigDecimal)settleOfTaxAmtMap.get(contractId);
            if (sumSettleOfTaxAmt == null) {
                sumSettleOfTaxAmt = BigDecimal.ZERO;
            }
            sumSettleOfTaxAmt = sumSettleOfTaxAmt.add(settleOfTaxAmt);
            settleOfTaxAmtMap.put(contractId, sumSettleOfTaxAmt);
            BigDecimal sumSettleAmt = (BigDecimal)settleAmtMap.get(contractId);
            if (sumSettleAmt == null) {
                sumSettleAmt = BigDecimal.ZERO;
            }
            sumSettleAmt = sumSettleAmt.add(settleAmt);
            settleAmtMap.put(contractId, sumSettleAmt);
            contractIdSet.add(contractId);
        }
        if (contractIdSet.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> repairContracts = new ArrayList<DynamicObject>();
        for (DynamicObject contract : contracts = BusinessDataServiceHelper.load((Object[])contractIdSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_outcontract"))) {
            BigDecimal totalSetOfTaxAmt;
            long contractId = Long.parseLong(contract.getPkValue().toString());
            BigDecimal sumSettleOfTaxAmt = (BigDecimal)settleOfTaxAmtMap.get(contractId);
            if (sumSettleOfTaxAmt == null || sumSettleOfTaxAmt.compareTo(totalSetOfTaxAmt = contract.getBigDecimal("totalsettleoftaxamount")) == 0) continue;
            repairContracts.add(contract);
        }
        String ids = repairContracts.stream().map(o -> o.getPkValue().toString()).collect(Collectors.joining(","));
        DBRoute dbRoute = new DBRoute("cr");
        Calendar calendar = Calendar.getInstance();
        String time = String.valueOf(calendar.get(1)) + (calendar.get(2) + 1) + calendar.get(5) + calendar.get(11) + calendar.get(12) + calendar.get(13);
        String sql = "/*dialect*/create table t_con_outsettle_back_" + time + " as select * from t_pmct_contract_s where fid in (" + ids + ")";
        DB.execute((DBRoute)dbRoute, (String)sql, null);
        for (DynamicObject contract : repairContracts) {
            BigDecimal sumSettleAmt;
            long contractId = Long.parseLong(contract.getPkValue().toString());
            BigDecimal sumSettleOfTaxAmt = (BigDecimal)settleOfTaxAmtMap.get(contractId);
            if (sumSettleOfTaxAmt != null) {
                contract.set("totalsettleoftaxamount", (Object)sumSettleOfTaxAmt);
            }
            if ((sumSettleAmt = (BigDecimal)settleAmtMap.get(contractId)) == null) continue;
            contract.set("totalsettleamount", (Object)sumSettleAmt);
        }
        SaveServiceHelper.update((DynamicObject[])repairContracts.toArray(new DynamicObject[0]));
        view.showSuccessNotification(ResManager.loadKDString((String)"\u652f\u51fa\u5408\u540c\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u4fee\u590d\u6210\u529f\u3002", (String)"DataUpdateHelper_22", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
    }
}

