/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmbs.business.helper.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectF7FilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.BuildCommonFilterList;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;
import org.apache.commons.collections4.ListUtils;

public class ProjectTeamPermissionHelper {
    private static final Log logger = LogFactory.getLog(ProjectTeamPermissionHelper.class);

    public static Set<Long> loadHasPermProjects(QFilter proQFilter, boolean ctrlParam, boolean isLoadNoPermOrgTeamPro, Long userId, List<Long> orgIds, String appId, String entityNum) {
        long startTime = new Date().getTime();
        HashSet<Long> bdProjects = new HashSet<Long>();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)userId);
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (superUser || adminUser) {
            ProjectTeamPermissionHelper.loadProjectBySuper(bdProjects, proQFilter, orgIds);
            logger.info("\u5168\u529f\u80fd\u7528\u6237\u7684\u9879\u76ee\u6570: {}", (Object)bdProjects.size());
        } else {
            ProjectTeamPermissionHelper.loadProjectByDeptManager(bdProjects, proQFilter, userId);
            logger.info("\u90e8\u95e8\u8d1f\u8d23\u4eba\u9879\u76ee\u6570: {}", (Object)bdProjects.size());
            Set<Long> projectByExceptions = ProjectTeamPermissionHelper.loadProjectByExUser(userId, proQFilter);
            if (projectByExceptions.size() > 0) {
                bdProjects.addAll(projectByExceptions);
            }
            logger.info("\u9879\u76ee\u4f8b\u5916\u4eba\u5458\u8bbe\u7f6e + \u90e8\u95e8\u8d1f\u8d23\u4eba\u7684\u9879\u76ee\u6570: {}", (Object)bdProjects.size());
            if (ctrlParam) {
                ProjectTeamPermissionHelper.loadProjectByTeam(bdProjects, userId, orgIds, appId, entityNum);
            } else {
                ProjectTeamPermissionHelper.loadProjectByOrg(bdProjects, userId, orgIds, appId, entityNum);
            }
            long EndTime = new Date().getTime();
            logger.info("\u67e5\u8be2\u9879\u76ee\u6240\u9700\u65f6\u95f4\uff1a{}", (Object)(EndTime - startTime));
            logger.info("\u9879\u76ee\u56e2\u961f + \u90e8\u95e8\u8d1f\u8d23\u4eba + \u9879\u76ee\u4f8b\u5916\u4eba\u5458\u8bbe\u7f6e\u9879\u76ee\u6570: {}", (Object)bdProjects.size());
        }
        return bdProjects;
    }

    public static void loadProjectBySuper(Set<Long> bdProjects, QFilter qFilter, List<Long> orgIds) {
        if (orgIds != null && orgIds.size() > 0) {
            List allSubordinateOrgList = OrgServiceHelper.getAllSubordinateOrgs((String)"15", orgIds, (boolean)true);
            Set<Long> approvalPros = ProjectTeamPermissionHelper.loadProjectsByApproval(allSubordinateOrgList);
            if (approvalPros.size() > 0) {
                bdProjects.addAll(approvalPros);
            }
            qFilter.and("pmascreateorg", "in", (Object)allSubordinateOrgList);
        }
        bdProjects.addAll(ProjectTeamPermissionHelper.batchQueryProject(qFilter));
    }

    public static void loadProjectByOrg(Set<Long> bdProjects, Long userId, List<Long> orgIds, String appId, String entityNum) {
        if (orgIds == null) {
            orgIds = new ArrayList<Long>();
            List allPermOrgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(userId), (String)appId, (String)entityNum, (String)"47150e89000000ac");
            orgIds.addAll(allPermOrgList);
        }
        if (orgIds.size() > 0) {
            QFilter qFilter;
            Set<Long> mainProjects;
            Set<Long> approvalPros = ProjectTeamPermissionHelper.loadProjectsByApproval(orgIds);
            if (approvalPros.size() > 0) {
                bdProjects.addAll(approvalPros);
            }
            if ((mainProjects = ProjectTeamPermissionHelper.batchQueryProject(qFilter = new QFilter("pmascreateorg", "in", orgIds))).size() > 0) {
                bdProjects.addAll(mainProjects);
            }
        }
    }

    public static void loadProjectByDeptManager(Set<Long> bdProjects, QFilter qFilter, Long userId) {
        List chargeOrgList = UserServiceHelper.getUserDepartment((long)userId, (boolean)Boolean.TRUE);
        if (chargeOrgList != null && chargeOrgList.size() > 0) {
            Set<Long> approvalPros;
            List<Long> shareOrgUnits = ProjectTeamPermissionHelper.loadShareOrgUnitsByAdminOrg(chargeOrgList = OrgServiceHelper.getAllSubordinateOrgs((String)"01", (List)chargeOrgList, (boolean)true));
            if (shareOrgUnits.size() > 0) {
                chargeOrgList.addAll(shareOrgUnits);
            }
            if ((approvalPros = ProjectTeamPermissionHelper.loadProjectsByApproval(chargeOrgList)).size() > 0) {
                bdProjects.addAll(approvalPros);
            }
            QFilter departQFilter = new QFilter("pmascreateorg", "in", (Object)chargeOrgList);
            bdProjects.addAll(ProjectTeamPermissionHelper.batchQueryProject(departQFilter.and(qFilter)));
        }
    }

    public static Set<Long> loadProjectByTeam(Set<Long> bdProjects, Long userId, List<Long> orgIds, String appId, String entityNum) {
        QFilter memberQFilter = new QFilter("member", "=", (Object)userId);
        DataSet projectSet = ORM.create().queryDataSet("ProjectTeamPermissionHelper#loadProjectByTeam", "pmas_nowteam", "project", new QFilter[]{memberQFilter});
        while (projectSet.hasNext()) {
            Row row = projectSet.next();
            bdProjects.add(row.getLong("project"));
        }
        return bdProjects;
    }

    public static void loadProjectTeamProsByOrg(Set<Long> bdProjects, Long userId, List<Long> orgIds) {
        QFilter qFilter = new QFilter("pmascreateorg", "in", orgIds);
        qFilter.and("status", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("enable", "=", (Object)true);
        Set<Long> projectsByOrg = ProjectTeamPermissionHelper.batchQueryProject(qFilter);
        Set<Long> projectsByApproval = ProjectTeamPermissionHelper.loadProjectsByApproval(orgIds);
        if (projectsByApproval.size() > 0) {
            projectsByOrg.addAll(projectsByApproval);
        }
        QFilter memberQFilter = new QFilter("member", "=", (Object)userId);
        DataSet projectSet = ORM.create().queryDataSet("ProjectTeamPermissionHelper#loadProjectByTeam", "pmas_nowteam", "project", new QFilter[]{memberQFilter});
        while (projectSet.hasNext()) {
            Row row = projectSet.next();
            Long projectId = row.getLong("project");
            if (!projectsByOrg.contains(projectId)) continue;
            bdProjects.add(projectId);
        }
    }

    public static void loadProjectsByNoPermOrg(Set<Long> bdProjects, Long userId, String appId, String entityNum) {
        QFilter memberQFilter = new QFilter("member", "=", (Object)userId);
        DataSet projectSet = ORM.create().queryDataSet("ProjectTeamPermissionHelper#loadProjectByTeam", "pmas_nowteam", "project", new QFilter[]{memberQFilter});
        while (projectSet.hasNext()) {
            Row row = projectSet.next();
            Long projectIds = row.getLong("project");
            bdProjects.add(projectIds);
        }
        List allPermOrgList = ProjectPermissionHelper.getAllPermOrgsByPermItem((String)"15", (String)String.valueOf(userId), (String)appId, (String)entityNum, (String)"47150e89000000ac");
        HashSet<Long> hasPermOrgPros = new HashSet<Long>(10);
        ProjectTeamPermissionHelper.loadProjectTeamProsByOrg(hasPermOrgPros, userId, allPermOrgList);
        if (hasPermOrgPros.size() > 0) {
            bdProjects.removeAll(hasPermOrgPros);
        }
    }

    public static Set<Long> loadProjectByExUser(Long userId, QFilter qFilter) {
        HashSet<Long> bdProjects = new HashSet<Long>(16);
        String selectors = String.join((CharSequence)",", "org", "issubordinate", "excluprojstr", "rolesstr", "exclusionproj");
        QFilter filter = new QFilter("enable", "=", (Object)true);
        filter.and("user", "=", (Object)userId);
        DynamicObject[] proPermissions = BusinessDataServiceHelper.load((String)"pmbs_propermission", (String)selectors, (QFilter[])new QFilter[]{filter});
        HashSet<Long> adminOrgIds = new HashSet<Long>();
        HashSet excludeProIds = new HashSet();
        for (DynamicObject obj : proPermissions) {
            long orgId = Long.parseLong(obj.getDynamicObject("org").getPkValue().toString());
            boolean isSubordinate = obj.getBoolean("issubordinate");
            if (isSubordinate) {
                adminOrgIds.addAll(OrgServiceHelper.getAllSubordinateOrgs((String)"01", Stream.of(Long.valueOf(orgId)).collect(Collectors.toList()), (boolean)true));
            } else {
                adminOrgIds.add(orgId);
            }
            DynamicObjectCollection excludeObj = obj.getDynamicObjectCollection("exclusionproj");
            Set excludeProObj = excludeObj.stream().filter(pro -> pro.getDynamicObject("fbasedataId") != null).map(pro -> Long.parseLong(pro.getDynamicObject("fbasedataId").getPkValue().toString())).collect(Collectors.toSet());
            excludeProIds.addAll(excludeProObj);
        }
        logger.info("\u4eba\u5458\u6240\u5177\u5907\u7684\u884c\u653f\u7ec4\u7ec7: {}", adminOrgIds);
        logger.info("\u6392\u9664\u7684\u9879\u76ee: {}", excludeProIds);
        if (proPermissions.length > 0 && adminOrgIds.size() > 0) {
            List<Long> shareUnits = ProjectTeamPermissionHelper.loadShareOrgUnitsByAdminOrg(new ArrayList<Long>(adminOrgIds));
            if (shareUnits.size() > 0) {
                adminOrgIds.addAll(shareUnits);
            }
            Set<Long> projectAppIds = ProjectTeamPermissionHelper.loadProjectsByApproval(new ArrayList<Long>(adminOrgIds));
            QFilter projectAppFilter = new QFilter("id", "in", projectAppIds);
            projectAppFilter.and("pmascreateorg", "in", adminOrgIds);
            Set<Long> projectIds = ProjectTeamPermissionHelper.batchQueryProject(qFilter.and(projectAppFilter));
            if (projectIds.size() > 0) {
                projectIds.removeIf(excludeProIds::contains);
                bdProjects.addAll(projectIds);
            }
        }
        return bdProjects;
    }

    public static Set<Long> loadProjectsByBizBill(List<QFilter> qFilters, String proIdentity, String formId) {
        DynamicObjectCollection busBills;
        Set<Long> bdProjects = new HashSet<Long>(16);
        if (qFilters.size() > 0 && (busBills = QueryServiceHelper.query((String)formId, (String)proIdentity, (QFilter[])qFilters.toArray(new QFilter[0]))).size() > 0) {
            bdProjects = busBills.stream().filter(bill -> bill.getLong(proIdentity) != 0L).map(bill -> bill.getLong(proIdentity)).collect(Collectors.toSet());
        }
        return bdProjects;
    }

    private static Set<Long> loadProjectsByApproval(List<Long> orgIds) {
        Set<Long> proApprovalSet = new HashSet<Long>(10);
        QFilter statusQFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObjectCollection proApprovals = QueryServiceHelper.query((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "id", "pro", "department", "org", "syscreateorg", "accountorg", "createorg"), (QFilter[])new QFilter[]{statusQFilter});
        if (proApprovals.size() > 0) {
            proApprovalSet = proApprovals.stream().filter(o -> o.getLong("pro") != 0L).filter(o -> orgIds.contains(o.getLong("org")) || orgIds.contains(o.getLong("department")) || orgIds.contains(o.getLong("syscreateorg")) || orgIds.contains(o.getLong("accountorg")) || orgIds.contains(o.getLong("createorg"))).map(o -> o.getLong("pro")).collect(Collectors.toSet());
        }
        return proApprovalSet;
    }

    public static Set<Long> loadPermContract(QFilter conQFilter, List<Long> projectIds) {
        ArrayList contracts = new ArrayList(16);
        if (projectIds.size() > 1) {
            QFilter proQFilter = new QFilter("project", "=", (Object)0L);
            String maxsize = System.getProperty("orm.opt.in.maxsize");
            int pageSize = 10000;
            if (!StringUtils.isEmpty((CharSequence)maxsize)) {
                pageSize = Integer.parseInt(maxsize);
            }
            List partition = ListUtils.partition(projectIds, (int)pageSize);
            for (List proIds : partition) {
                QFilter qFilter = new QFilter("project", "in", (Object)proIds);
                qFilter.or(proQFilter);
                contracts.addAll(QueryServiceHelper.query((String)"pmct_contracttpl", (String)"id", (QFilter[])new QFilter[]{conQFilter, qFilter}));
            }
        } else if (projectIds.size() == 1) {
            conQFilter = new QFilter("project", "=", (Object)projectIds.get(0));
            contracts.addAll(QueryServiceHelper.query((String)"pmct_contracttpl", (String)"id", (QFilter[])new QFilter[]{conQFilter}));
        } else {
            QFilter proQFilter = new QFilter("project", "=", (Object)0L);
            contracts.addAll(QueryServiceHelper.query((String)"pmct_contracttpl", (String)"id", (QFilter[])new QFilter[]{conQFilter, proQFilter}));
        }
        return contracts.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
    }

    public static Map<Long, Boolean> judgeIsHasProOpPerm(Set<Long> projectIdList, String billFormId, String operateKey, Long userId, Map<String, Set<Long>> permOrgMap) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(16);
        ArrayList<Long> unPermProjectList = new ArrayList<Long>(10);
        if (projectIdList == null || projectIdList.isEmpty()) {
            return result;
        }
        boolean isTeamPerm = ProjectPermFilterHelper.getTeamPermSysParam();
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a\u9879\u76ee\u56e2\u961f\u6743\u9650\u53c2\u6570\u662f\u5426\u5f00\u542f={}", (Object)isTeamPerm);
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a\u5f00\u59cb\u83b7\u53d6\u6709\u6743\u9650\u7684\u9879\u76ee\uff0c\u5355\u636e\u6807\u8bc6={}\uff0c\u64cd\u4f5c\u6807\u8bc6={}\uff0c\u7528\u6237ID={}", new Object[]{billFormId, operateKey, userId});
        Map permObj = ProjectPermissionHelper.getPermObj((String)billFormId, (String)operateKey);
        if (permObj.isEmpty()) {
            logger.info("\u5355\u636e{}\u7684{}\u64cd\u4f5c\u672a\u914d\u7f6e\u6743\u9650\u9879", (Object)billFormId, (Object)operateKey);
            for (Long projectId : projectIdList) {
                result.put(projectId, Boolean.TRUE);
            }
            return result;
        }
        for (Long projectId : projectIdList) {
            if (isTeamPerm) {
                result.put(projectId, Boolean.FALSE);
            } else {
                result.put(projectId, Boolean.TRUE);
            }
            unPermProjectList.add(projectId);
        }
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a\u521d\u59cb\u9879\u76ee\u6743\u9650\u5217\u8868{}", result);
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a1\u3001\u5f00\u59cb\u8ba1\u7b97\u9879\u76ee\u56e2\u961f\u4e2d\u662f\u5426\u6709\u6743\u9650\u7684\u9879\u76ee");
        if (isTeamPerm) {
            QFilter teamQFilter = new QFilter("project", "in", projectIdList);
            teamQFilter.and("member", "=", (Object)userId);
            DynamicObjectCollection teams = QueryServiceHelper.query((String)"pmas_nowteam", (String)"project,role,ischarge", (QFilter[])new QFilter[]{teamQFilter});
            for (DynamicObject team : teams) {
                boolean isCharge = team.getBoolean("ischarge");
                if (isCharge) {
                    result.put(team.getLong("project"), isCharge);
                    unPermProjectList.remove(team.getLong("project"));
                    continue;
                }
                String role = team.getString("role");
                HashSet<String> roles = new HashSet<String>();
                roles.add(role);
                boolean hashPerm = ProjectTeamPermissionHelper.judgePermByRoles(billFormId, roles, (String)permObj.get("permNumber"));
                if (!hashPerm) continue;
                result.put(team.getLong("project"), hashPerm);
                unPermProjectList.remove(team.getLong("project"));
            }
            if (unPermProjectList.size() == 0) {
                return result;
            }
            logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a\u6309\u9879\u76ee\u56e2\u961f\u8ba1\u7b97\u5426\u6709\u6743\u9650\u7684\u9879\u76ee\u540e\uff0c\u9879\u76ee\u6743\u9650\u5217\u8868{}", result);
        }
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a2\u3001\u5f00\u59cb\u6309\u884c\u653f\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u8ba1\u7b97\u662f\u5426\u6709\u6743\u9650\u7684\u9879\u76ee");
        Set<Long> chargeOrgList = permOrgMap.get("chargeOrgList");
        if (!chargeOrgList.isEmpty()) {
            QFilter projectFilter = new QFilter("pro", "!=", (Object)0L).and("billstatus", "=", (Object)Character.valueOf('C'));
            DynamicObjectCollection approvalProjectIdList = QueryServiceHelper.query((String)"pmas_pro_approval", (String)"pro", (QFilter[])new QFilter[]{projectFilter});
            Set approvalProjectIdSet = new HashSet(10);
            if (approvalProjectIdList != null && approvalProjectIdList.size() > 0) {
                approvalProjectIdSet = approvalProjectIdList.stream().map(item -> item.getLong("pro")).collect(Collectors.toSet());
            }
            unPermProjectList.retainAll(approvalProjectIdSet);
            QFilter qFilter = new QFilter("pro", "in", unPermProjectList);
            DynamicObjectCollection proApprovals = QueryServiceHelper.query((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "pro", "id", "department", "org", "syscreateorg", "accountorg", "createorg"), (QFilter[])new QFilter[]{qFilter});
            if (proApprovals.size() > 0) {
                for (DynamicObject bill : proApprovals) {
                    boolean flag = chargeOrgList.contains(bill.getLong("org")) || chargeOrgList.contains(bill.getLong("department")) || chargeOrgList.contains(bill.getLong("syscreateorg")) || chargeOrgList.contains(bill.getLong("accountorg")) || chargeOrgList.contains(bill.getLong("createorg"));
                    if (!flag) continue;
                    result.put(bill.getLong("pro"), Boolean.TRUE);
                    unPermProjectList.remove(bill.getLong("pro"));
                }
            }
        }
        if (unPermProjectList.size() == 0) {
            return result;
        }
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a\u6309\u884c\u653f\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u8ba1\u7b97\u662f\u5426\u6709\u6743\u9650\u7684\u9879\u76ee\u540e,\u9879\u76ee\u6743\u9650\u5217\u8868{}", result);
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a3\u3001\u5f00\u59cb\u6309\u5176\u4ed6\u4e91\u53c2\u6570\u8ba1\u7b97\u662f\u5426\u6709\u6743\u9650\u7684\u9879\u76ee");
        ArrayList permOrgList = new ArrayList(permOrgMap.get("permOrgList"));
        if (permOrgList.size() > 0) {
            Set otherCloudProjectIdList = ProjectF7FilterHelper.getOtherCloudProjectIdList(permOrgList);
            for (Long projectId : otherCloudProjectIdList) {
                result.put(projectId, Boolean.TRUE);
                unPermProjectList.remove(projectId);
            }
        }
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a\u6309\u5176\u4ed6\u4e91\u8ba1\u7b97\u662f\u5426\u6709\u6743\u9650\u7684\u9879\u76ee\u540e,\u9879\u76ee\u6743\u9650\u5217\u8868{}", result);
        if (unPermProjectList.size() == 0) {
            return result;
        }
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a4\u3001\u5f00\u59cb\u6309\u4f8b\u5916\u4eba\u5458\u8bbe\u7f6e\u8ba1\u7b97\u662f\u5426\u6709\u6743\u9650\u7684\u9879\u76ee");
        String selectors = String.join((CharSequence)",", "org", "issubordinate", "excluprojstr", "rolesstr", "exclusionproj");
        QFilter filter = new QFilter("enable", "=", (Object)true);
        filter.and("user", "=", (Object)userId);
        DynamicObjectCollection proPermissions = QueryServiceHelper.query((String)"pmbs_propermission", (String)selectors, (QFilter[])new QFilter[]{filter});
        if (proPermissions != null && !proPermissions.isEmpty()) {
            Set<Long> adminOrgIds = permOrgMap.get("projectPersonSettingOrgList");
            HashSet<Long> excludeProIds = new HashSet<Long>();
            ORM orm = ORM.create();
            for (DynamicObject obj : proPermissions) {
                long excludeProjectMulti = obj.getLong("exclusionproj");
                if (excludeProjectMulti == 0L) continue;
                StringBuilder querySQL = new StringBuilder("select fbasedataId from t_pmbs_exclusionproj where fid =").append(excludeProjectMulti);
                DataSet dataSet = DB.queryDataSet((String)"kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper.judgeIsHasProOpPerm#1", (DBRoute)DBRoute.of((String)"cr"), (String)querySQL.toString());
                DynamicObjectCollection excludeProjectList = orm.toPlainDynamicObjectCollection(dataSet);
                for (DynamicObject item2 : excludeProjectList) {
                    excludeProIds.add(item2.getLong("fbasedataId"));
                }
            }
            Set<Long> projectAppIds = ProjectTeamPermissionHelper.loadProjectsByApproval(new ArrayList<Long>(adminOrgIds));
            if (!projectAppIds.isEmpty()) {
                projectAppIds.removeAll(excludeProIds);
                for (Long item3 : unPermProjectList) {
                    if (!projectAppIds.contains(item3)) continue;
                    result.put(item3, Boolean.TRUE);
                }
            }
            if (!isTeamPerm) {
                for (Long id : excludeProIds) {
                    if (!result.containsKey(id)) continue;
                    result.put(id, false);
                }
            }
        }
        logger.info("[\u9879\u76ee\u4e91\u9879\u76ee\u6743\u9650\u65e5\u5fd7]\uff1a\u6309\u4f8b\u5916\u4eba\u5458\u8bbe\u7f6e\u8ba1\u7b97\u662f\u5426\u6709\u6743\u9650\u7684\u9879\u76ee\u540e\uff0c\u9879\u76ee\u6743\u9650\u5217\u8868{}", result);
        return result;
    }

    public static Map<String, String> judgeIsHasProOpPerm(Long selectProjectId, String billFormId, String operateKey, Long userId) {
        HashMap<String, String> tipMap = new HashMap<String, String>(16);
        Map permObj = ProjectPermissionHelper.getPermObj((String)billFormId, (String)operateKey);
        if (permObj.isEmpty()) {
            tipMap.put("hasPerm", Boolean.TRUE.toString());
            return tipMap;
        }
        if (selectProjectId != 0L) {
            boolean isTeamPerm;
            Map<String, String> resultMap = ProjectTeamPermissionHelper.judgeProjectPermByExUser(userId, billFormId, operateKey, selectProjectId);
            if ("view".equals(operateKey) || "modify".equals(operateKey)) {
                if (resultMap.get("hasViewPerm") != null && Boolean.parseBoolean(resultMap.get("hasViewPerm"))) {
                    tipMap.put("hasPerm", Boolean.TRUE.toString());
                    return tipMap;
                }
                QFilter projectFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
                projectFilter.and("enable", "=", (Object)EnableEnum.ENABLE.getValue());
                HashSet<Long> deptManagerProjects = new HashSet<Long>();
                ProjectTeamPermissionHelper.loadProjectByDeptManager(deptManagerProjects, projectFilter, userId);
                if (deptManagerProjects.contains(selectProjectId)) {
                    tipMap.put("hasPerm", Boolean.TRUE.toString());
                    return tipMap;
                }
            }
            if (!(isTeamPerm = ProjectPermFilterHelper.getTeamPermSysParam())) {
                tipMap.put("hasPerm", Boolean.TRUE.toString());
                return tipMap;
            }
            if (resultMap.get("hasPerm") != null && Boolean.parseBoolean(resultMap.get("hasPerm"))) {
                tipMap.put("hasPerm", Boolean.TRUE.toString());
                return tipMap;
            }
            boolean isProLeader = ProjectTeamPermissionHelper.judgeIfProLeader(selectProjectId, userId);
            if (isProLeader) {
                tipMap.put("hasPerm", Boolean.TRUE.toString());
                return tipMap;
            }
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)selectProjectId, (String)"bd_project");
            QFilter teamQFilter = new QFilter("project", "=", (Object)selectProjectId);
            teamQFilter.and("member", "=", (Object)userId);
            DynamicObject[] teams = BusinessDataServiceHelper.load((String)"pmas_nowteam", (String)"role,ischarge", (QFilter[])new QFilter[]{teamQFilter});
            if (teams != null && teams.length > 0) {
                Set<String> roles = Arrays.stream(teams).filter(o -> o.getDynamicObject("role") != null).map(o -> o.getDynamicObject("role").getPkValue().toString()).collect(Collectors.toSet());
                boolean hashPerm = ProjectTeamPermissionHelper.judgePermByRoles(billFormId, roles, (String)permObj.get("permNumber"));
                if (hashPerm) {
                    tipMap.put("hasPerm", Boolean.TRUE.toString());
                } else {
                    tipMap.put("noHasPerm", String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u9879\u76ee\u7684\u201c%2$s\u201d\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u9879\u76ee\u56e2\u961f\u4e2d\u7684\u89d2\u8272\u3002", (String)"ProjectTeamPermissionHelper_6", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("name"), permObj.get("permName")));
                }
            } else {
                tipMap.put("noHasPerm", String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u9879\u76ee\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u7528\u6237\u662f\u5426\u662f\u9879\u76ee\u56e2\u961f\u6210\u5458\u6216\u9879\u76ee\u7ba1\u7406\u4f8b\u5916\u4eba\u5458\u3002", (String)"ProjectTeamPermissionHelper_11", (String)"pmgt-pmbs-business", (Object[])new Object[0]), project.getString("name")));
            }
        }
        return tipMap;
    }

    public static Map<String, String> judgeProjectPermByExUser(long userId, String billFormId, String operateKey, long projectId) {
        boolean hashPerm;
        DynamicObject[] proPermissions;
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        Map permObj = ProjectPermissionHelper.getPermObj((String)billFormId, (String)operateKey);
        if (permObj.isEmpty()) {
            resultMap.put("hasPerm", Boolean.TRUE.toString());
            resultMap.put("hasViewPerm", Boolean.TRUE.toString());
            return resultMap;
        }
        HashSet<Long> adminOrgIds = new HashSet<Long>();
        HashSet excludeProObj = new HashSet();
        HashSet<String> roleIds = new HashSet<String>();
        HashSet<Long> proOrgs = new HashSet<Long>(10);
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bd_project");
        proOrgs.add(Long.parseLong(project.getDynamicObject("pmascreateorg").getPkValue().toString()));
        QFilter qFilter = new QFilter("pro", "=", (Object)projectId);
        DynamicObjectCollection proApprovals = QueryServiceHelper.query((String)"pmas_pro_approval", (String)String.join((CharSequence)",", "pro", "id", "department", "org", "syscreateorg", "accountorg", "createorg"), (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject proApproval : proApprovals) {
            if (proApproval.get("department") != null) {
                proOrgs.add(proApproval.getLong("department"));
            }
            if (proApproval.get("org") != null) {
                proOrgs.add(proApproval.getLong("org"));
            }
            if (proApproval.get("syscreateorg") != null) {
                proOrgs.add(proApproval.getLong("syscreateorg"));
            }
            if (proApproval.get("accountorg") != null) {
                proOrgs.add(proApproval.getLong("accountorg"));
            }
            if (proApproval.get("createorg") == null) continue;
            proOrgs.add(proApproval.getLong("createorg"));
        }
        String selectors = String.join((CharSequence)",", "org", "issubordinate", "roles", "exclusionproj");
        QFilter filter = new QFilter("enable", "=", (Object)true);
        filter.and("user", "=", (Object)userId);
        for (DynamicObject obj : proPermissions = BusinessDataServiceHelper.load((String)"pmbs_propermission", (String)selectors, (QFilter[])new QFilter[]{filter})) {
            Set roles;
            DynamicObjectCollection roleColl;
            List<Long> adminOrgIdsByOrg = new ArrayList<Long>();
            long orgId = Long.parseLong(obj.getDynamicObject("org").getPkValue().toString());
            boolean isSubordinate = obj.getBoolean("issubordinate");
            if (isSubordinate) {
                adminOrgIdsByOrg = OrgServiceHelper.getAllSubordinateOrgs((String)"01", Stream.of(Long.valueOf(orgId)).collect(Collectors.toList()), (boolean)true);
            } else {
                adminOrgIdsByOrg.add(orgId);
            }
            List<Long> shareUnits = ProjectTeamPermissionHelper.loadShareOrgUnitsByAdminOrg(adminOrgIdsByOrg);
            if (shareUnits.size() > 0) {
                adminOrgIdsByOrg.addAll(shareUnits);
            }
            adminOrgIdsByOrg.retainAll(proOrgs);
            if (adminOrgIdsByOrg.size() == 0) continue;
            adminOrgIds.addAll(adminOrgIdsByOrg);
            DynamicObjectCollection excludeObj = obj.getDynamicObjectCollection("exclusionproj");
            Set excludePro = excludeObj.stream().filter(pro -> pro.getDynamicObject("fbasedataId") != null).map(pro -> Long.parseLong(pro.getDynamicObject("fbasedataId").getPkValue().toString())).collect(Collectors.toSet());
            if (excludePro.size() > 0) {
                excludeProObj.addAll(excludePro);
            }
            if ((roleColl = obj.getDynamicObjectCollection("roles")) == null || roleColl.size() <= 0 || (roles = roleColl.stream().map(pro -> String.valueOf(pro.getDynamicObject("fbasedataId").getPkValue())).collect(Collectors.toSet())).size() <= 0) continue;
            roleIds.addAll(roles);
        }
        if (adminOrgIds.size() == 0 || excludeProObj.contains(projectId)) {
            resultMap.put("hasPerm", Boolean.FALSE.toString());
            resultMap.put("hasViewPerm", Boolean.FALSE.toString());
            return resultMap;
        }
        resultMap.put("hasViewPerm", Boolean.TRUE.toString());
        if (roleIds.size() > 0 && (hashPerm = ProjectTeamPermissionHelper.judgePermByRoles(billFormId, roleIds, permObj.get("permNumber").toString()))) {
            resultMap.put("hasPerm", Boolean.TRUE.toString());
        }
        return resultMap;
    }

    private static boolean judgePermByRoles(String billFormId, Set<String> roles, String permNumber) {
        HashSet<String> hasPermRoles = new HashSet<String>(16);
        block0: for (String role : roles) {
            DynamicObject[] rightPermData;
            for (DynamicObject obj : rightPermData = PermissionServiceHelper.getRightPermDataByRoleId((String)role)) {
                DynamicObjectCollection rolePerms = obj.getDynamicObjectCollection("roleperm");
                if (rolePerms == null) continue;
                for (DynamicObject perm : rolePerms) {
                    DynamicObject entity = perm.getDynamicObject("entity");
                    DynamicObject perItem = perm.getDynamicObject("permitem");
                    String entityNumber = "";
                    String perItemNumber = "";
                    if (entity != null) {
                        entityNumber = entity.getString("number");
                    }
                    if (perItem != null) {
                        perItemNumber = perItem.getString("number");
                    }
                    if (!entityNumber.equals(billFormId) || !perItemNumber.equals(permNumber)) continue;
                    hasPermRoles.add(role);
                    continue block0;
                }
            }
        }
        return hasPermRoles.size() > 0;
    }

    private static Set<Long> batchQueryProject(QFilter qFilter) {
        HashSet<Long> projectIdSet = new HashSet<Long>(16);
        DataSet projectIds = ORM.create().queryDataSet("ProjectTeamPermissionHelper#batchQueryProject", "bd_project", "id", new QFilter[]{qFilter}, "id desc");
        while (projectIds.hasNext()) {
            Row row = projectIds.next();
            projectIdSet.add(row.getLong(0));
        }
        return projectIdSet;
    }

    public static <T extends AbstractFormPlugin> void setProjectNotCloseComboItems(T formPlugin, List<Long> orgIds) {
        List projectItems = ProjectPermissionHelper.getProjectFilter(formPlugin);
        for (CommonFilterColumn projectFilterItem : projectItems) {
            String formId;
            QFilter filter = ProjectTeamPermissionHelper.getProjectNotCloseFilter();
            QFilter proOrgQFilter = new QFilter("department", "in", orgIds);
            proOrgQFilter.or("pmascreateorg", "in", orgIds);
            proOrgQFilter.or("org", "in", orgIds);
            proOrgQFilter.or("createorg", "in", orgIds);
            proOrgQFilter.or("useorg", "in", orgIds);
            filter.and(proOrgQFilter);
            Set<Long> projectIds = ProjectTeamPermissionHelper.batchQueryProject(filter);
            Map customParams = formPlugin.getView().getFormShowParameter().getCustomParams();
            if (customParams.get("billFormId") != null && StringUtils.equals((CharSequence)(formId = formPlugin.getView().getFormShowParameter().getCustomParams().get("billFormId").toString()), (CharSequence)"pmas_team")) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("org", "in", orgIds));
                Set<Long> bizBillPros = ProjectTeamPermissionHelper.loadProjectsByBizBill(qFilters, "project", formId);
                if (bizBillPros.size() > 0) {
                    projectIds.addAll(bizBillPros);
                }
            }
            DynamicObject dynamicObject = ParameterReader.getBillParameter((String)"pmas_pro_approval");
            int maxParamLimit = dynamicObject.getInt("maxreturndata");
            if (projectIds.size() > maxParamLimit) {
                formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u9879\u76ee\u6570\u8d85\u8fc7\u5217\u8868\u9650\u5236\u6570\uff0c\u8bf7\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"ProjectTeamPermissionHelper_9", (String)"pmgt-pmbs-business", (Object[])new Object[0]));
            }
            List<Long> projectIdList = new ArrayList<Long>(projectIds);
            if (projectIds.size() > 0) {
                List partition = ListUtils.partition(projectIdList, (int)maxParamLimit);
                projectIdList = (List)partition.get(0);
            }
            QFilter qFilter = new QFilter("id", "in", projectIdList);
            projectFilterItem.setComboItems(BuildCommonFilterList.buildComboItem((String)"bd_project", (QFilter)qFilter));
        }
    }

    public static QFilter getProjectNotCloseFilter() {
        long businessCloseId = Long.parseLong(ProjectStatusEnum.BUSSINESS_CLOSE.getId());
        long financialCloseId = Long.parseLong(ProjectStatusEnum.FINANCIAL_CLOSE.getId());
        long suspendId = Long.parseLong(ProjectStatusEnum.SUSPEND.getId());
        long quitId = Long.parseLong(ProjectStatusEnum.QUIT.getId());
        return new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue()).and("enable", "=", (Object)EnableEnum.ENABLE.getValue()).and("prostatus", "not in", (Object)new long[]{businessCloseId, financialCloseId, suspendId, quitId});
    }

    public static List<Long> getAllPermOrgsByPermItem(String orgViewType, Long userId, String appId, String entityNum, String permItemId) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId);
        if (result.hasAllOrgPerm()) {
            ArrayList<Long> orgList = new ArrayList<Long>(10);
            orgList.add(OrgUnitServiceHelper.getRootOrgId());
            return OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgList, (boolean)true);
        }
        return result.getHasPermOrgs();
    }

    public static Map<String, Set<Long>> getOtherSpecialOrgMap(long userId) {
        QFilter projectFilter;
        DynamicObjectCollection teamCollection;
        Set projectList;
        HashMap<String, Set<Long>> otherSpecialOrgMap = new HashMap<String, Set<Long>>(10);
        HashSet<Long> orgList = new HashSet<Long>(2000);
        List<Long> chargeOrgList = UserServiceHelper.getUserDepartment((long)RequestContext.get().getCurrUserId(), (boolean)Boolean.TRUE);
        if (!chargeOrgList.isEmpty()) {
            chargeOrgList = OrgServiceHelper.getAllSubordinateOrgs((String)"01", (List)chargeOrgList, (boolean)true);
            chargeOrgList = ProjectTeamPermissionHelper.loadShareOrgUnitsByAdminOrg(chargeOrgList);
            orgList.addAll(chargeOrgList);
        }
        otherSpecialOrgMap.put("chargeOrgList", orgList);
        QFilter filter = new QFilter("enable", "=", (Object)true);
        filter.and("user", "=", (Object)userId);
        DynamicObjectCollection proPermissions = QueryServiceHelper.query((String)"pmbs_propermission", (String)String.join((CharSequence)",", "org", "issubordinate"), (QFilter[])new QFilter[]{filter});
        HashSet<Long> orgList1 = new HashSet<Long>(2000);
        if (proPermissions != null && !proPermissions.isEmpty()) {
            for (DynamicObject item2 : proPermissions) {
                Long orgId = item2.getLong("org");
                orgList1.add(orgId);
                if (!item2.getBoolean("issubordinate")) continue;
                orgList1.addAll(OrgUnitServiceHelper.getAllSubordinateOrgs((String)"01", Collections.singletonList(orgId), (boolean)false));
            }
        }
        otherSpecialOrgMap.put("projectPersonSettingOrgList", new HashSet<Long>(ProjectTeamPermissionHelper.loadShareOrgUnitsByAdminOrg(new ArrayList<Long>(orgList1))));
        HashSet orgList2 = new HashSet(2000);
        QFilter userFilter = new QFilter("member", "=", (Object)userId);
        DynamicObjectCollection projectCollection = QueryServiceHelper.query((String)"pmas_nowteam", (String)"project", (QFilter[])new QFilter[]{userFilter});
        if (!(projectCollection == null || projectCollection.isEmpty() || (projectList = projectCollection.stream().map(item -> item.getLong("project")).collect(Collectors.toSet())).isEmpty() || (teamCollection = QueryServiceHelper.query((String)"pmas_team", (String)"org", (QFilter[])new QFilter[]{projectFilter = new QFilter("project", "in", projectList)})).isEmpty())) {
            orgList2.addAll(teamCollection.stream().map(item -> item.getLong("org")).collect(Collectors.toSet()));
        }
        otherSpecialOrgMap.put("projectTeamOrgList", orgList2);
        return otherSpecialOrgMap;
    }

    public static List<Long> loadShareOrgUnitsByAdminOrg(List<Long> adminOrgList) {
        List<Long> orgUnitList = new ArrayList<Long>(10);
        QFilter qFilter = new QFilter("toorg", "in", adminOrgList);
        DynamicObject[] fromOrgs = BusinessDataServiceHelper.load((String)"bos_org_orgrelation_dept", (String)"fromorg", (QFilter[])new QFilter[]{qFilter});
        if (fromOrgs.length > 0) {
            orgUnitList = Arrays.stream(fromOrgs).filter(o -> o.getDynamicObject("fromorg") != null).map(o -> Long.parseLong(o.getDynamicObject("fromorg").getPkValue().toString())).collect(Collectors.toList());
        }
        return orgUnitList;
    }

    public static boolean judgeIfProLeader(Long project, Long userId) {
        boolean result = false;
        QFilter qFilter = new QFilter("project", "=", (Object)project);
        qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        qFilter.and("type", "=", (Object)"ADJUST");
        DynamicObject[] teamAdjusts = BusinessDataServiceHelper.load((String)"pmas_teamadjust", (String)"proleader", (QFilter[])new QFilter[]{qFilter}, (String)" auditdate desc", (int)1);
        if (teamAdjusts.length > 0) {
            DynamicObject teamAdjust = teamAdjusts[0];
            DynamicObject proLeader = teamAdjust.getDynamicObject("proleader");
            if (proLeader != null && userId == Long.parseLong(proLeader.getPkValue().toString())) {
                result = true;
            }
        } else {
            qFilter = new QFilter("project", "=", (Object)project);
            qFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            qFilter.and("proleader", "=", (Object)userId);
            qFilter.and("type", "=", (Object)"NEW");
            if (QueryServiceHelper.exists((String)"pmas_team", (QFilter[])new QFilter[]{qFilter})) {
                result = true;
            }
        }
        return result;
    }

    public static String getPermItemId(String permItemNum) {
        String permItemId = "";
        DynamicObject permPermItem = BusinessDataServiceHelper.loadSingle((String)"perm_permitem", (String)"id, number", (QFilter[])new QFilter("number", "=", (Object)permItemNum).toArray());
        if (permPermItem != null) {
            permItemId = permPermItem.getString("id");
        }
        return permItemId;
    }
}

