/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin.contsettle;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;
import kd.pmgt.pmbs.common.enums.PerformAmountTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.budget.BudgetValidateAndUpdateHelper;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfo;
import kd.pmgt.pmbs.common.utils.budget.PerformBillInfoBuilder;
import kd.pmgt.pmct.opplugin.AbstractReverseWritingPmctContractOp;
import kd.pmgt.pmct.opplugin.contsettle.FinalSettleValidator;

public class InContractFinalSettleOp
extends AbstractReverseWritingPmctContractOp {
    private static final String CONTRACTSTATUS = "contractstatus";
    private String selectPro = "appamount, apptaxamount, contractstatus";
    private static final String INCONTRACTSETTLEAFTERINVOICECTRL = "pmgt_incontractsettle_invoice_ctrl";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("appamount");
        e.getFieldKeys().add("apptaxamount");
        e.getFieldKeys().add("tempcontstatus");
        e.getFieldKeys().add("paydirection");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("stdcurrency");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("cbudgetitem");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("budgetitem");
        e.getFieldKeys().add("itemsubamount");
        e.getFieldKeys().add("itemappamount");
        e.getFieldKeys().add("itemamount");
        e.getFieldKeys().add("itemincomeaomunt");
        e.getFieldKeys().add("avgtaxrate");
        e.getFieldKeys().add("taxrate");
        e.getFieldKeys().add("ismultirate");
    }

    @Override
    public void reverseWritingToContract(String opkey, DynamicObject finalSettle) {
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)opkey)) {
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)finalSettle.getDynamicObject("contract").getPkValue(), (String)"pmct_incontract", (String)this.selectPro);
            contract.set("appamount", (Object)finalSettle.getBigDecimal("appamount"));
            contract.set("apptaxamount", (Object)finalSettle.getBigDecimal("apptaxamount"));
            QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.CLOSED.getValue());
            DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
            contract.set(CONTRACTSTATUS, (Object)contStatusObj);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
        } else if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)opkey)) {
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)finalSettle.getDynamicObject("contract").getPkValue(), (String)"pmct_incontract", (String)this.selectPro);
            contract.set("appamount", (Object)BigDecimal.ZERO);
            contract.set("apptaxamount", (Object)BigDecimal.ZERO);
            DynamicObject tempContStatus = finalSettle.getDynamicObject("tempcontstatus");
            if (tempContStatus == null) {
                QFilter contStatusFilter = new QFilter("number", "=", (Object)ContractStatusEnum.RUNNING.getValue());
                DynamicObject contStatusObj = BusinessDataServiceHelper.loadSingle((String)"pmct_contractstatus", (String)"id", (QFilter[])new QFilter[]{contStatusFilter});
                contract.set(CONTRACTSTATUS, (Object)contStatusObj);
            } else {
                contract.set(CONTRACTSTATUS, (Object)tempContStatus);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FinalSettleValidator());
        e.addValidator((AbstractValidator)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit") || StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
            this.updateBudgetData(dataEntities, operationKey);
        } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) {
            for (DynamicObject bill : dataEntities) {
                String billNo = bill.getString("billno");
                boolean isInvoiceExist = QueryServiceHelper.exists((String)"sim_original_bill", (QFilter[])new QFilter[]{new QFilter("contractno", "=", (Object)billNo)});
                if (!isInvoiceExist) continue;
                String warnMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u6536\u5165\u5408\u540c\u7ed3\u7b97\u5355\u5df2\u5b58\u5728\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55\uff0c\u53cd\u5ba1\u6838\u53ef\u80fd\u4f1a\u5bf9\u8d22\u52a1\u505a\u8d26\u4ea7\u751f\u5f71\u54cd\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u53cd\u5ba1\u6838\uff1f", (String)"InContractFinalSettleOp_1", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), billNo);
                String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
                InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
                if (confirmResult.getResults().containsKey(INCONTRACTSETTLEAFTERINVOICECTRL)) continue;
                InteractionContext interactionContext = new InteractionContext();
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setMessage(warnMsg);
                errorInfo.setLevel(ErrorLevel.Warning);
                interactionContext.addOperateInfo(errorInfo);
                throw new KDInteractionException(INCONTRACTSETTLEAFTERINVOICECTRL, interactionContext);
            }
            this.updateBudgetData(dataEntities, operationKey);
        }
    }

    protected void updateBudgetData(DynamicObject[] entities, String operationKey) {
        Set proIds;
        DynamicObject[] contracts = new DynamicObject[]{};
        DynamicObject[] proApps = new DynamicObject[]{};
        Set<Object> contractIds = Arrays.stream(entities).filter(o -> o.getDynamicObject("contract") != null).filter(o -> o.getDynamicObject("cbudgetitem") != null).map(o -> o.getDynamicObject("contract").getPkValue()).collect(Collectors.toSet());
        if (contractIds.size() > 0 && (proIds = Arrays.stream(contracts = BusinessDataServiceHelper.load((Object[])contractIds.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract"))).filter(o -> o.getDynamicObject("project") != null).map(o -> Long.parseLong(o.getDynamicObject("project").getPkValue().toString())).collect(Collectors.toSet())).size() > 0) {
            proApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIds)});
        }
        for (DynamicObject bill : entities) {
            PerformBillInfo billInfo;
            DynamicObject budget;
            DynamicObject contract = bill.getDynamicObject("contract");
            if (contract == null || (budget = bill.getDynamicObject("cbudgetitem")) == null) continue;
            if (contracts.length > 0) {
                String contractId = contract.getPkValue().toString();
                Optional<DynamicObject> first = Arrays.stream(contracts).filter(o -> StringUtils.equals((CharSequence)contractId, (CharSequence)o.getPkValue().toString())).findFirst();
                if (first.isPresent()) {
                    contract = first.get();
                }
            }
            DynamicObject project = contract.getDynamicObject("project");
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            if (entryEntity.isEmpty()) continue;
            DynamicObject[] curBillProApps = null;
            boolean multipartSettlement = contract.getBoolean("multipartsettlement");
            if (multipartSettlement) {
                Set<Object> proIdSet = this.getProIdSetWithMultiSettle(bill);
                curBillProApps = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"pro,org,currencyfield", (QFilter[])new QFilter[]{new QFilter("pro", "in", proIdSet)});
            } else if (project != null) {
                String proId = project.getPkValue().toString();
                if (proApps.length > 0) {
                    curBillProApps = (DynamicObject[])Arrays.stream(proApps).filter(o -> StringUtils.equals((CharSequence)proId, (CharSequence)o.getDynamicObject("pro").getPkValue().toString())).toArray(DynamicObject[]::new);
                }
            }
            if (curBillProApps == null || curBillProApps.length <= 0) continue;
            Map<String, BigDecimal> projectAmountMap = this.buildBudgetAmountMap(bill, this.getExchangeRate(bill, (DynamicObject)curBillProApps[0]));
            Map<String, BigDecimal> contractAmountMap = this.buildBudgetAmountMap(bill, BigDecimal.ONE);
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"submit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_infinalsettle").billNo(bill.getString("billno")).billName(bill.getString("name")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).contractCurrency(bill.getDynamicObject("currency")).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnSubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"unsubmit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_infinalsettle").id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnUnsubmit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) {
                billInfo = new PerformBillInfoBuilder().formBillId("pmct_infinalsettle").billNo(bill.getString("billno")).billName(bill.getString("name")).creator(bill.getDynamicObject("creator")).createDate(bill.getDate("createtime")).auditor(bill.getDynamicObject("auditor")).auditDate(bill.getDate("auditdate")).id(bill.getLong("id")).contractId(contract.getPkValue().toString()).amountType(PerformAmountTypeEnum.CONTRACT).build();
                BudgetValidateAndUpdateHelper.updateBudgetOnAudit(projectAmountMap, contractAmountMap, (PerformBillInfo)billInfo);
                continue;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) continue;
            BudgetValidateAndUpdateHelper.updateBudgetOnUnaudit(projectAmountMap, contractAmountMap, (String)"pmct_infinalsettle", (long)bill.getLong("id"), (String)contract.getPkValue().toString(), (PerformAmountTypeEnum)PerformAmountTypeEnum.CONTRACT);
        }
    }

    protected BigDecimal getExchangeRate(DynamicObject bill, DynamicObject project) {
        DynamicObject exRateTable;
        DynamicObject org = project.getDynamicObject("org");
        DynamicObject proCurrency = project.getDynamicObject("currencyfield");
        DynamicObject contractCurrency = bill.getDynamicObject("currency");
        DynamicObject stdCurrency = bill.getDynamicObject("stdcurrency");
        if (proCurrency != null && contractCurrency != null && proCurrency.getPkValue().equals(contractCurrency.getPkValue())) {
            return BigDecimal.ONE;
        }
        if (proCurrency != null && stdCurrency != null && proCurrency.getPkValue().equals(stdCurrency.getPkValue())) {
            return bill.getBigDecimal("exchangerate");
        }
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (org != null && proCurrency != null && contractCurrency != null && (exRateTable = CurrencyHelper.getExRateTable((Long)org.getLong("id"))) != null) {
            exchangeRate = CurrencyHelper.getExChangeRate((Long)contractCurrency.getLong("id"), (Long)proCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)bill.getDate("createtime"));
        }
        return exchangeRate;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, BigDecimal exchangeRate) {
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            BigDecimal amount = entry.getBigDecimal("itemsubamount").negate();
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply(exchangeRate)));
        }
        return budgetAmountMap;
    }

    protected Map<String, BigDecimal> buildBudgetAmountMap(DynamicObject bill, DynamicObject[] proApps) {
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
        HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(proApps.length);
        for (DynamicObject proApp : proApps) {
            BigDecimal exchangeRate = this.getExchangeRate(contract, proApp);
            DynamicObject pro = proApp.getDynamicObject("pro");
            exchangeRateMap.put(pro.getPkValue(), exchangeRate);
        }
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("entryentity");
        HashMap<String, BigDecimal> budgetAmountMap = new HashMap<String, BigDecimal>(entryentity.size());
        for (DynamicObject entry : entryentity) {
            DynamicObject project;
            BigDecimal amount = entry.getBigDecimal("itemappamount");
            DynamicObject budget = entry.getDynamicObject("budgetitem");
            if (budget == null || amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal budgetAmount = (BigDecimal)budgetAmountMap.get(budget.getPkValue().toString());
            if (budgetAmount == null) {
                budgetAmount = BigDecimal.ZERO;
            }
            if (!exchangeRateMap.containsKey((project = budget.getDynamicObject("project")).getPkValue())) continue;
            budgetAmountMap.put(budget.getPkValue().toString(), budgetAmount.add(amount.multiply((BigDecimal)exchangeRateMap.get(project.getPkValue()))));
        }
        return budgetAmountMap;
    }

    private Set<Object> getProIdSetWithMultiSettle(DynamicObject bill) {
        HashSet<Object> proIdSet = new HashSet<Object>(1);
        DynamicObject contract = bill.getDynamicObject("contract");
        boolean multipartSettlement = (contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_incontract")).getBoolean("multipartsettlement");
        if (multipartSettlement) {
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            proIdSet = new HashSet(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                DynamicObject budgetItem = entry.getDynamicObject("budgetitem");
                DynamicObject budgetProject = budgetItem.getDynamicObject("project");
                proIdSet.add(budgetProject.getPkValue());
            }
        }
        return proIdSet;
    }

    protected Map<String, Boolean> validateRate(ExtendedDataEntity[] dataEntities) {
        HashMap<String, Boolean> validateRateResult = new HashMap<String, Boolean>();
        if (dataEntities.length > 0) {
            DynamicObject[] contractBills = new DynamicObject[]{};
            List bills = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
            Set contracts = bills.stream().filter(o -> o.getDynamicObject("contract") != null).map(o -> o.getDynamicObject("contract").getPkValue()).collect(Collectors.toSet());
            if (contracts.size() > 0) {
                QFilter qFilter = new QFilter("id", "in", contracts);
                contractBills = BusinessDataServiceHelper.load((String)"pmct_incontract", (String)String.join((CharSequence)",", "lsttaxrate", "lstavgtaxrate"), (QFilter[])new QFilter[]{qFilter});
            }
            for (DynamicObject bill : bills) {
                DynamicObject contract = bill.getDynamicObject("contract");
                if (contract == null) {
                    validateRateResult.put(bill.getString("billno"), true);
                    continue;
                }
                String contractId = contract.getPkValue().toString();
                if (contractBills.length > 0) {
                    Optional<DynamicObject> first = Arrays.stream(contractBills).filter(o -> StringUtils.equals((CharSequence)contractId, (CharSequence)o.getPkValue().toString())).findFirst();
                    if (first.isPresent()) {
                        contract = first.get();
                    } else {
                        validateRateResult.put(bill.getString("billno"), true);
                        continue;
                    }
                }
                boolean isMultiRate = bill.getBoolean("ismultirate");
                boolean isLastRate = true;
                if (!isMultiRate) {
                    BigDecimal settleRate;
                    BigDecimal contractRate;
                    DynamicObject contractRateDyn = contract.getDynamicObject("lsttaxrate");
                    DynamicObject settleRateDyn = bill.getDynamicObject("taxrate");
                    if (contractRateDyn != null && settleRateDyn != null && (contractRate = contractRateDyn.getBigDecimal("taxrate")).compareTo(settleRate = settleRateDyn.getBigDecimal("taxrate")) != 0) {
                        isLastRate = false;
                    }
                } else {
                    BigDecimal contractAvgRate = contract.getBigDecimal("lstavgtaxrate");
                    BigDecimal settleAvgRate = bill.getBigDecimal("avgtaxrate");
                    if (contractAvgRate != null && settleAvgRate != null && contractAvgRate.compareTo(settleAvgRate) != 0) {
                        isLastRate = false;
                    }
                }
                validateRateResult.put(bill.getString("billno"), isLastRate);
            }
        }
        return validateRateResult;
    }
}

