/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.scm.common.eip.helper.BillCoreHelper;
import kd.scm.common.eip.helper.PurInstockWriteUtilHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.MessageSendUtil;
import kd.scm.common.util.OrderUtil;

public class PurInstockHelper
extends BillCoreHelper {
    private static Log log = LogFactory.getLog(PurInstockHelper.class);
    private static String ENTITY_KEY = "pur_instock";

    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    protected void afterAddEntityTransaction(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.afterAddEntityTransaction(dynamicObjects, headDataMap, entryDataMap);
    }

    protected DynamicObject setHeadDefaultProperties(DynamicObject obj) {
        obj = super.setHeadDefaultProperties(obj);
        obj.set("cfmstatus", (Object)ConfirmStatusEnum.CONFIRM.getVal());
        return obj;
    }

    protected String getSelectfields(Set<String> keySet) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append(super.getSelectfields(keySet));
        selectFields.append(',').append("iscentersettle");
        return selectFields.toString();
    }

    protected String getEntrySelectfields(Set<String> keySet, String str) {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append(super.getEntrySelectfields(keySet, str));
        selectFields.append(',').append("purtype").append('.').append("id");
        selectFields.append(',').append("sumcheckqty");
        return selectFields.toString();
    }

    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.beforeAddEntity(dynamicObjects, headDataMap, entryDataMap);
        ArrayList<DynamicObject> newDynamicObjects = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String billno = dynamicObject.getString(this.getBillNumber());
            if (!"1".equals(headDataMap.get(billno.toLowerCase()).get("type"))) {
                newDynamicObjects.add(dynamicObject);
            }
            if (dynamicObject.getPkValue() != null && (Long)dynamicObject.getPkValue() != 0L) continue;
            if ("1".equals(headDataMap.get(billno.toLowerCase()).get("hasvirtual"))) {
                dynamicObject.set("iscentersettle", (Object)"1");
            } else {
                dynamicObject.set("iscentersettle", (Object)"0");
            }
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                entry.set("srcbillid", headDataMap.get(billno.toLowerCase()).get("id"));
            }
        }
        BizLog.log((String)("@\u5165\u5e93\u5355\u540c\u6b65purinstockhelper=======>newDynamicObjects.size():" + newDynamicObjects.size()));
        OrderUtil.setPurTypeByOrder(dynamicObjects, headDataMap, entryDataMap, (String)this.getEntryKey());
        this.sumInstockAmount(dynamicObjects);
    }

    protected void sumInstockAmount(List<DynamicObject> dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            BigDecimal sumTax = BigDecimal.ZERO;
            BigDecimal sumTaxAmount = BigDecimal.ZERO;
            DynamicObjectCollection materialColl = dynamicObject.getDynamicObjectCollection(this.getEntryKey());
            for (DynamicObject material : materialColl) {
                sumTaxAmount = sumTaxAmount.add(CommonUtil.getBigDecimalPro((Object)material.get("taxamount")));
                sumTax = sumTax.add(CommonUtil.getBigDecimalPro((Object)material.get("tax")));
            }
            dynamicObject.set("sumtax", (Object)sumTax);
            dynamicObject.set("sumtaxamount", (Object)sumTaxAmount);
        }
    }

    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.afterAddEntity(dynamicObjects, headDataMap, entryDataMap);
        List writeBackDynamicObjects = OrderUtil.getWriteBackObjesByOrder(dynamicObjects, headDataMap, (String)this.getEntryKey());
        PurInstockWriteUtilHelper.writeBackSrcBill(writeBackDynamicObjects, headDataMap, entryDataMap, ENTITY_KEY, "audit");
        HashMap<String, String> extraMap = new HashMap<String, String>(3);
        StringBuilder content = new StringBuilder();
        Map inStockOfSal = MessageSendUtil.getAllSalOutStockBill(dynamicObjects);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Set idOfBiLL = (Set)inStockOfSal.get(dynamicObject.getString("id"));
            Iterator stringIterator = idOfBiLL.iterator();
            extraMap.put("tplScene", "purinstockquery");
            extraMap.put("orgScopeType", "rcvorgscope");
            extraMap.put("title", ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6548\u8bf7\u67e5\u8be2\u3002", (String)"PurInstockHelper_0", (String)"scm-common", (Object[])new Object[0]));
            StringBuilder salBillNo = new StringBuilder();
            while (stringIterator.hasNext()) {
                salBillNo.append((String)stringIterator.next()).append('\u3001');
            }
            content.append(ResManager.loadKDString((String)"\u5df2\u7ecf\u751f\u6548\uff0c\u8bf7\u767b\u5f55\u7cfb\u7edf\u8fdb\u884c\u5165\u5e93\u67e5\u8be2\u3002", (String)"PurInstockHelper_1", (String)"scm-common", (Object[])new Object[0]));
            if (salBillNo.length() > 0) {
                content.append(MessageFormat.format(ResManager.loadKDString((String)"\u672c\u6b21\u5904\u7406\u7684\u53d1\u8d27\u5355\u5982\u4e0b\uff1a{0}", (String)"PurInstockHelper_2", (String)"scm-common", (Object[])new Object[0]), salBillNo.subSequence(0, salBillNo.length() - 1)));
            }
            extraMap.put("content", content.toString());
            MessageSendUtil.send((DynamicObject)dynamicObject, extraMap);
        }
    }

    protected boolean isHasOrder(List<DynamicObject> objs) {
        DynamicObjectCollection cols;
        HashSet<String> poIdSet = new HashSet<String>();
        for (DynamicObject obj : objs) {
            cols = obj.getDynamicObjectCollection(this.getEntryKey());
            for (DynamicObject col : cols) {
                String poBillId = col.getString("pobillid");
                if (null == poBillId || poBillId.isEmpty()) continue;
                poIdSet.add(poBillId);
            }
        }
        String selectFields = "billno,id";
        QFilter filter = new QFilter("materialentry.pobillid", "in", poIdSet);
        cols = ORM.create().query("pur_order", selectFields, new QFilter[]{filter});
        if (cols.size() != poIdSet.size()) {
            // empty if block
        }
        return true;
    }
}

