/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.SaloutUtil;
import kd.scm.common.util.WriteBackUtil;
import kd.scm.common.util.check.CheckRelationUtil;
import kd.scm.common.util.check.CheckWriteDataEntity;

public class PurInstockWriteUtilHelper {
    private static Log log = LogFactory.getLog(PurInstockWriteUtilHelper.class);

    public static void writeBackSrcBill(List<DynamicObject> objs, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap, String entityKey, String operation) {
        ArrayList<Long> srcEntryIdList = new ArrayList<Long>(entryDataMap.size());
        ArrayList<Object> poEntryIdList = new ArrayList<Object>();
        HashMap<String, BigDecimal> srcEntryId_qtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, Map<String, Object>> srcEntryId_entryMap = new HashMap<String, Map<String, Object>>();
        Map objsMap = DynamicObjectUtil.arraysToMap(objs, (String)"materialentry", (String)"srcentryid");
        ArrayList<Object> poEntryIdListByNoSrcEntryId = new ArrayList<Object>();
        for (Map.Entry<String, Map<String, Object>> entry : entryDataMap.entrySet()) {
            DynamicObject instockEntry;
            Object instockEntryId = entry.getValue().get("srcentryid");
            if (null == instockEntryId || null == (instockEntry = (DynamicObject)objsMap.get(instockEntryId.toString()))) continue;
            srcEntryId_entryMap.putIfAbsent(instockEntryId.toString(), entry.getValue());
            Object saloutentryid = entry.getValue().get("saloutentryid");
            Object poEntryId = entry.getValue().get("poentryid");
            if (null != poEntryId) {
                poEntryIdList.add(poEntryId);
            }
            if (null == saloutentryid) {
                if (null == poEntryId) continue;
                poEntryIdListByNoSrcEntryId.add(poEntryId);
                continue;
            }
            String srcEntryIdStr = String.valueOf(saloutentryid);
            if (srcEntryIdStr.isEmpty() || Long.valueOf(srcEntryIdStr).equals(0L)) {
                if (null == poEntryId) continue;
                poEntryIdListByNoSrcEntryId.add(poEntryId);
                continue;
            }
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)instockEntry.get("basicqty"));
            if (null != srcEntryId_qtyMap.get(srcEntryIdStr)) {
                srcEntryId_qtyMap.put(srcEntryIdStr, ((BigDecimal)srcEntryId_qtyMap.get(srcEntryIdStr)).add(qty));
            } else {
                srcEntryId_qtyMap.put(srcEntryIdStr, qty);
            }
            srcEntryIdList.add(Long.valueOf(srcEntryIdStr));
        }
        log.info("PurReceiptHelper#writeBackSrcBill#srcEntryId_qtyMap" + srcEntryId_qtyMap);
        log.info("PurReceiptHelper#writeBackSrcBill#srcEntryIdList" + srcEntryIdList);
        log.info("PurReceiptHelper#writeBackSrcBill#srcEntryId_entryMap" + srcEntryId_entryMap);
        if (srcEntryIdList.size() > 0) {
            HashMap<String, List<String>> proListMap = new HashMap<String, List<String>>(1);
            ArrayList<String> proList = new ArrayList<String>();
            proList.clear();
            proList.add("suminstockbaseqty");
            proListMap.put("materialentry", proList);
            WriteBackUtil.writeBackBill("scp_saloutstock", proListMap, srcEntryIdList, srcEntryId_qtyMap, operation);
            CheckRelationUtil.createCheckRelation(objs, srcEntryId_entryMap, (String)entityKey, (String)"materialentry");
        }
        if (poEntryIdListByNoSrcEntryId.size() > 0) {
            PurInstockWriteUtilHelper.writeBackOrderByInstockByNoSrcEntryId(objs, headDataMap, entryDataMap, poEntryIdListByNoSrcEntryId, entityKey, operation);
        }
        if (poEntryIdList.size() > 0) {
            PurInstockWriteUtilHelper.writeBackOrderByInstock(objs, headDataMap, entryDataMap, poEntryIdList, operation);
        }
    }

    private static void writeBackOrderByInstockByNoSrcEntryId(List<DynamicObject> objs, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap, List<Object> poEntryIdList, String entityKey, String operation) {
        CheckWriteDataEntity writeData = new CheckWriteDataEntity();
        for (DynamicObject obj : objs) {
            DynamicObjectCollection cols = obj.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : cols) {
                String saloutentryidStr;
                Object saloutentryid;
                String srcPoEntryIdStr;
                Object srcPoEntryId = entry.get("poentryid");
                if (null == srcPoEntryId || (srcPoEntryIdStr = String.valueOf(srcPoEntryId)).isEmpty() || null != (saloutentryid = entry.get("saloutentryid")) && !(saloutentryidStr = String.valueOf(saloutentryid)).isEmpty() && !Long.valueOf(saloutentryidStr).equals(0L)) continue;
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.get("basicqty"));
                writeData.setWriteData(srcPoEntryIdStr, entry.getPkValue().toString(), qty);
                writeData.setEntryIdBillIdMap(entry.getPkValue().toString(), obj.getPkValue().toString());
                writeData.setSrcEntityKey(entityKey);
                writeData.setTarEntityKey("pur_saloutstock");
            }
        }
        SaloutUtil.updateReciptQtyOrInstockQty(writeData, "suminstockbaseqty", operation);
    }

    private static void writeBackOrderByInstock(List<DynamicObject> objs, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap, List<Object> poEntryIdList, String operation) {
        ArrayList<Long> srcEntryIdList = new ArrayList<Long>();
        HashMap<String, BigDecimal> srcEntryId_qtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, DynamicObject> orderEntryMap = new HashMap<String, DynamicObject>();
        if (poEntryIdList.size() > 0) {
            DynamicObjectCollection srcBillObjects = OrderUtil.querySrcBillInfo(poEntryIdList);
            Iterator iterator = srcBillObjects.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                orderEntryMap.put(dynamicObject.getString("poentryid"), dynamicObject);
            }
        }
        for (DynamicObject obj : objs) {
            DynamicObjectCollection cols = obj.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : cols) {
                String srcEntryIdStr;
                Object srcPoEntryId = entry.get("poentryid");
                if (null == srcPoEntryId || (srcEntryIdStr = String.valueOf(srcPoEntryId)).isEmpty()) continue;
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.get("basicqty"));
                DynamicObject poBillEntry = (DynamicObject)orderEntryMap.get(srcEntryIdStr);
                String poEntryId = null;
                if (poBillEntry == null) continue;
                poEntryId = poBillEntry.getString("entryId");
                if (null != srcEntryId_qtyMap.get(poEntryId)) {
                    srcEntryId_qtyMap.put(poEntryId, ((BigDecimal)srcEntryId_qtyMap.get(poEntryId)).add(qty));
                } else {
                    srcEntryId_qtyMap.put(poEntryId, qty);
                }
                srcEntryIdList.add(Long.valueOf(poEntryId));
            }
        }
        if (!srcEntryIdList.isEmpty()) {
            HashMap<String, List<String>> proListMap = new HashMap<String, List<String>>(1);
            ArrayList<String> proList = new ArrayList<String>();
            proList.add("suminstockbaseqty");
            proListMap.put("materialentry", proList);
            WriteBackUtil.writeBackBillForPurOrder("pur_order", proListMap, srcEntryIdList, srcEntryId_qtyMap, operation);
        }
    }
}

