/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.SaloutUtil;

public final class WriteBackUtil {
    private static Log log = LogFactory.getLog(WriteBackUtil.class);
    private static final String HEAD = "head";

    public static void writeBackSaloutBill(String entityKey, List<Long> entryIdList, Map<String, BigDecimal> srcEntryId_qtyMap, String operation) {
        DynamicObject[] col;
        String selectFields = "id,billno,billstatus,materialentry,materialentry.qty,materialentry.sumreceiptqty";
        HashMap params = new HashMap();
        if (!entryIdList.isEmpty()) {
            HashMap<String, List<Long>> entryParam = new HashMap<String, List<Long>>();
            entryParam.put("in", entryIdList);
            params.put("materialentry.id", entryParam);
            HashMap<String, String> statusParam = new HashMap<String, String>();
            statusParam.put("=", "A");
            params.put("materialentry.entrystatus", statusParam);
            if ("audit".equals(operation)) {
                HashMap<String, String> qtyParam = new HashMap<String, String>();
                qtyParam.put("of", "materialentry.qty>materialentry.sumreceiptqty");
                params.put("materialentry.qty", qtyParam);
            }
        } else {
            return;
        }
        for (DynamicObject bill : col = ORMUtil.load((String)entityKey, (String)selectFields, params)) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                Long entryId = (Long)entry.getPkValue();
                if (!entryIdList.contains(entryId)) continue;
                BigDecimal recieveQty = CommonUtil.getBigDecimalPro((Object)srcEntryId_qtyMap.get(String.valueOf(entryId)));
                BigDecimal sumReceiveQty = CommonUtil.getBigDecimalPro((Object)entry.get("sumreceiptqty"));
                if (recieveQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                if ("audit".equals(operation)) {
                    entry.set("sumreceiptqty", (Object)recieveQty.add(sumReceiveQty));
                    continue;
                }
                if ("delete".equals(operation)) {
                    entry.set("sumreceiptqty", (Object)sumReceiveQty.subtract(recieveQty));
                    continue;
                }
                entry.set("sumreceiptqty", (Object)recieveQty.add(sumReceiveQty));
            }
        }
        if (col.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])col);
        }
    }

    public static void writeBackBill(String entityKey, Map<String, List<String>> proListMap, List<Long> entryIdList, Map<String, BigDecimal> srcEntryId_qtyMap, String operation) {
        StringBuilder selectFields = new StringBuilder();
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        log.info("entryIdList" + entryIdList);
        if (!entryIdList.isEmpty()) {
            HashMap<String, List<Long>> entryParam = new HashMap<String, List<Long>>(1);
            entryParam.put("in", entryIdList);
            params.put("materialentry.id", entryParam);
            WriteBackUtil.assembleSelectFieldsAndParams(proListMap, selectFields, params, operation);
            log.info("###WriteBackUtil params:" + params);
            if (!params.isEmpty()) {
                selectFields.append(",").append("materialentry.material");
                selectFields.append(",").append("materialentry.unit");
                selectFields.append(",").append("materialentry.basicunit");
                List<String> proList = proListMap.get("materialentry");
                for (String pro : proList) {
                    if ("sumreceiptbaseqty".equals(pro)) {
                        selectFields.append(",materialentry.sumreceiptqty");
                        continue;
                    }
                    if ("suminstockbaseqty".equals(pro)) {
                        selectFields.append(",materialentry.suminstockqty");
                        continue;
                    }
                    if ("sumreceiptqty".equals(pro)) {
                        selectFields.append(",materialentry.sumreceiptbaseqty");
                        continue;
                    }
                    if (!"suminstockqty".equals(pro)) continue;
                    selectFields.append(",materialentry.suminstockbaseqty");
                }
                DynamicObject[] dynamicObjectSave = ORMUtil.load((String)entityKey, (String)selectFields.toString(), params);
                ArrayList<Object> pkList = new ArrayList<Object>(dynamicObjectSave.length);
                for (DynamicObject bill : dynamicObjectSave) {
                    pkList.add(bill.getPkValue());
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("materialentry");
                    for (DynamicObject entry : entrys) {
                        DynamicObject materialObj = entry.getDynamicObject("material");
                        DynamicObject unitObj = entry.getDynamicObject("unit");
                        DynamicObject basicUnitObj = entry.getDynamicObject("basicunit");
                        Long entryId = (Long)entry.getPkValue();
                        if (!entryIdList.contains(entryId)) continue;
                        if (entityKey.equals("pur_saloutstock") || entityKey.equals("scp_saloutstock")) {
                            WriteBackUtil.writeBackSalProVal(entry, proListMap, entryId, srcEntryId_qtyMap, operation);
                        } else {
                            WriteBackUtil.writeBackProVal(entry, proListMap, entryId, srcEntryId_qtyMap, operation);
                        }
                        for (String pro : proList) {
                            WriteBackUtil.setBaseQty(pro, entry, materialObj, unitObj, basicUnitObj);
                        }
                    }
                }
                if (dynamicObjectSave.length > 0) {
                    SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynamicObjectSave);
                    if (entityKey.equals("pur_order") || entityKey.equals("scp_order")) {
                        log.info("###WriteBackUtil order updateOrderCfmStatusByPks:" + CommonUtil.objs2str((Object[])pkList.toArray()));
                        OrderUtil.updateOrderCfmStatusByPks((Object[])pkList.toArray(), (String)entityKey);
                    } else if (entityKey.equals("pur_saloutstock") || entityKey.equals("scp_saloutstock")) {
                        log.info("###WriteBackUtil saloutStock updateCfmStatusByPks:" + CommonUtil.objs2str((Object[])pkList.toArray()));
                        SaloutUtil.updateCfmStatusByPks(pkList.toArray(), entityKey);
                    }
                }
            }
        } else {
            log.info("entryIdList" + entryIdList);
            log.info("srcEntryId_qtyMap" + srcEntryId_qtyMap);
        }
    }

    private static void setBaseQty(String pro, DynamicObject col, DynamicObject materialObj, DynamicObject unitObj, DynamicObject basicUnitObj) {
        if ("sumreceiptbaseqty".equals(pro)) {
            BigDecimal sumreceiptbaseqty = col.getBigDecimal(pro);
            BigDecimal sumreceiptqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)basicUnitObj, (BigDecimal)sumreceiptbaseqty, (DynamicObject)unitObj);
            col.set("sumreceiptqty", (Object)sumreceiptqty);
        } else if ("sumreceiptqty".equals(pro)) {
            BigDecimal sumreceiptqty = col.getBigDecimal(pro);
            BigDecimal sumreceiptbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumreceiptqty, (DynamicObject)basicUnitObj);
            col.set("sumreceiptbaseqty", (Object)sumreceiptbaseqty);
        } else if ("suminstockbaseqty".equals(pro)) {
            BigDecimal suminstockbaseqty = col.getBigDecimal(pro);
            BigDecimal suminstockqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)basicUnitObj, (BigDecimal)suminstockbaseqty, (DynamicObject)unitObj);
            col.set("suminstockqty", (Object)suminstockqty);
        } else if ("suminstockqty".equals(pro)) {
            BigDecimal suminstockqty = col.getBigDecimal(pro);
            BigDecimal suminstockbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)suminstockqty, (DynamicObject)basicUnitObj);
            col.set("suminstockbaseqty", (Object)suminstockbaseqty);
        }
    }

    public static void writeBackBillForPurOrder(String entityKey, Map<String, List<String>> proListMap, List<Long> entryIdList, Map<String, BigDecimal> srcEntryId_qtyMap, String operation) {
        StringBuilder selectFields = new StringBuilder();
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        log.info("writeBackBillForPurOrder:entryIdList&srcEntryId_qtyMap=" + entryIdList + "&" + srcEntryId_qtyMap.toString());
        if (!entryIdList.isEmpty()) {
            HashMap<String, List<Long>> entryParam = new HashMap<String, List<Long>>(1);
            entryParam.put("in", entryIdList);
            params.put("materialentry.id", entryParam);
            WriteBackUtil.assembleSelectFieldsAndParamsForPurOrder(proListMap, selectFields, params, operation);
            log.info("###WriteBackUtil params:" + params);
            if (!params.isEmpty()) {
                boolean poFlag;
                boolean bl = poFlag = "pur_order".equals(entityKey) || "scp_order".equals(entityKey);
                if (poFlag) {
                    selectFields.append(",materialentry.sumreceiptbaseqty,materialentry.suminstockbaseqty,materialentry.sumrecretbaseqty,materialentry.suminstockretbaseqty");
                    selectFields.append(",materialentry.material,materialentry.unit,materialentry.basicunit,materialentry.poentryid,materialentry.linetype");
                    List<String> proList = proListMap.get("materialentry");
                    for (String pro : proList) {
                        if ("sumreceiptbaseqty".equals(pro)) {
                            selectFields.append(",materialentry.sumreceiptqty");
                            continue;
                        }
                        if (!"suminstockbaseqty".equals(pro)) continue;
                        selectFields.append(",materialentry.suminstockqty");
                    }
                }
                DynamicObject[] dynamicObjectSave = ORMUtil.load((String)entityKey, (String)selectFields.toString(), params);
                ArrayList<Object> pkList = new ArrayList<Object>(dynamicObjectSave.length);
                for (DynamicObject bill : dynamicObjectSave) {
                    pkList.add(bill.getPkValue());
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("materialentry");
                    for (DynamicObject entry : entrys) {
                        DynamicObject materialObj = entry.getDynamicObject("material");
                        DynamicObject unitObj = entry.getDynamicObject("unit");
                        DynamicObject basicUnitObj = entry.getDynamicObject("basicunit");
                        Long entryId = (Long)entry.getPkValue();
                        if (entryIdList.contains(entryId)) {
                            WriteBackUtil.writeBackProVal(entry, proListMap, entryId, srcEntryId_qtyMap, operation);
                        }
                        if (!poFlag) continue;
                        List<String> proList = proListMap.get("materialentry");
                        for (String pro : proList) {
                            BigDecimal sumreceiptbaseqty;
                            if ("sumreceiptbaseqty".equals(pro)) {
                                BigDecimal sumreceiptbaseqty2 = entry.getBigDecimal(pro);
                                BigDecimal sumreceiptqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)basicUnitObj, (BigDecimal)sumreceiptbaseqty2, (DynamicObject)unitObj);
                                entry.set("sumreceiptqty", (Object)sumreceiptqty);
                                continue;
                            }
                            if ("sumreceiptqty".equals(pro)) {
                                BigDecimal sumreceiptqty = entry.getBigDecimal(pro);
                                sumreceiptbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumreceiptqty, (DynamicObject)basicUnitObj);
                                entry.set("sumreceiptbaseqty", (Object)sumreceiptbaseqty);
                                continue;
                            }
                            if ("suminstockbaseqty".equals(pro)) {
                                BigDecimal suminstockbaseqty = entry.getBigDecimal(pro);
                                BigDecimal suminstockqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)basicUnitObj, (BigDecimal)suminstockbaseqty, (DynamicObject)unitObj);
                                entry.set("suminstockqty", (Object)suminstockqty);
                                continue;
                            }
                            if ("suminstockqty".equals(pro)) {
                                BigDecimal suminstockqty = entry.getBigDecimal(pro);
                                BigDecimal suminstockbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)suminstockqty, (DynamicObject)basicUnitObj);
                                entry.set("suminstockbaseqty", (Object)suminstockbaseqty);
                                continue;
                            }
                            if ("sumrecretbaseqty".equals(pro)) {
                                BigDecimal sumrecretbaseqty = entry.getBigDecimal(pro);
                                BigDecimal sumrecretqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)basicUnitObj, (BigDecimal)sumrecretbaseqty, (DynamicObject)unitObj);
                                entry.set("sumrecretqty", (Object)sumrecretqty);
                                continue;
                            }
                            if ("sumrecretqty".equals(pro)) {
                                BigDecimal sumrecretqty = entry.getBigDecimal(pro);
                                sumreceiptbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrecretqty, (DynamicObject)basicUnitObj);
                                entry.set("sumreceiptbaseqty", (Object)sumreceiptbaseqty);
                                continue;
                            }
                            if ("suminstockretbaseqty".equals(pro)) {
                                BigDecimal suminstockretbaseqty = entry.getBigDecimal(pro);
                                BigDecimal suminstockretqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)basicUnitObj, (BigDecimal)suminstockretbaseqty, (DynamicObject)unitObj);
                                entry.set("suminstockretqty", (Object)suminstockretqty);
                                continue;
                            }
                            if (!"suminstockretqty".equals(pro)) continue;
                            BigDecimal suminstockretqty = entry.getBigDecimal(pro);
                            BigDecimal suminstockretbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)suminstockretqty, (DynamicObject)basicUnitObj);
                            entry.set("suminstockretbaseqty", (Object)suminstockretbaseqty);
                        }
                    }
                }
                if (dynamicObjectSave.length > 0) {
                    SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynamicObjectSave);
                    if (entityKey.equals("pur_order") || entityKey.equals("scp_order")) {
                        log.info("###WriteBackUtil order updateOrderCfmStatusByPks:" + CommonUtil.objs2str((Object[])pkList.toArray()));
                        OrderUtil.updateOrderCfmStatusByPks((Object[])pkList.toArray(), (String)entityKey);
                    } else if (entityKey.equals("pur_saloutstock") || entityKey.equals("scp_saloutstock")) {
                        log.info("###WriteBackUtil saloutStock updateCfmStatusByPks:" + CommonUtil.objs2str((Object[])pkList.toArray()));
                        SaloutUtil.updateCfmStatusByPks(pkList.toArray(), entityKey);
                    }
                }
            }
        } else {
            log.info("entryIdList" + entryIdList);
            log.info("srcEntryId_qtyMap" + srcEntryId_qtyMap);
        }
    }

    public static void writeBackBillByReturnAdd(String entityKey, Map<String, List<String>> proListMap, List<Long> entryIdList, Map<String, BigDecimal> srcEntryId_qtyMap, String operation) {
        StringBuilder selectFields = new StringBuilder();
        HashMap<String, Map<String, Object>> oldparams = new HashMap<String, Map<String, Object>>();
        HashMap params = new HashMap();
        log.info("writeBackBillByReturnAdd:entryIdList&srcEntryId_qtyMap=" + entryIdList + "&" + srcEntryId_qtyMap.toString());
        if (!entryIdList.isEmpty()) {
            HashMap<String, List<Long>> entryParam = new HashMap<String, List<Long>>(1);
            entryParam.put("in", entryIdList);
            params.put("materialentry.id", entryParam);
            WriteBackUtil.assembleSelectFieldsAndParamsForPurOrder(proListMap, selectFields, oldparams, operation);
            log.info("###WriteBackUtil params:" + params);
            if (!params.isEmpty()) {
                boolean poFlag;
                boolean bl = poFlag = "pur_order".equals(entityKey) || "scp_order".equals(entityKey);
                if (poFlag) {
                    selectFields.append(",materialentry.sumreceiptbaseqty,materialentry.suminstockbaseqty,materialentry.sumrefundqty,materialentry.sumrefundbaseqty");
                    selectFields.append(",materialentry.sumrecretbaseqty,materialentry.suminstockretbaseqty,materialentry.sumrefundqty,materialentry.sumrefundbaseqty");
                    selectFields.append(",materialentry.material,materialentry.unit,materialentry.basicunit,materialentry.poentryid");
                    List<String> proList = proListMap.get("materialentry");
                    for (String pro : proList) {
                        if ("sumrecretqty".equals(pro)) {
                            selectFields.append(",materialentry.sumreceiptqty");
                            continue;
                        }
                        if (!"suminstockretqty".equals(pro)) continue;
                        selectFields.append(",materialentry.suminstockqty");
                    }
                }
                DynamicObject[] dynamicObjectSave = ORMUtil.load((String)entityKey, (String)selectFields.toString(), params);
                ArrayList<Object> pkList = new ArrayList<Object>(dynamicObjectSave.length);
                for (DynamicObject bill : dynamicObjectSave) {
                    pkList.add(bill.getPkValue());
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("materialentry");
                    for (DynamicObject entry : entrys) {
                        Long entryId = (Long)entry.getPkValue();
                        if (entryIdList.contains(entryId)) {
                            WriteBackUtil.writeBackProVal(entry, proListMap, entryId, srcEntryId_qtyMap, operation);
                        }
                        if (!poFlag) continue;
                        List<String> proList = proListMap.get("materialentry");
                        DynamicObject materialObj = entry.getDynamicObject("material");
                        DynamicObject unitObj = entry.getDynamicObject("unit");
                        DynamicObject basicUnitObj = entry.getDynamicObject("basicunit");
                        for (String pro : proList) {
                            BigDecimal sumrefundbaseqty;
                            BigDecimal sumrefundqty;
                            if ("sumrecretqty".equals(pro)) {
                                BigDecimal sumrecretqty = entry.getBigDecimal(pro);
                                BigDecimal sumrecretbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrecretqty, (DynamicObject)basicUnitObj);
                                entry.set("sumrecretbaseqty", (Object)sumrecretbaseqty);
                                WriteBackUtil.writeBackProVal(entry, "sumrefundqty", entryId, srcEntryId_qtyMap, operation, false);
                                sumrefundqty = entry.getBigDecimal("sumrefundqty");
                                sumrefundbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrefundqty, (DynamicObject)basicUnitObj);
                                entry.set("sumrefundbaseqty", (Object)sumrefundbaseqty);
                                continue;
                            }
                            if ("sumreceiptqty".equals(pro)) {
                                BigDecimal sumreceiptqty = entry.getBigDecimal(pro);
                                BigDecimal sumreceiptbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumreceiptqty, (DynamicObject)basicUnitObj);
                                entry.set("sumreceiptbaseqty", (Object)sumreceiptbaseqty);
                                continue;
                            }
                            if ("suminstockretqty".equals(pro)) {
                                BigDecimal suminstockretqty = entry.getBigDecimal(pro);
                                BigDecimal suminstockretbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)suminstockretqty, (DynamicObject)basicUnitObj);
                                entry.set("suminstockretbaseqty", (Object)suminstockretbaseqty);
                                WriteBackUtil.writeBackProVal(entry, "sumrefundqty", entryId, srcEntryId_qtyMap, operation, false);
                                sumrefundqty = entry.getBigDecimal("sumrefundqty");
                                sumrefundbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)sumrefundqty, (DynamicObject)basicUnitObj);
                                entry.set("sumrefundbaseqty", (Object)sumrefundbaseqty);
                                continue;
                            }
                            if (!"suminstockqty".equals(pro)) continue;
                            BigDecimal suminstockqty = entry.getBigDecimal(pro);
                            BigDecimal suminstockbaseqty = CommonUtil.getDesQtyConv((DynamicObject)materialObj, (DynamicObject)unitObj, (BigDecimal)suminstockqty, (DynamicObject)basicUnitObj);
                            entry.set("suminstockbaseqty", (Object)suminstockbaseqty);
                        }
                    }
                }
                if (dynamicObjectSave.length > 0) {
                    SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynamicObjectSave);
                    if (entityKey.equals("pur_order") || entityKey.equals("scp_order")) {
                        log.info("###WriteBackUtil order updateOrderCfmStatusByPks:" + CommonUtil.objs2str((Object[])pkList.toArray()));
                        OrderUtil.updateOrderCfmStatusByPks((Object[])pkList.toArray(), (String)entityKey);
                    } else if (entityKey.equals("pur_saloutstock") || entityKey.equals("scp_saloutstock")) {
                        log.info("###WriteBackUtil saloutStock updateCfmStatusByPks:" + CommonUtil.objs2str((Object[])pkList.toArray()));
                        SaloutUtil.updateCfmStatusByPks(pkList.toArray(), entityKey);
                    }
                }
            }
        } else {
            log.info("entryIdList" + entryIdList);
            log.info("srcEntryId_qtyMap" + srcEntryId_qtyMap);
        }
    }

    private static void writeBackProVal(DynamicObject entry, Map<String, List<String>> proListMap, long entryId, Map<String, BigDecimal> srcEntryId_qtyMap, String operation) {
        List<String> proList = proListMap.get("materialentry");
        for (String pro : proList) {
            WriteBackUtil.writeBackProVal(entry, pro, entryId, srcEntryId_qtyMap, operation, false);
        }
    }

    private static void writeBackSalProVal(DynamicObject entry, Map<String, List<String>> proListMap, long entryId, Map<String, BigDecimal> srcEntryId_qtyMap, String operation) {
        List<String> proList = proListMap.get("materialentry");
        for (String pro : proList) {
            WriteBackUtil.writeBackProVal(entry, pro, entryId, srcEntryId_qtyMap, operation, true);
        }
    }

    private static void writeBackProVal(DynamicObject entry, String pro, long entryId, Map<String, BigDecimal> srcEntryId_qtyMap, String operation, Boolean validQty) {
        BigDecimal proValue = CommonUtil.getBigDecimalPro((Object)srcEntryId_qtyMap.get(String.valueOf(entryId)));
        BigDecimal wirtBackQtyPro = CommonUtil.getBigDecimalPro((Object)entry.get(pro));
        log.info("pro&entryId&proValue&wirtBackQtyPro&operation:" + pro + ";" + entryId + ";" + proValue + ";" + wirtBackQtyPro + ";" + operation);
        if (proValue.compareTo(BigDecimal.ZERO) > 0) {
            switch (operation) {
                case "audit": {
                    BigDecimal add = proValue.add(wirtBackQtyPro);
                    if (validQty.booleanValue() && entry.containsProperty("qty")) {
                        BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.get("qty"));
                        if (add.compareTo(qty) > 0) {
                            entry.set(pro, (Object)qty);
                            break;
                        }
                        entry.set(pro, (Object)add);
                        break;
                    }
                    entry.set(pro, (Object)add);
                    break;
                }
                case "delete": {
                    if (wirtBackQtyPro.compareTo(BigDecimal.ZERO) <= 0) break;
                    BigDecimal subtract = wirtBackQtyPro.subtract(proValue);
                    if (subtract.compareTo(BigDecimal.ZERO) <= 0) {
                        entry.set(pro, (Object)BigDecimal.ZERO);
                        break;
                    }
                    entry.set(pro, (Object)subtract);
                    break;
                }
            }
        }
    }

    public static void skipAuditWriteBackBill(String originalKey, Map<String, List<String>> proListMap, List<Long> srcEntryIdList, Map<String, BigDecimal> srcEntryId_qtyMap, String targetKey) {
        BFRowId bfRowId;
        Object bfRow2;
        if (srcEntryIdList.size() == 0) {
            return;
        }
        List bfRowList = BFTrackerServiceHelper.loadSourceRowIds((String)originalKey, (String)"materialentry", (Long[])srcEntryIdList.toArray(new Long[0]));
        ArrayList<Long> srcEntryIds = new ArrayList<Long>();
        ArrayList<Long> srcOrderEntryIds = new ArrayList<Long>();
        HashMap<String, BigDecimal> srcOrderEntryId_qtyMap = new HashMap<String, BigDecimal>(bfRowList.size());
        for (Object bfRow2 : bfRowList) {
            bfRowId = bfRow2.getSId();
            srcEntryIds.add(bfRowId.getEntryId());
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"skipAuditWriteBackBill", (String)"pur_order", (String)"materialentry.id entryid", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", srcEntryIds)}, (String)"id");
        bfRow2 = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                srcOrderEntryIds.add(row.getLong("entryid"));
            }
        }
        catch (Throwable row) {
            bfRow2 = row;
            throw row;
        }
        finally {
            if (dataSet != null) {
                if (bfRow2 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)bfRow2).addSuppressed(row);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        for (Object bfRow2 : bfRowList) {
            String entryIdStr;
            bfRowId = bfRow2.getSId();
            Long entryId = bfRowId.getEntryId();
            BigDecimal entryQty = srcEntryId_qtyMap.get(String.valueOf(bfRow2.getId().getEntryId()));
            if (entryQty == null) {
                entryQty = (BigDecimal)srcOrderEntryId_qtyMap.get(String.valueOf(bfRow2.getId().getEntryId()));
            }
            if (entryQty == null) {
                entryQty = BigDecimal.ZERO;
            }
            if (srcOrderEntryId_qtyMap.containsKey(entryIdStr = String.valueOf(entryId))) {
                srcOrderEntryId_qtyMap.put(entryIdStr, ((BigDecimal)srcOrderEntryId_qtyMap.get(entryIdStr)).add(entryQty));
                continue;
            }
            srcOrderEntryId_qtyMap.put(entryIdStr, entryQty);
        }
        if (srcOrderEntryIds.size() > 0) {
            WriteBackUtil.writeBackBillForPurOrder(targetKey, proListMap, srcOrderEntryIds, srcOrderEntryId_qtyMap, "audit");
        }
    }

    @Deprecated
    public static void saveWriteBackBill(String originalKey, String targetKey, ArrayList<Object> currBillIds) {
    }

    public static void skipUnAuditWriteBackBill(String originalKey, Map<String, List<String>> proListMap, List<Long> srcEntryIdList, Map<String, BigDecimal> srcEntryId_qtyMap, String targetKey) {
        if (srcEntryIdList.size() == 0) {
            return;
        }
        List bfRowList = BFTrackerServiceHelper.loadSourceRowIds((String)originalKey, (String)"materialentry", (Long[])srcEntryIdList.toArray(new Long[0]));
        ArrayList<Long> orderEntryIds = new ArrayList<Long>();
        HashMap<String, BigDecimal> srcOrderEntryId_qtyMap = new HashMap<String, BigDecimal>(bfRowList.size());
        for (BFRow bfRow : bfRowList) {
            String entryIdStr;
            BFRowId bfRowId = bfRow.getSId();
            Long entryId = bfRowId.getEntryId();
            orderEntryIds.add(entryId);
            BigDecimal entryQty = srcEntryId_qtyMap.get(String.valueOf(bfRow.getId().getEntryId()));
            if (entryQty == null) {
                entryQty = BigDecimal.ZERO;
            }
            if (srcOrderEntryId_qtyMap.containsKey(entryIdStr = String.valueOf(entryId))) {
                srcOrderEntryId_qtyMap.put(entryIdStr, ((BigDecimal)srcOrderEntryId_qtyMap.get(entryIdStr)).add(entryQty));
                continue;
            }
            srcOrderEntryId_qtyMap.put(entryIdStr, entryQty);
        }
        if (orderEntryIds.size() > 0) {
            WriteBackUtil.writeBackBillForPurOrder(targetKey, proListMap, orderEntryIds, srcOrderEntryId_qtyMap, "delete");
        }
    }

    private static void assembleSelectFieldsAndParams(Map<String, List<String>> proListMap, StringBuilder selectFields, Map<String, Map<String, Object>> params, String operation) {
        selectFields.append("id,billno,billstatus");
        for (Map.Entry<String, List<String>> entry : proListMap.entrySet()) {
            List<String> proList = entry.getValue();
            String entryKey = entry.getKey();
            if (null == proList || proList.size() <= 0) continue;
            switch (entryKey) {
                case "head": {
                    WriteBackUtil.assemblePro(proList, selectFields);
                    break;
                }
                case "materialentry": 
                case "2": {
                    selectFields.append(',').append(entryKey);
                    WriteBackUtil.assembleEntryPro(entryKey, proList, selectFields);
                    WriteBackUtil.assembleParams(entryKey, proList, operation, params);
                    break;
                }
            }
        }
    }

    private static void assembleSelectFieldsAndParamsForPurOrder(Map<String, List<String>> proListMap, StringBuilder selectFields, Map<String, Map<String, Object>> params, String operation) {
        selectFields.append("id,billno,billstatus");
        for (Map.Entry<String, List<String>> entry : proListMap.entrySet()) {
            List<String> proList = entry.getValue();
            String entryKey = entry.getKey();
            if (null == proList || proList.size() <= 0) continue;
            switch (entryKey) {
                case "head": {
                    WriteBackUtil.assemblePro(proList, selectFields);
                    break;
                }
                case "materialentry": 
                case "2": {
                    selectFields.append(',').append(entryKey);
                    WriteBackUtil.assembleEntryPro(entryKey, proList, selectFields);
                    WriteBackUtil.assembleParamsForPurOrder(entryKey, proList, operation, params);
                    break;
                }
            }
        }
    }

    private static void assembleParamsForPurOrder(String entryKey, List<String> proList, String operation, Map<String, Map<String, Object>> params) {
        for (String pro : proList) {
            if (null == pro || pro.isEmpty() || !"audit".equals(operation)) continue;
            HashMap<String, String> qtyParam = new HashMap<String, String>();
            if ("sumreceiptbaseqty".equals(pro) || "suminstockbaseqty".equals(pro) || "suminstockqty".equals(pro) || "sumreceiptqty".equals(pro)) {
                StringBuilder recQtqSql = new StringBuilder();
                recQtqSql.append(entryKey).append('.').append(pro).append(" < ");
                recQtqSql.append(" ( ").append(entryKey).append('.').append("qty").append(" + ").append(entryKey).append('.').append("sumrefundqty");
                recQtqSql.append(" + ").append(entryKey).append('.').append("sumrejqty").append(" ) ");
                qtyParam.put("of", recQtqSql.toString());
                params.put(entryKey + ".qty", qtyParam);
                continue;
            }
            if ("sumaccepttaxamount".equals(pro)) {
                qtyParam.put("of", entryKey + ".taxamount>" + entryKey + "." + pro);
                params.put(entryKey + ".taxamount", qtyParam);
                continue;
            }
            qtyParam.put("of", entryKey + ".qty>" + entryKey + "." + pro);
            params.put(entryKey + ".qty", qtyParam);
        }
    }

    private static void assemblePro(List<String> proList, StringBuilder selectFields) {
        for (String pro : proList) {
            selectFields.append(',').append(pro);
        }
    }

    private static void assembleEntryPro(String entryKey, List<String> proList, StringBuilder selectFields) {
        for (String pro : proList) {
            if (null == pro || pro.isEmpty()) continue;
            selectFields.append(',').append(entryKey).append('.').append(pro);
        }
    }

    private static void assembleParams(String entryKey, List<String> proList, String operation, Map<String, Map<String, Object>> params) {
        for (String pro : proList) {
            if (null == pro || pro.isEmpty() || !"audit".equals(operation)) continue;
            HashMap<String, String> qtyParam = new HashMap<String, String>();
            qtyParam.put("of", entryKey + ".qty>" + entryKey + "." + pro);
            params.put(entryKey + ".qty", qtyParam);
        }
    }

    public static void partRejWriteBack(List<Object> orderList, List<Object> saloutList, HashMap<String, HashMap<String, Object>> dealDataMap, List<String> inOrRecList, String operate) {
        String selector;
        if (StringUtils.isEmpty((String)operate)) {
            return;
        }
        if (null == orderList) {
            orderList = new ArrayList<Object>();
        }
        if (null == saloutList) {
            saloutList = new ArrayList<Object>();
        }
        HashMap<String, BigDecimal> orderWriteBackMap = new HashMap<String, BigDecimal>(16);
        if (null != dealDataMap && dealDataMap.size() > 0) {
            for (HashMap<String, Object> rejMap : dealDataMap.values()) {
                BigDecimal rejQty;
                Object poEntryIdObj = rejMap.get("poentryid_rej");
                String poEntryId = null == poEntryIdObj ? "" : poEntryIdObj.toString();
                DynamicObject[] rejQtyObj = rejMap.get("rejectqty_rej");
                BigDecimal bigDecimal = rejQty = null == rejQtyObj ? BigDecimal.ZERO : new BigDecimal(rejQtyObj.toString());
                if (orderWriteBackMap.containsKey(poEntryId)) {
                    rejQty = rejQty.add((BigDecimal)orderWriteBackMap.get(poEntryId));
                    orderWriteBackMap.put(poEntryId, rejQty);
                    continue;
                }
                orderWriteBackMap.put(poEntryId, rejQty);
            }
        }
        if ("add".equals(operate)) {
            if (orderList.isEmpty()) {
                return;
            }
            selector = "billno,number,cfmstatus,materialentry.sumrejqty,materialentry.poentryid";
            List orderListStr = orderList.stream().map(String::valueOf).collect(Collectors.toList());
            QFilter prodfilter = new QFilter("materialentry.poentryid", "in", orderListStr);
            DynamicObject[] orderArray = BusinessDataServiceHelper.load((String)"pur_order", (String)selector, (QFilter[])new QFilter[]{prodfilter});
            if (null != orderArray) {
                for (DynamicObject order : orderArray) {
                    DynamicObjectCollection entryCol = order.getDynamicObjectCollection("materialentry");
                    if (null == entryCol || entryCol.size() == 0) continue;
                    BigDecimal rejectqty = BigDecimal.ZERO;
                    for (DynamicObject entry : entryCol) {
                        String pobilentryid = entry.getString("poentryid");
                        rejectqty = (BigDecimal)orderWriteBackMap.get(pobilentryid);
                        if (null == rejectqty || rejectqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                        entry.set("sumrejqty", (Object)entry.getBigDecimal("sumrejqty").add(rejectqty));
                    }
                }
                SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orderArray);
            }
            if (saloutList.isEmpty()) {
                return;
            }
            prodfilter = new QFilter("id", "in", saloutList);
            selector = "id,billno,logstatus,materialentry.rejectreason,materialentry.pobillno,materialentry.qty,materialentry.id,materialentry.poentryid,materialentry.rejectqty,materialentry.rowlogstatus,rejentryentity.entryid_rej,rejentryentity.pobillno_rej,rejentryentity.inbillno_rej,rejentryentity.materialid_rej,rejentryentity.unitid_rej,rejentryentity.rejdate_rej,rejentryentity.rejectqty_rej,rejentryentity.rejectreason_rej,rejentryentity.poentryid_rej,rejentryentity.pobillid_rej";
            DynamicObject[] prodArray = BusinessDataServiceHelper.load((String)"scp_saloutstock", (String)selector, (QFilter[])new QFilter[]{prodfilter});
            Boolean needSetLogRej = null;
            if (null == prodArray || prodArray.length == 0) {
                return;
            }
            for (DynamicObject saloutOrder : prodArray) {
                needSetLogRej = true;
                DynamicObjectCollection entryCol = saloutOrder.getDynamicObjectCollection("materialentry");
                if (null == entryCol || entryCol.size() == 0) continue;
                DynamicObjectCollection rejEntryCol = saloutOrder.getDynamicObjectCollection("rejentryentity");
                DynamicObject rejDataTemp = null;
                for (DynamicObject entry : entryCol) {
                    BigDecimal saloutQty;
                    String pobilentryid = entry.getString("poentryid");
                    String entryid = entry.getString("id");
                    HashMap<String, Object> detailMap = null == dealDataMap.get(entryid) ? dealDataMap.get(pobilentryid) : dealDataMap.get(entryid);
                    if (null == detailMap || detailMap.size() == 0) continue;
                    BigDecimal rejectqty = (BigDecimal)detailMap.get("rejectqty_rej");
                    BigDecimal currentRejQty = entry.getBigDecimal("rejectqty").add(rejectqty);
                    if (currentRejQty.compareTo(saloutQty = entry.getBigDecimal("qty")) != 0) {
                        needSetLogRej = false;
                    }
                    entry.set("rejectqty", (Object)currentRejQty);
                    entry.set("rowlogstatus", (Object)"H");
                    entry.set("rejectreason", detailMap.get("rejectreason_rej"));
                    rejDataTemp = rejEntryCol.addNew();
                    rejDataTemp.set("pobillno_rej", detailMap.get("pobillno_rej"));
                    rejDataTemp.set("inbillno_rej", detailMap.get("inbillno_rej"));
                    rejDataTemp.set("materialid_rej", detailMap.get("materialid_rej"));
                    rejDataTemp.set("rejdate_rej", detailMap.get("rejdate_rej"));
                    rejDataTemp.set("rejectqty_rej", detailMap.get("rejectqty_rej"));
                    rejDataTemp.set("rejectreason_rej", detailMap.get("rejectreason_rej"));
                    rejDataTemp.set("poentryid_rej", detailMap.get("poentryid_rej"));
                    rejDataTemp.set("pobillid_rej", detailMap.get("pobillid_rej"));
                    rejDataTemp.set("unitid_rej", detailMap.get("unitid_rej"));
                }
                if (!needSetLogRej.booleanValue()) continue;
                saloutOrder.set("logstatus", (Object)"H");
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodArray);
        } else if ("delete".equals(operate)) {
            if (null == inOrRecList || inOrRecList.isEmpty()) {
                return;
            }
            selector = "billno,logstatus,materialentry.rejectreason,materialentry.pobillno,materialentry.qty,materialentry.poentryid,materialentry.id,materialentry.rejectqty,rejentryentity.pobillno_rej,rejentryentity.pobillno_rej,rejentryentity.inbillno_rej,rejentryentity.materialid_rej,rejentryentity.unitid_rej,rejentryentity.rejdate_rej,rejentryentity.rejectqty_rej,rejentryentity.rejectreason_rej,rejentryentity.poentryid_rej,rejentryentity.pobillid_rej";
            QFilter prodfilter = new QFilter("materialentry.poentryid", "in", saloutList);
            DynamicObject[] prodArray = BusinessDataServiceHelper.load((String)"scp_saloutstock", (String)selector, (QFilter[])new QFilter[]{prodfilter});
            if (null == prodArray || prodArray.length == 0) {
                return;
            }
            HashMap<String, BigDecimal> writeMap = new HashMap<String, BigDecimal>();
            HashMap<String, Object> rejReasonMap = new HashMap<String, Object>();
            ArrayList<String> orders = new ArrayList<String>();
            BigDecimal tempRejQty = BigDecimal.ZERO;
            for (DynamicObject saloutOrder : prodArray) {
                String pobilentryid;
                DynamicObjectCollection rejEntryCol;
                DynamicObjectCollection entryCol = saloutOrder.getDynamicObjectCollection("materialentry");
                if (null == entryCol || entryCol.isEmpty() || null == (rejEntryCol = saloutOrder.getDynamicObjectCollection("rejentryentity")) || rejEntryCol.isEmpty()) continue;
                ArrayList<DynamicObject> remoArrayList = new ArrayList<DynamicObject>();
                for (DynamicObject entry : rejEntryCol) {
                    pobilentryid = entry.getString("poentryid_rej");
                    String inOrRecNo = entry.getString("inbillno_rej");
                    if (!inOrRecNo.isEmpty() && !inOrRecList.contains(inOrRecNo)) {
                        if (rejReasonMap.containsKey(pobilentryid + "-DATE")) {
                            Date old = (Date)rejReasonMap.get(pobilentryid + "-DATE");
                            Date cur = entry.getDate("rejdate_rej");
                            if (cur.getTime() <= old.getTime()) continue;
                            rejReasonMap.put(pobilentryid + "-REASON", entry.getString("rejectreason_rej"));
                            continue;
                        }
                        rejReasonMap.put(pobilentryid + "-DATE", entry.getDate("rejdate_rej"));
                        rejReasonMap.put(pobilentryid + "-REASON", entry.getString("rejectreason_rej"));
                        continue;
                    }
                    tempRejQty = BigDecimal.ZERO;
                    if (writeMap.containsKey(pobilentryid)) {
                        tempRejQty = (BigDecimal)writeMap.get(pobilentryid);
                    }
                    tempRejQty = tempRejQty.add(entry.getBigDecimal("rejectqty_rej"));
                    writeMap.put(pobilentryid, tempRejQty);
                    orders.add(entry.getString("poentryid_rej"));
                    remoArrayList.add(entry);
                }
                remoArrayList.forEach(v -> rejEntryCol.remove(v));
                for (DynamicObject entry : entryCol) {
                    pobilentryid = entry.getString("poentryid");
                    if (!writeMap.containsKey(pobilentryid)) continue;
                    BigDecimal newQty = entry.getBigDecimal("rejectqty").subtract((BigDecimal)writeMap.get(pobilentryid));
                    if (newQty.compareTo(BigDecimal.ZERO) <= 0) {
                        newQty = BigDecimal.ZERO;
                    }
                    entry.set("rejectqty", (Object)newQty);
                    String newRejReason = rejEntryCol.isEmpty() ? "" : rejReasonMap.get(pobilentryid + "-REASON");
                    entry.set("rejectreason", (Object)newRejReason);
                }
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodArray);
            selector = "billno,number,cfmstatus,materialentry.sumrejqty,materialentry.poentryid";
            prodfilter = new QFilter("materialentry.poentryid", "in", orders);
            DynamicObject[] orderArray = BusinessDataServiceHelper.load((String)"pur_order", (String)selector, (QFilter[])new QFilter[]{prodfilter});
            if (null != orderArray) {
                for (DynamicObject order : orderArray) {
                    DynamicObjectCollection entryCol = order.getDynamicObjectCollection("materialentry");
                    if (null == entryCol || entryCol.size() == 0) continue;
                    for (Iterator entry : entryCol) {
                        String pobilentryid = entry.getString("poentryid");
                        if (!writeMap.containsKey(pobilentryid)) continue;
                        BigDecimal newQty = entry.getBigDecimal("sumrejqty").subtract((BigDecimal)writeMap.get(pobilentryid));
                        if (newQty.compareTo(BigDecimal.ZERO) <= 0) {
                            newQty = BigDecimal.ZERO;
                        }
                        if (null == newQty || newQty.compareTo(BigDecimal.ZERO) < 0) continue;
                        entry.set("sumrejqty", newQty);
                    }
                }
                SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orderArray);
            }
        }
    }
}

