/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.invoice;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.checkmapping.PurCheckMappingUtils;
import kd.scm.common.store.SRMStoreDataTraceHelper;

public class ScpWriteBackUtil {
    public static final Boolean SAVE_OP = Boolean.TRUE;
    public static final Boolean DEL_OP = Boolean.FALSE;
    public static final Boolean NEED_CLEAN_DATA = Boolean.TRUE;
    public static final Boolean UN_NEED_CLEAN_DATA = Boolean.FALSE;
    private static Log log = LogFactory.getLog(ScpWriteBackUtil.class);

    public static void writeBackInvoiceAmtAndQty(List<DynamicObject> dyoList, Boolean flag, Boolean isUpdate) {
        if (null == dyoList || 0 == dyoList.size()) {
            log.info("method:writeBackInvoiceAmtAndQty dyoList is null");
            return;
        }
        HashMap<String, HashMap<String, BigDecimal>> orderMap = new HashMap<String, HashMap<String, BigDecimal>>(1024);
        HashMap inOrRevMap = new HashMap(1024);
        Set deductBill = PurCheckMappingUtils.getDeductBill();
        for (DynamicObject dynamicObject : dyoList) {
            DynamicObjectCollection dyoCol = dynamicObject.getDynamicObjectCollection("entryentity1");
            if (null == dyoCol || dyoCol.size() == 0) continue;
            for (DynamicObject temp : dyoCol) {
                HashMap<String, BigDecimal> inOrRevAmountMap;
                String srcOrderId = temp.getString("poentryid1");
                String srcBillType = temp.getString("srcbilltype1");
                if (StringUtils.isEmpty((CharSequence)srcOrderId)) continue;
                BigDecimal invoiceAmt = temp.getBigDecimal("actchecktaxamount");
                BigDecimal invoiceQty = temp.getBigDecimal("qty1");
                HashMap<String, BigDecimal> orderEntryMap = orderMap.get(srcOrderId);
                if (null == orderEntryMap) {
                    orderEntryMap = new HashMap(1024);
                }
                BigDecimal oldInvoiceAmt = orderEntryMap.get("amount");
                BigDecimal oldInvoiceQty = orderEntryMap.get("qty");
                oldInvoiceAmt = null == oldInvoiceAmt ? invoiceAmt : oldInvoiceAmt.add(invoiceAmt);
                oldInvoiceQty = null == oldInvoiceQty ? invoiceQty : oldInvoiceQty.add(invoiceQty);
                orderEntryMap.put("amount", oldInvoiceAmt);
                orderEntryMap.put("qty", oldInvoiceQty);
                if (!StringUtils.isEmpty((CharSequence)srcBillType) && deductBill.contains(srcBillType)) continue;
                orderMap.put(srcOrderId, orderEntryMap);
                if (StringUtils.isEmpty((CharSequence)srcBillType)) continue;
                String srcEntryId = temp.getString("srcentryid1");
                HashMap inOrRevEntryMap = (HashMap)inOrRevMap.get(srcBillType);
                if (null == inOrRevEntryMap) {
                    inOrRevEntryMap = new HashMap(1024);
                }
                if (null == (inOrRevAmountMap = (HashMap<String, BigDecimal>)inOrRevEntryMap.get(srcEntryId))) {
                    inOrRevAmountMap = new HashMap<String, BigDecimal>(1024);
                }
                BigDecimal oldInvoiceEntryAmt = (BigDecimal)inOrRevAmountMap.get("amount");
                BigDecimal oldInvoiceEntryQty = (BigDecimal)inOrRevAmountMap.get("qty");
                oldInvoiceEntryAmt = null == oldInvoiceEntryAmt ? invoiceAmt : oldInvoiceEntryAmt.add(invoiceAmt);
                oldInvoiceEntryQty = null == oldInvoiceEntryQty ? invoiceQty : oldInvoiceEntryQty.add(invoiceQty);
                inOrRevAmountMap.put("amount", oldInvoiceEntryAmt);
                inOrRevAmountMap.put("qty", oldInvoiceEntryQty);
                inOrRevEntryMap.put(srcEntryId, inOrRevAmountMap);
                inOrRevMap.put(srcBillType, inOrRevEntryMap);
            }
        }
        if (isUpdate.booleanValue()) {
            ScpWriteBackUtil.writeBack("pur_order", orderMap, flag, NEED_CLEAN_DATA);
            for (Map.Entry entry : inOrRevMap.entrySet()) {
                ScpWriteBackUtil.writeBack((String)entry.getKey(), (HashMap)entry.getValue(), flag, NEED_CLEAN_DATA);
            }
        }
        ScpWriteBackUtil.writeBack("pur_order", orderMap, flag, UN_NEED_CLEAN_DATA);
        for (Map.Entry entry : inOrRevMap.entrySet()) {
            ScpWriteBackUtil.writeBack((String)entry.getKey(), (HashMap)entry.getValue(), flag, UN_NEED_CLEAN_DATA);
        }
    }

    private static void writeBack(String entityKey, HashMap<String, HashMap<String, BigDecimal>> writeBackMap, Boolean flag, Boolean isUpdate) {
        if (StringUtils.isEmpty((CharSequence)entityKey)) {
            log.info("writeBack method failed to execute, cause by empty entityKey");
            return;
        }
        if (null == writeBackMap || writeBackMap.size() == 0) {
            log.info("writeBack method failed to execute, cause by empty writeBackMap");
            return;
        }
        QFilter filter = null;
        String queryStr = "billno,billstatus,materialentry.id, materialentry.qty, materialentry.taxamount,materialentry.invoiceqty,materialentry.invoiceamt";
        if ("pur_order".equals(entityKey) || "scp_order".equals(entityKey)) {
            filter = new QFilter("materialentry.poentryid", "in", writeBackMap.keySet());
            queryStr = "billno,billstatus,materialentry.id, materialentry.poentryid, materialentry.qty, materialentry.taxamount,materialentry.invoiceqty,materialentry.invoiceamt";
        } else {
            Set writeBackSet = writeBackMap.keySet().stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet());
            filter = new QFilter("materialentry.id", "in", writeBackSet);
        }
        DynamicObject[] dyoList = BusinessDataServiceHelper.load((String)entityKey, (String)queryStr, (QFilter[])new QFilter[]{filter});
        if (null == dyoList || dyoList.length == 0) {
            log.info("writeBack method failed to execute, cause by empty db query result");
            return;
        }
        for (DynamicObject temp : dyoList) {
            DynamicObjectCollection cols = temp.getDynamicObjectCollection("materialentry");
            if (null == cols || cols.size() == 0) continue;
            for (DynamicObject col : cols) {
                HashMap<String, BigDecimal> amtOrQtyMap;
                if (isUpdate.booleanValue()) {
                    col.set("invoiceamt", (Object)BigDecimal.ZERO);
                    col.set("invoiceqty", (Object)BigDecimal.ZERO);
                    continue;
                }
                BigDecimal oldAmt = col.getBigDecimal("invoiceamt");
                BigDecimal oldQty = col.getBigDecimal("invoiceqty");
                BigDecimal totalAmt = col.getBigDecimal("taxamount");
                BigDecimal totalQty = col.getBigDecimal("qty");
                String entryId = col.getString("id");
                if ("pur_order".equals(entityKey)) {
                    entryId = col.getString("poentryid");
                }
                if (null == (amtOrQtyMap = writeBackMap.get(entryId)) || amtOrQtyMap.size() == 0) continue;
                BigDecimal originalAmt = amtOrQtyMap.get("amount");
                BigDecimal originalQty = amtOrQtyMap.get("qty");
                BigDecimal amt = BigDecimal.ZERO;
                BigDecimal qty = BigDecimal.ZERO;
                if ("pur_order".equals(entityKey)) {
                    amt = originalAmt;
                    qty = originalQty;
                } else {
                    amt = originalAmt.abs();
                    qty = originalQty.abs();
                }
                if (SAVE_OP.equals(flag)) {
                    if (null != amt) {
                        oldAmt = oldAmt.add(amt);
                    }
                    if (null != qty) {
                        oldQty = oldQty.add(qty);
                    }
                } else if (DEL_OP.equals(flag)) {
                    if (null != amt) {
                        oldAmt = oldAmt.subtract(amt);
                    }
                    if (null != qty) {
                        oldQty = oldQty.subtract(qty);
                    }
                }
                col.set("invoiceamt", (Object)oldAmt);
                col.set("invoiceqty", (Object)oldQty);
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dyoList);
    }

    public static void writeBackSrcBillInvoiceAmtAndQty(List<DynamicObject> dyoList, Boolean flag, Boolean isUpdate) {
        if (null == dyoList || 0 == dyoList.size()) {
            log.info("method:writeBackSrcBillInvoiceAmtAndQty dyoList is null");
            return;
        }
        HashMap inOrRevMap = new HashMap(1024);
        for (DynamicObject dynamicObject : dyoList) {
            DynamicObjectCollection dyoCol = dynamicObject.getDynamicObjectCollection("entryentity1");
            if (null == dyoCol || dyoCol.size() == 0) continue;
            for (DynamicObject temp : dyoCol) {
                HashMap<String, BigDecimal> inOrRevAmountMap;
                BigDecimal invoiceAmt = temp.getBigDecimal("actchecktaxamount");
                BigDecimal invoiceQty = temp.getBigDecimal("qty1");
                String srcBillType = temp.getString("srcbilltype1");
                if (StringUtils.isEmpty((CharSequence)srcBillType)) continue;
                String srcEntryId = temp.getString("srcentryid1");
                HashMap inOrRevEntryMap = (HashMap)inOrRevMap.get(srcBillType);
                if (null == inOrRevEntryMap) {
                    inOrRevEntryMap = new HashMap(1024);
                }
                if (null == (inOrRevAmountMap = (HashMap<String, BigDecimal>)inOrRevEntryMap.get(srcEntryId))) {
                    inOrRevAmountMap = new HashMap<String, BigDecimal>(1024);
                }
                BigDecimal oldInvoiceEntryAmt = (BigDecimal)inOrRevAmountMap.get("amount");
                BigDecimal oldInvoiceEntryQty = (BigDecimal)inOrRevAmountMap.get("qty");
                oldInvoiceEntryAmt = null == oldInvoiceEntryAmt ? invoiceAmt : oldInvoiceEntryAmt.add(invoiceAmt);
                oldInvoiceEntryQty = null == oldInvoiceEntryQty ? invoiceQty : oldInvoiceEntryQty.add(invoiceQty);
                inOrRevAmountMap.put("amount", oldInvoiceEntryAmt);
                inOrRevAmountMap.put("qty", oldInvoiceEntryQty);
                inOrRevEntryMap.put(srcEntryId, inOrRevAmountMap);
                inOrRevMap.put(srcBillType, inOrRevEntryMap);
            }
        }
        for (Map.Entry entry : inOrRevMap.entrySet()) {
            ScpWriteBackUtil.writeBack((String)entry.getKey(), (HashMap)entry.getValue(), flag, UN_NEED_CLEAN_DATA);
        }
    }
}

