/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.k3cloud.util;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import org.json.JSONArray;
import org.json.JSONObject;

public class InvokeHelper {
    protected static IAppCache XKCookival = AppCache.get((String)"XKCookival");
    private static Log log = LogFactory.getLog(InvokeHelper.class);
    public static final String SAVE_OPR = "Save";
    public static final String DELETE_OPR = "Delete";
    public static final String VIEW_OPR = "View";
    public static final String EXECUTEBILLQUERY_OPR = "ExecuteBillQuery";
    public static final String SUBMIT_OPR = "Submit";
    public static final String AUDIT_OPR = "Audit";
    public static final String UNAUDIT_OPR = "UnAudit";
    public static final String STATUSCONVERT_OPR = "StatusConvert";
    private static Map map = new HashMap();

    private static HttpURLConnection initUrlConn(String url, JSONArray paras, String post) throws Exception {
        URL postUrl = new URL(post.concat(url));
        HttpURLConnection connection = (HttpURLConnection)postUrl.openConnection();
        connection.setConnectTimeout(180000);
        String CookieVal = (String)XKCookival.get("XKCookie", String.class);
        if (CookieVal != null) {
            connection.setRequestProperty("Cookie", CookieVal);
        }
        if (!connection.getDoOutput()) {
            connection.setDoOutput(true);
        }
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
        OutputStream outputStream = null;
        FilterOutputStream out = null;
        try {
            outputStream = connection.getOutputStream();
            out = new DataOutputStream(outputStream);
            UUID uuid = UUID.randomUUID();
            int hashCode = uuid.toString().hashCode();
            JSONObject jObj = new JSONObject();
            jObj.put("format", 1);
            jObj.put("useragent", (Object)"ApiClient");
            jObj.put("rid", hashCode);
            jObj.put("parameters", (Object)InvokeHelper.chinaToUnicode(paras.toString()));
            jObj.put("timestamp", (Object)new Date().toString());
            jObj.put("v", (Object)"1.0");
            byte[] bytes = jObj.toString().getBytes("utf-8");
            out.write(bytes);
            ((DataOutputStream)out).flush();
        }
        catch (IOException e) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)e);
            throw new KDException(new ErrorCode("networkerror", e.getMessage()), new Object[]{e});
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return connection;
    }

    public static JSONArray getJsonParam(Map<String, Object> param) throws Exception {
        JSONArray paramlist = new JSONArray();
        JSONObject actionNameMap = new JSONObject();
        actionNameMap.put("actionName", param.remove("actionName"));
        paramlist.put((Object)actionNameMap);
        paramlist.put(param);
        return paramlist;
    }

    private static String getStandardParam(Object param) {
        return JSON.toJSONString((Object)param);
    }

    public static boolean Login(String dbId, String user, String pwd, int lang, String post) throws Exception {
        boolean bResult = false;
        String sUrl = "Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser.common.kdsvc";
        JSONArray jParas = new JSONArray();
        jParas.put((Object)dbId);
        jParas.put((Object)user);
        jParas.put((Object)pwd);
        jParas.put(lang);
        HttpURLConnection connection = InvokeHelper.initUrlConn(sUrl, jParas, post);
        log.info("connection success");
        String key = null;
        int i = 1;
        while ((key = connection.getHeaderFieldKey(i)) != null) {
            String tempCookieVal;
            if (key.equalsIgnoreCase("Set-Cookie") && (tempCookieVal = connection.getHeaderField(i)).startsWith("kdservice-sessionid")) {
                XKCookival.put("XKCookie", (Object)tempCookieVal);
                break;
            }
            ++i;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            log.info(" ============================= ");
            log.info(" Contents of post request ");
            log.info("Contents of post request");
            log.info(" ============================= ");
            while ((line = reader.readLine()) != null) {
                String sResult = new String(line.getBytes(), StandardCharsets.UTF_8);
                log.info(sResult);
                log.info("sResult=" + sResult);
                bResult = line.contains("\"LoginResultType\":1");
            }
            log.info(" ============================= ");
            log.info(" Contents of post request ends ");
            log.info("Contents of post request ends");
            log.info(" ============================= ");
            reader.close();
            connection.disconnect();
        }
        return bResult;
    }

    public static String Save(String formId, String content, String post) throws Exception {
        return InvokeHelper.Invoke(SAVE_OPR, formId, content, post);
    }

    public static String Custome(String formId, JSONArray content, String post) throws Exception {
        return InvokeHelper.InvokeCustome("Custom", formId, content, post);
    }

    public static void View(String formId, String content, String post) throws Exception {
        InvokeHelper.Invoke(VIEW_OPR, formId, content, post);
    }

    public static void Submit(String formId, String content, String post) throws Exception {
        InvokeHelper.Invoke(SUBMIT_OPR, formId, content, post);
    }

    public static void Audit(String formId, String content, String post) throws Exception {
        InvokeHelper.Invoke(AUDIT_OPR, formId, content, post);
    }

    public static void UnAudit(String formId, String content, String post) throws Exception {
        InvokeHelper.Invoke(UNAUDIT_OPR, formId, content, post);
    }

    public static void StatusConvert(String formId, String content, String post) throws Exception {
        InvokeHelper.Invoke(STATUSCONVERT_OPR, formId, content, post);
    }

    public static String invokeStandardOperation(String operation, String formId, Object params, String post) throws Exception {
        String paramStr = InvokeHelper.getStandardParam(params);
        log.info("paramStr=" + paramStr);
        return InvokeHelper.Invoke(operation, formId, paramStr, post);
    }

    private static String Invoke(String deal, String formId, String content, String post) throws Exception {
        String str = null;
        String sUrl = map.get(deal).toString();
        JSONArray jParas = new JSONArray();
        if (null != formId) {
            jParas.put((Object)formId);
        }
        jParas.put((Object)content);
        HttpURLConnection connectionInvoke = InvokeHelper.initUrlConn(sUrl, jParas, post);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connectionInvoke.getInputStream()));){
            String line;
            log.info(" ============================= ");
            log.info(" Contents of post request ");
            log.info(" ============================= ");
            while ((line = reader.readLine()) != null) {
                String sResult = new String(line.getBytes(), StandardCharsets.UTF_8);
                log.info(sResult);
                str = sResult;
            }
            log.info(" ============================= ");
            log.info(" Contents of post request ends ");
            log.info(" ============================= ");
            reader.close();
            connectionInvoke.disconnect();
        }
        return str;
    }

    private static String InvokeCustome(String deal, String formId, Object content, String post) throws Exception {
        String str = null;
        String sUrl = map.get(deal).toString();
        HttpURLConnection connectionInvoke = InvokeHelper.initUrlConn(sUrl, (JSONArray)content, post);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connectionInvoke.getInputStream()));){
            String line;
            log.info(" ============================= ");
            log.info(" Contents of post request ");
            log.info(" ============================= ");
            while ((line = reader.readLine()) != null) {
                String sResult = new String(line.getBytes(), StandardCharsets.UTF_8);
                log.info(sResult);
                str = sResult;
            }
            log.info(" ============================= ");
            log.info(" Contents of post request ends ");
            log.info(" ============================= ");
            reader.close();
            connectionInvoke.disconnect();
            String string = str;
            return string;
        }
    }

    public static String chinaToUnicode(String str) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char chr1 = str.charAt(i);
            if (chr1 >= '\u4e00' && chr1 <= '\u9fa5') {
                result.append("\\u").append(Integer.toHexString(chr1));
                continue;
            }
            result.append(str.charAt(i));
        }
        return result.toString();
    }

    static {
        map.put(SAVE_OPR, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Save.common.kdsvc");
        map.put(DELETE_OPR, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Delete.common.kdsvc");
        map.put(VIEW_OPR, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.View.common.kdsvc");
        map.put(EXECUTEBILLQUERY_OPR, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.ExecuteBillQuery.common.kdsvc");
        map.put(SUBMIT_OPR, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Submit.common.kdsvc");
        map.put(AUDIT_OPR, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Audit.common.kdsvc");
        map.put(UNAUDIT_OPR, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.UnAudit.common.kdsvc");
        map.put(STATUSCONVERT_OPR, "Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.StatusConvert.common.kdsvc");
        map.put("Custom", "Kingdee.K3.SCM.CQ.ServicesStub.DynamicScmService.ProcessRequest.common.kdsvc");
    }
}

