/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamConfigUtil;

public final class BizPartnerUtil {
    private static Log log = LogFactory.getLog(BizPartnerUtil.class);

    private static boolean isEnableChangeSupplier() {
        Object publicValue = SystemParamServiceHelper.loadPublicParameterFromCache((String)"enable_switch_bizpartner");
        boolean enable_switch_bizpartner = false;
        if (null != publicValue) {
            enable_switch_bizpartner = Boolean.parseBoolean(publicValue.toString());
        }
        return enable_switch_bizpartner;
    }

    private static long getCurBizPartner() {
        RequestContext rc = RequestContext.get();
        long bizPartnerId = 0L;
        if (null != rc.getBizPartnerId()) {
            bizPartnerId = rc.getBizPartnerId();
            log.info("\u5f53\u524d\u4f9b\u5e94\u5546\uff1a" + bizPartnerId);
        }
        if (bizPartnerId == 0L && ParamConfigUtil.getCacheBooleanParamConfig((String)"enbleforceBizpartner").booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5c0a\u656c\u7684\u7528\u6237\uff0c\u8bf7\u60a8\u5207\u6362\u5f53\u524d\u5546\u52a1\u4f19\u4f34\u4fe1\u606f\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizPartnerUtil_0", (String)"scm-common", (Object[])new Object[0]));
        }
        return bizPartnerId;
    }

    public static Long getCurSupplierId() {
        Long curBizPartner = BizPartnerUtil.getCurBizPartner();
        DynamicObject supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", (Object)curBizPartner)});
        if (supplier == null) {
            return 0L;
        }
        return supplier.getLong("id");
    }

    @Deprecated
    public static final Map<String, Map<String, Object>> assembleBizPartner() {
        HashMap<String, Map<String, Object>> filterMap = new HashMap<String, Map<String, Object>>(1);
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(1);
        Set<Long> bizPartnerIds = BizPartnerUtil.getBizPartnerIds();
        map.put("in", bizPartnerIds);
        filterMap.put("bizpartner", map);
        return filterMap;
    }

    public static final QFilter assembleQFilterBizPartner() {
        Set<Long> idSet = BizPartnerUtil.getBizPartnerIds();
        return null != idSet && idSet.size() > 0 ? new QFilter("bizpartner", "in", idSet) : new QFilter("bizpartner", "=", (Object)-1);
    }

    public static final boolean bizPartnerIsAdmin() {
        ArrayList pkIds = new ArrayList();
        if (BizPartnerUtil.isEnableChangeSupplier()) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bos_bizpartneruser", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("id", "=", (Object)Long.valueOf(RequestContext.get().getUserId())))}, (String)"bizpartner");){
                dataSet.forEach(row -> pkIds.add(row.getLong("bizpartner")));
            }
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bos_bizpartneruser", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("user", "=", (Object)BizPartnerUtil.getCurBizPartner()))}, (String)"bizpartner");){
            dataSet.forEach(row -> pkIds.add(row.getLong("bizpartner")));
        }
        return pkIds.size() > 0;
    }

    public static final Set<Long> getBizPartnerIds() {
        HashSet<Long> pkIds = new HashSet<Long>();
        if (BizPartnerUtil.isEnableChangeSupplier()) {
            pkIds.add(BizPartnerUtil.getCurBizPartner());
        } else {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bos_bizpartneruser", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()))}, (String)"bizpartner");){
                dataSet.forEach(row -> pkIds.add(row.getLong("bizpartner")));
            }
        }
        return pkIds;
    }

    @Deprecated
    public static final DynamicObjectCollection getBizPartners() {
        HashMap<String, Long> map = new HashMap<String, Long>(1);
        HashMap<String, HashMap<String, Long>> filterMap = new HashMap<String, HashMap<String, Long>>(1);
        if (BizPartnerUtil.isEnableChangeSupplier()) {
            map.put("=", BizPartnerUtil.getCurBizPartner());
            filterMap.put("bizpartner", map);
        } else {
            map.put("=", Long.valueOf(RequestContext.get().getUserId()));
            filterMap.put("user", map);
        }
        String selectFields = "bizpartner.id bizpartner,bizpartner.number bizpartnernumber";
        DynamicObjectCollection bizPartnerUsers = ORMUtil.queryDynamicObjectCollection((String)"bos_bizpartneruser", (String)selectFields, filterMap);
        return null != bizPartnerUsers ? bizPartnerUsers : null;
    }

    @Deprecated
    public static final HashSet<String> getBizPartnerNumber() {
        DynamicObjectCollection bizPartnerUsers = BizPartnerUtil.getBizPartners();
        if (null != bizPartnerUsers && bizPartnerUsers.size() > 0) {
            HashSet<String> numberSet = new HashSet<String>(bizPartnerUsers.size());
            for (DynamicObject dynamicObject : bizPartnerUsers) {
                String number = dynamicObject.getString("bizpartnernumber");
                if (null == number) continue;
                numberSet.add(number);
            }
            return numberSet;
        }
        return null;
    }

    @Deprecated
    public static final HashSet<Long> getBizPartnerId() {
        DynamicObjectCollection bizPartnerUsers = BizPartnerUtil.getBizPartners();
        if (null != bizPartnerUsers && bizPartnerUsers.size() > 0) {
            HashSet<Long> idSet = new HashSet<Long>(bizPartnerUsers.size());
            for (DynamicObject dynamicObject : bizPartnerUsers) {
                Long id = dynamicObject.getLong("bizpartner");
                if (null == id) continue;
                idSet.add(id);
            }
            return idSet;
        }
        return null;
    }

    public static final Long getBizPartnerBySupplier(Object supplierId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)supplierId, (String)"bd_supplier", (String)"bizpartner");
        Long bizpartnerId = null;
        if (null != dynamicObject) {
            bizpartnerId = dynamicObject.getLong("bizpartner_id");
        }
        return bizpartnerId;
    }

    public static final Long getSupplierByBizPartner(Object bizPartner) {
        Long[] bizpartnerId = new Long[1];
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", bizPartner)}, (String)"id");){
            dataSet.forEach(row -> {
                bizpartnerId[0] = row.getLong("id");
            });
        }
        return bizpartnerId[0];
    }

    @Deprecated
    public static final ArrayList<Long> getSupplierByBizPartner() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(1);
        HashMap<String, HashMap<String, Set<Long>>> filterMap = new HashMap<String, HashMap<String, Set<Long>>>(1);
        map.put("in", BizPartnerUtil.getBizPartnerIds());
        filterMap.put("bizpartner", map);
        String selectFields = "id,bizpartner.id bizpartner";
        DynamicObjectCollection suppliers = ORMUtil.queryDynamicObjectCollection((String)"bd_supplier", (String)selectFields, filterMap, (String)"number");
        if (suppliers != null && suppliers.size() > 0) {
            ArrayList<Long> idSet = new ArrayList<Long>(suppliers.size());
            for (DynamicObject dynamicObject : suppliers) {
                Long id = dynamicObject.getLong("id");
                if (id == null) continue;
                idSet.add(id);
            }
            return idSet;
        }
        return null;
    }

    public static final List<Long> getSupplierByUserOfBizPartner() {
        ArrayList<Long> idSet = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", BizPartnerUtil.getBizPartnerIds())}, (String)"id");){
            dataSet.forEach(row -> idSet.add(row.getLong("id")));
        }
        return idSet;
    }

    public static final List<Long> getSupplierByUserAndOrgOfBizPartner(Long orgId) {
        ArrayList<Long> idSet = new ArrayList<Long>();
        QFilter bd_supplier = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)orgId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{bd_supplier.and(new QFilter("bizpartner", "in", BizPartnerUtil.getBizPartnerIds()))}, (String)"id");){
            dataSet.forEach(row -> idSet.add(row.getLong("id")));
        }
        return idSet;
    }

    public static final List<Long> getSupplierByUserOfBizPartner(Set<String> enables, Set<String> statusNumbers) {
        QFilter qFilter = new QFilter("bizpartner", "in", BizPartnerUtil.getBizPartnerIds());
        if (null != enables && enables.size() > 0) {
            qFilter.and("enable", "in", enables);
        }
        if (null != statusNumbers && statusNumbers.size() > 0) {
            qFilter.and("supplier_status.number", "in", statusNumbers);
        }
        ArrayList<Long> idSet = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"id");){
            dataSet.forEach(row -> idSet.add(row.getLong("id")));
        }
        return idSet;
    }

    public static final Map<Long, Integer> getSupplierWithEnableStatusByUserOfBizPartner() {
        HashMap<Long, Integer> supplierMap = new HashMap<Long, Integer>();
        ArrayList enableUser = new ArrayList();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"pur_supuser", (String)"id", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId())), new QFilter("enable", "=", (Object)"1")}, (String)"id");){
            dataSet.forEach(row -> enableUser.add(row.getLong("id")));
        }
        dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"bd_supplier", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", BizPartnerUtil.getBizPartnerIds())}, (String)"id");
        var3_3 = null;
        try {
            dataSet.forEach(row -> supplierMap.put(row.getLong("id"), enableUser.isEmpty() ? Integer.valueOf(0) : row.getInteger("enable")));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var3_3 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return supplierMap;
    }

    @Deprecated
    public static final DynamicObjectCollection getSupplierByBizPartner(String bizParenterid) {
        DynamicObjectCollection supplierByBizPartner = BizPartnerUtil.getSupplierByBizPartner(Long.parseLong(bizParenterid));
        return supplierByBizPartner;
    }

    @Deprecated
    public static final DynamicObjectCollection getSupplierByBizPartner(Long bizParenterid) {
        HashMap<String, Long> map = new HashMap<String, Long>(1);
        HashMap<String, HashMap<String, Long>> filterMap = new HashMap<String, HashMap<String, Long>>(1);
        map.put("in", bizParenterid);
        filterMap.put("bizpartner", map);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"bd_supplier", (boolean)false);
        DynamicObjectCollection suppliers = ORMUtil.queryDynamicObjectCollection((String)"bd_supplier", (String)selectFields, filterMap, (String)"number");
        return suppliers;
    }

    public static final DynamicObjectCollection getSupplierCollByBizPartner() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(1);
        HashMap<String, HashMap<String, Set<Long>>> filterMap = new HashMap<String, HashMap<String, Set<Long>>>(1);
        map.put("in", BizPartnerUtil.getBizPartnerIds());
        filterMap.put("bizpartner", map);
        StringBuilder selectFields = new StringBuilder().append("id").append(',').append("bizpartner").append(',').append("paycond").append(',').append("settlementtypeid").append(',').append("settlementcyid").append(',').append("mallstatus");
        DynamicObjectCollection suppliers = ORMUtil.queryDynamicObjectCollection((String)"bd_supplier", (String)selectFields.toString(), filterMap);
        return suppliers;
    }

    public static String getChatOpenIds(List<Long> userIds) {
        StringBuilder openids = new StringBuilder();
        log.info("\u672c\u6b21\u53d1\u8d77\u6c9f\u901a\u7684\u7528\u6237\u662f\uff1a" + userIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SupplierChatEngineUtil", (String)"bos_user", (String)"useropenid", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds).and(new QFilter("enable", "=", (Object)"1"))}, (String)"id");){
            dataSet.forEach(row -> {
                String openid = row.getString("useropenid");
                if (!"".equals(openid)) {
                    openids.append(openid).append(',');
                }
            });
        }
        log.info("\u672c\u6b21\u53d1\u8d77\u6c9f\u901a\u7684\u7528\u6237openIds\u662f\uff1a" + openids);
        return openids.length() > 1 ? openids.delete(openids.length() - 1, openids.length()).toString() : openids.toString();
    }

    public static final DynamicObjectCollection getMalSupplierCollByBizPartner() {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(1);
        HashMap<String, String> malMap = new HashMap<String, String>(1);
        HashMap<String, HashMap<String, Object>> filterMap = new HashMap<String, HashMap<String, Object>>(1);
        map.put("in", BizPartnerUtil.getBizPartnerIds());
        malMap.put("=", "B");
        filterMap.put("bizpartner", map);
        filterMap.put("mallstatus", malMap);
        StringBuilder selectFields = new StringBuilder().append("id").append(',').append("bizpartner").append(',').append("paycond").append(',').append("settlementtypeid").append(',').append("settlementcyid").append(',').append("mallstatus");
        DynamicObjectCollection suppliers = ORMUtil.queryDynamicObjectCollection((String)"bd_supplier", (String)selectFields.toString(), filterMap);
        return suppliers;
    }

    @Deprecated
    public static Set<String> getSupUserPhoneByBizPartner(Set<String> bizpartnerIdSet) {
        DynamicObject[] cols;
        HashMap params = new HashMap(2);
        HashMap idMap = new HashMap(1);
        HashSet<String> phoneList = new HashSet<String>();
        if (CollectionUtils.isEmpty(bizpartnerIdSet)) {
            return phoneList;
        }
        Set bizpartnerIds = bizpartnerIdSet.stream().map(Long::parseLong).collect(Collectors.toSet());
        idMap.put("in", bizpartnerIds);
        params.put("bizpartner", idMap);
        for (DynamicObject dynamicObject : cols = ORMUtil.load((String)"pur_supuser", (String)"user.phone", params)) {
            if (dynamicObject.getDynamicObject("user") == null) continue;
            phoneList.add(dynamicObject.getDynamicObject("user").getString("phone"));
        }
        return phoneList;
    }

    public static List<Long> getSupUserIdsByBizPartner(Set<Long> bizpartnerIdSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter("bizpartner", "in", bizpartnerIdSet)};
        ArrayList<Long> userPks = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"pur_supuser", (String)"user", (QFilter[])qFilters, (String)"user");){
            dataSet.forEach(row -> userPks.add(row.getLong("user")));
        }
        return userPks;
    }

    public static List<Long> getSupEnableUserIdsByBizPartner(Set<Long> bizpartnerIdSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter("bizpartner", "in", bizpartnerIdSet).and("enable", "=", (Object)"1")};
        ArrayList<Long> userPks = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"pur_supuser", (String)"user", (QFilter[])qFilters, (String)"user");){
            dataSet.forEach(row -> userPks.add(row.getLong("user")));
        }
        return userPks;
    }

    public static List<Long> getSupUserIds() {
        QFilter[] qFilters = new QFilter[]{new QFilter("bizpartner", "in", BizPartnerUtil.getBizPartnerIds())};
        ArrayList<Long> userPks = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"pur_supuser", (String)"user", (QFilter[])qFilters, (String)"user");){
            dataSet.forEach(row -> userPks.add(row.getLong("user")));
        }
        return userPks;
    }

    public static List<Long> getAdminSupUserIdsByBizPartner(Long bizpartnerId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("bizpartner", "=", (Object)bizpartnerId))};
        ArrayList<Long> userPks = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"pur_supuser", (String)"user", (QFilter[])qFilters, (String)"user");){
            dataSet.forEach(row -> userPks.add(row.getLong("user")));
        }
        return userPks;
    }

    public static Map<Long, List<Long>> getAdminSupUsersByBizPartners(List<Long> bizpartnerIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("bizpartner", "in", bizpartnerIds))};
        HashMap<Long, List<Long>> partnerRelAdminUser = new HashMap<Long, List<Long>>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"pur_supuser", (String)"user,bizpartner", (QFilter[])qFilters, (String)"user");){
            dataSet.forEach(row -> {
                Long bizParterId = row.getLong("bizpartner");
                if (null != bizParterId) {
                    Long userId;
                    ArrayList<Long> adminUserIds = (ArrayList<Long>)partnerRelAdminUser.get(bizParterId);
                    if (null == adminUserIds) {
                        adminUserIds = new ArrayList<Long>();
                        partnerRelAdminUser.put(bizParterId, adminUserIds);
                    }
                    if (null != (userId = row.getLong("user"))) {
                        adminUserIds.add(userId);
                    }
                }
            });
        }
        return partnerRelAdminUser;
    }

    @Deprecated
    public static List<Long> getAdminSupUserIdsByBizPartner(Set<Long> bizpartnerIdSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("bizpartner", "in", bizpartnerIdSet))};
        ArrayList<Long> userPks = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"pur_supuser", (String)"user", (QFilter[])qFilters, (String)"user");){
            dataSet.forEach(row -> userPks.add(row.getLong("user")));
        }
        return userPks;
    }

    public static List<Long> getEnableAdminSupUserIdsByBizPartner(Set<Long> bizpartnerIdSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("bizpartner", "in", bizpartnerIdSet)).and(new QFilter("enable", "=", (Object)"1"))};
        ArrayList<Long> userPks = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"pur_supuser", (String)"user", (QFilter[])qFilters, (String)"user");){
            dataSet.forEach(row -> userPks.add(row.getLong("user")));
        }
        return userPks;
    }

    public static Map<Long, List<Long>> getEnableAdminSupUserIdsMapByBizPartner(Set<Long> bizpartnerIdSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("bizpartner", "in", bizpartnerIdSet)).and(new QFilter("enable", "=", (Object)"1"))};
        HashMap<Long, List<Long>> bizUserPksMap = new HashMap<Long, List<Long>>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"pur_supuser", (String)"bizpartner,user", (QFilter[])qFilters, (String)"user");){
            for (Row row : dataSet) {
                List<Long> userPksList = bizUserPksMap.get(row.getLong("bizpartner"));
                if (userPksList == null) {
                    userPksList = new ArrayList<Long>();
                }
                userPksList.add(row.getLong("user"));
                bizUserPksMap.put(row.getLong("bizpartner"), userPksList);
            }
        }
        return bizUserPksMap;
    }

    public static Map<Long, List<Long>> getEnableAdminSupplierUserIdsMapByBizPartner(Set<Long> bizpartnerIdSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter("isadmin", "=", (Object)"1").and(new QFilter("bizpartner", "in", bizpartnerIdSet)).and(new QFilter("enable", "=", (Object)"1"))};
        HashMap<Long, List<Long>> bizUserPksMap = new HashMap<Long, List<Long>>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"pur_supuser", (String)"bizpartner,id", (QFilter[])qFilters, (String)"id");){
            for (Row row : dataSet) {
                List<Long> userPksList = bizUserPksMap.get(row.getLong("bizpartner"));
                if (userPksList == null) {
                    userPksList = new ArrayList<Long>();
                }
                userPksList.add(row.getLong("id"));
                bizUserPksMap.put(row.getLong("bizpartner"), userPksList);
            }
        }
        return bizUserPksMap;
    }

    public static List<Long> getStaffUserIdsByBizPartner(Long bizpartnerId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("isstaff", "=", (Object)"1").and(new QFilter("bizpartner", "=", (Object)bizpartnerId))};
        ArrayList<Long> userPks = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BizPartnerUtil", (String)"pur_supuser", (String)"user", (QFilter[])qFilters, (String)"user");){
            dataSet.forEach(row -> userPks.add(row.getLong("user")));
        }
        return userPks;
    }

    @Deprecated
    public static DynamicObject[] getUsersByBizPartner(Set<String> bizpartnerIdSet) {
        HashMap params = new HashMap(1);
        HashMap<String, Set<String>> phoneMap = new HashMap<String, Set<String>>(1);
        phoneMap.put("in", BizPartnerUtil.getSupUserPhoneByBizPartner(bizpartnerIdSet));
        params.put("phone", phoneMap);
        return ORMUtil.load((String)"bos_user", (String)"enable", params);
    }

    @Deprecated
    public static DynamicObject[] getAdminUsersByBizPartner(Set<Long> bizpartnerIdSet) {
        HashMap params = new HashMap(1);
        HashMap<String, List<Long>> phoneMap = new HashMap<String, List<Long>>(1);
        phoneMap.put("in", BizPartnerUtil.getSupUserIdsByBizPartner(bizpartnerIdSet));
        params.put("phone", phoneMap);
        return ORMUtil.load((String)"bos_user", (String)"enable", params);
    }

    public static void saveBizpartnerOfSupplier(DynamicObject supplier) {
        String name = supplier.getString("name");
        String number = supplier.getString("number");
        String internalCompany = supplier.getString("internal_company_id");
        DynamicObject[] dynamicObjectCheck = BusinessDataServiceHelper.load((String)"bd_bizpartner", (String)"id,name,issupplier", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)name)});
        if (null != dynamicObjectCheck && dynamicObjectCheck.length > 0) {
            DynamicObject save = dynamicObjectCheck[0];
            supplier.set("bizpartner_id", (Object)save.getLong("id"));
            save.set("issupplier", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])dynamicObjectCheck);
        } else {
            DynamicObject dynamicObjectSave = BusinessDataServiceHelper.newDynamicObject((String)"bd_bizpartner");
            dynamicObjectSave.set("name", (Object)name);
            dynamicObjectSave.set("number", (Object)number);
            dynamicObjectSave.set("simplename", (Object)name);
            dynamicObjectSave.set("issupplier", (Object)"1");
            dynamicObjectSave.set("type", (Object)"1");
            dynamicObjectSave.set("status", (Object)"C");
            dynamicObjectSave.set("enable", (Object)"1");
            dynamicObjectSave.set("internal_company_id", (Object)internalCompany);
            dynamicObjectSave.set("issupplier", (Object)"1");
            Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObjectSave});
            if (null != result && result.length > 0) {
                supplier.set("bizpartner_id", ((DynamicObject)result[0]).getPkValue());
            }
        }
    }

    public static final boolean allowRequestMall() {
        DynamicObjectCollection supplierCol = BizPartnerUtil.getSupplierCollByBizPartner();
        if (supplierCol.size() > 0) {
            for (DynamicObject supplier : supplierCol) {
                if (!supplier.get("mallstatus").equals(" ") && !supplier.get("mallstatus").equals("") && !supplier.get("mallstatus").equals("A")) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean haveEnterMall() {
        DynamicObjectCollection supplierCol = BizPartnerUtil.getSupplierCollByBizPartner();
        if (supplierCol.size() > 0) {
            for (DynamicObject supplier : supplierCol) {
                if (!supplier.get("mallstatus").equals("B")) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean haveEnterMallRequest() {
        DynamicObjectCollection supplierCol = BizPartnerUtil.getSupplierCollByBizPartner();
        if (supplierCol.size() > 0) {
            for (DynamicObject supplier : supplierCol) {
                if (!supplier.get("mallstatus").equals("A") && !supplier.get("mallstatus").equals("B")) continue;
                return true;
            }
        }
        return false;
    }
}

