/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.calmodel;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.CheckUtils;
import kd.scm.common.util.CurrencyUtils;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.common.util.calmodel.ICalModel;

public abstract class AbstractCalModel
implements ICalModel {
    private static final Log log = LogFactory.getLog(AbstractCalModel.class);
    private String priceKey = "price";
    private String taxPriceKey = "taxprice";
    private String actPriceKey = "actprice";
    private String actTaxPriceKey = "acttaxprice";
    private String amountKey = "amount";
    private String taxAmountKey = "taxamount";
    private String taxKey = "tax";
    private String discountTypekey = "discounttype";
    private String discountRateKey = "dctrate";
    private String discountAmountKey = "dctamount";
    private String taxRateKey = "taxrate";
    private String qtyKey = "qty";
    private String sumQtyKey = "sumqty";
    private String taxTypeKey = "taxtype";
    private String sumAmountKey = "sumamount";
    private String sumTaxAmountKey = "sumtaxamount";
    private String sumTaxKey = "sumtax";
    private int amountScale = 2;
    private String locamountKey = "locamount";
    private String loctaxamountKey = "loctaxamount";
    private String loctaxKey = "loctax";
    private String exchrateKey = "exchrate";
    private String actcheckpriceKey = "actcheckprice";
    private String actchecktaxpriceKey = "actchecktaxprice";
    private String actcheckamountKey = "actcheckamount";
    private String actchecktaxamountKey = "actchecktaxamount";
    private String unmatchQtyKey = "unmatchqty";
    private String unmatchAmtKey = "unmatchamt";
    private String unmatchAmountKey = "unmatchamount";
    private String inTaxAmountKey = "intaxamount";
    private String diffAmtKey = "diffamt";

    public String getPriceKey() {
        return this.priceKey;
    }

    public void setPriceKey(String priceKey) {
        this.priceKey = priceKey;
    }

    public String getTaxPriceKey() {
        return this.taxPriceKey;
    }

    public void setTaxPriceKey(String taxPriceKey) {
        this.taxPriceKey = taxPriceKey;
    }

    public String getActPriceKey() {
        return this.actPriceKey;
    }

    public void setActPriceKey(String actPriceKey) {
        this.actPriceKey = actPriceKey;
    }

    public String getActTaxPriceKey() {
        return this.actTaxPriceKey;
    }

    public void setActTaxPriceKey(String actTaxPriceKey) {
        this.actTaxPriceKey = actTaxPriceKey;
    }

    public String getAmountKey() {
        return this.amountKey;
    }

    public void setAmountKey(String amountKey) {
        this.amountKey = amountKey;
    }

    public String getLocamountKey() {
        return this.locamountKey;
    }

    public void setLocamountKey(String locamountKey) {
        this.locamountKey = locamountKey;
    }

    public String getLoctaxamountKey() {
        return this.loctaxamountKey;
    }

    public void setLoctaxamountKey(String loctaxamountKey) {
        this.loctaxamountKey = loctaxamountKey;
    }

    public String getLoctaxKey() {
        return this.loctaxKey;
    }

    public void setLoctaxKey(String loctaxKey) {
        this.loctaxKey = loctaxKey;
    }

    public String getExchrateKey() {
        return this.exchrateKey;
    }

    public void setExchrateKey(String exchrateKey) {
        this.exchrateKey = exchrateKey;
    }

    public String getTaxAmountKey() {
        return this.taxAmountKey;
    }

    public void setTaxAmountKey(String taxAmountKey) {
        this.taxAmountKey = taxAmountKey;
    }

    public String getTaxKey() {
        return this.taxKey;
    }

    public void setTaxKey(String taxKey) {
        this.taxKey = taxKey;
    }

    public String getDiscountTypekey() {
        return this.discountTypekey;
    }

    public void setDiscountTypekey(String discountTypekey) {
        this.discountTypekey = discountTypekey;
    }

    public String getDiscountRateKey() {
        return this.discountRateKey;
    }

    public void setDiscountRateKey(String discountRateKey) {
        this.discountRateKey = discountRateKey;
    }

    public String getDiscountAmountKey() {
        return this.discountAmountKey;
    }

    public void setDiscountAmountKey(String discountAmountKey) {
        this.discountAmountKey = discountAmountKey;
    }

    public String getTaxRateKey() {
        return this.taxRateKey;
    }

    public void setTaxRateKey(String taxRateKey) {
        this.taxRateKey = taxRateKey;
    }

    public String getQtyKey() {
        return this.qtyKey;
    }

    public void setQtyKey(String qtyKey) {
        this.qtyKey = qtyKey;
    }

    public String getSumQtyKey() {
        return this.sumQtyKey;
    }

    public void setSumQtyKey(String sumQtyKey) {
        this.sumQtyKey = sumQtyKey;
    }

    public String getTaxTypeKey() {
        return this.taxTypeKey;
    }

    public void setTaxTypeKey(String taxTypeKey) {
        this.taxTypeKey = taxTypeKey;
    }

    public String getSumAmountKey() {
        return this.sumAmountKey;
    }

    public void setSumAmountKey(String sumAmountKey) {
        this.sumAmountKey = sumAmountKey;
    }

    public String getSumTaxAmountKey() {
        return this.sumTaxAmountKey;
    }

    public void setSumTaxAmountKey(String sumTaxAmountKey) {
        this.sumTaxAmountKey = sumTaxAmountKey;
    }

    public String getSumTaxKey() {
        return this.sumTaxKey;
    }

    public void setSumTexKey(String sumTaxKey) {
        this.sumTaxKey = sumTaxKey;
    }

    public int getAmountScale() {
        return this.amountScale;
    }

    public void setAmountScale(int amountScale) {
        this.amountScale = amountScale;
    }

    public void setSumTaxKey(String sumTaxKey) {
        this.sumTaxKey = sumTaxKey;
    }

    public String getActcheckpriceKey() {
        return this.actcheckpriceKey;
    }

    public void setActcheckpriceKey(String actcheckpriceKey) {
        this.actcheckpriceKey = actcheckpriceKey;
    }

    public String getActchecktaxpriceKey() {
        return this.actchecktaxpriceKey;
    }

    public void setActchecktaxpriceKey(String actchecktaxpriceKey) {
        this.actchecktaxpriceKey = actchecktaxpriceKey;
    }

    public String getActcheckamountKey() {
        return this.actcheckamountKey;
    }

    public void setActcheckamountKey(String actcheckamountKey) {
        this.actcheckamountKey = actcheckamountKey;
    }

    public String getActchecktaxamountKey() {
        return this.actchecktaxamountKey;
    }

    public void setActchecktaxamountKey(String actchecktaxamountKey) {
        this.actchecktaxamountKey = actchecktaxamountKey;
    }

    public String getUnmatchQtyKey() {
        return this.unmatchQtyKey;
    }

    public void setUnmatchQtyKey(String unmatchQtyKey) {
        this.unmatchQtyKey = unmatchQtyKey;
    }

    public String getUnmatchAmtKey() {
        return this.unmatchAmtKey;
    }

    public void setUnmatchAmtKey(String unmatchAmtKey) {
        this.unmatchAmtKey = unmatchAmtKey;
    }

    public String getUnmatchAmountKey() {
        return this.unmatchAmountKey;
    }

    public void setUnmatchAmountKey(String unmatchAmountKey) {
        this.unmatchAmountKey = unmatchAmountKey;
    }

    public String getInTaxAmountKey() {
        return this.inTaxAmountKey;
    }

    public void setInTaxAmountKey(String inTaxAmountKey) {
        this.inTaxAmountKey = inTaxAmountKey;
    }

    public String getDiffAmtKey() {
        return this.diffAmtKey;
    }

    public void setDiffAmtKey(String diffAmtKey) {
        this.diffAmtKey = diffAmtKey;
    }

    @Override
    public void calSumTaxAmount(IDataModel model, String entryKey) {
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        DynamicObject billDynamicObject = model.getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : dynamicObjectCollection) {
            sumTaxAmount = sumTaxAmount.add(entry.getBigDecimal(this.taxAmountKey));
        }
        model.setValue(this.sumTaxAmountKey, (Object)sumTaxAmount);
    }

    @Override
    public void calEntryDiscountAmount(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        DynamicObject billDynamicObject = model.getDataEntity();
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)billDynamicObject);
        BigDecimal taxPrice = entryDynamic.getBigDecimal(this.taxPriceKey);
        BigDecimal discountAmount = this.calDiscountAmountByPercentNoScale(billDynamicObject, entryDynamic, scale, taxPrice);
        discountAmount = discountAmount.setScale(scale, 4);
        model.setValue(this.discountAmountKey, (Object)discountAmount, rowIndex);
    }

    public void calEntryDiscountAmountByPrice(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)billDynamicObject);
        boolean containTax = this.isContainTax(billDynamicObject);
        BigDecimal taxPrice = BigDecimal.ZERO;
        taxPrice = containTax ? this.calEntryTaxPriceByTaxAmountNoScale(billDynamicObject, entryDynamic) : this.calEntryTaxPriceByPriceNoScale(entryDynamic, scale);
        BigDecimal discountAmount = this.calDiscountAmountByPercentNoScale(billDynamicObject, entryDynamic, scale, taxPrice);
        discountAmount = discountAmount.setScale(scale, 4);
        model.setValue(this.discountAmountKey, (Object)discountAmount, rowIndex);
    }

    private BigDecimal calDiscountAmountByPercentNoScale(DynamicObject billDynamicObject, DynamicObject entryDynamic, int scale, BigDecimal taxPrice) {
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
        String discountType = this.getDiscountType(entryDynamic);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        BigDecimal discountAmount = CalculateUtils.calDiscountAmountByPercentNoScale((String)discountType, (BigDecimal)discountRate, (BigDecimal)qty, (BigDecimal)taxPrice, (String)taxType, (BigDecimal)taxRate, (int)scale);
        return discountAmount;
    }

    private String getDiscountType(DynamicObject entryDynamic) {
        String discountType = "A";
        try {
            if (entryDynamic.containsProperty(this.discountTypekey)) {
                discountType = entryDynamic.getString(this.discountTypekey);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return discountType;
    }

    @Override
    public void calEntryTaxAmount(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)billDynamicObject);
        BigDecimal taxAmount = this.calTaxAmount(billDynamicObject, entryDynamic, scale);
        taxAmount = taxAmount.setScale(scale, 4);
        int locScale = CurrencyUtils.getLocalAmtPrecision((DynamicObject)billDynamicObject);
        BigDecimal exchrate = billDynamicObject.getBigDecimal(this.exchrateKey);
        if (exchrate != null) {
            BigDecimal loctaxamount = taxAmount.multiply(exchrate).setScale(locScale, 4);
            model.setValue(this.loctaxamountKey, (Object)loctaxamount, rowIndex);
        }
        model.setValue(this.taxAmountKey, (Object)taxAmount, rowIndex);
    }

    private BigDecimal calTaxAmount(DynamicObject billDynamicObject, DynamicObject entryDynamic, int scale) {
        boolean containTax = this.isContainTax(billDynamicObject);
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (containTax) {
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            BigDecimal taxPrice = entryDynamic.getBigDecimal(this.taxPriceKey);
            BigDecimal discount = entryDynamic.getBigDecimal(this.discountRateKey);
            String discountType = this.getDiscountType(entryDynamic);
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent((String)discountType, (BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)discount, (int)scale);
        } else {
            BigDecimal amount = entryDynamic.getBigDecimal(this.amountKey);
            BigDecimal tax = entryDynamic.getBigDecimal(this.taxKey);
            taxAmount = CalculateUtils.calTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
        }
        return taxAmount;
    }

    @Override
    public void calEntryTax(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)billDynamicObject);
        BigDecimal tax = this.calEntryTax(billDynamicObject, entryDynamic, scale);
        tax = tax.setScale(scale, 4);
        int locScale = CurrencyUtils.getLocalAmtPrecision((DynamicObject)billDynamicObject);
        BigDecimal exchrate = billDynamicObject.getBigDecimal(this.exchrateKey);
        if (exchrate != null) {
            BigDecimal loctax = tax.multiply(exchrate).setScale(locScale, 4);
            model.setValue(this.loctaxKey, (Object)loctax, rowIndex);
        }
        model.setValue(this.taxKey, (Object)tax, rowIndex);
    }

    private BigDecimal calEntryTax(DynamicObject billDynamicObject, DynamicObject entryDynamic, int scale) {
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        BigDecimal taxAmount = entryDynamic.getBigDecimal(this.taxAmountKey);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal tax = BigDecimal.ZERO;
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceExludeTax((BigDecimal)taxAmount, (BigDecimal)taxRate, (int)scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal amount = entryDynamic.getBigDecimal(this.amountKey);
            tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)scale);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceInludeTax((BigDecimal)taxAmount, (BigDecimal)taxRate, (int)scale);
        }
        return tax;
    }

    @Override
    public void calEntryAmount(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)billDynamicObject);
        BigDecimal amount = this.calEntryAmountNoScale(billDynamicObject, entryDynamic, scale);
        amount = amount.setScale(scale, 4);
        int locScale = CurrencyUtils.getLocalAmtPrecision((DynamicObject)billDynamicObject);
        BigDecimal exchrate = billDynamicObject.getBigDecimal(this.exchrateKey);
        if (exchrate != null) {
            BigDecimal locamount = amount.multiply(exchrate).setScale(locScale, 4);
            model.setValue(this.locamountKey, (Object)locamount, rowIndex);
        }
        model.setValue(this.amountKey, (Object)amount, rowIndex);
    }

    private BigDecimal calEntryAmountNoScale(DynamicObject billDynamicObject, DynamicObject entryDynamic, int scale) {
        BigDecimal amount = BigDecimal.ZERO;
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxAmount = entryDynamic.getBigDecimal(this.taxAmountKey);
            BigDecimal tax = this.calEntryTax(billDynamicObject, entryDynamic, scale);
            amount = CalculateUtils.calAmountInTax((BigDecimal)taxAmount, (BigDecimal)tax, (int)scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            BigDecimal price = entryDynamic.getBigDecimal(this.priceKey);
            String discountType = this.getDiscountType(entryDynamic);
            amount = CalculateUtils.calAmountByDiscountPercent((String)discountType, (BigDecimal)qty, (BigDecimal)price, (BigDecimal)discountRate, (int)scale);
        }
        return amount;
    }

    @Override
    public void calEntryTaxPriceByPrice(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        BigDecimal price = entryDynamic.getBigDecimal(this.priceKey);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        model.setValue(this.taxPriceKey, (Object)taxPrice, rowIndex);
    }

    public void calEntryTaxPriceByAmount(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        BigDecimal taxPrice = this.calEntryTaxPriceByAmountNoScale(entryDynamic, scale);
        taxPrice = taxPrice.setScale(scale, 4);
        model.setValue(this.taxPriceKey, (Object)taxPrice, rowIndex);
    }

    private BigDecimal calEntryTaxPriceByAmountNoScale(DynamicObject entryDynamic, int scale) {
        BigDecimal price = this.calEntryPriceByAmountNoScale(entryDynamic, scale);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal taxPrice = CalculateUtils.calTaxPriceNoScale((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        return taxPrice;
    }

    private BigDecimal calEntryTaxPriceByPriceNoScale(DynamicObject entryDynamic, int scale) {
        BigDecimal price = entryDynamic.getBigDecimal(this.priceKey);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal taxPrice = CalculateUtils.calTaxPriceNoScale((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        return taxPrice;
    }

    private BigDecimal calEntryTaxPriceByTaxAmountNoScale(DynamicObject billDynamicObject, DynamicObject entryDynamic) {
        BigDecimal taxAmount = entryDynamic.getBigDecimal(this.taxAmountKey);
        BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        String discountType = this.getDiscountType(entryDynamic);
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        BigDecimal taxPrice = CalculateUtils.calTaxPriceNoScale((String)discountType, (BigDecimal)taxAmount, (BigDecimal)qty, (BigDecimal)discountRate, (int)scale);
        return taxPrice;
    }

    @Override
    public void calEntryActualPrice(IDataModel model, String entryKey, int rowIndex) {
        if (this.actPriceKey == null) {
            return;
        }
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        boolean containTax = this.isContainTax(billDynamicObject);
        BigDecimal actualPrice = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        amount = containTax ? this.calEntryAmountNoScale(billDynamicObject, entryDynamic, scale) : entryDynamic.getBigDecimal(this.amountKey);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        actualPrice = CalculateUtils.calActualPrice((BigDecimal)amount, (BigDecimal)qty, (int)scale);
        model.setValue(this.actPriceKey, (Object)actualPrice, rowIndex);
    }

    @Override
    public void calEntryActualTaxPrice(IDataModel model, String entryKey, int rowIndex) {
        if (this.actTaxPriceKey == null) {
            return;
        }
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        boolean containTax = this.isContainTax(billDynamicObject);
        BigDecimal actualTaxPrice = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        taxAmount = containTax ? entryDynamic.getBigDecimal(this.taxAmountKey) : this.calTaxAmount(billDynamicObject, entryDynamic, scale);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        actualTaxPrice = CalculateUtils.calActualTaxPrice((BigDecimal)taxAmount, (BigDecimal)qty, (int)scale);
        model.setValue(this.actTaxPriceKey, (Object)actualTaxPrice, rowIndex);
    }

    @Override
    public void calEntryPriceByTaxPrice(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        if (null == taxType || "2".equals(taxType)) {
            return;
        }
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        BigDecimal taxPrice = entryDynamic.getBigDecimal(this.taxPriceKey);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        BigDecimal price = null;
        price = "1".equals(taxType) ? CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        model.setValue(this.priceKey, (Object)price, rowIndex);
    }

    public void calEntryPriceByTaxAmount(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        if (null == taxType || "2".equals(taxType)) {
            return;
        }
        BigDecimal price = this.calEntryPriceByTaxAmountNoScale(billDynamicObject, taxType, entryDynamic);
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        price = price.setScale(scale, 4);
        model.setValue(this.priceKey, (Object)price, rowIndex);
    }

    private BigDecimal calEntryPriceByTaxAmountNoScale(DynamicObject billDynamicObject, String taxType, DynamicObject entryDynamic) {
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        BigDecimal taxPrice = this.calEntryTaxPriceByTaxAmountNoScale(billDynamicObject, entryDynamic);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal price = null;
        price = "1".equals(taxType) ? CalculateUtils.calPriceNoScale((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calPriceIsPriceInTaxNoScale((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        return price;
    }

    @Override
    public void calEntryPriceByAmount(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        BigDecimal price = this.calEntryPriceByAmountNoScale(entryDynamic, scale);
        price = price.setScale(scale, 4);
        model.setValue(this.priceKey, (Object)price, rowIndex);
    }

    private BigDecimal calEntryPriceByAmountNoScale(DynamicObject entryDynamic, int scale) {
        BigDecimal amount = entryDynamic.getBigDecimal(this.amountKey);
        BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        String discountType = this.getDiscountType(entryDynamic);
        BigDecimal price = CalculateUtils.calPriceNoScale((String)discountType, (BigDecimal)amount, (BigDecimal)qty, (BigDecimal)discountRate, (int)scale);
        return price;
    }

    @Override
    public void calEntryTaxPriceByTaxAmount(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        BigDecimal taxPrice = this.calEntryTaxPriceByTaxAmountNoScale(billDynamicObject, entryDynamic);
        taxPrice = taxPrice.setScale(scale, 4);
        model.setValue(this.taxPriceKey, (Object)taxPrice, rowIndex);
    }

    @Override
    public void calEntryDiscountRate(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        BigDecimal taxPrice = this.calEntryTaxPriceByTaxAmountNoScale(billDynamicObject, entryDynamic);
        BigDecimal discountAmount = entryDynamic.getBigDecimal(this.discountAmountKey);
        String discountType = this.getDiscountType(entryDynamic);
        BigDecimal discountRate = CalculateUtils.calDiscountByPercent((String)discountType, (BigDecimal)discountAmount, (BigDecimal)qty, (BigDecimal)taxPrice, (int)scale);
        model.setValue(this.discountRateKey, (Object)discountRate, rowIndex);
    }

    @Override
    public void calSumAmount(IDataModel model, String entryKey, int rowIndex) {
        BigDecimal sumAmount = BigDecimal.ZERO;
        DynamicObject billDynamicObject = model.getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        for (DynamicObject entry : dynamicObjectCollection) {
            sumAmount = sumAmount.add(entry.getBigDecimal(this.amountKey));
        }
        model.setValue(this.sumAmountKey, (Object)sumAmount);
    }

    @Override
    public void calSumTax(IDataModel model, String entryKey) {
        BigDecimal sumTax = BigDecimal.ZERO;
        DynamicObject billDynamicObject = model.getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        for (DynamicObject entry : dynamicObjectCollection) {
            sumTax = sumTax.add(entry.getBigDecimal(this.taxKey));
        }
        model.setValue(this.sumTaxKey, (Object)sumTax);
    }

    public void calByEntryQtyChange(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject dynamicObject = model.getDataEntity();
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.calEntryDiscountAmount(model, entryKey, rowIndex);
            this.calEntryTaxAmount(model, entryKey, rowIndex);
            this.calEntryTax(model, entryKey, rowIndex);
            this.calEntryAmount(model, entryKey, rowIndex);
        } else {
            this.calEntryDiscountAmount(model, entryKey, rowIndex);
            this.calEntryAmount(model, entryKey, rowIndex);
            this.calEntryTax(model, entryKey, rowIndex);
            this.calEntryTaxAmount(model, entryKey, rowIndex);
        }
    }

    public void calByEntryQtyByAmountChange(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject dynamicObject = model.getDataEntity(true);
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.calEntryTaxPriceByTaxAmount(model, entryKey, rowIndex);
            this.calEntryPriceByTaxAmount(model, entryKey, rowIndex);
            this.calEntryTax(model, entryKey, rowIndex);
            this.calEntryAmount(model, entryKey, rowIndex);
            this.calEntryDiscountAmount(model, entryKey, rowIndex);
            this.calEntryActualPrice(model, entryKey, rowIndex);
            this.calEntryActualTaxPrice(model, entryKey, rowIndex);
        } else {
            this.calEntryPriceByAmount(model, entryKey, rowIndex);
            this.calEntryTaxPriceByAmount(model, entryKey, rowIndex);
            this.calEntryDiscountAmount(model, entryKey, rowIndex);
            this.calEntryTax(model, entryKey, rowIndex);
            this.calEntryTaxAmount(model, entryKey, rowIndex);
            this.calEntryActualPrice(model, entryKey, rowIndex);
            this.calEntryActualTaxPrice(model, entryKey, rowIndex);
        }
    }

    @Override
    public void calSum(IDataModel model, String entryKey) {
        DynamicObject billDynamicObject = model.getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = billDynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumTax = BigDecimal.ZERO;
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        BigDecimal sumQty = BigDecimal.ZERO;
        for (DynamicObject entryDynamicObject : dynamicObjectCollection) {
            sumAmount = sumAmount.add(entryDynamicObject.getBigDecimal("amount"));
            sumTax = sumTax.add(entryDynamicObject.getBigDecimal("tax"));
            sumTaxAmount = sumTaxAmount.add(entryDynamicObject.getBigDecimal("taxamount"));
            sumQty = sumQty.add(entryDynamicObject.getBigDecimal("qty"));
        }
        model.setValue(this.sumAmountKey, (Object)sumAmount);
        model.setValue(this.sumTaxKey, (Object)sumTax);
        model.setValue(this.sumTaxAmountKey, (Object)sumTaxAmount);
        model.setValue(this.sumQtyKey, (Object)sumQty);
    }

    public void calByEntryPriceChange(IDataModel model, String entryKey, int rowIndex) {
        this.calEntryTaxPriceByPrice(model, entryKey, rowIndex);
        this.calEntryDiscountAmount(model, entryKey, rowIndex);
        this.calEntryAmount(model, entryKey, rowIndex);
        this.calEntryActualPrice(model, entryKey, rowIndex);
        this.calEntryTax(model, entryKey, rowIndex);
        this.calEntryTaxAmount(model, entryKey, rowIndex);
        this.calEntryActualTaxPrice(model, entryKey, rowIndex);
    }

    public void calByEntryTaxPriceChange(IDataModel model, String entryKey, int rowIndex) {
        log.info(entryKey + "\u7684taxPrice\u89e6\u53d1\u8ba1\u7b97\u3002\u3002\u3002");
        this.calEntryPriceByTaxPrice(model, entryKey, rowIndex);
        this.calEntryTaxAmount(model, entryKey, rowIndex);
        this.calEntryTax(model, entryKey, rowIndex);
        this.calEntryAmount(model, entryKey, rowIndex);
        this.calEntryActualPrice(model, entryKey, rowIndex);
        this.calEntryActualTaxPrice(model, entryKey, rowIndex);
        this.calEntryDiscountAmount(model, entryKey, rowIndex);
    }

    public void calByEntryAmountChange(IDataModel model, String entryKey, int rowIndex) {
        this.calEntryPriceByAmount(model, entryKey, rowIndex);
        this.calEntryTaxPriceByAmount(model, entryKey, rowIndex);
        this.calEntryDiscountAmount(model, entryKey, rowIndex);
        this.calEntryTax(model, entryKey, rowIndex);
        this.calEntryTaxAmount(model, entryKey, rowIndex);
        this.calEntryActualPrice(model, entryKey, rowIndex);
        this.calEntryActualTaxPrice(model, entryKey, rowIndex);
    }

    public void calByEntryTaxAmountChange(IDataModel model, String entryKey, int rowIndex) {
        this.calEntryTaxPriceByTaxAmount(model, entryKey, rowIndex);
        this.calEntryPriceByTaxAmount(model, entryKey, rowIndex);
        this.calEntryTax(model, entryKey, rowIndex);
        this.calEntryAmount(model, entryKey, rowIndex);
        this.calEntryDiscountAmount(model, entryKey, rowIndex);
        this.calEntryActualPrice(model, entryKey, rowIndex);
        this.calEntryActualTaxPrice(model, entryKey, rowIndex);
    }

    public void calByEntryDiscountRateChange(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject dynamicObject = model.getDataEntity();
        String taxType = dynamicObject.getString(this.taxTypeKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            this.calEntryDiscountAmount(model, entryKey, rowIndex);
            this.calEntryTaxAmount(model, entryKey, rowIndex);
            this.calEntryTax(model, entryKey, rowIndex);
            this.calEntryAmount(model, entryKey, rowIndex);
            this.calEntryActualPrice(model, entryKey, rowIndex);
            this.calEntryActualTaxPrice(model, entryKey, rowIndex);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            this.calEntryDiscountAmount(model, entryKey, rowIndex);
            this.calEntryAmount(model, entryKey, rowIndex);
            this.calEntryTax(model, entryKey, rowIndex);
            this.calEntryTaxAmount(model, entryKey, rowIndex);
            this.calEntryActualPrice(model, entryKey, rowIndex);
            this.calEntryActualTaxPrice(model, entryKey, rowIndex);
        }
    }

    public void calByEntryDiscountAmountChange(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject dynamicObject = model.getDataEntity();
        String taxType = dynamicObject.getString(this.taxTypeKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            this.calEntryDiscountRate(model, entryKey, rowIndex);
            this.calEntryTaxAmount(model, entryKey, rowIndex);
            this.calEntryTax(model, entryKey, rowIndex);
            this.calEntryAmount(model, entryKey, rowIndex);
            this.calEntryActualPrice(model, entryKey, rowIndex);
            this.calEntryActualTaxPrice(model, entryKey, rowIndex);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            this.calEntryDiscountRate(model, entryKey, rowIndex);
            this.calEntryAmount(model, entryKey, rowIndex);
            this.calEntryTax(model, entryKey, rowIndex);
            this.calEntryTaxAmount(model, entryKey, rowIndex);
            this.calEntryActualPrice(model, entryKey, rowIndex);
            this.calEntryActualTaxPrice(model, entryKey, rowIndex);
        }
    }

    public void calByEntryTaxRateChange(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject dynamicObject = model.getDataEntity();
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.calEntryPriceByTaxPrice(model, entryKey, rowIndex);
            this.calEntryTax(model, entryKey, rowIndex);
            this.calEntryAmount(model, entryKey, rowIndex);
            this.calSumAmount(model, entryKey, rowIndex);
        } else {
            this.calEntryTaxPriceByPrice(model, entryKey, rowIndex);
            this.calEntryDiscountAmount(model, entryKey, rowIndex);
            this.calEntryTax(model, entryKey, rowIndex);
            this.calEntryTaxAmount(model, entryKey, rowIndex);
            this.calSumTaxAmount(model, entryKey);
        }
        this.calEntryActualTaxPrice(model, entryKey, rowIndex);
    }

    public void calByEntryTaxChange(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject dynamicObject = model.getDataEntity();
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.calEntryAmount(model, entryKey, rowIndex);
            this.calSumAmount(model, entryKey, rowIndex);
        } else {
            this.calEntryTaxAmount(model, entryKey, rowIndex);
            this.calSumTaxAmount(model, entryKey);
        }
    }

    protected boolean isContainTax(DynamicObject billDynamicObject) {
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        return TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType);
    }

    public void calEntryActcheckamount(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        BigDecimal amount = BigDecimal.ZERO;
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)billDynamicObject);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxAmount = entryDynamic.getBigDecimal(this.actchecktaxamountKey);
            BigDecimal tax = this.calEntryActTax(billDynamicObject, entryDynamic, this.actchecktaxamountKey, this.actcheckamountKey, scale);
            amount = CalculateUtils.calAmountInTax((BigDecimal)taxAmount, (BigDecimal)tax, (int)scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            BigDecimal price = entryDynamic.getBigDecimal(this.actcheckpriceKey);
            String discountType = this.getDiscountType(entryDynamic);
            amount = CalculateUtils.calAmountByDiscountPercent((String)discountType, (BigDecimal)qty, (BigDecimal)price, (BigDecimal)discountRate, (int)scale);
        }
        amount = amount.setScale(scale, 4);
        model.setValue(this.actcheckamountKey, (Object)amount, rowIndex);
    }

    private BigDecimal calEntryActTax(DynamicObject billDynamicObject, DynamicObject entryDynamic, String actchecktaxamountKeyField, String actcheckamountKeyField, int scale) {
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        BigDecimal taxAmount = entryDynamic.getBigDecimal(actchecktaxamountKeyField);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal tax = BigDecimal.ZERO;
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceExludeTax((BigDecimal)taxAmount, (BigDecimal)taxRate, (int)scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal amount = entryDynamic.getBigDecimal(actcheckamountKeyField);
            tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)scale);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceInludeTax((BigDecimal)taxAmount, (BigDecimal)taxRate, (int)scale);
        }
        return tax;
    }

    public void calEntryActTaxAmount(IDataModel model, String entryKey, int rowIndex) {
        BigDecimal taxAmount;
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        DynamicObject billDynamicObject = model.getDataEntity();
        boolean containTax = this.isContainTax(billDynamicObject);
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)billDynamicObject);
        if (containTax) {
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            BigDecimal taxPrice = entryDynamic.getBigDecimal(this.actchecktaxpriceKey);
            BigDecimal discount = entryDynamic.getBigDecimal(this.discountRateKey);
            String discountType = this.getDiscountType(entryDynamic);
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent((String)discountType, (BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)discount, (int)scale);
        } else {
            BigDecimal amount = entryDynamic.getBigDecimal(this.actcheckamountKey);
            BigDecimal tax = this.calEntryActTax(billDynamicObject, entryDynamic, this.actchecktaxamountKey, this.actcheckamountKey, scale);
            tax = tax.setScale(scale, 4);
            taxAmount = CalculateUtils.calTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
        }
        taxAmount = taxAmount.setScale(scale, 4);
        model.setValue(this.actchecktaxamountKey, (Object)taxAmount, rowIndex);
    }

    public void calEntryActTaxPriceByPrice(IDataModel model, String entryKey, int rowIndex, String type) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        BigDecimal price = BigDecimal.ZERO;
        if ("amount".equals(type)) {
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            price = this.getActPriceByAmount(entryDynamic, qty, scale);
        } else {
            price = entryDynamic.getBigDecimal(this.actcheckpriceKey);
        }
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        model.setValue(this.actchecktaxpriceKey, (Object)taxPrice, rowIndex);
    }

    public void calEntryActPriceByTaxPrice(IDataModel model, String entryKey, int rowIndex, String type) {
        DynamicObject billDynamicObject = model.getDataEntity();
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        if (null == taxType || "2".equals(taxType)) {
            return;
        }
        BigDecimal price = this.getActCheckPriceByTax(billDynamicObject, scale, entryDynamic, type);
        price = price.setScale(scale, 4);
        model.setValue(this.actcheckpriceKey, (Object)price, rowIndex);
    }

    private BigDecimal getActCheckPriceByTax(DynamicObject billDynamicObject, int scale, DynamicObject entryDynamic, String type) {
        BigDecimal taxPrice = BigDecimal.ZERO;
        if ("amount".equals(type)) {
            BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
            taxPrice = this.getActTaxTriceAmount(entryDynamic, qty, scale);
        } else {
            taxPrice = entryDynamic.getBigDecimal(this.actchecktaxpriceKey);
        }
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        BigDecimal price = null;
        price = "1".equals(taxType) ? CalculateUtils.calPriceNoScale((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calPriceIsPriceInTaxNoScale((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        return price;
    }

    public void calEntryActPriceByAmount(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        BigDecimal price = this.getActPriceByAmount(entryDynamic, qty, scale);
        price = price.setScale(scale, 4);
        model.setValue(this.actcheckpriceKey, (Object)price, rowIndex);
    }

    private BigDecimal getActPriceByAmount(DynamicObject entryDynamic, BigDecimal qty, int scale) {
        BigDecimal amount = entryDynamic.getBigDecimal(this.actcheckamountKey);
        BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
        String discountType = this.getDiscountType(entryDynamic);
        BigDecimal price = CalculateUtils.calPriceNoScale((String)discountType, (BigDecimal)amount, (BigDecimal)qty, (BigDecimal)discountRate, (int)scale);
        return price;
    }

    public void calEntryActTaxPriceByTaxAmount(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        BigDecimal qty = entryDynamic.getBigDecimal(this.qtyKey);
        BigDecimal taxPrice = this.getActTaxTriceAmount(entryDynamic, qty, scale);
        taxPrice = taxPrice.setScale(scale, 4);
        model.setValue(this.actchecktaxpriceKey, (Object)taxPrice, rowIndex);
    }

    private BigDecimal getActTaxTriceAmount(DynamicObject entryDynamic, BigDecimal qty, int scale) {
        BigDecimal taxAmount = entryDynamic.getBigDecimal(this.actchecktaxamountKey);
        BigDecimal discountRate = entryDynamic.getBigDecimal(this.discountRateKey);
        String discountType = this.getDiscountType(entryDynamic);
        BigDecimal taxPrice = CalculateUtils.calTaxPriceNoScale((String)discountType, (BigDecimal)taxAmount, (BigDecimal)qty, (BigDecimal)discountRate, (int)scale);
        return taxPrice;
    }

    public void calEntryActTaxAmountByActCheckAmount(IDataModel model, String entryKey, int rowIndex) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)billDynamicObject);
        BigDecimal amount = entryDynamic.getBigDecimal(this.actcheckamountKey);
        BigDecimal tax = this.calEntryActTax(billDynamicObject, entryDynamic, this.actchecktaxamountKey, this.actcheckamountKey, scale);
        BigDecimal taxAmount = CalculateUtils.calTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
        model.setValue(this.actchecktaxamountKey, (Object)taxAmount, rowIndex);
    }

    public void calByEntryActCheckTaxAmountChange(IDataModel model, String entryKey, String suffix, int rowIndex) {
        DynamicObject dynamicObject = model.getDataEntity();
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.initFiledValue(suffix);
            this.calEntryActTaxPriceByTaxAmount(model, entryKey, rowIndex);
            this.calEntryActPriceByTaxPrice(model, entryKey, rowIndex, "amount");
            this.calEntryActcheckamount(model, entryKey, rowIndex);
            String name = dynamicObject.getDynamicObjectType().getName();
            if ("scp_check".equals(name) || "pur_check".equals(name)) {
                this.calEntryUnmatchAmt(model, entryKey, rowIndex, "amount");
                this.calEntryUnmatchAmount(model, entryKey, rowIndex, "amount");
                this.calEntryDiffamtAmount(model, entryKey, rowIndex, suffix);
            }
        }
    }

    public void calByEntryActCheckTaxPriceChange(IDataModel model, String entryKey, String suffix, int rowIndex) {
        DynamicObject dynamicObject = model.getDataEntity();
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.initFiledValue(suffix);
            this.calEntryActTaxAmount(model, entryKey, rowIndex);
            this.calEntryActPriceByTaxPrice(model, entryKey, rowIndex, "price");
            this.calEntryActcheckamount(model, entryKey, rowIndex);
            String name = dynamicObject.getDynamicObjectType().getName();
            if ("scp_check".equals(name) || "pur_check".equals(name)) {
                this.calEntryUnmatchAmt(model, entryKey, rowIndex, "price");
                this.calEntryUnmatchAmount(model, entryKey, rowIndex, "price");
                this.calEntryDiffamtAmount(model, entryKey, rowIndex, suffix);
            }
        }
    }

    public void calByEntryActCheckAmountChange(IDataModel model, String entryKey, String suffix, int rowIndex) {
        DynamicObject dynamicObject = model.getDataEntity();
        boolean containTax = this.isContainTax(dynamicObject);
        if (!containTax) {
            this.initFiledValue(suffix);
            this.calEntryActPriceByAmount(model, entryKey, rowIndex);
            this.calEntryActTaxPriceByPrice(model, entryKey, rowIndex, "amount");
            this.calEntryActTaxAmountByActCheckAmount(model, entryKey, rowIndex);
            String name = dynamicObject.getDataEntityType().getName();
            if ("scp_check".equals(name) || "pur_check".equals(name)) {
                this.calEntryUnmatchAmt(model, entryKey, rowIndex, "amount");
                this.calEntryUnmatchAmount(model, entryKey, rowIndex, "amount");
                this.calEntryDiffamtAmount(model, entryKey, rowIndex, suffix);
            }
        }
    }

    public void calByEntryActCheckPriceChange(IDataModel model, String entryKey, String suffix, int rowIndex) {
        DynamicObject dynamicObject = model.getDataEntity();
        boolean containTax = this.isContainTax(dynamicObject);
        if (!containTax) {
            this.initFiledValue(suffix);
            this.calEntryActcheckamount(model, entryKey, rowIndex);
            this.calEntryActTaxPriceByPrice(model, entryKey, rowIndex, "price");
            this.calEntryActTaxAmountByActCheckAmount(model, entryKey, rowIndex);
            String name = dynamicObject.getDataEntityType().getName();
            if ("scp_check".equals(name) || "pur_check".equals(name)) {
                this.calEntryUnmatchAmt(model, entryKey, rowIndex, "price");
                this.calEntryUnmatchAmount(model, entryKey, rowIndex, "price");
                this.calEntryDiffamtAmount(model, entryKey, rowIndex, suffix);
            }
        }
    }

    private void calEntryDiffamtAmount(IDataModel model, String entryKey, int rowIndex, String suffix) {
        DynamicObject billDynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        BigDecimal taxAmount = entryDynamic.getBigDecimal(this.actchecktaxamountKey);
        BigDecimal inTaxAmount = BigDecimal.ZERO;
        inTaxAmount = this.inTaxAmountKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.inTaxAmountKey) : entryDynamic.getBigDecimal(this.inTaxAmountKey + suffix);
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)billDynamicObject);
        BigDecimal diffAmt = taxAmount.subtract(inTaxAmount).setScale(scale, 4);
        model.setValue(this.diffAmtKey, (Object)diffAmt, rowIndex);
    }

    public void calByEntryActQtyChange(IDataModel model, String entryKey, String suffix, int rowIndex) {
        this.initFiledValue(suffix);
        DynamicObject dynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        this.calByEntryQtyChange(model, entryKey, rowIndex);
        BigDecimal discountAmount = entryDynamic.getBigDecimal(this.discountAmountKey);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal taxPrice = entryDynamic.getBigDecimal(this.taxPriceKey);
            BigDecimal price = entryDynamic.getBigDecimal(this.priceKey);
            model.setValue(this.actPriceKey, (Object)price, rowIndex);
            model.setValue(this.actTaxPriceKey, (Object)taxPrice, rowIndex);
        } else {
            this.calEntryActualPrice(model, entryKey, rowIndex);
            this.calEntryActualTaxPrice(model, entryKey, rowIndex);
        }
        boolean containTax = this.isContainTax(dynamicObject);
        if (containTax) {
            this.calEntryActTaxAmount(model, entryKey, rowIndex);
            this.calEntryActcheckamount(model, entryKey, rowIndex);
        } else {
            this.calEntryActcheckamount(model, entryKey, rowIndex);
            this.calEntryActTaxAmount(model, entryKey, rowIndex);
        }
        String name = dynamicObject.getDynamicObjectType().getName();
        if ("scp_check".equals(name) || "pur_check".equals(name)) {
            this.calEntryUnmatchAmt(model, entryKey, rowIndex, "price");
            this.calEntryUnmatchAmount(model, entryKey, rowIndex, "price");
            this.calEntryDiffamtAmount(model, entryKey, rowIndex, suffix);
        }
    }

    @Override
    public void calByEntryActCheckAmountChange(IDataModel model, String entryKey, String suffix) {
        DynamicObject dynamicObject = model.getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        for (int rowIndex = 0; rowIndex < dynamicObjectCollection.size(); ++rowIndex) {
            String srcBillType = ((DynamicObject)dynamicObjectCollection.get(rowIndex)).getString("srcbilltype" + suffix);
            if (!CheckUtils.isPurInstock((String)srcBillType) && !CheckUtils.isPurReciept((String)srcBillType)) continue;
            this.calByEntryActCheckAmountChange(model, entryKey, suffix, rowIndex);
        }
    }

    @Override
    public void calByEntryActCheckTaxAmountChange(IDataModel model, String entryKey, String suffix) {
        DynamicObject dynamicObject = model.getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        for (int rowIndex = 0; rowIndex < dynamicObjectCollection.size(); ++rowIndex) {
            String srcBillType = ((DynamicObject)dynamicObjectCollection.get(rowIndex)).getString("srcbilltype" + suffix);
            if (!CheckUtils.isPurInstock((String)srcBillType) && !CheckUtils.isPurReciept((String)srcBillType)) continue;
            this.calByEntryActCheckTaxAmountChange(model, entryKey, suffix, rowIndex);
        }
    }

    @Override
    public void calByEntryActQtyChange(IDataModel model, String entryKey, String suffix) {
        DynamicObject dynamicObject = model.getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
        if (dynamicObjectCollection == null) {
            return;
        }
        for (int rowIndex = 0; rowIndex < dynamicObjectCollection.size(); ++rowIndex) {
            String srcBillType = ((DynamicObject)dynamicObjectCollection.get(rowIndex)).getString("srcbilltype" + suffix);
            if (!CheckUtils.isPurInstock((String)srcBillType) && !CheckUtils.isPurReciept((String)srcBillType)) continue;
            this.calByEntryActQtyChange(model, entryKey, suffix, rowIndex);
        }
    }

    @Override
    public void calEntryUnmatchAmount(IDataModel model, String entryKey) {
        DynamicObject billDynamicObject = model.getDataEntity();
        boolean inputamount = billDynamicObject.getBoolean("inputamount");
        if (inputamount) {
            this.calEntryUnmatchAmount(billDynamicObject, entryKey, "amount");
        } else {
            this.calEntryUnmatchAmount(billDynamicObject, entryKey, "price");
        }
    }

    public void calEntryUnmatchAmount(IDataModel model, String entryKey, int rowIndex, String type) {
        DynamicObject entryDynamic;
        DynamicObject dynamicObject = model.getDataEntity();
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)dynamicObject);
        String suffix = "";
        if ("entryentity1".equals(entryKey)) {
            suffix = "1";
        }
        if ((entryDynamic = model.getEntryRowEntity(entryKey, rowIndex)) == null) {
            return;
        }
        BigDecimal unmatchAmount = this.getUnmatchAmount(scale, suffix, dynamicObject, entryDynamic, type);
        model.setValue(this.unmatchAmountKey, (Object)unmatchAmount, rowIndex);
    }

    public void calEntryUnmatchAmt(IDataModel model, String entryKey, int rowIndex, String type) {
        DynamicObject dynamicObject = model.getDataEntity();
        DynamicObject entryDynamic = model.getEntryRowEntity(entryKey, rowIndex);
        if (entryDynamic == null) {
            return;
        }
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)dynamicObject);
        String suffix = "";
        if ("entryentity1".equals(entryKey)) {
            suffix = "1";
        }
        BigDecimal unmatchTaxAmount = this.getUnmatchTaxAmount(scale, suffix, dynamicObject, entryDynamic, type);
        model.setValue(this.getUnmatchAmtKey(), (Object)unmatchTaxAmount, rowIndex);
    }

    private BigDecimal getUnmatchTaxAmount(int scale, String suffix, DynamicObject billDynamicObject, DynamicObject entryDynamic, String type) {
        BigDecimal unmatchTaxAmount = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        int scaleprice = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
        qty = this.unmatchQtyKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.unmatchQtyKey) : entryDynamic.getBigDecimal(this.unmatchQtyKey + suffix);
        String discountType = "";
        discountType = this.discountTypekey.endsWith(suffix) ? entryDynamic.getString(this.discountTypekey) : entryDynamic.getString(this.discountTypekey + suffix);
        BigDecimal discount = BigDecimal.ZERO;
        discount = this.discountRateKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.discountRateKey) : entryDynamic.getBigDecimal(this.discountRateKey + suffix);
        BigDecimal taxRate = BigDecimal.ZERO;
        taxRate = this.taxRateKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.taxRateKey) : entryDynamic.getBigDecimal(this.taxRateKey + suffix);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal actcheckTaxPrice = BigDecimal.ZERO;
            actcheckTaxPrice = "amount".equals(type) ? this.getActTaxTriceAmount(entryDynamic, qty, scaleprice) : entryDynamic.getBigDecimal(this.actchecktaxpriceKey);
            unmatchTaxAmount = CalculateUtils.calTaxAmountByDiscountPercent((String)discountType, (BigDecimal)qty, (BigDecimal)actcheckTaxPrice, (BigDecimal)discount, (int)scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal actcheckprice = BigDecimal.ZERO;
            actcheckprice = "amount".equals(type) ? this.getActPriceByAmount(entryDynamic, qty, scaleprice) : entryDynamic.getBigDecimal(this.actcheckpriceKey);
            unmatchTaxAmount = CalculateUtils.calTaxAmountByPrice((String)discountType, (BigDecimal)qty, (BigDecimal)actcheckprice, (BigDecimal)discount, (BigDecimal)taxRate, (int)scale);
        }
        unmatchTaxAmount = unmatchTaxAmount.setScale(scale, 4);
        return unmatchTaxAmount;
    }

    private BigDecimal getUnmatchAmount(int scale, String suffix, DynamicObject billDynamicObject, DynamicObject entryDynamic, String type) {
        BigDecimal unmatchAmount = BigDecimal.ZERO;
        BigDecimal qty = BigDecimal.ZERO;
        String taxType = billDynamicObject.getString(this.taxTypeKey);
        qty = this.unmatchQtyKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.unmatchQtyKey) : entryDynamic.getBigDecimal(this.unmatchQtyKey + suffix);
        String discountType = this.getDiscountType(entryDynamic);
        BigDecimal discount = BigDecimal.ZERO;
        discount = this.discountRateKey.endsWith(suffix) ? entryDynamic.getBigDecimal(this.discountRateKey) : entryDynamic.getBigDecimal(this.discountRateKey + suffix);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxAmount = entryDynamic.getBigDecimal(this.unmatchAmtKey);
            BigDecimal tax = this.calEntryActTax(billDynamicObject, entryDynamic, this.unmatchAmtKey, this.unmatchAmountKey, scale);
            unmatchAmount = CalculateUtils.calAmountInTax((BigDecimal)taxAmount, (BigDecimal)tax, (int)scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal actcheckprice = BigDecimal.ZERO;
            if ("amount".equals(type)) {
                int scaleprice = CurrencyUtils.getPircePrecision((DynamicObject)billDynamicObject);
                actcheckprice = this.getActPriceByAmount(entryDynamic, qty, scaleprice);
            } else {
                actcheckprice = entryDynamic.getBigDecimal(this.actcheckpriceKey);
            }
            unmatchAmount = CalculateUtils.calAmountByDiscountPercent((String)discountType, (BigDecimal)qty, (BigDecimal)actcheckprice, (BigDecimal)discount, (int)scale);
        }
        unmatchAmount = unmatchAmount.setScale(scale, 4);
        return unmatchAmount;
    }

    public void calEntryUnmatchAmount(DynamicObject dynamicObject, String entryKey, String type) {
        int scale = CurrencyUtils.getAmtPrecision((DynamicObject)dynamicObject);
        String suffix = "";
        if ("entryentity1".equals(entryKey)) {
            suffix = "1";
        }
        this.initFiledValue(suffix);
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : col) {
            String srcBillType = entry.getString("srcbilltype" + suffix);
            if (!CheckUtils.isPurInstock((String)srcBillType) && !CheckUtils.isPurReciept((String)srcBillType)) continue;
            BigDecimal unmatchAmount = this.getUnmatchAmount(scale, suffix, dynamicObject, entry, type);
            entry.set(this.unmatchAmountKey, (Object)unmatchAmount);
        }
    }

    public void initField(String qtyKey, String discountTypeKey, String discountRateKey, String taxRateKey, String actchecktaxpriceKey, String actcheckpriceKey, String unmatchQtyKey) {
        this.setQtyKey(qtyKey);
        this.setDiscountTypekey(discountTypeKey);
        this.setDiscountRateKey(discountRateKey);
        this.setTaxRateKey(taxRateKey);
        this.setActcheckpriceKey(actcheckpriceKey);
        this.setActchecktaxpriceKey(actchecktaxpriceKey);
        this.setUnmatchQtyKey(unmatchQtyKey);
    }

    public BigDecimal getUnmatchTaxAmount(DynamicObject entryDynamic, int scaleamount, int scaleprice, String taxType, String type, BigDecimal taxAmount, BigDecimal amount) {
        BigDecimal unmatchTaxAmount = BigDecimal.ZERO;
        BigDecimal qty = entryDynamic.getBigDecimal(this.unmatchQtyKey);
        String discountType = entryDynamic.getString(this.discountTypekey);
        BigDecimal discount = entryDynamic.getBigDecimal(this.discountRateKey);
        BigDecimal taxRate = entryDynamic.getBigDecimal(this.taxRateKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal actcheckTaxPrice = BigDecimal.ZERO;
            actcheckTaxPrice = "amount".equals(type) ? CalculateUtils.calTaxPriceNoScale((String)discountType, (BigDecimal)taxAmount, (BigDecimal)qty, (BigDecimal)discount, (int)scaleprice) : entryDynamic.getBigDecimal(this.actchecktaxpriceKey);
            unmatchTaxAmount = CalculateUtils.calTaxAmountByDiscountPercent((String)discountType, (BigDecimal)qty, (BigDecimal)actcheckTaxPrice, (BigDecimal)discount, (int)scaleamount);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal actcheckprice = BigDecimal.ZERO;
            actcheckprice = "amount".equals(type) ? CalculateUtils.calPriceNoScale((String)discountType, (BigDecimal)amount, (BigDecimal)qty, (BigDecimal)discount, (int)scaleprice) : entryDynamic.getBigDecimal(this.actcheckpriceKey);
            unmatchTaxAmount = CalculateUtils.calTaxAmountByPrice((String)discountType, (BigDecimal)qty, (BigDecimal)actcheckprice, (BigDecimal)discount, (BigDecimal)taxRate, (int)scaleamount);
        }
        unmatchTaxAmount = unmatchTaxAmount.setScale(scaleamount, 4);
        return unmatchTaxAmount;
    }

    protected void initFiledValue(String suffix) {
        if (!this.getQtyKey().endsWith(suffix)) {
            this.setQtyKey(this.getQtyKey() + suffix);
            this.setAmountKey(this.getAmountKey() + suffix);
            this.setActPriceKey(this.getActPriceKey() + suffix);
            this.setActTaxPriceKey(this.getActTaxPriceKey() + suffix);
            this.setDiscountTypekey(this.getDiscountTypekey() + suffix);
            this.setDiscountRateKey(this.getDiscountRateKey() + suffix);
            this.setDiscountAmountKey(this.getDiscountAmountKey() + suffix);
            this.setPriceKey(this.getPriceKey() + suffix);
            this.setTaxKey(this.getTaxKey() + suffix);
            this.setTaxAmountKey(this.getTaxAmountKey() + suffix);
            this.setTaxPriceKey(this.getTaxPriceKey() + suffix);
            this.setTaxRateKey(this.getTaxRateKey() + suffix);
            this.setUnmatchQtyKey(this.getUnmatchQtyKey() + suffix);
            this.setLoctaxamountKey(this.getLoctaxamountKey() + suffix);
            this.setLocamountKey(this.getLocamountKey() + suffix);
            this.setLoctaxKey(this.getLoctaxKey() + suffix);
            this.setDiffAmtKey(this.getDiffAmtKey() + suffix);
            this.setInTaxAmountKey(this.getInTaxAmountKey() + suffix);
        }
    }
}

