/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.jointchannel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.business.MultiDataExecuteSchemeConfigHelper;
import kd.scm.common.helper.multisystemjoint.business.MultiJointFailTaskHelper;
import kd.scm.common.helper.multisystemjoint.business.MultiJointParamServiceProxyHelper;
import kd.scm.common.helper.multisystemjoint.entity.MultiDataHandleConfig;
import kd.scm.common.helper.multisystemjoint.entity.MultiJointStoreDataHandleMessageInfo;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.entity.ScMultiDataExecuteSchemeInfo;
import kd.scm.common.helper.multisystemjoint.entity.ScMultiExecuteSchemeEntryInfo;
import kd.scm.common.helper.multisystemjoint.exception.MultiSystemJointError;
import kd.scm.common.helper.multisystemjoint.exception.MultiSystemJointException;
import kd.scm.common.helper.multisystemjoint.jointchannel.IScChannelHandleService;
import kd.scm.common.helper.multisystemjoint.param.MultiCustomParam;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.api.IMultiParamDefineService;
import kd.scm.common.helper.scdatahandle.entity.ScDataHandleLogInfo;
import kd.scm.common.helper.scdatahandle.log.IScDataHandleLog;
import kd.scm.common.helper.scdatahandle.log.ScDataHandleLog;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.ExceptionUtil;

public abstract class ScMultiChannelHandleService
implements IScChannelHandleService {
    protected static Log log = LogFactory.getLog(ScMultiChannelHandleService.class);
    protected MultiCustomParam multiCustomParam;
    protected ScDataMultiJointChannelInfo scDataMultiJointChannelInfo;
    protected final List<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(1024);
    protected ScMultiDataExecuteSchemeInfo scMultiDataExecuteSchemeInfo;
    protected String failStrategy = "ignore";
    protected IScDataHandleLog iScDataHandleLog;
    protected MultiDataHandleResult scDataHandleResult;
    protected final Map<String, IMultiParamDefineService> defineServiceMap = new LinkedHashMap<String, IMultiParamDefineService>(4);

    public final void initialize(ScDataMultiJointChannelInfo scDataMultiJointChannelInfo, List<DynamicObject> dataexecuteconfigs, MultiCustomParam multiCustomParam) {
        this.scDataMultiJointChannelInfo = scDataMultiJointChannelInfo;
        this.scDataHandleResult = this.createHandleResult();
        this.multiCustomParam = multiCustomParam;
        try {
            this.scMultiDataExecuteSchemeInfo = MultiDataExecuteSchemeConfigHelper.getMultiDataExecuteSchemeInfo(dataexecuteconfigs);
            this.defineServiceMap.putAll(MultiJointParamServiceProxyHelper.getJointParamServicePool((ScMultiDataExecuteSchemeInfo)this.scMultiDataExecuteSchemeInfo));
            for (Map.Entry<String, IMultiParamDefineService> entry : this.defineServiceMap.entrySet()) {
                IMultiParamDefineService paramDefineService = entry.getValue();
                paramDefineService.initializeOperationResult(this.getScDataChannelInfo(), this.getScDataHandleResult(), multiCustomParam);
            }
        }
        catch (MultiSystemJointError multiSystemJointError) {
            log.error("runtimeException,message:{},type:{}", (Object)String.valueOf(multiSystemJointError.getErrorMessage()), (Object)((Object)((Object)multiSystemJointError)).getClass().getName());
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)multiSystemJointError);
            throw new KDException(new ErrorCode("SC_DATA_ERROR_CODE_001", "\u521d\u59cb\u5316\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e86\u4e0d\u53ef\u633d\u56de\u7684\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u652f\u6301\u4eba\u5458\u4fee\u590d" + multiSystemJointError.getErrorMessage()), new Object[]{multiSystemJointError});
        }
        catch (Throwable throwable) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)throwable);
            log.error("runtimeException,message:{},type:{}", (Object)String.valueOf(throwable.getMessage()), (Object)throwable.getClass().getName());
            throw new KDException(new ErrorCode("SC_DATA_ERROR_CODE_001", "\u521d\u59cb\u5316\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e86\u4e0d\u53ef\u633d\u56de\u7684\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u652f\u6301\u4eba\u5458\u4fee\u590d" + throwable.getMessage()), new Object[]{throwable});
        }
        finally {
            log.info("\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u521d\u59cb\u5316\u7ed3\u675f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MultiDataHandleResult execute(Long[] pkIds) {
        try {
            for (Map.Entry<String, IMultiParamDefineService> entry : this.defineServiceMap.entrySet()) {
                IMultiParamDefineService paramDefineService = entry.getValue();
                List dynamicObjects = paramDefineService.queryDynamicObject(pkIds);
                this.addAllDynamicObjects(dynamicObjects);
                paramDefineService.addAllDynamicObject(dynamicObjects);
            }
            this.doExecute();
        }
        catch (MultiSystemJointError multiSystemJointError) {
            this.handleException(multiSystemJointError, this.getDynamicObjects());
        }
        finally {
            log.info("\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u5904\u7406\u7ed3\u675f");
        }
        return this.getScDataHandleResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MultiDataHandleResult execute(List<DynamicObject> dynamicObjects) {
        try {
            this.addAllDynamicObjects(dynamicObjects);
            for (Map.Entry<String, IMultiParamDefineService> entry : this.defineServiceMap.entrySet()) {
                entry.getValue().addAllDynamicObject(dynamicObjects);
            }
            this.doExecute();
        }
        catch (MultiSystemJointError multiSystemJointError) {
            this.handleException(multiSystemJointError, this.getDynamicObjects());
        }
        finally {
            log.info("\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u5904\u7406\u7ed3\u675f");
        }
        return this.getScDataHandleResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute() throws MultiSystemJointException {
        this.executeHandleData();
        LinkedHashMap<String, ScMultiParamArgs> multiParamArgsMap = new LinkedHashMap<String, ScMultiParamArgs>(15);
        for (Map.Entry<String, IMultiParamDefineService> entry : this.defineServiceMap.entrySet()) {
            IMultiParamDefineService paramDefineService = entry.getValue();
            multiParamArgsMap.put(entry.getKey(), paramDefineService.assembleMultiParamArgs(paramDefineService.getDynamicObject()));
        }
        if (multiParamArgsMap.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.getScMultiDataExecuteSchemeInfo().getExecuteSchemeEntryInfoMap().entrySet()) {
                this.handleEmptyArgs((ScMultiExecuteSchemeEntryInfo)entry.getValue(), this.getDynamicObjects());
            }
        }
        for (Map.Entry<String, Object> entry : multiParamArgsMap.entrySet()) {
            ScMultiParamArgs scMultiParamArgs = (ScMultiParamArgs)entry.getValue();
            String entryKey = entry.getKey();
            IMultiParamDefineService defineService = this.defineServiceMap.get(entryKey);
            ScMultiExecuteSchemeEntryInfo schemeEntryInfo = this.getScMultiDataExecuteSchemeInfo().getExecuteSchemeEntryInfo(entryKey);
            try {
                if (scMultiParamArgs != null) {
                    defineService.getMultiPushDataHandler().executePush(this.getScDataHandleResult(), scMultiParamArgs);
                    this.assembleScDataSuccessLog(schemeEntryInfo, defineService, scMultiParamArgs);
                    defineService.callBack(this.getScDataHandleResult());
                    continue;
                }
                this.handleEmptyArgs(schemeEntryInfo, defineService.getDynamicObject());
            }
            catch (MultiSystemJointException multiSystemJointException) {
                this.handleSelfException(schemeEntryInfo, defineService, (ScMultiParamArgs)entry.getValue(), multiSystemJointException);
                break;
            }
            catch (Throwable throwable) {
                this.getScDataHandleResult().setFinishedTime(TimeServiceHelper.now());
                this.handleException(throwable, defineService.getDynamicObject());
                break;
            }
            finally {
                log.warn("\u591a\u7cfb\u7edf\u96c6\u6210\u670d\u52a1\u8bf7\u6c42\u5904\u7406\u7ed3\u675f");
            }
        }
    }

    protected abstract void executeHandleData();

    protected final MultiDataHandleResult createHandleResult() {
        MultiDataHandleResult scDataHandleResult = new MultiDataHandleResult();
        scDataHandleResult.setStartTime(TimeServiceHelper.now());
        return scDataHandleResult;
    }

    protected final IScDataHandleLog getScDataHandleLog() {
        this.iScDataHandleLog = new ScDataHandleLog();
        return this.iScDataHandleLog;
    }

    protected final ScDataMultiJointChannelInfo getScDataChannelInfo() {
        return this.scDataMultiJointChannelInfo;
    }

    protected final ScMultiDataExecuteSchemeInfo getScMultiDataExecuteSchemeInfo() {
        return this.scMultiDataExecuteSchemeInfo;
    }

    protected MultiDataHandleResult getScDataHandleResult() {
        return this.scDataHandleResult;
    }

    protected final MultiCustomParam getMultiCustomParam() {
        return this.multiCustomParam;
    }

    protected final void addAllDynamicObjects(List<DynamicObject> dynamicObjects) {
        if (dynamicObjects != null) {
            this.dynamicObjects.addAll(dynamicObjects);
        }
    }

    protected final List<DynamicObject> getDynamicObjects() {
        return this.dynamicObjects;
    }

    protected final String getFailStrategy() {
        return this.failStrategy;
    }

    protected final Map<String, IMultiParamDefineService> getDefineServiceMap() {
        return this.defineServiceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleException(Throwable throwable, List<DynamicObject> dynamicObjects) {
        try {
            ScDataHandleLogInfo scDataHandleLogInfo = this.assembleDefaultLogInfo();
            ScMultiDataExecuteSchemeInfo executeSchemeInfo = this.getScMultiDataExecuteSchemeInfo();
            String operateDesc = throwable.getMessage() != null ? throwable.getMessage() : "failed";
            String entityNumber = executeSchemeInfo.getEntityNumber();
            MultiDataHandleConfig multiDataHandleConfig = this.getDataHandleConfig(entityNumber, executeSchemeInfo.getOperateKey(), operateDesc, dynamicObjects);
            scDataHandleLogInfo.setLogAppId(multiDataHandleConfig.getBizAppId());
            scDataHandleLogInfo.setEntityDesc(multiDataHandleConfig.getEntityDesc());
            scDataHandleLogInfo.setOperateDesc(multiDataHandleConfig.getOperateDesc());
            String configJson = SerializationUtils.toJsonString((Object)multiDataHandleConfig);
            scDataHandleLogInfo.setConfig(configJson);
            scDataHandleLogInfo.setConfigTag(configJson);
            scDataHandleLogInfo.setParams("scDataHandleArgs");
            scDataHandleLogInfo.setParamsTag("scDataHandleArgs");
            scDataHandleLogInfo.setLogType("successlog");
            scDataHandleLogInfo.setState("success");
            scDataHandleLogInfo.setResult(operateDesc);
            scDataHandleLogInfo.setResultTag(ExceptionUtil.getStackTrace((Throwable)throwable));
            this.getScDataHandleResult().setExceptionMessage(String.valueOf(throwable.getMessage()));
            this.getScDataHandleResult().setScDataFailId(scDataHandleLogInfo.getId());
            this.getScDataHandleResult().setFinishedTime(TimeServiceHelper.now());
            this.getScDataHandleLog().info(scDataHandleLogInfo);
        }
        finally {
            if (throwable instanceof RuntimeException) {
                SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)((RuntimeException)throwable));
            } else {
                SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)throwable);
            }
            log.warn("\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u7a0b\u5e8f\u5f02\u5e38\u60c5\u51b5\u8bb0\u5f55\u7ed3\u675f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleSelfException(ScMultiExecuteSchemeEntryInfo schemeEntryInfo, IMultiParamDefineService defineService, ScMultiParamArgs scMultiParamArgs, MultiSystemJointException multiSystemJointException) {
        try {
            ScDataHandleLogInfo scDataHandleLogInfo = this.assembleDefaultLogInfo();
            this.getScDataHandleResult().setFinishedTime(TimeServiceHelper.now());
            String entityNumber = this.getScMultiDataExecuteSchemeInfo().getEntityNumber();
            MultiDataHandleConfig multiDataHandleConfig = this.getDataHandleConfig(entityNumber, this.getScMultiDataExecuteSchemeInfo().getOperateKey(), schemeEntryInfo.getSceneEntityNumber(), defineService.getDynamicObject());
            scDataHandleLogInfo.setEntityDesc(multiDataHandleConfig.getEntityDesc());
            scDataHandleLogInfo.setOperateDesc(multiDataHandleConfig.getOperateDesc());
            scDataHandleLogInfo.setLogAppId(multiDataHandleConfig.getBizAppId());
            multiDataHandleConfig.setMultiPushHandlerClass(defineService.getMultiPushDataHandler().getClass());
            String configJson = SerializationUtils.toJsonString((Object)multiDataHandleConfig);
            scDataHandleLogInfo.setConfig(configJson);
            scDataHandleLogInfo.setConfigTag(configJson);
            String paramArgsString = SerializationUtils.toJsonString((Object)scMultiParamArgs);
            scDataHandleLogInfo.setParams(paramArgsString);
            scDataHandleLogInfo.setParamsTag(paramArgsString);
            scDataHandleLogInfo.setRetry(Integer.valueOf(Integer.parseInt("0")));
            scDataHandleLogInfo.setLogType("faillog");
            scDataHandleLogInfo.setState("fail");
            scDataHandleLogInfo.setDefinescene(schemeEntryInfo.getExecuteSceneId());
            scDataHandleLogInfo.setResult(multiSystemJointException.getExceptionMessage());
            scDataHandleLogInfo.setResultTag(ExceptionUtil.getStackTrace((Throwable)multiSystemJointException));
            this.getScDataHandleLog().info(scDataHandleLogInfo);
            this.getScDataHandleResult().setScDataFailId(scDataHandleLogInfo.getId());
            this.getScDataHandleResult().setExceptionMessage(String.valueOf(multiSystemJointException.getMessage()));
            this.getScDataHandleResult().setFinishedTime(TimeServiceHelper.now());
            MultiJointStoreDataHandleMessageInfo jointStoreDataHandleMessageInfo = new MultiJointStoreDataHandleMessageInfo(scDataHandleLogInfo.getId());
            jointStoreDataHandleMessageInfo.setMultiParamArgs(scMultiParamArgs);
            jointStoreDataHandleMessageInfo.setMultiDataHandleConfig(multiDataHandleConfig);
            if ("retry".equals(schemeEntryInfo.getFailStrategy())) {
                MultiJointFailTaskHelper.executeTask((MultiJointStoreDataHandleMessageInfo)jointStoreDataHandleMessageInfo);
            }
        }
        finally {
            SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)((Object)multiSystemJointException));
            log.warn("\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u7a0b\u5e8f\u5f02\u5e38\u60c5\u51b5\u8bb0\u5f55\u7ed3\u675f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleEmptyArgs(ScMultiExecuteSchemeEntryInfo schemeEntryInfo, List<DynamicObject> dynamicObjects) {
        try {
            ScDataHandleLogInfo scDataHandleLogInfo = this.assembleDefaultLogInfo();
            ScMultiDataExecuteSchemeInfo executeSchemeInfo = this.getScMultiDataExecuteSchemeInfo();
            String entityNumber = executeSchemeInfo.getEntityNumber();
            MultiDataHandleConfig multiDataHandleConfig = this.getDataHandleConfig(entityNumber, executeSchemeInfo.getOperateKey(), schemeEntryInfo.getExecuteSchemeName(), dynamicObjects);
            scDataHandleLogInfo.setEntityDesc(multiDataHandleConfig.getEntityDesc());
            scDataHandleLogInfo.setOperateDesc(multiDataHandleConfig.getOperateDesc());
            scDataHandleLogInfo.setLogAppId(multiDataHandleConfig.getBizAppId());
            String configJson = SerializationUtils.toJsonString((Object)multiDataHandleConfig);
            scDataHandleLogInfo.setConfig(configJson);
            scDataHandleLogInfo.setConfigTag(configJson);
            scDataHandleLogInfo.setLogType("successlog");
            scDataHandleLogInfo.setState("success");
            scDataHandleLogInfo.setParams("empty ParamArgs");
            scDataHandleLogInfo.setParamsTag("empty ParamArgs");
            String message = this.getScDataHandleResult().getMessage();
            if (message != null && !message.isEmpty()) {
                scDataHandleLogInfo.setResult(message);
                scDataHandleLogInfo.setResultTag(message);
            } else {
                scDataHandleLogInfo.setResult("success");
                scDataHandleLogInfo.setResultTag("success");
            }
            this.getScDataHandleLog().info(scDataHandleLogInfo);
        }
        finally {
            log.debug("\u591a\u7cfb\u7edf\u96c6\u6210\u670d\u52a1\u8bf7\u6c42\u8bb0\u5f55\u7ed3\u675f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assembleScDataSuccessLog(ScMultiExecuteSchemeEntryInfo schemeEntryInfo, IMultiParamDefineService defineService, ScMultiParamArgs scMultiParamArgs) {
        try {
            ScDataHandleLogInfo scDataHandleLogInfo = this.assembleDefaultLogInfo();
            ScMultiDataExecuteSchemeInfo executeSchemeInfo = this.getScMultiDataExecuteSchemeInfo();
            String entityNumber = executeSchemeInfo.getEntityNumber();
            String paramJson = SerializationUtils.toJsonString((Object)scMultiParamArgs);
            MultiDataHandleConfig multiDataHandleConfig = this.getDataHandleConfig(entityNumber, executeSchemeInfo.getOperateKey(), schemeEntryInfo.getExecuteSchemeName(), defineService.getDynamicObject());
            scDataHandleLogInfo.setEntityDesc(multiDataHandleConfig.getEntityDesc());
            scDataHandleLogInfo.setOperateDesc(multiDataHandleConfig.getOperateDesc());
            scDataHandleLogInfo.setLogAppId(multiDataHandleConfig.getBizAppId());
            String configJson = SerializationUtils.toJsonString((Object)multiDataHandleConfig);
            scDataHandleLogInfo.setConfig(configJson);
            scDataHandleLogInfo.setConfigTag(configJson);
            scDataHandleLogInfo.setParams(paramJson);
            scDataHandleLogInfo.setParamsTag(paramJson);
            scDataHandleLogInfo.setLogType("successlog");
            scDataHandleLogInfo.setState("success");
            String message = this.getScDataHandleResult().getMessage();
            if (message != null && !message.isEmpty()) {
                scDataHandleLogInfo.setResult(message);
                scDataHandleLogInfo.setResultTag(message);
            } else {
                scDataHandleLogInfo.setResult("success");
                scDataHandleLogInfo.setResultTag("success");
            }
            this.getScDataHandleLog().info(scDataHandleLogInfo);
            this.getScDataHandleResult().setScDataLogId(scDataHandleLogInfo.getId());
            this.getScDataHandleResult().setFinishedTime(TimeServiceHelper.now());
        }
        finally {
            log.debug("\u591a\u7cfb\u7edf\u96c6\u6210\u670d\u52a1\u8bf7\u6c42\u6267\u884c\u6210\u529f\u8bb0\u5f55\u7ed3\u675f");
        }
    }

    protected final ScDataHandleLogInfo assembleDefaultLogInfo() {
        ScDataHandleLogInfo scDataHandleLogInfo = new ScDataHandleLogInfo();
        scDataHandleLogInfo.setId(DBServiceHelper.genStringId());
        scDataHandleLogInfo.setLogDim("scdataframe");
        scDataHandleLogInfo.setTraceId(RequestContext.get().getTraceId());
        scDataHandleLogInfo.setUserName(RequestContext.get().getUserName());
        scDataHandleLogInfo.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
        scDataHandleLogInfo.setLogAppId("pbd");
        return scDataHandleLogInfo;
    }

    protected final MultiDataHandleConfig getDataHandleConfig(String entityNumber, String operateKey, String operateDesc, List<DynamicObject> dynamicObjects) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String entityName = dataEntityType.getDisplayName().getLocaleValue() + "(" + dataEntityType.getName() + ")";
        Map op = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)operateKey);
        String opName = null;
        String opTypeId = (String)op.get("type");
        if (OperationTypeCache.isEntityOperation((String)opTypeId)) {
            String opKey;
            opName = opKey = (String)op.get("key");
            Map mapLocaleString = (Map)op.get("name");
            if (mapLocaleString != null) {
                opName = LocaleString.fromMap((Map)mapLocaleString).toString() + "(" + opKey + ")";
            }
        }
        MultiDataHandleConfig dataHandleConfig = new MultiDataHandleConfig();
        dataHandleConfig.setEntityDesc(entityName + opName);
        dataHandleConfig.setOperateDesc(operateDesc);
        dataHandleConfig.setBizAppId(dataEntityType.getAppId());
        dataHandleConfig.setJointChannelId(this.getScDataChannelInfo().getChannelId());
        HashSet dataMaps = new HashSet(1024);
        if (dynamicObjects.size() > 0) {
            String propertyName;
            DynamicObjectType dynamicObjectType = dynamicObjects.get(0).getDynamicObjectType();
            DataEntityPropertyCollection dataEntityProperties = dynamicObjectType.getProperties();
            String billNoKey = (String)this.getMultiCustomParam().get((Object)"billNoField");
            String billIdKey = (String)this.getMultiCustomParam().getOrDefault((Object)"keyField", (Object)"id");
            for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
                propertyName = dataEntityProperty.getName();
                if (billIdKey != null && !billIdKey.trim().isEmpty()) break;
                if (propertyName.startsWith("id")) {
                    billIdKey = propertyName;
                    continue;
                }
                if (!propertyName.startsWith("billid")) continue;
                billIdKey = propertyName;
            }
            for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
                if (billNoKey != null && !billNoKey.trim().isEmpty()) break;
                propertyName = dataEntityProperty.getName();
                if (!propertyName.startsWith("billno")) continue;
                billNoKey = propertyName;
            }
            for (DynamicObject bill : dynamicObjects) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                String billId = bill.getString(billIdKey);
                String billNo = bill.getString(billNoKey);
                dataMap.put(billIdKey, billId);
                dataMap.put(billNoKey, billNo);
                dataMaps.add(dataMap);
            }
        }
        dataHandleConfig.setDataJson(SerializationUtils.toJsonString(dataMaps));
        return dataHandleConfig;
    }

    protected final void release() {
        this.scMultiDataExecuteSchemeInfo = null;
    }

    protected final void callExecuteSceneCount() {
    }
}

