/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.placeorder.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.EmalParamsUtil;
import kd.scm.common.ecapi.util.PayTypeUtil;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.util.BizTypeHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.org.entity.MalOrgRelation;
import kd.scm.mal.business.org.service.MalOrgRelationService;
import kd.scm.mal.business.placeorder.entity.MalCreateOrderResult;
import kd.scm.mal.business.placeorder.entity.MalFeeGoods;
import kd.scm.mal.business.placeorder.entity.MalFreightInfo;
import kd.scm.mal.business.placeorder.entity.MalFreightParam;
import kd.scm.mal.business.placeorder.entity.MalFreightResult;
import kd.scm.mal.business.placeorder.entity.MalInvoicingInfo;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderEntity;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderItem;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderValidateOption;
import kd.scm.mal.business.placeorder.entity.MalPlaceOrderValidateResult;
import kd.scm.mal.business.placeorder.entity.MalSurchargeInfo;
import kd.scm.mal.business.placeorder.entity.MalSurchargeParam;
import kd.scm.mal.business.placeorder.entity.MalSurchargeResult;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderItem;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderParam;
import kd.scm.mal.business.placeorder.service.MalFreightService;
import kd.scm.mal.business.placeorder.service.MalPlaceOrderService;
import kd.scm.mal.business.placeorder.service.MalSurchargeService;
import kd.scm.mal.business.placeorder.vo.MalPlaceOrderVo;
import kd.scm.mal.business.receipt.entity.MalReceipt;
import kd.scm.mal.business.receipt.service.MalReceiptService;
import kd.scm.mal.business.shopcart.service.MalShopCartService;
import kd.scm.mal.business.stock.service.MalStockService;
import kd.scm.mal.common.enums.MalBizflowParamEnum;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.compare.ComparePriceInfo;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;

public class MalPlaceOrderServiceImpl
implements MalPlaceOrderService {
    private static final Log log = LogFactory.getLog(MalPlaceOrderServiceImpl.class);

    public MalPlaceOrderVo toPlaceOrder(MalToPlaceOrderParam malToPlaceOrderParam) {
        MalPlaceOrderValidateResult malPlaceOrderValidateResult;
        log.info("toPlaceOrder.malToPlaceOrderParam:" + malToPlaceOrderParam);
        this.validateParam(malToPlaceOrderParam);
        MalPlaceOrderVo res = new MalPlaceOrderVo();
        MalReceiptService malReceiptService = (MalReceiptService)MalBusinessFactory.serviceOf(MalReceiptService.class);
        if (malReceiptService == null) {
            return res;
        }
        MalReceipt malReceipt = malReceiptService.getReceiptById(malToPlaceOrderParam.getReceiptId());
        if (malReceipt == null && (malReceipt = malReceiptService.getDetaultReceipt()) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u4e0b\u5355\u5730\u5740\u3002", (String)"MalPlaceOrderServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]));
        }
        MalSurchargeParam malSurchargeParam = new MalSurchargeParam();
        MalFreightParam malFreightParam = new MalFreightParam();
        malFreightParam.setMalReceipt(malReceipt);
        HashMap<String, String> sourceToInvoiceTypeMap = new HashMap<String, String>(16);
        HashMap<String, String> sourceToInvoiceTypeIdMap = new HashMap<String, String>(16);
        HashMap<String, String> sourceToPayTypeMap = new HashMap<String, String>(16);
        HashMap<String, Object> sourceToMalPayTypeIdMap = new HashMap<String, Object>(16);
        HashMap<Long, BigDecimal> goodsIdToQtyMap = new HashMap<Long, BigDecimal>(16);
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(malToPlaceOrderParam.getMalToPlaceOrderItemList().size() << 2);
        for (MalToPlaceOrderItem malToPlaceOrderItem : malToPlaceOrderParam.getMalToPlaceOrderItemList()) {
            MalMatGoodsInitParam malMatGoodsInitParam = MalMatGoodsInitParam.buildGeneralParamWithSku(malToPlaceOrderItem.getGoodsId(), malToPlaceOrderItem.getGoodsNumber(), malToPlaceOrderItem.getPlatform(), malToPlaceOrderItem.getQty(), malReceipt.getAdmindivisionId(), malToPlaceOrderParam.getDptOrgId());
            malMatGoodsInitParam.setCompareId(malToPlaceOrderItem.getCompareId());
            malMatGoodsInitParam.setQueryPriceFromApi(true);
            malMatGoodsInitParam.setOrgId(malToPlaceOrderParam.getDptOrgId());
            malMatGoodsInitParams.add(malMatGoodsInitParam);
            malSurchargeParam.addGoodsIdToQty(malToPlaceOrderItem.getGoodsId(), malToPlaceOrderItem.getQty());
            String invoiceType = malToPlaceOrderItem.getInvoiceType();
            Object malPayTypeId = malToPlaceOrderItem.getMalPayTypeId();
            String payType = "";
            if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malToPlaceOrderItem.getPlatform())) {
                if (StringUtils.isBlank((CharSequence)invoiceType) && StringUtils.isBlank((CharSequence)(invoiceType = (String)sourceToInvoiceTypeMap.get(malToPlaceOrderItem.getPlatform())))) {
                    invoiceType = EmalParamsUtil.getEmalInvoiceNumber((String)malToPlaceOrderItem.getPlatform());
                    sourceToInvoiceTypeMap.put(malToPlaceOrderItem.getPlatform(), invoiceType);
                    sourceToInvoiceTypeIdMap.put(malToPlaceOrderItem.getPlatform(), String.valueOf(EmalParamsUtil.getInvoiceTypeId((String)malToPlaceOrderItem.getPlatform())));
                }
                if (malPayTypeId == null || (Long)malPayTypeId == 0L) {
                    malPayTypeId = sourceToMalPayTypeIdMap.getOrDefault(malToPlaceOrderItem.getPlatform(), EmalParamsUtil.getPayTypeId((String)malToPlaceOrderItem.getPlatform()));
                    sourceToMalPayTypeIdMap.put(malToPlaceOrderItem.getPlatform(), malPayTypeId);
                    payType = sourceToPayTypeMap.getOrDefault(malToPlaceOrderItem.getPlatform(), PayTypeUtil.getNumberByPayTypeId((Long)malPayTypeId, (String)malToPlaceOrderItem.getPlatform()));
                    sourceToPayTypeMap.put(malToPlaceOrderItem.getPlatform(), payType);
                }
            }
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malToPlaceOrderItem.getPlatform())) {
                if (StringUtils.isBlank((CharSequence)payType)) {
                    payType = "1";
                    sourceToPayTypeMap.put(malToPlaceOrderItem.getPlatform(), payType);
                }
                if (StringUtils.isBlank((CharSequence)invoiceType)) {
                    invoiceType = "2";
                    sourceToInvoiceTypeMap.put(malToPlaceOrderItem.getPlatform(), invoiceType);
                }
            }
            goodsIdToQtyMap.put(malToPlaceOrderItem.getGoodsId(), BigDecimal.ONE);
            MalFeeGoods malFeeGoods = new MalFeeGoods();
            malFeeGoods.setGoodsId(malToPlaceOrderItem.getGoodsId());
            malFeeGoods.setQty(malToPlaceOrderItem.getQty());
            malFeeGoods.setPlatform(malToPlaceOrderItem.getPlatform());
            malFeeGoods.setPayType(payType);
            malFreightParam.addMalFeeGoods(malFeeGoods);
        }
        Map<Long, MalGoods> malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, true, false);
        if (malToPlaceOrderParam.isValidateGoodsForPlaceOrder() && !(malPlaceOrderValidateResult = this.validateGoodsForPlaceOrder(goodsIdToQtyMap, malGoodsMap, false, malToPlaceOrderParam.getDptOrgId())).getErrorInfos().isEmpty()) {
            throw new KDBizException(String.join((CharSequence)(";" + System.lineSeparator()), malPlaceOrderValidateResult.getErrorInfos()));
        }
        DynamicObject placeOrderDyn = CommonUtil.createDefaultDyn((String)"mal_placeorder");
        String defaultCurrency = MalOrderUtil.getDefaultCurrency();
        if (StringUtils.isBlank((CharSequence)defaultCurrency)) {
            defaultCurrency = "1";
        }
        MalSurchargeResult malSurchargeResult = ((MalSurchargeService)MalBusinessFactory.serviceOf(MalSurchargeService.class)).getMalSurcharge(malSurchargeParam);
        for (MalFeeGoods malFeeGoods : malFreightParam.getMalFeeGoodsList()) {
            MalGoods malGoods = malGoodsMap.get(malFeeGoods.getGoodsId());
            if (malGoods == null) continue;
            String supplierId2 = malGoods.getSupplierId();
            if (StringUtils.isBlank((CharSequence)supplierId2)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7535\u5546\u6388\u6743\u5f00\u901a\u72b6\u6001\u662f\u5426\u4e3a\u8fd0\u884c\u4e2d\u3002", (String)"MalPlaceOrderServiceImpl_7", (String)"scm-mal-business", (Object[])new Object[0]));
            }
            malFeeGoods.setSupplierId(Long.valueOf(supplierId2));
            malFeeGoods.setSupplierName(malGoods.getSupplierName());
            malFeeGoods.setFeePrice(malGoods.getTaxPrice());
            malFeeGoods.setGoodsNumber(malGoods.getProductNumber());
        }
        MalFreightResult malFreightResult = ((MalFreightService)MalBusinessFactory.serviceOf(MalFreightService.class)).getMalFreight(malFreightParam);
        MalOrgRelation malOrgRelation = ((MalOrgRelationService)MalBusinessFactory.serviceOf(MalOrgRelationService.class)).getOrgRelationByDptOrgId(malToPlaceOrderParam.getDptOrgId());
        Long businuessType = this.getBusinessType(malToPlaceOrderParam, placeOrderDyn);
        Long defaultLineType = this.getDefaultLineType(businuessType, placeOrderDyn);
        Long defaultPurType = this.getDefalutPurType(defaultLineType);
        Map<Long, Long> goodsIdToMaterialIdMap = this.getGoodsIdToMaterialIdMap(malToPlaceOrderParam, malGoodsMap, defaultPurType);
        HashSet<Long> duplicateGoodsIdSet = new HashSet<Long>(malToPlaceOrderParam.getMalToPlaceOrderItemList().size());
        for (MalToPlaceOrderItem malToPlaceOrderItem : malToPlaceOrderParam.getMalToPlaceOrderItemList()) {
            if (!duplicateGoodsIdSet.add(malToPlaceOrderItem.getGoodsId())) continue;
            MalGoods malGoods = malGoodsMap.get(malToPlaceOrderItem.getGoodsId());
            Long supplierId3 = Long.valueOf(malGoods.getSupplierId());
            MalPlaceOrderEntity malPlaceOrderEntity2 = res.getSupplierIdToPlaceOrderEntityMap().getOrDefault(malGoods.getSupplierId(), new MalPlaceOrderEntity());
            if (malPlaceOrderEntity2 == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u5355\u5f02\u5e38\uff0c\u521d\u59cb\u5316\u4e0b\u5355\u5bf9\u8c61\u5931\u8d25\u3002", (String)"MalPlaceOrderServiceImpl_1", (String)"scm-mal-business", (Object[])new Object[0]));
            }
            malPlaceOrderEntity2.setReqPersonId(Long.valueOf(RequestContext.get().getCurrUserId()));
            malPlaceOrderEntity2.setPlatform(malGoods.getPlatform());
            if (StringUtils.isBlank((CharSequence)malPlaceOrderEntity2.getPlatformName())) {
                malPlaceOrderEntity2.setPlatformName(EcPlatformEnum.fromVal((String)malPlaceOrderEntity2.getPlatform()).getName());
            }
            malPlaceOrderEntity2.setMalReceipt(malReceipt);
            malPlaceOrderEntity2.setMalFreightInfo((MalFreightInfo)malFreightResult.getSupplierIdToFreightInfoMap().get(supplierId3));
            malPlaceOrderEntity2.setCurr(Long.valueOf(defaultCurrency));
            malPlaceOrderEntity2.setBusinessTypeId(businuessType);
            malPlaceOrderEntity2.setMalOrgRelation(malOrgRelation);
            malPlaceOrderEntity2.setDeliDate(DateUtil.getNextDay((Date)new Date()));
            malPlaceOrderEntity2.setTotalExtAmount((BigDecimal)malSurchargeResult.getSupplierIdToExtAmountMap().get(supplierId3));
            malPlaceOrderEntity2.setFreight(malFreightResult.getSupplierIdToFreightInfoMap().getOrDefault(supplierId3, new MalFreightInfo()).getFreight());
            malPlaceOrderEntity2.setInvoiceType((String)sourceToInvoiceTypeMap.get(malToPlaceOrderItem.getPlatform()));
            malPlaceOrderEntity2.setInvoiceTypeId((String)sourceToInvoiceTypeIdMap.get(malToPlaceOrderItem.getPlatform()));
            malPlaceOrderEntity2.setMalPayTypeId((Long)sourceToMalPayTypeIdMap.get(malToPlaceOrderItem.getPlatform()));
            malPlaceOrderEntity2.setPayType((String)sourceToPayTypeMap.get(malToPlaceOrderItem.getPlatform()));
            MalPlaceOrderItem malPlaceOrderItem = this.initMalOrderItem(malToPlaceOrderItem, malGoodsMap, goodsIdToMaterialIdMap, defaultLineType, defaultPurType, malSurchargeResult, malFreightResult);
            malPlaceOrderEntity2.setTotalGoodsAmt(malPlaceOrderEntity2.getTotalGoodsAmt().add(malPlaceOrderItem.getGoodsAmount()));
            this.initExtFiled(malPlaceOrderItem, malToPlaceOrderItem);
            malPlaceOrderEntity2.getPlaceOrderItemList().add(malPlaceOrderItem);
            malPlaceOrderEntity2.setSubTotalAmount(malPlaceOrderEntity2.getTotalGoodsAmt().add(malPlaceOrderEntity2.getTotalExtAmount() == null ? BigDecimal.ZERO : malPlaceOrderEntity2.getTotalExtAmount()).add(malPlaceOrderEntity2.getFreight() == null ? BigDecimal.ZERO : malPlaceOrderEntity2.getFreight()));
            res.getSupplierIdToPlaceOrderEntityMap().put(malGoods.getSupplierId(), malPlaceOrderEntity2);
        }
        res.getSupplierIdToPlaceOrderEntityMap().forEach((supplierId, malPlaceOrderEntity) -> res.setSumAmount(res.getSumAmount().add(malPlaceOrderEntity.getSubTotalAmount())));
        this.fillBaseDataInfo(res);
        log.info("toPlaceOrder.res:" + res);
        return res;
    }

    private void initExtFiled(MalPlaceOrderItem malPlaceOrderItem, MalToPlaceOrderItem malToPlaceOrderItem) {
        malPlaceOrderItem.setExtFiledMap(malToPlaceOrderItem.getExtFiledMap());
    }

    private void validateParam(MalToPlaceOrderParam malToPlaceOrderParam) {
        for (MalToPlaceOrderItem malToPlaceOrderItem : malToPlaceOrderParam.getMalToPlaceOrderItemList()) {
            if (malToPlaceOrderItem.getQty().compareTo(BigDecimal.ZERO) > 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4e0b\u5355\u6570\u91cf\u5e94\u5927\u4e8e0\u3002", (String)"MalPlaceOrderServiceImpl_8", (String)"scm-mal-business", (Object[])new Object[0]));
        }
    }

    private Map<String, Map<Object, DynamicObject>> getEntityKeyToBasedataMap(MalPlaceOrderVo malPlaceOrderVo) {
        HashMap<String, Map<Object, DynamicObject>> res = new HashMap<String, Map<Object, DynamicObject>>(16);
        HashSet<Long> userIdSet = new HashSet<Long>(16);
        userIdSet.add(RequestContext.get().getCurrUserId());
        HashSet<Long> purBizPersonIdSet = new HashSet<Long>(16);
        HashSet<Long> businessTypeIdSet = new HashSet<Long>(16);
        HashSet<Long> purTypeIdSet = new HashSet<Long>(16);
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        HashSet<Long> goodsUseIdSet = new HashSet<Long>(16);
        HashSet<Long> costProjectIdSet = new HashSet<Long>(16);
        HashSet<Long> receiptIdSet = new HashSet<Long>(16);
        HashSet<Long> taxRateIdSet = new HashSet<Long>(16);
        HashSet<Long> goodsIdSet = new HashSet<Long>(32);
        HashSet<Long> lineTypeIdSet = new HashSet<Long>(16);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        HashSet<Long> supplierIdSet = new HashSet<Long>(16);
        for (MalPlaceOrderEntity malPlaceOrderEntity : malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap().values()) {
            MalOrgRelation malOrgRelation = malPlaceOrderEntity.getMalOrgRelation();
            orgIdSet.add(malOrgRelation.getCostOrgId());
            orgIdSet.add(malOrgRelation.getDepOrgId());
            orgIdSet.add(malOrgRelation.getExpenseOrgId());
            orgIdSet.add(malOrgRelation.getInvoiceOrgId());
            orgIdSet.add(malOrgRelation.getPurOrgId());
            orgIdSet.add(malOrgRelation.getRcvOrgId());
            orgIdSet.add(malOrgRelation.getSettleOrgId());
            Long reqPersonId = malPlaceOrderEntity.getReqPersonId();
            if (reqPersonId != null && reqPersonId != 0L) {
                userIdSet.add(reqPersonId);
            }
            if (malPlaceOrderEntity.getPersonId() != null && malPlaceOrderEntity.getPersonId() != 0L) {
                purBizPersonIdSet.add(malPlaceOrderEntity.getPersonId());
            }
            if (malPlaceOrderEntity.getBusinessTypeId() != null && malPlaceOrderEntity.getBusinessTypeId() != 0L) {
                businessTypeIdSet.add(malPlaceOrderEntity.getBusinessTypeId());
            }
            if (malPlaceOrderEntity.getMalReceipt().getReceiptId() != null && malPlaceOrderEntity.getMalReceipt().getReceiptId() != 0L) {
                receiptIdSet.add(malPlaceOrderEntity.getMalReceipt().getReceiptId());
            }
            for (MalPlaceOrderItem malPlaceOrderItem : malPlaceOrderEntity.getPlaceOrderItemList()) {
                Long lineTypeId;
                Long goodsId;
                Long taxRateId;
                Long costProjectId;
                Long goodsUseId;
                Long autoMappingMaterialId;
                Long materialId;
                Long purTypeId = malPlaceOrderItem.getPurTypeId();
                if (purTypeId != null && purTypeId != 0L) {
                    purTypeIdSet.add(purTypeId);
                }
                if ((materialId = malPlaceOrderItem.getMaterialId()) != null && materialId != 0L) {
                    materialIdSet.add(materialId);
                }
                if ((autoMappingMaterialId = malPlaceOrderItem.getAutoMappingMaterialId()) != null && autoMappingMaterialId != 0L) {
                    materialIdSet.add(autoMappingMaterialId);
                }
                if ((goodsUseId = malPlaceOrderItem.getGoodsUseId()) != null && goodsUseId != 0L) {
                    goodsUseIdSet.add(goodsUseId);
                }
                if ((costProjectId = malPlaceOrderItem.getCostProjectId()) != null && costProjectId != 0L) {
                    costProjectIdSet.add(costProjectId);
                }
                if ((taxRateId = malPlaceOrderItem.getTaxRateId()) != null && taxRateId != 0L) {
                    taxRateIdSet.add(taxRateId);
                }
                if ((goodsId = malPlaceOrderItem.getGoodsId()) != null && goodsId != 0L) {
                    goodsIdSet.add(goodsId);
                }
                if ((lineTypeId = malPlaceOrderItem.getLineTypeId()) != null && lineTypeId != 0L) {
                    lineTypeIdSet.add(lineTypeId);
                }
                Long supplierId = malPlaceOrderItem.getSupplierId();
                if (lineTypeId == null || supplierId == 0L) continue;
                supplierIdSet.add(supplierId);
            }
        }
        orgIdSet.removeIf(Objects::isNull);
        if (!userIdSet.isEmpty()) {
            res.put("bos_user", BusinessDataServiceHelper.loadFromCache((Object[])userIdSet.toArray(), (String)"bos_user"));
        }
        if (!purBizPersonIdSet.isEmpty()) {
            res.put("pur_bizperson", BusinessDataServiceHelper.loadFromCache((Object[])purBizPersonIdSet.toArray(), (String)"pur_bizperson"));
        }
        if (!businessTypeIdSet.isEmpty()) {
            res.put("bd_biztype", BusinessDataServiceHelper.loadFromCache((Object[])businessTypeIdSet.toArray(), (String)"bd_biztype"));
        }
        if (!purTypeIdSet.isEmpty()) {
            res.put("pbd_mallextdata", BusinessDataServiceHelper.loadFromCache((Object[])purTypeIdSet.toArray(), (String)"pbd_mallextdata"));
        }
        if (!materialIdSet.isEmpty()) {
            res.put("bd_material", BusinessDataServiceHelper.loadFromCache((Object[])materialIdSet.toArray(), (String)"bd_material"));
        }
        if (!goodsUseIdSet.isEmpty()) {
            res.put("pmm_goods_use", BusinessDataServiceHelper.loadFromCache((Object[])goodsUseIdSet.toArray(), (String)"pmm_goods_use"));
        }
        if (!costProjectIdSet.isEmpty()) {
            res.put("er_expenseitemedit", BusinessDataServiceHelper.loadFromCache((Object[])costProjectIdSet.toArray(), (String)"er_expenseitemedit"));
        }
        if (!receiptIdSet.isEmpty()) {
            res.put("mal_address", BusinessDataServiceHelper.loadFromCache((Object[])receiptIdSet.toArray(), (String)"mal_address"));
        }
        if (!taxRateIdSet.isEmpty()) {
            res.put("bd_taxrate", BusinessDataServiceHelper.loadFromCache((Object[])taxRateIdSet.toArray(), (String)"bd_taxrate"));
        }
        if (!goodsIdSet.isEmpty()) {
            res.put("pmm_prodmanage", BusinessDataServiceHelper.loadFromCache((Object[])goodsIdSet.toArray(), (String)"pmm_prodmanage"));
        }
        if (!lineTypeIdSet.isEmpty()) {
            res.put("bd_linetype", BusinessDataServiceHelper.loadFromCache((Object[])lineTypeIdSet.toArray(), (String)"bd_linetype"));
        }
        if (!orgIdSet.isEmpty()) {
            res.put("bos_org", BusinessDataServiceHelper.loadFromCache((Object[])orgIdSet.toArray(), (String)"bos_org"));
        }
        if (!supplierIdSet.isEmpty()) {
            res.put("bd_supplier", BusinessDataServiceHelper.loadFromCache((Object[])supplierIdSet.toArray(), (String)"bd_supplier"));
        }
        return res;
    }

    private void fillBaseDataInfo(MalPlaceOrderVo malPlaceOrderVo) {
        Map<String, Map<Object, DynamicObject>> entityKeyToBasedataMap = this.getEntityKeyToBasedataMap(malPlaceOrderVo);
        HashSet<Long> invoiceOrgIdSet = new HashSet<Long>();
        for (MalPlaceOrderEntity malPlaceOrderEntity : malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap().values()) {
            MalOrgRelation malOrgRelation = malPlaceOrderEntity.getMalOrgRelation();
            if (malOrgRelation.getInvoiceOrgId() == null) continue;
            invoiceOrgIdSet.add(malOrgRelation.getInvoiceOrgId());
        }
        Map bosOrgMap = BusinessDataServiceHelper.loadFromCache((Object[])invoiceOrgIdSet.toArray(), (String)"bos_org");
        for (MalPlaceOrderEntity malPlaceOrderEntity : malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap().values()) {
            MalOrgRelation malOrgRelation;
            DynamicObject businessTypeDyn;
            DynamicObject reqPersonDyn;
            DynamicObject personDyn = (DynamicObject)((Map)entityKeyToBasedataMap.getOrDefault("pur_bizperson", new HashMap())).get(malPlaceOrderEntity.getPersonId());
            if (personDyn != null) {
                malPlaceOrderEntity.setPersonName(personDyn.getString("name"));
            }
            if ((reqPersonDyn = (DynamicObject)((Map)entityKeyToBasedataMap.getOrDefault("bos_user", new HashMap())).get(malPlaceOrderEntity.getReqPersonId())) != null) {
                malPlaceOrderEntity.setReqPersonName(reqPersonDyn.getString("name"));
            }
            if ((businessTypeDyn = (DynamicObject)((Map)entityKeyToBasedataMap.getOrDefault("bd_biztype", new HashMap())).get(malPlaceOrderEntity.getBusinessTypeId())) != null) {
                malPlaceOrderEntity.setBusinessTypeName(businessTypeDyn.getString("name"));
            }
            if ((malOrgRelation = malPlaceOrderEntity.getMalOrgRelation()).getInvoiceOrgId() != null) {
                malPlaceOrderEntity.setMalInvoicingInfo(this.fillInvoicingInfo((DynamicObject)bosOrgMap.get(malOrgRelation.getInvoiceOrgId())));
            }
            for (MalPlaceOrderItem malPlaceOrderItem : malPlaceOrderEntity.getPlaceOrderItemList()) {
                DynamicObject costProjectDyn;
                DynamicObject goodsUseDyn;
                DynamicObject autoMappingMaterialDyn;
                DynamicObject materialDyn;
                DynamicObject purTypeDyn = (DynamicObject)((Map)entityKeyToBasedataMap.getOrDefault("pbd_mallextdata", new HashMap())).get(malPlaceOrderItem.getPurTypeId());
                if (purTypeDyn != null) {
                    malPlaceOrderItem.setPurTypeName(purTypeDyn.getString("name"));
                }
                if ((materialDyn = (DynamicObject)((Map)entityKeyToBasedataMap.getOrDefault("bd_material", new HashMap())).get(malPlaceOrderItem.getMaterialId())) != null) {
                    malPlaceOrderItem.setMaterialName(materialDyn.getString("name"));
                }
                if ((autoMappingMaterialDyn = (DynamicObject)((Map)entityKeyToBasedataMap.getOrDefault("bd_material", new HashMap())).get(malPlaceOrderItem.getAutoMappingMaterialId())) != null) {
                    malPlaceOrderItem.setAutoMappingMaterialName(autoMappingMaterialDyn.getString("name"));
                }
                if ((goodsUseDyn = (DynamicObject)((Map)entityKeyToBasedataMap.getOrDefault("pmm_goods_use", new HashMap())).get(malPlaceOrderItem.getGoodsUseId())) != null) {
                    malPlaceOrderItem.setGoodsUseName(goodsUseDyn.getString("name"));
                }
                if ((costProjectDyn = (DynamicObject)((Map)entityKeyToBasedataMap.getOrDefault("er_expenseitemedit", new HashMap())).get(malPlaceOrderItem.getCostProjectId())) == null) continue;
                malPlaceOrderItem.setCostProjectName(costProjectDyn.getString("name"));
            }
        }
    }

    private MalInvoicingInfo fillInvoicingInfo(DynamicObject invoiceOrgDyn) {
        if (invoiceOrgDyn == null) {
            return null;
        }
        MalInvoicingInfo malInvoicingInfo = new MalInvoicingInfo();
        malInvoicingInfo.setInvoiceOrgId(Long.valueOf(invoiceOrgDyn.getLong("id")));
        malInvoicingInfo.setInvoiceOrgName(invoiceOrgDyn.getString("name"));
        malInvoicingInfo.setTitle(invoiceOrgDyn.getString("ffirmname"));
        malInvoicingInfo.setTaxRegNum(invoiceOrgDyn.getString("ftaxregnum"));
        malInvoicingInfo.setDepositBank(invoiceOrgDyn.getString("depositbank"));
        malInvoicingInfo.setBankAccount(invoiceOrgDyn.getString("bankaccount"));
        malInvoicingInfo.setAddress(invoiceOrgDyn.getString("faddress"));
        malInvoicingInfo.setPhone(invoiceOrgDyn.getString("phone"));
        return malInvoicingInfo;
    }

    public MalCreateOrderResult createMalOrder(MalPlaceOrderVo malPlaceOrderVo, Map<String, DynamicObject> platformToMalOrderDynMap) {
        Throwable malFreightInfo;
        log.info("\u5f00\u59cb\u521b\u5efa\u5546\u57ce\u8ba2\u5355\uff1a" + malPlaceOrderVo);
        MalCreateOrderResult malCreateOrderResult = new MalCreateOrderResult();
        ArrayList malPlaceOrderEntities = new ArrayList(malPlaceOrderVo.getSupplierIdToPlaceOrderEntityMap().values());
        ArrayList<Long> orderedGoodsIds = new ArrayList<Long>(32);
        Map<String, Map<Object, DynamicObject>> entityKeyToBasedataMap = this.getEntityKeyToBasedataMap(malPlaceOrderVo);
        HashMap<Object, Object> innerPlatformToMalOrderDynMap = platformToMalOrderDynMap == null ? new HashMap(16) : new HashMap<String, DynamicObject>(platformToMalOrderDynMap);
        DynamicObject billtypeDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)1317361223599179776L, (String)"bos_billtype");
        for (MalPlaceOrderEntity malPlaceOrderEntity : malPlaceOrderEntities) {
            DynamicObject malOrderDyn = innerPlatformToMalOrderDynMap.getOrDefault(malPlaceOrderEntity.getPlatform(), CommonUtil.createDefaultDyn((String)"mal_order"));
            this.handleHeadInfo(malOrderDyn, malPlaceOrderEntity, entityKeyToBasedataMap, billtypeDyn);
            for (MalPlaceOrderItem malPlaceOrderItem : malPlaceOrderEntity.getPlaceOrderItemList()) {
                this.handleEntryInfo(malOrderDyn, malPlaceOrderItem, entityKeyToBasedataMap);
                orderedGoodsIds.add(malPlaceOrderItem.getGoodsId());
            }
            malFreightInfo = malPlaceOrderEntity.getMalFreightInfo();
            if (malFreightInfo != null && malFreightInfo.isHasTailDiff()) {
                Cal4DynamicObj.calByTaxAmount((DynamicObject)malOrderDyn, (String)"entryentity");
            } else {
                Cal4DynamicObj.reCalBill((DynamicObject)malOrderDyn, (String)"entryentity");
            }
            innerPlatformToMalOrderDynMap.put(malPlaceOrderEntity.getPlatform(), malOrderDyn);
        }
        OperationResult submitResult = null;
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        try {
            malFreightInfo = null;
            try (TXHandle h = TX.required();){
                OperationResult saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"mal_order", (DynamicObject[])innerPlatformToMalOrderDynMap.values().toArray(new DynamicObject[0]), (OperateOption)option);
                try {
                    CommonUtil.check((OperationResult)saveResult);
                }
                catch (Exception e) {
                    if (!saveResult.getSuccessPkIds().isEmpty()) {
                        OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"mal_order", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
                        try {
                            CommonUtil.check((OperationResult)deleteResult);
                        }
                        catch (Exception delException) {
                            log.warn("\u4e0b\u5355\u5931\u8d25\uff0c\u5f3a\u5236\u5220\u9664\u8ba2\u5355\uff1a" + saveResult.getSuccessPkIds() + System.lineSeparator() + ExceptionUtil.getStackTrace((Throwable)delException));
                            DeleteServiceHelper.delete((String)"mal_order", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)saveResult.getSuccessPkIds())});
                        }
                    }
                    throw new KDBizException(e.getMessage());
                }
                submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"mal_order", (Object[])saveResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
                try {
                    CommonUtil.check((OperationResult)submitResult);
                }
                catch (Exception e) {
                    if (!submitResult.getSuccessPkIds().isEmpty()) {
                        OperationResult unSubmitResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"mal_order", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
                        try {
                            CommonUtil.check((OperationResult)unSubmitResult);
                        }
                        catch (Exception exception) {
                            log.warn(ExceptionUtil.getStackTrace((Throwable)exception));
                        }
                    }
                    OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"mal_order", (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
                    try {
                        CommonUtil.check((OperationResult)deleteResult);
                    }
                    catch (Exception exception) {
                        log.warn(ExceptionUtil.getStackTrace((Throwable)exception));
                    }
                    throw new KDBizException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                malFreightInfo = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            log.warn("\u4fdd\u5b58\u5546\u57ce\u8ba2\u5355\u5931\u8d25\uff1a" + e.getMessage() + System.lineSeparator() + "malPlaceOrderVo:" + malPlaceOrderVo);
            log.warn("\u4fdd\u5b58\u5546\u57ce\u8ba2\u5355\u5931\u8d25\u5806\u6808\u4fe1\u606f\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            malCreateOrderResult.getErrorMsgs().add(e.getMessage());
        }
        if (submitResult != null) {
            String bizflow = MalOrderUtil.getBizFlowParam();
            if (StringUtils.equalsIgnoreCase((CharSequence)bizflow, (CharSequence)MalBizflowParamEnum.ERP_PURORDER.getVal())) {
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"mal_order", (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
                CommonUtil.check((OperationResult)auditResult);
            }
            DynamicObject[] malOrdyDyns = BusinessDataServiceHelper.load((Object[])submitResult.getSuccessPkIds().toArray(), (DynamicObjectType)((DynamicObject)new ArrayList(innerPlatformToMalOrderDynMap.values()).get(0)).getDynamicObjectType());
            malCreateOrderResult.setMalOrderDynList(Arrays.asList(malOrdyDyns));
            if (malPlaceOrderVo.isClearOrderedGoodsInShopCart() && malCreateOrderResult.getErrorMsgs().isEmpty()) {
                MalProductUtil.deleteCartProds(orderedGoodsIds);
                ((MalShopCartService)MalBusinessFactory.serviceOf(MalShopCartService.class)).deleteCartItems(orderedGoodsIds);
                log.info("\u4ece\u8d2d\u7269\u8f66\u4e2d\u5220\u9664\u5df2\u4e0b\u5355\u5546\u54c1");
            }
        }
        return malCreateOrderResult;
    }

    private void handleEntryInfo(DynamicObject malOrderDyn, MalPlaceOrderItem malPlaceOrderItem, Map<String, Map<Object, DynamicObject>> entityKeyToBasedataMap) {
        DynamicObjectCollection entryentityCol = malOrderDyn.getDynamicObjectCollection("entryentity");
        DynamicObject entry = null;
        boolean isNewRow = false;
        for (DynamicObject initEntry : entryentityCol) {
            if (!StringUtils.equals((CharSequence)initEntry.getString("goods"), (CharSequence)String.valueOf(malPlaceOrderItem.getGoodsId()))) continue;
            entry = initEntry;
        }
        if (entry == null) {
            entry = new DynamicObject(entryentityCol.getDynamicObjectType());
            isNewRow = true;
        }
        entry.set("qty", (Object)malPlaceOrderItem.getQty());
        Long materialId = malPlaceOrderItem.getMaterialId() == null ? malPlaceOrderItem.getAutoMappingMaterialId() : malPlaceOrderItem.getMaterialId();
        entry.set("material_id", (Object)materialId);
        entry.set("material", ((Map)entityKeyToBasedataMap.getOrDefault("bd_material", new HashMap())).get(materialId));
        entry.set("goodsimg", (Object)malPlaceOrderItem.getThumbnail());
        entry.set("goodsdesc", (Object)malPlaceOrderItem.getProductDesc());
        entry.set("erpsourceid", (Object)malPlaceOrderItem.getErpSourceId());
        entry.set("erpsourceentryid", (Object)malPlaceOrderItem.getErpSourceEntryId());
        entry.set("erpsourcebilltype", (Object)malPlaceOrderItem.getErpSourceBillType());
        entry.set("protocolno", (Object)malPlaceOrderItem.getProtocolNo());
        entry.set("taxrateid_id", (Object)malPlaceOrderItem.getTaxRateId());
        entry.set("taxrateid", ((Map)entityKeyToBasedataMap.getOrDefault("bd_taxrate", new HashMap())).get(malPlaceOrderItem.getTaxRateId()));
        entry.set("taxrate", (Object)malPlaceOrderItem.getTaxRate());
        entry.set("compareid", (Object)malPlaceOrderItem.getCompareId());
        entry.set("goodsuse_id", (Object)malPlaceOrderItem.getGoodsUseId());
        entry.set("goodsuse", ((Map)entityKeyToBasedataMap.getOrDefault("pmm_goods_use", new HashMap())).get(malPlaceOrderItem.getGoodsUseId()));
        entry.set("taxamount", (Object)malPlaceOrderItem.getTaxAmount());
        entry.set("taxprice", (Object)malPlaceOrderItem.getTaxPrice());
        entry.set("supplier_id", (Object)malPlaceOrderItem.getSupplierId());
        entry.set("supplier", ((Map)entityKeyToBasedataMap.getOrDefault("bd_supplier", new HashMap())).get(malPlaceOrderItem.getSupplierId()));
        entry.set("unit_id", (Object)malPlaceOrderItem.getProductUnitId());
        entry.set("unit", (Object)malPlaceOrderItem.getProductUnitId());
        entry.set("goods_id", (Object)malPlaceOrderItem.getGoodsId());
        entry.set("goods", ((Map)entityKeyToBasedataMap.getOrDefault("pmm_prodmanage", new HashMap())).get(malPlaceOrderItem.getGoodsId()));
        entry.set("purtype_id", (Object)malPlaceOrderItem.getPurTypeId());
        entry.set("purtype", ((Map)entityKeyToBasedataMap.getOrDefault("pbd_mallextdata", new HashMap())).get(malPlaceOrderItem.getPurTypeId()));
        entry.set("linetype_id", (Object)malPlaceOrderItem.getLineTypeId());
        entry.set("linetype", ((Map)entityKeyToBasedataMap.getOrDefault("bd_linetype", new HashMap())).get(malPlaceOrderItem.getLineTypeId()));
        entry.set("entrycostproject_id", (Object)malPlaceOrderItem.getCostProjectId());
        entry.set("entrycostproject", ((Map)entityKeyToBasedataMap.getOrDefault("er_expenseitemedit", new HashMap())).get(malPlaceOrderItem.getCostProjectId()));
        entry.set("compareresult", (Object)malPlaceOrderItem.getCompareResult());
        entry.set("compareremark", (Object)malPlaceOrderItem.getCompareRemark());
        entry.set("protocolsourceid", (Object)malPlaceOrderItem.getProtocolId());
        entry.set("protocolsourceentryid", (Object)malPlaceOrderItem.getProtocolEntryId());
        entry.set("entrystatus", (Object)BillEntryStatusEnum.COMMON.getVal());
        entry.set("addvalue", (Object)"2");
        entry.set("note", (Object)malPlaceOrderItem.getNote());
        if (isNewRow) {
            entryentityCol.add((Object)entry);
        }
    }

    private void handleHeadInfo(DynamicObject malOrderDyn, MalPlaceOrderEntity malPlaceOrderEntity, Map<String, Map<Object, DynamicObject>> entityKeyToBasedataMap, DynamicObject billtypeDyn) {
        DynamicObject bdInvoiceTypeDyn;
        DynamicObject payTypeDyn;
        malOrderDyn.set("curr_id", (Object)malPlaceOrderEntity.getCurr());
        malOrderDyn.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        malOrderDyn.set("creator", ((Map)entityKeyToBasedataMap.getOrDefault("bos_user", new HashMap())).get(RequestContext.get().getCurrUserId()));
        malOrderDyn.set("loccurr", (Object)MalOrderUtil.getEcCurrencyId((String)malPlaceOrderEntity.getPlatform()));
        malOrderDyn.set("org_id", (Object)malPlaceOrderEntity.getMalOrgRelation().getPurOrgId());
        malOrderDyn.set("org", ((Map)entityKeyToBasedataMap.getOrDefault("bos_org", new HashMap())).get(malPlaceOrderEntity.getMalOrgRelation().getPurOrgId()));
        malOrderDyn.set("remark", (Object)malPlaceOrderEntity.getRemark());
        malOrderDyn.set("businesstype_id", (Object)malPlaceOrderEntity.getBusinessTypeId());
        malOrderDyn.set("businesstype", ((Map)entityKeyToBasedataMap.getOrDefault("bd_biztype", new HashMap())).get(malPlaceOrderEntity.getBusinessTypeId()));
        malOrderDyn.set("delidate", (Object)malPlaceOrderEntity.getDeliDate());
        malOrderDyn.set("receipt_id", (Object)malPlaceOrderEntity.getMalReceipt().getReceiptId());
        malOrderDyn.set("receipt", ((Map)entityKeyToBasedataMap.getOrDefault("mal_address", new HashMap())).get(malPlaceOrderEntity.getMalReceipt().getReceiptId()));
        malOrderDyn.set("billtype", (Object)billtypeDyn);
        if (malPlaceOrderEntity.getMalPayTypeId() != null && (payTypeDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)malPlaceOrderEntity.getMalPayTypeId(), (String)"pbd_paytype")) != null) {
            malOrderDyn.set("settletype_id", (Object)payTypeDyn.getLong("settletypeid.id"));
            malOrderDyn.set("settletype", payTypeDyn.get("settletypeid"));
            malOrderDyn.set("paycond_id", (Object)payTypeDyn.getLong("purcondition.id"));
            malOrderDyn.set("paycond", payTypeDyn.get("purcondition"));
            malOrderDyn.set("malpaytype_id", payTypeDyn.getPkValue());
            malOrderDyn.set("malpaytype", (Object)payTypeDyn);
        }
        malOrderDyn.set("invtype", (Object)malPlaceOrderEntity.getInvoiceType());
        malOrderDyn.set("freight", (Object)malPlaceOrderEntity.getFreight());
        malOrderDyn.set("platform", (Object)malPlaceOrderEntity.getPlatform());
        malOrderDyn.set("settleorg_id", (Object)malPlaceOrderEntity.getMalOrgRelation().getSettleOrgId());
        malOrderDyn.set("settleorg", ((Map)entityKeyToBasedataMap.getOrDefault("bos_org", new HashMap())).get(malPlaceOrderEntity.getMalOrgRelation().getSettleOrgId()));
        malOrderDyn.set("rcvorg_id", (Object)malPlaceOrderEntity.getMalOrgRelation().getRcvOrgId());
        malOrderDyn.set("rcvorg", ((Map)entityKeyToBasedataMap.getOrDefault("bos_org", new HashMap())).get(malPlaceOrderEntity.getMalOrgRelation().getRcvOrgId()));
        malOrderDyn.set("deporg_id", (Object)malPlaceOrderEntity.getMalOrgRelation().getDepOrgId());
        malOrderDyn.set("deporg", ((Map)entityKeyToBasedataMap.getOrDefault("bos_org", new HashMap())).get(malPlaceOrderEntity.getMalOrgRelation().getDepOrgId()));
        malOrderDyn.set("costorg_id", (Object)malPlaceOrderEntity.getMalOrgRelation().getCostOrgId());
        malOrderDyn.set("costorg", ((Map)entityKeyToBasedataMap.getOrDefault("bos_org", new HashMap())).get(malPlaceOrderEntity.getMalOrgRelation().getCostOrgId()));
        malOrderDyn.set("invoiceorg_id", (Object)malPlaceOrderEntity.getMalOrgRelation().getInvoiceOrgId());
        malOrderDyn.set("invoiceorg", ((Map)entityKeyToBasedataMap.getOrDefault("bos_org", new HashMap())).get(malPlaceOrderEntity.getMalOrgRelation().getInvoiceOrgId()));
        malOrderDyn.set("expenseorg_id", (Object)malPlaceOrderEntity.getMalOrgRelation().getExpenseOrgId());
        malOrderDyn.set("expenseorg", (Object)malPlaceOrderEntity.getMalOrgRelation().getExpenseOrgId());
        malOrderDyn.set("reqperson_id", ((Map)entityKeyToBasedataMap.getOrDefault("bos_org", new HashMap())).get(malPlaceOrderEntity.getMalOrgRelation().getInvoiceOrgId()));
        malOrderDyn.set("reqperson_id", (Object)malPlaceOrderEntity.getReqPersonId());
        malOrderDyn.set("reqperson", ((Map)entityKeyToBasedataMap.getOrDefault("bos_user", new HashMap())).get(malPlaceOrderEntity.getReqPersonId()));
        malOrderDyn.set("person_id", (Object)malPlaceOrderEntity.getPersonId());
        malOrderDyn.set("person", ((Map)entityKeyToBasedataMap.getOrDefault("pur_bizperson", new HashMap())).get(malPlaceOrderEntity.getPersonId()));
        malOrderDyn.set("ecsource", (Object)MalNewOrderUtils.getPlatformId((String)malPlaceOrderEntity.getPlatform()));
        String invoiceTypeId = malPlaceOrderEntity.getInvoiceTypeId();
        String bdInvoiceTypeId = "0";
        if (!StringUtils.isEmpty((CharSequence)invoiceTypeId) && !StringUtils.equals((CharSequence)invoiceTypeId, (CharSequence)"0")) {
            bdInvoiceTypeDyn = this.getBdInvoiceTypeId(invoiceTypeId);
            if (null != bdInvoiceTypeDyn) {
                malOrderDyn.set("malinvtype_id", (Object)bdInvoiceTypeDyn.getString("bdinvoicetype.id"));
                malOrderDyn.set("invtype", (Object)bdInvoiceTypeDyn.getString("emalinvoicenumber"));
            } else {
                bdInvoiceTypeId = EmalParamsUtil.getBdInvoiceTypeId((String)malPlaceOrderEntity.getPlatform());
            }
        } else {
            bdInvoiceTypeId = EmalParamsUtil.getBdInvoiceTypeId((String)malPlaceOrderEntity.getPlatform());
        }
        if (!StringUtils.equals((CharSequence)bdInvoiceTypeId, (CharSequence)"0") && null != (bdInvoiceTypeDyn = this.getBdInvoiceTypeId(bdInvoiceTypeId))) {
            malOrderDyn.set("malinvtype_id", (Object)bdInvoiceTypeDyn.getString("bdinvoicetype.id"));
            malOrderDyn.set("invtype", (Object)bdInvoiceTypeDyn.getString("emalinvoicenumber"));
        }
    }

    private DynamicObject getBdInvoiceTypeId(String emalType) {
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(emalType));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_invoicetype", (String)"bdinvoicetype.id,emalinvoicenumber", (QFilter[])filter.toArray());
    }

    private Long getDefalutPurType(Long defaultLineType) {
        DynamicObjectCollection purTypeCol = QueryServiceHelper.query((String)"pbd_mallextdata", (String)"id", (QFilter[])new QFilter[]{new QFilter("linetype", "=", (Object)defaultLineType)}, (String)"number desc");
        if (!Objects.isNull(purTypeCol) && purTypeCol.size() > 0) {
            return ((DynamicObject)purTypeCol.get(0)).getLong("id");
        }
        return 0L;
    }

    private Long getDefaultLineType(Long businessType, DynamicObject placeOrderDyn) {
        if (businessType == null || businessType == 0L) {
            businessType = placeOrderDyn.getLong("businesstype");
        }
        if (businessType != 0L) {
            return BizTypeHelper.getDefaultLineType((Long)businessType);
        }
        return 0L;
    }

    private MalPlaceOrderItem initMalOrderItem(MalToPlaceOrderItem malToPlaceOrderItem, Map<Long, MalGoods> malGoodsMap, Map<Long, Long> goodsIdToMaterialIdMap, Long defaultLineType, Long defaultPurType, MalSurchargeResult malSurchageResult, MalFreightResult malFreightResult) {
        MalGoods malGoods;
        MalPlaceOrderItem malPlaceOrderItem = new MalPlaceOrderItem();
        malPlaceOrderItem.setQty(malToPlaceOrderItem.getQty());
        malPlaceOrderItem.setCompareId(malToPlaceOrderItem.getCompareId());
        malPlaceOrderItem.setCompareResult(this.getCompareResult(malToPlaceOrderItem, malGoodsMap));
        malPlaceOrderItem.setCostProjectId(malToPlaceOrderItem.getCostProjectId());
        malPlaceOrderItem.setGoodsUseId(malToPlaceOrderItem.getGoodsUseId());
        malPlaceOrderItem.setErpSourceBillType(malToPlaceOrderItem.getErpSourceBillType());
        malPlaceOrderItem.setErpSourceEntryId(malToPlaceOrderItem.getErpSourceEntryId());
        malPlaceOrderItem.setErpSourceId(malToPlaceOrderItem.getErpSourceId());
        Long lineTypeId = malToPlaceOrderItem.getLineTypeId();
        if (lineTypeId == null || lineTypeId == 0L) {
            lineTypeId = defaultLineType;
        }
        malPlaceOrderItem.setLineTypeId(lineTypeId);
        Long purTypeId = malToPlaceOrderItem.getPurTypeId();
        if (purTypeId == null || purTypeId == 0L) {
            purTypeId = defaultPurType;
        }
        malPlaceOrderItem.setPurTypeId(purTypeId);
        Long materialId = malToPlaceOrderItem.getMaterialId();
        if (materialId == null || materialId == 0L) {
            materialId = goodsIdToMaterialIdMap.getOrDefault(malToPlaceOrderItem.getGoodsId(), 0L);
            malPlaceOrderItem.setAutoMappingMaterialId(materialId);
        }
        if ((malGoods = malGoodsMap.get(malToPlaceOrderItem.getGoodsId())) != null) {
            BigDecimal avgFreight;
            malPlaceOrderItem.setGoodsId(malGoods.getId());
            malPlaceOrderItem.setPlatform(malGoods.getPlatform());
            malPlaceOrderItem.setGoodsName(malGoods.getName());
            malPlaceOrderItem.setGoodsNumber(malGoods.getNumber());
            malPlaceOrderItem.setThumbnail(malGoods.getThumbnail());
            malPlaceOrderItem.setProductModel(malGoods.getProductModel());
            malPlaceOrderItem.setProductDesc(malGoods.getGoodsInfo().getProductDesc());
            malPlaceOrderItem.setProductUnitId(Long.valueOf(malGoods.getProductUnitID()));
            malPlaceOrderItem.setTaxRateId(malGoods.getTaxrateId());
            malPlaceOrderItem.setTaxRate(malGoods.getTaxRate());
            malPlaceOrderItem.setSupplierId(Long.valueOf(malGoods.getSupplierId()));
            malPlaceOrderItem.setMinOrderQty(malGoods.getMinOrderQty());
            malPlaceOrderItem.setProtocolId(malGoods.getGoodsInfo().getProtocolId());
            malPlaceOrderItem.setProtocolEntryId(malGoods.getGoodsInfo().getProtocolEntryId());
            malPlaceOrderItem.setProtocolNo(malGoods.getProtocolBillno());
            malPlaceOrderItem.setStockDesc(malGoods.getStockDesc());
            malPlaceOrderItem.setGoodsAmount(malGoods.getTaxPrice().multiply(malToPlaceOrderItem.getQty()));
            malPlaceOrderItem.setSupplierId(Long.valueOf(malGoods.getSupplierId()));
            malPlaceOrderItem.setSupplierName(malGoods.getSupplierName());
            MalSurchargeInfo malSurchargeInfo = (MalSurchargeInfo)malSurchageResult.getGoodsIdToSurchargeInfo().get(malToPlaceOrderItem.getGoodsId());
            BigDecimal perAmount = BigDecimal.ZERO;
            if (malSurchargeInfo != null) {
                malPlaceOrderItem.setExtAmount(malSurchargeInfo.getRowTotalExtAmount() == null ? BigDecimal.ZERO : malSurchargeInfo.getRowTotalExtAmount());
                perAmount = malSurchargeInfo.getPerAmount();
            }
            malPlaceOrderItem.setAvgFreight((avgFreight = (BigDecimal)malFreightResult.getGoodsIdToAvgFreightMap().get(malToPlaceOrderItem.getGoodsId())) == null ? BigDecimal.ZERO : avgFreight);
            BigDecimal singleAvgFreight = (BigDecimal)malFreightResult.getGoodsIdToSingleAvgFreightMap().get(malToPlaceOrderItem.getGoodsId());
            malPlaceOrderItem.setGoodsPrice(malGoods.getTaxPrice());
            malPlaceOrderItem.setTaxPrice(malGoods.getTaxPrice().add(singleAvgFreight == null ? BigDecimal.ZERO : singleAvgFreight).add(perAmount));
            malPlaceOrderItem.setTaxAmount(malPlaceOrderItem.getGoodsAmount().add(malPlaceOrderItem.getExtAmount()).add(malPlaceOrderItem.getAvgFreight()));
        }
        return malPlaceOrderItem;
    }

    private String getCompareResult(MalToPlaceOrderItem malToPlaceOrderItem, Map<Long, MalGoods> malGoodsMap) {
        String res = "A";
        MalGoods malGoods = malGoodsMap.get(malToPlaceOrderItem.getGoodsId());
        if (malGoods != null && malToPlaceOrderItem.getCompareId() != null && !ObjectUtils.isEmpty(malGoods.getComparePrices())) {
            for (ComparePriceInfo info : malGoods.getComparePrices()) {
                if (!info.getGoodsId().equals(malGoods.getId()) || !info.getCompareResult().equals("1")) continue;
                return "B";
            }
            return "C";
        }
        return res;
    }

    private Map<Long, Long> getGoodsIdToMaterialIdMap(MalToPlaceOrderParam malToPlaceOrderParam, Map<Long, MalGoods> malGoodsMap, Long defaultPurType) {
        ArrayList params = new ArrayList(malToPlaceOrderParam.getMalToPlaceOrderItemList().size());
        for (MalToPlaceOrderItem malToPlaceOrderItem : malToPlaceOrderParam.getMalToPlaceOrderItemList()) {
            MalGoods malGoods = malGoodsMap.get(malToPlaceOrderItem.getGoodsId());
            if (malGoods == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u201c{0}\u201d\u4e0d\u5b58\u5728\u3002", (String)"MalPlaceOrderServiceImpl_6", (String)"scm-mal-business", (Object[])new Object[]{malToPlaceOrderItem.getGoodsNumber()}));
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("goodsId", malToPlaceOrderItem.getGoodsId());
            param.put("categoryId", StringUtils.isEmpty((CharSequence)malGoods.getCategoryId()) ? 0L : Long.parseLong(malGoods.getCategoryId()));
            param.put("purchaseTypeId", defaultPurType);
            param.put("protocolNo", malGoods.getProtocolBillno());
            params.add(param);
        }
        return (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pmm", (String)"IPmmMatMappingService", (String)"queryProdMaterialMapping", (Object[])new Object[]{params});
    }

    private Long getBusinessType(MalToPlaceOrderParam malToPlaceOrderParam, DynamicObject placeOrderDyn) {
        if (malToPlaceOrderParam.getBusinessType() != null && malToPlaceOrderParam.getBusinessType() != 0L) {
            return malToPlaceOrderParam.getBusinessType();
        }
        DynamicObject businessTypeDyn = placeOrderDyn.getDynamicObject("businesstype");
        if (businessTypeDyn != null) {
            return businessTypeDyn.getLong("id");
        }
        DynamicObject billType = placeOrderDyn.getDynamicObject("billtype");
        if (billType != null) {
            return BizTypeHelper.getDefaultBizType((String)"mal_order", (Long)billType.getLong("id"));
        }
        return 0L;
    }

    public MalPlaceOrderValidateResult validateGoodsForPlaceOrder(Map<Long, BigDecimal> goodsIdToQtyMap, Map<Long, MalGoods> malGoodsMap, boolean validateMinOrderQty, long orgId) {
        MalPlaceOrderValidateOption malPlaceOrderValidateOption = new MalPlaceOrderValidateOption();
        malPlaceOrderValidateOption.setValidateMinOrderQty(false);
        malPlaceOrderValidateOption.setValidateStock(true);
        malPlaceOrderValidateOption.setMaxSupplierCount(10);
        return this.validateGoods(goodsIdToQtyMap, malGoodsMap, orgId, malPlaceOrderValidateOption);
    }

    public MalPlaceOrderValidateResult validateGoods(Map<Long, BigDecimal> goodsIdToQtyMap, Map<Long, MalGoods> malGoodsMap, Long orgId, MalPlaceOrderValidateOption malPlaceOrderValidateOption) {
        DynamicObject orgDyn = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        MalPlaceOrderValidateResult malPlaceOrderValidateResult = new MalPlaceOrderValidateResult();
        HashSet<String> supplierIdSet = new HashSet<String>(malGoodsMap.size());
        boolean selfInventoryUnlimited = MalOrderParamUtil.isSelfInventoryUnlimited();
        for (MalGoods malGoods : malGoodsMap.values()) {
            supplierIdSet.add(malGoods.getSupplierId());
            if (!malGoods.validateMallStatus()) {
                malPlaceOrderValidateResult.getInvalidMallStatusProdNumberList().add(malGoods.getNumber());
                malPlaceOrderValidateResult.getInvalidProdNumberList().add(malGoods.getNumber());
                malPlaceOrderValidateResult.getInvalidMallStatusProdIDList().add(malGoods.getId());
                malPlaceOrderValidateResult.getInvalidProdIDList().add(malGoods.getId());
                continue;
            }
            if (!malGoods.validateOrgSaleable(orgId)) {
                malPlaceOrderValidateResult.getInvalidOrgProdNumberList().add(malGoods.getNumber());
                malPlaceOrderValidateResult.getInvalidProdNumberList().add(malGoods.getNumber());
                malPlaceOrderValidateResult.getInvalidOrgProdIDList().add(malGoods.getId());
                malPlaceOrderValidateResult.getInvalidProdIDList().add(malGoods.getId());
                continue;
            }
            if (malGoods.getTaxPrice().compareTo(BigDecimal.ZERO) <= 0) {
                malPlaceOrderValidateResult.getInvalidPriceProdNumberList().add(malGoods.getNumber());
                malPlaceOrderValidateResult.getInvalidProdNumberList().add(malGoods.getNumber());
                malPlaceOrderValidateResult.getInvalidPriceProdIDList().add(malGoods.getId());
                malPlaceOrderValidateResult.getInvalidProdIDList().add(malGoods.getId());
            }
            if (malPlaceOrderValidateOption.isValidateStock() && !malGoods.validateStock(goodsIdToQtyMap.get(malGoods.getId()))) {
                malPlaceOrderValidateResult.getInvalidStockProdNumberList().add(malGoods.getNumber());
                malPlaceOrderValidateResult.getInvalidProdNumberList().add(malGoods.getNumber());
                malPlaceOrderValidateResult.getInvalidStockProdIDList().add(malGoods.getId());
                malPlaceOrderValidateResult.getInvalidProdIDList().add(malGoods.getId());
            }
            if (malPlaceOrderValidateOption.isValidateStock() && !selfInventoryUnlimited && EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malGoods.getPlatform()) && !((MalStockService)MalBusinessFactory.serviceOf(MalStockService.class)).validGoodsStock(malGoods, goodsIdToQtyMap.get(malGoods.getId()))) {
                malPlaceOrderValidateResult.getInvalidStockProdNumberList().add(malGoods.getNumber());
                malPlaceOrderValidateResult.getInvalidProdNumberList().add(malGoods.getNumber());
                malPlaceOrderValidateResult.getInvalidStockProdIDList().add(malGoods.getId());
                malPlaceOrderValidateResult.getInvalidProdIDList().add(malGoods.getId());
            }
            if (!malPlaceOrderValidateOption.isValidateMinOrderQty() || malGoods.getMinOrderQty() == null || malGoods.getMinOrderQty().compareTo(goodsIdToQtyMap.get(malGoods.getId())) <= 0) continue;
            malPlaceOrderValidateResult.getInvalidMinOrderQtyList().add(malGoods.getNumber());
            malPlaceOrderValidateResult.getInvalidProdNumberList().add(malGoods.getNumber());
            malPlaceOrderValidateResult.getInvalidMinOrderQtyIDList().add(malGoods.getId());
            malPlaceOrderValidateResult.getInvalidProdIDList().add(malGoods.getId());
        }
        if (malPlaceOrderValidateOption.getMaxSupplierCount() > 0 && supplierIdSet.size() > malPlaceOrderValidateOption.getMaxSupplierCount()) {
            malPlaceOrderValidateResult.getErrorInfos().add(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u5bf9{0}\u4e2a\u5546\u5bb6\u540c\u65f6\u4e0b\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1\uff0c\u5206\u6279\u4e0b\u5355", (String)"MalPlaceOrderServiceImpl_20", (String)"scm-mal-business", (Object[])new Object[]{malPlaceOrderValidateOption.getMaxSupplierCount()}));
        }
        if (!malPlaceOrderValidateResult.getInvalidMallStatusProdNumberList().isEmpty()) {
            malPlaceOrderValidateResult.getErrorInfos().add(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u201c{0}\u201d\u5df2\u4e0b\u67b6\u6216\u4f9b\u5e94\u5546\u5df2\u88ab\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalPlaceOrderServiceImpl_15", (String)"scm-mal-business", (Object[])new Object[]{String.join((CharSequence)",", malPlaceOrderValidateResult.getInvalidMallStatusProdNumberList())}));
        }
        if (!malPlaceOrderValidateResult.getInvalidPriceProdNumberList().isEmpty()) {
            malPlaceOrderValidateResult.getErrorInfos().add(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u201c{0}\u201d\u4ef7\u683c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalPlaceOrderServiceImpl_16", (String)"scm-mal-business", (Object[])new Object[]{String.join((CharSequence)",", malPlaceOrderValidateResult.getInvalidPriceProdNumberList())}));
        }
        if (!malPlaceOrderValidateResult.getInvalidStockProdNumberList().isEmpty()) {
            malPlaceOrderValidateResult.getErrorInfos().add(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u201c{0}\u201d\u7f3a\u8d27\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6\u6216\u7ba1\u7406\u5458\u3002", (String)"MalPlaceOrderServiceImpl_17", (String)"scm-mal-business", (Object[])new Object[]{String.join((CharSequence)",", malPlaceOrderValidateResult.getInvalidStockProdNumberList())}));
        }
        if (!malPlaceOrderValidateResult.getInvalidMinOrderQtyList().isEmpty()) {
            malPlaceOrderValidateResult.getErrorInfos().add(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u201c{0}\u201d\u7684\u91c7\u8d2d\u6570\u91cf\u672a\u8fbe\u8d77\u8ba2\u91cf\u3002", (String)"MalPlaceOrderServiceImpl_18", (String)"scm-mal-business", (Object[])new Object[]{String.join((CharSequence)",", malPlaceOrderValidateResult.getInvalidMinOrderQtyList())}));
        }
        if (!malPlaceOrderValidateResult.getInvalidOrgProdNumberList().isEmpty()) {
            malPlaceOrderValidateResult.getErrorInfos().add(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u62e9\u7684\u5546\u54c1\u5728\u7533\u8bf7\u7ec4\u7ec7\u3010{0}\u3011\u4e0b\u4e0d\u53ef\u552e\uff0c\u8bf7\u8054\u7cfb\u4f01\u4e1a\u91c7\u8d2d\u8fd0\u8425\u4e13\u5458\u5904\u7406\u3002\u5546\u54c1\u7f16\u7801\uff1a{1}", (String)"MalPlaceOrderServiceImpl_19", (String)"scm-mal-business", (Object[])new Object[]{orgDyn.getString("name"), String.join((CharSequence)",", malPlaceOrderValidateResult.getInvalidOrgProdNumberList())}));
        }
        return malPlaceOrderValidateResult;
    }
}

