/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.business.product.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.entity.ImageInfo;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.entity.StockInfo;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.mal.business.product.service.MalProductService;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import kd.scm.mal.common.util.MalProductUtil;
import kd.scm.mal.domain.model.goods.MalGoodsInfo;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.goods.MalPrice;
import kd.scm.mal.domain.model.goods.MalStock;

public class MalEcGroupProductServiceImpl
implements MalProductService {
    private static final Log log = LogFactory.getLog((String)MalEcGroupProductServiceImpl.class.getName());

    public Map<Long, MalGoodsInfo> getMalGoodsInfos(List<MalMatGoodsInitParam> malMatGoodsInitParams, boolean initStock, boolean isDetail) {
        this.handleParamSku(malMatGoodsInitParams, isDetail);
        Map<Long, MalGoodsInfo> malGoodsInfoMap = this.initEcGoodsInfo(malMatGoodsInitParams, isDetail);
        MalEcGroupProductServiceImpl.preHandleMalMatGoodsInitParamsByMalGoodsInfos(malMatGoodsInitParams, malGoodsInfoMap);
        Map malPriceMap = MalPrice.batchInstance(malMatGoodsInitParams);
        Map<Object, Object> malStockMap = new HashMap(malMatGoodsInitParams.size() << 2);
        if (initStock) {
            malStockMap = this.getMalStocks(malMatGoodsInitParams);
        }
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            MalStock malStock;
            MalGoodsInfo goodsInfo = malGoodsInfoMap.getOrDefault(malMatGoodsInitParam.getGoodsId(), new MalGoodsInfo());
            goodsInfo.setProductSource(malMatGoodsInitParam.getPlatform());
            MalPrice malPrice = (MalPrice)malPriceMap.get(malMatGoodsInitParam.getGoodsId());
            if (malPrice != null) {
                goodsInfo.setTaxPrice(malPrice.getTaxprice());
                goodsInfo.setTaxRate(malPrice.getTaxrate());
                goodsInfo.setTaxRateId(malPrice.getTaxrateId());
                goodsInfo.setPrice(malPrice.getPrice());
                goodsInfo.setShopPrice(malPrice.getShopprice());
                goodsInfo.setPriceModifyTime(malPrice.getModifytime());
                goodsInfo.setComparePrices(malPrice.getComparePrices());
            }
            if ((malStock = (MalStock)malStockMap.get(malMatGoodsInitParam.getGoodsId())) == null) continue;
            goodsInfo.setStockState(malStock.stockStateDesc());
        }
        return malGoodsInfoMap;
    }

    private void handleParamSku(List<MalMatGoodsInitParam> malMatGoodsInitParams, boolean isDetail) {
        HashMap<Long, MalMatGoodsInitParam> needHandleSkuGoodsId2ParamMap = new HashMap<Long, MalMatGoodsInitParam>(malMatGoodsInitParams.size());
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            if (!StringUtils.isBlank((CharSequence)malMatGoodsInitParam.getSku()) || !malMatGoodsInitParam.isQueryFromEcApi() && !isDetail) continue;
            needHandleSkuGoodsId2ParamMap.put(malMatGoodsInitParam.getGoodsId(), malMatGoodsInitParam);
        }
        if (!needHandleSkuGoodsId2ParamMap.isEmpty()) {
            try (DataSet mallGoodsDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_mallgoods", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", needHandleSkuGoodsId2ParamMap.keySet())}, null);){
                for (Row row : mallGoodsDs) {
                    MalMatGoodsInitParam malMatGoodsInitParam = (MalMatGoodsInitParam)needHandleSkuGoodsId2ParamMap.get(row.getLong("id"));
                    if (malMatGoodsInitParam == null) continue;
                    malMatGoodsInitParam.setSku(row.getString("number"));
                }
            }
        }
    }

    private static void preHandleMalMatGoodsInitParamsByMalGoodsInfos(List<MalMatGoodsInitParam> malMatGoodsInitParams, Map<Long, MalGoodsInfo> goodsInfoMap) {
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            MalGoodsInfo malGoodsInfo = goodsInfoMap.get(malMatGoodsInitParam.getGoodsId());
            if (malGoodsInfo == null) continue;
            malMatGoodsInitParam.setSku(malGoodsInfo.getProductNumber());
            String productUnitID = malGoodsInfo.getProductUnitID();
            if (!StringUtils.isNotEmpty((CharSequence)productUnitID)) continue;
            malMatGoodsInitParam.setGoodsUnitId(Long.valueOf(productUnitID));
        }
    }

    private static void initImageInfoFromApi(Map<Long, MalGoodsInfo> goodsInfoMap) {
        HashMap<String, List> imgParams = new HashMap<String, List>(goodsInfoMap.size() << 2);
        for (Map.Entry<Long, MalGoodsInfo> entry : goodsInfoMap.entrySet()) {
            List skuList = imgParams.getOrDefault(entry.getValue().getProductSource(), new ArrayList(goodsInfoMap.size()));
            skuList.add(entry.getValue().getProductNumber());
            imgParams.put(entry.getValue().getProductSource(), skuList);
        }
        Map ecSkuImgMap = EcGroupApiUtil.getEcSkuImgMap(imgParams);
        if (!ObjectUtils.isEmpty((Object)ecSkuImgMap)) {
            for (Map.Entry<Long, MalGoodsInfo> entry : goodsInfoMap.entrySet()) {
                Map skuImgMap = ecSkuImgMap.getOrDefault(entry.getValue().getProductSource(), new HashMap());
                List imageInfos = skuImgMap.getOrDefault(entry.getValue().getProductNumber(), new ArrayList());
                MalEcGroupProductServiceImpl.fillImageInGoodsInfo((GoodsInfo)entry.getValue(), imageInfos);
            }
        }
    }

    private static void fillImageInGoodsInfo(GoodsInfo goodsInfo, List<ImageInfo> imageInfos) {
        int index = 0;
        for (ImageInfo pic : imageInfos) {
            if (index >= 4) continue;
            if (pic.getOrderSort() == 1) {
                goodsInfo.setProductImgPath(pic.getImgPath());
                continue;
            }
            if (index == 0) {
                goodsInfo.setPicture1(pic.getImgPath());
                ++index;
                continue;
            }
            if (index == 1) {
                goodsInfo.setPicture2(pic.getImgPath());
                ++index;
                continue;
            }
            if (index == 2) {
                goodsInfo.setPicture3(pic.getImgPath());
                ++index;
                continue;
            }
            if (index != 3) continue;
            goodsInfo.setPicture4(pic.getImgPath());
            ++index;
        }
    }

    private static Map<Long, MalGoodsInfo> initDetailInfoFromDetailApi(List<MalMatGoodsInitParam> malMatGoodsInitParamForApi) {
        HashMap<Long, MalGoodsInfo> res = new HashMap<Long, MalGoodsInfo>(malMatGoodsInitParamForApi.size() << 2);
        Map<String, String> sku2StatusMap = MalEcGroupProductServiceImpl.getStatusFormApi(malMatGoodsInitParamForApi);
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParamForApi) {
            if (StringUtils.isEmpty((CharSequence)malMatGoodsInitParam.getSku())) {
                throw new KDBizException(ResManager.loadKDString((String)"sku\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MalEcGroupProductServiceImpl_0", (String)"scm-mal-business", (Object[])new Object[0]));
            }
            GoodsInfo goodsInfoFormApi = MalEcGroupProductServiceImpl.queryEcGoodsFromApi(malMatGoodsInitParam.getSku(), malMatGoodsInitParam.getPlatform());
            if (goodsInfoFormApi == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u63a5\u53e3\u83b7\u53d6\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"MalEcGroupProductServiceImpl_1", (String)"scm-mal-business", (Object[])new Object[0]));
            }
            MalGoodsInfo malGoodsInfo = (MalGoodsInfo)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)goodsInfoFormApi), MalGoodsInfo.class);
            malGoodsInfo.setProtocolId(malMatGoodsInitParam.getProtocolId());
            malGoodsInfo.setProductId(String.valueOf(malMatGoodsInitParam.getGoodsId()));
            malGoodsInfo.setSupplierName(malGoodsInfo.getSupplier());
            malGoodsInfo.setGoodsVisible(true);
            malGoodsInfo.setMallStatus(sku2StatusMap.get(malGoodsInfo.getProductNumber()));
            res.put(malMatGoodsInitParam.getGoodsId(), malGoodsInfo);
        }
        return res;
    }

    private static Map<String, String> getStatusFormApi(List<MalMatGoodsInitParam> malMatGoodsInitParamForApis) {
        HashMap<String, List> source_skuIdsMap = new HashMap<String, List>(1);
        String source = "";
        for (MalMatGoodsInitParam malMatGoodsInitParamForApi : malMatGoodsInitParamForApis) {
            List skuIds = source_skuIdsMap.getOrDefault(malMatGoodsInitParamForApi.getPlatform(), new ArrayList());
            skuIds.add(malMatGoodsInitParamForApi.getSku());
            source_skuIdsMap.put(malMatGoodsInitParamForApi.getPlatform(), skuIds);
            source = malMatGoodsInitParamForApi.getPlatform();
        }
        return EcGroupApiUtil.getEcSkuStateMap(source_skuIdsMap).getOrDefault(source, new HashMap());
    }

    private static GoodsInfo queryEcGoodsFromApi(String sku, String source) {
        HashMap params = new HashMap(1);
        HashMap<String, String> paramMap = new HashMap<String, String>(1);
        paramMap.put("skuId", sku);
        params.put(source, paramMap);
        Map ecProdDetail = EcGroupApiUtil.getEcProdDetail(params);
        GoodsInfo goodsInfo = new GoodsInfo();
        Map detailMap = (Map)ecProdDetail.get(source);
        if (null != detailMap) {
            goodsInfo = (GoodsInfo)detailMap.get(sku);
        }
        return goodsInfo;
    }

    private Map<Long, MalGoodsInfo> initEcGoodsInfo(List<MalMatGoodsInitParam> malMatGoodsInitParams, Boolean isDetail) {
        if (malMatGoodsInitParams.isEmpty()) {
            return new HashMap<Long, MalGoodsInfo>();
        }
        HashMap<Long, MalGoodsInfo> res = new HashMap<Long, MalGoodsInfo>(malMatGoodsInitParams.size() << 2);
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParamForApi = new ArrayList<MalMatGoodsInitParam>(malMatGoodsInitParams.size());
        HashSet<Long> ecGoodsIdSet = new HashSet<Long>(malMatGoodsInitParams.size());
        HashSet<Long> localEcGoodsIdSet = new HashSet<Long>(malMatGoodsInitParams.size());
        ArrayList<String> ecGoodsNumbers = new ArrayList<String>(malMatGoodsInitParams.size());
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            if (malMatGoodsInitParam.getGoodsId() != null && malMatGoodsInitParam.getGoodsId() != 0L) {
                ecGoodsIdSet.add(malMatGoodsInitParam.getGoodsId());
            }
            if (!StringUtils.isNotEmpty((CharSequence)malMatGoodsInitParam.getSku())) continue;
            ecGoodsNumbers.add(malMatGoodsInitParam.getSku());
        }
        if (ecGoodsIdSet.isEmpty()) {
            QFilter goodsFilter = new QFilter("number", "in", ecGoodsNumbers).and("source", "=", (Object)malMatGoodsInitParams.get(0).getPlatform());
            Map id2GoodsDynMap = BusinessDataServiceHelper.loadFromCache((String)"pbd_mallgoods", (QFilter[])new QFilter[]{goodsFilter});
            for (DynamicObject goodsDyn : id2GoodsDynMap.values()) {
                for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
                    if (!StringUtils.equals((CharSequence)malMatGoodsInitParam.getSku(), (CharSequence)goodsDyn.getString("number"))) continue;
                    malMatGoodsInitParam.setGoodsId(goodsDyn.getLong("id"));
                }
            }
        }
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malMatGoodsInitParam.getPlatform())) continue;
            if (malMatGoodsInitParam.isQueryFromEcApi() || isDetail.booleanValue()) {
                malMatGoodsInitParamForApi.add(malMatGoodsInitParam);
                malMatGoodsInitParam.setQueryFromEcApi(true);
                continue;
            }
            localEcGoodsIdSet.add(malMatGoodsInitParam.getGoodsId());
        }
        if (!localEcGoodsIdSet.isEmpty()) {
            res.putAll(this.getEcGoodsInfoLocal(localEcGoodsIdSet));
        }
        if (!malMatGoodsInitParamForApi.isEmpty()) {
            res.putAll(MalEcGroupProductServiceImpl.initDetailInfoFromDetailApi(malMatGoodsInitParamForApi));
            if (isDetail.booleanValue()) {
                try {
                    MalEcGroupProductServiceImpl.initImageInfoFromApi(res);
                }
                catch (Exception e) {
                    log.error(ExceptionUtil.getStackTrace((Throwable)e));
                }
            }
        }
        Map<Long, DynamicObject> goodsIdMallStatusMap = MalEcGroupProductServiceImpl.queryEcMallStatus(res.keySet());
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            DynamicObject ecStatusDyn;
            MalGoodsInfo malGoodsInfo = (MalGoodsInfo)res.get(malMatGoodsInitParam.getGoodsId());
            if (malGoodsInfo == null) continue;
            malGoodsInfo.setShippingAddress(malMatGoodsInitParam.getAddressId());
            if ("0".equals(malGoodsInfo.getProductId()) || StringUtils.isEmpty((CharSequence)malGoodsInfo.getProductId()) || (ecStatusDyn = goodsIdMallStatusMap.get(Long.parseLong(malGoodsInfo.getProductId()))) == null) continue;
            malGoodsInfo.setMallStatus(ecStatusDyn.getString("mallstatus"));
        }
        return res;
    }

    private Map<Long, MalGoodsInfo> getEcGoodsInfoLocal(Set<Long> localEcGoodsIdSet) {
        HashMap<Long, MalGoodsInfo> res = new HashMap<Long, MalGoodsInfo>(localEcGoodsIdSet.size() << 2);
        Map ecGoodsToProdManageMap = MalProductUtil.covertEcGoodsToProdManage(localEcGoodsIdSet);
        DynamicObjectCollection ecGoodsDyns = MalEcGroupProductServiceImpl.queryMallGoods(new HashSet<Long>(localEcGoodsIdSet));
        for (DynamicObject ecGoodsDyn : ecGoodsDyns) {
            DynamicObject goodsDyn = (DynamicObject)ecGoodsToProdManageMap.get(ecGoodsDyn.getLong("id"));
            if (goodsDyn == null) continue;
            res.put(ecGoodsDyn.getLong("id"), MalEcGroupProductServiceImpl.convertProdManageToGoodsInfo(goodsDyn));
        }
        return res;
    }

    private static MalGoodsInfo convertProdManageToGoodsInfo(DynamicObject goodsDyn) {
        MalGoodsInfo goodsInfo = new MalGoodsInfo();
        goodsInfo.setProductId(goodsDyn.getString("id"));
        goodsInfo.setProductNumber(goodsDyn.getString("number"));
        goodsInfo.setProductImgPath(MalProductUtil.getPictureUrl((String)goodsDyn.getString("thumbnail")));
        goodsInfo.setProductName(goodsDyn.getString("name"));
        goodsInfo.setProductDesc(goodsDyn.getString("description"));
        goodsInfo.setProductModel(goodsDyn.getString("model"));
        goodsInfo.setRemark(goodsDyn.getString("remark"));
        goodsInfo.setProductSource(goodsDyn.getString("source"));
        goodsInfo.setSupplier(goodsDyn.getString("supplier.name"));
        goodsInfo.setSupplierName(goodsDyn.getString("supplier.name"));
        goodsInfo.setSupplierId(Long.valueOf(goodsDyn.getLong("supplier.id")));
        goodsInfo.setProductUnitID(goodsDyn.getString("unit"));
        goodsInfo.setProductCurrID(goodsDyn.getString("curr"));
        goodsInfo.setRemark(goodsDyn.getString("number"));
        goodsInfo.setSupplierMallStatus(goodsDyn.getString("supplier.mallstatus"));
        goodsInfo.setTaxRate(goodsDyn.getBigDecimal("taxrate"));
        goodsInfo.setBrandId(goodsDyn.getString("brand"));
        goodsInfo.setPicture1(MalProductUtil.getPictureUrl((String)goodsDyn.getString("picture1")));
        goodsInfo.setPicture2(MalProductUtil.getPictureUrl((String)goodsDyn.getString("picture2")));
        goodsInfo.setPicture3(MalProductUtil.getPictureUrl((String)goodsDyn.getString("picture3")));
        goodsInfo.setPicture4(MalProductUtil.getPictureUrl((String)goodsDyn.getString("picture4")));
        goodsInfo.setCategoryNumber(goodsDyn.getString("category.number"));
        goodsInfo.setCategoryName(goodsDyn.getString("category.name"));
        goodsInfo.setCategoryId(goodsDyn.getString("category.id"));
        goodsInfo.setCentralpurtype(goodsDyn.getString("centralpurtype"));
        String content_tag = goodsDyn.getString("content_tag");
        if (!StringUtils.isEmpty((CharSequence)content_tag)) {
            goodsInfo.setProductDetail(content_tag);
        } else {
            goodsInfo.setProductDetail(goodsDyn.getString("content"));
        }
        goodsInfo.setGuarantee(goodsDyn.getString("guarantee"));
        goodsInfo.setPackinglist(goodsDyn.getString("packinglist"));
        goodsInfo.setBarCode(goodsDyn.getString("barcode"));
        goodsInfo.setGoodsVisible(true);
        return goodsInfo;
    }

    private static Map<Long, DynamicObject> queryEcMallStatus(Set<Long> goodsIdSet) {
        HashSet<Long> tempGoodsIdSet = new HashSet<Long>(goodsIdSet);
        tempGoodsIdSet.removeIf(goodsId -> 0L == goodsId);
        HashMap<Long, DynamicObject> res = new HashMap<Long, DynamicObject>(tempGoodsIdSet.size());
        if (tempGoodsIdSet.isEmpty()) {
            return res;
        }
        DynamicObjectCollection statusDynCol = QueryServiceHelper.query((String)"pbd_mallgoods_status", (String)"mallgoods,mallstatus,saleable", (QFilter[])new QFilter[]{new QFilter("mallgoods", "in", tempGoodsIdSet)});
        for (DynamicObject ecStatusDyn : statusDynCol) {
            res.put(ecStatusDyn.getLong("mallgoods"), ecStatusDyn);
        }
        return res;
    }

    private static DynamicObjectCollection queryMallGoods(Set<Long> nonSyncGoodsIdSet) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("id", "in", nonSyncGoodsIdSet));
        String selectFields = "id,number,name,mainpic,source,model,group,group.number,group.name,unitid,brandid,createtime,barcode";
        return QueryServiceHelper.query((String)"pbd_mallgoods", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
    }

    public Map<Long, MalPrice> getMalPrices(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        return MalEcGroupProductServiceImpl.ecPrice(malMatGoodsInitParams);
    }

    private static Map<Long, MalPrice> ecPrice(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        HashMap<Long, MalPrice> res = new HashMap<Long, MalPrice>();
        if (malMatGoodsInitParams.isEmpty()) {
            return res;
        }
        ArrayList<Long> goodsIds = new ArrayList<Long>();
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParamsQueryFromEcApis = new ArrayList<MalMatGoodsInitParam>(malMatGoodsInitParams.size());
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParams) {
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malMatGoodsInitParam.getPlatform())) continue;
            if (malMatGoodsInitParam.isQueryPriceFromApi() || malMatGoodsInitParam.isQueryFromEcApi()) {
                malMatGoodsInitParamsQueryFromEcApis.add(malMatGoodsInitParam);
                continue;
            }
            goodsIds.add(malMatGoodsInitParam.getGoodsId());
        }
        if (!goodsIds.isEmpty()) {
            res.putAll(MalEcGroupProductServiceImpl.getEcPriceLocal(goodsIds));
        }
        if (!malMatGoodsInitParamsQueryFromEcApis.isEmpty()) {
            res.putAll(MalEcGroupProductServiceImpl.getEcPriceFromApi(malMatGoodsInitParamsQueryFromEcApis));
        }
        return res;
    }

    private static Map<Long, MalPrice> getEcPriceFromApi(List<MalMatGoodsInitParam> malMatGoodsInitParamsQueryFromEcApis) {
        Map taxrate2TaxrateIdMap = MalProductUtil.getTaxrate2TaxrateIdMap();
        HashMap<Long, MalPrice> res = new HashMap<Long, MalPrice>(malMatGoodsInitParamsQueryFromEcApis.size() << 2);
        HashMap<String, Map> params = new HashMap<String, Map>(malMatGoodsInitParamsQueryFromEcApis.size() << 2);
        HashMap<String, String> commonParam = new HashMap<String, String>(8);
        String cityId = MalPlaceOrderUtils.getCityId((String)malMatGoodsInitParamsQueryFromEcApis.get(0).getAddressId());
        commonParam.put("cityId", cityId);
        params.put("common_params", commonParam);
        HashSet<String> platformSet = new HashSet<String>(4);
        HashMap<String, Long> sku2GoodsIdMap = new HashMap<String, Long>(malMatGoodsInitParamsQueryFromEcApis.size() << 2);
        for (MalMatGoodsInitParam malMatGoodsInitParam : malMatGoodsInitParamsQueryFromEcApis) {
            Map platformParams = params.getOrDefault(malMatGoodsInitParam.getPlatform(), new HashMap(8));
            List skuIds = platformParams.getOrDefault("skuIds", new ArrayList(malMatGoodsInitParamsQueryFromEcApis.size()));
            skuIds.add(malMatGoodsInitParam.getSku());
            platformParams.put("skuIds", skuIds);
            params.put(malMatGoodsInitParam.getPlatform(), platformParams);
            platformSet.add(malMatGoodsInitParam.getPlatform());
            sku2GoodsIdMap.put(malMatGoodsInitParam.getSku(), malMatGoodsInitParam.getGoodsId());
        }
        log.info("\u67e5\u8be2\u7535\u5546\u4ef7\u683c\u7684\u53c2\u6570\u4e3a\uff1a" + params);
        Map platform2PriceInfoMap = EcGroupApiUtil.getEcPrice(params);
        log.info("\u67e5\u8be2\u7535\u5546\u4ef7\u683c\u7684\u7ed3\u679c\u4e3a\uff1a" + platform2PriceInfoMap);
        for (String platform : platformSet) {
            Map priceInfoMap = (Map)platform2PriceInfoMap.get(platform);
            if (priceInfoMap == null) {
                String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u7535\u5546\u5546\u54c1\u4ef7\u683c\u4e3a\u7a7a\u3002", (String)"MalEcGroupProductServiceImpl_2", (String)"scm-mal-business", (Object[])new Object[0]);
                throw new KDBizException(new ErrorCode("getMalGoodsPrice error", EcPlatformEnum.fromVal((String)platform).getName() + msg), new Object[0]);
            }
            for (Map.Entry priceInfoEntry : priceInfoMap.entrySet()) {
                PriceInfo priceInfo = (PriceInfo)priceInfoEntry.getValue();
                Long goodsId = (Long)sku2GoodsIdMap.get(priceInfo.getSkuId());
                MalPrice malPrice = new MalPrice(String.valueOf(goodsId), priceInfo.getTaxPrice(), priceInfo.getPrice(), priceInfo.getEcPrice(), priceInfo.getTaxRate(), taxrate2TaxrateIdMap.getOrDefault(priceInfo.getTaxRate().stripTrailingZeros(), 0L), TimeServiceHelper.now());
                malPrice.setSku(priceInfo.getSkuId());
                res.put(goodsId, malPrice);
            }
        }
        return res;
    }

    private static Map<Long, MalPrice> getEcPriceLocal(List<Long> goodsIds) {
        HashMap<Long, MalPrice> res = new HashMap<Long, MalPrice>(goodsIds.size() << 2);
        DynamicObjectCollection ecPriceDynCol = QueryServiceHelper.query((String)"pbd_mallgoods_price", (String)"mallgoods,mallgoods.number,price,nakedprice,taxrate,modifytime,mallprice", (QFilter[])new QFilter[]{new QFilter("mallgoods", "in", goodsIds)});
        Map taxrate2TaxrateIdMap = MalProductUtil.getTaxrate2TaxrateIdMap();
        for (DynamicObject ecPriceDyn : ecPriceDynCol) {
            MalPrice malPrice = new MalPrice(ecPriceDyn.getString("mallgoods"), ecPriceDyn.getBigDecimal("price"), ecPriceDyn.getBigDecimal("nakedprice"), ecPriceDyn.getBigDecimal("mallprice"), ecPriceDyn.getBigDecimal("taxrate"), taxrate2TaxrateIdMap.getOrDefault(ecPriceDyn.getBigDecimal("taxrate"), 0L), ecPriceDyn.getDate("modifytime"));
            malPrice.setSku(ecPriceDyn.getString("mallgoods.number"));
            res.put(ecPriceDyn.getLong("mallgoods"), malPrice);
        }
        return res;
    }

    public Map<Long, MalStock> getMalStocks(List<MalMatGoodsInitParam> malMatGoodsInitParams) {
        long start = System.currentTimeMillis();
        HashMap<Long, MalStock> res = new HashMap<Long, MalStock>(malMatGoodsInitParams.size() << 2);
        HashMap<String, Map> stockParam = new HashMap<String, Map>(16);
        String[] addressId = new String[1];
        HashMap<String, Long> skuGoodsIdMap = new HashMap<String, Long>(malMatGoodsInitParams.size());
        for (MalMatGoodsInitParam goodsIdInitParam : malMatGoodsInitParams) {
            if (!StringUtils.isNotEmpty((CharSequence)goodsIdInitParam.getPlatform())) continue;
            Map param = stockParam.computeIfAbsent(goodsIdInitParam.getPlatform(), s -> new HashMap());
            addressId[0] = goodsIdInitParam.getAddressId();
            param.putIfAbsent(goodsIdInitParam.getSku(), goodsIdInitParam.getQtyForQueryStock());
            skuGoodsIdMap.put(goodsIdInitParam.getSku(), goodsIdInitParam.getGoodsId());
        }
        Map stockResMap = new HashMap(malMatGoodsInitParams.size() << 2);
        try {
            stockResMap = EcGroupApiUtil.getEcStock(stockParam, (String)addressId[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        for (Map.Entry stockResEntry : stockResMap.entrySet()) {
            for (Map.Entry stockEntry : ((Map)stockResEntry.getValue()).entrySet()) {
                res.put((Long)skuGoodsIdMap.get(stockEntry.getKey()), new MalStock((StockInfo)stockEntry.getValue()));
            }
        }
        log.info("\u83b7\u53d6\u7535\u5546\u5e93\u5b58\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return res;
    }

    public String getEcSyncServiceFlowNumber() {
        return "";
    }
}

