/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.formplugin.edit;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ProductSourceEnum;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.util.CommonUtil;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderItem;
import kd.scm.mal.business.placeorder.entity.MalToPlaceOrderParam;
import kd.scm.mal.domain.model.goods.MalGoods;
import kd.scm.mal.domain.model.goods.MalMatGoodsInitParam;
import kd.scm.mal.domain.model.productdetail.MalProductDetail;

public class MalPurSchemeEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String OP_ADDCART = "addcart";
    private static final String GOODSENTRY = "goodsentry";
    private static final String OP_TO_ORDER = "toorder";
    private static final String OP_ADD_GOODS = "addgoods";
    private static final String CCB_SELECTGOODS = "ccb_selectgoods";

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        BaseShowParameter formShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (BillOperationStatus.ADDNEW == formShowParameter.getBillStatus()) {
            Object goodsInfos = formShowParameter.getCustomParam("goodsInfos");
            if (ObjectUtils.isEmpty((Object)goodsInfos)) {
                return;
            }
            this.getModel().setValue("name", formShowParameter.getCustomParam("schemeName"));
            this.addGoods((List)goodsInfos);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit goods = (BasedataEdit)this.getControl("goods");
        goods.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid goodsEntry = (EntryGrid)this.getControl(GOODSENTRY);
        goodsEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.dynamicFill();
        this.getModel().setDataChanged(false);
    }

    private void dynamicFill() {
        int entryRowCount = this.getModel().getEntryEntity(GOODSENTRY).size();
        ArrayList<MalMatGoodsInitParam> malMatGoodsInitParams = new ArrayList<MalMatGoodsInitParam>(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject goods = (DynamicObject)this.getModel().getValue("goods", i);
            if (goods == null) continue;
            this.getModel().setValue("unit", goods.get("unit"), i);
            String source = goods.getString("source");
            Long goodsId = goods.getLong("id");
            String goodsNumber = goods.getString("number");
            malMatGoodsInitParams.add(MalMatGoodsInitParam.buildGeneralParamWithSku((Long)goodsId, (String)goodsNumber, (String)source, (BigDecimal)((BigDecimal)this.getModel().getValue("qty", i)), (String)"", (Long)RequestContext.get().getOrgId()));
        }
        if (!malMatGoodsInitParams.isEmpty()) {
            Map malGoodsMap = MalGoods.batchInstance(malMatGoodsInitParams, (boolean)false, (boolean)false);
            this.getModel().beginInit();
            BigDecimal sumTaxAmount = BigDecimal.ZERO;
            for (int i = 0; i < entryRowCount; ++i) {
                MalGoods malGoods;
                DynamicObject goods = (DynamicObject)this.getModel().getValue("goods", i);
                if (goods == null || (malGoods = (MalGoods)malGoodsMap.get(goods.getLong("id"))) == null) continue;
                this.getModel().setValue("taxprice", (Object)malGoods.getTaxPrice(), i);
                BigDecimal taxAmount = malGoods.getTaxPrice().multiply((BigDecimal)this.getModel().getValue("qty", i));
                sumTaxAmount = sumTaxAmount.add(taxAmount);
                this.getModel().setValue("taxamount", (Object)taxAmount, i);
            }
            this.getModel().endInit();
            this.getModel().setValue("sumtaxamount", (Object)sumTaxAmount);
            this.getView().updateView(GOODSENTRY);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        IDataModel dataModel = this.getModel();
        ArrayList<Long> goodsIdList = new ArrayList<Long>();
        DynamicObjectCollection entryEntityCol = dataModel.getEntryEntity(GOODSENTRY);
        for (DynamicObject dyo : entryEntityCol) {
            if (null == dyo.get("goods")) continue;
            goodsIdList.add(dyo.getLong("goods.id"));
        }
        ListShowParameter formShowParameter = (ListShowParameter)arg0.getFormShowParameter();
        List filters = formShowParameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("id", "not in", goodsIdList));
        filters.add(new QFilter("source", "=", (Object)ProductSourceEnum.PRODUCTSOURCE_SELF.getVal()));
        filters.add(new QFilter("mallstatus", "=", (Object)"B"));
        filters.add(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        filters.add(new QFilter("enable", "=", (Object)"1"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_ADDCART.equals(operateKey) || OP_TO_ORDER.equals(operateKey)) {
            OperateOption option = operate.getOption();
            EntryGrid entryGrid = (EntryGrid)this.getControl(GOODSENTRY);
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            if (selectedRows.length > 0) {
                ArrayList<String> selectedGoodsIds = new ArrayList<String>(selectedRows.length);
                for (int index : selectedRows) {
                    DynamicObject goodsEntry = this.getModel().getEntryRowEntity(GOODSENTRY, index);
                    selectedGoodsIds.add(goodsEntry.getString("goods.id"));
                }
                option.setVariableValue("selectedGoodsIds", StringUtils.join((Object[])selectedGoodsIds.toArray(), (String)","));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        IFormView parentView;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && OP_TO_ORDER.equals(afterDoOperationEventArgs.getOperateKey())) {
            MalToPlaceOrderParam malToPlaceOrderParam = new MalToPlaceOrderParam();
            EntryGrid entryGrid = (EntryGrid)this.getControl(GOODSENTRY);
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            ArrayList<MalToPlaceOrderItem> malToPlaceOrderItems = new ArrayList<MalToPlaceOrderItem>(selectedRows.length);
            if (selectedRows.length <= 0) {
                selectedRows = IntStream.rangeClosed(0, this.getModel().getEntryRowCount(GOODSENTRY) - 1).toArray();
            }
            if (selectedRows.length <= 0) {
                return;
            }
            for (int index : selectedRows) {
                DynamicObject entry = this.getModel().getEntryRowEntity(GOODSENTRY, index);
                malToPlaceOrderParam.setDptOrgId(Long.valueOf(RequestContext.get().getOrgId()));
                String goodsId = entry.getString("goods.id");
                String goodsNumber = entry.getString("goods.number");
                String source = entry.getString("goods.source");
                BigDecimal qty = entry.getBigDecimal("qty");
                MalToPlaceOrderItem malToPlaceOrderItem = new MalToPlaceOrderItem();
                malToPlaceOrderItem.setGoodsId(Long.valueOf(goodsId));
                malToPlaceOrderItem.setGoodsNumber(goodsNumber);
                malToPlaceOrderItem.setPlatform(source);
                malToPlaceOrderItem.setQty(qty);
                malToPlaceOrderItems.add(malToPlaceOrderItem);
            }
            malToPlaceOrderParam.setMalToPlaceOrderItemList(malToPlaceOrderItems);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("mal_placeorder");
            parameter.setCustomParam("MAL_TO_PLACEORDER_PARAM", (Object)JSON.toJSONString((Object)malToPlaceOrderParam));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setShowTitle(false);
            this.getView().showForm(parameter);
        }
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && OP_ADD_GOODS.equals(afterDoOperationEventArgs.getOperateKey())) {
            FormShowParameter parameter = new FormShowParameter();
            String esFilter = this.getEsFilter();
            parameter.setFormId("mal_selectgoods_scheme");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CCB_SELECTGOODS));
            parameter.setCustomParam("esfilter", (Object)esFilter);
            this.getView().showForm(parameter);
        }
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && OP_ADDCART.equals(afterDoOperationEventArgs.getOperateKey()) && (parentView = this.getView().getParentView()) != null && parentView.getParentView() != null && "mal_newshopcenter".equals(parentView.getParentView().getEntityId())) {
            parentView.getParentView().updateView();
            this.getView().sendFormAction(parentView.getParentView());
        }
    }

    private String getEsFilter() {
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>(2);
        EsFilterField esFilterField = new EsFilterField("source", "!=", new Object[]{"0"});
        esFilterFields.add(esFilterField);
        return JSON.toJSONString(esFilterFields);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (CCB_SELECTGOODS.equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (ObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            List selectedGoods = (List)returnData;
            this.addGoods(selectedGoods);
            this.getView().updateView();
        }
    }

    private void addGoods(List<Map<String, Object>> goodsInfos) {
        HashSet<Long> goodsIds = new HashSet<Long>(goodsInfos.size());
        for (Map<String, Object> goodsInfo : goodsInfos) {
            goodsIds.add((Long)goodsInfo.get("goodsId"));
        }
        MalGoods.syncEcGoodsToGoodsManage(new HashSet(goodsIds));
        DynamicObjectCollection goodsEntryCol = this.getModel().getEntryEntity(GOODSENTRY);
        HashMap<Long, Integer> existGoodsId2IndexMap = new HashMap<Long, Integer>(goodsEntryCol.size() << 2);
        int i = 0;
        for (DynamicObject entry : goodsEntryCol) {
            existGoodsId2IndexMap.put(entry.getLong("goods.id"), i);
            ++i;
        }
        Map goodsDynMap = BusinessDataServiceHelper.loadFromCache((Object[])goodsIds.toArray(), (String)"pmm_prodmanage");
        this.getModel().beginInit();
        for (Map<String, Object> goodsInfo : goodsInfos) {
            Long goodsId = (Long)goodsInfo.get("goodsId");
            Integer existIndex = (Integer)existGoodsId2IndexMap.get(goodsId);
            if (existIndex == null) {
                int index = this.getModel().createNewEntryRow(GOODSENTRY);
                this.getModel().setValue("goods_id", (Object)goodsId, index);
                this.getModel().setValue("goods", goodsDynMap.get(goodsId), index);
                this.getModel().setValue("qty", goodsInfo.get("qty"), index);
                continue;
            }
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", existIndex.intValue());
            BigDecimal newQty = qty.add((BigDecimal)goodsInfo.get("qty"));
            this.getModel().setValue("qty", (Object)newQty, existIndex.intValue());
        }
        this.getModel().endInit();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        if (StringUtils.equals((CharSequence)"goods", (CharSequence)fieldKey)) {
            for (ChangeData changedDatum : changedData) {
                int index = changedDatum.getRowIndex();
                DynamicObject goods = (DynamicObject)changedDatum.getNewValue();
                model.setValue("unit", goods.get("unit"), index);
            }
            this.getView().updateView();
        }
        if (StringUtils.equals((CharSequence)"qty", (CharSequence)fieldKey)) {
            BigDecimal newVal = CommonUtil.getBigDecimalPro((Object)changedData[0].getNewValue());
            this.getModel().setValue("qty", (Object)newVal.toBigInteger());
            this.getView().updateView();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.getView().updateView();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("goods".equals(evt.getFieldName())) {
            DynamicObject goods = (DynamicObject)this.getModel().getValue("goods", evt.getRowIndex());
            String goodsId = goods.getString("id");
            String goodsNumber = goods.getString("number");
            String source = goods.getString("source");
            String goodsName = goods.getString("name");
            FormShowParameter detailPageFormShowParam = MalProductDetail.getDetailPageFormShowParam((String)goodsId, (String)goodsNumber, (String)source, (String)goodsName, (String)this.getView().getEntityId(), (ShowType)ShowType.Modal, null, null);
            this.getView().showForm(detailPageFormShowParam);
        }
    }
}

