/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.jd;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.mal.common.ecmessage.enums.JdMsgTypeEnum;
import kd.scm.mal.common.ecmessage.msg.AbstractMessageHandler;
import kd.scm.mal.common.util.MalPlaceOrderUtils;
import net.sf.json.JSONObject;

public class JdCancelOrderMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(JdCancelOrderMessageHandler.class);

    public boolean doExcute(DynamicObject[] messageDyos) {
        HashSet<String> cancelOrderList = new HashSet<String>(messageDyos.length);
        HashMap<String, DynamicObject> msgMap = new HashMap<String, DynamicObject>(messageDyos.length);
        String source = EcPlatformEnum.ECPLATFORM_JD.getVal();
        for (DynamicObject dyo : messageDyos) {
            source = dyo.getString("systype");
            String msgType = dyo.getString("msgtype");
            if (!msgType.equals(JdMsgTypeEnum.ORDER_CANCELED.getVal())) continue;
            String result = dyo.getString("result");
            JSONObject json = JSONObject.fromObject((Object)result);
            String orderId = json.getString("orderId");
            if (json.containsKey((Object)"state") && !"1".equals(json.getString("state"))) continue;
            cancelOrderList.add(orderId);
            msgMap.put(orderId, dyo);
        }
        logger.info("@@@JdCancelOrderMessageHandler\u5904\u7406\u8ba2\u5355\uff1a" + cancelOrderList);
        if (cancelOrderList.isEmpty()) {
            this.addRetryTimes(messageDyos, ((Object)((Object)this)).getClass().getName());
            return false;
        }
        Set<String> sucessOrders = this.startCancel(cancelOrderList, source);
        if (sucessOrders.size() <= 0) {
            this.addRetryTimes(messageDyos, ((Object)((Object)this)).getClass().getName());
            return false;
        }
        DynamicObject[] failedMsgDyos = this.getFailedMessageDyo(sucessOrders, msgMap);
        if (failedMsgDyos.length > 0) {
            this.addRetryTimes(failedMsgDyos, ((Object)((Object)this)).getClass().getName());
            DynamicObject[] sucessMsgDyos = this.getSuccessMessageDyo(sucessOrders, msgMap);
            this.changeConsumeStatus(sucessMsgDyos);
            return false;
        }
        return true;
    }

    public Set<String> startCancel(Set<String> cancelOrderList, String source) {
        return MalPlaceOrderUtils.malOrderInvalidProcessor(cancelOrderList, (String)source);
    }
}

