/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.common.ecmessage.msg.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.parser.SnApiParser;
import kd.scm.mal.common.util.MalProductUtil;

public class EcMessageUtil {
    private static final Log log = LogFactory.getLog((String)EcMessageUtil.class.getName());

    public static void updateSnOrderSubmitStatus(List<String> orderList) {
        HashSet<String> orderIdSet = new HashSet<String>(orderList);
        DynamicObject[] dyos = SnApiParser.getSnOrder(orderIdSet);
        SnApiParser.setSubmitState((DynamicObject[])dyos);
        SaveServiceHelper.save((DynamicObject[])dyos);
    }

    public static Object startServiceFlow(String number, Object ... args) {
        if (args != null) {
            ArrayList<Object> inputs = new ArrayList<Object>(1024);
            for (Object arg : args) {
                inputs.add(arg);
            }
            return ApiAccessor.invokeServiceFlow((String)number, inputs);
        }
        return ApiAccessor.invokeServiceFlow((String)number);
    }

    public static DynamicObject[] getMsgDyoCol(List<Long> msgIds) {
        String selectFields = "systype,msgid,msgtype,status,result,retrytimes";
        QFilter filter = new QFilter("id", "in", msgIds);
        return BusinessDataServiceHelper.load((String)"pbd_apimessage", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    public static List<Object> getEcProdIdListBySku(String ecType, List<String> skuList) {
        if (null == skuList || skuList.isEmpty()) {
            return new ArrayList<Object>();
        }
        QFilter filter = new QFilter("source", "=", (Object)ecType).and(new QFilter("number", "in", skuList));
        return QueryServiceHelper.queryPrimaryKeys((String)"pbd_mallgoods", (QFilter[])new QFilter[]{filter}, (String)"", (int)1000);
    }

    private static DynamicObject[] getProdStatusDyo(String ecType, Set<String> skus) {
        QFilter skuFilter = new QFilter("mallgoods.number", "in", skus);
        QFilter sourceFilter = new QFilter("mallgoods.source", "=", (Object)ecType);
        return BusinessDataServiceHelper.load((String)"pbd_mallgoods_status", (String)"id,mallgoods.id,mallgoods.number,ecstatus,mallstatus,saleable", (QFilter[])new QFilter[]{skuFilter, sourceFilter});
    }

    public static void changeGoodsState(String ecType, Map<String, String> modifySkuMap) {
        DynamicObject[] dyos;
        for (DynamicObject dyo : dyos = EcMessageUtil.getProdStatusDyo(ecType, modifySkuMap.keySet())) {
            String number = dyo.getString("mallgoods.number");
            if (modifySkuMap.get(number).equals("1")) {
                dyo.set("ecstatus", (Object)"1");
                dyo.set("saleable", (Object)"1");
                continue;
            }
            dyo.set("ecstatus", (Object)"0");
            dyo.set("saleable", (Object)"0");
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        OperationServiceHelper.executeOperate((String)"save", (String)"pbd_mallgoods_status", (DynamicObject[])dyos, (OperateOption)option);
    }

    public static List<String> getSkuListByPoolPageNum(String pageNum, int pageNo) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("pageNum", pageNum);
        params.put("pageNo", pageNo);
        try {
            return (List)ApiAccessor.invoke((String)"SRM_JD_GOODS_getSkuByPage", params);
        }
        catch (Exception e) {
            throw new KDBizException("EcMessageUtil.getSkuListByPoolPageNum Failed!");
        }
    }

    public static DynamicObject[] getPurOrderByEcOrder(String ecType, Collection<String> orderNumbers) {
        QFilter noFilter = new QFilter("jdorderid", "in", orderNumbers);
        QFilter typeFilter = new QFilter("platform", "=", (Object)ecType);
        DynamicObjectCollection malOrderCol = QueryServiceHelper.query((String)"mal_order", (String)"id", (QFilter[])new QFilter[]{noFilter, typeFilter});
        if (null == malOrderCol || malOrderCol.size() <= 0) {
            return null;
        }
        ArrayList malOrderIds = new ArrayList(malOrderCol.size());
        malOrderCol.forEach(dyo -> malOrderIds.add(dyo.getString("id")));
        String selectProperties = "id,billno,creator,org,businesstype,materialentry.srcbillid,materialentry.srcentryid,materialentry.entryrcvorg,materialentry.qty,materialentry.jdorder,materialentry.poentryid,materialentry.pobillid,materialentry.unit,materialentry.basicunit,materialentry.purtype,materialentry.entryrcvorg,materialentry.entryrcvorg.id,materialentry.entryrcvorg.number";
        return BusinessDataServiceHelper.load((String)"pur_order", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("materialentry.srcbillid", "in", malOrderIds)}, (String)"billdate desc");
    }

    public static Set<String> getPurEntryIdsByEcOrderNo(Set<String> orderItemNoSet, String ecOrderEntityKey, String selectors, String filterKey) {
        QFilter idFilter = new QFilter(filterKey, "in", orderItemNoSet);
        DynamicObjectCollection col = QueryServiceHelper.query((String)ecOrderEntityKey, (String)selectors, (QFilter[])new QFilter[]{idFilter});
        ArrayList ecOrderIds = new ArrayList(col.size());
        col.forEach(dyo -> ecOrderIds.add(dyo.getLong("id")));
        QFilter entryIdFilter = new QFilter("entryentity.order", "in", ecOrderIds);
        DynamicObjectCollection malCol = QueryServiceHelper.query((String)"mal_order", (String)"entryentity.id", (QFilter[])new QFilter[]{entryIdFilter});
        List srcEntryIds = MalProductUtil.getListByProperty((DynamicObjectCollection)malCol, (String)"entryentity.id");
        QFilter srcEntryIdFilter = new QFilter("materialentry.srcentryid", "in", (Object)srcEntryIds);
        DynamicObjectCollection purCol = QueryServiceHelper.query((String)"pur_order", (String)"materialentry.id", (QFilter[])new QFilter[]{srcEntryIdFilter});
        HashSet<String> result = new HashSet<String>(purCol.size());
        purCol.forEach(dyo -> result.add(dyo.getString("materialentry.id")));
        return result;
    }

    public static Map<String, DynamicObject> getOrderDyoMap(List<String> pOrderList) {
        DynamicObject[] dyos;
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(pOrderList.size());
        String selectFields = "sumtaxamount,entryentity.order,entryentity.goods,jdorderstatus,orderstatus,id,entryentity.id,platform,jdorderid";
        QFilter jdOrderFilter = new QFilter("jdorderid", "in", pOrderList);
        for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{jdOrderFilter})) {
            result.put(dyo.getString("jdorderid"), dyo);
        }
        return result;
    }

    public static List<String> filterUnsyncWhenEnableExternalSearch(List<String> skus, String platform) {
        DynamicObject ecAdminDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_ecadmit", (QFilter[])new QFilter[]{new QFilter("platform", "=", (Object)platform).and("openstatus", "=", (Object)"2")});
        if (ecAdminDyn != null && ecAdminDyn.getBoolean("external_search")) {
            log.info("\u542f\u7528\u4e86\u5916\u90e8\u7535\u5546\u9009\u54c1");
            ArrayList<String> res = new ArrayList<String>(skus.size());
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_mallgoods", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", skus).and("source", "=", (Object)platform)}, null);){
                for (Row row : dataSet) {
                    res.add(row.getString("number"));
                }
                log.info("\u8fc7\u6ee4\u672a\u540c\u6b65\u5546\u54c1\u540e\uff1a" + res);
                ArrayList<String> arrayList = res;
                return arrayList;
            }
        }
        return skus;
    }
}

