/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mal.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.helper.apiconnector.api.parser.CgApiParser;
import kd.scm.common.helper.apiconnector.api.parser.DlApiParser;
import kd.scm.common.helper.apiconnector.api.parser.JdApiParser;
import kd.scm.common.helper.apiconnector.api.parser.SnApiParser;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.mal.business.factory.MalBusinessFactory;
import kd.scm.mal.business.order.entity.MalEcOrderConfirmResult;
import kd.scm.mal.business.order.service.MalEcOrderConfirmService;

public class MalOrderEcConfirmOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(MalOrderEcConfirmOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("cfmstatus");
        filds.add("jdorderstatus");
        filds.add("jdorderid");
        filds.add("platform");
        filds.add("billno");
        filds.add("billstatus");
        filds.add("entryentity.erpbillnumber");
        filds.add("entryentity.erpbillstatus");
        filds.add("entryentity.erplogstatus");
        filds.add("asyncstatus");
        filds.add("entryentity.erpsourceentryid");
        filds.add("entryentity.qty");
        if (MalOrderUtil.getDefaultMalVersion()) {
            filds.add("ecorderid");
            filds.add("orderstatus");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        log.info("\u7535\u5546\u786e\u8ba4\u6536\u8d27\u5e76\u66f4\u65b0\u7535\u5546\u72b6\u6001");
        ArrayList<Object> malOrderIds = new ArrayList<Object>(e.getDataEntities().length);
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            malOrderIds.add(dynamicObject.getPkValue());
        }
        this.updateEcStatus(malOrderIds.toArray());
        MalEcOrderConfirmResult malEcOrderConfirmResult = ((MalEcOrderConfirmService)MalBusinessFactory.serviceOf(MalEcOrderConfirmService.class)).confirmReceived(malOrderIds);
        if (StringUtils.isNotBlank((CharSequence)malEcOrderConfirmResult.getErrorMsg())) {
            throw new KDBizException(malEcOrderConfirmResult.getErrorMsg());
        }
    }

    private void updateEcStatus(Object[] ids) {
        Map<String, DynamicObjectCollection> malOrdersMap = this.querySelectedMalOrderByPks(ids);
        if (malOrdersMap.isEmpty()) {
            return;
        }
        this.updateJdStatus(malOrdersMap.get(EcPlatformEnum.ECPLATFORM_JD.getVal()), EcPlatformEnum.ECPLATFORM_JD.getVal());
        this.updateJdStatus(malOrdersMap.get(EcPlatformEnum.ECPLATFORM_JDPRO.getVal()), EcPlatformEnum.ECPLATFORM_JDPRO.getVal());
        this.updateSnStatus(malOrdersMap.get(EcPlatformEnum.ECPLATFORM_SUNING.getVal()));
        this.updateXyStatus(malOrdersMap.get(EcPlatformEnum.ECPLATFORM_XY.getVal()));
        this.updateCgStatus(malOrdersMap.get(EcPlatformEnum.ECPLATFORM_CG.getVal()));
        this.updateDlStatus(malOrdersMap.get(EcPlatformEnum.ECPLATFORM_DL.getVal()));
        this.updateXfsStatus(malOrdersMap.get(EcPlatformEnum.ECPLATFORM_XFS.getVal()));
        this.updateZkhStatus(malOrdersMap.get(EcPlatformEnum.ECPLATFORM_ZKH.getVal()));
    }

    private void updateXfsStatus(DynamicObjectCollection malOrders) {
        DynamicObject[] xfsOrders;
        if (malOrders == null || malOrders.isEmpty()) {
            return;
        }
        HashMap<String, String> orderIdStateMap = new HashMap<String, String>(malOrders.size() * 2);
        for (DynamicObject malOrder : malOrders) {
            String ecOrderPkId = malOrder.getString("order");
            String pOrderId = MalNewOrderUtils.getOrderId((String)EcPlatformEnum.ECPLATFORM_XFS.getVal(), (String)ecOrderPkId);
            Map data = (Map)EcGroupApiUtil.getEcOrderDetail((String)pOrderId, (String)EcPlatformEnum.ECPLATFORM_XFS.getVal()).get(EcPlatformEnum.ECPLATFORM_XFS.getVal());
            if (null == data || null == data.get("state")) continue;
            orderIdStateMap.put(pOrderId, String.valueOf(data.get("state")));
        }
        QFilter filter = new QFilter("orderid", "in", orderIdStateMap.keySet());
        for (DynamicObject xfsOrder : xfsOrders = BusinessDataServiceHelper.load((String)"pbd_order_xfs", (String)"id,orderid,orderstate,submitstate,state", (QFilter[])new QFilter[]{filter})) {
            String orderId = xfsOrder.getString("orderid");
            xfsOrder.set("state", orderIdStateMap.get(orderId));
        }
        SaveServiceHelper.save((DynamicObject[])xfsOrders);
    }

    private void updateJdStatus(DynamicObjectCollection malOrders, String source) {
        if (malOrders == null || malOrders.isEmpty()) {
            return;
        }
        HashMap<String, Set> stateOrderIdSetMap = new HashMap<String, Set>(malOrders.size() * 2);
        for (DynamicObject malOrder : malOrders) {
            Map detail;
            String orderId;
            Map data;
            String orderPk = malOrder.getString("order");
            if (!StringUtils.isNotBlank((CharSequence)orderPk) || "0".equals(orderPk) || null == (data = EcApiUtil.JdChildOrder((String)(orderId = MalNewOrderUtils.getSubOrderId((String)source, (String)orderPk)), (String)source)) || null == data.get("success") || !data.get("success").toString().equalsIgnoreCase("true") || null == (detail = (Map)data.get("result")) || null == detail.get("state")) continue;
            String state2 = detail.get("state").toString();
            HashSet<String> orderIdSet2 = (HashSet<String>)stateOrderIdSetMap.get(detail.get("state").toString());
            if (orderIdSet2 == null) {
                orderIdSet2 = new HashSet<String>(malOrders.size());
            }
            orderIdSet2.add(orderId);
            stateOrderIdSetMap.put(state2, orderIdSet2);
        }
        log.info("@@updateJdStatus.stateOrderIdSetMap:" + stateOrderIdSetMap);
        stateOrderIdSetMap.forEach((state, orderIdSet) -> JdApiParser.updateJdOrderStatus((String)"jdstate", (Set)orderIdSet, (String)state));
    }

    private void updateSnStatus(DynamicObjectCollection malOrders) {
        if (malOrders == null || malOrders.isEmpty()) {
            return;
        }
        for (DynamicObject malOrder : malOrders) {
            String pOrderPkId = malOrder.getString("pOrder");
            String pOrderId = MalNewOrderUtils.getOrderId((String)EcPlatformEnum.ECPLATFORM_SUNING.getVal(), (String)pOrderPkId);
            Map orderIdStatusMap = EcApiUtil.getSnOrderStatusMap((String)pOrderId);
            SnApiParser.updateSnOrderStatus((Map)orderIdStatusMap);
        }
    }

    private void updateXyStatus(DynamicObjectCollection malOrders) {
        DynamicObject[] xyOrders;
        if (malOrders == null || malOrders.isEmpty()) {
            return;
        }
        HashMap<String, String> orderIdStateMap = new HashMap<String, String>(malOrders.size() * 2);
        HashMap<String, String> orderIdSubmitStateMap = new HashMap<String, String>(malOrders.size() * 2);
        HashMap<String, String> orderIdOrderStateMap = new HashMap<String, String>(malOrders.size() * 2);
        for (DynamicObject malOrder : malOrders) {
            String pOrderPkId = malOrder.getString("pOrder");
            String pOrderId = MalNewOrderUtils.getOrderId((String)EcPlatformEnum.ECPLATFORM_XY.getVal(), (String)pOrderPkId);
            Map data = EcApiUtil.getXyOrderDetail((String)pOrderId);
            if (null == data || null == data.get("state")) continue;
            orderIdStateMap.put(pOrderId, String.valueOf(data.get("state")));
            orderIdOrderStateMap.put(pOrderId, String.valueOf(data.get("orderState")));
            orderIdSubmitStateMap.put(pOrderId, String.valueOf(data.get("submitState")));
        }
        QFilter filter = new QFilter("orderid", "in", orderIdStateMap.keySet());
        for (DynamicObject xyOrder : xyOrders = BusinessDataServiceHelper.load((String)"pbd_order_xy", (String)"id,orderid,orderstate,submitstate,state", (QFilter[])new QFilter[]{filter})) {
            String orderId = xyOrder.getString("orderid");
            xyOrder.set("submitstate", orderIdSubmitStateMap.get(orderId));
            xyOrder.set("orderstate", orderIdOrderStateMap.get(orderId));
            xyOrder.set("state", orderIdStateMap.get(orderId));
        }
        SaveServiceHelper.save((DynamicObject[])xyOrders);
    }

    private void updateDlStatus(DynamicObjectCollection malOrders) {
        DynamicObject[] dlDyos;
        if (malOrders == null || malOrders.isEmpty()) {
            return;
        }
        HashSet<Long> pOrderPkSet = new HashSet<Long>(malOrders.size() * 2);
        for (DynamicObject malOrder : malOrders) {
            pOrderPkSet.add(malOrder.getLong("pOrder"));
        }
        for (DynamicObject dyo : dlDyos = DlApiParser.getDlOrderByPks(pOrderPkSet)) {
            String orderId = dyo.getString("orderid");
            Map orderIdStatusMap = (Map)EcGroupApiUtil.getEcOrderStatusMap((String)orderId, (String)EcPlatformEnum.ECPLATFORM_DL.getVal()).get(EcPlatformEnum.ECPLATFORM_DL.getVal());
            dyo.set("state", (Object)String.valueOf(orderIdStatusMap.get(orderId)));
        }
        SaveServiceHelper.save((DynamicObject[])dlDyos);
    }

    private void updateCgStatus(DynamicObjectCollection malOrders) {
        if (malOrders == null || malOrders.isEmpty()) {
            return;
        }
        HashSet<Long> pOrderPkSet = new HashSet<Long>(malOrders.size() * 2);
        for (DynamicObject malOrder : malOrders) {
            pOrderPkSet.add(malOrder.getLong("pOrder"));
        }
        DynamicObjectCollection xyOrders = QueryServiceHelper.query((String)"pbd_order_cg", (String)"porderid", (QFilter[])new QFilter[]{new QFilter("id", "in", pOrderPkSet)});
        HashSet<String> pOrderSet = new HashSet<String>(malOrders.size() * 2);
        for (DynamicObject xyOrder : xyOrders) {
            pOrderSet.add(xyOrder.getString("porderid"));
        }
        Map orderIdStateMap = EcApiUtil.batchGetCgOrderStatusMap(pOrderSet);
        CgApiParser.updateCgOrderState((Map)orderIdStateMap);
    }

    private void updateZkhStatus(DynamicObjectCollection malOrders) {
        DynamicObject[] zkhOrders;
        if (malOrders == null || malOrders.isEmpty()) {
            return;
        }
        HashMap<String, String> orderIdStateMap = new HashMap<String, String>(malOrders.size() * 2);
        for (DynamicObject malOrder : malOrders) {
            String ecOrderPkId = malOrder.getString("order");
            String pOrderId = MalNewOrderUtils.getOrderId((String)EcPlatformEnum.ECPLATFORM_ZKH.getVal(), (String)ecOrderPkId);
            Map data = (Map)EcGroupApiUtil.getEcOrderDetail((String)pOrderId, (String)EcPlatformEnum.ECPLATFORM_ZKH.getVal()).get(EcPlatformEnum.ECPLATFORM_ZKH.getVal());
            if (null == data || null == data.get("state")) continue;
            orderIdStateMap.put(pOrderId, String.valueOf(data.get("state")));
        }
        QFilter filter = new QFilter("orderid", "in", orderIdStateMap.keySet());
        for (DynamicObject zkhOrder : zkhOrders = BusinessDataServiceHelper.load((String)"pbd_order_zkh", (String)"id,orderid,orderstate,submitstate,state", (QFilter[])new QFilter[]{filter})) {
            String orderId = zkhOrder.getString("orderid");
            zkhOrder.set("state", orderIdStateMap.get(orderId));
        }
        SaveServiceHelper.save((DynamicObject[])zkhOrders);
    }

    private Map<String, DynamicObjectCollection> querySelectedMalOrderByPks(Object[] ids) {
        QFilter filter = new QFilter("id", "in", (Object)ids).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()).and("platform", "!=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal());
        return this.querySelectMalOrderByFilter(filter);
    }

    private Map<String, DynamicObjectCollection> querySelectMalOrderByFilter(QFilter filter) {
        HashMap<String, DynamicObjectCollection> res = new HashMap<String, DynamicObjectCollection>(16);
        QFilter[] filters = new QFilter[]{filter};
        String selectProperties = "id,billno,platform,ecorderid pOrder,entryentity.order order";
        DynamicObjectCollection malOrders = QueryServiceHelper.query((String)"mal_order", (String)selectProperties, (QFilter[])filters);
        for (DynamicObject malOrder : malOrders) {
            String platform = malOrder.getString("platform");
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(malOrder.getString("platform"))) continue;
            DynamicObjectCollection col = (DynamicObjectCollection)res.get(platform);
            if (col == null) {
                col = new DynamicObjectCollection();
            }
            col.add((Object)malOrder);
            res.put(platform, col);
        }
        return res;
    }
}

