/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.DataTypeEnum;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.BaseDataMixUtil;
import kd.scm.common.util.BillPushAssistUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.MessageUtil;
import kd.scm.common.util.SaloutUtil;
import kd.scm.common.util.check.CheckRelationUtil;
import kd.scm.common.util.check.CheckWriteDataEntity;
import kd.scm.common.util.check.OrderCheckUtil;
import kd.scm.common.util.invoice.ScpWriteBackUtil;

public class PurUpgradePlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(PurUpgradePlugin.class);
    private static final String PUR_RECEIPT_RETURN = "pur_receipt_return";
    private String[] entityKeys = new String[]{"pur_receipt", "pur_instock", "pur_return"};
    private String[] currEntityKeys = new String[]{"pur_order", "pur_saloutstock", "pur_receipt", "pur_instock", "pur_return"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"barupgrade", "bardtupgrade"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("tenantid", (Object)RequestContext.get().getTenantId());
        this.getModel().setValue("accountid", (Object)RequestContext.get().getAccountId());
        super.afterCreateNewData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("ptupgrage".equalsIgnoreCase(key)) {
            this.upgrade();
        } else if ("sendmsg".equalsIgnoreCase(key)) {
            MessageUtil.sendMsgToMsgCenter();
        } else if ("dtupgrade".equalsIgnoreCase(key)) {
            this.upgradeDt();
        } else if ("upgradect".equalsIgnoreCase(key)) {
            this.upgradeCt();
        } else if ("updatecfmstatus".equalsIgnoreCase(key)) {
            this.upgradeOrderCfms();
        } else if ("updatebasedata".equalsIgnoreCase(key)) {
            this.updateBasedata();
        } else if ("rebuildcheckrelation".equalsIgnoreCase(key)) {
            this.rebuild();
        } else if ("fixordercheck".equalsIgnoreCase(key)) {
            this.fixOrderCheckData();
        } else if ("upgradecurr".equalsIgnoreCase(key)) {
            this.upgradeCurr();
        } else if ("supplierupgrade".equalsIgnoreCase(key)) {
            this.doSupplierUpgrade();
        } else if ("materialupgrade".equalsIgnoreCase(key)) {
            this.doMaterialUpgrade();
        } else if ("updatepurorderdata".equalsIgnoreCase(key)) {
            this.updatePurOrderData();
        } else if ("updaterejdata".equalsIgnoreCase(key)) {
            this.updateRejData();
        } else if ("updateinvoicedata".equalsIgnoreCase(key)) {
            this.updateInvoice();
        } else if ("updatesrcprojectdata".equalsIgnoreCase(key)) {
            this.insertData("scm", "src_bidbillcomptpl", "fid", "t_src_project", "t_src_project_l", "en_US");
            this.insertData("scm", "src_bidbillcomptpl", "fid", "t_src_project", "t_src_project_l", "zh_TW");
            ArrayList<String> filedList = new ArrayList<String>(1);
            filedList.add("fnodename");
            this.updatesrcprojectdata("scm", filedList, "fid", "t_src_project", "t_src_project_l", "zh_CN");
            this.updatesrcprojectdata("scm", filedList, "fid", "t_src_project", "t_src_project_l", "zh_TW");
            this.updatesrcprojectdata("scm", filedList, "fid", "t_src_project", "t_src_project_l", "en_US");
        }
    }

    public void updateInvoice() {
        int pageSize = 20000;
        String orderKey = "scp_invoice";
        List countList = QueryServiceHelper.queryPrimaryKeys((String)orderKey, null, (String)"id", (int)Integer.MAX_VALUE);
        int count = 0;
        if (null != countList) {
            count = countList.size();
        }
        if (0 >= count) {
            return;
        }
        int totalPages = count / pageSize;
        if (count % pageSize != 0) {
            ++totalPages;
        }
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            String selectFields = "id, entryentity1.poentryid1, entryentity1.qty1, entryentity1.taxamount1, entryentity1.actchecktaxamount,entryentity1.srcbilltype1, entryentity1.srcentryid1";
            log.info("updateInvoice \u52a0\u8f7d\u5f00\u7968\u5355\u6570\u636e\uff0c\u9875\u5e8f\u53f7\uff1a" + pageIndex);
            DynamicObject[] cols = BusinessDataServiceHelper.load((String)orderKey, (String)selectFields, null, (String)"id", (int)pageIndex, (int)pageSize);
            ScpWriteBackUtil.writeBackInvoiceAmtAndQty(Arrays.asList(cols), (Boolean)ScpWriteBackUtil.SAVE_OP, (Boolean)ScpWriteBackUtil.NEED_CLEAN_DATA);
        }
        IFormView view = this.getView();
        view.showMessage(ResManager.loadKDString((String)"\u5f00\u7968\u5355\u5df2\u5f00\u7968\u6570\u91cf\u5347\u7ea7\u6210\u529f\u3002", (String)"PurUpgradePlugin_22", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
    }

    public void updateRejData() {
        int pageSize = 10000;
        String orderKey = "pur_order";
        List countList = QueryServiceHelper.queryPrimaryKeys((String)orderKey, (QFilter[])new QFilter[]{new QFilter("billstatus", "not in", (Object)"D,Z")}, (String)"id", (int)Integer.MAX_VALUE);
        int count = 0;
        if (null != countList) {
            count = countList.size();
        }
        if (0 >= count) {
            return;
        }
        int totalPages = count / pageSize;
        if (count % pageSize != 0) {
            ++totalPages;
        }
        HashMap<String, DynamicObject> orderEntryMap = null;
        ArrayList<String> poentryIdList = null;
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            orderEntryMap = new HashMap<String, DynamicObject>(10000);
            poentryIdList = new ArrayList<String>(10000);
            String selectFields = "id, materialentry.poentryid, materialentry.sumrejqty, materialentry.sumoutstockqty";
            log.info("updateRejData \u52a0\u8f7d\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\uff0c\u9875\u5e8f\u53f7\uff1a" + pageIndex);
            DynamicObject[] cols = BusinessDataServiceHelper.load((String)orderKey, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("billstatus", "not in", (Object)"D,Z")}, (String)"id", (int)pageIndex, (int)pageSize);
            if (null == cols || cols.length <= 0) continue;
            for (DynamicObject obj : cols) {
                DynamicObjectCollection entryList = obj.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : entryList) {
                    String poentryId = entry.getString("poentryid");
                    orderEntryMap.put(poentryId, entry);
                    poentryIdList.add(poentryId);
                }
            }
            String saloutSelect = "id,modifytime,materialentry.pobillno,materialentry.poentryid,materialentry.unit,materialentry.material,materialentry.pobillid,materialentry.rejectqty,materialentry.rejectreason,rejentryentity.entryid_rej,rejentryentity.pobillno_rej,rejentryentity.inbillno_rej,rejentryentity.materialid_rej,rejentryentity.unitid_rej,rejentryentity.rejdate_rej,rejentryentity.rejectqty_rej,rejentryentity.rejectreason_rej,rejentryentity.poentryid_rej,rejentryentity.pobillid_rej";
            DynamicObject[] saloutArray = BusinessDataServiceHelper.load((String)"scp_saloutstock", (String)saloutSelect, (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poentryIdList).and(new QFilter("logstatus", "=", (Object)"H"))});
            if (null == saloutArray || saloutArray.length <= 0) continue;
            DynamicObject rejDataTemp = null;
            int needSaveCount = 0;
            for (DynamicObject obj : saloutArray) {
                DynamicObjectCollection entryList = obj.getDynamicObjectCollection("materialentry");
                DynamicObjectCollection rejEntryCol = obj.getDynamicObjectCollection("rejentryentity");
                if (null == rejEntryCol || null == entryList || entryList.isEmpty() || null != rejEntryCol && rejEntryCol.size() > 0) continue;
                for (DynamicObject entry : entryList) {
                    BigDecimal rejQty = entry.getBigDecimal("rejectqty");
                    String rejReason = entry.getString("rejectreason");
                    Object unit = entry.get("unit");
                    Object material = entry.get("material");
                    Object dateObj = obj.get("modifytime");
                    String pobillNo = entry.getString("pobillno");
                    String poentryId = entry.getString("poentryid");
                    String pobillId = entry.getString("pobillid");
                    rejDataTemp = rejEntryCol.addNew();
                    rejDataTemp.set("pobillno_rej", (Object)pobillNo);
                    rejDataTemp.set("materialid_rej", material);
                    rejDataTemp.set("rejdate_rej", dateObj);
                    rejDataTemp.set("rejectqty_rej", (Object)rejQty);
                    rejDataTemp.set("rejectreason_rej", (Object)rejReason);
                    rejDataTemp.set("poentryid_rej", (Object)poentryId);
                    rejDataTemp.set("pobillid_rej", (Object)pobillId);
                    rejDataTemp.set("unitid_rej", unit);
                    DynamicObject orderEntry = (DynamicObject)orderEntryMap.get(poentryId);
                    if (null == orderEntry) continue;
                    orderEntry.set("sumrejqty", (Object)orderEntry.getBigDecimal("sumrejqty").add(rejQty));
                    orderEntry.set("sumoutstockqty", (Object)orderEntry.getBigDecimal("sumoutstockqty").add(rejQty));
                    ++needSaveCount;
                }
            }
            if (needSaveCount <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])saloutArray);
            SaveServiceHelper.save((DynamicObject[])cols);
            log.info("\u5347\u7ea7\u9500\u552e\u53d1\u8d27\u5355\u603b\u6570\uff1a" + saloutArray.length + ", \u5347\u7ea7\u91c7\u8d2d\u8ba2\u5355\u603b\u6570:" + needSaveCount);
        }
        IFormView view = this.getView();
        view.showMessage(ResManager.loadKDString((String)"\u4e0d\u5408\u683c\u4fe1\u606f\u5347\u7ea7\u6210\u529f\u3002", (String)"PurUpgradePlugin_20", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
    }

    private void doMaterialUpgrade() {
        ApiUtil.syncMaterialGroup((String)ApiUtil.syncSupplierGroup((String)this.getGroupSendString("bd_materialgroup")));
        Set<String> materialIdSet = this.getBasedataIdSet("bd_materialgroupdetail", "material.id,number", "material");
        Set<String> materialNumSet = this.getBasedataNumSet(materialIdSet, "bd_material");
        int count = 0;
        int index = 0;
        StringBuilder stuffer = new StringBuilder();
        for (String number : materialNumSet) {
            ++count;
            ++index;
            if (stuffer.length() > 0) {
                stuffer.append(',').append('\'').append(number).append('\'');
            } else {
                stuffer.append('\'').append(number).append('\'');
            }
            if (count != 50 && index != materialNumSet.size()) continue;
            count = 0;
            ApiUtil.syncMaterial((String)stuffer.toString());
            stuffer.setLength(0);
        }
    }

    private Set<String> getBasedataNumSet(Set<String> materialIdSet, String basedataEntity) {
        DynamicObject[] materialArray = BusinessDataServiceHelper.load((String)basedataEntity, (String)"id,number", (QFilter[])new QFilter[]{null});
        HashSet<String> materialNumSet = new HashSet<String>(8);
        for (DynamicObject dyn : materialArray) {
            if (0L == dyn.getLong("id") || materialIdSet.contains(dyn.getString("id"))) continue;
            materialNumSet.add(dyn.getString("number"));
        }
        return materialNumSet;
    }

    private Set<String> getBasedataIdSet(String groupentity, String selector, String basedata) {
        QFilter stardfilter = new QFilter("standard", "!=", (Object)0);
        DynamicObject[] magDetailArray = BusinessDataServiceHelper.load((String)groupentity, (String)selector, (QFilter[])new QFilter[]{stardfilter});
        HashSet<String> materialIdSet = new HashSet<String>(8);
        for (DynamicObject dyn : magDetailArray) {
            if (null == dyn.getDynamicObject(basedata)) continue;
            materialIdSet.add(dyn.getDynamicObject(basedata).getString("id"));
        }
        return materialIdSet;
    }

    private String getGroupSendString(String groupEntity) {
        QFilter detailfilter = new QFilter("standard", "=", (Object)0);
        DynamicObject[] detailArray = BusinessDataServiceHelper.load((String)groupEntity, (String)"id,number", (QFilter[])new QFilter[]{detailfilter});
        StringBuilder stuffer = new StringBuilder();
        for (int i = 0; i < detailArray.length; ++i) {
            DynamicObject dyn = detailArray[i];
            if (null == dyn.getString("number")) continue;
            if (stuffer.length() > 0) {
                stuffer.append(',').append('\'').append(dyn.getString("number")).append('\'');
                continue;
            }
            stuffer.append('\'').append(dyn.getString("number")).append('\'');
        }
        return stuffer.toString();
    }

    private void doSupplierUpgrade() {
        ApiUtil.syncSupplierGroup((String)this.getGroupSendString("bd_suppliergroup"));
        Set<String> supplierIdSet = this.getBasedataIdSet("bd_suppliergroupdetail", "supplier.id,number", "supplier");
        Set<String> supplierNumSet = this.getBasedataNumSet(supplierIdSet, "bd_material");
        int count = 0;
        int index = 0;
        StringBuilder stuffer = new StringBuilder();
        for (String number : supplierNumSet) {
            ++count;
            ++index;
            if (stuffer.length() > 0) {
                stuffer.append(',').append('\'').append(number).append('\'');
            } else {
                stuffer.append('\'').append(number).append('\'');
            }
            if (count != 50 && index != supplierNumSet.size()) continue;
            count = 0;
            ApiUtil.syncSupplier((String)stuffer.toString());
            stuffer.setLength(0);
        }
    }

    private void updateBasedata() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int pagesize = Integer.parseInt(model.getValue("pagesize").toString());
        Object basedata = model.getValue("basedata");
        BaseDataMixUtil baseDataUtil = new BaseDataMixUtil();
        Object selectkey = model.getValue("selectkey");
        if (null == basedata) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurUpgradePlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (null == selectkey) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u67e5\u627e\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurUpgradePlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String[] basedatas = basedata.toString().split(",");
        StringBuilder strbuffer = new StringBuilder();
        for (int i = 0; i < basedatas.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)basedatas[i])) continue;
            if ("1".equals(basedatas[i])) {
                log.info("@@@@\u5f00\u59cb\u5347\u7ea7\u4ed8\u6b3e\u6761\u4ef6");
                BaseDataMixUtil.doMixBaseData((String)"pur_paycond", (String)"bd_paycondition", (int)pagesize, (String)(DynamicObjectUtil.getSelectfields((String)"bd_paycondition", (boolean)false) + "," + DynamicObjectUtil.getEntrySelectfields(null, (String)"bd_paycondition", (String)"entry", (boolean)false)), (String)selectkey.toString());
                log.info("@@@@\u7ed3\u675f\u5347\u7ea7\u4ed8\u6b3e\u6761\u4ef6");
                strbuffer.append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6", (String)"PurUpgradePlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0])).append("\uff0c");
                continue;
            }
            if ("2".equals(basedatas[i])) {
                log.info("@@@@\u5f00\u59cb\u5347\u7ea7\u4ed3\u5e93");
                BaseDataMixUtil.doMixBaseData((String)"pur_warehouse", (String)"bd_warehouse", (int)pagesize, (String)(DynamicObjectUtil.getSelectfields((String)"bd_warehouse", (boolean)false) + "," + DynamicObjectUtil.getEntrySelectfields(null, (String)"bd_warehouse", (String)"entryentity", (boolean)false)), (String)selectkey.toString());
                log.info("@@@@\u7ed3\u675f\u5347\u7ea7\u4ed3\u5e93");
                strbuffer.append(ResManager.loadKDString((String)"\u4ed3\u5e93", (String)"PurUpgradePlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0])).append("\uff0c");
                continue;
            }
            if ("3".equals(basedatas[i])) {
                log.info("@@@@\u5f00\u59cb\u5347\u7ea7\u5e93\u4f4d");
                BaseDataMixUtil.doMixBaseData((String)"pur_location", (String)"bd_location", (int)pagesize, (String)DynamicObjectUtil.getSelectfields((String)"bd_location", (boolean)false), (String)selectkey.toString());
                log.info("@@@@\u7ed3\u675f\u5347\u7ea7\u5e93\u4f4d");
                strbuffer.append(ResManager.loadKDString((String)"\u5e93\u4f4d", (String)"PurUpgradePlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[0])).append("\uff0c");
                continue;
            }
            if (!"4".equals(basedatas[i])) continue;
            log.info("@@@@\u5f00\u59cb\u5347\u7ea7\u9879\u76ee\u53f7");
            BaseDataMixUtil.doMixBaseData((String)"pur_project", (String)"bd_project", (int)pagesize, (String)DynamicObjectUtil.getSelectfields((String)"bd_project", (boolean)false), (String)selectkey.toString());
            log.info("@@@@\u7ed3\u675f\u5347\u7ea7\u9879\u76ee\u53f7");
            strbuffer.append(ResManager.loadKDString((String)"\u9879\u76ee\u53f7", (String)"PurUpgradePlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[0])).append("\uff0c");
        }
        String message = ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"PurUpgradePlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
        view.showMessage(strbuffer.toString().substring(0, strbuffer.toString().length() - 1) + message);
    }

    private void upgrade() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String billKey = (String)model.getValue("billname");
        Object purType = model.getValue("purtype");
        Object purtypeId = 530841016689795072L;
        String[] billKeys = new String[]{"pur_instock", "pur_receipt"};
        if (null != purType) {
            purtypeId = ((DynamicObject)purType).getPkValue();
        }
        if (null != billKey && billKey.trim().length() > 0) {
            this.upgradePurtype(billKey.split(","), purtypeId);
        } else {
            this.upgradePurtype(billKeys, purtypeId);
        }
        view.showMessage(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\uff01", (String)"PurUpgradePlugin_23", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
    }

    private void upgradePurtype(String[] billKeys, Object purtypeId) {
        String selectFields = "id,billno,materialentry.purtype";
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        filter.and(new QFilter("materialentry.purtype", "is null", (Object)"").or(new QFilter("materialentry.purtype", "=", (Object)0)));
        ArrayList<DynamicObject> upgradeData = new ArrayList<DynamicObject>();
        for (int i = 0; i < billKeys.length; ++i) {
            upgradeData.clear();
            Map dataMap = BusinessDataServiceHelper.loadFromCache((String)billKeys[i], (String)selectFields, (QFilter[])new QFilter[]{filter});
            for (Map.Entry bill : dataMap.entrySet()) {
                DynamicObject data = (DynamicObject)bill.getValue();
                DynamicObjectCollection cols = data.getDynamicObjectCollection("materialentry");
                for (DynamicObject col : cols) {
                    col.set("purtype", purtypeId);
                }
                upgradeData.add(data);
            }
            SaveServiceHelper.save((DynamicObject[])upgradeData.toArray(new DynamicObject[0]));
        }
    }

    private void upgradeCt() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object checkType = model.getValue("checktype");
        Object purType = model.getValue("purtypeforct");
        if (null == checkType) {
            view.showMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"PurUpgradePlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectFields = "id,datatype,number,checktype";
        QFilter filter = new QFilter("datatype", "=", (Object)DataTypeEnum.PURTYPE.getValue());
        filter.and(new QFilter("checktype", "is null", (Object)"").or(new QFilter("checktype", "=", (Object)" ")).or(new QFilter("checktype", "=", (Object)"0")));
        if (null != purType) {
            Object purtypeId = ((DynamicObject)purType).getPkValue();
            filter.and(new QFilter("id", "=", purtypeId));
        }
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)"pbd_mallextdata", (String)selectFields, (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> upgradeData = new ArrayList<DynamicObject>(dataMap.size());
        for (Map.Entry val : dataMap.entrySet()) {
            DynamicObject data = (DynamicObject)val.getValue();
            data.set("checktype", checkType);
            upgradeData.add(data);
        }
        SaveServiceHelper.save((DynamicObject[])upgradeData.toArray(new DynamicObject[0]));
        view.showMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u7c7b\u578b\u5347\u7ea7\u6210\u529f\u3002", (String)"PurUpgradePlugin_8", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
    }

    private void upgradeDt() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object destType = model.getValue("desttype");
        Object purType = model.getValue("purtypefordt");
        if (null == destType) {
            view.showMessage(ResManager.loadKDString((String)"\u76ee\u7684\u5730\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"PurUpgradePlugin_9", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectFields = "id,datatype,number,desttype";
        QFilter filter = new QFilter("datatype", "=", (Object)DataTypeEnum.PURTYPE.getValue());
        filter.and(new QFilter("desttype", "is null", (Object)"").or(new QFilter("desttype", "=", (Object)" ")));
        if (null != purType) {
            Object purtypeId = ((DynamicObject)purType).getPkValue();
            filter.and(new QFilter("id", "=", purtypeId));
        }
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)"pbd_mallextdata", (String)selectFields, (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> upgradeData = new ArrayList<DynamicObject>(dataMap.size());
        for (Map.Entry val : dataMap.entrySet()) {
            DynamicObject data = (DynamicObject)val.getValue();
            data.set("desttype", destType);
            upgradeData.add(data);
        }
        SaveServiceHelper.save((DynamicObject[])upgradeData.toArray(new DynamicObject[0]));
        view.showMessage(ResManager.loadKDString((String)"\u76ee\u7684\u5730\u7c7b\u578b\u5347\u7ea7\u6210\u529f\u3002", (String)"PurUpgradePlugin_10", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
    }

    private void upgradeOrderCfms() {
        IFormView view = this.getView();
        QFilter filter = new QFilter("logstatus", "=", (Object)" ");
        filter.or("logstatus", "is null", (Object)"");
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("id,billno,cfmstatus,billstatus,logstatus,org").append(",materialentry.id,materialentry.qty,materialentry.sumreceiveqty,materialentry.sumoutstockqty").append(",materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.vmistockqty,materialentry.rowlogstatus");
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"scp_saloutstock", (String)selectSb.toString(), (QFilter[])new QFilter[]{filter});
        SaloutUtil.updateCfmStatus((DynamicObject[])objs);
        SaveServiceHelper.save((DynamicObject[])objs);
        view.showMessage(ResManager.loadKDString((String)"\u66f4\u65b0\u534f\u540c\u786e\u8ba4\u72b6\u6001\u6210\u529f\u3002", (String)"PurUpgradePlugin_11", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
    }

    private void fixOrderCheckData() {
        OrderCheckUtil.fixOrderCheckDataByCheck();
        this.getView().showMessage(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f\uff01", (String)"PurUpgradePlugin_12", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
    }

    private void rebuild() {
        if (!this.checkCondtion()) {
            return;
        }
        String[] entityKeys = this.getEntityKeys();
        for (int i = 0; i < entityKeys.length; ++i) {
            String entityKey = entityKeys[i];
            log.info("###rebuild:" + entityKey);
            boolean isReturn = this.isReturn(entityKey);
            if (PUR_RECEIPT_RETURN.equals(entityKey)) {
                entityKey = "pur_receipt";
            }
            QFilter filter = this.getRebuildCondtion(entityKey, isReturn);
            String selectFields = this.getSelectFields(entityKey);
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{filter});
            if (objs.length == 0) continue;
            List idList = DynamicObjectUtil.getProVal2List((DynamicObject[])objs, (String)"id");
            log.info("###rebuild " + entityKey + ",IdList:" + CommonUtil.list2str((List)idList));
            DynamicObjectCollection checkRelCols = CheckRelationUtil.getCheckRelation((List)idList);
            Map checkRelMap = null;
            if (null != checkRelCols && checkRelCols.size() > 0) {
                checkRelMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)checkRelCols, (String)"srcid");
            }
            ArrayList<DynamicObject> noCheckRelDataList = new ArrayList<DynamicObject>();
            for (DynamicObject obj : objs) {
                if (null != checkRelMap && (null == checkRelMap || null != checkRelMap.get(String.valueOf(obj.getPkValue())))) continue;
                noCheckRelDataList.add(obj);
            }
            if (noCheckRelDataList.size() == 0) continue;
            if (isReturn) {
                String srcEntityKey = null;
                ArrayList<String> proList = new ArrayList<String>();
                if ("pur_receipt".equals(entityKey)) {
                    proList.add("sumrecretqty");
                    srcEntityKey = "scp_receipt";
                } else if ("pur_return".equals(entityKey)) {
                    proList.add("suminstockretqty");
                    srcEntityKey = "scp_return";
                }
                List entryIdList = DynamicObjectUtil.getProVal2List((DynamicObject[])noCheckRelDataList.toArray(new DynamicObject[0]), (String)"materialentry", (String)"id");
                ArrayList<Long> entryIdLi = new ArrayList<Long>(entryIdList.size());
                for (String entryId : entryIdList) {
                    entryIdLi.add(Long.valueOf(entryId));
                }
                ArrayList targetIdList = new ArrayList();
                List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)srcEntityKey, (String)"materialentry", (Long[])entryIdLi.toArray(new Long[0]));
                bfRowList.forEach(bfRow -> targetIdList.add(bfRow.getId().getBillId()));
                log.info("rebuild targetIdList:" + CommonUtil.collection2str(targetIdList));
                List<DynamicObject> tarDataList = new ArrayList();
                if (targetIdList.size() > 0) {
                    String returnSelectFields = "id,billno,materialentry.qty,materialentry.poentryid,materialentry.pobillid,materialentry.pobillno";
                    QFilter returnFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
                    DynamicObject[] returnObjs = BusinessDataServiceHelper.load((String)"scp_salreturn", (String)returnSelectFields, (QFilter[])new QFilter[]{returnFilter});
                    if (returnObjs.length == 0) continue;
                    tarDataList.addAll(Arrays.asList(returnObjs));
                } else {
                    tarDataList = BillPushAssistUtil.pushToTargetAuditBill(noCheckRelDataList, (String)srcEntityKey, (String)"materialentry", (String)"scp_salreturn");
                }
                CheckRelationUtil.createCheckRelation(noCheckRelDataList, tarDataList, (String)entityKey);
                continue;
            }
            String pro = null;
            if ("pur_receipt".equals(entityKey)) {
                pro = "sumreceiptqty";
            } else if ("pur_instock".equals(entityKey)) {
                pro = "suminstockqty";
            }
            CheckWriteDataEntity writeData = this.getCheckWriteData(noCheckRelDataList);
            PurUpgradePlugin.rebuildCheckRel(writeData, pro, "audit");
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u6784\u5efa\u6210\u529f\uff01", (String)"PurUpgradePlugin_13", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
    }

    public static void rebuildCheckRel(CheckWriteDataEntity writeData, String pro, String operation) {
        Map writeDataMap = writeData.getWriteDataMap();
        if (writeDataMap.size() == 0) {
            log.info("###writeDataMap isEmpty!");
            return;
        }
        QFilter filter = new QFilter("materialentry.poentryid", "in", writeDataMap.keySet());
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        StringBuilder selectSb = new StringBuilder();
        selectSb.append("id,billno,cfmstatus,billstatus,logstatus").append(",materialentry.id,materialentry.poentryid,materialentry.srcentryid,materialentry.qty").append(",materialentry.sumreceiptqty,materialentry.suminstockqty");
        String orderBy = "billdate asc";
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"scp_saloutstock", (String)selectSb.toString(), (QFilter[])new QFilter[]{filter}, (String)orderBy);
        ArrayList<DynamicObject> checkRelationList = new ArrayList<DynamicObject>();
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject salOut = datas[i];
            DynamicObjectCollection cols = salOut.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                String poEntryId = col.getString("poentryid");
                Map srcEntryId_qtyMap = writeData.getWriteDataMap(poEntryId);
                if (null == srcEntryId_qtyMap) continue;
                String srcEntryId = null;
                BigDecimal writeQty = null;
                for (Map.Entry qtyMapEntry : srcEntryId_qtyMap.entrySet()) {
                    srcEntryId = (String)qtyMapEntry.getKey();
                    writeQty = (BigDecimal)qtyMapEntry.getValue();
                    if (writeQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                }
                BigDecimal sumQty = BigDecimal.ZERO;
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)col.get("qty"));
                if (null == writeQty || null != writeQty && writeQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal restWriteQty = BigDecimal.ZERO;
                if ("audit".equals(operation)) {
                    boolean isBuildRelation = true;
                    BigDecimal realWriteQty = BigDecimal.ZERO;
                    if (sumQty.compareTo(qty) < 0 && sumQty.add(writeQty).compareTo(qty) < 0) {
                        realWriteQty = writeQty;
                    } else if (sumQty.compareTo(qty) < 0 && sumQty.add(writeQty).compareTo(qty) >= 0) {
                        restWriteQty = sumQty.add(writeQty).subtract(qty);
                        realWriteQty = writeQty.subtract(restWriteQty);
                    } else {
                        isBuildRelation = false;
                        continue;
                    }
                    if (isBuildRelation) {
                        DynamicObject writeRelation = CheckRelationUtil.createRelationObj((String)poEntryId, (String)srcEntryId, (String)col.getPkValue().toString(), (BigDecimal)realWriteQty);
                        CheckRelationUtil.setRelationData((DynamicObject)salOut, (DynamicObject)writeRelation, (CheckWriteDataEntity)writeData);
                        checkRelationList.add(writeRelation);
                    }
                }
                srcEntryId_qtyMap.put(srcEntryId, restWriteQty);
            }
        }
        if (checkRelationList.size() > 0) {
            Object[] relationObjs = SaveServiceHelper.save((DynamicObject[])checkRelationList.toArray(new DynamicObject[0]));
            log.info("###rebuild saveRelations!" + Arrays.toString(relationObjs));
        }
    }

    private CheckWriteDataEntity getCheckWriteData(List<DynamicObject> objs) {
        CheckWriteDataEntity writeData = new CheckWriteDataEntity();
        if (objs.size() == 0) {
            return writeData;
        }
        String entityKey = objs.get(0).getDataEntityType().getName();
        for (DynamicObject obj : objs) {
            DynamicObjectCollection cols = obj.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : cols) {
                String srcEntryIdStr;
                Object srcPoEntryId = entry.get("poentryid");
                if (null == srcPoEntryId || (srcEntryIdStr = String.valueOf(srcPoEntryId)).isEmpty()) continue;
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.get("qty"));
                writeData.setWriteData(srcEntryIdStr, entry.getPkValue().toString(), qty);
                writeData.setEntryIdBillIdMap(entry.getPkValue().toString(), obj.getPkValue().toString());
                writeData.setSrcEntityKey(entityKey);
                writeData.setTarEntityKey("pur_saloutstock");
            }
        }
        return writeData;
    }

    private String getSelectFields(String entityKey) {
        StringBuilder selectProperties = new StringBuilder();
        selectProperties.append("billno").append(',').append("materialentry").append('.').append("qty").append(',').append("materialentry").append('.').append("srcbillid").append(',').append("materialentry").append('.').append("srcentryid").append(',').append("materialentry").append('.').append("pobillid").append(',').append("materialentry").append('.').append("poentryid");
        return selectProperties.toString();
    }

    private boolean checkCondtion() {
        IFormView view = this.getView();
        Object dateFromObj = this.getModel().getValue("datefrom");
        if (null == dateFromObj) {
            view.showMessage(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurUpgradePlugin_14", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object dateToObj = this.getModel().getValue("dateto");
        if (null == dateToObj) {
            view.showMessage(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurUpgradePlugin_15", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private QFilter getRebuildCondtion(String entityKey, boolean isReturn) {
        IDataModel model = this.getModel();
        Date dateFrom = (Date)model.getValue("datefrom");
        Date dateTo = (Date)model.getValue("dateto");
        QFilter filter = new QFilter("billdate", ">=", (Object)dateFrom);
        filter.and("billdate", "<=", (Object)dateTo);
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        if ("pur_instock".equals(entityKey) || "pur_return".equals(entityKey)) {
            filter.and("iscentersettle", "!=", (Object)"1");
        } else if (isReturn && "pur_receipt".equals(entityKey)) {
            filter.and("isreturn", "=", (Object)"1");
        } else if (!isReturn && "pur_receipt".equals(entityKey)) {
            filter.and("isreturn", "!=", (Object)"1");
        }
        return filter;
    }

    private String[] getEntityKeys() {
        String entityKeysObj = (String)this.getModel().getValue("entitykeys");
        if (null != entityKeysObj && entityKeysObj.trim().length() > 0) {
            this.entityKeys = entityKeysObj.split(",");
        }
        ArrayList<String> entityKeyList = new ArrayList<String>(Arrays.asList(this.entityKeys));
        for (String entityKey : this.entityKeys) {
            if (!entityKey.equals("pur_receipt")) continue;
            entityKeyList.add(PUR_RECEIPT_RETURN);
        }
        return entityKeyList.toArray(new String[0]);
    }

    private boolean isReturn(String entityKey) {
        boolean isReturn = false;
        if (PUR_RECEIPT_RETURN.equals(entityKey)) {
            isReturn = true;
        } else if ("pur_return".equals(entityKey)) {
            isReturn = true;
        }
        return isReturn;
    }

    protected void upgradeCurr() {
        String[] entityKeys;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object curr = model.getValue("curr");
        if (null == curr) {
            view.showMessage(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurUpgradePlugin_16", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isUpdate = (Boolean)model.getValue("updatecurr");
        Object tarCurr = model.getValue("tarcurr");
        if (isUpdate && null == tarCurr) {
            view.showMessage(ResManager.loadKDString((String)"\u76ee\u6807\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurUpgradePlugin_17", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String selectFields = "id,billno,curr,loccurr";
        QFilter filter = null;
        Object currId = ((DynamicObject)curr).getPkValue();
        Object tarCurrId = null;
        if (isUpdate) {
            tarCurrId = ((DynamicObject)tarCurr).getPkValue();
            filter = new QFilter("curr", "=", currId);
        } else {
            filter = new QFilter("curr", "!=", currId);
        }
        for (String entityKey : entityKeys = this.getCurrEntityKeys()) {
            DynamicObject[] dataObjs = BusinessDataServiceHelper.load((String)entityKey, (String)selectFields, (QFilter[])new QFilter[]{filter});
            ArrayList<DynamicObject> upgradeData = new ArrayList<DynamicObject>(dataObjs.length);
            for (DynamicObject obj : dataObjs) {
                if (isUpdate) {
                    obj.set("curr", tarCurrId);
                    obj.set("loccurr", tarCurrId);
                } else {
                    obj.set("curr", currId);
                    obj.set("loccurr", currId);
                }
                upgradeData.add(obj);
            }
            SaveServiceHelper.save((DynamicObject[])upgradeData.toArray(new DynamicObject[0]));
        }
        view.showMessage(ResManager.loadKDString((String)"\u5e01\u79cd\u5347\u7ea7\u6210\u529f\u3002", (String)"PurUpgradePlugin_18", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
    }

    private String[] getCurrEntityKeys() {
        String entityKeysObj = (String)this.getModel().getValue("entitykey");
        if (null != entityKeysObj && entityKeysObj.trim().length() > 0) {
            this.currEntityKeys = entityKeysObj.split(",");
        }
        return this.currEntityKeys;
    }

    private void updatePurOrderData() {
        int pageSize = 10000;
        String checkOrderKey = "pur_check";
        String orderKey = "pur_order";
        Object param = null;
        List countList = QueryServiceHelper.queryPrimaryKeys((String)checkOrderKey, (QFilter[])new QFilter[0], (String)"id", (int)Integer.MAX_VALUE);
        int count = 0;
        if (null != countList) {
            count = countList.size();
        }
        if (0 >= count) {
            return;
        }
        int totalPages = count / pageSize;
        if (count % pageSize != 0) {
            ++totalPages;
        }
        HashMap<String, Integer> dealPoMap = new HashMap<String, Integer>(10000);
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            DynamicObject[] orderList;
            String selectFields = "id,materialentry.pobillno, materialentry.poentryid, materialentry.inqty, materialentry.intaxamount";
            log.info("updatePurOrderData \u52a0\u8f7d\u5bf9\u8d26\u5355\u6570\u636e\uff0c\u9875\u5e8f\u53f7\uff1a" + pageIndex);
            DynamicObject[] cols = BusinessDataServiceHelper.load((String)checkOrderKey, (String)selectFields, (QFilter[])new QFilter[0], (String)"id", (int)pageIndex, (int)pageSize);
            ArrayList<String> poBillList = new ArrayList<String>(10000);
            HashMap<String, ArrayList> checkMap = new HashMap<String, ArrayList>(10000);
            for (DynamicObject col : cols) {
                DynamicObjectCollection entrys = col.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : entrys) {
                    if (StringUtil.isNotEmpty((CharSequence)entry.getString("pobillno")) && !poBillList.contains(entry.getString("pobillno"))) {
                        poBillList.add(entry.getString("pobillno"));
                    }
                    if (!StringUtil.isNotEmpty((CharSequence)entry.getString("poentryid"))) continue;
                    ArrayList tempList = new ArrayList(1024);
                    if (checkMap.containsKey(entry.getString("poentryid"))) {
                        tempList = (ArrayList)checkMap.get(entry.getString("poentryid"));
                    }
                    tempList.add(entry);
                    checkMap.put(entry.getString("poentryid"), tempList);
                }
            }
            QFilter prodfilter = new QFilter("billno", "in", poBillList);
            for (DynamicObject poBill : orderList = BusinessDataServiceHelper.load((String)orderKey, (String)"id,billno,materialentry.id,materialentry.poentryid,materialentry.payableqty,materialentry.payableamt", (QFilter[])new QFilter[]{prodfilter})) {
                DynamicObjectCollection entrys = poBill.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : entrys) {
                    BigDecimal sumPayableQty = BigDecimal.ZERO;
                    BigDecimal sumPayableAmt = BigDecimal.ZERO;
                    if (dealPoMap.containsKey(entry.getString("poentryid"))) {
                        sumPayableQty = entry.getBigDecimal("payableqty");
                        sumPayableAmt = entry.getBigDecimal("payableamt");
                    } else {
                        dealPoMap.put(entry.getString("poentryid"), 1);
                    }
                    ArrayList checkDOList = (ArrayList)checkMap.get(entry.getString("poentryid"));
                    if (null != checkDOList) {
                        for (DynamicObject checkDO : checkDOList) {
                            sumPayableQty = sumPayableQty.add(checkDO.getBigDecimal("inqty"));
                            sumPayableAmt = sumPayableAmt.add(checkDO.getBigDecimal("intaxamount"));
                        }
                    }
                    entry.set("payableqty", (Object)sumPayableQty);
                    entry.set("payableamt", (Object)sumPayableAmt);
                }
            }
            if (orderList.length <= 0) continue;
            SaveServiceHelper.save((DynamicObject[])orderList);
            log.info("auto save poBillOrder success, pageIndex:" + pageIndex);
        }
        IFormView view = this.getView();
        view.showMessage(ResManager.loadKDString((String)"\u7d2f\u8ba1\u5bf9\u8d26\u6570\u91cf\uff0c\u91d1\u989d\u5347\u7ea7\u6210\u529f\u3002", (String)"PurUpgradePlugin_21", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
    }

    public void updatesrcprojectdata(String dbKey, List<String> filedList, String idFiledName, String srcTableName, String tarTablename, String language) {
        int pageSize = 2000;
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select ").append(idFiledName);
        for (String string : filedList) {
            selectSql.append(", ").append(string);
        }
        selectSql.append(", fcurrentnode");
        selectSql.append(" from  ").append(srcTableName);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(tarTablename).append(" set ").append(idFiledName).append(" = ? ");
        for (String filed : filedList) {
            updateSql.append(", ").append(filed).append(" = ? ");
        }
        updateSql.append(" where  ").append(idFiledName).append(" = ? ").append("and flocaleid = '").append(language).append("'");
        String string = "select fid,fname from t_pds_biznode_l where flocaleid = '" + language + "' ";
        HashMap<Long, String> NodeName = new HashMap<Long, String>(1024);
        try (DataSet tmp = this.getDataSet(dbKey, string);){
            while (tmp.hasNext()) {
                Row row = tmp.next();
                long id = row.getLong(idFiledName);
                String Name = row.getString("fname");
                NodeName.put(id, Name);
            }
        }
        var13_15 = null;
        try (DataSet srcDs = this.getDataSet(dbKey, selectSql.toString());){
            ArrayList<Object[]> allParamsList = new ArrayList<Object[]>(2048);
            while (srcDs.hasNext()) {
                Row row = srcDs.next();
                Long nodeId = row.getLong("fcurrentnode");
                if (nodeId == 0L || !NodeName.containsKey(nodeId)) continue;
                ArrayList<Object> paramsList = new ArrayList<Object>(filedList.size() + 2);
                paramsList.add(row.get(idFiledName));
                String nodeName = (String)NodeName.get(nodeId);
                paramsList.add(nodeName);
                paramsList.add(row.get(idFiledName));
                allParamsList.add(paramsList.toArray());
                if (allParamsList.size() <= pageSize) continue;
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
                allParamsList.clear();
            }
            if (allParamsList.size() > 0) {
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
            }
        }
        catch (Throwable throwable) {
            var13_15 = throwable;
            throw throwable;
        }
    }

    public void insertData(String dbKey, String billname, String idFiledName, String srcTableName, String tarTablename, String language) {
        int pageSize = 2000;
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select ").append(idFiledName);
        selectSql.append(" from  ").append(srcTableName);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("insert ").append(tarTablename).append(" ( ").append(idFiledName);
        updateSql.append(", FPKID ,FLOCALEID ");
        updateSql.append(" )");
        updateSql.append(" values ( ?,?,? ");
        updateSql.append(" )");
        String selectFromTarSql = "select " + idFiledName + " from  " + tarTablename + " where flocaleid = '" + language + "'";
        HashSet<Long> tarIds = new HashSet<Long>(1024);
        try (DataSet tmp = this.getDataSet(dbKey, selectFromTarSql);){
            while (tmp.hasNext()) {
                Row row = tmp.next();
                long id = row.getLong(idFiledName);
                tarIds.add(id);
            }
        }
        var13_13 = null;
        try (DataSet srcDs = this.getDataSet(dbKey, selectSql.toString());){
            int count = srcDs.copy().count(idFiledName, true);
            ORM orm = ORM.create();
            String[] ids = orm.genStringIds(billname, count);
            ArrayList<Object[]> allParamsList = new ArrayList<Object[]>(2048);
            int i = 0;
            while (srcDs.hasNext()) {
                Row row = srcDs.next();
                ArrayList<Object> paramsList = new ArrayList<Object>(3);
                long id = (Long)row.get(idFiledName);
                if (tarIds.contains(id)) continue;
                paramsList.add(id);
                paramsList.add(ids[i]);
                ++i;
                paramsList.add(language);
                allParamsList.add(paramsList.toArray());
                if (allParamsList.size() <= pageSize) continue;
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
                allParamsList.clear();
            }
            if (allParamsList.size() > 0) {
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
            }
        }
        catch (Throwable throwable) {
            var13_13 = throwable;
            throw throwable;
        }
    }

    private void updateBatch(String dbKey, String updateSql, List<Object[]> paramsList) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, paramsList);
    }

    private DataSet getDataSet(String dbKey, String sql) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        return DB.queryDataSet((String)RequestContext.get().getTraceId(), (DBRoute)dbRoute, (String)sql);
    }
}

