/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.ParamUtil;

public class PbdMallGoodsStatusSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("mallstatus");
        e.getFieldKeys().add("ecstatus");
        e.getFieldKeys().add("mallgoods.id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String ecProductOpStr = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"ec_product_op");
        boolean ecProductOp = Boolean.parseBoolean(ecProductOpStr);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        HashMap<Long, String> goodsId2StatusMap = new HashMap<Long, String>(dynamicObjects.length);
        HashSet<Object> goodsIdSet = new HashSet<Object>(dynamicObjects.length);
        for (DynamicObject bill : dynamicObjects) {
            goodsIdSet.add(bill.get("mallgoods.id"));
        }
        QFilter qFilter = new QFilter("entryentity.goods.id", "in", goodsIdSet);
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        if (ecProductOp) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pmm_ecprodaudit", (String)"entryentity.goods.id,biztype,auditdate", (QFilter[])qFilter.and(billstatusFilter).toArray(), (String)"auditdate");){
                for (Row row : ds) {
                    if ("1".equals(row.getString("biztype"))) {
                        goodsId2StatusMap.put(row.getLong("entryentity.goods.id"), "1");
                    }
                    if (!"2".equals(row.getString("biztype"))) continue;
                    goodsId2StatusMap.put(row.getLong("entryentity.goods.id"), "0");
                }
            }
        }
        for (DynamicObject bill : dynamicObjects) {
            String ecstatus = bill.getString("ecstatus");
            if (ecProductOp) {
                if ("0".equals(ecstatus)) {
                    bill.set("mallstatus", (Object)ecstatus);
                    continue;
                }
                String latestMallstatus = goodsId2StatusMap.getOrDefault(bill.getLong("mallgoods.id"), "0");
                bill.set("mallstatus", (Object)latestMallstatus);
                continue;
            }
            bill.set("mallstatus", (Object)ecstatus);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] mallGoodsDyns;
        DynamicObject[] objs = e.getDataEntities();
        HashMap<Long, DynamicObject> goodsId2StatusMap = new HashMap<Long, DynamicObject>(objs.length << 2);
        for (DynamicObject obj : objs) {
            goodsId2StatusMap.put(obj.getLong("mallgoods.id"), obj);
        }
        for (DynamicObject mallGoodsDyn : mallGoodsDyns = BusinessDataServiceHelper.load((String)"pbd_mallgoods", (String)"id, mallgoods.id,statusinfo", (QFilter[])new QFilter[]{new QFilter("id", "in", goodsId2StatusMap.keySet())})) {
            mallGoodsDyn.set("statusinfo", goodsId2StatusMap.get(mallGoodsDyn.getLong("id")));
        }
        SaveServiceHelper.save((DynamicObject[])mallGoodsDyns);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        DynamicObject[] objs = e.getDataEntities();
        HashMap<Long, String> goodsStatusMap = new HashMap<Long, String>(16);
        for (DynamicObject obj : objs) {
            goodsIds.add(obj.getLong("mallgoods.id"));
            goodsStatusMap.put(obj.getLong("mallgoods.id"), obj.getString("mallstatus"));
        }
        if (goodsIds.size() > 0) {
            DynamicObject[] pmm_goodsrulelogs;
            QFilter qFilter = new QFilter("goodsid", "in", goodsIds);
            QFilter dealStatusQFilter = new QFilter("dealstatus", "=", (Object)"A");
            qFilter.and(dealStatusQFilter);
            for (DynamicObject info : pmm_goodsrulelogs = BusinessDataServiceHelper.load((String)"pmm_goodsrulelog", (String)"remark,result,goodsid,dealstatus,id", (QFilter[])qFilter.toArray())) {
                long goodsid = info.getLong("goodsid");
                if (!goodsIds.contains(goodsid)) continue;
                info.set("dealstatus", (Object)"C");
                String bizType = (String)goodsStatusMap.get(goodsid);
                String msg = ResManager.loadKDString((String)"\u56e0\u7535\u5546\u7aef\u4e0b\u67b6\u5546\u54c1\uff0c\u4f5c\u5e9f\u76d1\u63a7\u65e5\u5fd7", (String)"PbdMallGoodsStatusSaveOp_0", (String)"scm-pbd-opplugin", (Object[])new Object[0]);
                if ("1".equals(bizType)) {
                    msg = ResManager.loadKDString((String)"\u56e0\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u8c03\u6574\uff0c\u672a\u8fbe\u5230\u9608\u503c/\u751f\u6210\u65b0\u7684\u76d1\u63a7\u65e5\u5fd7\uff0c\u4f5c\u5e9f\u76d1\u63a7\u65e5\u5fd7", (String)"PbdMallGoodsStatusSaveOp_1", (String)"scm-pbd-opplugin", (Object[])new Object[0]);
                }
                info.set("remark", (Object)msg);
            }
            if (pmm_goodsrulelogs.length > 0) {
                SaveServiceHelper.save((DynamicObject[])pmm_goodsrulelogs);
            }
        }
    }
}

