/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.costdetail;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCostDetailUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class PdsCostDetailCopyCompData
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.copyCompData(context);
    }

    protected void copyCompData(ExtPluginContext context) {
        long billId = PdsCostDetailUtils.getCostDetailBillId((String)context.getView().getParentView().getParentView().getEntityId(), (String)context.getView().getEntityId(), (DynamicObject)context.getView().getModel().getDataEntity().getDynamicObject("purlist"));
        long templateId = context.getView().getModel().getDataEntity().getLong("costdetailtpl.id");
        if (templateId == 0L && billId == 0L) {
            return;
        }
        boolean isSucced = false;
        if (billId > 0L) {
            isSucced = this.copyCompData(context.getView().getModel().getDataEntity(true), "src_costdetail", billId);
        }
        if (!isSucced) {
            isSucced = this.copyCompData(context.getView().getModel().getDataEntity(true), "pds_costdetailtpl", templateId);
        }
        if (isSucced) {
            PdsCommonUtils.saveDynamicObjects((DynamicObject)context.getView().getModel().getDataEntity(true));
            context.getView().invokeOperation("refresh");
        }
    }

    protected boolean copyCompData(DynamicObject billObj, String tplEntityId, long templateId) {
        boolean isChanged = false;
        if (!QueryServiceHelper.exists((String)tplEntityId, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)})) {
            return isChanged;
        }
        DynamicObject tplObj = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)tplEntityId);
        List compKeys = TemplateUtil.getCompKeyList((DynamicObject)billObj);
        if (null == compKeys || compKeys.size() == 0) {
            return isChanged;
        }
        long preTemplateId = billObj.getLong("template.id");
        ArrayList<DynamicObject> newCompObjList = new ArrayList<DynamicObject>(compKeys.size());
        for (String compKey : compKeys) {
            DynamicObject tplCompObj;
            DynamicObject preCompObj = TemplateUtil.getCompData((DynamicObject)billObj, (String)compKey);
            if (templateId == preTemplateId && null != preCompObj || null == (tplCompObj = TemplateUtil.getCompData((DynamicObject)tplObj, (String)compKey))) continue;
            if (null != preCompObj) {
                QFilter qfilter = new QFilter("id", "=", (Object)preCompObj.getLong("id"));
                DeleteServiceHelper.delete((String)preCompObj.getDataEntityType().getName(), (QFilter[])qfilter.toArray());
            }
            DynamicObject newCompObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)tplCompObj, (boolean)true, (boolean)true);
            PdsCommonUtils.setPrimaryKey((DynamicObject)newCompObj);
            newCompObj.set("parentid", billObj.getPkValue());
            newCompObj.set("pentitykey", (Object)billObj.getDataEntityType().getName());
            if ("tnd_costdetail".equals(billObj.getDataEntityType().getName())) {
                newCompObj.set("origin", (Object)"2");
            } else {
                newCompObj.set("origin", (Object)"1");
            }
            if ("3".equals(newCompObj.getString("type"))) {
                PdsCostDetailUtils.setParentEntryId((DynamicObject)tplCompObj, (DynamicObject)newCompObj);
            }
            newCompObjList.add(newCompObj);
            isChanged = true;
        }
        if (isChanged) {
            PdsCommonUtils.saveDynamicObjects(newCompObjList);
        }
        return isChanged;
    }
}

