/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.edit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.MetaDataUtil;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.common.util.excel.ExcelUtil;
import kd.scm.pds.common.entity.DataImportSheetHandler;
import kd.scm.pds.common.util.PdsMetadataUtil;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class AbstractBillImportEdit
extends AbstractFormPlugin
implements UploadListener {
    protected static final String IMPORTDATA = "importdata";
    protected static final String EXPORT_DATA = "exportdata";
    protected static final String EXPORT_TPL = "exporttpl";
    public static final String UPLOAD = "upload";
    public Map<Integer, Map<Integer, String>> dataRows;
    protected Map<String, String> bdProMap;
    protected Map<String, Map<String, String>> assistantProMap;
    protected static final String ASSISTANT_TYPE = "assistant_type";
    protected static final String ASSISTANT_KEY = "assistant_key";
    public Map<String, Integer> proScaleMap = new HashMap<String, Integer>(8);
    public Map<Integer, Map<String, Object>> highLevelProMap = new HashMap<Integer, Map<String, Object>>(8);

    public void registerListener(EventObject e) {
        Toolbar advToolBar;
        super.registerListener(e);
        Toolbar toolBar = (Toolbar)this.getControl("toolbarap");
        if (null != toolBar) {
            toolBar.addUploadListener((UploadListener)this);
        }
        if (null != (advToolBar = (Toolbar)this.getControl("advcontoolbarap"))) {
            advToolBar.addUploadListener((UploadListener)this);
            advToolBar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        switch (itemKey) {
            case "exportdata": {
                view.showLoading(new LocaleString(this.getLoadingTitle(itemKey)));
                this.exportData();
                view.hideLoading();
                break;
            }
            case "exporttpl": {
                view.showLoading(new LocaleString(this.getLoadingTitle(itemKey)));
                this.exportTpl();
                view.hideLoading();
                break;
            }
        }
    }

    public String getLoadingTitle(String opKey) {
        String loadingTitle = "";
        switch (opKey) {
            case "upload": {
                loadingTitle = ResManager.loadKDString((String)"\u5bfc\u5165\u4e2d...", (String)"AbstractBillImportEdit_31", (String)"scm-pds-common", (Object[])new Object[0]);
                break;
            }
            case "exportdata": 
            case "exporttpl": {
                loadingTitle = ResManager.loadKDString((String)"\u5bfc\u51fa\u4e2d...", (String)"AbstractBillImportEdit_32", (String)"scm-pds-common", (Object[])new Object[0]);
                break;
            }
        }
        return loadingTitle;
    }

    protected void exportData() {
        this.export(true);
    }

    protected void exportTpl() {
        this.export(false);
    }

    protected void export(boolean includeData) {
        IFormView view = this.getView();
        try {
            ExcelDataEntity excelDataEntity = new ExcelDataEntity((Workbook)new XSSFWorkbook());
            excelDataEntity.createSheet();
            IDataModel model = this.getModel();
            String entityKey = model.getDataEntityType().getName();
            String fileName = "";
            fileName = includeData ? this.getExportDataTitile() : this.getExportTplTitle();
            excelDataEntity.setFileName(fileName + ".xlsx");
            excelDataEntity.setEntityKey(entityKey);
            excelDataEntity.setEntryKey(this.getEntryKey());
            excelDataEntity.setAddColumnKeyToHeader(true);
            this.setColumn(excelDataEntity);
            this.setExcelHeader(excelDataEntity, model);
            this.setCellFormat(excelDataEntity);
            if (includeData) {
                this.setEexclBody(excelDataEntity);
            } else {
                this.setEexclBodyCommand(excelDataEntity);
            }
            ExcelUtil.exportExcel((IFormView)view, (ExcelDataEntity)excelDataEntity);
        }
        catch (IOException e) {
            view.showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"AbstractBillImportEdit_0", (String)"scm-pds-common", (Object[])new Object[0]));
        }
    }

    protected void setEexclBodyCommand(ExcelDataEntity excelDataEntity) throws IOException {
    }

    protected void setColumn(ExcelDataEntity excelDataEntity) {
        String entityKey = excelDataEntity.getEntityKey();
        if (null == entityKey) {
            throw new KDBizException(ResManager.loadKDString((String)"entityKey\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBillImportEdit_1", (String)"scm-pds-common", (Object[])new Object[0]));
        }
        String entryKey = excelDataEntity.getEntryKey();
        if (null == entryKey) {
            throw new KDBizException(ResManager.loadKDString((String)"entryKey\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBillImportEdit_2", (String)"scm-pds-common", (Object[])new Object[0]));
        }
        List columnList = MetaDataUtil.getColumnKey((String)entityKey, (String)entryKey);
        excelDataEntity.setColumnKeyList(columnList);
        this.removeUnValidColumnKey(excelDataEntity);
    }

    protected void removeUnValidColumnKey(ExcelDataEntity excelData) {
        IDataModel model = this.getModel();
        List<String> excludeUnvalidColumnList = this.getExcludeUnvalidColumnList();
        ArrayList<String> needRemoveColumn = new ArrayList<String>();
        for (int i = 0; i < excelData.getColumnKeyList().size(); ++i) {
            String column = (String)excelData.getColumnKeyList().get(i);
            DynamicProperty pro = (DynamicProperty)model.getDataEntityType().findProperty(column);
            if (null != pro || excludeUnvalidColumnList.contains(column)) continue;
            needRemoveColumn.add(column);
        }
        if (needRemoveColumn.size() == 0) {
            return;
        }
        List<Object> newColumnKeyList = new ArrayList(excelData.getColumnKeyList());
        newColumnKeyList.removeAll(needRemoveColumn);
        newColumnKeyList = newColumnKeyList.stream().distinct().collect(Collectors.toList());
        excelData.setColumnKeyList(newColumnKeyList);
    }

    public List<String> getExcludeUnvalidColumnList() {
        ArrayList<String> excludeUnvalidColumnList = new ArrayList<String>();
        return excludeUnvalidColumnList;
    }

    protected void setExcelHeader(ExcelDataEntity excelDataEntity, IDataModel model) throws IOException {
        ArrayList<String> columnTitleList = new ArrayList<String>();
        Map<String, String> proMap = PdsMetadataUtil.getProMap(excelDataEntity.getEntityKey(), false);
        proMap.putAll(this.getCustomColumnMap());
        ArrayList<Integer> mustInputIndexList = new ArrayList<Integer>();
        Map<String, String> mustInputProMap = this.getMustInputProMap();
        Integer rowCount = 0;
        for (int i = 0; i < excelDataEntity.getColumnKeyList().size(); ++i) {
            String column = (String)excelDataEntity.getColumnKeyList().get(i);
            String proName = proMap.get(excelDataEntity.getEntryKey() + "." + column);
            if (null == proName) {
                proName = proMap.getOrDefault(column, ResManager.loadKDString((String)".\u672a\u5b9a\u4e49", (String)"AbstractBillImportEdit_3", (String)"scm-pds-common", (Object[])new Object[0]));
            }
            if (null == proName) continue;
            String[] proNames = proName.split("\\.");
            StringBuilder headTitileSb = new StringBuilder();
            if (proNames.length > 1) {
                headTitileSb.append(proNames[1]);
            } else {
                headTitileSb.append(proName);
            }
            String proVal = mustInputProMap.get(excelDataEntity.getEntryKey() + "." + column);
            if (null == proVal) {
                proVal = mustInputProMap.get(column);
            }
            if (null != proVal) {
                headTitileSb.append('*');
                mustInputIndexList.add(rowCount);
            }
            if (excelDataEntity.isAddColumnKeyToHeader()) {
                headTitileSb.append("${");
                headTitileSb.append(column);
                headTitileSb.append('}');
            }
            columnTitleList.add(headTitileSb.toString());
            Integer n = rowCount;
            Integer n2 = rowCount = Integer.valueOf(rowCount + 1);
        }
        this.setExcelHeaderCustom(excelDataEntity, columnTitleList);
        this.setColumnTitleColor(excelDataEntity, mustInputIndexList);
    }

    public void setExcelHeaderCustom(ExcelDataEntity excelDataEntity, List<String> columnTitleList) throws IOException {
        int titleRowIndex = this.getTitleIndex();
        ArrayList<String> header = new ArrayList<String>();
        header.addAll(columnTitleList);
        excelDataEntity.createRow(0, titleRowIndex);
        excelDataEntity.setRowValue(0, header, titleRowIndex);
        for (int i = 0; i < columnTitleList.size(); ++i) {
            excelDataEntity.setStyle(0, titleRowIndex, i, excelDataEntity.makeStyle(1));
        }
    }

    protected void setColumnTitleColor(ExcelDataEntity excelDataEntity, List<Integer> mustInputIndexList) {
        CellStyle style = this.getCellStyle(excelDataEntity);
        int startRow = this.getTitleIndex();
        for (int colIndex : mustInputIndexList) {
            if (colIndex < 0) continue;
            try {
                excelDataEntity.setStyle(0, startRow, colIndex, style, 4000);
            }
            catch (IOException e) {
                BizLog.log((String)e.getMessage());
            }
        }
    }

    public Map<String, String> getCustomColumnMap() {
        HashMap<String, String> columnMap = new HashMap<String, String>(2);
        return columnMap;
    }

    protected CellStyle getCellStyle(ExcelDataEntity excelDataEntity) {
        CellStyle style = excelDataEntity.getWorkbook().createCellStyle();
        style.setFillForegroundColor(IndexedColors.YELLOW.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.GENERAL);
        Font font = excelDataEntity.getWorkbook().createFont();
        font.setColor(IndexedColors.RED.getIndex());
        style.setFont(font);
        return style;
    }

    protected Map<String, String> getMustInputProMap() {
        return new HashMap<String, String>(1);
    }

    protected void setCellFormat(ExcelDataEntity excelDataEntity) {
        XSSFWorkbook wb = (XSSFWorkbook)excelDataEntity.getWorkbook();
        XSSFSheet sheet = wb.getSheet("Sheet0");
        HashMap<String, String> commentMap = new HashMap<String, String>(4);
        this.addComment(commentMap);
        HashMap<String, List<String>> cellRangeListMap = new HashMap<String, List<String>>(4);
        this.addCellRangeList(cellRangeListMap);
        int titleIndex = this.getTitleIndex();
        List columnKeyList = excelDataEntity.getColumnKeyList();
        for (int i = 0; i < columnKeyList.size(); ++i) {
            List cellRangeList;
            String columnKey = (String)columnKeyList.get(i);
            String commentStr = (String)commentMap.get(columnKey);
            if (null != commentStr) {
                XSSFClientAnchor anChor = null;
                anChor = commentStr.length() > 100 ? new XSSFClientAnchor(0, 0, 0, 0, 1, 1, 5, 6) : (commentStr.length() > 50 ? new XSSFClientAnchor(0, 0, 0, 0, 2, 2, 5, 6) : new XSSFClientAnchor(0, 0, 0, 0, 3, 3, 5, 6));
                XSSFDrawing draw = sheet.createDrawingPatriarch();
                XSSFComment comment = draw.createCellComment((ClientAnchor)anChor);
                comment.setString((RichTextString)new XSSFRichTextString(commentStr));
                sheet.getRow(titleIndex).getCell(i).setCellComment((Comment)comment);
            }
            if (null == (cellRangeList = (List)cellRangeListMap.get(columnKey)) || cellRangeList.size() <= 0) continue;
            CellRangeAddressList regions = new CellRangeAddressList(1, 65535, i, i);
            DataValidationHelper helper = sheet.getDataValidationHelper();
            DataValidationConstraint constraint = helper.createExplicitListConstraint(cellRangeList.toArray(new String[0]));
            XSSFDataValidation validation = (XSSFDataValidation)helper.createValidation(constraint, regions);
            sheet.addValidationData((DataValidation)validation);
        }
    }

    public int getTitleIndex() {
        int startImportIndex = this.getStratImportIndex();
        return startImportIndex > 0 ? startImportIndex - 1 : 0;
    }

    protected void addComment(Map<String, String> commentMap) {
    }

    protected void addCellRangeList(Map<String, List<String>> cellRangeListMap) {
    }

    protected String getExportTplTitle() {
        String entityKey = this.getModel().getDataEntityType().getName();
        String fileName = ResManager.loadKDString((String)"\u6a21\u677f", (String)"AbstractBillImportEdit_4", (String)"scm-pds-common", (Object[])new Object[0]);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityKey);
        if (entityKey != null || null != type) {
            fileName = String.format(ResManager.loadKDString((String)"%1$s\u6a21\u677f", (String)"AbstractBillImportEdit_5", (String)"scm-pds-common", (Object[])new Object[0]), type.getDisplayName().toString());
        }
        return fileName;
    }

    protected String getExportDataTitile() {
        String entityKey = this.getModel().getDataEntityType().getName();
        String fileName = "";
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityKey);
        if (entityKey != null || null != type) {
            fileName = type.getDisplayName().toString() + DateUtil.date2str((Date)new Date(), (String)"yyyyMMddHHmmss");
        }
        return fileName;
    }

    protected void setEexclBody(ExcelDataEntity excelDataEntity) throws IOException {
        int rowCount = this.getModel().getEntryRowCount(this.getEntryKey());
        List columnKeyList = excelDataEntity.getColumnKeyList();
        int startRow = this.getTitleIndex();
        for (int i = 0; i < rowCount; ++i) {
            List<Object> rowData = this.getRowDataByIndex(columnKeyList, i);
            int rowIndex = startRow + i + 1;
            excelDataEntity.createRow(0, rowIndex);
            this.setRowValue(excelDataEntity, 0, rowIndex, rowData);
        }
    }

    public boolean setRowValue(ExcelDataEntity excelDataEntity, int sheetIx, int rowIndex, List<Object> rowData) throws IOException {
        Sheet sheet = excelDataEntity.getWorkbook().getSheetAt(sheetIx);
        CellStyle cellStyle = excelDataEntity.getWorkbook().createCellStyle();
        DataFormat dataFormat = excelDataEntity.getWorkbook().createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("@"));
        Row row = sheet.getRow(rowIndex);
        for (int i = 0; i < rowData.size(); ++i) {
            Object data = rowData.get(i);
            if (data instanceof String) {
                row.createCell(i).setCellValue(String.valueOf(data));
                row.getCell(i).setCellStyle(cellStyle);
                continue;
            }
            if (data instanceof Double) {
                row.createCell(i).setCellValue(((Double)data).doubleValue());
                continue;
            }
            if (data instanceof BigDecimal) {
                row.createCell(i).setCellValue(((BigDecimal)data).doubleValue());
                continue;
            }
            if (data instanceof Calendar) {
                row.createCell(i).setCellValue((Calendar)data);
                continue;
            }
            if (data instanceof Date) {
                row.createCell(i).setCellValue((Date)data);
                continue;
            }
            if (data instanceof Boolean) {
                row.createCell(i).setCellValue(((Boolean)data).booleanValue());
                continue;
            }
            row.createCell(i).setCellValue(String.valueOf(data));
            row.getCell(i).setCellStyle(cellStyle);
        }
        return true;
    }

    public List<Object> getRowDataByIndex(List<String> columnKeyList, int i) {
        ArrayList<Object> rowData = new ArrayList<Object>(columnKeyList.size());
        DynamicObject col = this.getModel().getEntryRowEntity(this.getEntryKey(), i);
        for (String column : columnKeyList) {
            Object val = this.getRowVal(col, column, i);
            rowData.add(val);
        }
        return rowData;
    }

    public Object getRowVal(DynamicObject col, String column, int i) {
        IDataEntityProperty pro;
        Object val = "";
        Object columnVal = this.getRowValByColumn(col, column, i);
        val = columnVal == null ? "" : (columnVal instanceof DynamicObject ? ((DynamicObject)columnVal).get("name") : (columnVal instanceof BigDecimal ? (((BigDecimal)columnVal).compareTo(BigDecimal.ZERO) == 0 ? "" : ((BigDecimal)columnVal).setScale(this.getScale(col, column, i), RoundingMode.HALF_UP)) : (columnVal instanceof Boolean ? (((Boolean)columnVal).booleanValue() ? ResManager.loadKDString((String)"\u662f", (String)"AbstractBillImportEdit_18", (String)"scm-pds-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AbstractBillImportEdit_19", (String)"scm-pds-common", (Object[])new Object[0])) : (columnVal instanceof Date ? ((pro = this.findPro(column)) instanceof DateTimeProp ? ((DateTimeProp)pro).getDateFormat().format(columnVal) : DateUtil.date2str((Date)((Date)columnVal), (String)"yyyy-MM-dd")) : columnVal))));
        return val;
    }

    public Object getRowValByColumn(DynamicObject col, String column, int i) {
        IDataEntityProperty pro = this.findPro(column);
        Object columnVal = "";
        if (null == pro) {
            Control control = this.getControl(column);
            if (null != control && control instanceof BasedataPropEdit) {
                BasedataPropEdit bdPro = (BasedataPropEdit)control;
                String refBdPro = bdPro.getRefBasedataProp();
                String refBdDisPro = bdPro.getRefDisplayProp();
                columnVal = col.get(refBdPro + "." + refBdDisPro);
            }
        } else {
            columnVal = col.get(column);
        }
        return columnVal;
    }

    public int getScale(DynamicObject col, String column, int rowIndex) {
        DynamicObject currency;
        Integer cacheScale = this.proScaleMap.get(column);
        if (null != cacheScale) {
            return cacheScale;
        }
        int scale = 6;
        IDataEntityProperty pro = this.findPro(column);
        if (pro instanceof PriceProp) {
            DynamicObject currency2 = this.getCurrency(rowIndex);
            if (Objects.nonNull(currency2)) {
                scale = currency2.getInt("priceprecision");
            }
        } else if (pro instanceof AmountProp && Objects.nonNull(currency = this.getCurrency(rowIndex))) {
            scale = currency.getInt("amtprecision");
        }
        this.proScaleMap.put(column, scale);
        return scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(UploadEvent evt) {
        String url = (String)evt.getUrls()[0];
        if (null == url) {
            return;
        }
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        fileService.download(url, (OutputStream)outStream, "httpclient");
        ByteArrayInputStream input = new ByteArrayInputStream(outStream.toByteArray());
        ExcelReader reader = new ExcelReader();
        DataImportSheetHandler handler = new DataImportSheetHandler();
        IFormView view = this.getView();
        try {
            reader.read((InputStream)input, (SheetHandler)handler);
        }
        catch (Exception e) {
            BizLog.log((String)String.format(ResManager.loadKDString((String)"\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a%1$s", (String)"AbstractBillImportEdit_30", (String)"scm-pds-common", (Object[])new Object[0]), e.getMessage()));
        }
        try {
            view.showLoading(new LocaleString(this.getLoadingTitle(UPLOAD)));
            this.importData(handler);
        }
        catch (Exception e) {
            BizLog.log((String)String.format("import error\uff1a%1$s", e.getMessage()));
            view.showMessage("import fail\uff1a" + e.getMessage());
        }
        finally {
            view.hideLoading();
        }
    }

    protected void beforeImport() {
    }

    public void beforeBatchCreateNewEntry(TableValueSetter ts, int successCount) {
    }

    protected void afterImport() {
    }

    private void importData(DataImportSheetHandler handler) {
        int startImportRowIndex = this.getStratImportIndex();
        handler.setStartImportRowIndex(startImportRowIndex);
        List<String> uniqueColumnList = this.getUniqueColumnList();
        handler.setUniqueColumnList(uniqueColumnList);
        if (!this.validateImportData(handler)) {
            return;
        }
        this.dataRows = handler.getRows();
        this.beforeImport();
        StringBuilder msgSb = new StringBuilder();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        DynamicObject obj = this.getModel().getDataEntity();
        DynamicObjectCollection cols = obj.getDynamicObjectCollection(this.getEntryKey());
        DynamicObjectType objType = cols.getDynamicObjectType();
        this.bdProMap = AbstractBillImportEdit.getDynamicBdProperties((IDataEntityType)objType);
        this.assistantProMap = this.getAssistantProperties((IDataEntityType)objType);
        HashMap<String, DynamicObject> uniqueColumnColMap = new HashMap<String, DynamicObject>(8);
        HashMap<String, Integer> columnIndexMap = new HashMap<String, Integer>(8);
        this.groupEntryData(uniqueColumnColMap, columnIndexMap);
        EntryGrid entry = (EntryGrid)this.getControl(this.getEntryKey());
        int rowIndex = 0;
        int updateCount = 0;
        int successCount = 0;
        int failCount = 0;
        int titleIndex = this.getTitleIndex();
        int columSize = this.dataRows.get(titleIndex).size();
        Map<String, Object> highLevelProIndexMap = this.getHighLevelProIndexMap(handler, columSize);
        HashSet<String> importUniqueValSet = new HashSet<String>(8);
        for (Map.Entry<Integer, Map<Integer, String>> row : this.dataRows.entrySet()) {
            int i = row.getKey();
            if (i < startImportRowIndex || null == row.getValue() || row.getValue().size() == 0) continue;
            boolean isSuccess = true;
            boolean isUpdate = false;
            Integer updateRowIndex = null;
            String uniqueColumnVal = handler.getColumnVal(Integer.valueOf(i));
            if (this.isRepeat(importUniqueValSet, uniqueColumnVal, i)) {
                failCount = this.dataRows.size() - 1;
                successCount = 0;
                updateCount = 0;
                rowIndex = 0;
                msgSb.append(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u884c\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u64cd\u4f5c\uff0c\u91cd\u590d\u5b57\u6bb5\u5217\uff1a", (String)"AbstractBillImportEdit_28", (String)"scm-pds-common", (Object[])new Object[0])).append(uniqueColumnList.toString());
                msgSb.append('\n');
                break;
            }
            updateRowIndex = this.getUpdateRowIndex(columnIndexMap, uniqueColumnVal, i);
            if (null != updateRowIndex) {
                isUpdate = true;
                entry.selectRows(updateRowIndex.intValue(), true);
            } else if (!this.isAddNew()) {
                ++failCount;
                msgSb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u672a\u5339\u914d\u5230\u73b0\u6709\u7684\u5206\u5f55\u6570\u636e\uff0c\u65e0\u6cd5\u5f15\u5165\u3002", (String)"AbstractBillImportEdit_7", (String)"scm-pds-common", (Object[])new Object[0]), i + 1));
                msgSb.append('\n');
                continue;
            }
            Map<String, Object> highLevelProValMap = this.getHighLevelProValMap(this.dataRows, highLevelProIndexMap, i);
            LinkedHashMap<String, Object> importDataMap = new LinkedHashMap<String, Object>(16);
            for (int j = 0; j < columSize; ++j) {
                StringBuilder rowDetailMsg;
                String columnKey = handler.getColumnName(j);
                if (columnKey.length() == 0) continue;
                String valObj = row.getValue().get(j);
                String rowVal = String.valueOf(null == valObj ? "" : valObj);
                Object setVal = this.getVal(columnKey, i, rowVal, rowDetailMsg = new StringBuilder());
                if (this.validateDataByHighLevlePro(highLevelProValMap, setVal, columnKey)) {
                    isSuccess = true;
                } else if (rowDetailMsg.length() > 0) {
                    msgSb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s", (String)"AbstractBillImportEdit_8", (String)"scm-pds-common", (Object[])new Object[0]), this.getRowIndexForMessage(i), rowDetailMsg));
                    isSuccess = false;
                }
                if (null == setVal || !isSuccess) continue;
                importDataMap.put(columnKey, setVal);
            }
            StringBuilder rowMsg = new StringBuilder();
            if (isSuccess && !this.isImport(isUpdate, updateRowIndex, rowMsg, importDataMap)) {
                msgSb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s", (String)"AbstractBillImportEdit_8", (String)"scm-pds-common", (Object[])new Object[0]), this.getRowIndexForMessage(i), rowMsg));
                isSuccess = false;
            }
            if (isSuccess) {
                ++successCount;
                if (this.ignoreExeption(msgSb)) {
                    this.updateOrInsertRow(importDataMap, ts, null == updateRowIndex ? 0 : updateRowIndex, rowIndex, isUpdate);
                }
            } else {
                ++failCount;
            }
            if (isSuccess && !isUpdate) {
                ++rowIndex;
                continue;
            }
            if (!isSuccess || !isUpdate) continue;
            ++updateCount;
        }
        this.beforeBatchCreateNewEntry(ts, successCount);
        if (rowIndex > 0) {
            try {
                model.batchCreateNewEntryRow(this.getEntryKey(), ts);
            }
            catch (Exception e) {
                msgSb.append(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002message:%s", (String)"AbstractBillImportEdit_33", (String)"scm-pds-common", (Object[])new Object[0]), e.getMessage()));
                msgSb.append('\n');
                successCount = 0;
                failCount = ts.getCount();
            }
        }
        this.showMessage(msgSb, updateCount, successCount, failCount);
        this.afterImport();
    }

    public int getRowIndexForMessage(int index) {
        return index + 1;
    }

    public boolean ignoreExeption(StringBuilder msgSb) {
        return true;
    }

    public void updateOrInsertRow(Map<String, Object> importDataMap, TableValueSetter ts, int updateRowIndex, int rowIndex, boolean isUpdate) {
        IDataModel model = this.getModel();
        for (Map.Entry<String, Object> importDataMapEntry : importDataMap.entrySet()) {
            IDataEntityProperty pro = this.findPro(importDataMapEntry.getKey());
            if (null == pro) continue;
            if (isUpdate) {
                String valStr = String.valueOf(importDataMapEntry.getValue());
                if ((null != this.bdProMap.get(importDataMapEntry.getKey()) || null != this.assistantProMap.get(importDataMapEntry.getKey())) && Long.valueOf(valStr).intValue() == 0) {
                    model.setValue(importDataMapEntry.getKey(), null, updateRowIndex);
                    continue;
                }
                model.setValue(importDataMapEntry.getKey(), importDataMapEntry.getValue(), updateRowIndex);
                continue;
            }
            ts.set(importDataMapEntry.getKey(), importDataMapEntry.getValue(), rowIndex);
        }
        if (isUpdate) {
            this.afterImportOneRow(ts, updateRowIndex, isUpdate);
            this.afterImportOneRow(importDataMap, ts, updateRowIndex, isUpdate);
        } else {
            this.afterImportOneRow(ts, rowIndex, isUpdate);
            this.afterImportOneRow(importDataMap, ts, rowIndex, isUpdate);
        }
    }

    public boolean isRepeat(Set<String> importUniqueValSet, String uniqueColumnVal, int index) {
        return !importUniqueValSet.add(uniqueColumnVal) && !Objects.equals("null", uniqueColumnVal);
    }

    public Integer getUpdateRowIndex(Map<String, Integer> columnIndexMap, String uniqueColumnVal, int index) {
        return columnIndexMap.get(uniqueColumnVal);
    }

    public int getStratImportIndex() {
        return 1;
    }

    protected boolean isImport(boolean isUpdate, Integer updateRowIndex, StringBuilder rowMsg, Map<String, Object> importDataMap) {
        return true;
    }

    protected boolean validateImportData(DataImportSheetHandler handler) {
        int rowCount;
        IFormView view = this.getView();
        if (!handler.isTemplate()) {
            view.showMessage(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5bf9\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u6b63\u786e\u3002", (String)"AbstractBillImportEdit_10", (String)"scm-pds-common", (Object[])new Object[0]));
            return false;
        }
        List importColumnKeyList = handler.getImportColumnKeyList();
        ExcelDataEntity excelDataEntity = new ExcelDataEntity();
        IDataModel model = this.getModel();
        String entityKey = model.getDataEntityType().getName();
        excelDataEntity.setEntityKey(entityKey);
        excelDataEntity.setEntryKey(this.getEntryKey());
        this.setColumn(excelDataEntity);
        List realExportList = excelDataEntity.getColumnKeyList();
        if (importColumnKeyList.size() != realExportList.size() || !importColumnKeyList.containsAll(realExportList)) {
            view.showMessage(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5bf9\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u6b63\u786e\u3002", (String)"AbstractBillImportEdit_10", (String)"scm-pds-common", (Object[])new Object[0]));
            return false;
        }
        int importRowCount = handler.getRows().size();
        if (importRowCount <= handler.getStartImportRowIndex()) {
            view.showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u5bfc\u5165\u6587\u4ef6\u662f\u5426\u6b63\u786e\u3002", (String)"AbstractBillImportEdit_11", (String)"scm-pds-common", (Object[])new Object[0]));
            return false;
        }
        if (!this.isAddNew() && (rowCount = this.getModel().getEntryRowCount(this.getEntryKey())) != importRowCount - handler.getStartImportRowIndex()) {
            StringBuilder msgSb = new StringBuilder();
            msgSb.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u5165\u65b0\u589e\u5206\u5f55\uff0c\u53ea\u5141\u8bb8\u5bfc\u5165%1$s\u6761\u6570\u636e\u3002", (String)"AbstractBillImportEdit_12", (String)"scm-pds-common", (Object[])new Object[0]), rowCount));
            view.showMessage(msgSb.toString());
            return false;
        }
        return true;
    }

    protected boolean isAddNew() {
        return true;
    }

    protected Set<String> getHighLevelProSet() {
        HashSet<String> highLevelProSet = new HashSet<String>();
        return highLevelProSet;
    }

    protected Map<String, Object> getHighLevelProIndexMap(DataImportSheetHandler handler, int columSize) {
        HashMap<String, Object> highLevelProIndexMap = new HashMap<String, Object>(4);
        Set<String> highLevelProSet = this.getHighLevelProSet();
        if (highLevelProSet.size() == 0) {
            return highLevelProIndexMap;
        }
        for (int i = 0; i < columSize; ++i) {
            String columnKey = handler.getColumnName(i);
            if (!highLevelProSet.contains(columnKey)) continue;
            highLevelProIndexMap.put(columnKey, i);
        }
        return highLevelProIndexMap;
    }

    protected Map<String, Object> getHighLevelProValMap(Map<Integer, Map<Integer, String>> rows, Map<String, Object> highLevelProIndexMap, int rowIndex) {
        HashMap<String, Object> highLevelProValMap = new HashMap<String, Object>(4);
        Map<Integer, String> data = rows.get(rowIndex);
        if (null == data) {
            return highLevelProValMap;
        }
        for (Map.Entry<String, Object> highLevelProIndexMapEntry : highLevelProIndexMap.entrySet()) {
            int proIndex = Integer.parseInt(highLevelProIndexMapEntry.getValue().toString());
            String rowVal = String.valueOf(data.get(proIndex));
            StringBuilder rowMsg = new StringBuilder();
            Object proVal = this.getVal(highLevelProIndexMapEntry.getKey(), rowIndex, rowVal, rowMsg);
            highLevelProValMap.put(highLevelProIndexMapEntry.getKey(), proVal);
        }
        this.highLevelProMap.put(rowIndex, highLevelProValMap);
        return highLevelProValMap;
    }

    protected boolean validateDataByHighLevlePro(Map<String, Object> highLevelProValMap, Object setVal, String pro) {
        return false;
    }

    protected void afterImportOneRow(TableValueSetter ts, int rowIndex, boolean isUpdate) {
    }

    protected void afterImportOneRow(Map<String, Object> importDataMap, TableValueSetter ts, int rowIndex, boolean isUpdate) {
    }

    private void showMessage(StringBuilder msgSb, int updateCount, int successCount, int failCount) {
        IFormView view = this.getView();
        if (!this.ignoreExeption(msgSb)) {
            updateCount = 0;
            successCount = 0;
        }
        StringBuilder titileSb = new StringBuilder();
        titileSb.append(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u65b0\u589e\u6210\u529f%1$s\u6761\uff0c\u66f4\u65b0\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"AbstractBillImportEdit_29", (String)"scm-pds-common", (Object[])new Object[0]), successCount == 0 ? successCount : successCount - updateCount, updateCount, failCount));
        if (msgSb.length() > 0) {
            view.showMessage(titileSb.toString(), msgSb.toString(), MessageTypes.Default);
        } else {
            view.showMessage(titileSb.toString());
        }
    }

    protected Object getVal(String column, int index, Object val, StringBuilder msg) {
        String newStr;
        String str;
        boolean isBd = false;
        Object returnVal = val;
        IDataEntityProperty pro = this.findPro(column);
        if (pro instanceof BasedataProp) {
            isBd = true;
            if (pro instanceof AssistantProp) {
                Map<String, String> assistantMap = this.assistantProMap.get(column);
                if (null == assistantMap) {
                    return null;
                }
                if (StringUtils.isEmpty((String)String.valueOf(val))) {
                    returnVal = null;
                } else {
                    String assistantType = assistantMap.get(ASSISTANT_TYPE);
                    String assistantKey = assistantMap.get(ASSISTANT_KEY);
                    returnVal = this.getAssistantBdVal(column, assistantKey, Long.parseLong(assistantType), val);
                }
            } else {
                String bdKey = this.bdProMap.get(column);
                if (null == bdKey) {
                    return null;
                }
                returnVal = StringUtils.isEmpty((String)String.valueOf(val)) ? null : this.getBdVal(column, bdKey, val);
            }
            if ("0".equals(String.valueOf(returnVal))) {
                msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u7cfb\u7edf\u4e2d\u6ca1\u6709\u503c\u4e3a'%2$s'\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"AbstractBillImportEdit_17", (String)"scm-pds-common", (Object[])new Object[0]), pro.getDisplayName(), val));
                msg.append('\n');
            }
        } else if (pro instanceof BooleanProp) {
            if (ResManager.loadKDString((String)"\u662f", (String)"AbstractBillImportEdit_18", (String)"scm-pds-common", (Object[])new Object[0]).equals(String.valueOf(val))) {
                returnVal = Boolean.TRUE;
            } else if (ResManager.loadKDString((String)"\u5426", (String)"AbstractBillImportEdit_19", (String)"scm-pds-common", (Object[])new Object[0]).equals(String.valueOf(val))) {
                returnVal = Boolean.FALSE;
            } else {
                msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u662f\u5e03\u5c14\u7c7b\u578b\uff0c\u53ea\u80fd\u8f93\u5165\u201c\u662f\u201d\u6216\u8005\u201c\u5426\u201d\u3002", (String)"AbstractBillImportEdit_20", (String)"scm-pds-common", (Object[])new Object[0]), pro.getDisplayName()));
                msg.append('\n');
            }
        } else if (pro instanceof DecimalProp) {
            String decimalValStr = val != null && String.valueOf(val).trim().length() > 0 ? String.valueOf(val) : "0";
            try {
                BigDecimal decimalVal = new BigDecimal(decimalValStr);
                if (pro instanceof PriceProp) {
                    if (decimalVal.compareTo(BigDecimal.ZERO) < 0) {
                        msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"AbstractBillImportEdit_21", (String)"scm-pds-common", (Object[])new Object[0]), pro.getDisplayName()));
                        msg.append('\n');
                    } else {
                        BigDecimal decimal;
                        int priceprecision = this.getScale(null, column, index);
                        String[] split = decimalValStr.split("\\.");
                        if (split.length == 2 && (decimal = new BigDecimal(split[1])).compareTo(BigDecimal.ZERO) > 0 && split[1].length() > priceprecision) {
                            msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u4e0d\u80fd\u8d85\u8fc7%2$s\u4f4d\u5c0f\u6570\u3002", (String)"AbstractBillImportEdit_22", (String)"scm-pds-common", (Object[])new Object[0]), pro.getDisplayName(), priceprecision));
                            msg.append('\n');
                        }
                    }
                } else if (pro instanceof AmountProp) {
                    // empty if block
                }
                returnVal = decimalVal;
            }
            catch (NumberFormatException e) {
                msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u6570\u636e\u683c\u5f0f\u4e0d\u7b26\u5408\u5c0f\u6570\u683c\u5f0f\u3002", (String)"AbstractBillImportEdit_23", (String)"scm-pds-common", (Object[])new Object[0]), pro.getDisplayName()));
                msg.append('\n');
            }
        } else if (pro instanceof DateProp) {
            if (val != null && String.valueOf(val).trim().length() > 0) {
                str = String.valueOf(val).trim();
                newStr = str.replace('.', '-').replace('|', '-').replace('/', '-');
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                df.setLenient(false);
                try {
                    returnVal = df.parse(newStr);
                }
                catch (ParseException e) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u6570\u636e\u683c\u5f0f\u4e0d\u662f\u5408\u6cd5\u7684\u65e5\u671f\u683c\u5f0f\uff0c\u683c\u5f0f\u5982\u4e0b\uff1aYYYY-MM-DD\u3002", (String)"AbstractBillImportEdit_26", (String)"scm-pds-common", (Object[])new Object[0]), pro.getDisplayName()));
                    msg.append('\n');
                    returnVal = null;
                }
            } else {
                returnVal = null;
            }
        } else if (pro instanceof DateTimeProp) {
            if (val != null && String.valueOf(val).trim().length() > 0) {
                str = String.valueOf(val).trim();
                newStr = str.replace('.', '-').replace('|', '-').replace('/', '-');
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                df.setLenient(false);
                try {
                    returnVal = df.parse(newStr);
                }
                catch (ParseException e) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u6570\u636e\u683c\u5f0f\u4e0d\u662f\u5408\u6cd5\u7684\u957f\u65e5\u671f\u683c\u5f0f\uff0c\u683c\u5f0f\u5982\u4e0b\uff1aYYYY-MM-DD HH:MM:SS\u3002", (String)"AbstractBillImportEdit_27", (String)"scm-pds-common", (Object[])new Object[0]), pro.getDisplayName()));
                    msg.append('\n');
                    returnVal = null;
                }
            } else {
                returnVal = null;
            }
        }
        if (null == returnVal) {
            StringBuilder configKeySb = new StringBuilder();
            configKeySb.append(this.getEntryKey()).append('.').append(column);
            Map<String, String> mustInputProMap = this.getMustInputProMap();
            if (null != mustInputProMap.get(configKeySb.toString()) && msg.length() == 0) {
                IDataEntityProperty prop = this.getModel().getDataEntityType().findProperty(column);
                if (null != prop) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u201c%1$s\u201d\u5fc5\u5f55\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractBillImportEdit_25", (String)"scm-pds-common", (Object[])new Object[0]), pro.getDisplayName())).append('\n');
                }
            } else if (isBd) {
                returnVal = 0L;
            }
        }
        return returnVal;
    }

    protected Object getBdVal(String column, String bdKey, Object val) {
        StringBuilder cacheKeySb = new StringBuilder();
        cacheKeySb.append("import_");
        cacheKeySb.append(bdKey);
        cacheKeySb.append('_');
        cacheKeySb.append(column);
        cacheKeySb.append('_');
        cacheKeySb.append(val);
        Object bdVal = this.getBdCache().get(cacheKeySb.toString(), Object.class);
        if (null != bdVal) {
            return bdVal;
        }
        if (null == val || String.valueOf(val).trim().length() == 0) {
            return null;
        }
        String bdPro = this.getBdPro(column);
        QFilter bdFilter = new QFilter(bdPro, "=", val);
        DynamicObject bdObj = QueryServiceHelper.queryOne((String)bdKey, (String)"id", (QFilter[])bdFilter.toArray());
        if (null == bdObj) {
            bdVal = 0L;
        } else {
            bdVal = bdObj.get("id");
            this.getBdCache().put(cacheKeySb.toString(), (Object)String.valueOf(bdVal), this.getBdCacheExpireSeconds());
        }
        return bdVal;
    }

    protected Object getAssistantBdVal(String column, String bdKey, long assistantType, Object val) {
        StringBuilder cacheKeySb = new StringBuilder();
        cacheKeySb.append("import_");
        cacheKeySb.append(bdKey);
        cacheKeySb.append('_');
        cacheKeySb.append(assistantType);
        cacheKeySb.append('_');
        cacheKeySb.append(column);
        cacheKeySb.append('_');
        cacheKeySb.append(val);
        Object bdVal = this.getBdCache().get(cacheKeySb.toString(), Object.class);
        if (null != bdVal) {
            return bdVal;
        }
        if (null == val || String.valueOf(val).trim().length() == 0) {
            return null;
        }
        String bdPro = this.getBdPro(column);
        QFilter assistantFilter = new QFilter(bdPro, "=", val);
        assistantFilter.and("group", "=", (Object)assistantType);
        DynamicObject bdObj = QueryServiceHelper.queryOne((String)bdKey, (String)"id", (QFilter[])new QFilter[]{assistantFilter});
        if (null == bdObj) {
            bdVal = 0L;
        } else {
            bdVal = bdObj.get("id");
            this.getBdCache().put(cacheKeySb.toString(), (Object)String.valueOf(bdVal), this.getBdCacheExpireSeconds());
        }
        return bdVal;
    }

    protected int getBdCacheExpireSeconds() {
        return 1800;
    }

    @Deprecated
    protected String getUniqueColumnName() {
        return null;
    }

    protected List<String> getUniqueColumnList() {
        ArrayList<String> uniqueColumnList = new ArrayList<String>();
        String uniqueColumn = this.getUniqueColumnName();
        if (null != uniqueColumn) {
            uniqueColumnList.add(uniqueColumn);
        }
        this.addUniqueColumn(uniqueColumnList);
        if (uniqueColumnList.size() == 0) {
            uniqueColumnList.add("seq");
        }
        return uniqueColumnList;
    }

    protected void addUniqueColumn(List<String> uniqueColumnList) {
    }

    protected Integer getUpdateRowIndex(Object val) {
        HashMap<String, Integer> columnIndexMap = new HashMap<String, Integer>(8);
        HashMap<String, DynamicObject> uniqueColumnColMap = new HashMap<String, DynamicObject>(8);
        this.groupEntryData(uniqueColumnColMap, columnIndexMap);
        return (Integer)columnIndexMap.get(String.valueOf(val));
    }

    protected void groupEntryData(Map<String, DynamicObject> uniqueColumnColMap, Map<String, Integer> columnIndexMap) {
        List<String> uniqueColumnList = this.getUniqueColumnList();
        int rowIndex = 0;
        DynamicObjectCollection cols = this.getModel().getEntryEntity(this.getEntryKey());
        for (DynamicObject col : cols) {
            String valStr = this.getGroupVal(col, uniqueColumnList);
            uniqueColumnColMap.put(valStr, col);
            columnIndexMap.put(valStr, rowIndex);
            ++rowIndex;
        }
    }

    protected String getGroupVal(DynamicObject col, String uniqueColumn) {
        Object val = col.get(uniqueColumn);
        String valStr = null;
        if (val instanceof DynamicObject) {
            DynamicObject valObj = (DynamicObject)val;
            String bdPro = this.getBdPro(uniqueColumn);
            valStr = valObj.getString(bdPro);
        } else {
            valStr = val instanceof Boolean ? (((Boolean)val).booleanValue() ? ResManager.loadKDString((String)"\u662f", (String)"AbstractBillImportEdit_18", (String)"scm-pds-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AbstractBillImportEdit_19", (String)"scm-pds-common", (Object[])new Object[0])) : (val == null ? "" : String.valueOf(val));
        }
        return valStr;
    }

    protected String getGroupVal(DynamicObject col, List<String> uniqueColumnList) {
        StringBuilder groupValStrSb = new StringBuilder();
        for (String uniqueColumn : uniqueColumnList) {
            String valStr = this.getGroupVal(col, uniqueColumn);
            if (groupValStrSb.length() > 0) {
                groupValStrSb.append('_');
                groupValStrSb.append(valStr);
                continue;
            }
            groupValStrSb.append(valStr);
        }
        return groupValStrSb.toString();
    }

    protected Map<String, String> getDynamicBdProperties() {
        DynamicObject obj = this.getModel().getDataEntity();
        DynamicObjectCollection cols = obj.getDynamicObjectCollection(this.getEntryKey());
        return AbstractBillImportEdit.getDynamicBdProperties((IDataEntityType)cols.getDynamicObjectType());
    }

    private static Map<String, String> getDynamicBdProperties(IDataEntityType objType) {
        HashMap<String, String> bdMap = new HashMap<String, String>();
        if (objType != null) {
            DataEntityPropertyCollection proptiesCol = objType.getProperties();
            for (IDataEntityProperty iDataEntityProperty : proptiesCol) {
                if (iDataEntityProperty instanceof AssistantProp || !(iDataEntityProperty instanceof BasedataProp)) continue;
                bdMap.put(iDataEntityProperty.getName(), ((BasedataProp)iDataEntityProperty).getBaseEntityId());
            }
        }
        return bdMap;
    }

    public Map<String, Map<String, String>> getAssistantProperties(IDataEntityType objType) {
        HashMap<String, Map<String, String>> assisbdMap = new HashMap<String, Map<String, String>>(1);
        DataEntityPropertyCollection proptiesCol = objType.getProperties();
        for (IDataEntityProperty iDataEntityProperty : proptiesCol) {
            if (!(iDataEntityProperty instanceof AssistantProp)) continue;
            HashMap<String, String> assistantMap = new HashMap<String, String>(2);
            assistantMap.put(ASSISTANT_TYPE, ((AssistantProp)iDataEntityProperty).getAsstTypeId());
            assistantMap.put(ASSISTANT_KEY, ((AssistantProp)iDataEntityProperty).getBaseEntityId());
            assisbdMap.put(iDataEntityProperty.getName(), assistantMap);
        }
        return assisbdMap;
    }

    protected String getBdPro(String column) {
        String bdMatchPro = "number";
        IDataEntityProperty pro = this.findPro(column);
        if (pro instanceof BasedataProp) {
            bdMatchPro = ((BasedataProp)pro).getNumbProp().getName();
        }
        return bdMatchPro;
    }

    public IDataEntityProperty findPro(String column) {
        IDataModel model = this.getModel();
        IDataEntityProperty pro = model.getDataEntityType().findProperty(column);
        return pro;
    }

    protected String getEntryKey() {
        return "entryentity";
    }

    protected DynamicObject getCurrency(int index) {
        IDataEntityProperty pro = this.findPro("curr");
        if (null == pro) {
            return null;
        }
        return this.getModel().getDataEntity().getDynamicObject("curr");
    }

    public IAppCache getBdCache() {
        return AppCache.get((String)"pds");
    }
}

