/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.endhandler;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class PdsEndStatusButtonDisableEdit
extends AbstractBillPlugIn {
    private static Log log = LogFactory.getLog(PdsEndStatusButtonDisableEdit.class);

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String opKey;
        switch (opKey = evt.getItemKey()) {
            case "bar_new": 
            case "bar_refresh": 
            case "bar_close": 
            case "bar_exit": 
            case "bar_bizquery": 
            case "businessquery": 
            case "copyproject": {
                break;
            }
            default: {
                this.validate(evt, opKey);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
    }

    public void validate(Object evt, String opKey) {
        Control control;
        Object billId = this.getModel().getDataEntity().getPkValue();
        String entityId = this.getView().getEntityId();
        if (Objects.equals(entityId, "src_negotiatebill")) {
            entityId = "src_project";
            billId = this.getModel().getDataEntity().getDynamicObject("project").getPkValue();
        }
        if (null == (control = this.getControl("bizstatus"))) {
            return;
        }
        String bizStatus = null;
        String billno = "";
        QFilter filter = new QFilter("id", "=", billId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)entityId, (String)"bizstatus,billno", (QFilter[])filter.toArray());
        if (Objects.nonNull(obj)) {
            bizStatus = obj.getString("bizstatus");
            billno = obj.getString("billno");
        }
        if (null == bizStatus && (Objects.equals(entityId, "src_negotiatebill") || Objects.equals(entityId, "tnd_quotebill")) && Objects.nonNull(obj = QueryServiceHelper.queryOne((String)entityId, (String)"project.bizstatus,project.billno", (QFilter[])filter.toArray()))) {
            bizStatus = obj.getString("project.bizstatus");
            billno = obj.getString("project.billno");
        }
        if (null == bizStatus || "".equals(bizStatus.trim()) || ProcessStatusEnums.NOTSTARTED.getValue().equals(bizStatus) || ProcessStatusEnums.PROCESSING.getValue().equals(bizStatus) || ProcessStatusEnums.PROCESSED.getValue().equals(bizStatus)) {
            return;
        }
        Map<String, Map<String, String>> resultMap = PdsMetadataUtil.getButtonMap(this.getView().getEntityId());
        Map<String, String> queryMap = resultMap.get("businessquery");
        if (queryMap.containsKey(opKey)) {
            return;
        }
        boolean isCancle = false;
        if (ProcessStatusEnums.CLOSED.getValue().equals(bizStatus)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$S \u5df2\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"PdsEndStatusButtonDisableEdit_2", (String)"scm-pds-common", (Object[])new Object[0]), billno));
            isCancle = true;
        } else if (ProcessStatusEnums.TERMINATED.getValue().equals(bizStatus)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s \u5df2\u5e9f\u6807\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"PdsEndStatusButtonDisableEdit_3", (String)"scm-pds-common", (Object[])new Object[0]), billno));
            isCancle = true;
        }
        if (isCancle) {
            if (evt instanceof BeforeDoOperationEventArgs) {
                ((BeforeDoOperationEventArgs)evt).setCancel(true);
            } else if (evt instanceof BeforeItemClickEvent) {
                ((BeforeItemClickEvent)evt).setCancel(true);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String entityName = this.getView().getEntityId();
        if (null == entityName) {
            return;
        }
        if (Objects.equals(entityName, "src_placeonfile")) {
            return;
        }
        String bizStatus = null;
        try {
            bizStatus = this.getModel().getDataEntity().getString("bizstatus");
        }
        catch (Exception e2) {
            log.error("###get val Exception:" + e2.getMessage());
        }
        if (null == bizStatus && (Objects.equals(entityName, "src_negotiatebill") || Objects.equals(entityName, "tnd_quotebill"))) {
            bizStatus = this.getModel().getDataEntity().getString("project.bizstatus");
        }
        if (null == bizStatus || "".equals(bizStatus.trim()) || ProcessStatusEnums.NOTSTARTED.getValue().equals(bizStatus) || ProcessStatusEnums.PROCESSING.getValue().equals(bizStatus) || ProcessStatusEnums.PROCESSED.getValue().equals(bizStatus)) {
            return;
        }
        HashSet<String> exceptSet = new HashSet<String>(16);
        exceptSet.add("bar_refresh");
        exceptSet.add("bar_close");
        exceptSet.add("bar_exit");
        exceptSet.add("bar_bizquery");
        exceptSet.add("nextnode");
        exceptSet.add("businessop");
        exceptSet.add("businessquery");
        Map<String, Map<String, String>> resultMap = PdsMetadataUtil.getButtonMap(this.getView().getEntityId());
        Map<String, String> buttonMap = resultMap.get("businessop");
        Map<String, String> queryMap = resultMap.get("businessquery");
        exceptSet.addAll(queryMap.keySet());
        if (null != buttonMap && buttonMap.size() > 0) {
            for (Map.Entry<String, String> entry : buttonMap.entrySet()) {
                if (exceptSet.contains(entry.getKey())) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{entry.getKey()});
            }
        }
    }
}

