/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.selecttool;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.selecttool.IPdsInitContext;
import kd.scm.pds.common.selecttool.IPdsInitExtData;
import kd.scm.pds.common.selecttool.IPdsInitModel;
import kd.scm.pds.common.selecttool.IPdsReturnData;
import kd.scm.pds.common.selecttool.SupplierContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;
import kd.scm.pds.common.util.PdsPurlistUtils;

public class PdsSelectUtils {
    public static SupplierContext getContextInstance() {
        return (SupplierContext)ExtPluginFactory.getInstance().getExtPluginInstance(SupplierContext.class.getSimpleName(), SupplierContext.class.getName());
    }

    public static void initModel(SupplierContext context) {
        IPdsInitModel initModel = (IPdsInitModel)ExtPluginFactory.getInstance().getExtPluginInstance(IPdsInitModel.class.getSimpleName());
        if (initModel == null) {
            context.setSucced(false);
            return;
        }
        initModel.initModel((Object)context);
        if (context.getProjectObj() == null) {
            context.setSucced(false);
        }
    }

    public static void initContext(SupplierContext context) {
        IPdsInitContext initContext = (IPdsInitContext)ExtPluginFactory.getInstance().getExtPluginInstance(IPdsInitContext.class.getSimpleName());
        if (initContext == null) {
            context.setSucced(false);
            return;
        }
        initContext.initContext((Object)context);
    }

    public static void initExtData(SupplierContext context) {
        IPdsInitExtData extData = (IPdsInitExtData)ExtPluginFactory.getInstance().getExtPluginInstance(IPdsInitExtData.class.getSimpleName());
        if (extData == null) {
            context.setSucced(false);
            return;
        }
        context.setExtData(extData);
    }

    public static void returnData(SupplierContext context) {
        List returnDatas = ExtPluginFactory.getInstance().getExtPluginInstances(IPdsReturnData.class.getSimpleName());
        if (returnDatas == null || returnDatas.size() == 0) {
            context.setSucced(false);
            return;
        }
        for (IPdsReturnData returnData : returnDatas) {
            returnData.returnData((Object)context);
        }
    }

    public static void setQueryConditionVisible(IFormView view, Boolean isVisible) {
        PdsSelectUtils.setQueryConditionVisible(view, "bd_supplier", isVisible);
        PdsSelectUtils.setQueryConditionVisible(view, "srm_supplier", isVisible);
        PdsSelectUtils.setQueryConditionVisible(view, "srm_supcategory", isVisible);
        PdsSelectUtils.setQueryConditionVisible(view, "srm_scorerpt", isVisible);
        PdsSelectUtils.setQueryConditionPropertiesVisible(view, "condition_bd_supplier", isVisible);
        PdsSelectUtils.setQueryConditionPropertiesVisible(view, "condition_srm_supplier", isVisible);
        PdsSelectUtils.setQueryConditionPropertiesVisible(view, "condition_srm_supcategory", isVisible);
        PdsSelectUtils.setQueryConditionPropertiesVisible(view, "condition_srm_scorerpt", isVisible);
    }

    public static void setQueryConditionVisible(IFormView view, String baseDataType, Boolean isVisible) {
        view.setVisible(isVisible, new String[]{baseDataType});
        view.setVisible(isVisible, new String[]{"condition_" + baseDataType});
    }

    public static void setQueryConditionPropertiesVisible(IFormView view, String containerName, Boolean isVisible) {
        List<String> properties = PdsMetadataUtil.getContainerProperties("pds_invitehelper", containerName);
        for (String property : properties) {
            view.setVisible(isVisible, new String[]{property});
        }
    }

    public static Set<Long> getPurOrgSet(SupplierContext context, DynamicObjectCollection rows) {
        long purOrgId;
        long l = purOrgId = null == context ? 0L : context.getProjectObj().getLong("org.id");
        if ((null == rows || rows.size() == 0) && null != context) {
            rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"org.id", (QFilter[])context.getPurlistQFilter().toArray());
        }
        if (rows == null || rows.size() == 0) {
            return PdsCommonUtils.buildSet((Long[])new Long[]{purOrgId});
        }
        if (rows.stream().anyMatch(e -> e.getLong("org.id") > 0L)) {
            return rows.stream().map(e -> e.getLong("org.id")).collect(Collectors.toSet());
        }
        return PdsCommonUtils.buildSet((Long[])new Long[]{purOrgId});
    }

    public static Set<String> getOrgCategorySet(SupplierContext context) {
        QFilter qfilter = PdsPurlistUtils.getOriginalPurlistQFilter((long)context.getProjectId());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"org.id,category.id", (QFilter[])qfilter.toArray());
        if (rows == null || rows.size() == 0) {
            return null;
        }
        return rows.stream().map(e -> e.getString("org.id") + '_' + e.getString("category.id")).collect(Collectors.toSet());
    }
}

