/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class ComboEditUtils {
    public static List<ComboItem> getComboList(Map<String, String> comboMap) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
        for (Map.Entry<String, String> comboMapEntry : comboMap.entrySet()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(comboMapEntry.getKey());
            comboItem.setCaption(new LocaleString(comboMapEntry.getValue()));
            comboItemList.add(comboItem);
        }
        return comboItemList;
    }

    public static String getComboKeyByValue(DynamicObject billObj, String combField, String value) {
        MainEntityType dataEntityType = (MainEntityType)billObj.getDataEntityType();
        Map entityTypeMap = dataEntityType.getAllEntities();
        for (Map.Entry entityType : entityTypeMap.entrySet()) {
            DataEntityPropertyCollection properties = ((EntityType)entityType.getValue()).getProperties();
            ComboProp comboUnitProp = (ComboProp)properties.get((Object)combField);
            if (null == comboUnitProp || null == comboUnitProp.getItemByName(value)) continue;
            return comboUnitProp.getItemByName(value);
        }
        return null;
    }

    public static Map<String, Object> getComboKeyValueMap(String entityName, String combField) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        ComboProp iDataEntityProperty = (ComboProp)dynamicObject.getDataEntityType().getProperties().get((Object)combField);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        for (ValueMapItem comboItem : iDataEntityProperty.getComboItems()) {
            String key = comboItem.getValue();
            LocaleString value = comboItem.getName();
            resultMap.put(key, value);
        }
        return resultMap;
    }

    public static Map<String, Object> getComboKeyValueMapFromEntry(String entityName, String entryName, String combField) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectCollection(entryName).getDynamicObjectType();
        DynamicObject entryDynamicOperationsObject = new DynamicObject(dynamicObjectType);
        ComboProp iDataEntityProperty = (ComboProp)entryDynamicOperationsObject.getDataEntityType().getProperties().get((Object)combField);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (null == iDataEntityProperty) {
            return resultMap;
        }
        for (ValueMapItem comboItem : iDataEntityProperty.getComboItems()) {
            String key = comboItem.getValue();
            LocaleString value = comboItem.getName();
            resultMap.put(key, value);
        }
        return resultMap;
    }

    public static List<ComboItem> getCombList(String entityName) {
        Map<String, String> propetiesMap = PdsMetadataUtil.getProMap(entityName, true);
        List<ComboItem> combList = new ArrayList<ComboItem>(16);
        if (!CollectionUtils.isEmpty(propetiesMap)) {
            combList = PdsMetadataUtil.buildPropComboItems(propetiesMap);
        }
        return combList;
    }

    public static String getCombListNameByVale(List<ComboItem> combList, String value) {
        for (ComboItem item : combList) {
            if (!item.getValue().equals(value)) continue;
            return item.getCaption().getLocaleValue_zh_CN();
        }
        return null;
    }
}

