/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.scm.pds.common.constant.SrcCommonConstant;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsMetadataUtil;

public class MultiTypeEditUtils {
    public static String getFieldType(String pro) {
        String type = "";
        switch (pro) {
            case "TextEdit": {
                type = "0";
                break;
            }
            case "DecimalEdit": 
            case "AmountEdit": {
                type = "3";
                break;
            }
            case "DateTimeEdit": {
                type = "5";
                break;
            }
            case "FieldEdit": {
                type = "7";
                break;
            }
            case "BasedataEdit": 
            case "OrgEdit": 
            case "UserEdit": 
            case "MainOrgEdit": {
                type = "8";
                break;
            }
            case "ComboEdit": 
            case "BillStatusEdit": {
                type = "9";
                break;
            }
            default: {
                type = "0";
            }
        }
        return type;
    }

    public static FormShowParameter createParamValue(String paramType, String value, String basedataInfo, List<ComboItem> comboProps) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("value", (Object)value);
        switch (paramType) {
            case "0": {
                parameter.setCustomParam("visible", (Object)"texttype");
                break;
            }
            case "1": {
                parameter.setCustomParam("visible", (Object)"integertype");
                break;
            }
            case "2": {
                parameter.setCustomParam("visible", (Object)"biginttype");
                break;
            }
            case "3": {
                parameter.setCustomParam("visible", (Object)"decimaltype");
                break;
            }
            case "4": {
                parameter.setCustomParam("visible", (Object)"datetype");
                break;
            }
            case "5": {
                parameter.setCustomParam("visible", (Object)"datetimetype");
                break;
            }
            case "6": {
                parameter.setCustomParam("visible", (Object)"timetype");
                break;
            }
            case "7": {
                parameter.setCustomParam("visible", (Object)"booleantype");
                break;
            }
            case "8": {
                parameter.setCustomParam("visible", (Object)"basedatavalue");
                parameter.setCustomParam("basedatainfo", (Object)basedataInfo);
                break;
            }
            case "9": {
                parameter.setCustomParam("visible", (Object)"combotype");
                parameter.setCustomParam("comboinfo", (Object)JSONObject.toJSONString(comboProps));
                break;
            }
            default: {
                parameter.setCustomParam("visible", (Object)"texttype");
            }
        }
        return parameter;
    }

    public static void clickHandle(IFormView view, EventObject evt, Map<String, String> paramMap) {
        String fieldName = ((Control)evt.getSource()).getKey();
        String pluginName = paramMap.get("pluginname");
        String baseField = paramMap.get("basefield");
        String objectField = paramMap.get("objectfield");
        String paramField = paramMap.get("paramfield");
        String titleField = paramMap.get("titlefield");
        DynamicObject baseObj = MultiTypeEditUtils.getBaseObject(view, baseField);
        if (null == baseObj) {
            return;
        }
        String paramType = PdsCommonUtils.object2String((Object)baseObj.get(paramField), (String)"0");
        if (StringUtils.isBlank((CharSequence)paramType)) {
            return;
        }
        FormShowParameter parameter = MultiTypeEditUtils.createParamValue(paramType, MultiTypeEditUtils.getValue(view, paramType, fieldName), MultiTypeEditUtils.getBasedataInfo(view, paramType, fieldName, baseField, objectField), MultiTypeEditUtils.getComboList(view, paramType, baseField, objectField));
        String title = baseObj.getString(titleField);
        parameter.setCustomParam("title", (Object)title);
        parameter.setCustomParam("fieldname", (Object)fieldName);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("pds_def_param");
        parameter.setCloseCallBack(new CloseCallBack(pluginName, "callbackid"));
        view.showForm(parameter);
    }

    public static void closedCallBackHandle(IFormView view, ClosedCallBackEvent evt, Map<String, String> paramMap) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (!"callbackid".equals(actionId) || null == returnData) {
            return;
        }
        Map dataMap = (Map)returnData;
        Object returnDataMap = dataMap.get("returnData");
        if (returnDataMap instanceof Map) {
            Map param = (Map)returnDataMap;
            String type = PdsCommonUtils.object2String(param.get("type"), (String)"");
            String value = PdsCommonUtils.object2String(param.get("defaultvalue"), (String)"");
            String fieldName = PdsCommonUtils.object2String(dataMap.get("fieldname"), (String)"");
            String fieldNameValue = fieldName;
            if (!fieldNameValue.contains("value")) {
                fieldNameValue = fieldNameValue + "value";
            }
            if ("combovalue".equals(type)) {
                view.getModel().setValue(fieldName, param.get("combovalue"));
                view.getModel().setValue(fieldNameValue, (Object)value);
                return;
            }
            if ("boolean".equals(type)) {
                view.getModel().setValue(fieldName, (Object)value);
                view.getModel().setValue(fieldNameValue, (Object)(StringUtils.equals((CharSequence)SrcCommonConstant.TRUE, (CharSequence)value) ? "1" : "0"));
                return;
            }
            if (!"basedata".equals(type)) {
                view.getModel().setValue(fieldName, (Object)value);
                view.getModel().setValue(fieldNameValue, (Object)value);
                return;
            }
            param.remove("defaultvalue");
            param.remove("type");
            view.getModel().setValue(fieldName, (Object)value);
            view.getModel().setValue(fieldNameValue, ((Map)param.get("basedatavalue")).get("id"));
        }
    }

    private static String getValue(IFormView view, String paramType, String fieldName) {
        if (StringUtils.equals((CharSequence)"7", (CharSequence)paramType)) {
            return StringUtils.equals((CharSequence)SrcCommonConstant.TRUE, (CharSequence)PdsCommonUtils.object2String((Object)view.getModel().getValue(fieldName), (String)"")) ? "1" : "0";
        }
        if (!fieldName.contains("value")) {
            return PdsCommonUtils.object2String((Object)view.getModel().getValue(fieldName + "value"), (String)"");
        }
        return fieldName;
    }

    private static String getBasedataInfo(IFormView view, String paramType, String fieldName, String baseField, String objectField) {
        if (StringUtils.equals((CharSequence)"8", (CharSequence)paramType)) {
            return JSONObject.toJSONString(MultiTypeEditUtils.getBaseDataMap(view, fieldName, baseField, objectField));
        }
        return null;
    }

    private static Map<String, Map<String, String>> getBaseDataMap(IFormView view, String fieldName, String baseField, String objectField) {
        HashMap<String, Map<String, String>> dataMap = new HashMap<String, Map<String, String>>(8);
        HashMap<String, String> baseDataValueMap = new HashMap<String, String>(1);
        DynamicObject baseObj = MultiTypeEditUtils.getBaseObject(view, baseField);
        String baseEntityId = null;
        if (Objects.nonNull(baseObj)) {
            baseEntityId = (null == baseField ? view.getModel().getDataEntity() : baseObj).getString(objectField + '.' + "number");
        }
        baseDataValueMap.put("number", baseEntityId);
        String fieldNameValue = fieldName.contains("value") ? fieldName : fieldName + "value";
        baseDataValueMap.put("id", PdsCommonUtils.object2String((Object)view.getModel().getValue(fieldNameValue), (String)""));
        dataMap.put("basedatavalue", baseDataValueMap);
        return dataMap;
    }

    private static List<ComboItem> getComboList(IFormView view, String paramType, String baseField, String objectField) {
        if (StringUtils.equals((CharSequence)"9", (CharSequence)paramType)) {
            DynamicObject baseObj = MultiTypeEditUtils.getBaseObject(view, baseField);
            String baseEntityId = null;
            String fieldName = null;
            if (Objects.nonNull(baseObj)) {
                baseEntityId = (null == baseField ? view.getModel().getDataEntity() : baseObj).getString(objectField + '.' + "number");
                fieldName = baseObj.getString("fieldname");
            }
            return PdsMetadataUtil.getComboProp(baseEntityId, fieldName);
        }
        return null;
    }

    private static DynamicObject getBaseObject(IFormView view, String baseField) {
        if ("src_bizitem".equals(view.getEntityId())) {
            return view.getModel().getDataEntity();
        }
        String entryName = MultiTypeEditUtils.getEntryEntityId(view.getEntityId());
        int index = view.getModel().getEntryCurrentRowIndex(entryName);
        if (index >= 0) {
            if (null != baseField) {
                return view.getModel().getEntryRowEntity(entryName, index).getDynamicObject(baseField);
            }
            return view.getModel().getEntryRowEntity(entryName, index);
        }
        return null;
    }

    private static String getEntryEntityId(String entityName) {
        if ("src_purlist_item".equals(entityName)) {
            return "itementity";
        }
        return "entryentity";
    }

    public static Map<String, String> getParamMap(String pluginName, String baseField, String objectField, String paramField, String titleField) {
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        paramMap.put("pluginname", pluginName);
        paramMap.put("basefield", baseField);
        paramMap.put("objectfield", objectField);
        paramMap.put("paramfield", paramField);
        paramMap.put("titlefield", titleField);
        return paramMap;
    }
}

