/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.common.vie;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.form.control.CountDown;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.enums.SrcVieStatusEnums;
import kd.scm.pds.common.enums.VieTurnsEnums;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.pds.common.vie.IPdsVieProcess;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieSumAndRankHandler;

public class PdsVieHelper {
    public static void allowInitializeRedisCache(PdsVieContext context, String status) {
        String initialKey = String.valueOf(context.getProjectId()) + '|' + context.getVieturns() + '|' + "initial";
        PdsVieHelper.getInstance().put(initialKey, (Object)status, context.getBidtimes());
    }

    public static DistributeSessionlessCache getInstance() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(RequestContext.get().getTenantId() + "_pds");
    }

    public static void allowRefreshRedisCache(PdsVieContext context, String status) {
        String refreshKey = String.valueOf(context.getProjectId()) + '|' + context.getVieturns() + '|' + "refresh";
        PdsVieHelper.getInstance().put(refreshKey, (Object)status, context.getBidtimes());
    }

    public static HashMap<String, Object> createRankMap(int rank, DynamicObject optimalQuote, DynamicObject supplierQuote) {
        HashMap<String, Object> rankMap = new HashMap<String, Object>(4);
        rankMap.put("rank", rank);
        rankMap.put("pkgrank", supplierQuote.get("pkgrank"));
        rankMap.put("pkgamount", supplierQuote.get("pkgamount"));
        rankMap.put("pkgtaxamount", supplierQuote.get("pkgtaxamount"));
        rankMap.put("prorank", supplierQuote.get("prorank"));
        rankMap.put("proamount", supplierQuote.get("proamount"));
        rankMap.put("protaxamount", supplierQuote.get("protaxamount"));
        rankMap.put("optimalquote", optimalQuote);
        rankMap.put("supplierquote", supplierQuote);
        return rankMap;
    }

    public static PdsVieContext getContextInstance() {
        return (PdsVieContext)ExtPluginFactory.getInstance().getExtPluginInstance(PdsVieContext.class.getSimpleName(), PdsVieContext.class.getName());
    }

    public static String getLastNegTurns(DynamicObject negBillObj) {
        if (negBillObj != null) {
            if (negBillObj.getString("negotiatetype").equals("4")) {
                return negBillObj.getString("turns");
            }
            return "0";
        }
        return "1";
    }

    public static DynamicObject getLastNegTurnsObj(long projectId) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        DynamicObjectCollection negObjs = QueryServiceHelper.query((String)"src_negotiatebill", (String)"negotiatetype,turns", (QFilter[])qfilter.toArray());
        if (null == negObjs || negObjs.size() == 0) {
            return null;
        }
        return (DynamicObject)negObjs.stream().max((e1, e2) -> e1.getInt("turns") - e2.getInt("turns")).get();
    }

    public static DynamicObject getLastVieTurnsObj(DynamicObject vieBillObj, String turns) {
        if (vieBillObj == null) {
            return null;
        }
        DynamicObjectCollection vieTurnsObjs = vieBillObj.getDynamicObjectCollection("entryentityturns");
        if (null == vieTurnsObjs || vieTurnsObjs.size() == 0) {
            return null;
        }
        if (turns == null) {
            return vieTurnsObjs.stream().max(Comparator.comparingInt(e -> Integer.parseInt(e.getString("vieturns")))).get();
        }
        return vieTurnsObjs.stream().filter(e -> e.getString("turns").equals(turns)).max(Comparator.comparingInt(e -> Integer.parseInt(e.getString("vieturns")))).orElse(null);
    }

    public static String getLastVieTurns(long projectId, String turns) {
        DynamicObject vieBillObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_competebill");
        DynamicObject turnsObj = PdsVieHelper.getLastVieTurnsObj(vieBillObj, turns);
        if (null != turnsObj) {
            return turnsObj.getString("vieturns");
        }
        return VieTurnsEnums.VIE01.getValue();
    }

    public static DynamicObjectCollection getPurchasePurlist(long projectId, String turns) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId).and("turns", "=", (Object)turns);
        return PdsVieHelper.getPurlist(qfilter);
    }

    public static DynamicObjectCollection getPurlist(QFilter qfilter) {
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)true);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilter.toArray());
        return rows;
    }

    public static Set<Long> getPurlistIds(PdsVieContext context) {
        DynamicObjectCollection purlistObjs = null;
        if (context.getVieTechScheme().equals("1")) {
            purlistObjs = context.getView().getModel().getEntryEntity("entryentity");
        } else {
            QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId()).and("supplier", ">", (Object)0L).and("turns", "=", (Object)context.getTurns()).and("billtype", "=", (Object)"2");
            purlistObjs = QueryServiceHelper.query((String)"src_purlistf7", (String)"purlist.id", (QFilter[])qfilter.toArray());
        }
        if (purlistObjs == null || purlistObjs.size() == 0) {
            return Collections.emptySet();
        }
        return purlistObjs.stream().map(e -> e.getLong("purlist.id")).collect(Collectors.toSet());
    }

    public static long getQuoteBillId(PdsVieContext context) {
        Map params = context.getView().getFormShowParameter().getCustomParams();
        long quoteBillId = PdsCommonUtils.object2Long(params.get("quoteid"));
        return quoteBillId;
    }

    public static Map<String, Object> getQuoteBillMap(long billId) {
        if (billId == 0L) {
            return null;
        }
        DynamicObject quoBillObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"tnd_quotebill");
        if (quoBillObj == null) {
            return null;
        }
        if (!quoBillObj.getBoolean("iscompete")) {
            return null;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("projectid", quoBillObj.getString("project.id"));
        resultMap.put("supplierid", quoBillObj.getString("supplier.id"));
        resultMap.put("suppliername", quoBillObj.getString("supplier.name"));
        resultMap.put("billid", SrmCommonUtil.getPkValue((DynamicObject)quoBillObj));
        resultMap.put("turns", quoBillObj.getString("turns"));
        String vieturns = PdsVieHelper.getLastVieTurns(PdsCommonUtils.object2Long((Object)quoBillObj.getLong("project.id")), null);
        resultMap.put("vieturns", vieturns);
        return resultMap;
    }

    public static void getQuoteDataFromDB(PdsVieContext context) {
        Set<Long> purlistSet = PdsVieHelper.getPurlistIds(context);
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        qfilter.and("purlist", "in", purlistSet);
        if ("1".equals(context.getVie_purlist())) {
            qfilter.and("vieturns", "=", (Object)context.getVieturns());
        }
        StringBuilder orderBy = new StringBuilder("purlist").append(',');
        orderBy.append("supplier").append(',');
        orderBy.append("quotedate").append(' ').append("desc");
        String selectfields = "id,purlist.package.id," + DynamicObjectUtil.getSelectfields((String)"src_vie_detailf7", (boolean)true);
        DynamicObjectCollection quoteRows = QueryServiceHelper.query((String)"src_vie_detailf7", (String)selectfields, (QFilter[])qfilter.toArray(), (String)orderBy.toString());
        if (quoteRows != null && quoteRows.size() > 0) {
            Map<String, DynamicObject> quoteDataMap = quoteRows.stream().collect(Collectors.groupingBy(e -> e.getString("purlist") + '|' + e.getString("supplier"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
            HashSet<Long> entryIds = new HashSet<Long>(quoteDataMap.size());
            for (Map.Entry<String, DynamicObject> entry : quoteDataMap.entrySet()) {
                entryIds.add(entry.getValue().getLong("id"));
            }
            Map<String, List<DynamicObject>> quoteData = quoteRows.stream().filter(e -> entryIds.contains(e.getLong("id"))).collect(Collectors.groupingBy(e -> e.getString("purlist")));
            context.setQuoteData(quoteData);
        }
    }

    public static long getRestOfTime(PdsVieContext context) {
        String bidStatus = context.getBidStatus();
        int bidTime = context.getVieBillObj().getInt("bidtime");
        int addTime = context.getVieBillObj().getInt("addtime");
        long bidrestOfTime = context.getVieBillObj().getLong("bidrestoftime");
        Date openDate = context.getVieBillObj().getDate("opendate");
        Date pauseTime = context.getVieBillObj().getDate("pausetime");
        Date pauseRestartDate = context.getVieBillObj().getDate("pausestarttime");
        Date currTime = TimeServiceHelper.now();
        long restOfTime = 0L;
        if (pauseTime == null) {
            restOfTime = (long)(bidTime * 60 * 1000 + addTime * 60 * 1000) - (currTime.getTime() - openDate.getTime());
        } else if (bidStatus.equals(SrcVieStatusEnums.PAUSED.getValue())) {
            restOfTime = bidrestOfTime;
        } else if (bidStatus.equals(SrcVieStatusEnums.BIDDING.getValue()) && pauseRestartDate != null) {
            restOfTime = bidrestOfTime - (currTime.getTime() - pauseRestartDate.getTime());
        }
        return restOfTime;
    }

    public static DynamicObjectCollection getSupplierPurlist(long billId) {
        QFilter qfilter = new QFilter("parentid", "=", (Object)String.valueOf(billId));
        return PdsVieHelper.getPurlist(qfilter);
    }

    public static Map<String, List<DynamicObject>> getSupplierQuoteMap(PdsVieContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId()).and("supplier", "=", (Object)context.getSupplierId()).and("purlist", ">", (Object)0L);
        String selectfields = DynamicObjectUtil.getSelectfields((String)"src_vie_detailf7", (boolean)true);
        DynamicObject[] quoteRows = BusinessDataServiceHelper.load((String)"src_vie_detailf7", (String)selectfields, (QFilter[])qfilter.toArray(), (String)"quotedate desc");
        if (quoteRows == null || quoteRows.length == 0) {
            return null;
        }
        return Arrays.asList(quoteRows).stream().collect(Collectors.groupingBy(e -> e.getString("purlist.id")));
    }

    public static String getTaxType(DynamicObject vieBillObj) {
        return PdsCommonUtils.object2String((Object)vieBillObj.get("taxtype"), (String)"1");
    }

    public static String getDecisionType(DynamicObject vieBillObj) {
        return PdsCommonUtils.object2String((Object)vieBillObj.get("decisiontype"), (String)"1");
    }

    public static String getSumType(DynamicObject vieBillObj) {
        return PdsCommonUtils.object2String((Object)vieBillObj.get("sumtype"), (String)"3");
    }

    public static DynamicObject getVieBillObj(long projectId) {
        if (QueryServiceHelper.exists((String)"src_competebill", (Object)projectId)) {
            return BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_competebill");
        }
        return null;
    }

    public static boolean isInitializeRedisCache(PdsVieContext context) {
        String initialKey = String.valueOf(context.getProjectId()) + '|' + context.getVieturns() + '|' + "initial";
        if (PdsVieHelper.getInstance().get(initialKey) == null || ((String)PdsVieHelper.getInstance().get(initialKey)).equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean isRefreshRedisCache(PdsVieContext context) {
        String refreshKey = String.valueOf(context.getProjectId()) + '|' + context.getVieturns() + '|' + "refresh";
        if (PdsVieHelper.getInstance().get(refreshKey) == null || ((String)PdsVieHelper.getInstance().get(refreshKey)).equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void loadVieEntryData(PdsVieContext context, IFormView targetView, String sourceEntity, QFilter sourceQfilter, Set<String> excFields, String entryentity) {
        AbstractFormDataModel model = (AbstractFormDataModel)targetView.getModel();
        model.deleteEntryData(entryentity);
        String selectfields = DynamicObjectUtil.getSelectfields((String)sourceEntity, (boolean)true);
        DynamicObject[] srouceRows = BusinessDataServiceHelper.load((String)sourceEntity, (String)selectfields, (QFilter[])new QFilter[]{sourceQfilter}, (String)"purlist.id,supplier.id");
        if (srouceRows == null || srouceRows.length == 0) {
            return;
        }
        Set noDiscardSet = null;
        Set hasDiscardSet = null;
        if (null != context && context.getVieBillObj().getBoolean("isdiscarded") && context.getSupplierId() > 0L) {
            noDiscardSet = PdsPurlistUtils.getIsDiscardedPurilstIds((long)context.getProjectId(), (long)context.getSupplierId(), (boolean)false);
            hasDiscardSet = PdsPurlistUtils.getIsDiscardedPurilstIds((long)context.getProjectId(), (long)context.getSupplierId(), (boolean)true);
        }
        EntryGrid entryGrid = (EntryGrid)targetView.getControl(entryentity);
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (int i = 0; i < srouceRows.length; ++i) {
            DynamicObject row = srouceRows[i];
            for (String pro : properties) {
                if (excFields.contains(pro)) continue;
                try {
                    if (pro.equals("srcentryid")) {
                        ts.set("srcentryid", row.getPkValue(), i);
                        continue;
                    }
                    if (pro.equals("supplierip")) {
                        ts.set("supplierip", (Object)PdsCommonUtils.getLoginIp(), i);
                        continue;
                    }
                    if (pro.equals("isonline")) {
                        long supplierId = PdsCommonUtils.object2Long((Object)ts.get("supplier", i));
                        context.setSupplierId(supplierId);
                        String[] status = PdsVieHelper.getSupplierOnlineStatus(context);
                        if ("0".equals(status[0])) {
                            ts.set("isonline", (Object)false, i);
                            continue;
                        }
                        ts.set("isonline", (Object)true, i);
                        continue;
                    }
                    if (row.get(pro) instanceof DynamicObject) {
                        ts.set(pro, row.getDynamicObject(pro).getPkValue(), i);
                        continue;
                    }
                    ts.set(pro, row.get(pro), i);
                }
                catch (Exception e) {
                    BizLog.log((String)e.getMessage());
                }
            }
            if (context != null) {
                if (row.getBigDecimal("increaseprice").compareTo(BigDecimal.ZERO) == 0) {
                    ts.set("increaseprice", (Object)context.getReducePct(), i);
                }
                ts.set("reducetype", (Object)context.getReduceType(), i);
            }
            if (null == context || context.getSupplierId() <= 0L) continue;
            Long purlistId = row.getLong("purlist.id");
            if (null != noDiscardSet && noDiscardSet.contains(purlistId)) {
                ts.set("isquote", (Object)true, i);
                continue;
            }
            if (null == hasDiscardSet || !hasDiscardSet.contains(purlistId)) continue;
            ts.set("isdiscarded2", (Object)true, i);
        }
        model.batchCreateNewEntryRow(entryentity, ts);
    }

    public static void putLastQuoteToCache(String key, DynamicObject purlistObj, boolean isDynamicObject) {
        Map<String, String> quoteCacheMap = PdsVieHelper.getLastQuoteToCache(key, purlistObj, isDynamicObject);
        PdsVieHelper.getInstance().put(key, quoteCacheMap);
    }

    public static Map<String, String> getLastQuoteToCache(String key, DynamicObject purlistObj, boolean isDynamicObject) {
        HashMap<String, String> quoteCacheMap = new HashMap<String, String>(16);
        quoteCacheMap.put(key + '|' + "vieratio", purlistObj.getBigDecimal("vieratio").toString());
        quoteCacheMap.put(key + '|' + "viediffer", purlistObj.getBigDecimal("viediffer").toString());
        quoteCacheMap.put(key + '|' + "price", purlistObj.getBigDecimal("price").toString());
        quoteCacheMap.put(key + '|' + "taxprice", purlistObj.getBigDecimal("taxprice").toString());
        quoteCacheMap.put(key + '|' + "taxrate", purlistObj.getBigDecimal("taxrate").toString());
        quoteCacheMap.put(key + '|' + "amount", purlistObj.getBigDecimal("amount").toString());
        quoteCacheMap.put(key + '|' + "taxamount", purlistObj.getBigDecimal("taxamount").toString());
        quoteCacheMap.put(key + '|' + "note", purlistObj.getString("note"));
        quoteCacheMap.put(key + '|' + "quotedate", SerializationUtils.toJsonString((Object)purlistObj.getDate("quotedate")));
        if (isDynamicObject) {
            quoteCacheMap.put(key + '|' + "taxitem", purlistObj.getString("taxitem.id"));
            quoteCacheMap.put(key + '|' + "currency", purlistObj.getString("currency.id"));
        } else {
            quoteCacheMap.put(key + '|' + "taxitem", purlistObj.getString("taxitem"));
            quoteCacheMap.put(key + '|' + "currency", purlistObj.getString("currency"));
        }
        return quoteCacheMap;
    }

    public static void putRankResultToCache(String key, int rank, String optimalSupplier, String optimalQuote) {
        Map<String, String> quoteRankCacheMap = PdsVieHelper.getRankResultToCache(key, rank, optimalSupplier, optimalQuote);
        PdsVieHelper.getInstance().put(key, quoteRankCacheMap);
    }

    public static Map<String, String> getRankResultToCache(String key, int rank, String optimalSupplier, String optimalQuote) {
        HashMap<String, String> quoteRankCacheMap = new HashMap<String, String>(4);
        quoteRankCacheMap.put(key + '|' + "rank", String.valueOf(rank));
        quoteRankCacheMap.put(key + '|' + "optimalsupplier", optimalSupplier);
        quoteRankCacheMap.put(key + '|' + "optimalquote", optimalQuote);
        return quoteRankCacheMap;
    }

    public static List<DynamicObject> rankQuoteData(List<DynamicObject> quoteData, final String vieType, final String taxType, final String decisionType) {
        List<DynamicObject> quoteDataList = quoteData;
        Collections.sort(quoteDataList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                if (taxType.equals("2")) {
                    if ("2".equals(decisionType)) {
                        return PdsVieHelper.compareValue(vieType, o1, o2, "locamount", "quotedate");
                    }
                    return PdsVieHelper.compareValue(vieType, o1, o2, "locprice", "quotedate");
                }
                if ("2".equals(decisionType)) {
                    return PdsVieHelper.compareValue(vieType, o1, o2, "loctaxamount", "quotedate");
                }
                return PdsVieHelper.compareValue(vieType, o1, o2, "loctaxprice", "quotedate");
            }
        });
        return quoteDataList;
    }

    public static int compareValue(String vieType, DynamicObject o1, DynamicObject o2, String valueField, String dateField) {
        int result = o1.getBigDecimal(valueField).compareTo(o2.getBigDecimal(valueField));
        if (vieType.equals("B")) {
            result = -result;
        }
        if (result != 0) {
            return result;
        }
        return o1.getDate(dateField).compareTo(o2.getDate(dateField));
    }

    public static void rankQuoteData(PdsVieContext context) {
        Map quoteData = context.getQuoteData();
        if (quoteData == null || quoteData.size() == 0) {
            return;
        }
        HashMap<String, HashMap<String, Object>> quoteRank = new HashMap<String, HashMap<String, Object>>(8);
        for (Map.Entry entry : quoteData.entrySet()) {
            List<DynamicObject> quoteList = PdsVieHelper.rankQuoteData((List)entry.getValue(), context.getVieBillObj().getString("vietype"), context.getVieBillObj().getString("taxtype"), context.getVieBillObj().getString("decisiontype"));
            int rank = 1;
            for (int i = 0; i < quoteList.size(); ++i) {
                String supplierId = quoteList.get(i).getString("supplier");
                if (quoteList.get(i).getBoolean("isdiscarded")) {
                    quoteRank.put((String)entry.getKey() + '|' + supplierId, PdsVieHelper.createRankMap(0, quoteList.get(0), quoteList.get(i)));
                    continue;
                }
                quoteRank.put((String)entry.getKey() + '|' + supplierId, PdsVieHelper.createRankMap(rank++, quoteList.get(0), quoteList.get(i)));
            }
        }
        context.setQuoteRank(quoteRank);
    }

    public static void rankQuoteDataRedis(PdsVieContext context) {
        Map quoteDataMap = context.getQuoteDataMap();
        if (quoteDataMap == null || quoteDataMap.size() == 0) {
            return;
        }
        String rankCacheKey = PdsVieHelper.getRankCacheKey(context);
        HashMap<String, String> rankCacheMap = new HashMap<String, String>(8);
        for (Map.Entry entry : quoteDataMap.entrySet()) {
            Map quoteMap = null;
            quoteMap = context.getVieBillObj().getString("vietype").equals("A") ? PdsCommonUtils.sortAscend((Map)((Map)entry.getValue())) : PdsCommonUtils.sortDescend((Map)((Map)entry.getValue()));
            int rank = 1;
            String optimalSupplier = null;
            String optimalQuote = null;
            for (Map.Entry supplierEntry : quoteMap.entrySet()) {
                if (optimalSupplier == null) {
                    optimalSupplier = (String)supplierEntry.getKey();
                    optimalQuote = (String)supplierEntry.getValue();
                }
                String key = String.valueOf(context.getProjectId()) + '|' + (String)entry.getKey() + '|' + (String)supplierEntry.getKey();
                rankCacheMap.putAll(PdsVieHelper.getRankResultToCache(key, rank, optimalSupplier, optimalQuote));
                ++rank;
            }
        }
        PdsVieHelper.getInstance().put(rankCacheKey, rankCacheMap);
    }

    public static void setAutoRefreshTimes(IFormView view, int times) {
        CountDown autorefreshCD = (CountDown)view.getControl("autorefresh_cd");
        autorefreshCD.setDuration(times);
    }

    public static void setQuoteFromCache(IDataModel model, String key, int rowIndex) {
        Map quoteCacheMap = PdsVieHelper.getInstance().getAll(key);
        PdsVieHelper.setQuoteByQuoteMap(model, key, rowIndex, quoteCacheMap);
    }

    public static void setQuoteByQuoteMap(IDataModel model, String key, int rowIndex, Map<String, String> quoteCacheMap) {
        String quoteDate;
        String note;
        String currency;
        String taxamount;
        String amount;
        String taxrate;
        String taxitem;
        String taxprice;
        String price;
        String viediffer;
        if (quoteCacheMap == null || quoteCacheMap.size() == 0) {
            return;
        }
        String vieratio = quoteCacheMap.get(key + '|' + "vieratio");
        if (null != vieratio) {
            model.setValue("vieratio", (Object)vieratio, rowIndex);
        }
        if (null != (viediffer = quoteCacheMap.get(key + '|' + "viediffer"))) {
            model.setValue("viediffer", (Object)viediffer, rowIndex);
        }
        if (null != (price = quoteCacheMap.get(key + '|' + "price"))) {
            model.setValue("price", (Object)price, rowIndex);
        }
        if (null != (taxprice = quoteCacheMap.get(key + '|' + "taxprice"))) {
            model.setValue("taxprice", (Object)taxprice, rowIndex);
        }
        if (null != (taxitem = quoteCacheMap.get(key + '|' + "taxitem"))) {
            model.setValue("taxitem", (Object)taxitem, rowIndex);
        }
        if (null != (taxrate = quoteCacheMap.get(key + '|' + "taxrate"))) {
            model.setValue("taxrate", (Object)taxrate, rowIndex);
        }
        if (null != (amount = quoteCacheMap.get(key + '|' + "amount"))) {
            model.setValue("amount", (Object)amount, rowIndex);
        }
        if (null != (taxamount = quoteCacheMap.get(key + '|' + "taxamount"))) {
            model.setValue("taxamount", (Object)taxamount, rowIndex);
        }
        if (null != (currency = quoteCacheMap.get(key + '|' + "currency"))) {
            model.setValue("currency", (Object)currency, rowIndex);
        }
        if (null != (note = quoteCacheMap.get(key + '|' + "note"))) {
            model.setValue("note", (Object)note, rowIndex);
        }
        if ((quoteDate = quoteCacheMap.get(key + '|' + "quotedate")) != null) {
            model.setValue("quotedate", SerializationUtils.fromJsonString((String)quoteDate, Date.class), rowIndex);
        }
    }

    public static void setRestOfTime(PdsVieContext context) {
        String bidStatus = context.getBidStatus();
        CountDown countdown = (CountDown)context.getView().getControl("countdownap");
        if (bidStatus.equals(SrcVieStatusEnums.BIDDING.getValue()) || bidStatus.equals(SrcVieStatusEnums.PAUSED.getValue())) {
            long restOfTime = PdsVieHelper.getRestOfTime(context);
            if (restOfTime <= 0L) {
                context.getView().setVisible(Boolean.FALSE, new String[]{"submit", "import", "export", "attachment"});
                return;
            }
            if (countdown != null) {
                countdown.setDuration((int)(restOfTime / 1000L));
                if (bidStatus.equals(SrcVieStatusEnums.PAUSED.getValue())) {
                    countdown.pause();
                }
            }
        } else if (countdown != null) {
            countdown.setDuration(0);
            countdown.pause();
        }
    }

    public static void setVieParameter(IFormView view) {
        String submitType;
        Object autoSaveTimes;
        Object tndRefreshTimes;
        view.getModel().setValue("vietechscheme", (Object)"1");
        Object srcRefreshTimes = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"srcrefreshtimes");
        if (!Objects.isNull(srcRefreshTimes)) {
            view.getModel().setValue("srcrefreshtimes", srcRefreshTimes);
        }
        if (!Objects.isNull(tndRefreshTimes = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"tndrefreshtimes"))) {
            view.getModel().setValue("tndrefreshtimes", tndRefreshTimes);
        }
        if (!Objects.isNull(autoSaveTimes = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"autosavetimes"))) {
            view.getModel().setValue("autosavetimes", autoSaveTimes);
        }
        if (StringUtils.isBlank((CharSequence)(submitType = view.getModel().getDataEntity().getString("viebill.submittype")))) {
            submitType = PdsCommonUtils.object2String((Object)ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"submittype"), (String)"1");
        }
        view.getModel().setValue("submittype", (Object)submitType);
    }

    public static void updateRedis(PdsVieContext context) {
        Map quoteData = context.getQuoteData();
        if (quoteData == null || quoteData.size() == 0) {
            return;
        }
        for (Map.Entry entry : quoteData.entrySet()) {
            String key = String.valueOf(context.getProjectId()) + '|' + (String)entry.getKey();
            HashMap<String, String> supRankPriceMap = PdsVieHelper.getInstance().getAll(key);
            if (null == supRankPriceMap) {
                supRankPriceMap = new HashMap<String, String>(16);
            }
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                DynamicObject purlistObj = (DynamicObject)((List)entry.getValue()).get(i);
                String supplierId = purlistObj.getString("supplier");
                if (context.getVieBillObj().getString("taxtype").equals("2")) {
                    supRankPriceMap.put(supplierId, purlistObj.getBigDecimal("locprice").toString());
                } else {
                    supRankPriceMap.put(supplierId, purlistObj.getBigDecimal("loctaxprice").toString());
                }
                PdsVieHelper.putLastQuoteToCache(key + '|' + supplierId, purlistObj, Boolean.FALSE);
            }
            PdsVieHelper.getInstance().put(key, supRankPriceMap);
        }
    }

    public static StringBuilder verifyLimitPrice(StringBuilder sb, String taxtype, String tendency, DynamicObject purlistObj, BigDecimal locprice, BigDecimal maxprice, int priceprecision) {
        if (locprice.compareTo(BigDecimal.ZERO) > 0 && maxprice.compareTo(BigDecimal.ZERO) > 0) {
            String symbol = null;
            if ("1".equals(tendency) && locprice.compareTo(maxprice) > 0) {
                symbol = " > ";
            }
            if ("2".equals(tendency) && locprice.compareTo(maxprice) < 0) {
                symbol = " < ";
            }
            if (null != symbol) {
                sb.append(purlistObj.getString("purlistseq"));
                sb.append('-');
                sb.append(purlistObj.getString("materialnane"));
                sb.append(": ");
                sb.append(locprice.setScale(priceprecision, 5));
                sb.append(symbol);
                sb.append(maxprice.setScale(priceprecision, 5));
                sb.append(';');
                sb.append('\n');
            }
        }
        return sb;
    }

    public static StringBuilder verifyTendency(StringBuilder sb, String taxtype, String tendency, DynamicObject purlistObj, BigDecimal hisPrice, BigDecimal price, int priceprecision) {
        if ("1".equals(tendency)) {
            if (price.compareTo(hisPrice) > 0) {
                sb.append(String.format(ResManager.loadKDString((String)"\u884c%1$s %2$s: %3$s > %4$s;", (String)"PdsVieHelper_18", (String)"scm-pds-common", (Object[])new Object[0]), purlistObj.getString("purlistseq"), purlistObj.getString("materialnane"), price.setScale(priceprecision, 5), hisPrice.setScale(priceprecision, 5)));
                sb.append("\n");
            }
        } else if (price.compareTo(hisPrice) < 0) {
            sb.append(String.format(ResManager.loadKDString((String)"\u884c%1$s %2$s: %3$s < %4$s;", (String)"PdsVieHelper_19", (String)"scm-pds-common", (Object[])new Object[0]), purlistObj.getString("purlistseq"), purlistObj.getString("materialnane"), price.setScale(priceprecision, 5), hisPrice.setScale(priceprecision, 5)));
            sb.append("\n");
        }
        return sb;
    }

    public static String getLastQuoteCacheKey(PdsVieContext context) {
        StringBuilder projectCacheKey = new StringBuilder();
        projectCacheKey.append("lastQuotedData_");
        projectCacheKey.append(context.getProjectId());
        projectCacheKey.append("|");
        projectCacheKey.append(context.getTurns());
        return projectCacheKey.toString();
    }

    public static String getRankCacheKey(PdsVieContext context) {
        StringBuilder projectCacheKey = new StringBuilder();
        projectCacheKey.append("lastRankData_");
        projectCacheKey.append(context.getProjectId());
        return projectCacheKey.toString();
    }

    public static String getVieValueField(String viePattern, String taxType) {
        String valueField = null;
        switch (viePattern) {
            case "1": {
                if (taxType.equals("2")) {
                    valueField = "price";
                    break;
                }
                valueField = "taxprice";
                break;
            }
            case "2": {
                valueField = "vieratio";
                break;
            }
            case "3": {
                valueField = "viediffer";
                break;
            }
        }
        return valueField;
    }

    public static String getVieRegionField(String viePattern, String vieType) {
        String regionField = null;
        switch (viePattern) {
            case "1": {
                if (vieType.equals("A")) {
                    regionField = "viefrom";
                    break;
                }
                regionField = "vieto";
                break;
            }
            case "2": {
                regionField = "vieto";
                break;
            }
            case "3": {
                regionField = "vieto";
                break;
            }
        }
        return regionField;
    }

    public static Map<String, String> getViePatternTitle(String viePatternType, String taxType) {
        String viePattern = "";
        String viefrom = "";
        String vieto = "";
        if (viePatternType.equals("2")) {
            viePattern = ResManager.loadKDString((String)"\u6309\u6bd4\u7387%\u7ade\u4ef7", (String)"PdsVieHelper_1", (String)"scm-pds-common", (Object[])new Object[0]);
            viefrom = ResManager.loadKDString((String)"\u6bd4\u7387\u4ece(>)", (String)"PdsVieHelper_2", (String)"scm-pds-common", (Object[])new Object[0]);
            vieto = ResManager.loadKDString((String)"\u6bd4\u7387\u81f3(<)", (String)"PdsVieHelper_3", (String)"scm-pds-common", (Object[])new Object[0]);
        } else if (viePatternType.equals("3")) {
            viePattern = ResManager.loadKDString((String)"\u6309\u4ef7\u5dee\u7ade\u4ef7", (String)"PdsVieHelper_4", (String)"scm-pds-common", (Object[])new Object[0]);
            viefrom = ResManager.loadKDString((String)"\u4ef7\u5dee\u4ece(>)", (String)"PdsVieHelper_5", (String)"scm-pds-common", (Object[])new Object[0]);
            vieto = ResManager.loadKDString((String)"\u4ef7\u5dee\u81f3(<)", (String)"PdsVieHelper_6", (String)"scm-pds-common", (Object[])new Object[0]);
        } else {
            viePattern = ResManager.loadKDString((String)"\u6309\u5355\u4ef7\u7ade\u4ef7", (String)"PdsVieHelper_7", (String)"scm-pds-common", (Object[])new Object[0]);
            if (taxType.equals("2")) {
                viefrom = ResManager.loadKDString((String)"\u672a\u7a0e\u5355\u4ef7\u4ece(>)", (String)"PdsVieHelper_10", (String)"scm-pds-common", (Object[])new Object[0]);
                vieto = ResManager.loadKDString((String)"\u672a\u7a0e\u5355\u4ef7\u81f3(<)", (String)"PdsVieHelper_11", (String)"scm-pds-common", (Object[])new Object[0]);
            } else {
                viefrom = ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7\u4ece(>)", (String)"PdsVieHelper_12", (String)"scm-pds-common", (Object[])new Object[0]);
                vieto = ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7\u81f3(<)", (String)"PdsVieHelper_13", (String)"scm-pds-common", (Object[])new Object[0]);
            }
        }
        HashMap<String, String> vieTitleMap = new HashMap<String, String>(4);
        vieTitleMap.put("viepattern", viePattern);
        vieTitleMap.put("viefrom", viefrom);
        vieTitleMap.put("vieto", vieto);
        return vieTitleMap;
    }

    public static void setBidCount(PdsVieContext context) {
        DynamicObjectCollection lastQuotes;
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId()).and("supplier", "=", (Object)context.getSupplierId());
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj().getDynamicObject("srctype"));
        boolean isBidCountByTurns = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isbidcountbyturns", (Object)true, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj())));
        if (isBidCountByTurns) {
            qfilter.and("vieturns", "=", (Object)context.getVieturns());
        }
        if ((lastQuotes = QueryServiceHelper.query((String)"src_vie_detailf7", (String)"bidcount", (QFilter[])qfilter.toArray(), (String)"quotedate desc", (int)1)) != null && lastQuotes.size() > 0) {
            context.getView().getModel().setValue("bidcount", (Object)((DynamicObject)lastQuotes.get(0)).getInt("bidcount"));
        }
    }

    public static void setRestofBidCount(PdsVieContext context) {
        Label restofbidcount = (Label)context.getView().getControl("restofbidcount");
        int bidCount = context.getVieBillObj().getInt("bidcount");
        if (bidCount == 0) {
            restofbidcount.setText(ResManager.loadKDString((String)"\u4e0d\u9650\u5236", (String)"PdsVieHelper_14", (String)"scm-pds-common", (Object[])new Object[0]));
            return;
        }
        int hasBidCount = 0;
        int restBidcount = Math.max(bidCount - hasBidCount, 0);
        restofbidcount.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\u6b21", (String)"PdsVieHelper_15", (String)"scm-pds-common", (Object[])new Object[0]), restBidcount));
    }

    public static void setRestBidCountByPurlist(PdsVieContext context, Map<String, Integer> hasBidCountMap) {
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        DynamicObjectCollection rows = model.getEntryEntity("entryentity");
        int rowIndex = 0;
        for (DynamicObject row : rows) {
            String key = row.getString("supplier.id") + '_' + row.getString("purlist.id");
            int hasBidCount = null == hasBidCountMap.get(key) ? 0 : hasBidCountMap.get(key);
            int restBidCount = context.getVieBillObj().getInt("bidcount") - hasBidCount;
            model.setValue("restofbidcount2", (Object)(restBidCount > 0 ? restBidCount : 0), rowIndex);
            ++rowIndex;
        }
    }

    public static Set<Long> getAllVieSupplierIdSet(long projectId, String turns) {
        DynamicObjectCollection rows = null;
        if (QuoteTurnsEnums.NEGOTIATE00.getValue().equals(turns)) {
            QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
            rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"suppliertype,supplier.id", (QFilter[])qfilters.toArray());
        } else {
            QFilter qfilters = new QFilter("project", "=", (Object)projectId);
            qfilters.and("turns", "=", (Object)turns);
            rows = QueryServiceHelper.query((String)"tnd_quotebill", (String)"suppliertype,supplier.id", (QFilter[])qfilters.toArray());
        }
        if (null == rows || rows.size() == 0) {
            return null;
        }
        return rows.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
    }

    private static String getSupplierVieKey(PdsVieContext context) {
        return String.valueOf(context.getProjectId()) + '|' + context.getTurns() + '|' + context.getVieturns();
    }

    public static String getSupplierVieOnlineKey(PdsVieContext context) {
        return PdsVieHelper.getSupplierVieKey(context) + '|' + "isonline";
    }

    public static synchronized void setSupplierOnlineStatus(PdsVieContext context, String status, boolean isRefresh) {
        String supplierId = String.valueOf(context.getSupplierId());
        String statusKey = PdsVieHelper.getSupplierVieOnlineKey(context);
        Map<String, String> supplierMap = PdsVieHelper.getAllSupplierOnlinetatusMap(statusKey);
        String newStatus = supplierMap.get(supplierId);
        if ("0".equals(status)) {
            int count;
            if (null == supplierMap || supplierMap.size() == 0 || null == newStatus || "0".equals(newStatus)) {
                return;
            }
            String[] newStatusArray = newStatus.split("\\_");
            newStatus = newStatusArray.length <= 1 ? "0" : ((count = Integer.parseInt(newStatusArray[0]) - 1) <= 0 ? "0" : String.valueOf(count) + '_' + newStatusArray[1]);
        } else if (null == newStatus || "0".equals(newStatus)) {
            newStatus = "1_" + status;
        } else {
            if (isRefresh) {
                return;
            }
            String[] newStatusArray = newStatus.split("\\_");
            if (newStatusArray.length <= 1) {
                newStatus = "1_" + status;
            } else {
                int count = Integer.parseInt(newStatusArray[0]) + 1;
                newStatus = String.valueOf(count) + '_' + status;
            }
        }
        supplierMap.put(supplierId, newStatus);
        PdsVieHelper.getInstance().put(statusKey, supplierMap);
    }

    public static String[] getSupplierOnlineStatus(PdsVieContext context) {
        String statusKey = PdsVieHelper.getSupplierVieOnlineKey(context);
        String[] results = new String[]{"0", ""};
        Map<String, String> supplierMap = PdsVieHelper.getAllSupplierOnlinetatusMap(statusKey);
        String status = supplierMap.get(String.valueOf(context.getSupplierId()));
        if (null == status || "0".equals(status)) {
            return results;
        }
        String[] statusArray = status.split("\\_");
        if (statusArray.length > 1) {
            results[0] = statusArray[0];
            results[1] = statusArray[1];
            return results;
        }
        results[0] = "1";
        results[1] = statusArray[0];
        return results;
    }

    public static Map<String, String> getAllSupplierOnlinetatusMap(String statusKey) {
        HashMap supplierMap = PdsVieHelper.getInstance().getAll(statusKey);
        if (null == supplierMap) {
            supplierMap = new HashMap(16);
        }
        return supplierMap;
    }

    public static String getSupplierVieMessageKey(PdsVieContext context) {
        return PdsVieHelper.getSupplierVieKey(context) + '|' + "message";
    }

    public static void setAllSupplierVieMessage(PdsVieContext context, Set<Long> supplierIds, long bizLogId) {
        if (null == supplierIds || supplierIds.size() == 0) {
            return;
        }
        String messageKey = PdsVieHelper.getSupplierVieMessageKey(context);
        HashMap<String, String> messageMap = PdsVieHelper.getInstance().getAll(messageKey);
        if (null == messageMap) {
            messageMap = new HashMap<String, String>(16);
        }
        for (long supplierId : supplierIds) {
            messageMap.put(String.valueOf(supplierId), String.valueOf(bizLogId));
        }
        PdsVieHelper.getInstance().put(messageKey, messageMap);
    }

    public static synchronized Object getSupplierVieMessage(PdsVieContext context, long supplierId) {
        String messageKey = PdsVieHelper.getSupplierVieMessageKey(context);
        Map messageMap = PdsVieHelper.getInstance().getAll(messageKey);
        if (null == messageMap || messageMap.size() == 0) {
            return null;
        }
        Object bizLogId = messageMap.get(String.valueOf(supplierId));
        messageMap.put(String.valueOf(supplierId), "0");
        PdsVieHelper.getInstance().put(messageKey, messageMap);
        return bizLogId;
    }

    public static Map<String, Integer> getHasBidCountMapByProject(PdsVieContext context) {
        String selectFields = "supplier.id,purlist.project.id,bidcount";
        String orderBy = selectFields + ' ' + "desc";
        DynamicObjectCollection rows = PdsVieHelper.getHasBidCountRows(context, selectFields, orderBy);
        if (rows.size() == 0) {
            return Collections.emptyMap();
        }
        return rows.stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id") + '_' + e.getString("purlist.project.id"), Collectors.collectingAndThen(Collectors.toList(), value -> ((DynamicObject)value.get(0)).getInt("bidcount"))));
    }

    public static Map<String, Integer> getHasBidCountMapByPackage(PdsVieContext context) {
        String selectFields = "supplier.id,purlist.package.id,bidcount";
        String orderBy = selectFields + ' ' + "desc";
        DynamicObjectCollection rows = PdsVieHelper.getHasBidCountRows(context, selectFields, orderBy);
        if (rows.size() == 0) {
            return Collections.emptyMap();
        }
        return rows.stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id") + '_' + e.getString("purlist.package.id"), Collectors.collectingAndThen(Collectors.toList(), value -> ((DynamicObject)value.get(0)).getInt("bidcount"))));
    }

    public static Map<String, Integer> getHasBidCountMapByPurlist(PdsVieContext context) {
        String selectFields = "supplier.id,purlist.id,bidcount";
        String orderBy = selectFields + ' ' + "desc";
        DynamicObjectCollection rows = PdsVieHelper.getHasBidCountRows(context, selectFields, orderBy);
        if (rows.size() == 0) {
            return Collections.emptyMap();
        }
        return rows.stream().collect(Collectors.groupingBy(e -> e.getString("supplier.id") + '_' + e.getString("purlist.id"), Collectors.collectingAndThen(Collectors.toList(), value -> ((DynamicObject)value.get(0)).getInt("bidcount"))));
    }

    public static DynamicObjectCollection getHasBidCountRows(PdsVieContext context, String selectFields, String orderBy) {
        QFilter qfilter = PdsVieHelper.getHasBidCountQFilter(context);
        return QueryServiceHelper.query((String)"src_vie_detailf7", (String)selectFields, (QFilter[])qfilter.toArray(), (String)orderBy);
    }

    public static QFilter getHasBidCountQFilter(PdsVieContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        if (context.getSupplierId() > 0L) {
            qfilter.and("supplier", "=", (Object)context.getSupplierId());
        }
        if (context.isBidCountByTurns()) {
            qfilter.and("vieturns", "=", (Object)context.getVieturns());
        }
        return qfilter;
    }

    public static synchronized void setSupplierCommitData(PdsVieContext context, String status) {
        String commitKey = PdsVieHelper.getSupplierVieKey(context) + '|' + "commit";
        PdsVieHelper.getInstance().put(commitKey, (Object)status);
    }

    public static boolean isSupplierCommitData(PdsVieContext context) {
        String commitKey = PdsVieHelper.getSupplierVieKey(context) + '|' + "commit";
        String status = (String)PdsVieHelper.getInstance().get(commitKey);
        if (null == status || "0".equals(status)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Map<String, String> getMaxPriceField(String decisionType, String taxType) {
        HashMap<String, String> maxPriceFieldMap = new HashMap<String, String>(2);
        if ("2".equals(decisionType)) {
            if (taxType.equals("2")) {
                maxPriceFieldMap.put("fieldid", "maxamount");
                maxPriceFieldMap.put("fieldname", ResManager.loadKDString((String)"\u672a\u7a0e\u8d77\u6807\u91d1\u989d", (String)"PdsVieHelper_20", (String)"scm-pds-common", (Object[])new Object[0]));
            } else {
                maxPriceFieldMap.put("fieldid", "maxtaxamount");
                maxPriceFieldMap.put("fieldname", ResManager.loadKDString((String)"\u542b\u7a0e\u8d77\u6807\u91d1\u989d", (String)"PdsVieHelper_21", (String)"scm-pds-common", (Object[])new Object[0]));
            }
        } else if (taxType.equals("2")) {
            maxPriceFieldMap.put("fieldid", "maxprice");
            maxPriceFieldMap.put("fieldname", ResManager.loadKDString((String)"\u672a\u7a0e\u8d77\u6807\u5355\u4ef7", (String)"PdsVieHelper_22", (String)"scm-pds-common", (Object[])new Object[0]));
        } else {
            maxPriceFieldMap.put("fieldid", "maxtaxprice");
            maxPriceFieldMap.put("fieldname", ResManager.loadKDString((String)"\u542b\u7a0e\u8d77\u6807\u5355\u4ef7", (String)"PdsVieHelper_23", (String)"scm-pds-common", (Object[])new Object[0]));
        }
        return maxPriceFieldMap;
    }

    public static void calcSumAmountAndRank(PdsVieContext context) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(PdsVieSumAndRankHandler.class.getSimpleName(), PdsVieSumAndRankHandler.class.getName());
        for (IPdsVieProcess handler : handlers) {
            handler.process(context);
        }
    }
}

