/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pds.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PdsDbInsertService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PdsDbInsertService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog("start upgrade mallgoods");
            this.upgrade("scm", "pds_flowconfig", "fentryid", "t_pds_flownode", "t_pds_flownode_l", pProcessInfo);
            this.upgrade("scm", "pds_flowconfig", "fdetailid", "t_pds_flownodesub", "t_pds_flownodesub_l", pProcessInfo);
            this.upgrade("scm", "pds_costdetailtpl", "fid", "t_pds_costdetailtpl", "t_pds_costdetailtpl_l", pProcessInfo);
            this.upgrade("scm", "pds_costdetailcomp2", "fdetailid", "t_pds_costdetailsubentry", "t_pds_costdetailsubentry_l", pProcessInfo);
            this.upgrade("scm", "pds_flowconfig", "fid", "t_pds_flowconfig", "t_pds_flowconfig_l", pProcessInfo);
            this.upgrade("scm", "pds_defaultconfig", "fentryid", "t_pds_defaultconfigentry", "t_pds_defaultconfigentry_l", pProcessInfo);
            this.upgrade("scm", "pds_compconfig", "fentryid", "t_pds_compconfigentry", "t_pds_compconfigentry_l", pProcessInfo);
            this.upgrade("scm", "pds_extdata", "fid", "t_pds_extdata", "t_pds_extdata_l", pProcessInfo);
            this.upgrade("scm", "pds_costdetailcomp1", "fentryid", "t_pds_costdetailentry", "t_pds_costdetailentry_l", pProcessInfo);
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            throw new KDBizException(result.getErrorInfo());
        }
        return result;
    }

    public boolean upgrade(String dbKey, String billname, String idFiledName, String srcTableName, String tarTablename, StringBuilder pProcessInfo) {
        int pageSize = 2000;
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select ").append(idFiledName);
        selectSql.append(" from  ").append(srcTableName);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("insert ").append(tarTablename).append(" ( ").append(idFiledName);
        updateSql.append(", FPKID ,FLOCALEID ");
        updateSql.append(" )");
        updateSql.append(" values ( ?,?,? ");
        updateSql.append(" )");
        String selectFromTarSql = "select " + idFiledName + " from  " + tarTablename + " where flocaleid = 'zh_CN'";
        DataSet tarDs = null;
        try (DataSet tmp = this.getDataSet(dbKey, selectFromTarSql);){
            tarDs = tmp.copy();
        }
        HashSet<Long> tarIds = new HashSet<Long>(tarDs.copy().count(idFiledName, true));
        while (tarDs.hasNext()) {
            Row row = tarDs.next();
            long id = row.getLong(idFiledName);
            tarIds.add(id);
        }
        try (DataSet srcDs = this.getDataSet(dbKey, selectSql.toString());){
            int count = srcDs.copy().count(idFiledName, true);
            String[] ids = ID.genStringIds((int)count);
            ArrayList<Object[]> allParamsList = new ArrayList<Object[]>(2048);
            int i = 0;
            while (srcDs.hasNext()) {
                Row row = srcDs.next();
                ArrayList<Object> paramsList = new ArrayList<Object>(3);
                long id = (Long)row.get(idFiledName);
                if (tarIds.contains(id)) continue;
                paramsList.add(id);
                paramsList.add(ids[i]);
                ++i;
                paramsList.add("zh_CN");
                allParamsList.add(paramsList.toArray());
                if (allParamsList.size() <= pageSize) continue;
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
                allParamsList.clear();
            }
            if (allParamsList.size() > 0) {
                this.updateBatch(dbKey, updateSql.toString(), allParamsList);
            }
        }
        return true;
    }

    private void updateBatch(String dbKey, String updateSql, List<Object[]> paramsList) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, paramsList);
    }

    private DataSet getDataSet(String dbKey, String sql) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        return DB.queryDataSet((String)RequestContext.get().getTraceId(), (DBRoute)dbRoute, (String)sql);
    }
}

