/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.opplugin.util.PurReturnUtil;

public class PurReturnUnAuditOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PurReturnUnAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("poentryid");
        e.getFieldKeys().add("pobillid");
        e.getFieldKeys().add("srcbilltype");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcentryid");
        e.getFieldKeys().add("replenishtype");
        e.getFieldKeys().add("basicqty");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] returnDyns = e.getDataEntities();
        if (PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])e.getDataEntities(), (String)"self")) {
            PurReturnUtil.writeBackRefundApplyConfirmStatus((DynamicObject[])returnDyns, (String)"G");
            this.deletTargetBill(returnDyns);
            this.deletCheckRelation(returnDyns);
            PurReturnUtil.writeBackPoSumReturnQty((DynamicObject[])returnDyns, (boolean)false);
        }
    }

    private void deletCheckRelation(DynamicObject[] returnDyns) {
        ArrayList<String> entryIdList = new ArrayList<String>();
        for (DynamicObject dyn : returnDyns) {
            DynamicObjectCollection entryDyns = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryDyn : entryDyns) {
                entryIdList.add(entryDyn.getPkValue().toString());
            }
        }
        QFilter filter = new QFilter("srcentryid", "in", entryIdList);
        DeleteServiceHelper.delete((String)"pur_checkrelation", (QFilter[])new QFilter[]{filter});
        log.info("\u5220\u9664\u5bf9\u8d26\u5173\u7cfbsrcentryid:" + entryIdList);
    }

    private void deletTargetBill(DynamicObject[] returnDyns) {
        ArrayList<Long> billIds = new ArrayList<Long>(returnDyns.length);
        for (DynamicObject dyn : returnDyns) {
            billIds.add((Long)dyn.getPkValue());
        }
        Map linkBills = BFTrackerServiceHelper.findTargetBills((String)"scp_return", (Long[])billIds.toArray(new Long[billIds.size()]));
        Set targetIdSet = (Set)linkBills.get("scp_salreturn");
        if (null != targetIdSet && targetIdSet.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"scp_salreturn", (Object[])targetIdSet.toArray(), (OperateOption)option);
            if (unAuditResult.isSuccess()) {
                OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"scp_salreturn", (Object[])targetIdSet.toArray(), (OperateOption)option);
                if (!deleteResult.isSuccess()) {
                    log.error("@@\u5220\u9664\u76ee\u6807\u5355\u9500\u552e\u9000\u8d27\u5931\u8d25\uff1a" + ExceptionUtil.getErrorInfoDetails((List)deleteResult.getAllErrorOrValidateInfo()));
                    throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)deleteResult.getAllErrorOrValidateInfo()));
                }
            } else {
                log.error("\u53cd\u5ba1\u6838\u9500\u552e\u9000\u8d27\u5355\u5931\u8d25\uff1a" + ExceptionUtil.getErrorInfoDetails((List)unAuditResult.getAllErrorOrValidateInfo()));
                throw new KDBizException(ExceptionUtil.getErrorInfoDetails((List)unAuditResult.getAllErrorOrValidateInfo()));
            }
            log.info("\u5220\u9664\u9500\u552e\u9000\u8d27\u5355\uff1a" + targetIdSet);
        }
    }
}

