/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.blueprintshare.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.scm.pur.common.blueprintshare.support.plmservice.IPLMRequestService;
import kd.scm.pur.common.blueprintshare.support.plmservice.impl.K3cloudPLMRequestService;

public class PurBluePrintAttachmentSupport {
    private static final Log log = LogFactory.getLog(PurBluePrintAttachmentSupport.class);
    private final IPLMRequestService plmRequestService = new K3cloudPLMRequestService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAttachmentAndBind(Object pkValue, String documentName, String documentIds) throws Exception {
        log.info("\u83b7\u53d6\u661f\u7a7a\u9644\u4ef6\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u5e76\u7ed1\u5b9a\u5230\u5355\u636e\u4e0a,pkValue {}, documentName {} , documentIds {}", new Object[]{pkValue, documentName, documentIds});
        String[] documentIdArr = documentIds.split(" , ");
        String[] documentNameArr = documentName.split(" , ");
        for (int i = 0; i < documentIdArr.length; ++i) {
            try (InputStream is = null;){
                String id = documentIdArr[i];
                String name = documentNameArr[i];
                is = this.plmRequestService.getFileInputStream(id);
                String fileUrl = this.saveInputStreamToTempFile(is, name);
                log.info("\u8bbf\u95ee\u661f\u7a7a\u7535\u5b50\u4ed3\u83b7\u53d6\u6587\u4ef6\u6d41\uff0c\u8f6c\u6362\u4e3a\u4e34\u65f6url\uff1a{}", (Object)fileUrl);
                this.saveUrlFile2AttachmentAndBind("pur_blueprint_share", pkValue, fileUrl, name, "10", "attachmentpanelap");
                log.info("\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u5e76\u7ed1\u5b9a\u5355\u636e\u6210\u529f\uff01pkValue: {} documentName: {} documentIds: {}", new Object[]{pkValue, documentName, documentIds});
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUrlFile2AttachmentAndBind(String entity, Object pk, String fileUrl, String fileName, String fileSize, String attachKey) throws Exception {
        ArrayList attachments = new ArrayList();
        HashMap<String, Object> attachItem = new HashMap<String, Object>();
        attachItem.put("name", fileName);
        InputStream inputStream = null;
        URLConnection conn = null;
        String tempUrl = null;
        try {
            URL url = new URL(fileUrl);
            conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                httpConn.setConnectTimeout(3000);
                httpConn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
                inputStream = httpConn.getInputStream();
            } else {
                inputStream = url.openStream();
            }
            attachItem.put("size", fileSize);
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            tempUrl = conn instanceof HttpURLConnection ? cache.saveAsFullUrl((String)attachItem.get("name"), inputStream, 600) : cache.saveAsUrl((String)attachItem.get("name"), inputStream, 600);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25" + e.getMessage());
            }
        }
        log.info("\u5c06\u6587\u4ef6\u6d41\u5b58\u5165\u4e34\u65f6\u6587\u4ef6\u7f13\u5b58\u6210\u529f\u3002");
        attachItem.put("lastModified", System.currentTimeMillis());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
        String appId = dataEntityType.getAppId();
        String actUrl = AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)appId, (String)entity, (Object)pk, (String)((String)attachItem.get("name")));
        log.info("\u9644\u4ef6\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u6210\u529f\u3002");
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream in = cache.getInputStream(tempUrl);
        RequestContext requestContext = RequestContext.get();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)uuid, (String)fileName);
        FileItem fileItem = new FileItem(fileName, pathParam, in);
        FileService service = FileServiceFactory.getAttachmentFileService();
        String downUrl = service.upload(fileItem);
        attachItem.put("url", actUrl);
        attachments.add(attachItem);
        AttachmentServiceHelper.upload((String)entity, (Object)pk, (String)attachKey, attachments);
        log.info("\u5355\u636e\u7ed1\u5b9a\u9644\u4ef6\u6210\u529f\u3002");
    }

    public String saveInputStreamToTempFile(InputStream inputStream, String fileName) throws Exception {
        String tempFileName = "tempfile_" + System.currentTimeMillis();
        File tempFile = File.createTempFile(tempFileName, ".tmp");
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        return tempFile.toURI().toURL().toString();
    }
}

